/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ACUFilePointer;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.smartFile;
import java.io.File;

public class ACUFile {
    public static final boolean debugMode = false;
    public static final int MAX_KEYS = 120;
    public static final int MAX_KEY_SIZE = 250;
    public static final int MAX_SEGS = 16;
    protected smartFile dataFile = new smartFile();
    protected smartFile keyFile = new smartFile();
    protected int nodeSize = 0;
    protected int numberOfKeys = 0;
    protected String filename = null;
    protected boolean dataFileWasDeclared = false;
    protected int recordFrom = -1;
    protected int recordTo = -1;
    protected Variable dependingOn = null;
    protected int newModes = 0;
    protected int[] keyLengths = null;
    protected boolean[] keyDuplicatesAllowed = null;
    protected Object[] keyStartLocations = null;
    protected int[] keyOffsets = null;
    protected Variable[] keyArray = null;
    protected Variable masterRecord = null;
    protected boolean isOpen = false;
    protected boolean readable = false;
    protected boolean writable = false;
    protected boolean extend = false;
    protected boolean fileAlreadyExists = false;
    private int status = 0;
    protected byte[] keyFileHeader = null;
    protected byte[] dataFileHeader = null;
    protected LockRecord dataLockRecord = null;
    protected LockRecord idxLockRecord = null;
    protected int maxKeyLength = 0;
    protected int keyDuplicateCount = 0;
    protected int preallocateAmount = 1;
    protected int extendAmount = 1;
    protected long endOfDataRecordsIndex = 0L;
    protected long startOfDataDeletedRecords = 0L;
    protected long currentRecordID = 0L;
    protected long startOfKeyDeletedRecords = 0L;
    protected long numberOfDataRecords = 0L;
    protected long numberOfDeletedDataRecords = 0L;
    protected int numberOfKeyRecords = 0;
    protected int numberOfDeletedKeyRecords = 0;
    protected long totalNodeSpaceUsed = 0L;
    protected long originalNumberOfTransactions = 0L;
    protected long originalNumberOfSplitsAndRedistributes = 0L;

    public static void debug(String text) {
        Utilities.debugOutput("ACUFile: " + text);
    }

    public ACUFile(int nodeSize, int numberOfKeys, int recordFrom, int recordTo, Variable dependingOn, int keyCompression, int dataCompression, int idxFormat, int[] keyLengths, boolean[] keyDuplicatesAllowed, Object[] keyStartLocations, int[] keyOffsets, Variable[] keyArray, Variable masterRecord, int newModes, LockRecord dataLockRecord, LockRecord idxLockRecord) {
        this.nodeSize = nodeSize;
        this.numberOfKeys = numberOfKeys;
        this.dataFileWasDeclared = false;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        this.keyLengths = keyLengths;
        this.keyDuplicatesAllowed = keyDuplicatesAllowed;
        this.keyStartLocations = keyStartLocations;
        this.keyOffsets = keyOffsets;
        this.keyArray = keyArray;
        this.masterRecord = masterRecord;
        this.newModes = newModes;
        this.dataLockRecord = dataLockRecord;
        this.idxLockRecord = idxLockRecord;
        dataLockRecord.setFileObject(this.dataFile);
        idxLockRecord.setFileObject(this.keyFile);
        if (keyLengths != null) {
            this.maxKeyLength = 0;
            this.keyDuplicateCount = 0;
            for (int i = 0; i < keyLengths.length; ++i) {
                int len = keyLengths[i];
                if (len > this.maxKeyLength) {
                    this.maxKeyLength = len;
                }
                if (!keyDuplicatesAllowed[i]) continue;
                ++this.keyDuplicateCount;
            }
        }
        this.extendAmount = 1 + recordTo / nodeSize;
    }

    protected void warning(String method, String text) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("ACUFile." + method + ": " + text);
        }
    }

    public boolean deleteFile() {
        String name = this.filename;
        if (name == null) {
            return false;
        }
        File f = new File(name);
        boolean flag = false;
        try {
            flag = f.exists() ? f.delete() : true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!flag) {
            return false;
        }
        if (name.endsWith(".dat")) {
            name = name.substring(0, name.length() - 4);
        }
        name = name + ".vix";
        f = new File(name);
        flag = false;
        try {
            flag = f.exists() ? f.delete() : true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return flag;
    }

    private String stripExtension(String filename) {
        if (filename == null) {
            return "";
        }
        int index = filename.lastIndexOf(46);
        if (index < 0) {
            return filename;
        }
        try {
            return filename.substring(0, index);
        }
        catch (Exception e) {
            return filename;
        }
    }

    public int setFilename(String filename) {
        if (filename.endsWith(".vix")) {
            return -90004;
        }
        this.filename = filename;
        if (!this.dataFileWasDeclared) {
            int status = this.declareDataFile();
            if (status < 0) {
                return status;
            }
        } else {
            this.dataFile.setFilename(filename);
        }
        String keyFilename = filename;
        this.keyFile.setFilename(this.stripExtension(keyFilename) + ".vix");
        return 0;
    }

    private int declareDataFile() {
        this.dataFile.setFilename(this.filename);
        this.dataFileWasDeclared = true;
        return 0;
    }

    public int open(int mode) {
        this.iostatus(0);
        this.readable = (mode & 1) != 0;
        this.writable = (mode & 2) != 0;
        if ((mode & 4) != 0) {
            this.writable = true;
            this.extend = true;
        } else {
            this.extend = false;
        }
        int openReturnCode = this.keyFile.open(mode);
        this.iostatus(openReturnCode);
        if (openReturnCode > -10) {
            int returnCode;
            boolean flag;
            if (this.dataLockRecord != null) {
                this.dataLockRecord.open(this.filename, mode & 0x16000);
            }
            if (this.idxLockRecord != null) {
                this.idxLockRecord.open(this.keyFile.getFilename(), mode & 0x16000 | 0x10000);
            }
            boolean bl = this.fileAlreadyExists = !this.keyFile.isNewFile();
            if (!this.fileAlreadyExists) {
                String name = this.filename;
                File f = new File(name);
                boolean flag2 = false;
                try {
                    flag2 = f.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            boolean bl2 = flag = (returnCode = this.dataFile.open(mode)) > -10;
            if (!flag) {
                this.iostatus(returnCode);
                try {
                    this.keyFile.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.dataLockRecord != null) {
                    this.dataLockRecord.close();
                }
                if (this.idxLockRecord != null) {
                    this.idxLockRecord.close();
                }
                return returnCode;
            }
            if (this.fileAlreadyExists) {
                if (this.dataFile.isNewFile()) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return -90043;
                }
                returnCode = this.readHeaderInformation();
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
                this.originalNumberOfTransactions = this.getNumberOfTransactions();
                this.originalNumberOfSplitsAndRedistributes = this.getSplitAndRedistributeTotal();
                if (this.isWritable()) {
                    this.increaseUserCount();
                }
            } else {
                if (!this.isWritable()) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return openReturnCode;
                }
                if (!this.dataFile.isNewFile()) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return -90043;
                }
                this.keyFileHeader = null;
                this.dataFileHeader = null;
                returnCode = this.writeHeaderInformation();
                this.iostatus(returnCode);
                if (returnCode < 0) {
                    try {
                        this.dataFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.keyFile.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.dataLockRecord != null) {
                        this.dataLockRecord.close();
                    }
                    if (this.idxLockRecord != null) {
                        this.idxLockRecord.close();
                    }
                    return returnCode;
                }
                this.originalNumberOfTransactions = 0L;
                this.originalNumberOfSplitsAndRedistributes = 0L;
                this.increaseUserCount();
            }
            this.isOpen = true;
            if (this.fileAlreadyExists) {
                // empty if block
            }
        }
        return openReturnCode;
    }

    public final int close(int mode) {
        if (this.isWritable()) {
            this.decreaseUserCount();
        }
        int returnCode = 0;
        this.isOpen = false;
        returnCode = this.dataFile.close(mode);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.close(mode);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        if (this.dataLockRecord != null) {
            this.dataLockRecord.close();
        }
        if (this.idxLockRecord != null) {
            this.idxLockRecord.close();
        }
        this.fileAlreadyExists = false;
        return returnCode;
    }

    public final int close() {
        return this.close(0);
    }

    private int increaseUserCount() {
        long userCount = this.getUserCount() + 1L;
        this.setUserCount(userCount);
        int returnCode = this.dataFile.seek(76L);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.write(this.dataFileHeader, 76, 4);
        return returnCode;
    }

    private int decreaseUserCount() {
        long userCount = this.getUserCount() - 1L;
        this.setUserCount(userCount);
        int returnCode = this.dataFile.seek(76L);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.write(this.dataFileHeader, 76, 4);
        return returnCode;
    }

    private int readHeaderInformation() {
        int returnCode = 0;
        if (this.keyFileHeader == null) {
            this.keyFileHeader = new byte[this.nodeSize];
            int dfhSize = 160 + 59 * this.numberOfKeys;
            dfhSize = this.nodeSize * (int)Math.ceil((double)dfhSize / (double)this.nodeSize);
            this.dataFileHeader = new byte[dfhSize];
        }
        returnCode = this.keyFile.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.read(this.keyFileHeader, 0, this.nodeSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.read(this.dataFileHeader, 0, this.dataFileHeader.length, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        this.extendAmount = this.getNumberOfBlocksToExtend();
        this.endOfDataRecordsIndex = this.getDataFileEndOfLastRecordPosition();
        this.startOfDataDeletedRecords = this.getDataFileDeletedRecordsPosition();
        this.currentRecordID = this.getDataFileNextRecordID();
        this.startOfKeyDeletedRecords = this.getKeyFileDeletedRecordsPosition();
        this.numberOfDataRecords = this.getDataFileNumberOfRecords();
        this.numberOfDeletedDataRecords = this.getDataFileNumberOfDeletedRecords();
        this.numberOfKeyRecords = this.getKeyFileNumberOfRecords();
        this.numberOfDeletedKeyRecords = this.getKeyFileNumberOfDeletedRecords();
        this.totalNodeSpaceUsed = this.getKeyFileTotalNodeSpaceUsed();
        return 0;
    }

    private int writeHeaderInformation() {
        int returnCode = 0;
        if (!this.isWritable()) {
            return 0;
        }
        boolean isNewFile = false;
        if (this.keyFileHeader == null) {
            isNewFile = true;
            this.keyFileHeader = new byte[this.nodeSize];
            int dfhSize = 160 + 59 * this.numberOfKeys;
            dfhSize = this.nodeSize * (int)Math.ceil((double)dfhSize / (double)this.nodeSize);
            this.dataFileHeader = new byte[dfhSize];
            this.setKeyFileID();
            this.setKeyFileMajorVersion();
            this.setKeyFileMinorVersion();
            this.setKeyFileEndOfFilePosition(this.nodeSize * this.preallocateAmount);
            this.setKeyFileNextBlockAllocationPosition(this.nodeSize);
            this.setDataFileID();
            this.setDataFileMajorVersion();
            this.setDataFileMinorVersion();
            this.setBlockingFactor(this.nodeSize == 512 ? 1 : 2);
            this.setNumberOfBlocksToPreallocate(this.preallocateAmount);
            this.setNumberOfBlocksToExtend(this.extendAmount);
            long eofData = this.nodeSize * this.preallocateAmount;
            if (eofData < (long)dfhSize) {
                eofData = dfhSize;
            }
            this.setDataFileEndOfFilePosition(eofData);
            this.setDataFileNextBlockAllocationPosition(dfhSize);
            this.endOfDataRecordsIndex = 0L;
            this.startOfDataDeletedRecords = 0L;
            this.currentRecordID = 0L;
            this.startOfKeyDeletedRecords = 0L;
            this.numberOfDataRecords = 0L;
            this.numberOfDeletedDataRecords = 0L;
            this.numberOfKeyRecords = 0;
            this.numberOfDeletedKeyRecords = 0;
            this.totalNodeSpaceUsed = 0L;
            this.setHeaderSizeForDataRecord(this.keyDuplicateCount > 0 ? 8 : 4);
            this.setTotalNumberOfKeysThatAllowDuplicates(this.keyDuplicateCount);
            this.setFileSegmentSize();
            this.setMaximumRecordSize(this.recordTo);
            this.setMinimumRecordSize(this.recordFrom);
            this.setComment("Generated using Elastic COBOL");
            this.createKeyHeaderInformation();
        }
        returnCode = this.keyFile.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.write(this.keyFileHeader);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.seek(0L);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.write(this.dataFileHeader);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        if (isNewFile) {
            long keof = this.getKeyFileEndOfFilePosition();
            long deof = this.getDataFileEndOfFilePosition();
            int kdelta = (int)(keof - (long)this.keyFileHeader.length);
            int ddelta = (int)(deof - (long)this.dataFileHeader.length);
            int max = kdelta;
            if (ddelta > kdelta) {
                max = ddelta;
            }
            byte[] temp = new byte[max];
            if (max > 0) {
                if (kdelta > 0) {
                    returnCode = this.keyFile.write(temp, 0, kdelta);
                    this.iostatus(returnCode);
                    if (returnCode < 0) {
                        return returnCode;
                    }
                }
                if (ddelta > 0) {
                    returnCode = this.dataFile.write(temp, 0, ddelta);
                    this.iostatus(returnCode);
                    if (returnCode < 0) {
                        return returnCode;
                    }
                }
            }
        }
        return 0;
    }

    public boolean checkHeaderInformation() {
        if (this.getKeyFileMajorVersion() != 4) {
            return false;
        }
        if (this.getKeyFileMinorVersion() != 0) {
            return false;
        }
        if (this.getDataFileMajorVersion() != 4) {
            return false;
        }
        if (this.getDataFileMinorVersion() != 0) {
            return false;
        }
        return this.checkKeyInformation();
    }

    public ACUFilePointer getKeyStartLocation(int keyIndex) {
        long loc = this.getRootNode(keyIndex);
        ACUFilePointer location = new ACUFilePointer(loc);
        if (this.keyStartLocations != null) {
            this.keyStartLocations[keyIndex] = location;
        }
        return location;
    }

    private void updateKeyStartLocationsAndTreeHeights(Object[] keyStartLocations, int[] treeHeight) {
        int offset = 160;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (i == 5) {
                offset = 512;
            }
            ACUFile.setBytesFromInt(this.dataFileHeader, offset, ((ACUFilePointer)keyStartLocations[i]).getRecordKey());
            this.dataFileHeader[offset + 6] = (byte)treeHeight[i];
            offset += 59;
        }
    }

    public int updateHeaderInformation(Object[] keyStartLocations, int[] treeHeight, long numberOfTransactions, long numberOfSplitsAndRedistributes) {
        if (!this.isWritable() || this.keyFileHeader == null) {
            return 0;
        }
        this.keyStartLocations = keyStartLocations;
        this.updateKeyStartLocationsAndTreeHeights(keyStartLocations, treeHeight);
        this.setDataFileEndOfLastRecordPosition(this.endOfDataRecordsIndex);
        this.setDataFileDeletedRecordsPosition(this.startOfDataDeletedRecords);
        this.setDataFileNextRecordID(this.currentRecordID);
        this.setKeyFileDeletedRecordsPosition(this.startOfKeyDeletedRecords);
        this.setDataFileNumberOfRecords(this.numberOfDataRecords);
        this.setDataFileNumberOfDeletedRecords(this.numberOfDeletedDataRecords);
        this.setKeyFileNumberOfRecords(this.numberOfKeyRecords);
        this.setKeyFileNumberOfDeletedRecords(this.numberOfDeletedKeyRecords);
        this.setKeyFileTotalNodeSpaceUsed(this.totalNodeSpaceUsed);
        this.setNumberOfTransactions(this.originalNumberOfTransactions + numberOfTransactions);
        long tot = this.originalNumberOfSplitsAndRedistributes + numberOfSplitsAndRedistributes;
        if (tot == 0L && this.totalNodeSpaceUsed > 0L) {
            tot = 1L;
        }
        this.setSplitAndRedistributeTotal(tot);
        return this.writeHeaderInformation();
    }

    public final byte[] getKeyRecord(long recordKey) {
        int returnCode = this.seekToKeyRecord(recordKey);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            return null;
        }
        byte[] recordBytes = new byte[this.nodeSize];
        returnCode = this.keyFile.read(recordBytes, 0, this.nodeSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        return recordBytes;
    }

    public final long addKeyRecord(byte[] bytes) {
        return this.addKeyRecord(bytes, 0, bytes.length);
    }

    public final long addKeyRecord(byte[] bytes, int offset, int length) {
        if (!this.isWritable()) {
            this.warning("addKeyRecord", "write operation on file not open for output");
            return -48L;
        }
        if (this.startOfKeyDeletedRecords == 0L) {
            return this.allocateKeyRecordFromEndOfFile(bytes, offset, length);
        }
        byte[] freeBytes = this.getKeyRecord(this.startOfKeyDeletedRecords);
        if (freeBytes == null) {
            return -1L;
        }
        long recKey = this.startOfKeyDeletedRecords;
        this.startOfKeyDeletedRecords = ACUFile.getIntFromBytes(freeBytes, 1);
        int returnCode = this.updateKeyRecord(recKey, bytes, offset, length);
        if (returnCode < 0) {
            return -1L;
        }
        ++this.numberOfKeyRecords;
        --this.numberOfDeletedKeyRecords;
        int tot = ACUFile.getShortFromBytes(bytes, offset + 1);
        this.totalNodeSpaceUsed += (long)tot;
        return recKey;
    }

    public final int deleteKeyRecord(long recordKey) {
        int headerSize = 5;
        byte[] header = new byte[headerSize];
        int returnCode = this.keyFile.seek(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.read(header, 0, headerSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        int tot = ACUFile.getShortFromBytes(header, 1);
        this.totalNodeSpaceUsed -= (long)tot;
        header[0] = 3;
        ACUFile.setBytesFromInt(header, 1, this.startOfKeyDeletedRecords);
        this.startOfKeyDeletedRecords = recordKey;
        returnCode = this.keyFile.seek(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.write(header, 0, headerSize);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        --this.numberOfKeyRecords;
        ++this.numberOfDeletedKeyRecords;
        return returnCode;
    }

    public final int updateKeyRecord(long recordKey, byte[] bytes) {
        return this.updateKeyRecord(recordKey, bytes, 0, bytes.length);
    }

    public final int updateKeyRecord(long recordKey, byte[] bytes, int offset, int length) {
        if (bytes == null) {
            this.warning("updateKeyRecord", "internal error");
            return -30;
        }
        if (!this.isWritable()) {
            this.warning("updateKeyRecord", "write operation on file not open for output");
            return -48;
        }
        int headerSize = 5;
        byte[] header = new byte[headerSize];
        int returnCode = this.seekToKeyRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.read(header, 0, headerSize, true);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        int tot = ACUFile.getShortFromBytes(header, 1);
        this.totalNodeSpaceUsed -= (long)tot;
        returnCode = this.seekToKeyRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.keyFile.write(bytes, offset, length);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        tot = ACUFile.getShortFromBytes(bytes, offset + 1);
        this.totalNodeSpaceUsed += (long)tot;
        return returnCode;
    }

    public final byte[] getDataRecord(long recordKey) {
        int returnCode = this.seekToDataRecord(recordKey);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            return null;
        }
        int headerSize = 4;
        if (this.keyDuplicateCount > 0) {
            headerSize += 4;
        }
        byte[] headerBytes = new byte[headerSize];
        returnCode = this.dataFile.read(headerBytes, 0, headerSize);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        int dataSize = ACUFile.getShortFromBytes(headerBytes, 2);
        if (dataSize <= 0) {
            return null;
        }
        byte[] recordBytes = new byte[dataSize];
        returnCode = this.dataFile.read(recordBytes, 0, dataSize);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        return recordBytes;
    }

    public long addDataRecord(byte[] bytes) {
        return this.addDataRecord(bytes, 0, bytes.length);
    }

    public long addDataRecord(byte[] bytes, int offset, int length) {
        if (!this.isWritable()) {
            this.warning("addDataRecord", "write operation on file not open for output");
            return -48L;
        }
        if (this.startOfDataDeletedRecords == 0L) {
            return this.allocateDataRecordFromEndOfFile(bytes, offset, length);
        }
        byte[] freeBytes = this.getFullDataRecord(this.startOfDataDeletedRecords);
        if (freeBytes == null) {
            return -1L;
        }
        long recKey = this.startOfDataDeletedRecords;
        this.startOfDataDeletedRecords = ACUFile.getIntFromBytes(freeBytes, 4);
        int returnCode = this.updateDataRecord(recKey, bytes, offset, length, true);
        if (returnCode < 0) {
            return -1L;
        }
        ++this.numberOfDataRecords;
        --this.numberOfDeletedDataRecords;
        return recKey;
    }

    public int deleteDataRecord(long recordKey) {
        int returnCode = this.dataFile.seek(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        int headerSize = 10;
        if (this.keyDuplicateCount > 0) {
            headerSize += 4;
        }
        byte[] header = new byte[headerSize];
        int max = this.recordTo;
        if (max < 6) {
            max = 6;
        }
        ACUFile.setBytesFromShort(header, 0, max);
        ACUFile.setBytesFromShort(header, 2, 0);
        ACUFile.setBytesFromInt(header, 4, this.startOfDataDeletedRecords);
        if (this.keyDuplicateCount > 0) {
            ACUFile.setBytesFromInt(header, 8, this.startOfDataDeletedRecords);
            ACUFile.setBytesFromShort(header, 12, 0);
        } else {
            ACUFile.setBytesFromShort(header, 8, 0);
        }
        this.startOfDataDeletedRecords = recordKey;
        returnCode = this.dataFile.write(header, 0, headerSize);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        --this.numberOfDataRecords;
        ++this.numberOfDeletedDataRecords;
        return returnCode;
    }

    public final int updateDataRecord(long recordKey, byte[] bytes) {
        return this.updateDataRecord(recordKey, bytes, 0, bytes.length, false);
    }

    public final int updateDataRecord(long recordKey, byte[] bytes, int offset, int length) {
        return this.updateDataRecord(recordKey, bytes, offset, length, false);
    }

    private int seekToKeyRecord(long recordKey) {
        long endOfFilePosition = this.getKeyFileEndOfFilePosition();
        if (recordKey < 0L || recordKey > endOfFilePosition) {
            int returnCode = -90;
            this.iostatus(-90);
            this.warning("seekToKeyRecord", "internal error");
            return returnCode;
        }
        int returnCode = this.keyFile.seek(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        return 0;
    }

    private int allocateNewKeyBlocks(long location) {
        long eof = this.getKeyFileEndOfFilePosition();
        if (location < eof) {
            this.setKeyFileNextBlockAllocationPosition(location + (long)this.nodeSize);
            return 0;
        }
        int returnCode = this.keyFile.seek(eof);
        if (returnCode < 0) {
            return -1;
        }
        int amount = this.nodeSize;
        byte[] bytes = new byte[amount];
        returnCode = this.keyFile.write(bytes, 0, amount);
        if (returnCode < 0) {
            return -1;
        }
        this.setKeyFileEndOfFilePosition(eof += (long)amount);
        this.setKeyFileNextBlockAllocationPosition(location + (long)this.nodeSize);
        return 0;
    }

    private long allocateKeyRecordFromEndOfFile(byte[] bytes) {
        return this.allocateKeyRecordFromEndOfFile(bytes, 0, bytes.length);
    }

    private long allocateKeyRecordFromEndOfFile(byte[] bytes, int offset, int length) {
        int returnCode;
        long eof = this.getKeyFileEndOfFilePosition();
        long bof = this.getKeyFileNextBlockAllocationPosition();
        if (bof + (long)this.nodeSize > eof) {
            returnCode = this.allocateNewKeyBlocks(bof);
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return -1L;
            }
        }
        returnCode = this.keyFile.seek(bof);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return -1L;
        }
        long recKey = bof;
        returnCode = this.keyFile.write(bytes, offset, length);
        if (returnCode < 0) {
            return -1L;
        }
        ++this.numberOfKeyRecords;
        int tot = ACUFile.getShortFromBytes(bytes, offset + 1);
        this.totalNodeSpaceUsed += (long)tot;
        return recKey;
    }

    private int seekToDataRecord(long recordKey) {
        long endOfFilePosition = this.getDataFileEndOfFilePosition();
        if (recordKey < 0L || recordKey > endOfFilePosition) {
            int returnCode = -90;
            this.iostatus(-90);
            this.warning("seekToDataRecord", "internal error");
            return returnCode;
        }
        int returnCode = this.dataFile.seek(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        return 0;
    }

    private final byte[] getFullDataRecord(long recordKey) {
        int returnCode = this.seekToDataRecord(recordKey);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            return null;
        }
        int max = this.recordTo;
        if (max < 6) {
            max = 6;
        }
        int headerSize = 4;
        if (this.keyDuplicateCount > 0) {
            headerSize += 4;
        }
        byte[] recordBytes = new byte[max + headerSize];
        returnCode = this.dataFile.read(recordBytes, 0, max + headerSize);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return null;
        }
        return recordBytes;
    }

    private int writeDataRecordHeader(int max, int length) {
        int headerSize = 4;
        if (this.keyDuplicateCount > 0) {
            headerSize = 8;
        }
        byte[] bytes = new byte[headerSize];
        ACUFile.setBytesFromShort(bytes, 0, max);
        ACUFile.setBytesFromShort(bytes, 2, length);
        if (this.keyDuplicateCount > 0) {
            ACUFile.setBytesFromInt(bytes, 4, this.currentRecordID);
        }
        return this.dataFile.write(bytes, 0, headerSize);
    }

    private int allocateNewDataBlocks(long location, int size) {
        long eof = this.getDataFileEndOfFilePosition();
        if (location + (long)size < eof) {
            this.setDataFileNextBlockAllocationPosition(location + (long)(this.nodeSize * (1 + size / this.nodeSize)));
            return 0;
        }
        int returnCode = this.dataFile.seek(eof);
        if (returnCode < 0) {
            return -1;
        }
        int amount = this.nodeSize * this.extendAmount;
        byte[] bytes = new byte[amount];
        returnCode = this.dataFile.write(bytes, 0, amount);
        if (returnCode < 0) {
            return -1;
        }
        this.setDataFileEndOfFilePosition(eof += (long)amount);
        this.setDataFileNextBlockAllocationPosition(location + (long)this.nodeSize);
        return 0;
    }

    private long allocateDataRecordFromEndOfFile(byte[] bytes) {
        return this.allocateDataRecordFromEndOfFile(bytes, 0, bytes.length);
    }

    private long allocateDataRecordFromEndOfFile(byte[] bytes, int offset, int length) {
        int returnCode;
        int max = this.recordTo;
        if (max < 6) {
            max = 6;
        }
        int headerSize = 4;
        if (this.keyDuplicateCount > 0) {
            headerSize = 8;
        }
        long eof = this.getDataFileNextBlockAllocationPosition();
        if (this.endOfDataRecordsIndex == 0L) {
            this.endOfDataRecordsIndex = eof;
            this.setDataFileFirstRecordPosition(this.endOfDataRecordsIndex);
        }
        if (this.endOfDataRecordsIndex + (long)max + (long)headerSize > eof) {
            returnCode = this.allocateNewDataBlocks(eof, (int)(this.endOfDataRecordsIndex + (long)max + (long)headerSize - eof));
            this.iostatus(returnCode);
            if (returnCode < 0) {
                return -1L;
            }
        }
        returnCode = this.dataFile.seek(this.endOfDataRecordsIndex);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return -1L;
        }
        long recKey = this.endOfDataRecordsIndex;
        returnCode = this.writeDataRecordHeader(max, length);
        if (returnCode < 0) {
            return -1L;
        }
        if (length == max) {
            returnCode = this.dataFile.write(bytes, offset, length);
        } else {
            byte[] maxBytes = new byte[max];
            System.arraycopy(bytes, offset, maxBytes, 0, max);
            returnCode = this.dataFile.write(maxBytes, 0, max);
        }
        if (returnCode < 0) {
            return -1L;
        }
        this.endOfDataRecordsIndex = this.dataFile.getFilePointer();
        ++this.numberOfDataRecords;
        return recKey;
    }

    private final int updateFullDataRecord(long recordKey, byte[] bytes) {
        return this.updateFullDataRecord(recordKey, bytes, 0, bytes.length);
    }

    private final int updateFullDataRecord(long recordKey, byte[] bytes, int offset, int length) {
        if (bytes == null) {
            this.warning("updateFullDataRecord", "internal error");
            return -30;
        }
        if (!this.isWritable()) {
            this.warning("updateFullDataRecord", "write operation on file not open for output");
            return -48;
        }
        int returnCode = this.seekToDataRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.write(bytes, offset, length);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        long currentDataFileIndex = this.dataFile.getFilePointer();
        if (currentDataFileIndex > this.endOfDataRecordsIndex) {
            this.endOfDataRecordsIndex = currentDataFileIndex;
        }
        return returnCode;
    }

    private final int updateDataRecord(long recordKey, byte[] bytes, int offset, int length, boolean convertFromDeletedToNonDeleted) {
        if (bytes == null) {
            this.warning("updateDataRecord", "internal error");
            return -30;
        }
        if (!this.isWritable()) {
            this.warning("updateDataRecord", "write operation on file not open for output");
            return -48;
        }
        byte[] oldBytes = this.getFullDataRecord(recordKey);
        if (oldBytes == null) {
            return this.status;
        }
        int max = this.recordTo;
        if (max < 6) {
            max = 6;
        }
        ACUFile.setBytesFromShort(oldBytes, 0, max);
        ACUFile.setBytesFromShort(oldBytes, 2, length);
        if (convertFromDeletedToNonDeleted && this.keyDuplicateCount > 0) {
            ACUFile.setBytesFromInt(oldBytes, 4, this.currentRecordID);
        }
        int headerSize = 4;
        if (this.keyDuplicateCount > 0) {
            headerSize = 8;
        }
        System.arraycopy(bytes, offset, oldBytes, headerSize, length);
        int returnCode = this.seekToDataRecord(recordKey);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        returnCode = this.dataFile.write(oldBytes, 0, oldBytes.length);
        this.iostatus(returnCode);
        if (returnCode < 0) {
            return returnCode;
        }
        long currentDataFileIndex = this.dataFile.getFilePointer();
        if (currentDataFileIndex > this.endOfDataRecordsIndex) {
            this.endOfDataRecordsIndex = currentDataFileIndex;
        }
        return returnCode;
    }

    private long getKeyFileID() {
        return ACUFile.getIntFromBytes(this.keyFileHeader, 0);
    }

    private void setKeyFileID() {
        this.keyFileHeader[0] = 16;
        this.keyFileHeader[1] = 18;
        this.keyFileHeader[2] = 20;
        this.keyFileHeader[3] = 24;
    }

    private int getKeyFileMajorVersion() {
        return ACUFile.getShortFromBytes(this.keyFileHeader, 4);
    }

    private void setKeyFileMajorVersion() {
        this.keyFileHeader[4] = 0;
        this.keyFileHeader[5] = 4;
    }

    private int getKeyFileMinorVersion() {
        return this.keyFileHeader[6] & 0xFF;
    }

    private void setKeyFileMinorVersion() {
        this.keyFileHeader[6] = 0;
    }

    private long getKeyFileEndOfFilePosition() {
        return ACUFile.getIntFromBytes(this.keyFileHeader, 8);
    }

    private void setKeyFileEndOfFilePosition(long val) {
        ACUFile.setBytesFromInt(this.keyFileHeader, 8, val);
        ACUFile.setBytesFromInt(this.dataFileHeader, 110, val);
    }

    private long getNumberOfTransactions() {
        return ACUFile.getIntFromBytes(this.keyFileHeader, 12);
    }

    private void setNumberOfTransactions(long val) {
        ACUFile.setBytesFromInt(this.keyFileHeader, 12, val);
        ACUFile.setBytesFromInt(this.dataFileHeader, 64, val);
    }

    private long getDataFileID() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 0);
    }

    private void setDataFileID() {
        this.dataFileHeader[0] = 16;
        this.dataFileHeader[1] = 18;
        this.dataFileHeader[2] = 20;
        this.dataFileHeader[3] = 25;
    }

    private int getDataFileMajorVersion() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 4);
    }

    private void setDataFileMajorVersion() {
        this.dataFileHeader[4] = 0;
        this.dataFileHeader[5] = 4;
    }

    private int getDataFileMinorVersion() {
        return this.dataFileHeader[6] & 0xFF;
    }

    private void setDataFileMinorVersion() {
        this.dataFileHeader[6] = 0;
    }

    private int getBlockingFactor() {
        return this.dataFileHeader[7] & 0xFF;
    }

    private void setBlockingFactor(int val) {
        this.dataFileHeader[7] = (byte)val;
    }

    private int getNumberOfBlocksToPreallocate() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 8);
    }

    private void setNumberOfBlocksToPreallocate(int val) {
        ACUFile.setBytesFromShort(this.dataFileHeader, 8, val);
    }

    private int getNumberOfBlocksToExtend() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 10);
    }

    private void setNumberOfBlocksToExtend(int val) {
        ACUFile.setBytesFromShort(this.dataFileHeader, 10, val);
    }

    private long getDataFileEndOfFilePosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 12);
    }

    private void setDataFileEndOfFilePosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 12, val);
        ACUFile.setBytesFromInt(this.dataFileHeader, 106, val);
    }

    private long getDataFileNextBlockAllocationPosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 18);
    }

    private void setDataFileNextBlockAllocationPosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 18, val);
    }

    private long getDataFileEndOfLastRecordPosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 24);
    }

    private void setDataFileEndOfLastRecordPosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 24, val);
    }

    private long getDataFileFirstRecordPosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 30);
    }

    private void setDataFileFirstRecordPosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 30, val);
    }

    private long getDataFileDeletedRecordsPosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 36);
    }

    private void setDataFileDeletedRecordsPosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 36, val);
    }

    private long getSplitAndRedistributeTotal() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 42);
    }

    private void setSplitAndRedistributeTotal(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 42, val);
    }

    private long getKeyFileDeletedRecordsPosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 46);
    }

    private void setKeyFileDeletedRecordsPosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 46, val);
    }

    private long getDataFileNumberOfRecords() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 52);
    }

    private void setDataFileNumberOfRecords(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 52, val);
    }

    private long getDataFileNumberOfDeletedRecords() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 56);
    }

    private void setDataFileNumberOfDeletedRecords(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 56, val);
    }

    private long getDataFileNextRecordID() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 60);
    }

    private void setDataFileNextRecordID(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 60, val);
    }

    private long getDataFileCollatingSequenceTablePosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 68);
    }

    private void setDataFileCollatingSequenceTablePosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 68, val);
    }

    private long getKeyFileTotalNodeSpaceUsed() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 72);
    }

    private void setKeyFileTotalNodeSpaceUsed(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 72, val);
    }

    private long getUserCount() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 76);
    }

    private void setUserCount(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 76, val);
    }

    private int getKeyFileNumberOfRecords() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 80);
    }

    private void setKeyFileNumberOfRecords(int val) {
        ACUFile.setBytesFromShort(this.dataFileHeader, 80, val);
    }

    private int getKeyFileNumberOfDeletedRecords() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 82);
    }

    private void setKeyFileNumberOfDeletedRecords(int val) {
        ACUFile.setBytesFromShort(this.dataFileHeader, 82, val);
    }

    private int getHeaderSizeForDataRecord() {
        return this.dataFileHeader[85] & 0xFF;
    }

    private void setHeaderSizeForDataRecord(int val) {
        this.dataFileHeader[85] = (byte)val;
    }

    private int getTotalNumberOfKeysThatAllowDuplicates() {
        return this.dataFileHeader[87] & 0xFF;
    }

    private void setTotalNumberOfKeysThatAllowDuplicates(int val) {
        this.dataFileHeader[87] = (byte)val;
    }

    private long getKeyFileNextBlockAllocationPosition() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 92);
    }

    private void setKeyFileNextBlockAllocationPosition(long val) {
        ACUFile.setBytesFromInt(this.dataFileHeader, 92, val);
    }

    private long getFileSegmentSize() {
        return ACUFile.getIntFromBytes(this.dataFileHeader, 102);
    }

    private void setFileSegmentSize() {
        this.dataFileHeader[102] = 127;
        this.dataFileHeader[103] = -1;
        this.dataFileHeader[104] = this.nodeSize == 1024 ? -8 : -6;
        this.dataFileHeader[105] = 0;
    }

    private int getMaximumRecordSize() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 116);
    }

    private void setMaximumRecordSize(int val) {
        ACUFile.setBytesFromShort(this.dataFileHeader, 116, val);
    }

    private int getMinimumRecordSize() {
        return ACUFile.getShortFromBytes(this.dataFileHeader, 118);
    }

    private void setMinimumRecordSize(int val) {
        ACUFile.setBytesFromShort(this.dataFileHeader, 118, val);
    }

    private int getNumberOfKeys() {
        return this.dataFileHeader[120] & 0xFF;
    }

    private void setNumberOfKeys(int val) {
        this.dataFileHeader[120] = (byte)val;
    }

    private int getCompressionFactor() {
        return this.dataFileHeader[121] & 0xFF;
    }

    private void setCompressionFactor(int val) {
        this.dataFileHeader[121] = (byte)val;
    }

    private int getEncryptionFlag() {
        return this.dataFileHeader[122] & 0xFF;
    }

    private void setEncryptionFlag(int val) {
        this.dataFileHeader[122] = (byte)val;
    }

    private int getLargestKeySize() {
        return this.dataFileHeader[123] & 0xFF;
    }

    private void setLargestKeySize(int val) {
        this.dataFileHeader[123] = (byte)val;
    }

    private String getComment() {
        return ACUFile.getStringFromBytes(this.dataFileHeader, 128, 30);
    }

    private void setComment(String val) {
        ACUFile.setBytesFromString(this.dataFileHeader, 128, 30, val);
    }

    private int getHeaderOffset(int keyNumber) {
        int mult = 59;
        int offset = 0;
        offset = keyNumber >= 5 ? 512 + mult * (keyNumber - 5) : 160 + mult * keyNumber;
        return offset;
    }

    long getHeightOfTree(int keyNumber) {
        int offset = this.getHeaderOffset(keyNumber) + 6;
        return this.dataFileHeader[offset] & 0xFF;
    }

    void setHeightOfTree(int keyNumber, int val) {
        int offset = this.getHeaderOffset(keyNumber) + 6;
        this.dataFileHeader[offset] = (byte)val;
    }

    private long getRootNode(int keyNumber) {
        int offset = this.getHeaderOffset(keyNumber);
        return ACUFile.getIntFromBytes(this.dataFileHeader, offset);
    }

    private void setRootNode(int keyNumber, long val) {
        int offset = this.getHeaderOffset(keyNumber);
        ACUFile.setBytesFromInt(this.dataFileHeader, offset, val);
    }

    private void createKeyHeaderInformation() {
        this.setNumberOfKeys(this.numberOfKeys);
        this.setLargestKeySize(this.maxKeyLength);
        int masterRecordAddress = this.masterRecord.getAddress();
        int offset = 160;
        for (int i = 0; i < this.numberOfKeys; ++i) {
            if (i == 5) {
                offset = 512;
            }
            Variable key = this.keyArray[i];
            Variable[] keys = null;
            keys = key instanceof VariableList ? ((VariableList)key).getList() : new Variable[]{key};
            this.dataFileHeader[offset + 7] = (byte)keys.length;
            this.dataFileHeader[offset + 8] = (byte)(this.keyDuplicatesAllowed[i] ? 1 : 0);
            this.dataFileHeader[offset + 9] = (byte)this.keyLengths[i];
            ACUFile.setBytesFromShort(this.dataFileHeader, offset + 10, keys[0].length());
            ACUFile.setBytesFromShort(this.dataFileHeader, offset + 12, keys[0].getAddress() - masterRecordAddress);
            offset += 14;
            for (int j = 1; j < keys.length; ++j) {
                this.dataFileHeader[offset] = (byte)keys[j].length();
                ACUFile.setBytesFromShort(this.dataFileHeader, offset + 1, keys[j].getAddress() - masterRecordAddress);
                offset += 3;
            }
            offset += 3 * (16 - keys.length);
        }
    }

    private boolean checkKeyInformation() {
        int numKeys = this.getNumberOfKeys();
        if (numKeys != this.numberOfKeys) {
            return false;
        }
        int masterRecordAddress = this.masterRecord.getAddress();
        int offset = 160;
        for (int i = 0; i < numKeys; ++i) {
            boolean dups;
            if (i == 5) {
                offset = 512;
            }
            int numSegments = this.dataFileHeader[offset + 7] & 0xFF;
            Variable key = this.keyArray[i];
            Variable[] keys = null;
            if (key instanceof VariableList) {
                keys = ((VariableList)key).getList();
                if (keys.length != numSegments) {
                    return false;
                }
            } else {
                if (numSegments > 1) {
                    return false;
                }
                keys = new Variable[]{key};
            }
            boolean bl = dups = (this.dataFileHeader[offset + 8] & 0xFF) != 0;
            if (this.keyDuplicatesAllowed[i] != dups) {
                return false;
            }
            int klen = this.dataFileHeader[offset + 9] & 0xFF;
            if (this.keyLengths[i] != klen) {
                return false;
            }
            int segSize = ACUFile.getShortFromBytes(this.dataFileHeader, offset + 10);
            if (keys[0].length() != segSize) {
                return false;
            }
            int segOffset = ACUFile.getShortFromBytes(this.dataFileHeader, offset + 12);
            if (keys[0].getAddress() - masterRecordAddress != segOffset) {
                return false;
            }
            offset += 14;
            for (int j = 1; j < keys.length; ++j) {
                segSize = this.dataFileHeader[offset] & 0xFF;
                if (keys[j].length() != segSize) {
                    return false;
                }
                segOffset = ACUFile.getShortFromBytes(this.dataFileHeader, offset + 1);
                if (keys[j].getAddress() - masterRecordAddress != segOffset) {
                    return false;
                }
                offset += 3;
            }
            offset += 3 * (16 - keys.length);
        }
        return true;
    }

    public static String getStringFromBytes(byte[] bytes, int offset, int maxLength) {
        int bval;
        String txt = "";
        for (int i = 0; i < maxLength && (bval = bytes[offset++] & 0xFF) != 0; ++i) {
            txt = txt + (char)bval;
        }
        return txt;
    }

    public static void setBytesFromString(byte[] bytes, int offset, int maxLength, String txt) {
        if (txt == null) {
            return;
        }
        int len = txt.length();
        for (int i = 0; i < maxLength; ++i) {
            if (i == len) {
                bytes[offset] = 0;
                return;
            }
            char c = txt.charAt(i);
            byte bval = (byte)(c & 0xFF);
            bytes[offset++] = bval;
        }
    }

    public static long getIntFromBytes(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static void setBytesFromInt(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(value >> 24 & 0xFFL);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFFL);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFFL);
        bytes[offset + 3] = (byte)(value & 0xFFL);
    }

    public static int getShortFromBytes(byte[] bytes, int offset) {
        return ((short)bytes[offset] & 0xFF) << 8 | (short)bytes[offset + 1] & 0xFF;
    }

    public static void setBytesFromShort(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)(value >> 8 & 0xFF);
        bytes[offset + 1] = (byte)(value & 0xFF);
    }

    public final int getIndexNodeRecordSize() {
        return this.nodeSize;
    }

    public final boolean getDuplicatesAllowed(int index) {
        if (this.keyDuplicatesAllowed != null) {
            return this.keyDuplicatesAllowed[index];
        }
        return false;
    }

    public boolean fileIsOpen() {
        return this.isOpen;
    }

    public boolean isInput() {
        return this.readable && !this.writable;
    }

    public boolean isOutput() {
        return this.writable && !this.readable;
    }

    public boolean isIO() {
        return this.readable && this.writable;
    }

    public boolean isExtend() {
        return this.extend;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isNewFile() {
        return !this.fileAlreadyExists;
    }

    public void flushCache() {
    }

    public void reset() {
        this.keyFileHeader = null;
        this.dataFileHeader = null;
        this.readHeaderInformation();
        this.seekToKeyRecord(0L);
        this.seekToDataRecord(0L);
    }

    public final void iostatus(int status) {
        this.status = status;
    }

    public final int getStatus() {
        int myStatus = this.status;
        this.status = 0;
        return myStatus;
    }

    public final void increaseCurrentRecordID() {
        ++this.currentRecordID;
    }

    public final long getCurrentRecordID() {
        return this.currentRecordID;
    }

    public static boolean isPrint(char c) {
        return c >= ' ' && c <= '~';
    }

    public static String getHexDump(byte[] buffer) {
        return ACUFile.getHexDump(buffer, 0, buffer.length);
    }

    public static String getHexDump(byte[] buffer, int offset, int length) {
        String hex;
        int count;
        String lineSep = "\n";
        try {
            lineSep = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (buffer == null) {
            return null;
        }
        String text = "";
        int val = 0;
        String asciitext = "";
        for (count = offset; count < length; ++count) {
            val = buffer[count] & 0xFF;
            hex = "00";
            try {
                hex = Integer.toHexString(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (hex.length() < 2) {
                hex = "0" + hex;
            }
            String chex = "00";
            try {
                chex = Integer.toHexString(count);
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (chex.length() < 5) {
                chex = "0" + chex;
            }
            char c = (char)val;
            if (count == 0) {
                asciitext = ACUFile.isPrint(c) ? asciitext + "" + c : asciitext + ".";
            }
            if (count != 0) {
                if (count % 32 == 0) {
                    text = text + "  " + asciitext + lineSep;
                    asciitext = "";
                } else if (count % 4 == 0) {
                    text = text + " ";
                }
                asciitext = ACUFile.isPrint(c) ? asciitext + "" + c : asciitext + ".";
            }
            if (count % 32 == 0) {
                text = text + chex.toUpperCase() + ": ";
            }
            text = text + hex.toUpperCase();
        }
        hex = "--";
        while (true) {
            if (count != 0) {
                if (count % 32 == 0) break;
                if (count % 4 == 0) {
                    text = text + " ";
                }
                asciitext = asciitext + "-";
            }
            text = text + hex.toUpperCase();
            ++count;
        }
        text = text + "  " + asciitext + lineSep;
        return text;
    }
}

