/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class ACUFilePointer
implements comparableByteArray {
    private int recordKey = -1;
    public static final int length = 4;

    public ACUFilePointer() {
        this.recordKey = -1;
    }

    public ACUFilePointer(long recordKey) {
        this.recordKey = (int)recordKey;
    }

    public ACUFilePointer(byte[] bytes, int offset) {
        this.recordKey = (int)this.getIntFromBytes(bytes, offset);
    }

    @Override
    public final int length() {
        return 4;
    }

    public final int hashCode() {
        return this.recordKey;
    }

    public final void setPointer(long recordKey) {
        this.recordKey = (int)recordKey;
    }

    public final void setRecordKey(long recordKey) {
        this.recordKey = (int)recordKey;
    }

    public final long getRecordKey() {
        return this.recordKey;
    }

    @Override
    public final int compare(comparableByteArray pointer, boolean truncate) {
        return this.compare(pointer);
    }

    @Override
    public final int compare(comparableByteArray pointer) {
        ACUFilePointer otherPointer = (ACUFilePointer)pointer;
        if (this.recordKey == (int)otherPointer.getRecordKey()) {
            return 0;
        }
        if (this.recordKey > (int)otherPointer.getRecordKey()) {
            return 1;
        }
        return -1;
    }

    @Override
    public final byte[] toByteArray() {
        return this.getBytesFromInt(this.recordKey);
    }

    @Override
    public final void fromByteArray(byte[] tempBytes) {
        this.recordKey = (int)this.getIntFromBytes(tempBytes, 0);
    }

    public final String toStringNegative() {
        return "{ " + -this.recordKey + " }";
    }

    public final String toString() {
        return "{ " + this.recordKey + " }";
    }

    @Override
    public final comparableByteArray copy() {
        return new ACUFilePointer(this.recordKey);
    }

    public final boolean equals(Object o) {
        return o != null && o.hashCode() == this.hashCode();
    }

    public final boolean equals(ACUFilePointer p) {
        return p.recordKey == this.recordKey;
    }

    private long getIntFromBytes(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public void writeBytes(byte[] bytes, int offset) {
        this.setBytesFromInt(bytes, offset, this.recordKey);
    }

    private byte[] getBytesFromInt(long value) {
        byte[] bytes = new byte[4];
        this.setBytesFromInt(bytes, 0, value);
        return bytes;
    }

    private void setBytesFromInt(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(value >> 24 & 0xFFL);
        bytes[offset + 1] = (byte)(value >> 16 & 0xFFL);
        bytes[offset + 2] = (byte)(value >> 8 & 0xFFL);
        bytes[offset + 3] = (byte)(value & 0xFFL);
    }

    @Override
    public boolean supportsCompareBytes() {
        return false;
    }

    @Override
    public int compareBytes(byte[] bytes, int offset, int len, boolean truncate) {
        return 0;
    }
}

