/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Dialog;
import com.heirloomcomputing.ecs.exec.ICallableProgram;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.NativeCall;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AConnect
implements ICallableProgramGiving {
    public static final boolean debugMode = false;
    public static final int COMMIT_CONTEXT_PROGRAMMED = 0;
    public static final int COMMIT_CONTEXT_UNKNOWN = 1;
    public static final int COMMIT_CONTEXT_NO_TRX = 2;
    public static final int ROLLBACK_CONTEXT_PROGRAMMED = 0;
    public static final int ROLLBACK_CONTEXT_UNKNOWN = 1;
    public static final int ROLLBACK_CONTEXT_NO_TRX = 2;
    public static final int MAX_KEYS = 120;
    public static final int MAX_KEY_SIZE = 250;
    public static final int MAX_SEGS = 16;
    public static final int KEY_DESC_SIZE = 5;
    public static final int SEG_DESC_SIZE = 10;
    public static final int Finput = 0;
    public static final int Foutput = 1;
    public static final int Fio = 2;
    public static final int Fextend = 3;
    public static final int Fmulti_lock = 16;
    public static final int Fread_lock = 256;
    public static final int Fwrite_lock = 512;
    public static final int Fmass_update = 1536;
    public static final int Ftrans = 16384;
    public static final int F_EQUALS = 0;
    public static final int F_NOT_LESS = 1;
    public static final int F_GREATER = 2;
    public static final int F_LESS = 3;
    public static final int F_NOT_GREATER = 4;
    public static final int GET_LOGICAL_PARAMS = 1;
    public static final int GET_PHYSICAL_PARAMS = 2;
    public static final int GET_COMMENT = 3;
    public static final int GET_RECORD_COUNT = 4;
    public static final int GET_COLLATING_SEQUENCE = 5;
    public static final int GET_LOCK_COUNT = 6;
    public static final int GET_SEGMENT_COUNT = 7;
    public static final int GET_SEGMENT_INFO = 8;
    public static final int GET_FILE_SIZE = 9;
    public static final int E_SYS_ERR = 1;
    public static final int E_PARAM_ERR = 2;
    public static final int E_TOO_MANY_FILES = 3;
    public static final int E_MODE_CLASH = 4;
    public static final int E_REC_LOCKED = 5;
    public static final int E_BROKEN = 6;
    public static final int E_DUPLICATE = 7;
    public static final int E_NOT_FOUND = 8;
    public static final int E_UNDEF_RECORD = 9;
    public static final int E_DISK_FULL = 10;
    public static final int E_FILE_LOCKED = 11;
    public static final int E_REC_CHANGED = 12;
    public static final int E_MISMATCH = 13;
    public static final int E_NO_MEMORY = 14;
    public static final int E_MISSING_FILE = 15;
    public static final int E_PERMISSION = 16;
    public static final int E_NO_SUPPORT = 17;
    public static final int E_NO_LOCKS = 18;
    public static final int E_INTERFACE = 19;
    public static final int E_LICENSE_ERR = 20;
    public static final int E_UNKNOWN_ERR = 21;
    public static final int W_NO_SUPPORT = 100;
    public static final int W_DUP_OK = 101;
    public static final int E_LOG_EXTERNAL = 1;
    public static final int E_LOG_TOO_MANY = 2;
    public static final int E_LOG_MISSING = 3;
    public static final int E_LOG_PERMISSION = 4;
    public static final int E_LOG_SYS_ERR = 5;
    public static final int E_LOG_CORRUPT = 6;
    public static final int E_LOG_LOCKED = 7;
    public static final int E_LOG_NO_MEMORY = 8;
    public static final int E_LOG_DISK_FULL = 9;
    public static final int E_NO_LOG = 10;
    public static final int E_RB_LOG_CORRUPT = 11;
    public static final int E_LOG_INCOMPLETE = 12;
    public static final int E_OPEN_NOT_LOGGED = 13;
    public static final int E_LOG_INTERFACE = 14;
    public static final int E_LOG_REMOTE = 15;
    public static final int E_LOG_NESTED_START = 16;
    public static final int E_LOG_TEMP = 17;
    public static final int W_LOG_NO_SUPPORT = 100;
    public static final int G_OK = 0;
    public static final int G_CONT = -1;
    public static final int G_CALL_NOTFOUND = -1;
    public static final int G_FILE_NOTFOUND = -1;
    public static final int G_STOP_RUN = -2;
    public static final int G_SOCKET_ERROR = -3;
    public static final int G_FILE_ERROR = -3;
    public static final int G_SYNC_NODEF = -4;
    public static final int G_COBOL_ERROR = -5;
    public static final int G_CONNECT_FAIL = -6;
    public static final int G_ERR_PWD = -7;
    public static final int G_TIMEOUT = -8;
    public static final int G_MISSING = 1;
    public static final int G_NOT_COBOL = 2;
    public static final int G_INTERNAL = 3;
    public static final int G_MEMORY = 4;
    public static final int G_VERSION = 5;
    public static final int G_RECURSIVE = 6;
    public static final int G_EXTERNAL = 7;
    public static final int G_LARGE_MODEL = 8;
    public static final int G_ECONNREFUSED = 25;
    public static final int G_JAPANESE = 14;
    public static final int FILE_BASE = 1000;
    private static final int TIME_MASK = 2041302511;
    private static final String SIGNATURE_STRING = "picoSoft.it:dcp";
    private static final int SEQ_CFUN_BYNUM = 128;
    private static final int SEQ_CONFIGURE = 129;
    private static final int SEQ_INITIALIZE = 130;
    private static final int SEQ_RET_INIT = 64;
    private static final int SEQ_LOGIN = 1;
    private static final int SEQ_CALL_SYNC = 2;
    private static final int SEQ_END = 4;
    private static final int SEQ_STOP_RUN = 6;
    private static final int SEQ_CALL_ASYNC = 7;
    private static final int SEQ_OK = 8;
    private static final int SEQ_POLL = 10;
    private static final int SEQ_NO_DATA = 11;
    private static final int SEQ_NO_FOUND = 12;
    private static final int SEQ_CANCEL = 13;
    private static final int SEQ_REQ_PWD = 14;
    private static final int SEQ_ERR_PWD = 15;
    private static final int I_MAKE = -2147483600;
    private static final int I_OPEN = -2147483599;
    private static final int I_CLOSE = -2147483598;
    private static final int I_READ = -2147483597;
    private static final int I_NEXT = -2147483596;
    private static final int I_PREVIOUS = -2147483595;
    private static final int I_WRITE = -2147483594;
    private static final int I_REWRITE = -2147483593;
    private static final int I_DELETE = -2147483592;
    private static final int I_START = -2147483591;
    private static final int I_INFO = -2147483590;
    private static final int I_REMOVE = -2147483588;
    private static final int I_SYNC = -2147483587;
    private static final int I_RENAME = -2147483586;
    private static final int I_COPY = -2147483585;
    private static final int I_UNLOCK = -2147483584;
    private static final int I_BEGIN = -2147483579;
    private static final int I_COMMIT = -2147483578;
    private static final int I_ROLLBACK = -2147483577;
    private static final int I_RECOVER = -2147483576;
    private static final int type_NumEdited = 0;
    private static final int type_BinarySigned = 11;
    private static final int type_BinaryUnsigned = 12;
    private static final int type_Alphanum = 16;
    private static final int type_Float = 23;
    private static final int type_NativeVSigned = 30;
    private static final int type_NativeVUnsigned = 31;
    private static final int Okay = 0;
    private static final int PASSWORD_SIZE = 12;
    private static final int BUFSIZE = 65536;
    private static final int PORTNUM = 6996;
    private static final int PROTOCOL_ALL = 1;
    public static final int PARAM_INPUT = 1;
    public static final int PARAM_OUTPUT = 2;
    public static final int PARAM_IO = 3;
    public static final String KEY_CODE_MAPPING = "CODE_MAPPING";
    public static final String KEY_CODE_SUFFIX = "CODE_SUFFIX";
    public static final String KEY_CODE_PREFIX = "CODE_PREFIX";
    public static final String KEY_CFG_FILE = "ACUCONNECT_CONFIGURATION_FILE";
    public static final String KEY_RTS_FLAGS = "ACUCONNECT_RUNTIME_FLAGS";
    public static final String KEY_FILE_PREFIX = "FILE_PREFIX";
    public static final String KEY_CLAFCA = "ACUCONNECT_CLOSE_AFTER_CANCEL";
    public static final String KEY_SERVER_PORT = "SERVER_PORT";
    public static final String KEY_DEFAULT_CONN_TIMEOUT = "DEFAULT_CONNECT_TIMEOUT";
    public static final String KEY_DEFAULT_RUN_TIMEOUT = "DEFAULT_RUN_TIMEOUT";
    public static final String HEADER_MSG_ERR = "AcuConnect error ";
    public static final char TAG_REMOTE_FILE = '@';
    public static final char TAG_REMOTE_OBJECT = '@';
    public static final String USER = "USER";
    public static final String codeSuffixDefault = ".acu";
    private boolean isTrace = false;
    private int f_no_lock = 0;
    private int errno = 0;
    private int int_errno = 0;
    private int int2_errno = 0;
    private String host = "127.0.0.1";
    private int port = 6996;
    private Socket socket = null;
    private DataInputStream is = null;
    private DataOutputStream os = null;
    private int bytesInOutBuffer = 0;
    private int bytesInInBuffer = 0;
    private byte[] outBuffer = new byte[65536];
    private byte[] inBuffer = new byte[65536];
    private boolean connected = false;
    private int returnCode = 0;
    private int functionReturnCode = 0;
    private String cfgPath = null;
    private String rtsFlags = null;
    private String codePrefix = null;
    private String codeSuffix = null;
    private String filePrefix = null;
    private boolean closeAfterCancel = false;
    private int protocolType = 1;
    private Context context;
    private static String password = null;
    private int callError = 0;
    private boolean codeMapping = false;
    private static boolean initializedNativeCall = false;
    private String currentCallName = null;
    private Vector<String> callNames = null;
    private int lastReturnCode = 0;
    private static Hashtable<String, AConnect> hostTable = null;
    private static AConnect lastConnectionUsed = null;

    private static final void debug(String text) {
        System.out.println("AConnect: " + text);
    }

    private static final void trace(String text) {
        System.out.println("AConnect: " + text);
    }

    private static final boolean isNumeric(int x) {
        return x > 0 && x < 16 || x == 30 || x == 31 || x == 23;
    }

    public AConnect(Context context) {
        this(context, null, 6996);
    }

    public AConnect(Context context, String host, int port) {
        this.context = context;
        if (host != null) {
            this.setHost(host);
        }
        this.setPort(port);
        this.setRTSFlags(RuntimeEnvironment.getGlobalParameter(KEY_RTS_FLAGS));
        this.setCodeMapping(RuntimeEnvironment.getGlobalParameter(KEY_CODE_MAPPING));
        this.setCodePrefix(RuntimeEnvironment.getGlobalParameter(KEY_CODE_PREFIX));
        this.setCodeSuffix(RuntimeEnvironment.getGlobalParameter(KEY_CODE_SUFFIX));
        this.setFilePrefix(RuntimeEnvironment.getGlobalParameter(KEY_FILE_PREFIX));
    }

    private final int bytesToInt(byte[] bytes) {
        return this.bytesToInt(bytes, 0);
    }

    private final int bytesToInt(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    private final int pntohl(byte[] bytes) {
        return this.pntohl(bytes, 0);
    }

    private final int pntohl(byte[] bytes, int offset) {
        if (this.isLittleEndian()) {
            return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        }
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    private final int pntohs(byte[] bytes) {
        return this.pntohs(bytes, 0);
    }

    private final int pntohs(byte[] bytes, int offset) {
        if (this.isLittleEndian()) {
            return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
        }
        return (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    private final void intToBytes(byte[] bytes, int val) {
        this.intToBytes(bytes, 0, val);
    }

    private final void intToBytes(byte[] bytes, int offset, int val) {
        bytes[offset] = (byte)(val & 0xFF);
        bytes[offset + 1] = (byte)(val >> 8 & 0xFF);
        bytes[offset + 2] = (byte)(val >> 16 & 0xFF);
        bytes[offset + 3] = (byte)(val >> 24 & 0xFF);
    }

    private final void htonlp(byte[] bytes, int val) {
        this.htonlp(bytes, 0, val);
    }

    private final void htonlp(byte[] bytes, int offset, int val) {
        if (this.isLittleEndian()) {
            bytes[offset + 3] = (byte)(val & 0xFF);
            bytes[offset + 2] = (byte)(val >> 8 & 0xFF);
            bytes[offset + 1] = (byte)(val >> 16 & 0xFF);
            bytes[offset] = (byte)(val >> 24 & 0xFF);
        } else {
            bytes[offset] = (byte)(val & 0xFF);
            bytes[offset + 1] = (byte)(val >> 8 & 0xFF);
            bytes[offset + 2] = (byte)(val >> 16 & 0xFF);
            bytes[offset + 3] = (byte)(val >> 24 & 0xFF);
        }
    }

    private final void htonsp(byte[] bytes, int val) {
        this.htonsp(bytes, 0, val);
    }

    private final void htonsp(byte[] bytes, int offset, int val) {
        if (this.isLittleEndian()) {
            bytes[offset + 1] = (byte)(val & 0xFF);
            bytes[offset] = (byte)(val >> 8 & 0xFF);
        } else {
            bytes[offset] = (byte)(val & 0xFF);
            bytes[offset + 1] = (byte)(val >> 8 & 0xFF);
        }
    }

    private final byte[] getBytesFromString(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(text.charAt(i) & 0xFF);
        }
        return bytes;
    }

    private final String getStringFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.getStringFromBytes(bytes, 0, bytes.length);
    }

    private final String getStringFromBytes(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        if (offset + length > bytes.length) {
            length = bytes.length - offset;
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(bytes[offset + i] & 0xFF);
        }
        return new String(chars);
    }

    private void storeErrno(PARAM_G_INFO[] args, int arg_num, int one_val) {
        this.storeErrno(args, arg_num, one_val, one_val, one_val);
    }

    private void storeErrno(PARAM_G_INFO[] args, int arg_num, int errno_val, int int_errno_val, int int2_errno_val) {
        byte[] argF_errno = new byte[4];
        byte[] argF_int_errno = new byte[4];
        byte[] argF_int2_errno = new byte[4];
        this.errno = errno_val;
        this.int_errno = int_errno_val;
        this.int2_errno = int2_errno_val;
        this.htonlp(argF_errno, this.errno);
        this.htonlp(argF_int_errno, this.int_errno);
        this.htonlp(argF_int2_errno, this.int2_errno);
        args[arg_num].setArg(argF_errno, 11, 9, 0, 3);
        args[arg_num + 1].setArg(argF_int_errno, 11, 9, 0, 3);
        args[arg_num + 2].setArg(argF_int2_errno, 11, 9, 0, 3);
    }

    private void restoreErrno(PARAM_G_INFO[] args, int arg_num) {
        this.errno = this.pntohl(args[arg_num].getAddressBytes());
        this.int_errno = this.pntohl(args[arg_num + 1].getAddressBytes());
        this.int2_errno = this.pntohl(args[arg_num + 2].getAddressBytes());
        if (this.isTrace()) {
            AConnect.trace("restoreErrno:  errno=" + this.errno + ", int_errno=" + this.int_errno + ", int2_errno=" + this.int2_errno);
        }
    }

    private boolean sendBytes() {
        int len;
        this.returnCode = 0;
        if (this.isTrace()) {
            AConnect.trace("sendBytes:  Bytes in output buffer=" + this.bytesInOutBuffer);
        }
        if (this.bytesInOutBuffer == 0) {
            return true;
        }
        int start = 0;
        while ((len = this.bytesInOutBuffer - start) > 0) {
            if (len > 8192) {
                len = 8192;
            }
            try {
                this.os.write(this.outBuffer, start, len);
                this.os.flush();
            }
            catch (Exception e) {
                this.returnCode = -3;
                this.disconnect();
                if (this.isTrace()) {
                    AConnect.trace("sendBytes:  Socket error sending bytes");
                    e.printStackTrace(System.out);
                }
                return false;
            }
            start += len;
        }
        if (this.isTrace()) {
            AConnect.trace("sendBytes:  Bytes sent successfully");
        }
        this.bytesInOutBuffer = 0;
        return true;
    }

    private boolean receiveBytes(int len) {
        this.returnCode = 0;
        if (this.isTrace()) {
            AConnect.trace("receiveBytes:  Len=" + len);
        }
        this.bytesInInBuffer = 0;
        int lenRead = 0;
        int start = 0;
        while (true) {
            try {
                lenRead = this.is.read(this.inBuffer, start, len);
            }
            catch (Exception e) {
                this.returnCode = -3;
                this.disconnect();
                if (this.isTrace()) {
                    AConnect.trace("receiveBytes:  Socket error receiving bytes");
                    e.printStackTrace(System.out);
                }
                return false;
            }
            if (lenRead < 0) {
                if (this.isTrace()) {
                    AConnect.trace("receiveBytes:  End of stream reached, returning...");
                }
                return false;
            }
            if (lenRead == len) break;
            if (this.isTrace()) {
                AConnect.trace("receiveBytes:  The number of bytes received does not match the expected number...");
                AConnect.trace("receiveBytes:  Bytes received: " + lenRead + ", expected: " + len);
                AConnect.trace("Attempting another read...");
            }
            start += lenRead;
            len -= lenRead;
            lenRead = 0;
        }
        if (this.isTrace()) {
            AConnect.trace("receiveBytes:  Bytes received successfully");
        }
        this.bytesInInBuffer = len;
        return true;
    }

    private String receiveNullTerminatedString(int maxLen) {
        int len;
        if (this.isTrace()) {
            AConnect.trace("receiveNullTerminatedString:  MaxLen=" + maxLen);
        }
        this.returnCode = 0;
        String text = null;
        this.bytesInInBuffer = 0;
        for (len = 0; len <= maxLen; ++len) {
            byte b;
            try {
                b = this.is.readByte();
            }
            catch (Exception e) {
                this.returnCode = -3;
                this.disconnect();
                if (!this.isTrace()) break;
                AConnect.trace("receiveNullTerminatedString:  Socket error receiving byte");
                break;
            }
            this.inBuffer[len] = b;
            if (this.isTrace()) {
                AConnect.trace("receiveNullTerminatedString:  b=" + b);
            }
            if (b == 0) continue;
            text = text + (char)(b & 0xFF);
            if (b != 0) continue;
        }
        this.bytesInInBuffer = len;
        if (this.isTrace()) {
            AConnect.trace("receiveNullTerminatedString:  Returning: " + text);
        }
        return text;
    }

    private int getLongFromBuffer(int offset) {
        return this.pntohl(this.inBuffer, offset);
    }

    private byte[] getBytesFromBuffer(int bufferOffset, int len) {
        byte[] bytes = new byte[len];
        System.arraycopy(this.inBuffer, bufferOffset, bytes, 0, len);
        return bytes;
    }

    private void putLongInBuffer(int offset, int val) {
        this.htonlp(this.outBuffer, offset, val);
    }

    private void putBytesInBuffer(int bufferOffset, byte[] bytes, int offset, int len) {
        System.arraycopy(bytes, offset, this.outBuffer, bufferOffset, len);
    }

    private void putStringInBuffer(int bufferOffset, String text) {
        byte[] bytes = this.getBytesFromString(text);
        if (this.isTrace()) {
            AConnect.trace("putStringInBuffer:  bufferOffset=" + bufferOffset + ", text='" + text + "', textBytesString='" + this.getStringFromBytes(bytes) + "'");
        }
        this.putBytesInBuffer(bufferOffset, bytes, 0, bytes.length);
    }

    private String getStringFromBuffer(int bufferOffset, int len) {
        byte[] bytes = this.getBytesFromBuffer(bufferOffset, len);
        return this.getStringFromBytes(bytes);
    }

    private byte[] getArgumentBytes(PARAM_G_INFO[] args) {
        this.bytesInOutBuffer = 0;
        int end = 0;
        for (int i = 1; i < args.length; ++i) {
            end += args[i].writeBytes(this.outBuffer, end);
        }
        byte[] bytes = new byte[end];
        System.arraycopy(this.outBuffer, 0, bytes, 0, end);
        return bytes;
    }

    private void setArgumentBytes(PARAM_G_INFO[] args, byte[] bytes) {
        int end = 0;
        for (int i = 1; i < args.length; ++i) {
            end += args[i].readBytes(bytes, end);
        }
    }

    private int sendAndReceive(PARAM_G_INFO[] args, int type) {
        this.returnCode = 0;
        if (args == null) {
            return this.returnCode;
        }
        this.allocBufferC(args, type);
        this.sendHost(args, type);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        this.receiveHost(args, type);
        if (this.returnCode != 0 && this.returnCode != -3 && this.returnCode != -5) {
            this.AcuConnectSendEnd();
        }
        return this.returnCode;
    }

    private boolean verifyConnection() {
        int versionOk = 1;
        if (this.isTrace()) {
            AConnect.trace("verifyConnection:  Verifying connection...");
        }
        this.receiveBytes(SIGNATURE_STRING.length());
        if (this.returnCode != 0) {
            return false;
        }
        String text = this.getStringFromBytes(this.inBuffer, 0, SIGNATURE_STRING.length());
        if (!SIGNATURE_STRING.equalsIgnoreCase(text)) {
            if (this.isTrace()) {
                AConnect.trace("verifyConnection:  String returned does not match signature.");
                AConnect.trace("                   String returned='" + text + "'");
            }
            this.returnCode = 5;
            return false;
        }
        this.receiveBytes(4);
        int version = this.getLongFromBuffer(0);
        if (this.isTrace()) {
            AConnect.trace("verifyConnection:  Version=" + version);
        }
        if (version > versionOk) {
            if (this.isTrace()) {
                AConnect.trace("verifyConnection:  Error: Version mismatch");
            }
            this.returnCode = 5;
            return false;
        }
        this.protocolType = this.getProtocolType();
        if (this.isTrace()) {
            AConnect.trace("verifyConnection:  Connection verified, protocolType=" + this.protocolType);
        }
        return true;
    }

    private void setConnected(boolean flag) {
        this.connected = flag;
    }

    private void disconnect() {
        this.setConnected(false);
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.is = null;
        this.os = null;
    }

    private boolean connect() {
        if (this.isTrace()) {
            AConnect.trace("Connect:  Connecting...");
        }
        this.returnCode = 0;
        if (this.isConnected()) {
            if (this.isTrace()) {
                AConnect.trace("Connect:  Already connected...");
            }
            return true;
        }
        String host = this.getHost();
        int port = this.getPort();
        if (this.isTrace()) {
            AConnect.trace("Connect:  Host='" + host + "' Port=" + port + "");
        }
        try {
            if (this.isTrace()) {
                AConnect.trace("Connect:  Creating socket...");
            }
            this.socket = new Socket(host, port);
            if (this.isTrace()) {
                AConnect.trace("Connect:  Socket created.");
            }
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            boolean successful = this.verifyConnection();
            this.setConnected(successful);
            if (this.isTrace()) {
                AConnect.trace("Connect:  Connected successfully");
            }
            return successful;
        }
        catch (Exception e) {
            this.returnCode = -3;
            this.disconnect();
            if (this.isTrace()) {
                AConnect.trace("SocketManager could not connect:" + e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private int getProtocolType() {
        return 1;
    }

    private void AcuConnectSendEnd() {
        if (!this.isConnected()) {
            return;
        }
        this.returnCode = 0;
        byte[] msgend = new byte[20];
        msgend[0] = 4;
        msgend[1] = 0;
        System.arraycopy(msgend, 0, this.outBuffer, 0, 20);
        this.bytesInOutBuffer = 20;
        this.sendBytes();
        this.disconnect();
    }

    private void allocBufferC(PARAM_G_INFO[] args, int type) {
        byte[] addressBytes;
        int i = 0;
        long lenTmp = 0L;
        int bufferLen = 0;
        int inputBufferLen = 0;
        int outputBufferLen = 0;
        if (type == 7) {
            ++i;
        }
        if (type == 128) {
            bufferLen += 4;
        } else if (i < args.length && (addressBytes = args[i].getAddressBytes()) != null) {
            while (bufferLen < addressBytes.length && (addressBytes[bufferLen] & 0xFF) != 32) {
                ++bufferLen;
            }
        }
        bufferLen += 13;
        if (type == 128) {
            inputBufferLen = 13;
            outputBufferLen = bufferLen;
        }
        ++i;
        while (i < args.length) {
            lenTmp = 11L;
            if (type == 128) {
                if ((args[i].getIO() & 2) != 0) {
                    inputBufferLen += 4 + args[i].getLength();
                }
                if ((args[i].getIO() & 1) != 0) {
                    outputBufferLen = (int)((long)outputBufferLen + (lenTmp + (long)args[i].getLength()));
                }
            }
            bufferLen = (int)((long)bufferLen + (lenTmp + (long)args[i].getLength()));
            ++i;
        }
        if (type != 128 || (this.protocolType & 1) != 0) {
            inputBufferLen = bufferLen;
            outputBufferLen = bufferLen;
        }
        this.bytesInInBuffer = inputBufferLen;
        this.bytesInOutBuffer = outputBufferLen;
    }

    private int sendHost(PARAM_G_INFO[] args, int type) {
        byte[] addressBytes;
        this.returnCode = 0;
        int lenProg = 0;
        int i = 0;
        int numUsing = args.length;
        if (type == 7) {
            --numUsing;
            ++i;
        }
        if (type == 128) {
            lenProg = 4;
        } else if (i < args.length && (addressBytes = args[i].getAddressBytes()) != null) {
            while (lenProg < addressBytes.length && (addressBytes[lenProg] & 0xFF) != 32) {
                ++lenProg;
            }
        }
        int offset = 0;
        this.outBuffer[offset] = (byte)type;
        this.putLongInBuffer(++offset, this.bytesInOutBuffer);
        this.putLongInBuffer(offset += 4, lenProg);
        args[i++].writeAddressBytes(this.outBuffer, offset += 4);
        this.putLongInBuffer(offset += lenProg, numUsing - 1);
        offset += 4;
        while (i < args.length) {
            offset += args[i].writeBytes(this.outBuffer, offset);
            if (this.isTrace()) {
                AConnect.trace("sendHost:   param [" + i + "]: length [" + args[i].getLength() + "] type [" + args[i].getType() + "] digits [" + args[i].getDigits() + "] scale [" + args[i].getScale() + "] io [" + args[i].getIO() + "]");
            }
            ++i;
        }
        this.sendBytes();
        return this.returnCode;
    }

    private int receiveHost(PARAM_G_INFO[] args, int type) {
        this.returnCode = 0;
        if (this.isTrace()) {
            AConnect.trace("receiveHost:  Receiving bytes, bytesInInBuffer=" + this.bytesInInBuffer);
        }
        this.receiveBytes(this.bytesInInBuffer);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        int r_return = 0;
        int r_acallerr = 0;
        int offset = 1;
        this.functionReturnCode = 0;
        if (this.inBuffer[0] != 64) {
            this.returnCode = -5;
        } else {
            if (this.isTrace()) {
                AConnect.trace("receiveHost:  InBuffer[0]==SEQ_RET_INIT");
            }
            r_return = this.getLongFromBuffer(offset);
            r_acallerr = this.getLongFromBuffer(offset += 4);
            int r_returncode = this.getLongFromBuffer(offset += 4);
            offset += 4;
            if (this.isTrace()) {
                AConnect.trace("receiveHost:  r_return=" + r_return + ", r_acallerr=" + r_acallerr + ", r_returncode=" + r_returncode);
            }
            this.functionReturnCode = r_returncode;
        }
        if (this.returnCode != 0 || r_return == -1) {
            String errorMsg = null;
            if (this.inBuffer[0] != 64) {
                if (this.isTrace()) {
                    AConnect.trace("inBuffer[0]=" + this.inBuffer[0]);
                }
                if (this.bytesInInBuffer > 1) {
                    errorMsg = this.getStringFromBuffer(1, this.bytesInInBuffer - 1);
                }
            }
            if (errorMsg == null) {
                errorMsg = "Error, returnCode=" + this.returnCode + ", r_return=" + r_return;
            }
            this.showDialog(HEADER_MSG_ERR, errorMsg);
            if (this.isTrace()) {
                AConnect.trace("Error, returnCode=" + this.returnCode + ", r_return=" + r_return);
            }
            this.returnCode = -5;
        }
        if (this.returnCode == 0) {
            int i = 1;
            if (type == 7) {
                ++i;
            }
            while (i < args.length) {
                if ((args[i].getIO() & 2) != 0 || (this.protocolType & 1) != 0) {
                    offset += args[i].readBytes(this.inBuffer, offset);
                    if (this.isTrace) {
                        AConnect.trace("receiveHost:   param [" + i + "]: length [" + args[i].getLength() + "] type [" + args[i].getType() + "] digits [" + args[i].getDigits() + "] scale [" + args[i].getScale() + "] io [" + args[i].getIO() + "], offset=" + offset);
                    }
                }
                ++i;
            }
        }
        return this.returnCode;
    }

    private void showDialog(String title, String text) {
        Dialog.showInformationDialog(title, text);
    }

    private int configureStr(String variable, String strValue) {
        if (this.isTrace()) {
            AConnect.trace("configureStr:  Variable='" + variable + "', strValue='" + strValue + "'");
        }
        this.returnCode = 0;
        PARAM_G_INFO[] args = new PARAM_G_INFO[2];
        int type = 129;
        args[0] = new PARAM_G_INFO(variable, 16, 0, 0, 3);
        args[1] = new PARAM_G_INFO(strValue, 16, 0, 0, 3);
        this.allocBufferC(args, type);
        this.sendHost(args, type);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        this.receiveHost(args, type);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        if (this.isTrace()) {
            AConnect.trace("configureStr:  ReturnCode=" + this.returnCode);
        }
        return this.returnCode;
    }

    private String getConfigPath() {
        return this.cfgPath;
    }

    private void setConfigPath(String path) {
        this.cfgPath = path;
    }

    private String getRTSFlags() {
        return this.rtsFlags;
    }

    private void setRTSFlags(String flags) {
        this.rtsFlags = flags;
    }

    private boolean getCloseAfterCancel() {
        return this.closeAfterCancel;
    }

    public void setCloseAfterCancel(boolean flag) {
        this.closeAfterCancel = flag;
    }

    private boolean getCodeMapping() {
        return this.codeMapping;
    }

    private void setCodeMapping(String codeMappingString) {
        int mapping = 0;
        if (codeMappingString != null) {
            try {
                mapping = Integer.valueOf(codeMappingString.trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.codeMapping = mapping != 0;
    }

    private void setCodeMapping(boolean flag) {
        this.codeMapping = flag;
    }

    private String getCodePrefix() {
        return this.codePrefix;
    }

    private void setCodePrefix(String prefix) {
        this.codePrefix = prefix;
    }

    private String getCodeSuffix() {
        return this.codeSuffix;
    }

    private void setCodeSuffix(String suffix) {
        this.codeSuffix = suffix;
    }

    private String getFilePrefix() {
        return this.filePrefix;
    }

    private void setFilePrefix(String prefix) {
        this.filePrefix = prefix;
    }

    private int sendConfigPath() {
        this.returnCode = 0;
        String cfgPath = this.getConfigPath();
        if (cfgPath != null && cfgPath.length() > 0) {
            this.configureStr("CFG_PATH", cfgPath);
        } else if (this.isTrace()) {
            AConnect.trace("sendConfigPath:  Config path is null, not sending...");
        }
        return this.returnCode;
    }

    private int initializeServer(String name) {
        String filePrefix;
        String codePrefix;
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  Name=" + name);
        }
        this.returnCode = 0;
        String rtsFlags = this.getRTSFlags();
        if (rtsFlags != null && rtsFlags.length() > 0) {
            this.configureStr("RTS_FLAGS", rtsFlags);
            if (this.returnCode != 0) {
                return this.returnCode;
            }
        }
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  RTS flags = '" + rtsFlags + "'");
        }
        if ((codePrefix = this.getCodePrefix()) != null && codePrefix.length() > 0) {
            this.configureStr(KEY_CODE_PREFIX, codePrefix);
            if (this.returnCode != 0) {
                return this.returnCode;
            }
        }
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  Code prefix = '" + codePrefix + "'");
        }
        if ((filePrefix = this.getFilePrefix()) != null && filePrefix.length() > 0) {
            this.configureStr(KEY_FILE_PREFIX, filePrefix);
            if (this.returnCode != 0) {
                return this.returnCode;
            }
        }
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  File prefix = '" + filePrefix + "'");
        }
        int offset = 0;
        this.outBuffer[offset] = -126;
        this.putLongInBuffer(++offset, 9 + name.length());
        this.putLongInBuffer(offset += 4, name.length());
        this.putStringInBuffer(offset += 4, name);
        this.bytesInOutBuffer = offset += name.length();
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  bytesInOutBuffer=" + this.bytesInOutBuffer);
            AConnect.trace("initializeServer:  outBuffer='" + this.getStringFromBytes(this.outBuffer, 0, this.bytesInOutBuffer) + "'");
        }
        this.sendBytes();
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  Sent bytes, waiting on return bytes...");
        }
        this.receiveBytes(1);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        if (this.isTrace()) {
            AConnect.trace("initializeServer:  InBuffer[0]=" + this.inBuffer[0]);
        }
        if (this.inBuffer[0] == 8 || this.inBuffer[0] == 0) {
            if (this.isTrace()) {
                AConnect.trace("initializeServer:  Initialization accepted by server...");
            }
            this.returnCode = 0;
        } else {
            String errorMessage = "" + this.inBuffer[0];
            errorMessage = errorMessage + this.receiveNullTerminatedString(200);
            if (this.returnCode != 0) {
                return this.returnCode;
            }
            if (this.isTrace()) {
                AConnect.trace("initializeServer:  Error message returned by server...");
            }
            this.showDialog(HEADER_MSG_ERR, errorMessage);
            this.returnCode = -5;
        }
        return this.returnCode;
    }

    private static void encrypt(StringBuffer rec, int size, long key) {
        int offset = 0;
        while (size != 0) {
            char ch = (char)((long)rec.charAt(offset) + key & 0xFFL);
            rec.setCharAt(offset, ch);
            ++offset;
            key += 7L;
            --size;
        }
    }

    private static void decrypt(StringBuffer rec, int size, long key) {
        int offset = 0;
        while (size != 0) {
            char ch = (char)((long)rec.charAt(offset) - key & 0xFFL);
            rec.setCharAt(offset, ch);
            ++offset;
            key += 7L;
            --size;
        }
    }

    private void shufflePassword(StringBuffer shuf, StringBuffer pass, int dir) {
        if (dir != 0) {
            long curtime = System.currentTimeMillis();
            curtime &= 0x79ABCDEFL;
            if (this.isTrace()) {
                AConnect.trace("shufflePassword:  Encrypting, curtime=" + curtime);
            }
            if (this.isTrace()) {
                AConnect.trace("shufflePassword:  Password before encryption='" + pass + "'");
            }
            for (int ii = pass.length(); ii < 8; ++ii) {
                pass.append('\u0000');
            }
            AConnect.encrypt(pass, 8, curtime);
            if (this.isTrace()) {
                AConnect.trace("shufflePassword:  Password after encryption='" + pass + "'");
            }
            shuf.append(pass.charAt(5));
            shuf.append((char)(curtime & 0xFFL));
            shuf.append(pass.charAt(0));
            shuf.append(pass.charAt(7));
            shuf.append((char)((curtime & 0xFFFFFFFFFF000000L) >> 24));
            shuf.append(pass.charAt(3));
            shuf.append(pass.charAt(1));
            shuf.append((char)((curtime & 0xFF00L) >> 8));
            shuf.append(pass.charAt(6));
            shuf.append(pass.charAt(2));
            shuf.append((char)((curtime & 0xFF0000L) >> 16));
            shuf.append(pass.charAt(4));
            return;
        }
        long curtime = (long)shuf.charAt(1) & 0xFFL | ((long)shuf.charAt(7) & 0xFFL) << 8 | ((long)shuf.charAt(10) & 0xFFL) << 16 | ((long)shuf.charAt(4) & 0xFFL) << 24;
        if (this.isTrace()) {
            AConnect.trace("shufflePassword:  Decrypting, curtime=" + curtime);
        }
        pass.append(shuf.charAt(2));
        pass.append(shuf.charAt(6));
        pass.append(shuf.charAt(9));
        pass.append(shuf.charAt(5));
        pass.append(shuf.charAt(11));
        pass.append(shuf.charAt(0));
        pass.append(shuf.charAt(8));
        pass.append(shuf.charAt(3));
        if (this.isTrace()) {
            AConnect.trace("shufflePassword:  Encrypted password before decryption='" + pass + "'");
        }
        AConnect.decrypt(pass, 8, curtime);
        if (this.isTrace()) {
            AConnect.trace("shufflePassword:  Password after decryption='" + pass + "'");
        }
    }

    private String getPasswordFromUser(String title, String message) {
        if (this.context != null) {
            Variable checkVariable = new Variable("XXXXXXXXXX");
            String password = (checkVariable = checkVariable.setExternal(this.context, "ACU-CLIENT-PASSWORD")).toString();
            if (password != null && !"XXXXXXXXXX".equalsIgnoreCase(password)) {
                return password;
            }
        }
        return Dialog.showInputDialog(title, message, 20, true);
    }

    private int login() {
        if (this.isTrace()) {
            AConnect.trace("login:  Attempting to login...");
        }
        this.returnCode = 0;
        int lenCommand = 5;
        lenCommand += 4;
        String pntUser = RuntimeEnvironment.getGlobalParameter("USERNAME");
        if (pntUser == null) {
            pntUser = RuntimeEnvironment.getGlobalParameter(USER);
        }
        if (pntUser == null) {
            try {
                pntUser = System.getProperty("user.name");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pntUser == null) {
            pntUser = USER;
        }
        if (this.isTrace()) {
            AConnect.trace("login:  Username='" + pntUser + "'");
        }
        lenCommand += pntUser.length();
        String localHostName = null;
        lenCommand += 4;
        String explicitHost = RuntimeEnvironment.getGlobalParameter("LOCALHOST");
        if (explicitHost != null) {
            localHostName = explicitHost;
        } else {
            InetAddress localHost2;
            try {
                localHost2 = InetAddress.getLocalHost();
                localHostName = localHost2.getHostName();
            }
            catch (Exception localHost2) {
                // empty catch block
            }
            if (localHostName == null) {
                try {
                    localHost2 = InetAddress.getLocalHost();
                    localHostName = localHost2.getHostAddress();
                }
                catch (Exception localHost3) {
                    // empty catch block
                }
            }
            if (localHostName == null) {
                localHostName = "127.0.0.1";
            }
        }
        if (this.isTrace()) {
            AConnect.trace("login:  Local host name='" + localHostName + "'");
        }
        int offset = 0;
        this.outBuffer[offset++] = 1;
        this.putLongInBuffer(offset, lenCommand += localHostName.length());
        offset += 4;
        if (pntUser != null) {
            this.putLongInBuffer(offset, pntUser.length());
            this.putStringInBuffer(offset += 4, pntUser);
            offset += pntUser.length();
        }
        if (localHostName.length() > 0) {
            this.putLongInBuffer(offset, localHostName.length());
            this.putStringInBuffer(offset += 4, localHostName);
            offset += localHostName.length();
        } else {
            this.putLongInBuffer(offset, 0);
            offset += 4;
        }
        this.bytesInOutBuffer = lenCommand;
        this.sendBytes();
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        this.receiveBytes(1);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        if (this.inBuffer[0] == 8 || this.inBuffer[0] == 0) {
            if (this.isTrace()) {
                AConnect.trace("login:  Successful!");
            }
            this.returnCode = 0;
        } else if (this.inBuffer[0] == 14) {
            if (this.isTrace()) {
                AConnect.trace("login:  Requires password...");
            }
            int attemptCount = 0;
            do {
                ++attemptCount;
                if (this.isTrace()) {
                    AConnect.trace("login:  Password attempt: " + attemptCount);
                }
                offset = 0;
                this.outBuffer[0] = 14;
                ++offset;
                if (password == null || attemptCount > 1) {
                    String message;
                    String title = attemptCount > 1 ? "Invalid password" : "Password required to connect to " + this.getHost() + ".";
                    password = this.getPasswordFromUser(title, message = "Please enter password: ");
                    if (password == null) {
                        password = "";
                    }
                    if (this.isTrace()) {
                        AConnect.trace("login:  Password='" + password + "'");
                    }
                    StringBuffer pwdEncrypt = new StringBuffer();
                    this.shufflePassword(pwdEncrypt, new StringBuffer(password), 1);
                    password = pwdEncrypt.toString();
                    password = password + "\u0000";
                    while (password.length() < 12) {
                        password = password + "                    ";
                    }
                    if (password.length() > 12) {
                        password = password.substring(0, 12);
                    }
                }
                if (this.isTrace()) {
                    AConnect.trace("login:  Encrypted password='" + password + "', length=" + password.length());
                }
                this.putStringInBuffer(1, password);
                this.bytesInOutBuffer = offset += password.length();
                this.sendBytes();
                if (this.returnCode != 0) {
                    return this.returnCode;
                }
                this.receiveBytes(1);
                if (this.returnCode == 0) continue;
                return this.returnCode;
            } while (this.returnCode == 0 && this.inBuffer[0] == 14);
            if (this.returnCode == 0) {
                if (this.inBuffer[0] == 15) {
                    if (this.isTrace()) {
                        AConnect.trace("login:  Invalid user or password, or password attempts exceeded!");
                    }
                    this.returnCode = -7;
                } else if (this.isTrace()) {
                    AConnect.trace("login:  Password was accepted...");
                }
            }
        } else if (this.inBuffer[0] == 15) {
            if (this.isTrace()) {
                AConnect.trace("login:  Invalid user or password!");
            }
            this.returnCode = -7;
        } else {
            if (this.isTrace()) {
                AConnect.trace("login:  Error message received from server...");
            }
            String errorMessage = "" + (char)(this.inBuffer[0] & 0xFF);
            errorMessage = errorMessage + this.receiveNullTerminatedString(200);
            if (this.returnCode != 0) {
                return this.returnCode;
            }
            this.showDialog("AcuConnect", errorMessage);
            this.returnCode = -7;
        }
        return this.returnCode;
    }

    public static int strchr(String buff, char initChar) {
        return AConnect.strchr(buff, 0, initChar);
    }

    public static int strchr(String buff, int offset, char initChar) {
        if (offset < 0) {
            return -1;
        }
        while (offset >= 0 && offset < buff.length() && buff.charAt(offset) != '\u0000' && buff.charAt(offset) != initChar) {
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(String buff, int offset, char[] chars) {
        char c;
        if (offset < 0) {
            return -1;
        }
        while (offset < buff.length() && (c = buff.charAt(offset)) != '\u0000') {
            int i;
            for (i = 0; i < chars.length && c != chars[i]; ++i) {
            }
            if (i != chars.length) continue;
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(StringBuffer buff, int offset, char initChar) {
        while (offset >= 0 && offset < buff.length() && buff.charAt(offset) != '\u0000' && buff.charAt(offset) != initChar) {
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(StringBuffer buff, int offset, char[] chars) {
        char c;
        if (offset < 0) {
            return -1;
        }
        while (offset < buff.length() && (c = buff.charAt(offset)) != '\u0000') {
            int i;
            for (i = 0; i < chars.length && c != chars[i]; ++i) {
            }
            if (i != chars.length) continue;
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strstr(String buff, int offset, String initString) {
        if (offset < 0) {
            return -1;
        }
        int nullOffset = buff.substring(offset).indexOf(0);
        int strOffset = buff.substring(offset).indexOf(initString);
        if (nullOffset < 0 || strOffset < 0) {
            return strOffset;
        }
        if (nullOffset < strOffset) {
            return -1;
        }
        return strOffset;
    }

    private String getSubstring(String text, int offset) {
        if (text == null) {
            return null;
        }
        int start = offset;
        while (offset < text.length() && text.charAt(offset) != '\u0000') {
            ++offset;
        }
        if (offset == start) {
            return text;
        }
        if (offset == text.length()) {
            return text.substring(start);
        }
        return text.substring(start, offset);
    }

    public String readConfigFile(String fileString, String configString) {
        if (fileString == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(fileString);
        char initChar = '*';
        char[] chars = new char[2];
        boolean tappo = false;
        int offset = 0;
        int offsetEnd = 0;
        int offsetBlk = 0;
        chars[0] = 42;
        chars[1] = 64;
        int result = -1;
        while ((offset = AConnect.strchr(buff, offset, initChar)) >= 0) {
            offsetEnd = ++offset;
            result = AConnect.strchr(buff, offsetEnd, ':');
            if ((offsetEnd = result) > 0) {
                buff.setCharAt(offsetEnd - 1, '\u0000');
                offset = ++offsetEnd;
            }
            if ((offsetEnd = (result = AConnect.strchr(buff, offsetEnd, chars))) < 0 || offsetEnd >= buff.length() || buff.charAt(offsetEnd) == '\u0000') {
                tappo = true;
            } else {
                buff.setCharAt(--offsetEnd, '\u0000');
            }
            if (offset < 0 || offset >= buff.length() || buff.charAt(offset) == '\u0000') continue;
            for (offsetBlk = offsetEnd - 1; offsetBlk >= 0 && (buff.charAt(offsetBlk) == ' ' || buff.charAt(offsetBlk) == '\t'); --offsetBlk) {
                buff.setCharAt(offsetBlk, '\u0000');
            }
            if (configString != null) {
                String cString = this.getSubstring(buff.toString(), offset);
                if (this.isTrace()) {
                    AConnect.trace("configString=" + configString + ", cString=" + cString);
                }
                if (!configString.equals(cString)) {
                    configString = null;
                }
            }
            configString = this.getSubstring(buff.toString(), offset);
            if (this.isTrace()) {
                AConnect.trace("configString=" + configString);
            }
            if (tappo) {
                offset = offsetEnd;
                continue;
            }
            offset = ++offsetEnd;
        }
        return configString;
    }

    private void readConfigPath(String configFile) {
        String configString = this.readConfigFile(configFile, this.getConfigPath());
        if (this.isTrace()) {
            AConnect.trace("readConfigPath:  Config path = '" + configString + "'");
        }
        if (configString != null) {
            this.setConfigPath(configString);
        }
    }

    private void readRTSFlags(String configFile) {
        String configString = this.readConfigFile(configFile, this.getRTSFlags());
        if (this.isTrace()) {
            AConnect.trace("readRTSFlags:  RTS flags = '" + configString + "'");
        }
        if (configString != null) {
            this.setRTSFlags(configString);
        }
    }

    private void readConfig() {
        String cfgFile = RuntimeEnvironment.getGlobalParameter(KEY_CFG_FILE);
        if (cfgFile != null) {
            if (this.isTrace()) {
                AConnect.trace("readConfig:  Calling readConfigPath(" + cfgFile + ")");
            }
            this.readConfigPath(cfgFile);
        }
        if ((cfgFile = RuntimeEnvironment.getGlobalParameter(KEY_RTS_FLAGS)) != null) {
            if (this.isTrace()) {
                AConnect.trace("readConfig:  Calling readRTSFlags(" + cfgFile + ")");
            }
            this.readRTSFlags(cfgFile);
        }
        int offset = 0;
        int offsetStart = 0;
        boolean closeAfterCancel = false;
        cfgFile = RuntimeEnvironment.getGlobalParameter(KEY_CLAFCA);
        if (cfgFile != null) {
            if (this.isTrace()) {
                AConnect.trace("readConfig:  Close after cancel string = '" + cfgFile + "'");
            }
            int val = 0;
            String valString = this.getSubstring(cfgFile, 0);
            if (valString != null) {
                try {
                    val = Integer.valueOf(valString);
                }
                catch (Exception exception) {}
            } else {
                valString = "";
            }
            if (val == 1) {
                closeAfterCancel = true;
            } else {
                offsetStart = offset = 0;
                StringBuffer text = new StringBuffer(cfgFile);
                while (offset < text.length() && text.charAt(offset) != '\u0000' && text.charAt(offset) != ' ' && cfgFile.charAt(offset) != '\t') {
                    text.setCharAt(offset, Character.toUpperCase(text.charAt(offset)));
                    ++offset;
                }
                cfgFile = text.toString();
                if (AConnect.strstr(cfgFile, offsetStart, "YES") >= 0) {
                    closeAfterCancel = true;
                }
            }
        }
        if (this.isTrace()) {
            AConnect.trace("readConfig:  Setting close after cancel to " + closeAfterCancel);
        }
        this.setCloseAfterCancel(closeAfterCancel);
        int serverPort = 6996;
        offset = 0;
        cfgFile = RuntimeEnvironment.getGlobalParameter(KEY_SERVER_PORT);
        if (cfgFile != null) {
            if (this.isTrace()) {
                AConnect.trace("readConfig:  Server port string = '" + cfgFile + "'");
            }
            int val = 0;
            String valString = this.getSubstring(cfgFile, 0);
            if (valString != null) {
                try {
                    val = Integer.valueOf(valString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (val > 0) {
                    serverPort = val;
                }
            }
        }
        if (this.isTrace()) {
            AConnect.trace("readConfig:  Setting server port to: " + serverPort);
        }
        this.setPort(serverPort);
        if (this.isTrace()) {
            AConnect.trace("readConfig:  Returning...");
        }
    }

    private boolean initSocketConnection(String hostName) {
        if (this.isTrace()) {
            AConnect.trace("initSocketConnection:  hostName=" + hostName);
        }
        this.returnCode = 0;
        if (!this.isConnected()) {
            if (hostName == null) {
                this.returnCode = -6;
                return false;
            }
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Setting host to: '" + hostName + "'");
            }
            this.setHost(hostName);
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Calling readConfig()...");
            }
            this.readConfig();
            if (this.returnCode != 0) {
                return false;
            }
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Calling connect()...");
            }
            this.connect();
            if (this.returnCode != 0) {
                return false;
            }
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Calling sendConfigPath()...");
            }
            this.sendConfigPath();
            if (this.returnCode != 0) {
                this.disconnect();
                return false;
            }
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Calling initializeServer()...");
            }
            this.initializeServer("FILE_ACCESS");
            if (this.returnCode != 0) {
                this.disconnect();
                return false;
            }
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Calling login()...");
            }
            this.login();
            if (this.returnCode != 0) {
                this.disconnect();
                return false;
            }
            if (this.isTrace()) {
                AConnect.trace("initSocketConnection:  Success!");
            }
            return true;
        }
        return true;
    }

    private int handleSendAndReceive(PARAM_G_INFO[] args) {
        int errno_index = args.length - 3;
        args[errno_index] = new PARAM_G_INFO();
        args[errno_index + 1] = new PARAM_G_INFO();
        args[errno_index + 2] = new PARAM_G_INFO();
        this.storeErrno(args, errno_index, this.f_no_lock, 0, 0);
        if (this.sendAndReceive(args, 128) != 0) {
            if (this.isTrace()) {
                AConnect.trace("handleSendAndReceive:  Error:  returnCode=" + this.returnCode);
            }
            return 0;
        }
        this.restoreErrno(args, errno_index);
        return this.functionReturnCode;
    }

    public boolean isLittleEndian() {
        return RuntimeEnvironment.isLittleEndian();
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public void setTrace(boolean flag) {
        this.isTrace = flag;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getErrno() {
        return this.errno;
    }

    public int getIntErrno() {
        return this.int_errno;
    }

    public int getInt2Errno() {
        return this.int2_errno;
    }

    public int getF_NO_LOCK() {
        return this.f_no_lock;
    }

    public void setF_NO_LOCK(int val) {
        this.f_no_lock = val;
    }

    public static final String getHostnameFromString(String text) {
        String[] result = AConnect.getHostnameAndFilenameFromString(text);
        if (result == null) {
            return null;
        }
        return result[0];
    }

    public static final String getFilenameFromString(String text) {
        String[] result = AConnect.getHostnameAndFilenameFromString(text);
        if (result == null) {
            return null;
        }
        return result[1];
    }

    public static final String convertBackslashesToForwardSlashes(String n) {
        int offset = 0;
        int offsetN = 0;
        StringBuffer buff = new StringBuffer(n);
        while ((offset = AConnect.strchr(buff, offsetN, '\\')) >= 0) {
            buff.setCharAt(offset, '/');
            offsetN = offset;
        }
        return buff.toString();
    }

    public static final String[] getHostnameAndFilenameFromString(String text) {
        if (text == null) {
            return null;
        }
        String[] result = new String[2];
        String path = text;
        String hostName = null;
        int offset = AConnect.strchr(path = AConnect.convertBackslashesToForwardSlashes(path), 0, ':');
        if (offset > 1) {
            hostName = path.substring(1, offset);
        } else if (offset >= 0) {
            hostName = null;
        }
        if (offset >= 0 && offset < path.length() - 1) {
            path = path.substring(offset + 1);
        }
        result[0] = hostName;
        result[1] = path;
        return result;
    }

    public int i_abilities(Object a) {
        this.returnCode = 0;
        return this.returnCode;
    }

    public int i_begin() {
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483579);
        PARAM_G_INFO[] args = new PARAM_G_INFO[4];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_close(IFilePtr rf) {
        if (rf == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483598);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        PARAM_G_INFO[] args = new PARAM_G_INFO[5];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_commit(int context) {
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483578);
        byte[] argContext = new byte[2];
        this.htonsp(argContext, context);
        PARAM_G_INFO[] args = new PARAM_G_INFO[5];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argContext, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_copy(String fromname, String toname) {
        if (fromname == null || toname == null) {
            return 2;
        }
        this.returnCode = 0;
        String[] result = AConnect.getHostnameAndFilenameFromString(fromname);
        if (result == null) {
            return 2;
        }
        String fromHostName = result[0];
        fromname = result[1];
        result = AConnect.getHostnameAndFilenameFromString(toname);
        if (result == null) {
            return 2;
        }
        toname = result[1];
        if (!this.isConnected() && !this.initSocketConnection(fromHostName)) {
            return this.returnCode;
        }
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483585);
        PARAM_G_INFO[] args = new PARAM_G_INFO[6];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(fromname, 16, 0, 0, 3);
        args[2] = new PARAM_G_INFO(toname, 16, 0, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_delete(IFilePtr rf, byte[] record) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_delete(rf, record, 0, record.length);
    }

    public int i_delete(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483592);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        PARAM_G_INFO[] args = new PARAM_G_INFO[6];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_execute(String sys, String cmd) {
        this.returnCode = 0;
        return this.returnCode;
    }

    public int i_exit() {
        this.AcuConnectSendEnd();
        return this.returnCode == 0 ? 1 : 0;
    }

    public int i_info(IFilePtr rf, int mode, StringBuffer result) {
        if (result == null || rf == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483590);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        byte[] argMode = new byte[2];
        this.htonsp(argMode, mode);
        int lenResult = 0;
        switch (mode) {
            case -1: {
                lenResult = 17;
                break;
            }
            case -2: {
                lenResult = 17;
                break;
            }
            case -3: {
                lenResult = 30;
                break;
            }
            case -4: {
                lenResult = 10;
                break;
            }
            case -5: {
                lenResult = 256;
                break;
            }
            default: {
                lenResult = 165;
            }
        }
        byte[] buffinfo = new byte[lenResult];
        PARAM_G_INFO[] args = new PARAM_G_INFO[7];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(argMode, 12, 4, 0, 3);
        args[3] = new PARAM_G_INFO(buffinfo, 16, 0, 0, 3);
        if (this.handleSendAndReceive(args) == 0) {
            return 0;
        }
        String buffinfoString = this.getStringFromBytes(buffinfo);
        int offset = -1;
        String charNumSeg = null;
        int numSeg = 0;
        if (mode >= 0 && (offset = AConnect.strchr(buffinfoString, 0, ',')) >= 0) {
            charNumSeg = buffinfoString.substring(0, offset);
            try {
                numSeg = Integer.valueOf(charNumSeg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            lenResult = 5 + 10 * numSeg;
        }
        StringBuffer filename = new StringBuffer();
        StringBuffer file_version = new StringBuffer();
        StringBuffer int_version = new StringBuffer();
        this.i_version(filename, file_version, int_version, 0);
        String file_versionString = file_version.toString();
        int fileVersion = 0;
        try {
            fileVersion = Integer.valueOf(file_versionString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mode >= 0 && fileVersion <= 3) {
            result.setLength(0);
            try {
                result.append(buffinfoString.substring(1, lenResult - 1));
            }
            catch (Exception e) {
                result.append(buffinfoString.substring(1));
            }
        } else {
            result.setLength(0);
            try {
                result.append(buffinfoString.substring(0, lenResult));
            }
            catch (Exception e) {
                result.append(buffinfoString);
            }
        }
        return 1;
    }

    public int i_init() {
        this.returnCode = 0;
        return this.returnCode;
    }

    public int i_make(String filename, String comment, String physical_params, String logical_params, String keys, String transTable) {
        String[] result;
        if (filename == null || filename.trim().length() == 0 || keys == null) {
            return 2;
        }
        this.bytesInOutBuffer = 0;
        this.returnCode = 0;
        if (this.isTrace()) {
            AConnect.trace("i_make:  filename='" + filename + "', comment='" + comment + "', physical_params='" + physical_params + "', logical_params='" + logical_params + "', keys='" + keys + "', transTable='" + transTable + "'");
        }
        if ((result = AConnect.getHostnameAndFilenameFromString(filename)) == null) {
            return 2;
        }
        String hostName = result[0];
        filename = result[1];
        if (!this.isConnected() && !this.initSocketConnection(hostName)) {
            return this.returnCode;
        }
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483600);
        PARAM_G_INFO[] args = new PARAM_G_INFO[10];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 1);
        args[1] = new PARAM_G_INFO(filename, 16, 0, 0, 1);
        args[2] = new PARAM_G_INFO(comment, 16, 0, 0, 1);
        args[3] = new PARAM_G_INFO(physical_params, 16, 0, 0, 1);
        args[4] = new PARAM_G_INFO(logical_params, 16, 0, 0, 1);
        args[5] = new PARAM_G_INFO(keys, 16, 0, 0, 1);
        args[6] = new PARAM_G_INFO(transTable, 16, 0, 0, 1);
        return this.handleSendAndReceive(args);
    }

    public int i_next(IFilePtr rf, byte[] record) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_next(rf, record, 0, record.length);
    }

    public int i_next(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483596);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        PARAM_G_INFO[] args = new PARAM_G_INFO[6];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public IFilePtr i_open(String filename, int mode, String logical_params) {
        String[] result;
        if (filename == null) {
            this.errno = 2;
            return null;
        }
        this.bytesInOutBuffer = 0;
        int recSize = 0;
        this.returnCode = 0;
        if (this.isTrace()) {
            AConnect.trace("i_open:  filename='" + filename + "', mode='" + mode + "', logical_params='" + logical_params + "'");
        }
        if ((result = AConnect.getHostnameAndFilenameFromString(filename)) == null) {
            this.errno = 2;
            return null;
        }
        String hostName = result[0];
        filename = result[1];
        if (!this.isConnected() && !this.initSocketConnection(hostName)) {
            return null;
        }
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483599);
        byte[] argMode = new byte[2];
        this.htonsp(argMode, mode);
        byte[] argRecsize = new byte[4];
        this.htonlp(argRecsize, recSize);
        PARAM_G_INFO[] args = new PARAM_G_INFO[8];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(filename, 16, 0, 0, 3);
        args[2] = new PARAM_G_INFO(argMode, 11, 4, 0, 3);
        args[3] = new PARAM_G_INFO(logical_params, 16, 0, 0, 3);
        args[4] = new PARAM_G_INFO(argRecsize, 12, 9, 0, 3);
        this.handleSendAndReceive(args);
        recSize = this.pntohl(args[4].getAddressBytes());
        if (this.isTrace()) {
            AConnect.trace("i_open:  Done, now creating fileptr, errno=" + this.errno);
        }
        IFilePtr fp = null;
        if (this.errno == 0) {
            fp = new IFilePtr(filename, false, this.functionReturnCode, recSize, recSize + 40 + 1);
        }
        return fp;
    }

    public int i_previous(IFilePtr rf, byte[] record) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_previous(rf, record, 0, record.length);
    }

    public int i_previous(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483595);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        PARAM_G_INFO[] args = new PARAM_G_INFO[6];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_read(IFilePtr rf, byte[] record, int keynum) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_read(rf, record, 0, record.length, keynum);
    }

    public int i_read(IFilePtr rf, byte[] record, int offset, int length, int keynum) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483597);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        byte[] argKeynum = new byte[2];
        this.htonsp(argKeynum, keynum);
        PARAM_G_INFO[] args = new PARAM_G_INFO[7];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        args[3] = new PARAM_G_INFO(argKeynum, 12, 4, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_recover() {
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483576);
        PARAM_G_INFO[] args = new PARAM_G_INFO[4];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_remove(String filename) {
        if (filename == null) {
            return 2;
        }
        this.returnCode = 0;
        String[] result = AConnect.getHostnameAndFilenameFromString(filename);
        if (result == null) {
            return 2;
        }
        String hostName = result[0];
        filename = result[1];
        if (!this.isConnected() && !this.initSocketConnection(hostName)) {
            return this.returnCode;
        }
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483588);
        PARAM_G_INFO[] args = new PARAM_G_INFO[5];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(filename, 16, 0, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_rename(String fromname, String toname) {
        if (fromname == null || toname == null) {
            return 2;
        }
        this.returnCode = 0;
        String[] result = AConnect.getHostnameAndFilenameFromString(fromname);
        if (result == null) {
            return 2;
        }
        String fromHostName = result[0];
        fromname = result[1];
        result = AConnect.getHostnameAndFilenameFromString(toname);
        if (result == null) {
            return 2;
        }
        toname = result[1];
        if (!this.isConnected() && !this.initSocketConnection(fromHostName)) {
            return this.returnCode;
        }
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483586);
        PARAM_G_INFO[] args = new PARAM_G_INFO[6];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(fromname, 16, 0, 0, 3);
        args[2] = new PARAM_G_INFO(toname, 16, 0, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_rewrite(IFilePtr rf, byte[] record, int size) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_rewrite(rf, record, 0, record.length, size);
    }

    public int i_rewrite(IFilePtr rf, byte[] record, int offset, int length, int size) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483593);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        byte[] argSize = new byte[2];
        this.htonsp(argSize, size);
        PARAM_G_INFO[] args = new PARAM_G_INFO[7];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        args[3] = new PARAM_G_INFO(argSize, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_rollback(int context) {
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483577);
        byte[] argContext = new byte[2];
        this.htonsp(argContext, context);
        PARAM_G_INFO[] args = new PARAM_G_INFO[5];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argContext, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_start(IFilePtr rf, byte[] record, int keynum, int keysize, int mode) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_start(rf, record, 0, record.length, keynum, keysize, mode);
    }

    public int i_start(IFilePtr rf, byte[] record, int offset, int length, int keynum, int keysize, int mode) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483591);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        byte[] argKeynum = new byte[2];
        this.htonsp(argKeynum, keynum);
        byte[] argKeysize = new byte[2];
        this.htonsp(argKeysize, keysize);
        byte[] argMode = new byte[2];
        this.htonsp(argMode, mode);
        PARAM_G_INFO[] args = new PARAM_G_INFO[9];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        args[3] = new PARAM_G_INFO(argKeynum, 12, 4, 0, 3);
        args[4] = new PARAM_G_INFO(argKeysize, 12, 4, 0, 3);
        args[5] = new PARAM_G_INFO(argMode, 12, 4, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public void i_sync(int all_files) {
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483587);
        byte[] argAllFiles = new byte[2];
        this.htonsp(argAllFiles, all_files);
        PARAM_G_INFO[] args = new PARAM_G_INFO[5];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argAllFiles, 12, 9, 0, 3);
        this.handleSendAndReceive(args);
    }

    public int i_unlock(IFilePtr rf) {
        if (rf == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483584);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        PARAM_G_INFO[] args = new PARAM_G_INFO[5];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    public int i_version(StringBuffer filename, StringBuffer file_version, StringBuffer int_version, int system_num) {
        this.returnCode = 0;
        try {
            filename.setLength(0);
            filename.append("AcuConnect client");
            file_version.setLength(0);
            file_version.append("1.0.0");
            int_version.setLength(0);
            int_version.append("1");
            return 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int i_write(IFilePtr rf, byte[] record, int size) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_write(rf, record, 0, record.length, size);
    }

    public int i_write(IFilePtr rf, byte[] record, int offset, int length, int size) {
        if (rf == null || record == null) {
            return 2;
        }
        this.returnCode = 0;
        byte[] argNameCFun = new byte[4];
        this.htonlp(argNameCFun, -2147483594);
        byte[] argIfp = new byte[4];
        this.htonlp(argIfp, rf.getFileDescriptor());
        byte[] argSize = new byte[2];
        this.htonsp(argSize, size);
        PARAM_G_INFO[] args = new PARAM_G_INFO[7];
        args[0] = new PARAM_G_INFO(argNameCFun, 12, 9, 0, 3);
        args[1] = new PARAM_G_INFO(argIfp, 12, 9, 0, 3);
        args[2] = new PARAM_G_INFO(record, offset, length, 16, 0, 0, 3);
        args[3] = new PARAM_G_INFO(argSize, 12, 9, 0, 3);
        return this.handleSendAndReceive(args);
    }

    private int AcuConnectSendRecv(PARAM_G_INFO[] args, String nameHost) {
        this.returnCode = -1;
        if (!this.isConnected() && !this.initSocketConnection(nameHost)) {
            return 25;
        }
        int type = 2;
        this.allocBufferC(args, type);
        this.sendHost(args, type);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        this.receiveHost(args, type);
        if (this.returnCode != 0 && this.returnCode != -1 && this.returnCode != -3 && this.returnCode != -5) {
            this.AcuConnectSendEnd();
            this.removeAllCallNames();
        }
        return this.returnCode;
    }

    private int AcuConnectSendAsync(PARAM_G_INFO[] args, String nameHost) {
        this.returnCode = -1;
        args[0].setAddressBytes(new byte[4]);
        if (!this.isConnected() && !this.initSocketConnection(nameHost)) {
            this.removeAllCallNames();
            return 25;
        }
        int type = 7;
        this.allocBufferC(args, type);
        byte[] handle = new byte[4];
        int hash = this.hashCode();
        this.intToBytes(handle, hash);
        args[0].setAddressBytes(handle);
        this.sendHost(args, type);
        if (this.returnCode != 0) {
            return this.returnCode;
        }
        this.receiveBytes(1);
        if (this.returnCode != -3) {
            if (this.inBuffer[0] == 8) {
                this.returnCode = 0;
            } else if (this.inBuffer[0] == 12) {
                this.returnCode = -1;
            }
            if (this.returnCode == -1) {
                this.removeAllCallNames();
                args[0].setAddressBytes(new byte[4]);
            }
        }
        return this.returnCode;
    }

    private int async_run_body(String name, PARAM_G_INFO[] args, int initial) {
        this.returnCode = 0;
        int nameCall = AConnect.strchr(name, ':');
        String nameHost = null;
        if (name.charAt(0) == '*' && nameCall != 0) {
            nameHost = name.substring(1, nameCall);
            ++nameCall;
        } else {
            nameCall = 0;
        }
        String nameCallString = name.substring(nameCall);
        if (nameHost != null) {
            args[1].setAddressString(nameCallString);
            args[1].setLength(nameCallString.length());
            this.returnCode = this.AcuConnectSendAsync(args, nameHost);
            if (this.returnCode == -5 || this.returnCode == -3 || this.returnCode == 5 || this.returnCode == -7) {
                this.returnCode = -2;
            }
        }
        return this.returnCode;
    }

    private int async_run(String name, PARAM_G_INFO[] args, int initial) {
        int pntS;
        if (name == null) {
            return -1;
        }
        String codeSuffix = this.getCodeSuffix();
        this.returnCode = -1;
        boolean applyCodeSuffix = true;
        for (pntS = name.length() - 1; pntS > 0 && name.charAt(pntS) != '\\' && name.charAt(pntS) != '/'; --pntS) {
        }
        int pntPoint = 0;
        if (pntS > 0) {
            pntPoint = name.lastIndexOf(".");
            if (pntPoint > 0 && pntPoint > pntS) {
                applyCodeSuffix = false;
            }
        } else {
            pntPoint = name.lastIndexOf(".");
            if (pntPoint > 0) {
                applyCodeSuffix = false;
            }
        }
        String fullPath = null;
        this.returnCode = -1;
        if (applyCodeSuffix) {
            if (codeSuffix != null) {
                fullPath = name + codeSuffix;
                AConnect con = AConnect.getProgramByName(this.context, fullPath);
                if (con != null) {
                    this.returnCode = con.async_run_body(fullPath, args, initial);
                    if (this.returnCode == -1) {
                        con.removeCallName(fullPath);
                    }
                }
            } else {
                fullPath = name + codeSuffixDefault;
                AConnect con = AConnect.getProgramByName(this.context, fullPath);
                if (con != null) {
                    this.returnCode = con.async_run_body(fullPath, args, initial);
                }
                if (this.returnCode == -1) {
                    if (con != null) {
                        con.removeCallName(fullPath);
                    }
                    if ((con = AConnect.getProgramByName(this.context, fullPath = fullPath.substring(0, fullPath.length() - codeSuffixDefault.length()))) != null) {
                        this.returnCode = con.async_run_body(fullPath, args, initial);
                        if (this.returnCode == -1) {
                            con.removeCallName(fullPath);
                        }
                    }
                }
            }
        } else {
            AConnect con = AConnect.getProgramByName(this.context, name);
            if (con != null) {
                this.returnCode = con.async_run_body(name, args, initial);
                if (this.returnCode == -1) {
                    con.removeCallName(name);
                }
            }
        }
        return this.returnCode;
    }

    private int AcuConnectSendPoll() {
        this.returnCode = 0;
        this.outBuffer[0] = 10;
        this.bytesInOutBuffer = 1;
        this.sendBytes();
        if (this.returnCode != -3) {
            this.inBuffer[0] = 0;
            this.receiveBytes(1);
            if (this.returnCode != -3) {
                this.returnCode = this.inBuffer[0];
            }
        }
        return this.returnCode;
    }

    private String receiveErrorMessage() {
        this.receiveBytes(4);
        if (this.returnCode == -3) {
            return null;
        }
        if (this.bytesInInBuffer != 4) {
            return null;
        }
        int size = this.pntohl(this.inBuffer);
        if (size <= 0) {
            return null;
        }
        this.receiveBytes(size);
        if (this.returnCode == -3) {
            return null;
        }
        if (this.bytesInInBuffer != size) {
            return null;
        }
        return this.getStringFromBuffer(0, size);
    }

    private int AcuConnectPoll(PARAM_G_INFO[] args) {
        this.returnCode = -1;
        this.returnCode = this.AcuConnectSendPoll();
        switch (this.returnCode) {
            case 8: {
                this.allocBufferC(args, 7);
                this.returnCode = this.receiveHost(args, 7);
                if (this.returnCode != -3 && this.returnCode != -5 && this.returnCode != 0 && this.returnCode != -1) {
                    String errorMsg = "Error:  returnCode=" + this.returnCode;
                    int errorOffset = 0;
                    if (this.inBuffer[0] == 64) {
                        errorOffset = 13;
                    }
                    if (this.bytesInInBuffer > errorOffset) {
                        errorMsg = this.getStringFromBuffer(errorOffset, this.bytesInInBuffer - errorOffset);
                    }
                    this.showDialog(HEADER_MSG_ERR, errorMsg);
                }
                this.disconnect();
                args[0].setAddressBytes(new byte[4]);
                args[1].setAddressString("1");
                this.removeAllCallNames();
                break;
            }
            case 11: {
                args[1].setAddressString("0");
                this.returnCode = 0;
                break;
            }
            case 6: {
                args[0].setAddressBytes(new byte[4]);
                args[1].setAddressString("0");
                this.returnCode = -2;
                this.disconnect();
                this.removeAllCallNames();
                break;
            }
            case -3: {
                this.disconnect();
                this.removeAllCallNames();
                break;
            }
            default: {
                String errMsg = this.receiveErrorMessage();
                if (errMsg == null) {
                    return -3;
                }
                this.showDialog(HEADER_MSG_ERR, errMsg);
                this.AcuConnectSendEnd();
                this.removeAllCallNames();
                args[0].setAddressBytes(new byte[4]);
                args[1].setAddressString("J");
                this.returnCode = -5;
            }
        }
        return this.returnCode;
    }

    private int AcuConnectCancel(PARAM_G_INFO[] args) {
        if (args == null || args.length == 0) {
            return -1;
        }
        this.returnCode = -1;
        int type = 13;
        this.allocBufferC(args, type);
        this.returnCode = this.sendHost(args, type);
        if (this.returnCode != -3 && this.getCloseAfterCancel()) {
            this.removeCurrentCallName();
        }
        return this.returnCode;
    }

    public int async_poll(PARAM_G_INFO[] args, int initial) {
        if (args == null || args.length < 2) {
            return -2;
        }
        this.returnCode = 0;
        int handle = 0;
        byte[] handleBytes = args[0].getAddressBytes();
        if (handleBytes != null && handleBytes.length > 3) {
            handle = this.bytesToInt(handleBytes);
        }
        boolean remote2 = true;
        if (handle != 0) {
            AConnect con = AConnect.getConnectionUsingHandle(handle);
            if (con == null) {
                this.showDialog(HEADER_MSG_ERR, "Call C$ASYNCPOLL with pointer NULL");
                args[1].setAddressString("J");
                this.returnCode = -2;
            } else {
                String name = con.getCurrentCallName();
                boolean bl = remote2 = name != null && name.charAt(0) == '*';
                if (remote2) {
                    this.returnCode = con.AcuConnectPoll(args);
                    if (this.returnCode == -5 || this.returnCode == -2 || this.returnCode == 5 || this.returnCode == -7 || this.returnCode == -3) {
                        this.returnCode = -2;
                    }
                }
            }
        } else {
            remote2 = false;
        }
        if (!remote2) {
            args[1].setAddressString("1");
        }
        this.functionReturnCode = this.returnCode;
        return 0;
    }

    public int remoteCall(String name, PARAM_G_INFO[] args) {
        int argsLength = 0;
        if (args != null) {
            argsLength = args.length;
        }
        this.returnCode = 0;
        int nameCall = AConnect.strchr(name, ':');
        String nameHost = null;
        if (name.charAt(0) != '*' || nameCall == 0) {
            return -1;
        }
        nameHost = name.substring(1, nameCall);
        String nameCallString = name.substring(++nameCall);
        try {
            if (nameCallString != null) {
                PARAM_G_INFO[] pgi = new PARAM_G_INFO[argsLength + 1];
                pgi[0] = new PARAM_G_INFO(nameCallString, 16, 0, 0, 3);
                System.arraycopy(args, 0, pgi, 1, args.length);
                this.returnCode = this.AcuConnectSendRecv(pgi, nameHost);
                pgi = null;
            } else {
                this.returnCode = -1;
            }
        }
        catch (Throwable t) {
            CobolException.runtimeError("Error in remote call '" + name + "' (AConnect server).", t);
        }
        if (this.returnCode == -5 || this.returnCode == 5 || this.returnCode == -7 || this.returnCode == -3 || this.returnCode == -4) {
            this.returnCode = -2;
        }
        if (this.returnCode == -1) {
            this.returnCode = -1;
        }
        return this.returnCode;
    }

    public int remoteCancel(String name) {
        if (name == null || name.trim().length() == 0) {
            return -1;
        }
        this.returnCode = 0;
        PARAM_G_INFO[] pgi = new PARAM_G_INFO[]{new PARAM_G_INFO()};
        String nameCallString = null;
        if (name != null) {
            int nameCall = AConnect.strchr(name, ':');
            String nameHost = null;
            if (name.charAt(0) == '*' && nameCall != 0) {
                nameHost = name.substring(1, nameCall);
                ++nameCall;
            } else {
                nameCall = 0;
            }
            nameCallString = name.substring(nameCall);
            if (nameHost != null) {
                pgi[0].setAddressString(nameCallString);
                pgi[0].setLength(nameCallString.length());
            }
        }
        pgi[0].setType(16);
        pgi[0].setDigits(0);
        pgi[0].setScale(0);
        this.returnCode = this.AcuConnectCancel(pgi);
        if (this.returnCode == -3) {
            this.returnCode = -2;
        }
        return this.returnCode;
    }

    public int getCallError() {
        return this.callError;
    }

    public void setCallError(int error) {
        this.callError = error;
    }

    private boolean initializeNative() {
        if (!NativeCall.isSupported()) {
            return false;
        }
        try {
            NativeCall loadDLL = new NativeCall("wrun32.dll");
            loadDLL.call();
        }
        catch (Throwable t) {
            return false;
        }
        this.readConfig();
        NativeCall nc = new NativeCall("AcuInitialize");
        parameterList plist = new parameterList();
        plist.add(this.getRTSFlags());
        int rv = -1;
        try {
            Numeric returnValue = (Numeric)nc.callGiving(plist);
            rv = returnValue.toInt();
        }
        catch (Throwable t) {
            rv = -1;
        }
        if (rv != 0) {
            return false;
        }
        initializedNativeCall = true;
        return true;
    }

    public int cobol(String progName, PARAM_G_INFO[] args) {
        if (args == null || args.length <= 0) {
            return 0;
        }
        if (!initializedNativeCall && !this.initializeNative()) {
            return 0;
        }
        NativeCall nc = new NativeCall("acucobol");
        parameterList plist = new parameterList();
        plist.add(progName);
        for (int i = 1; i < args.length; ++i) {
            Variable v = args[i].getVariableType();
            if (v != null) {
                plist.add(v, false);
                continue;
            }
            plist.add(new Variable(" \u0000"), false);
        }
        Numeric result = null;
        int rv = -1;
        try {
            result = (Numeric)nc.callGiving(plist);
            rv = result.toInt();
        }
        catch (Throwable t) {
            rv = -1;
            this.setCallError(1);
        }
        if (rv == 0) {
            this.setCallError(0);
            return 1;
        }
        this.setCallError(-2);
        return 0;
    }

    public int AcuShutdown() {
        if (initializedNativeCall) {
            NativeCall nc = new NativeCall("AcuShutdown");
            try {
                nc.call();
            }
            catch (Throwable t) {
                return 0;
            }
            initializedNativeCall = false;
        }
        return 1;
    }

    public int AcuCall(String programName, String[] parameters) {
        int i;
        if (!initializedNativeCall && !this.initializeNative()) {
            return 0;
        }
        NativeCall nc = new NativeCall("AcuCall", 0);
        parameterList plist = new parameterList();
        plist.add(programName);
        int paramlen = 0;
        if (parameters != null) {
            paramlen = parameters.length;
            for (i = 0; i < paramlen; ++i) {
                plist.add(parameters[i]);
            }
        }
        for (i = 0; i < 14 - paramlen; ++i) {
            plist.add("");
        }
        Numeric result = null;
        int rv = -1;
        try {
            result = (Numeric)nc.callGiving(plist);
            rv = result.toInt();
            if (rv == -1) {
                result = (Numeric)new NativeCall("AcuGetCallError").callGiving();
            }
        }
        catch (Throwable t) {
            return 0;
        }
        if (rv == 0) {
            return 1;
        }
        return 0;
    }

    public void setCurrentCallName(String name) {
        this.currentCallName = name;
    }

    public String getCurrentCallName() {
        return this.currentCallName;
    }

    public boolean getCallNameExists(String name) {
        if (name == null || this.callNames == null) {
            return false;
        }
        return this.callNames.contains(name);
    }

    public boolean addCallName(String name) {
        if (this.callNames == null) {
            this.callNames = new Vector();
            this.callNames.addElement(name);
            return true;
        }
        if (!this.callNames.contains(name)) {
            this.callNames.addElement(name);
            return true;
        }
        return false;
    }

    public boolean removeCallName(String name) {
        if (this.callNames == null) {
            return false;
        }
        if (this.currentCallName != null && this.currentCallName.equals(name)) {
            this.currentCallName = null;
        }
        boolean result = this.callNames.removeElement(name);
        AConnect.removeConnectionFromTable(name);
        if (this.callNames == null && this.isConnected()) {
            this.AcuConnectSendEnd();
        }
        return result;
    }

    public void removeAllCallNames() {
        while (this.callNames != null && this.callNames.size() > 0) {
            this.removeCallName(this.callNames.elementAt(0));
        }
    }

    public void removeCurrentCallName() {
        if (this.callNames != null) {
            this.removeCallName(this.currentCallName);
        }
    }

    public int getLastCallError() {
        return this.lastReturnCode;
    }

    private void setLastCallError(int val) {
        this.lastReturnCode = val;
    }

    private PARAM_G_INFO[] getArgs(parameterList params) {
        if (params == null) {
            return null;
        }
        PARAM_G_INFO[] args = new PARAM_G_INFO[params.getLength()];
        for (int i = 0; i < args.length; ++i) {
            byte[] bytes = params.getArgument(i);
            int type = params.getArgumentType(i);
            int digits = params.getNumericDigits(i);
            int scale = params.getNumericScale(i);
            args[i] = !params.isByContent(i) ? new PARAM_G_INFO(bytes, type, digits, scale, 3) : new PARAM_G_INFO(bytes, type, digits, scale, 1);
        }
        return args;
    }

    private void updateParamsFromArgs(parameterList params, PARAM_G_INFO[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            byte[] bytes = args[i].getAddressBytes();
            if (!params.byReference(i)) continue;
            params.setArgument(i, bytes);
        }
    }

    private int asyncRunCall(PARAM_G_INFO[] args, int initial) {
        if (args == null || args.length < 2) {
            return -2;
        }
        int result = -1;
        int pntStart = 0;
        int pntEnd = 0;
        boolean tappo = false;
        String sep = "\\";
        try {
            sep = System.getProperty("file.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String programName = args[1].getAddressString();
        ICallableProgram o = Context.getProgramByName(programName, null, -1);
        if (o == null || !(o instanceof AConnect)) {
            return -1;
        }
        AConnect con = (AConnect)o;
        programName = con.getCurrentCallName();
        String codePrefix = this.getCodePrefix();
        if (programName != null && codePrefix == null) {
            if (programName.charAt(0) == '*') {
                result = con.async_run(programName, args, initial);
            } else {
                PARAM_G_INFO[] cobolArgs = new PARAM_G_INFO[args.length - 2];
                System.arraycopy(args, 2, cobolArgs, 0, args.length - 2);
                result = con.call(programName, args);
            }
            if (result == -1) {
                this.removeCallName(programName);
            }
        }
        while (codePrefix != null && result == -1 && pntStart < codePrefix.length()) {
            tappo = false;
            while (pntStart < codePrefix.length() && codePrefix.charAt(pntStart) != '\u0000' && (codePrefix.charAt(pntStart) == ' ' || codePrefix.charAt(pntStart) == '\t')) {
                ++pntStart;
            }
            for (pntEnd = pntStart; pntEnd < codePrefix.length() && codePrefix.charAt(pntEnd) != '\u0000' && codePrefix.charAt(pntEnd) != ' ' && codePrefix.charAt(pntEnd) != '\t' && codePrefix.charAt(pntEnd) != ';'; ++pntEnd) {
            }
            if (pntEnd >= codePrefix.length() || codePrefix.charAt(pntEnd) == '\u0000') {
                tappo = true;
            }
            codePrefix = pntStart >= codePrefix.length() ? "" : (pntEnd < codePrefix.length() ? codePrefix.substring(pntStart, pntEnd) : codePrefix.substring(pntStart));
            String fullPath = null;
            fullPath = programName != null && programName.length() > 3 && programName.charAt(1) == ':' ? (codePrefix != null && codePrefix.length() > 3 && codePrefix.charAt(1) == ':' ? codePrefix + sep + programName.substring(2) : (codePrefix != null && codePrefix.charAt(0) == '*' ? codePrefix + sep + programName : (codePrefix != null ? programName.substring(0, 2) + codePrefix + sep + programName.substring(2) : programName.substring(0, 2) + sep + programName.substring(2)))) : (codePrefix != null ? codePrefix + sep + programName : "" + sep + programName);
            if (fullPath != null) {
                boolean remote2 = fullPath.charAt(0) == '*';
                con = AConnect.getProgramByName(this.context, fullPath);
                if (con != null) {
                    if (remote2) {
                        result = con.async_run(fullPath, args, initial);
                    } else {
                        PARAM_G_INFO[] cobolArgs = new PARAM_G_INFO[args.length - 2];
                        System.arraycopy(args, 2, cobolArgs, 0, args.length - 2);
                        result = con.call(fullPath, args);
                    }
                }
                if (result == -1) {
                    if (con != null) {
                        con.removeCallName(fullPath);
                    }
                } else {
                    hostTable.put(programName, con);
                    con.addCallName(fullPath);
                    con.setCurrentCallName(fullPath);
                }
            }
            fullPath = null;
            if (!tappo) {
                pntStart = pntEnd + 1;
                continue;
            }
            pntStart = 0;
        }
        return result;
    }

    private int call(String programName, PARAM_G_INFO[] args) {
        int result = -1;
        int pntStart = 0;
        int pntEnd = 0;
        boolean tappo = false;
        String sep = "\\";
        try {
            sep = System.getProperty("file.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String codePrefix = this.getCodePrefix();
        if (programName != null && codePrefix == null) {
            if (programName.charAt(0) == '*') {
                result = this.remoteCall(programName, args);
            } else {
                this.cobol(programName, args);
                switch (this.getCallError()) {
                    case 0: {
                        result = 0;
                        break;
                    }
                    case 1: {
                        result = -1;
                        break;
                    }
                    default: {
                        result = -2;
                    }
                }
            }
            if (result == -1) {
                this.removeCallName(programName);
            }
        }
        while (codePrefix != null && result == -1 && pntStart < codePrefix.length()) {
            tappo = false;
            while (pntStart < codePrefix.length() && codePrefix.charAt(pntStart) != '\u0000' && (codePrefix.charAt(pntStart) == ' ' || codePrefix.charAt(pntStart) == '\t')) {
                ++pntStart;
            }
            for (pntEnd = pntStart; pntEnd < codePrefix.length() && codePrefix.charAt(pntEnd) != '\u0000' && codePrefix.charAt(pntEnd) != ' ' && codePrefix.charAt(pntEnd) != '\t' && codePrefix.charAt(pntEnd) != ';'; ++pntEnd) {
            }
            if (pntEnd >= codePrefix.length() || codePrefix.charAt(pntEnd) == '\u0000') {
                tappo = true;
            }
            codePrefix = pntStart >= codePrefix.length() ? "" : (pntEnd < codePrefix.length() ? codePrefix.substring(pntStart, pntEnd) : codePrefix.substring(pntStart));
            String fullPath = null;
            fullPath = programName != null && programName.length() > 3 && programName.charAt(1) == ':' ? (codePrefix != null && codePrefix.length() > 3 && codePrefix.charAt(1) == ':' ? codePrefix + sep + programName.substring(2) : (codePrefix != null && codePrefix.charAt(0) == '*' ? codePrefix + sep + programName : (codePrefix != null ? programName.substring(0, 2) + codePrefix + sep + programName.substring(2) : programName.substring(0, 2) + sep + programName.substring(2)))) : (codePrefix != null ? codePrefix + sep + programName : "" + sep + programName);
            if (fullPath != null) {
                boolean remote2 = fullPath.charAt(0) == '*';
                AConnect con = AConnect.getProgramByName(this.context, fullPath);
                if (con != null) {
                    if (remote2) {
                        result = con.remoteCall(fullPath, args);
                    } else {
                        con.cobol(fullPath, args);
                        switch (con.getCallError()) {
                            case 0: {
                                result = 0;
                                break;
                            }
                            case 1: {
                                result = -1;
                                break;
                            }
                            default: {
                                result = -2;
                            }
                        }
                    }
                }
                if (result == -1) {
                    if (con != null) {
                        con.removeCallName(fullPath);
                    }
                } else {
                    hostTable.put(programName, con);
                    con.addCallName(fullPath);
                    con.setCurrentCallName(fullPath);
                }
            }
            fullPath = null;
            if (!tappo) {
                pntStart = pntEnd + 1;
                continue;
            }
            pntStart = 0;
        }
        return result;
    }

    @Override
    public Object callGiving() {
        return this.callGiving(null);
    }

    @Override
    public void call() {
        this.call(null);
    }

    @Override
    public Object callGiving(parameterList params) {
        int result = 0;
        this.setLastCallError(result);
        String name = this.getCurrentCallName();
        if (name == null) {
            result = -1;
            this.setLastCallError(result);
            return new Numeric(result);
        }
        PARAM_G_INFO[] args = this.getArgs(params);
        result = "C$ASYNCRUN".equalsIgnoreCase(name) ? this.asyncRunCall(args, -1) : ("C$ASYNCPOLL".equalsIgnoreCase(name) ? this.async_poll(args, -1) : this.call(name, args));
        if (result == 0) {
            this.updateParamsFromArgs(params, args);
        }
        this.setLastCallError(result);
        return new Numeric(result);
    }

    @Override
    public void call(parameterList params) {
        int result = 0;
        this.setLastCallError(result);
        String name = this.getCurrentCallName();
        if (name == null) {
            this.setLastCallError(-1);
            return;
        }
        PARAM_G_INFO[] args = this.getArgs(params);
        result = "C$ASYNCRUN".equalsIgnoreCase(name) ? this.asyncRunCall(args, -1) : ("C$ASYNCPOLL".equalsIgnoreCase(name) ? this.async_poll(args, -1) : this.call(name, args));
        if (result == 0) {
            this.updateParamsFromArgs(params, args);
        }
        this.setLastCallError(result);
    }

    @Override
    public void cancel() {
        int result = 0;
        this.setLastCallError(result);
        String name = this.getCurrentCallName();
        if (name == null) {
            this.setLastCallError(-1);
            return;
        }
        result = this.remoteCancel(name);
        this.setLastCallError(result);
    }

    @Override
    public String redirectCall() {
        return null;
    }

    private static boolean removeConnectionFromTable(String name) {
        if (hostTable == null || name == null) {
            return false;
        }
        AConnect o = hostTable.remove(name);
        if (o == null) {
            return false;
        }
        if (lastConnectionUsed == o) {
            lastConnectionUsed = null;
        }
        return true;
    }

    private static AConnect getConnectionUsingHandle(int handle) {
        if (hostTable == null) {
            return null;
        }
        if (lastConnectionUsed != null && lastConnectionUsed.hashCode() == handle) {
            return lastConnectionUsed;
        }
        Enumeration<AConnect> connections = hostTable.elements();
        while (connections.hasMoreElements()) {
            AConnect con = connections.nextElement();
            if (con.hashCode() != handle) continue;
            lastConnectionUsed = con;
            return con;
        }
        return null;
    }

    public static final AConnect getConnectionUsingHostname(Context context, String nameHost) {
        AConnect con = null;
        if (nameHost != null) {
            if (hostTable == null) {
                hostTable = new Hashtable();
            } else {
                AConnect o = hostTable.get(nameHost);
                if (o != null) {
                    con = o;
                }
            }
            if (con == null) {
                con = new AConnect(context);
                hostTable.put(nameHost, con);
            }
        } else {
            con = new AConnect(context);
        }
        return con;
    }

    public static final AConnect getConnectionUsingFilename(Context context, String filename) {
        String[] result = AConnect.getHostnameAndFilenameFromString(filename);
        if (result == null) {
            return new AConnect(context);
        }
        String hostName = result[0];
        filename = result[1];
        return AConnect.getConnectionUsingHostname(context, hostName);
    }

    public static final AConnect getProgramByName(Context context, String name) {
        if (name == null) {
            return null;
        }
        try {
            int nameCall = AConnect.strchr(name, ':');
            String nameHost = null;
            if (name.charAt(0) == '*' && nameCall != 0) {
                nameHost = name.substring(1, nameCall);
                ++nameCall;
            } else {
                nameCall = 0;
            }
            String nameCallString = name.substring(nameCall);
            if (nameCallString == null) {
                return null;
            }
            AConnect con = null;
            if (nameHost != null) {
                if (hostTable == null) {
                    hostTable = new Hashtable();
                } else {
                    AConnect o = hostTable.get(nameHost);
                    if (o != null) {
                        con = o;
                    }
                }
                if (con == null) {
                    con = new AConnect(context);
                    hostTable.put(nameHost, con);
                }
            } else {
                if (hostTable == null) {
                    hostTable = new Hashtable();
                } else {
                    AConnect o = hostTable.get(name);
                    if (o != null) {
                        con = o;
                    }
                }
                if (con == null) {
                    con = new AConnect(context);
                    hostTable.put(name, con);
                }
            }
            if (con != null) {
                con.addCallName(name);
                con.setCurrentCallName(name);
            }
            return con;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void finalize() throws Throwable {
        this.removeAllCallNames();
        super.finalize();
    }

    public class IFilePtr {
        private String filename;
        private boolean isLocal = false;
        private int fileDescriptor = 0;
        private int lenRecord = 0;
        private int lenRecordBuffer = 0;

        public IFilePtr(String filename, boolean isLocal, int fileDescriptor, int lenRecord, int lenRecordBuffer) {
            this.setFilename(filename);
            this.setIsLocal(isLocal);
            this.setFileDescriptor(fileDescriptor);
            this.setRecordLength(lenRecord);
            this.setRecordBufferLength(lenRecordBuffer);
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public boolean getIsLocal() {
            return this.isLocal;
        }

        public void setIsLocal(boolean isLocal) {
            this.isLocal = isLocal;
        }

        public int getFileDescriptor() {
            return this.fileDescriptor;
        }

        public void setFileDescriptor(int fd) {
            this.fileDescriptor = fd;
        }

        public int getRecordLength() {
            return this.lenRecord;
        }

        public void setRecordLength(int val) {
            this.lenRecord = val;
        }

        public int getRecordBufferLength() {
            return this.lenRecordBuffer;
        }

        public void setRecordBufferLength(int val) {
            this.lenRecordBuffer = val;
        }
    }

    private class PARAM_G_INFO {
        private boolean addressIsBytes = false;
        private String a_address;
        private byte[] a_address_bytes;
        private int a_address_bytes_offset = 0;
        private int a_address_bytes_length = 0;
        private int a_length;
        private short a_type;
        private byte a_digits;
        private byte a_scale;
        private byte a_io;

        public PARAM_G_INFO() {
        }

        public PARAM_G_INFO(String addr, int type, int digits, int scale, int io) {
            this.setArg(addr, type, digits, scale, io);
        }

        public PARAM_G_INFO(byte[] addr, int type, int digits, int scale) {
            this.setArg(addr, type, digits, scale, 3);
        }

        public PARAM_G_INFO(byte[] addr, int type, int digits, int scale, int io) {
            this.setArg(addr, type, digits, scale, io);
        }

        public PARAM_G_INFO(byte[] addr, int offset, int length, int type, int digits, int scale) {
            this.setArg(addr, offset, length, type, digits, scale, 3);
        }

        public PARAM_G_INFO(byte[] addr, int offset, int length, int type, int digits, int scale, int io) {
            this.setArg(addr, offset, length, type, digits, scale, io);
        }

        public String getAddressString() {
            if (this.addressIsBytes) {
                this.a_address = AConnect.this.getStringFromBytes(this.a_address_bytes, this.a_address_bytes_offset, this.a_address_bytes_length);
                this.addressIsBytes = false;
            }
            return this.a_address;
        }

        public void setAddressString(String val) {
            this.a_address = val;
            this.a_address_bytes = null;
            this.addressIsBytes = false;
        }

        public int writeAddressBytes(byte[] bytes, int offset) {
            if (!this.addressIsBytes) {
                this.getAddressBytes();
            }
            if (this.a_address_bytes_length > 0) {
                System.arraycopy(this.a_address_bytes, this.a_address_bytes_offset, bytes, offset, this.a_address_bytes_length);
            }
            return this.a_address_bytes_length;
        }

        public byte[] getAddressBytes() {
            if (!this.addressIsBytes) {
                this.a_address_bytes = AConnect.this.getBytesFromString(this.a_address);
                this.a_address_bytes_offset = 0;
                this.a_address_bytes_length = 0;
                if (this.a_address_bytes != null) {
                    this.a_address_bytes_length = this.a_address_bytes.length;
                }
                this.addressIsBytes = true;
                return this.a_address_bytes;
            }
            if (this.a_address_bytes != null && this.a_address_bytes_offset == 0 && this.a_address_bytes.length == this.a_address_bytes_length) {
                return this.a_address_bytes;
            }
            byte[] bytes = new byte[this.a_address_bytes_length];
            if (this.a_address_bytes_length > 0) {
                System.arraycopy(this.a_address_bytes, this.a_address_bytes_offset, bytes, 0, this.a_address_bytes_length);
            }
            return bytes;
        }

        public void setAddressBytes(byte[] val) {
            int len = 0;
            if (val != null) {
                len = val.length;
            }
            this.setAddressBytes(val, 0, len);
        }

        public void setAddressBytes(byte[] val, int offset, int len) {
            this.a_address_bytes = val;
            this.a_address_bytes_offset = offset;
            this.a_address_bytes_length = len;
            this.addressIsBytes = true;
        }

        public int getLength() {
            return this.a_length;
        }

        public void setLength(int val) {
            this.a_length = val;
        }

        public int getType() {
            return this.a_type;
        }

        public void setType(int val) {
            this.a_type = (short)val;
        }

        public int getDigits() {
            return this.a_digits;
        }

        public void setDigits(int val) {
            this.a_digits = (byte)val;
        }

        public int getScale() {
            return this.a_scale;
        }

        public void setScale(int val) {
            this.a_scale = (byte)val;
        }

        public int getIO() {
            return this.a_io;
        }

        public void setIO(int val) {
            this.a_io = (byte)val;
        }

        public String toString() {
            String text = "";
            String lineSep = "\n";
            try {
                lineSep = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            text = text + "Address   = '" + this.getAddressString() + "'" + lineSep;
            text = text + "Length    = " + this.getLength() + lineSep;
            text = text + "Type      = " + this.getType() + lineSep;
            text = text + "Digits    = " + this.getDigits() + lineSep;
            text = text + "Scale     = " + this.getScale() + lineSep;
            text = text + "IO        = " + this.getIO() + lineSep;
            return text;
        }

        public int getBytesLength() {
            return this.getLength() + 9;
        }

        public int readBytes(byte[] bytes, int offset) {
            try {
                int len = 4;
                AConnect.this.pntohl(bytes, offset);
                offset += len;
                int lenParam = this.getLength();
                if (lenParam > 0) {
                    if (this.addressIsBytes && this.a_address_bytes != null && this.a_address_bytes_length >= lenParam) {
                        System.arraycopy(bytes, offset, this.a_address_bytes, this.a_address_bytes_offset, lenParam);
                        len += lenParam;
                        offset += lenParam;
                        this.a_address_bytes_length = lenParam;
                    } else {
                        byte[] abytes = new byte[lenParam];
                        System.arraycopy(bytes, offset, abytes, 0, lenParam);
                        len += lenParam;
                        offset += lenParam;
                        this.setAddressBytes(abytes);
                    }
                }
                return len;
            }
            catch (Exception exception) {
                if (AConnect.this.isTrace()) {
                    AConnect.trace("readBytes:  **************** error!");
                }
                return -1;
            }
        }

        public int writeBytes(byte[] bytes, int offset) {
            try {
                int len = 0;
                AConnect.this.htonlp(bytes, offset, this.getLength());
                AConnect.this.htonlp(bytes, offset += 4, this.getType());
                offset += 4;
                bytes[offset++] = (byte)this.getDigits();
                bytes[offset++] = (byte)this.getScale();
                bytes[offset++] = (byte)this.getIO();
                len += 11;
                if ((this.getIO() & 1) != 0) {
                    if (this.addressIsBytes && this.a_address_bytes != null) {
                        System.arraycopy(this.a_address_bytes, this.a_address_bytes_offset, bytes, offset, this.a_address_bytes_length);
                        len += this.a_address_bytes_length;
                        offset += this.a_address_bytes_length;
                    } else {
                        byte[] aBytes = this.getAddressBytes();
                        if (aBytes != null) {
                            System.arraycopy(aBytes, 0, bytes, offset, aBytes.length);
                            len += aBytes.length;
                            offset += aBytes.length;
                        }
                    }
                }
                return len;
            }
            catch (Throwable t) {
                CobolException.runtimeError("Error in writing to AConnect server.", t);
                if (AConnect.this.isTrace()) {
                    AConnect.trace("writeBytes:  **************** error!");
                }
                return -1;
            }
        }

        public void setArg(byte[] addr, int type, int digits, int scale, int io) {
            int len = 0;
            if (addr != null) {
                len = addr.length;
            }
            this.setArg(addr, 0, len, type, digits, scale, io);
        }

        public void setArg(byte[] addr, int offset, int length, int type, int digits, int scale, int io) {
            this.a_address = null;
            this.a_address_bytes = null;
            this.setAddressBytes(addr, offset, length);
            this.setLength(length);
            this.setType(type);
            this.setDigits(digits);
            this.setScale(scale);
            io = 3;
            this.setIO(io);
        }

        public void setArg(String addr, int type, int digits, int scale, int io) {
            this.a_address = null;
            this.a_address_bytes = null;
            this.setAddressString(addr);
            this.setLength(addr == null ? 0 : addr.length());
            this.setType(type);
            this.setDigits(digits);
            this.setScale(scale);
            io = 3;
            this.setIO(io);
        }

        public Variable getVariableType() {
            int type = this.getType();
            if (type == 12 || type == 11) {
                boolean signed = type == 11;
                byte[] bytes = this.getAddressBytes();
                long num = 0L;
                num = bytes.length == 4 ? (long)AConnect.this.pntohl(bytes) : (long)AConnect.this.pntohs(bytes);
                return new Binary(num, signed, bytes.length, this.getDigits());
            }
            if (this.getLength() == 0) {
                return null;
            }
            return new Variable(this.getAddressString());
        }
    }
}

