/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Dialog;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400FileRecordDescription;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.ReturnCodeException;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AS400Connect
implements ICallableProgramGiving {
    public static final boolean debugMode = false;
    private static final String TRACE_REMOTE_AS400 = "TRACE_REMOTE_AS400";
    public static final String KEY_SERVER_ADDRESS = "AS400CONNECT_SERVER";
    static final String KEY_DISPLAY_CALL = "AS400CONNECT-DISPLAY-CALL";
    static final String KEY_CODE_MAPPING = "CODE_MAPPING";
    static final String KEY_CODE_SUFFIX = "CODE_SUFFIX";
    static final String KEY_CODE_PREFIX = "CODE_PREFIX";
    static final String KEY_FILE_PREFIX = "FILE_PREFIX";
    static final String KEY_CFG_FILE = "AS400CONNECT_CONFIGURATION_FILE";
    static final String KEY_CLAFCA = "AS400CONNECT_CLOSE_AFTER_CANCEL";
    static final char TAG_REMOTE_FILE = '@';
    public static final int COMMIT_CONTEXT_PROGRAMMED = 0;
    public static final int COMMIT_CONTEXT_UNKNOWN = 1;
    public static final int COMMIT_CONTEXT_NO_TRX = 2;
    public static final int ROLLBACK_CONTEXT_PROGRAMMED = 0;
    public static final int ROLLBACK_CONTEXT_UNKNOWN = 1;
    public static final int ROLLBACK_CONTEXT_NO_TRX = 2;
    public static final int Finput = 0;
    public static final int Foutput = 1;
    public static final int Fio = 2;
    public static final int Fextend = 3;
    public static final int Fmulti_lock = 16;
    public static final int Fread_lock = 256;
    public static final int Fwrite_lock = 512;
    public static final int Fmass_update = 1536;
    public static final int Ftrans = 16384;
    public static final int F_EQUALS = 0;
    public static final int F_NOT_LESS = 1;
    public static final int F_GREATER = 2;
    public static final int F_LESS = 3;
    public static final int F_NOT_GREATER = 4;
    public static final int E_SYS_ERR = 1;
    public static final int E_PARAM_ERR = 2;
    public static final int E_TOO_MANY_FILES = 3;
    public static final int E_MODE_CLASH = 4;
    public static final int E_REC_LOCKED = 5;
    public static final int E_BROKEN = 6;
    public static final int E_DUPLICATE = 7;
    public static final int E_NOT_FOUND = 8;
    public static final int E_UNDEF_RECORD = 9;
    public static final int E_DISK_FULL = 10;
    public static final int E_FILE_LOCKED = 11;
    public static final int E_REC_CHANGED = 12;
    public static final int E_MISMATCH = 13;
    public static final int E_NO_MEMORY = 14;
    public static final int E_MISSING_FILE = 15;
    public static final int E_PERMISSION = 16;
    public static final int E_NO_SUPPORT = 17;
    public static final int E_NO_LOCKS = 18;
    public static final int E_INTERFACE = 19;
    public static final int E_LICENSE_ERR = 20;
    public static final int E_UNKNOWN_ERR = 21;
    public static final int W_NO_SUPPORT = 100;
    public static final int W_DUP_OK = 101;
    public static final int E_LOG_EXTERNAL = 1;
    public static final int E_LOG_TOO_MANY = 2;
    public static final int E_LOG_MISSING = 3;
    public static final int E_LOG_PERMISSION = 4;
    public static final int E_LOG_SYS_ERR = 5;
    public static final int E_LOG_CORRUPT = 6;
    public static final int E_LOG_LOCKED = 7;
    public static final int E_LOG_NO_MEMORY = 8;
    public static final int E_LOG_DISK_FULL = 9;
    public static final int E_NO_LOG = 10;
    public static final int E_RB_LOG_CORRUPT = 11;
    public static final int E_LOG_INCOMPLETE = 12;
    public static final int E_OPEN_NOT_LOGGED = 13;
    public static final int E_LOG_INTERFACE = 14;
    public static final int E_LOG_REMOTE = 15;
    public static final int E_LOG_NESTED_START = 16;
    public static final int E_LOG_TEMP = 17;
    public static final int W_LOG_NO_SUPPORT = 100;
    public static final int G_OK = 0;
    public static final int G_CONT = -1;
    public static final int G_CALL_NOTFOUND = -1;
    public static final int G_FILE_NOTFOUND = -1;
    public static final int G_STOP_RUN = -2;
    public static final int G_SOCKET_ERROR = -3;
    public static final int G_FILE_ERROR = -3;
    public static final int G_SYNC_NODEF = -4;
    public static final int G_COBOL_ERROR = -5;
    public static final int G_CONNECT_FAIL = -6;
    public static final int G_ERR_PWD = -7;
    public static final int G_TIMEOUT = -8;
    public static final int G_MISSING = 1;
    public static final int G_NOT_COBOL = 2;
    public static final int G_INTERNAL = 3;
    public static final int G_MEMORY = 4;
    public static final int G_VERSION = 5;
    public static final int G_RECURSIVE = 6;
    public static final int G_EXTERNAL = 7;
    public static final int G_LARGE_MODEL = 8;
    public static final int G_ECONNREFUSED = 25;
    public static final int G_JAPANESE = 14;
    static final String USER = "USER";
    private boolean isTrace = false;
    private String host = "127.0.0.1";
    private boolean isfileconnected = false;
    private boolean iscommandconnected = false;
    private int returnCode = 0;
    private int errno = 0;
    private int f_no_lock = 0;
    private Context context;
    private AS400 as400 = null;
    private boolean didConnect = false;
    private String comment = "";
    private String logical_params = "";
    private int maximum = 0;
    private int minimum = 0;
    private int numberOfKeys = 0;
    private Variable masterRecord = null;
    private Variable[] keyArray = null;
    private Variable[] fileDesc = null;
    private String codePrefix = null;
    private String codeSuffix = null;
    private String filePrefix = null;
    private String cfgPath = null;
    private boolean closeAfterCancel = false;
    private String lineSep = "\n";
    private static boolean AS400TextIsOldStyle = false;
    private static Hashtable<String, AS400Connect> connections = new Hashtable();
    private String currentCallName = null;
    private Vector<String> callNames = null;
    private int lastReturnCode = 0;

    private static final void debug(String text) {
        System.out.println("AS400Connect: " + text);
    }

    private static final void trace(String text) {
        System.out.println("AS/400 access: " + text);
    }

    public AS400Connect(Context context) {
        this(context, null);
    }

    public AS400Connect(Context context, String host) {
        this.context = context;
        if (host != null) {
            this.setHost(host);
        } else {
            host = RuntimeEnvironment.getGlobalParameter(KEY_SERVER_ADDRESS);
            if (host != null) {
                this.setHost(host);
            }
        }
        this.setCodeMapping(RuntimeEnvironment.getGlobalParameter(KEY_CODE_MAPPING));
        this.setCodePrefix(RuntimeEnvironment.getGlobalParameter(KEY_CODE_PREFIX));
        this.setCodeSuffix(RuntimeEnvironment.getGlobalParameter(KEY_CODE_SUFFIX));
        this.setFilePrefix(RuntimeEnvironment.getGlobalParameter(KEY_FILE_PREFIX));
        try {
            this.lineSep = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (RuntimeEnvironment.isGlobalParameter(TRACE_REMOTE_AS400)) {
            this.setTrace(true);
        }
    }

    private void setCodeMapping(String codeMappingString) {
    }

    private void setCodeMapping(boolean flag) {
    }

    private String getCodePrefix() {
        return this.codePrefix;
    }

    private void setCodePrefix(String prefix) {
        this.codePrefix = prefix;
    }

    private String getCodeSuffix() {
        return this.codeSuffix;
    }

    private void setCodeSuffix(String suffix) {
        this.codeSuffix = suffix;
    }

    private String getFilePrefix() {
        return this.filePrefix;
    }

    private void setFilePrefix(String prefix) {
        this.filePrefix = prefix;
    }

    private boolean getCloseAfterCancel() {
        return this.closeAfterCancel;
    }

    public void setCloseAfterCancel(boolean flag) {
        this.closeAfterCancel = flag;
    }

    private String getConfigPath() {
        return this.cfgPath;
    }

    private void setConfigPath(String path) {
        this.cfgPath = path;
    }

    public final boolean isTrace() {
        return this.isTrace;
    }

    public void setTrace(boolean flag) {
        this.isTrace = flag;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public int getErrno() {
        return this.errno;
    }

    private void setErrno(int val) {
        this.errno = val;
    }

    public int getF_NO_LOCK() {
        return this.f_no_lock;
    }

    public void setF_NO_LOCK(int val) {
        this.f_no_lock = val;
    }

    public int getNumberOfKeys() {
        return this.numberOfKeys;
    }

    private void setNumberOfKeys(int val) {
        this.numberOfKeys = val;
    }

    public int getMaximumRecordSize() {
        return this.maximum;
    }

    private void setMaximumRecordSize(int val) {
        this.maximum = val;
    }

    public int getMinimumRecordSize() {
        return this.minimum;
    }

    private void setMinimumRecordSize(int val) {
        this.minimum = val;
    }

    public boolean isConnected(int service) {
        if (service == 5) {
            return this.isfileconnected;
        }
        return this.iscommandconnected;
    }

    private void setConnected(boolean flag, int service) {
        if (service == 5) {
            this.isfileconnected = flag;
        } else {
            this.iscommandconnected = flag;
        }
    }

    public static int strchr(String buff, char initChar) {
        return AS400Connect.strchr(buff, 0, initChar);
    }

    public static int strchr(String buff, int offset, char initChar) {
        if (offset < 0) {
            return -1;
        }
        while (offset >= 0 && offset < buff.length() && buff.charAt(offset) != '\u0000' && buff.charAt(offset) != initChar) {
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(String buff, int offset, char[] chars) {
        char c;
        if (offset < 0) {
            return -1;
        }
        while (offset < buff.length() && (c = buff.charAt(offset)) != '\u0000') {
            int i;
            for (i = 0; i < chars.length && c != chars[i]; ++i) {
            }
            if (i != chars.length) continue;
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(StringBuffer buff, int offset, char initChar) {
        while (offset >= 0 && offset < buff.length() && buff.charAt(offset) != '\u0000' && buff.charAt(offset) != initChar) {
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(StringBuffer buff, int offset, char[] chars) {
        char c;
        if (offset < 0) {
            return -1;
        }
        while (offset < buff.length() && (c = buff.charAt(offset)) != '\u0000') {
            int i;
            for (i = 0; i < chars.length && c != chars[i]; ++i) {
            }
            if (i != chars.length) continue;
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strstr(String buff, int offset, String initString) {
        if (offset < 0) {
            return -1;
        }
        int nullOffset = buff.substring(offset).indexOf(0);
        int strOffset = buff.substring(offset).indexOf(initString);
        if (nullOffset < 0 || strOffset < 0) {
            return strOffset;
        }
        if (nullOffset < strOffset) {
            return -1;
        }
        return strOffset;
    }

    private String getSubstring(String text, int offset) {
        if (text == null) {
            return null;
        }
        int start = offset;
        while (offset < text.length() && text.charAt(offset) != '\u0000') {
            ++offset;
        }
        if (offset == start) {
            return text;
        }
        if (offset == text.length()) {
            return text.substring(start);
        }
        return text.substring(start, offset);
    }

    public String readConfigFile(String fileString, String configString) {
        if (fileString == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(fileString);
        char initChar = '*';
        char[] chars = new char[2];
        boolean tappo = false;
        int offset = 0;
        int offsetEnd = 0;
        int offsetBlk = 0;
        chars[0] = 42;
        chars[1] = 64;
        int result = -1;
        while ((offset = AS400Connect.strchr(buff, offset, initChar)) >= 0) {
            String cString;
            offsetEnd = ++offset;
            result = AS400Connect.strchr(buff, offsetEnd, ':');
            if ((offsetEnd = result) > 0) {
                buff.setCharAt(offsetEnd - 1, '\u0000');
                offset = ++offsetEnd;
            }
            if ((offsetEnd = (result = AS400Connect.strchr(buff, offsetEnd, chars))) < 0 || offsetEnd >= buff.length() || buff.charAt(offsetEnd) == '\u0000') {
                tappo = true;
            } else {
                buff.setCharAt(--offsetEnd, '\u0000');
            }
            if (offset < 0 || offset >= buff.length() || buff.charAt(offset) == '\u0000') continue;
            for (offsetBlk = offsetEnd - 1; offsetBlk >= 0 && (buff.charAt(offsetBlk) == ' ' || buff.charAt(offsetBlk) == '\t'); --offsetBlk) {
                buff.setCharAt(offsetBlk, '\u0000');
            }
            if (configString != null && !configString.equals(cString = this.getSubstring(buff.toString(), offset))) {
                configString = null;
            }
            configString = this.getSubstring(buff.toString(), offset);
            if (tappo) {
                offset = offsetEnd;
                continue;
            }
            offset = ++offsetEnd;
        }
        return configString;
    }

    private void readConfigPath(String configFile) {
        String configString = this.readConfigFile(configFile, this.getConfigPath());
        if (configString != null) {
            this.setConfigPath(configString);
        }
    }

    private void readConfig() {
        String cfgFile = RuntimeEnvironment.getGlobalParameter(KEY_CFG_FILE);
        if (cfgFile != null) {
            this.readConfigPath(cfgFile);
        }
        int offset = 0;
        int offsetStart = 0;
        boolean closeAfterCancel = false;
        cfgFile = RuntimeEnvironment.getGlobalParameter(KEY_CLAFCA);
        if (cfgFile != null) {
            int val = 0;
            String valString = this.getSubstring(cfgFile, 0);
            if (valString != null) {
                try {
                    val = Integer.valueOf(valString);
                }
                catch (Exception exception) {}
            } else {
                valString = "";
            }
            if (val == 1) {
                closeAfterCancel = true;
            } else {
                offsetStart = offset = 0;
                StringBuffer text = new StringBuffer(cfgFile);
                while (offset < text.length() && text.charAt(offset) != '\u0000' && text.charAt(offset) != ' ' && cfgFile.charAt(offset) != '\t') {
                    text.setCharAt(offset, Character.toUpperCase(text.charAt(offset)));
                    ++offset;
                }
                cfgFile = text.toString();
                if (AS400Connect.strstr(cfgFile, offsetStart, "YES") >= 0) {
                    closeAfterCancel = true;
                }
            }
        }
        this.setCloseAfterCancel(closeAfterCancel);
    }

    public static final String getHostnameFromString(String text) {
        String[] result = AS400Connect.getHostnameAndFilenameFromString(text);
        if (result == null) {
            return null;
        }
        return result[0];
    }

    public static final String getFilenameFromString(String text) {
        String[] result = AS400Connect.getHostnameAndFilenameFromString(text);
        if (result == null) {
            return null;
        }
        return result[1];
    }

    public static final String convertBackslashesToForwardSlashes(String n) {
        int offset = 0;
        int offsetN = 0;
        StringBuffer buff = new StringBuffer(n);
        while ((offset = AS400Connect.strchr(buff, offsetN, '\\')) >= 0) {
            buff.setCharAt(offset, '/');
            offsetN = offset;
        }
        return buff.toString();
    }

    public static final String[] getHostnameAndFilenameFromString(String text) {
        if (text == null) {
            return null;
        }
        String[] result = new String[2];
        String path = text;
        String hostname = null;
        int offset = AS400Connect.strchr(path = AS400Connect.convertBackslashesToForwardSlashes(path), 0, ':');
        if (offset > 1) {
            hostname = path.substring(0, offset);
        } else if (offset >= 0) {
            hostname = null;
        }
        if (offset >= 0 && offset < path.length() - 1) {
            path = path.substring(offset + 1);
        }
        result[0] = hostname;
        result[1] = path;
        return result;
    }

    private void parseLogicalParams(String params) {
        String text;
        if (params == null) {
            return;
        }
        int index = params.indexOf(44);
        if (index > 0) {
            text = params.substring(0, index).trim();
            try {
                this.maximum = Integer.valueOf(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                params = params.substring(index + 1);
            }
            catch (Exception e) {
                return;
            }
        }
        if ((index = params.indexOf(44)) > 0) {
            text = params.substring(0, index).trim();
            try {
                this.minimum = Integer.valueOf(text);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                params = params.substring(index + 1);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private String getUserName() {
        String pntUser = RuntimeEnvironment.getGlobalParameter("USERNAME");
        if (pntUser == null) {
            pntUser = RuntimeEnvironment.getGlobalParameter(USER);
        }
        return pntUser;
    }

    private String getPasswordFromUser(String title, String message) {
        if (this.context != null) {
            Variable checkVariable = new Variable("XXXXXXXXXX");
            String password = (checkVariable = checkVariable.setExternal(this.context, "AS400-CLIENT-PASSWORD")).toString();
            if (password != null && !"XXXXXXXXXX".equalsIgnoreCase(password)) {
                return password;
            }
        }
        return Dialog.showInputDialog(title, message, 20, true);
    }

    private String[] getUserNameAndPasswordFromUser(String title, String user, String password) {
        String[] myArray = new String[2];
        if (user == null) {
            user = this.getUserName();
        }
        if (user != null && password == null && this.context != null) {
            Variable checkVariable = new Variable("XXXXXXXXXX");
            password = (checkVariable = checkVariable.setExternal(this.context, "AS400-CLIENT-PASSWORD")).toString();
            if (password != null && !"XXXXXXXXXX".equalsIgnoreCase(password)) {
                myArray[0] = user;
                myArray[1] = password;
                return myArray;
            }
        }
        myArray[0] = user;
        myArray[1] = password;
        return myArray;
    }

    private String getLocalHostname() {
        String localHostName = null;
        String explicitHost = RuntimeEnvironment.getGlobalParameter("LOCALHOST");
        if (explicitHost != null) {
            localHostName = explicitHost;
        } else {
            InetAddress localHost2;
            try {
                localHost2 = InetAddress.getLocalHost();
                localHostName = localHost2.getHostName();
            }
            catch (Exception localHost2) {
                // empty catch block
            }
            if (localHostName == null) {
                try {
                    localHost2 = InetAddress.getLocalHost();
                    localHostName = localHost2.getHostAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (localHostName == null) {
                localHostName = "127.0.0.1";
            }
        }
        return localHostName;
    }

    private void disconnect(int service) {
        this.setConnected(false, service);
        if (this.as400 != null && this.didConnect) {
            try {
                this.as400.disconnectService(service);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.didConnect = false;
    }

    private void AS400ConnectSendEnd(int service) {
        if (service == 5) {
            if (this.isConnected(5)) {
                this.returnCode = 0;
                this.disconnect(5);
            }
        } else if (service == 2 && this.isConnected(2)) {
            this.returnCode = 0;
            this.disconnect(2);
        }
    }

    private boolean connect(int service) {
        if (this.isTrace()) {
            AS400Connect.trace("Attempting to connect to the AS/400, service='" + service + "'...");
        }
        this.returnCode = 0;
        this.setErrno(0);
        if (this.isConnected(service)) {
            if (this.isTrace()) {
                AS400Connect.trace("Already connected.");
            }
            return true;
        }
        String host = this.getHost();
        try {
            String systemName = host;
            if (systemName == null || systemName.trim().length() == 0) {
                systemName = "localhost";
            }
            if (this.isTrace()) {
                AS400Connect.trace("Host = '" + systemName + "'");
            }
            if (this.as400 == null) {
                this.as400 = new AS400(systemName);
            }
            if (service != 7 && this.as400.isConnected(service) || service == 7 && this.as400.isConnected()) {
                if (this.isTrace()) {
                    AS400Connect.trace("Connected.");
                }
                this.setConnected(true, service);
                return true;
            }
            String title = "Sign on to " + this.getHost() + ".";
            String user = null;
            String password = null;
            if (this.isTrace()) {
                AS400Connect.trace("Is this a local connection? " + this.as400.isLocal());
            }
            if (this.as400.isLocal()) {
                user = "*CURRENT";
                password = "*CURRENT";
                if (this.isTrace()) {
                    AS400Connect.trace("Local connection changes user to '" + user + "' and password to '" + password + "'.");
                }
            }
            int attempts = 0;
            while (!(this.as400.isLocal() ? attempts > 3 : attempts > 2)) {
                try {
                    if (attempts != 0 || !this.as400.isLocal()) {
                        String[] text = this.getUserNameAndPasswordFromUser(title, user, password);
                        user = text[0];
                        password = text[1];
                    }
                    if (user == null) {
                        user = "";
                    }
                    this.as400.setUserId(user);
                    if (password != null) {
                        this.as400.setPassword(password.trim());
                    }
                    if (this.isTrace()) {
                        AS400Connect.trace("Attempting to connect service, user='" + user + "'");
                    }
                    this.as400.setShowCheckboxes(true);
                    this.as400.connectService(service);
                    if (this.isTrace()) {
                        AS400Connect.trace("Connected.");
                    }
                    this.setConnected(true, service);
                    this.didConnect = true;
                    return true;
                }
                catch (Exception e) {
                    if (this.isTrace()) {
                        AS400Connect.trace("An exception occurred while attemting to connect:");
                        AS400Connect.trace("" + e);
                        AS400Connect.trace("");
                    }
                    this.returnCode = -6;
                    this.setErrno(19);
                    if (!(e instanceof AS400SecurityException)) break;
                    int rc = ((AS400SecurityException)e).getReturnCode();
                    title = null;
                    switch (rc) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 22: 
                        case 26: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 32: {
                            this.setErrno(16);
                            this.returnCode = -7;
                            title = "Invalid login attempt.";
                            password = null;
                            break;
                        }
                    }
                    if (title == null) break;
                    ++attempts;
                }
            }
            this.returnCode = -7;
        }
        catch (Throwable t) {
            if (this.isTrace()) {
                AS400Connect.trace("Unable to connect:");
                AS400Connect.trace("" + t);
                AS400Connect.trace("");
            }
            this.returnCode = -3;
            this.setErrno(19);
            this.disconnect(service);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    private boolean initSocketConnection(String hostname) {
        return this.initSocketConnection(hostname, 5);
    }

    private boolean initSocketConnection(String hostname, int service) {
        this.returnCode = 0;
        if (this.isTrace()) {
            AS400Connect.trace("Initializing socket connection [Hostname='" + hostname + "', Service='" + service + "']...");
        }
        if (!this.isConnected(service)) {
            if (this.isTrace()) {
                AS400Connect.trace("Setting host value and reading configuration data...");
            }
            this.setHost(hostname);
            this.readConfig();
            if (this.returnCode != 0) {
                return false;
            }
            this.connect(service);
            if (this.returnCode != 0) {
                return false;
            }
            if (this.isTrace()) {
                AS400Connect.trace("Successful socket connection.");
            }
            return true;
        }
        if (this.isTrace()) {
            AS400Connect.trace("A connection already exists.");
        }
        return true;
    }

    public AS400 getSystemConnection(int service) {
        if (this.isConnected(service)) {
            return this.as400;
        }
        boolean flag = this.initSocketConnection(this.getHost(), service);
        if (!flag) {
            return null;
        }
        return this.as400;
    }

    private void setErrno(Exception e) {
        this.setErrno(AS400Connect.getErrorFromException(e));
    }

    public static int getErrorFromException(Exception e) {
        if (e instanceof ReturnCodeException) {
            ReturnCodeException rc = (ReturnCodeException)e;
            int returnCode = rc.getReturnCode();
            if (e instanceof ExtendedIOException) {
                switch (returnCode) {
                    case 5: {
                        return 16;
                    }
                    case 4: 
                    case 9: 
                    case 14: 
                    case 17: 
                    case 21: 
                    case 40: 
                    case 41: {
                        return 1;
                    }
                    case 22: {
                        return 8;
                    }
                    case 1: {
                        return 11;
                    }
                    case 2: {
                        return 15;
                    }
                    case 10: {
                        return 11;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 15: 
                    case 16: 
                    case 24: 
                    case 42: {
                        return 16;
                    }
                    case 33: {
                        return 5;
                    }
                    case 18: {
                        return 3;
                    }
                    case 19: 
                    case 20: {
                        return 2;
                    }
                    case 3: {
                        return 15;
                    }
                    case 13: {
                        return 16;
                    }
                    case 23: {
                        return 17;
                    }
                    case 11: 
                    case 12: {
                        return 14;
                    }
                    case 32: {
                        return 11;
                    }
                    case 25: {
                        return 21;
                    }
                }
            } else if (e instanceof AS400SecurityException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: {
                        return 16;
                    }
                }
            } else if (e instanceof ConnectionDroppedException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return 19;
                    }
                }
            } else if (e instanceof ErrorCompletingRequestException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: {
                        return 1;
                    }
                }
            } else if (e instanceof ExtendedIllegalArgumentException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return 2;
                    }
                }
            } else if (e instanceof ExtendedIllegalStateException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return 19;
                    }
                }
            } else if (e instanceof IllegalObjectTypeException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return 1;
                    }
                }
            } else if (e instanceof IllegalPathNameException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        return 15;
                    }
                }
            } else if (e instanceof InternalErrorException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return 1;
                    }
                }
            } else if (e instanceof ObjectAlreadyExistsException) {
                switch (returnCode) {
                    case 1: {
                        return 7;
                    }
                }
            } else if (e instanceof ObjectDoesNotExistException) {
                switch (returnCode) {
                    case 1: {
                        return 15;
                    }
                    case 2: {
                        return 8;
                    }
                }
            } else if (e instanceof ProxyException) {
                switch (returnCode) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return 19;
                    }
                }
            } else if (e instanceof RequestNotSupportedException) {
                switch (returnCode) {
                    case 1: {
                        return 1;
                    }
                }
            } else if (e instanceof ServerStartupException) {
                switch (returnCode) {
                    case 1: 
                    case 2: {
                        return 19;
                    }
                    case 9: 
                    case 11: {
                        return 16;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        return 19;
                    }
                    case 10: {
                        return 16;
                    }
                }
            }
        }
        return 21;
    }

    private String getRecordFormatName(String filename) {
        if (this.isTrace()) {
            AS400Connect.trace("Getting record format name for filename '" + filename + "'...");
        }
        QSYSObjectPathName path = new QSYSObjectPathName(filename);
        String name = path.getMemberName();
        if (this.isTrace()) {
            AS400Connect.trace("Member name='" + name + "'");
        }
        if (name == null || name.trim().length() == 0 || name.charAt(0) == '*') {
            name = path.getObjectName();
            if (this.isTrace()) {
                AS400Connect.trace("Using object name='" + name + "'");
            }
        }
        if (name == null || name.trim().length() == 0) {
            if (this.isTrace()) {
                AS400Connect.trace("Could not find file, returning...");
            }
            this.setErrno(15);
            return null;
        }
        if (name.length() > 9) {
            name = name.substring(0, 9);
        }
        String format = name + "R";
        if (this.isTrace()) {
            AS400Connect.trace("Returning format='" + format + "'.");
        }
        return format;
    }

    private boolean isKey(Variable currentField) {
        int i = 0;
        Variable key = this.keyArray[i];
        if (key instanceof VariableList) {
            Variable[] myList = ((VariableList)key).getList();
            for (int j = 0; j < myList.length; ++j) {
                if (currentField != myList[j]) continue;
                return true;
            }
        } else if (currentField == this.keyArray[i]) {
            return true;
        }
        return false;
    }

    private AS400DataType getDataType(Variable currentField) {
        switch (currentField.getStorageClass()) {
            case 0: {
                int numDigits = currentField.length();
                int decimalPositions = currentField.getPlace();
                return new AS400ZonedDecimal(numDigits, decimalPositions);
            }
            case 1: {
                return new AS400Float4();
            }
            case 2: {
                return new AS400Float8();
            }
            case 3: {
                if (!(currentField instanceof BignumType)) break;
                int numDigits = ((BignumType)currentField).getNumberOfDigits();
                int decimalPositions = currentField.getPlace();
                return new AS400PackedDecimal(numDigits, decimalPositions);
            }
            case 4: {
                int length = currentField.length();
                if (length <= 2) {
                    return new AS400Bin2();
                }
                if (length <= 4) {
                    return new AS400Bin4();
                }
                if (length > 8) break;
                return new AS400Bin8();
            }
        }
        try {
            if (!AS400TextIsOldStyle) {
                return new AS400Text(currentField.length(), this.as400);
            }
        }
        catch (Throwable t) {
            AS400TextIsOldStyle = true;
        }
        return new AS400Text(currentField.length());
    }

    private BigDecimal convertToBigDecimal(Variable currentField) {
        return currentField.toBignum().decimalValue();
    }

    private Object getVariableObject(Variable currentField) {
        int type = currentField.getTypeNumber();
        switch (type) {
            case 0: {
                switch (currentField.getUsageNumber()) {
                    case 3: {
                        int length = currentField.length();
                        if (length <= 2) {
                            return new Short(currentField.toShort());
                        }
                        if (length <= 4) {
                            return new Integer(currentField.toInt());
                        }
                        if (length > 8) break;
                        return new Long(currentField.toLong());
                    }
                    case 1: {
                        return new Float(currentField.toFloat());
                    }
                    case 2: {
                        return new Double(currentField.toDouble());
                    }
                    case 34: {
                        return new Short(currentField.toShort());
                    }
                    case 0: 
                    case 35: {
                        return this.convertToBigDecimal(currentField);
                    }
                    case 4: {
                        if (!(currentField instanceof BignumType)) break;
                        return this.convertToBigDecimal(currentField);
                    }
                }
                break;
            }
        }
        return currentField.toString();
    }

    private void moveBigDecimal(Variable currentField, BigDecimal value) {
        Bignum bigNum = new Bignum(value.toString());
        currentField.move(bigNum);
    }

    private int setVariableObject(Variable currentField, Object value) {
        int type = currentField.getTypeNumber();
        int length = currentField.length();
        switch (type) {
            case 0: {
                switch (currentField.getUsageNumber()) {
                    case 3: {
                        if (length <= 2) {
                            if (value instanceof Short) {
                                currentField.move((Short)value);
                                return length;
                            }
                            return -1;
                        }
                        if (length <= 4) {
                            if (value instanceof Integer) {
                                currentField.move((Integer)value);
                                return length;
                            }
                            return -1;
                        }
                        if (length > 8) break;
                        if (value instanceof Long) {
                            currentField.move((Long)value);
                            return length;
                        }
                        return -1;
                    }
                    case 1: {
                        if (value instanceof Float) {
                            currentField.move(((Float)value).floatValue());
                            return length;
                        }
                        return -1;
                    }
                    case 2: {
                        if (value instanceof Double) {
                            currentField.move((double)((Double)value));
                            return length;
                        }
                        return -1;
                    }
                    case 34: {
                        if (value instanceof Short) {
                            currentField.move((Short)value);
                            return length;
                        }
                        return -1;
                    }
                    case 0: 
                    case 35: {
                        if (value instanceof BigDecimal) {
                            this.moveBigDecimal(currentField, (BigDecimal)value);
                            return length;
                        }
                        return -1;
                    }
                    case 4: {
                        if (!(currentField instanceof BignumType)) break;
                        if (value instanceof BigDecimal) {
                            this.moveBigDecimal(currentField, (BigDecimal)value);
                            return length;
                        }
                        return -1;
                    }
                }
                break;
            }
        }
        if (value instanceof String) {
            currentField.move((String)value);
            return length;
        }
        return -1;
    }

    private Object[] getKeyObjects() {
        Object[] myObjects;
        Variable key = this.keyArray[0];
        if (key instanceof VariableList) {
            Variable[] myList = ((VariableList)key).getList();
            myObjects = new Object[myList.length];
            for (int j = 0; j < myList.length; ++j) {
                myObjects[j] = this.getVariableObject(myList[j]);
            }
        } else {
            myObjects = new Object[]{this.getVariableObject(key)};
        }
        return myObjects;
    }

    private FieldDescription getFieldDescription(AS400DataType dt, String name) {
        if (dt instanceof AS400Bin2) {
            return new BinaryFieldDescription((AS400Bin2)dt, name, name, dt.getByteLength());
        }
        if (dt instanceof AS400Bin4) {
            return new BinaryFieldDescription((AS400Bin4)dt, name, name, dt.getByteLength());
        }
        if (!(dt instanceof AS400Bin8)) {
            if (dt instanceof AS400Float4) {
                return new FloatFieldDescription((AS400Float4)dt, name, name, dt.getByteLength());
            }
            if (dt instanceof AS400Float8) {
                return new FloatFieldDescription((AS400Float8)dt, name, name, dt.getByteLength());
            }
            if (dt instanceof AS400ZonedDecimal) {
                return new ZonedDecimalFieldDescription((AS400ZonedDecimal)dt, name, name);
            }
            if (dt instanceof AS400PackedDecimal) {
                return new PackedDecimalFieldDescription((AS400PackedDecimal)dt, name, name);
            }
            if (dt instanceof AS400Text) {
                return new CharacterFieldDescription((AS400Text)dt, name, name);
            }
        }
        return null;
    }

    private boolean searchForKey(Variable currentField) {
        if (this.isKey(currentField)) {
            return true;
        }
        int end = currentField.getChildrenCount();
        for (int i = 1; i <= end; ++i) {
            Variable child = currentField.getChild(i);
            if (!this.searchForKey(child)) continue;
            return true;
        }
        return false;
    }

    private int addFieldsToRecordFormat(RecordFormat recordFormat, Variable currentField, int offset) {
        if (currentField == null || currentField.length() <= 0) {
            return offset;
        }
        boolean isKey = false;
        if (currentField.isElementary() || (isKey = this.isKey(currentField))) {
            String name = "field_" + (offset + 1);
            AS400DataType dt = this.getDataType(currentField);
            FieldDescription fd = this.getFieldDescription(dt, name);
            if (fd == null) {
                if (this.isTrace()) {
                    AS400Connect.trace("Could not allocate a field description for current Variable =" + currentField.getName());
                }
                return -1;
            }
            recordFormat.addFieldDescription(fd);
            if (isKey) {
                recordFormat.addKeyFieldDescription(fd.getFieldName());
            }
            return ++offset;
        }
        int numChildren = currentField.getChildrenCount();
        for (int i = 1; i <= numChildren; ++i) {
            int temp;
            Variable child = currentField.getChild(i);
            if (child.length() <= 0) continue;
            if (!child.isElementary()) {
                if (this.searchForKey(child)) {
                    temp = this.addFieldsToRecordFormat(recordFormat, child, offset);
                    if (temp < 0) {
                        return temp;
                    }
                    offset = temp;
                    continue;
                }
                String name = "field_" + (offset + 1);
                AS400DataType dt = this.getDataType(child);
                FieldDescription fd = this.getFieldDescription(dt, name);
                if (fd == null) {
                    if (this.isTrace()) {
                        AS400Connect.trace("Could not allocate a field description for current Variable =" + child.getName());
                    }
                    return -1;
                }
                recordFormat.addFieldDescription(fd);
                ++offset;
                continue;
            }
            temp = this.addFieldsToRecordFormat(recordFormat, child, offset);
            if (temp < 0) {
                return temp;
            }
            offset = temp;
        }
        return offset;
    }

    private boolean addFieldsToRecordFormat(RecordFormat recordFormat) {
        if (this.addFieldsToRecordFormat(recordFormat, this.masterRecord, 0) < 0) {
            if (this.isTrace()) {
                AS400Connect.trace("Error: Could not create field descriptions for file using file descriptor variables.");
            }
            return false;
        }
        return true;
    }

    private boolean variableMatchesFieldDescription(FieldDescription fieldDesc, Variable currentField) {
        AS400DataType dataType = fieldDesc.getDataType();
        int type = currentField.getTypeNumber();
        switch (type) {
            case 0: {
                switch (currentField.getUsageNumber()) {
                    case 3: {
                        int length = currentField.length();
                        if (length <= 2) {
                            return dataType instanceof AS400Bin2;
                        }
                        if (length <= 4) {
                            return dataType instanceof AS400Bin4;
                        }
                        if (length > 8) break;
                        return dataType instanceof AS400Bin8;
                    }
                    case 1: {
                        return dataType instanceof AS400Float4;
                    }
                    case 2: {
                        return dataType instanceof AS400Float8;
                    }
                    case 34: {
                        return dataType instanceof AS400Bin2;
                    }
                    case 0: 
                    case 35: {
                        return dataType instanceof AS400ZonedDecimal;
                    }
                    case 4: {
                        if (!(currentField instanceof BignumType)) break;
                        return dataType instanceof AS400PackedDecimal;
                    }
                }
                break;
            }
        }
        boolean flag = dataType instanceof AS400Text && dataType.getByteLength() == currentField.length();
        return flag;
    }

    private int initFileDesc(FieldDescription[] fieldDescArray, Variable currentField, Vector<Variable> v, int offset) {
        if (currentField == null || currentField.length() <= 0) {
            return offset;
        }
        if (currentField.isElementary() || this.isKey(currentField)) {
            if (offset < fieldDescArray.length && this.variableMatchesFieldDescription(fieldDescArray[offset], currentField)) {
                v.addElement(currentField);
                return ++offset;
            }
            if (this.isTrace()) {
                AS400Connect.trace("Current variable='" + currentField.getName() + "' != fieldDesc[" + offset + "]='" + fieldDescArray[offset].getDDSName() + "'");
            }
            return -1;
        }
        int numChildren = currentField.getChildrenCount();
        for (int i = 1; i <= numChildren; ++i) {
            int temp;
            Variable child = currentField.getChild(i);
            if (child.length() <= 0) continue;
            if (!child.isElementary()) {
                if (this.searchForKey(child)) {
                    temp = this.initFileDesc(fieldDescArray, child, v, offset);
                    if (temp < 0) {
                        return temp;
                    }
                    offset = temp;
                    continue;
                }
                if (offset < fieldDescArray.length && this.variableMatchesFieldDescription(fieldDescArray[offset], child)) {
                    v.addElement(child);
                    ++offset;
                    continue;
                }
                if (this.isTrace()) {
                    AS400Connect.trace("Current variable='" + child.getName() + "' != fieldDesc[" + offset + "]='" + fieldDescArray[offset].getDDSName() + "'");
                }
                return -1;
            }
            temp = this.initFileDesc(fieldDescArray, child, v, offset);
            if (temp < 0) {
                return temp;
            }
            offset = temp;
        }
        return offset;
    }

    private boolean initFileDesc(FieldDescription[] fieldDescArray) {
        int size;
        Vector<Variable> v;
        if (this.isTrace()) {
            AS400Connect.trace("Initializing file descriptor...");
        }
        if (this.initFileDesc(fieldDescArray, this.masterRecord, v = new Vector<Variable>(), 0) < 0 && this.isTrace()) {
            AS400Connect.trace("Error: Could not match file descriptor with file's field descriptions.");
        }
        if ((size = v.size()) == 0) {
            if (this.isTrace()) {
                AS400Connect.trace("Error: No elements in file descriptor.");
            }
            return false;
        }
        this.fileDesc = new Variable[size];
        v.copyInto(this.fileDesc);
        if (this.isTrace()) {
            AS400Connect.trace("Successful.");
        }
        return true;
    }

    private Variable getVariableWithOffset(int offset) {
        return this.fileDesc[offset];
    }

    private int setVariableObject(int offset, Object value) {
        Variable v = this.getVariableWithOffset(offset);
        if (v == null) {
            return -1;
        }
        return this.setVariableObject(v, value);
    }

    private Record getRecordFromBytes(KeyedFile file2, byte[] bytes, int offset, int len, int size) {
        RecordFormat recordFormat = file2.getRecordFormat();
        Record r = recordFormat.getNewRecord();
        FieldDescription[] fieldDescArray = recordFormat.getFieldDescriptions();
        if (fieldDescArray != null) {
            int descLen = fieldDescArray.length;
            if (this.fileDesc == null && !this.initFileDesc(fieldDescArray)) {
                return null;
            }
            for (int i = 0; i < descLen; ++i) {
                Object o = this.getVariableObject(this.fileDesc[i]);
                if (o == null) {
                    return null;
                }
                r.setField(i, o);
            }
        }
        return r;
    }

    private int setBytesUsingRecord(Record r, byte[] bytes, int offset, int len) {
        Object[] fieldValue = null;
        try {
            fieldValue = r.getFields();
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("Error setting bytes, e=" + e);
            }
            return -1;
        }
        RecordFormat recordFormat = r.getRecordFormat();
        FieldDescription[] fieldDescArray = recordFormat.getFieldDescriptions();
        if (this.fileDesc == null && !this.initFileDesc(fieldDescArray)) {
            return -1;
        }
        int index = 0;
        if (fieldDescArray != null) {
            for (int i = 0; i < fieldDescArray.length; ++i) {
                int len2 = this.setVariableObject(i, fieldValue[i]);
                if (len2 < 0) {
                    if (this.isTrace()) {
                        AS400Connect.trace("Error setting variable object, fieldValue[" + i + "]=" + fieldValue[i]);
                    }
                    return -1;
                }
                index += len2;
            }
        }
        int length = index;
        if (this.masterRecord.length() < length) {
            length = this.masterRecord.length();
        }
        this.masterRecord.getMemory().copy(this.masterRecord.getAddress(), bytes, offset, length);
        return length;
    }

    public int i_begin(IFilePtr rf) {
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            file2.startCommitmentControl(4);
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_begin failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_close(IFilePtr rf) {
        if (rf == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            file2.close();
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_close failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_commit(IFilePtr rf, int context) {
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            file2.commit();
            file2.endCommitmentControl();
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_commit failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_delete(IFilePtr rf) {
        if (rf == null) {
            if (this.isTrace()) {
                AS400Connect.trace("Unable to delete record, file pointer does not exist");
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        Object[] key = this.getKeyObjects();
        try {
            KeyedFile file2 = rf.getKeyedFile();
            file2.deleteRecord(key);
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_delete failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_exit() {
        this.returnCode = 0;
        this.AS400ConnectSendEnd(5);
        this.masterRecord = null;
        this.keyArray = null;
        this.fileDesc = null;
        return 1;
    }

    public int i_info(IFilePtr rf, int mode, StringBuffer result) {
        if (result == null || rf == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            switch (mode) {
                case -1: {
                    result.append(this.logical_params);
                    break;
                }
                case -2: {
                    result.append("" + file2.getBlockingFactor() + ", 0, 0, 0, 0");
                    break;
                }
                case -3: {
                    result.append(this.comment);
                    break;
                }
                case -5: 
                case -4: {
                    this.setErrno(17);
                    return 0;
                }
                case -6: {
                    try {
                        int[] locks = file2.getExplicitLocks();
                        if (locks == null) break;
                        result.append("" + locks.length);
                        break;
                    }
                    catch (Exception e) {
                        this.setErrno(1);
                        return 0;
                    }
                }
                default: {
                    this.setErrno(17);
                    return 0;
                }
            }
            return 1;
        }
        catch (Exception e) {
            this.setErrno(e);
            return 0;
        }
    }

    public int i_init(Variable masterRecord, Variable[] keyArray, int[] keyLength, boolean[] keyDuplicates, int numKeys) {
        this.returnCode = 0;
        this.masterRecord = masterRecord;
        this.numberOfKeys = numKeys;
        this.keyArray = keyArray;
        return this.returnCode == 0 ? 1 : 0;
    }

    public int i_make(String filename, String comment, String physical_params, String logical_params, String keys, String transTable) {
        if (filename == null || filename.trim().length() == 0 || keys == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_make failed on invalid parameter, filename='" + filename + "', keys='" + keys + "'");
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        if (this.isTrace()) {
            AS400Connect.trace("i_make:  filename='" + filename + "', comment='" + comment + "', physical_params='" + physical_params + "', logical_params='" + logical_params + "', keys='" + keys + "', transTable='" + transTable + "'");
        }
        this.setErrno(0);
        String[] result = AS400Connect.getHostnameAndFilenameFromString(filename);
        if (result == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_make failed, could not obtain hostname and filename separation");
            }
            this.setErrno(2);
            return 0;
        }
        String hostname = result[0];
        filename = result[1];
        if (!this.isConnected(5) && !this.initSocketConnection(hostname)) {
            return 0;
        }
        this.comment = comment;
        this.logical_params = logical_params;
        this.parseLogicalParams(logical_params);
        try {
            KeyedFile file2 = new KeyedFile(this.as400, filename);
            RecordFormat recordFormat = null;
            boolean unique = true;
            String format = null;
            String text = null;
            format = this.getRecordFormatName(filename);
            if (format == null) {
                return 0;
            }
            recordFormat = new RecordFormat(format);
            try {
                if (!this.addFieldsToRecordFormat(recordFormat)) {
                    if (this.isTrace()) {
                        AS400Connect.trace("i_make failed, could not create a match from file descriptor to file's field descriptions");
                    }
                    this.setErrno(13);
                    return 0;
                }
            }
            catch (Exception e) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_make failed, e=" + e);
                }
                this.setErrno(e);
                return 0;
            }
            comment = null;
            text = "Elastic COBOL Generated";
            try {
                file2.create(recordFormat, text, null, null, null, null, unique, null, null);
            }
            catch (AS400Exception e) {
                file2.delete();
                file2.create(recordFormat, text, null, null, null, null, unique, null, null);
            }
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_make failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_next(IFilePtr rf, byte[] record) {
        return this.i_next(rf, record, 0, record.length);
    }

    public int i_next(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_next failed, file pointer or record bytes is null.  File pointer=" + rf);
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            Record r = file2.readNext();
            if (r == null) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_next could not read next record");
                }
                this.setErrno(8);
                return 0;
            }
            int len = this.setBytesUsingRecord(r, record, offset, length);
            if (len < 0) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_next failed, could not set bytes using record");
                }
                this.setErrno(21);
                return 0;
            }
            return len;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_next failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    private int convertOpenMode(int mode) {
        switch (mode) {
            case 0: {
                mode = 0;
                break;
            }
            case 1: 
            case 3: {
                mode = 2;
                break;
            }
            default: {
                mode = 1;
            }
        }
        return mode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setFileLocking(AS400File file2, int mode) {
        try {
            if ((mode & 0x600) != 0) {
                file2.lock(5);
            } else if ((mode & 0x100) != 0) {
                file2.lock(1);
            } else if ((mode & 0x200) != 0) {
                file2.lock(5);
            }
            if ((mode & 0x10) != 0) {
                // empty if block
            }
            if ((mode & 0x4000) == 0) return true;
        }
        catch (Exception e) {
            this.setErrno(e);
            return false;
        }
        return true;
    }

    public IFilePtr i_open(String filename, int mode, String logical_params) {
        String[] result;
        if (filename == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_open failed, filename is null");
            }
            this.setErrno(2);
            return null;
        }
        this.returnCode = 0;
        this.setErrno(0);
        if (this.isTrace()) {
            AS400Connect.trace("i_open:  filename='" + filename + "', mode='" + mode + "', logical_params='" + logical_params + "'");
        }
        if ((result = AS400Connect.getHostnameAndFilenameFromString(filename)) == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_open failed, unable to obtain hostname and filename separation");
            }
            this.setErrno(2);
            return null;
        }
        String hostname = result[0];
        filename = result[1];
        if (!this.isConnected(5) && !this.initSocketConnection(hostname)) {
            return null;
        }
        KeyedFile file2 = null;
        try {
            file2 = new KeyedFile(this.as400, filename);
            AS400FileRecordDescription rd = new AS400FileRecordDescription(this.as400, filename);
            RecordFormat[] formats = rd.retrieveRecordFormat();
            file2.setRecordFormat(formats[0]);
            int as400Mode = this.convertOpenMode(mode);
            if (!this.setFileLocking((AS400File)file2, mode)) {
                return null;
            }
            file2.open(as400Mode, 1, 4);
            this.logical_params = logical_params;
            if (mode == 3) {
                try {
                    file2.positionCursorAfterLast();
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    file2.positionCursorBeforeFirst();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            AS400Message msg;
            if (this.isTrace()) {
                AS400Connect.trace("i_open failed, e=" + e);
            }
            if (e instanceof AS400Exception && "CPF3012".equalsIgnoreCase((msg = ((AS400Exception)((Object)e)).getAS400Message()).getID())) {
                this.setErrno(15);
                return null;
            }
            this.setErrno(e);
            return null;
        }
        IFilePtr fp = new IFilePtr(file2);
        return fp;
    }

    public int i_previous(IFilePtr rf, byte[] record) {
        return this.i_previous(rf, record, 0, record.length);
    }

    public int i_previous(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_previous failed, file pointer or record bytes is null.  File pointer=" + rf);
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            Record r = file2.readPrevious();
            if (r == null) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_previous could not read previous record");
                }
                this.setErrno(8);
                return 0;
            }
            int len = this.setBytesUsingRecord(r, record, offset, length);
            if (len < 0) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_previous failed, could not set bytes using record");
                }
                this.setErrno(21);
                return 0;
            }
            return len;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_previous failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_read(IFilePtr rf, byte[] record, int keynum) {
        return this.i_read(rf, record, 0, record.length, keynum);
    }

    public int i_read(IFilePtr rf, byte[] record, int offset, int length, int keynum) {
        if (rf == null || record == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_read failed, file pointer or record bytes is null.  File pointer=" + rf);
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        Object[] key = this.getKeyObjects();
        try {
            KeyedFile file2 = rf.getKeyedFile();
            Record r = file2.read(key);
            if (r == null) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_read could not read record using key");
                    if (key != null) {
                        int keylen = key.length;
                        for (int i = 0; i < keylen; ++i) {
                            AS400Connect.trace("key[" + i + "]='" + key[i] + "'");
                        }
                    }
                }
                this.setErrno(8);
                return 0;
            }
            int len = this.setBytesUsingRecord(r, record, offset, length);
            if (len < 0) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_read failed, could not set bytes using record");
                }
                this.setErrno(21);
                return 0;
            }
            return len;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_read failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_recover() {
        this.setErrno(17);
        return 0;
    }

    public int i_remove(String filename) {
        if (filename == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_remove failed, filename is null");
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        String[] result = AS400Connect.getHostnameAndFilenameFromString(filename);
        if (result == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_remove failed, could not obtain filename and hostname separation");
            }
            this.setErrno(2);
            return 0;
        }
        String hostname = result[0];
        filename = result[1];
        if (!this.isConnected(5) && !this.initSocketConnection(hostname)) {
            return this.returnCode;
        }
        try {
            KeyedFile file2 = new KeyedFile(this.as400, filename);
            file2.delete();
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_remove failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_rename(String fromname, String toname) {
        if (this.isTrace()) {
            AS400Connect.trace("No support for i_rename");
        }
        this.setErrno(17);
        return 0;
    }

    public int i_rewrite(IFilePtr rf, byte[] record, int size) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        return this.i_rewrite(rf, record, 0, record.length, size);
    }

    public int i_rewrite(IFilePtr rf, byte[] record, int offset, int length, int size) {
        if (rf == null || record == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_rewrite failed, file pointer or record bytes is null.  File pointer=" + rf);
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        Object[] key = this.getKeyObjects();
        try {
            KeyedFile file2 = rf.getKeyedFile();
            Record r = this.getRecordFromBytes(file2, record, offset, length, size);
            if (r == null) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_rewrite failed, could not get record from bytes");
                }
                this.setErrno(21);
                return 0;
            }
            file2.update(key, r);
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_rewrite failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public int i_rollback(IFilePtr rf, int context) {
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            file2.rollback();
            file2.endCommitmentControl();
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_rollback failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    private int convertStartMode(int mode) {
        switch (mode) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    public int i_start(IFilePtr rf, byte[] record, int keynum, int keysize, int mode) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        return this.i_start(rf, record, 0, record.length, keynum, keysize, mode);
    }

    public int i_start(IFilePtr rf, byte[] record, int offset, int length, int keynum, int keysize, int mode) {
        if (rf == null || record == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_start failed, file pointer or record bytes is null.  File pointer=" + rf);
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        Object[] key = this.getKeyObjects();
        try {
            KeyedFile file2 = rf.getKeyedFile();
            int startMode = this.convertStartMode(mode);
            file2.positionCursor(key, startMode);
            return 1;
        }
        catch (Exception e) {
            if (this.isTrace()) {
                AS400Connect.trace("i_start failed, e=" + e);
            }
            this.setErrno(e);
            return 0;
        }
    }

    public void i_sync(int all_files) {
        if (this.isTrace()) {
            AS400Connect.trace("No support for i_sync");
        }
        this.setErrno(17);
    }

    public int i_unlock(IFilePtr rf) {
        if (this.isTrace()) {
            AS400Connect.trace("No support for i_unlock");
        }
        this.setErrno(17);
        return 0;
    }

    public int i_version(StringBuffer filename, StringBuffer file_version, StringBuffer int_version, int system_num) {
        this.returnCode = 0;
        try {
            filename.setLength(0);
            filename.append("AS400Connect client");
            file_version.setLength(0);
            file_version.append("1.0.0");
            int_version.setLength(0);
            int_version.append("1");
            return 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int i_write(IFilePtr rf, byte[] record, int size) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        return this.i_write(rf, record, 0, record.length, size);
    }

    public int i_write(IFilePtr rf, byte[] record, int offset, int length, int size) {
        if (rf == null || record == null) {
            if (this.isTrace()) {
                AS400Connect.trace("i_write failed, file pointer or record bytes is null.  File pointer=" + rf);
            }
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        try {
            KeyedFile file2 = rf.getKeyedFile();
            Record r = this.getRecordFromBytes(file2, record, offset, length, size);
            if (r == null) {
                if (this.isTrace()) {
                    AS400Connect.trace("i_write failed, could not get record from bytes");
                }
                this.setErrno(21);
                return 0;
            }
            file2.write(r);
            return 1;
        }
        catch (Exception e) {
            int rc;
            if (this.isTrace()) {
                AS400Connect.trace("i_write failed, e=" + e);
            }
            if (e instanceof ErrorCompletingRequestException && (rc = ((ErrorCompletingRequestException)e).getReturnCode()) == 1) {
                this.setErrno(7);
                return 0;
            }
            this.setErrno(e);
            return 0;
        }
    }

    public static void removeAS400Connection(String systemName) {
        connections.remove(systemName);
    }

    public static void removeAllAS400Connections() {
        connections.clear();
    }

    public static AS400Connect getAS400Connection(Context context, String systemName) {
        if ((systemName == null || systemName.trim().length() == 0) && (systemName = RuntimeEnvironment.getGlobalParameter(KEY_SERVER_ADDRESS)) == null) {
            systemName = "localhost";
        }
        try {
            AS400Connect myCon = null;
            try {
                myCon = connections.get(systemName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (myCon != null) {
                return myCon;
            }
            myCon = new AS400Connect(context, systemName);
            connections.put(systemName, myCon);
            return myCon;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setCurrentCallName(String name) {
        this.currentCallName = name;
    }

    public String getCurrentCallName() {
        return this.currentCallName;
    }

    public boolean getCallNameExists(String name) {
        if (name == null || this.callNames == null) {
            return false;
        }
        return this.callNames.contains(name);
    }

    public boolean addCallName(String name) {
        if (this.callNames == null) {
            this.callNames = new Vector();
            this.callNames.addElement(name);
            return true;
        }
        if (!this.callNames.contains(name)) {
            this.callNames.addElement(name);
            return true;
        }
        return false;
    }

    public boolean removeCallName(String name) {
        if (this.callNames == null) {
            return false;
        }
        if (this.currentCallName != null && this.currentCallName.equals(name)) {
            this.currentCallName = null;
        }
        boolean result = this.callNames.removeElement(name);
        AS400Connect.removeAS400Connection(name);
        if ((this.callNames == null || this.callNames.size() == 0) && this.isConnected(2)) {
            this.AS400ConnectSendEnd(2);
        }
        return result;
    }

    public void removeAllCallNames() {
        while (this.callNames != null && this.callNames.size() > 0) {
            this.removeCallName(this.callNames.elementAt(0));
        }
    }

    public void removeCurrentCallName() {
        if (this.callNames != null) {
            this.removeCallName(this.currentCallName);
        }
    }

    public int getLastCallError() {
        return this.lastReturnCode;
    }

    private void setLastCallError(int val) {
        this.lastReturnCode = val;
    }

    private int AS400ConnectCancel(String name) {
        if (name == null || name.length() == 0) {
            return -1;
        }
        if (this.getCloseAfterCancel()) {
            this.removeCurrentCallName();
        }
        return 0;
    }

    private int inner_cancel(String name) {
        if (name == null || name.trim().length() == 0) {
            return -1;
        }
        this.returnCode = 0;
        String nameCallString = null;
        if (name != null) {
            int nameCall = AS400Connect.strchr(name, ':');
            nameCall = nameCall > 0 && name.charAt(0) == '*' ? ++nameCall : 0;
            nameCallString = name.substring(nameCall);
        }
        this.returnCode = this.AS400ConnectCancel(nameCallString);
        if (this.returnCode == -3) {
            this.returnCode = -2;
        }
        return this.returnCode;
    }

    public static final AS400Connect getProgramByName(Context context, String name) {
        if (name == null) {
            return null;
        }
        try {
            int nameCall = AS400Connect.strchr(name, ':');
            String nameHost = null;
            if (nameCall > 0 && name.charAt(0) == '*') {
                nameHost = name.substring(1, nameCall);
                ++nameCall;
            } else {
                nameCall = 0;
            }
            String nameCallString = name.substring(nameCall);
            if (nameHost == null) {
                nameHost = "localhost";
            }
            if (nameCallString == null) {
                return null;
            }
            AS400Connect con = null;
            if (nameHost != null) {
                if (connections == null) {
                    connections = new Hashtable();
                } else {
                    AS400Connect o = connections.get(nameHost);
                    if (o != null) {
                        con = o;
                    }
                }
                if (con == null) {
                    con = new AS400Connect(context);
                    connections.put(nameHost, con);
                }
            }
            if (con != null) {
                con.addCallName(name);
                con.setCurrentCallName(name);
            }
            return con;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String getJobInfo() {
        ProgramParameter[] parameterList2 = new ProgramParameter[6];
        byte[] dataReceived = new byte[46];
        parameterList2[0] = new ProgramParameter(dataReceived.length);
        byte[] receiverLength = new byte[4];
        BinaryConverter.intToByteArray((int)dataReceived.length, (byte[])receiverLength, (int)0);
        parameterList2[1] = new ProgramParameter(receiverLength);
        byte[] formatName = new AS400Text(8, this.as400).toBytes((Object)"RTVC0100");
        parameterList2[2] = new ProgramParameter(formatName);
        byte[] numAttributes = new byte[4];
        BinaryConverter.intToByteArray((int)1, (byte[])numAttributes, (int)0);
        parameterList2[3] = new ProgramParameter(numAttributes);
        byte[] attributeKey = new byte[4];
        BinaryConverter.intToByteArray((int)1009, (byte[])attributeKey, (int)0);
        parameterList2[4] = new ProgramParameter(attributeKey);
        byte[] errorCode = new byte[17];
        BinaryConverter.intToByteArray((int)0, (byte[])errorCode, (int)0);
        parameterList2[5] = new ProgramParameter(errorCode, 17);
        try {
            ProgramCall pgm = new ProgramCall(this.as400);
            pgm.setProgram("/QSYS.LIB/QWCRTVCA.PGM", parameterList2);
            if (!pgm.run()) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        dataReceived = parameterList2[0].getOutputData();
        int numAttributesReturned = BinaryConverter.byteArrayToInt((byte[])dataReceived, (int)0);
        if (numAttributesReturned != 1) {
            return null;
        }
        return (String)new AS400Text(26, this.as400).toObject(dataReceived, 20);
    }

    private int inner_call(String name, parameterList params) {
        block24: {
            this.returnCode = -1;
            int nameCall = AS400Connect.strchr(name, ':');
            String nameHost = null;
            if (nameCall > 0 && name.charAt(0) == '*') {
                nameHost = name.substring(1, nameCall);
                ++nameCall;
            } else {
                nameCall = 0;
            }
            String nameCallString = name.substring(nameCall);
            try {
                if (nameCallString != null) {
                    if (!this.isConnected(2) && !this.initSocketConnection(nameHost, 2)) {
                        return 25;
                    }
                    boolean returnFlag = false;
                    try {
                        ProgramCall pgm = new ProgramCall(this.as400);
                        ProgramParameter[] args = this.getArgs(params);
                        String library = "/QSYS.LIB/%LIBL%.LIB";
                        String progName = null;
                        int libindex = nameCallString.indexOf(33);
                        if (libindex >= 0) {
                            try {
                                library = nameCallString.substring(libindex + 1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                progName = nameCallString.substring(0, libindex) + ".PGM";
                            }
                            catch (Exception exception) {}
                        } else {
                            progName = nameCallString + ".PGM";
                        }
                        nameCallString = library + "/" + progName;
                        pgm.setProgram(nameCallString, args);
                        returnFlag = pgm.run();
                        if (!returnFlag) {
                            try {
                                AS400Message[] messageList = pgm.getMessageList();
                                if (messageList != null) {
                                    AS400Message msg;
                                    for (int m = 0; m < messageList.length && (msg = messageList[m]) != null; ++m) {
                                    }
                                }
                            }
                            catch (Exception messageList) {
                                // empty catch block
                            }
                            this.returnCode = -1;
                            break block24;
                        }
                        this.returnCode = 0;
                        this.updateParamsFromArgs(params, args);
                        if (!RuntimeEnvironment.isGlobalParameter("KEY_DISPLAY_CALL")) break block24;
                        try {
                            String jobInfo = this.getJobInfo();
                            String jobName = jobInfo.substring(0, 10).trim();
                            String jobUser = jobInfo.substring(10, 20).trim();
                            String jobID = jobInfo.substring(20, 26).trim();
                            JobLog log = new JobLog(this.as400, jobName, jobUser, jobID);
                            StringBuffer msgText = new StringBuffer();
                            Enumeration e = log.getMessages();
                            while (e.hasMoreElements()) {
                                QueuedMessage message = (QueuedMessage)e.nextElement();
                                String fromProgram = message.getFromProgram();
                                if (!"QLRADRTN".equalsIgnoreCase(fromProgram)) continue;
                                msgText.insert(0, message.getText() + this.lineSep);
                            }
                            System.out.print(msgText.toString());
                            break block24;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Exception e) {
                        this.returnCode = AS400Connect.getErrorFromException(e);
                    }
                    break block24;
                }
                this.returnCode = -1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.returnCode == -5 || this.returnCode == 5 || this.returnCode == -7 || this.returnCode == -3 || this.returnCode == -4) {
            this.returnCode = -2;
        }
        if (this.returnCode == -1) {
            this.returnCode = -1;
        }
        return this.returnCode;
    }

    private int call(String programName, parameterList args) {
        int result = -1;
        int pntStart = 0;
        int pntEnd = 0;
        boolean tappo = false;
        String sep = "\\";
        try {
            sep = System.getProperty("file.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String codePrefix = this.getCodePrefix();
        if (programName != null && codePrefix == null && (result = this.inner_call(programName, args)) == -1) {
            this.removeCallName(programName);
        }
        while (codePrefix != null && result == -1 && pntStart < codePrefix.length()) {
            tappo = false;
            while (pntStart < codePrefix.length() && codePrefix.charAt(pntStart) != '\u0000' && (codePrefix.charAt(pntStart) == ' ' || codePrefix.charAt(pntStart) == '\t')) {
                ++pntStart;
            }
            for (pntEnd = pntStart; pntEnd < codePrefix.length() && codePrefix.charAt(pntEnd) != '\u0000' && codePrefix.charAt(pntEnd) != ' ' && codePrefix.charAt(pntEnd) != '\t' && codePrefix.charAt(pntEnd) != ';'; ++pntEnd) {
            }
            if (pntEnd >= codePrefix.length() || codePrefix.charAt(pntEnd) == '\u0000') {
                tappo = true;
            }
            codePrefix = pntStart >= codePrefix.length() ? "" : (pntEnd < codePrefix.length() ? codePrefix.substring(pntStart, pntEnd) : codePrefix.substring(pntStart));
            String fullPath = null;
            fullPath = programName != null && programName.length() > 3 && programName.charAt(1) == ':' ? (codePrefix != null && codePrefix.length() > 3 && codePrefix.charAt(1) == ':' ? codePrefix + sep + programName.substring(2) : (codePrefix != null && codePrefix.charAt(0) == '*' ? codePrefix + sep + programName : (codePrefix != null ? programName.substring(0, 2) + codePrefix + sep + programName.substring(2) : programName.substring(0, 2) + sep + programName.substring(2)))) : (codePrefix != null ? codePrefix + sep + programName : "" + sep + programName);
            if (fullPath != null) {
                AS400Connect con = AS400Connect.getProgramByName(this.context, fullPath);
                if (con != null) {
                    result = this.inner_call(fullPath, args);
                }
                if (result == -1) {
                    if (con != null) {
                        con.removeCallName(fullPath);
                    }
                } else {
                    String hostName = con.getHost();
                    if (hostName != null) {
                        connections.put(hostName, con);
                        con.addCallName(fullPath);
                        con.setCurrentCallName(fullPath);
                    }
                }
            }
            fullPath = null;
            if (!tappo) {
                pntStart = pntEnd + 1;
                continue;
            }
            pntStart = 0;
        }
        return result;
    }

    private ProgramParameter[] getArgs(parameterList params) {
        if (params == null) {
            return null;
        }
        ProgramParameter[] args = new ProgramParameter[params.getLength()];
        for (int i = 0; i < args.length; ++i) {
            boolean isByReference = params.isByReference(i);
            int type = isByReference ? 2 : 1;
            try {
                ProgramParameter param;
                byte[] inBytes;
                Object o = params.getObject(i);
                if (o instanceof Variable) {
                    Variable v = (Variable)o;
                    AS400DataType datatype = null;
                    Object vo = null;
                    try {
                        datatype = this.getDataType(v);
                        vo = this.getVariableObject(v);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    inBytes = datatype.toBytes(vo);
                    if (inBytes == null) continue;
                    param = isByReference ? new ProgramParameter(type, inBytes, inBytes.length) : new ProgramParameter(type, inBytes);
                    args[i] = param;
                    continue;
                }
                if (o instanceof Index) {
                    Index ix = (Index)o;
                    int value = ix.toInt();
                    Integer obj = new Integer(value);
                    inBytes = new AS400Bin4().toBytes((Object)obj);
                    if (inBytes == null) continue;
                    param = isByReference ? new ProgramParameter(type, inBytes, inBytes.length) : new ProgramParameter(type, inBytes);
                    args[i] = param;
                    continue;
                }
                String text = o.toString();
                if (text == null || text.length() <= 0) continue;
                int len = text.length();
                AS400Text tt = null;
                try {
                    tt = !AS400TextIsOldStyle ? new AS400Text(len, this.as400) : new AS400Text(len);
                }
                catch (Throwable t) {
                    AS400TextIsOldStyle = true;
                    tt = new AS400Text(len);
                }
                inBytes = tt.toBytes((Object)text);
                if (inBytes == null) continue;
                param = isByReference ? new ProgramParameter(type, inBytes, inBytes.length) : new ProgramParameter(type, inBytes);
                args[i] = param;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return args;
    }

    private void updateParamsFromArgs(parameterList params, ProgramParameter[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!params.byReference(i)) continue;
            ProgramParameter arg = args[i];
            byte[] bytes = arg.getOutputData();
            try {
                Object o = params.getObject(i);
                if (o instanceof Variable) {
                    Variable v = (Variable)o;
                    AS400DataType datatype = this.getDataType(v);
                    Object vo = datatype.toObject(bytes);
                    this.setVariableObject(v, vo);
                    continue;
                }
                if (!(o instanceof Index)) continue;
                Index ix = (Index)o;
                Integer obj = (Integer)new AS400Bin4().toObject(bytes);
                int val = obj;
                ix.setTo(val);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object callGiving() {
        return this.callGiving(null);
    }

    @Override
    public void call() {
        this.call(null);
    }

    @Override
    public Object callGiving(parameterList params) {
        int result = 0;
        this.setLastCallError(result);
        String name = this.getCurrentCallName();
        if (name == null) {
            result = -1;
            this.setLastCallError(result);
            return new Numeric(result);
        }
        result = this.call(name, params);
        this.setLastCallError(result);
        return new Numeric(result);
    }

    @Override
    public void call(parameterList params) {
        int result = 0;
        this.setLastCallError(result);
        String name = this.getCurrentCallName();
        if (name == null) {
            this.setLastCallError(-1);
            return;
        }
        result = this.call(name, params);
        this.setLastCallError(result);
    }

    @Override
    public void cancel() {
        int result = 0;
        this.setLastCallError(result);
        String name = this.getCurrentCallName();
        if (name == null) {
            this.setLastCallError(-1);
            return;
        }
        result = this.inner_cancel(name);
        this.setLastCallError(result);
    }

    @Override
    public String redirectCall() {
        return null;
    }

    public class IFilePtr {
        private KeyedFile file = null;

        public IFilePtr(KeyedFile kf) {
            this.file = kf;
        }

        public KeyedFile getKeyedFile() {
            return this.file;
        }
    }
}

