/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.AS400Connect;
import com.heirloomcomputing.ecs.exec.IndexedFile;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class AS400IndexedFile
extends IndexedFile {
    private static final boolean debugMode = false;
    private static final int[] mapStatusTable = new int[]{0, 30, 39, 94, 48, 99, 98, 22, 23, 0, 24, 93, 44, 0, 30, 35, 37, 30, 54, 30};
    protected AS400Connect file = null;
    protected AS400Connect.IFilePtr fileHandle = null;
    protected String oldFilename = null;
    protected String physical_params = null;
    protected String logical_params = null;
    protected String key_params = null;
    protected boolean isNewFile = false;
    protected boolean readable = false;
    protected boolean writable = false;
    protected boolean extend = false;
    protected boolean isOpen = false;
    protected boolean isAtBeginningOfFile = false;
    protected boolean isAtEndOfFile = false;
    private byte[] tempRecord;

    public static final void debug(String text) {
        System.out.println("AS400IndexedFile: " + text);
    }

    private void initPhysicalParams() {
        this.physical_params = "";
        int blockSize = 0;
        if (this.blockTo > 0) {
            if (this.isRecords) {
                if (this.blockTo * this.maximum > this.maximum) {
                    blockSize = this.blockTo * this.maximum;
                }
            } else if (this.blockTo > this.maximum) {
                blockSize = this.blockTo;
            }
        }
        this.physical_params = blockSize > 0 ? this.physical_params + String.valueOf(blockSize) + ", 0, 0, " : this.physical_params + String.valueOf(0) + ", 0, 0, ";
        int compressionFactor = this.dataCompression;
        try {
            String compressFactorString = RuntimeEnvironment.getGlobalParameter("COMPRESS_FACTOR");
            if (compressFactorString != null) {
                compressionFactor = Integer.valueOf(compressFactorString);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.physical_params = this.physical_params + "" + compressionFactor + ", " + (this.dataEncryption ? 1 : 0);
    }

    private void initLogicalParams() {
        this.logical_params = "";
        this.logical_params = this.maximum > 0 ? this.logical_params + String.valueOf(this.maximum) + ", " : this.logical_params + String.valueOf(1) + ", ";
        this.logical_params = this.minimum > 0 ? this.logical_params + String.valueOf(this.minimum) + ", " : this.logical_params + String.valueOf(1) + ", ";
        this.logical_params = this.logical_params + String.valueOf(this.numberOfKeys);
    }

    private void initKeyParams() {
        this.key_params = "";
        int masterRecordAddress = this.masterRecord.getAddress();
        for (int i = 0; i < this.numberOfKeys; ++i) {
            int numSegments = 1;
            Variable[] list = null;
            Variable v = this.keyArray[i];
            if (v instanceof VariableList) {
                list = ((VariableList)v).getList();
                numSegments = list.length;
            }
            this.key_params = this.key_params + String.valueOf(numSegments) + ", ";
            this.key_params = this.keyDuplicates[i] ? this.key_params + "1, " : this.key_params + "0, ";
            if (list == null) {
                this.key_params = this.key_params + String.valueOf(this.keyLength[i]) + ", " + String.valueOf(this.keyOffsets[i]);
            } else {
                for (int j = 0; j < numSegments; ++j) {
                    if (list != null) {
                        v = list[j];
                    }
                    this.key_params = this.key_params + String.valueOf(v.length()) + ", " + String.valueOf(v.getAddress() - masterRecordAddress);
                    if (j >= numSegments - 1) continue;
                    this.key_params = this.key_params + ", ";
                }
            }
            if (i >= this.numberOfKeys - 1) continue;
            this.key_params = this.key_params + ", ";
        }
    }

    @Override
    public boolean init(boolean remote2, String site, int port, String filename, int numberOfKeys, Variable[] keyArray, boolean[] keyDuplicates, boolean optional, int reserve, Variable fileStatus, int accessMode, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes, int keyCompression, int dataCompression, int idxFormat, boolean dataEncryption) {
        try {
            this.file = new AS400Connect(this.context);
        }
        catch (Throwable t) {
            return false;
        }
        return super.init(remote2, site, port, filename, numberOfKeys, keyArray, keyDuplicates, optional, reserve, fileStatus, accessMode, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, newModes, keyCompression, dataCompression, idxFormat, dataEncryption);
    }

    @Override
    boolean idx_init() {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        this.setIsAtEndOfFile(false);
        this.setIsAtBeginningOfFile(false);
        this.idx_setFilename(this.filename);
        this.initPhysicalParams();
        this.initLogicalParams();
        this.initKeyParams();
        this.tempRecord = new byte[this.maximum];
        int result = this.file.i_init(this.masterRecord, this.keyArray, this.keyLength, this.keyDuplicates, this.numberOfKeys);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        return result != 0;
    }

    @Override
    boolean idx_setFilename(String filename) {
        if (this.file == null) {
            return false;
        }
        if (this.oldFilename == null) {
            this.oldFilename = filename;
            return true;
        }
        if (!this.oldFilename.equals(filename)) {
            int result = this.file.i_rename(this.oldFilename, filename);
            int errno = this.file.getErrno();
            if (errno != 0) {
                this.setIOStatus(-errno - 80000);
            }
            int returnCode = this.getPriorError();
            if (result == 0) {
                return false;
            }
            this.oldFilename = filename;
            return true;
        }
        return true;
    }

    @Override
    boolean idx_resetCache() {
        return true;
    }

    @Override
    boolean idx_flushCache() {
        if (this.file == null) {
            this.setIOStatus(-90);
            return true;
        }
        this.file.i_sync(1);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        return true;
    }

    @Override
    int idx_mapStatusCode(int status) {
        if (status <= -80000) {
            if ((status = -status - 80000) == 0) {
                return status;
            }
            if (status > 0 && status < 20) {
                int newStatus = -mapStatusTable[status];
                return newStatus;
            }
            if (status == 100) {
                return 0;
            }
            if (status == 101) {
                return -2;
            }
            this.warning("AS400IndexedFile.idx_mapStatusCode", "unexpected status " + status);
            status = -30;
        }
        return status;
    }

    private int mapOpenMode(int mode) {
        if (mode == 0) {
            return mode;
        }
        int aMode = 0;
        int openMode = mode & 7;
        if (openMode == 3) {
            aMode = 2;
        } else if (openMode == 1) {
            aMode = 0;
        } else if (openMode == 2) {
            aMode = 1;
        }
        if ((openMode & 4) == 4) {
            aMode = 3;
        }
        if ((mode & 0xA0000) != 0) {
            if ((mode & 0x40000) == 262144) {
                aMode |= 0x200;
            } else if ((mode & 0x80000) == 524288) {
                aMode |= 0x100;
            }
            if ((mode & 0x8000) == 32768) {
                aMode |= 0x600;
            }
            if (this.lockingMultiple()) {
                aMode |= 0x10;
            }
            if ((mode & 0x8000000) == 0x8000000) {
                aMode |= 0x4000;
            }
        }
        return aMode;
    }

    private int mapStartMode(int mode) {
        if (mode == 0) {
            return 0;
        }
        if (mode == 1) {
            return 1;
        }
        if (mode == 2) {
            return 2;
        }
        if (mode == -2) {
            return 3;
        }
        if (mode == -1) {
            return 4;
        }
        return mode;
    }

    private boolean checkLogicalParams(String text) {
        int len;
        if (text == null) {
            return false;
        }
        for (len = text.length(); len > 0 && text.charAt(len - 1) < ' '; --len) {
        }
        if (len > 0) {
            text = text.substring(0, len);
        }
        int max = 0;
        int min = 0;
        int numKeys = 0;
        int index = text.indexOf(44);
        try {
            max = Integer.valueOf(text.substring(0, index));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (max != this.maximum) {
            return false;
        }
        try {
            text = text.substring(index + 1).trim();
        }
        catch (Exception e) {
            return false;
        }
        index = text.indexOf(44);
        try {
            min = Integer.valueOf(text.substring(0, index));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (min != this.minimum) {
            return false;
        }
        try {
            text = text.substring(index + 1).trim();
        }
        catch (Exception e) {
            return false;
        }
        try {
            numKeys = Integer.valueOf(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return numKeys == this.numberOfKeys;
    }

    private boolean checkHeaderInformation() {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        StringBuffer buf = new StringBuffer();
        int result = this.file.i_info(this.fileHandle, -1, buf);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        if (result == 0) {
            return false;
        }
        String text = buf.toString();
        boolean flag = this.checkLogicalParams(text);
        return flag;
    }

    private boolean isAtEndOfFile() {
        return this.isAtEndOfFile;
    }

    private void setIsAtEndOfFile(boolean flag) {
        this.isAtEndOfFile = flag;
    }

    private boolean isAtBeginningOfFile() {
        return this.isAtBeginningOfFile;
    }

    private void setIsAtBeginningOfFile(boolean flag) {
        this.isAtBeginningOfFile = flag;
    }

    private boolean idx_create() {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        int result = this.file.i_make(this.filename, "Elastic COBOL", this.physical_params, this.logical_params, this.key_params, "");
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        if (result == 0) {
            return false;
        }
        this.setIsAtBeginningOfFile(true);
        return true;
    }

    @Override
    boolean idx_open(int mode) {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        int returnCode = 0;
        int errno = 0;
        this.writable = (mode & 2) != 0;
        this.readable = (mode & 1) != 0;
        this.extend = (mode & 4) != 0;
        boolean optional = (mode & 8) != 0;
        boolean shouldAlwaysCreate = !this.readable && this.writable && !this.extend;
        boolean optionalIsMissing = false;
        boolean fileIsMissing = false;
        int aMode = this.mapOpenMode(mode);
        if (!shouldAlwaysCreate) {
            for (int i = 0; i < 3; ++i) {
                this.fileHandle = this.file.i_open(this.filename, aMode, this.logical_params);
                errno = this.file.getErrno();
                if (errno != 0) {
                    this.setIOStatus(-errno - 80000);
                }
                returnCode = this.getPriorError();
                if (this.fileHandle != null || returnCode != -93) break;
            }
            if (this.fileHandle == null) {
                if (errno != 15) {
                    this.warning("AS400IndexedFile.idx_open", "file missing");
                    return false;
                }
                fileIsMissing = true;
                if (!optional) {
                    if (!this.writable || this.readable || this.extend) {
                        this.setIOStatus(-35);
                        this.warning("AS400IndexedFile.idx_open", "file missing and optional not specified");
                        return false;
                    }
                } else {
                    optionalIsMissing = true;
                }
            } else {
                if (!this.checkHeaderInformation()) {
                    this.warning("AS400IndexedFile.idx_open", "file header indicates this is not an AS400 Indexed File" + this.filename);
                    return false;
                }
                this.isNewFile = false;
                this.isOpen = true;
                this.setIsAtEndOfFile(false);
                this.setIsAtBeginningOfFile(false);
                this.setIOStatus(0);
                return true;
            }
        }
        this.setIOStatus(0);
        if (!this.idx_create()) {
            returnCode = this.getPriorError();
            if (shouldAlwaysCreate || returnCode != -93) {
                this.warning("AS400IndexedFile.idx_open", "could not create file" + this.filename);
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.fileHandle = this.file.i_open(this.filename, aMode, this.logical_params);
        errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        returnCode = this.getPriorError();
        if (this.fileHandle == null) {
            return false;
        }
        this.isNewFile = true;
        this.isOpen = true;
        this.setIsAtEndOfFile(false);
        this.setIsAtBeginningOfFile(false);
        if (optionalIsMissing) {
            this.setIOStatus(-5);
        } else if (fileIsMissing) {
            this.setIOStatus(-8);
        }
        return true;
    }

    @Override
    boolean idx_close(int mode) {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        int result = this.file.i_close(this.fileHandle);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        if (result == 0) {
            return false;
        }
        this.isOpen = false;
        this.fileHandle = null;
        return true;
    }

    @Override
    boolean idx_start(int mode, Variable currentKey) {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        int keyOffset = this.findKeyOffset(currentKey);
        if (keyOffset < 0) {
            this.fileMarkerKeyOffset = -1;
            int returnCode = -23;
            this.setIOStatus(-23);
            this.warning("AS400IndexedFile.idx_start", "invalid key, random record is missing");
            return this.isInvalidKey(returnCode);
        }
        int aMode = this.mapStartMode(mode);
        this.masterRecord.flushToMemory();
        int result = this.file.i_start(this.fileHandle, this.masterRecord.getMemory().getBytes(this.masterRecord.getAddress(), this.masterRecord.length()), 0, this.masterRecord.length(), keyOffset, currentKey.length(), aMode);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        if (result == 0) {
            this.fileMarkerKeyOffset = -1;
            return this.isInvalidKey(returnCode);
        }
        this.lastWasAStart = true;
        this.fileMarkerKeyOffset = keyOffset;
        this.lastAccessError = 0;
        return false;
    }

    @Override
    int idx_readData(Variable keyIs, int keyOffset, byte[] bytes, int mode, double timeout) {
        int errno;
        boolean withNoLock;
        if (this.file == null) {
            this.setIOStatus(-90);
            return 0;
        }
        int length = 0;
        boolean locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        boolean bl = withNoLock = (mode & 0x200000) != 0;
        if (locking && withNoLock) {
            this.file.setF_NO_LOCK(-1);
        } else {
            this.file.setF_NO_LOCK(0);
        }
        if (this.isSequential()) {
            if (this.seqDirection >= 0) {
                if (this.isAtEndOfFile()) {
                    this.lastWasARead = false;
                    this.lastAccessError = 0;
                    int returnCode = -46;
                    this.setIOStatus(-46);
                    this.readDataResult = this.isInvalidKey(returnCode);
                    this.warning("AS400IndexedFile.idx_readData", "prior error file status ignored, can't read");
                    return 0;
                }
                this.masterRecord.flushToMemory();
                this.masterRecord.getMemory().copy(this.masterRecord.getAddress(), this.tempRecord, 0, this.masterRecord.length());
                length = this.file.i_next(this.fileHandle, this.tempRecord, 0, this.tempRecord.length);
            } else {
                if (this.isAtBeginningOfFile()) {
                    this.lastWasARead = false;
                    this.lastAccessError = 0;
                    int returnCode = -46;
                    this.setIOStatus(-46);
                    this.warning("AS400IndexedFile.idx_readData", "prior error file status ignored, can't read");
                    this.readDataResult = this.isInvalidKey(returnCode);
                    return 0;
                }
                this.masterRecord.flushToMemory();
                this.masterRecord.getMemory().copy(this.masterRecord.getAddress(), this.tempRecord, 0, this.masterRecord.length());
                length = this.file.i_previous(this.fileHandle, this.tempRecord, 0, this.tempRecord.length);
            }
        } else {
            this.masterRecord.flushToMemory();
            this.masterRecord.getMemory().copy(this.masterRecord.getAddress(), this.tempRecord, 0, this.masterRecord.length());
            length = this.file.i_read(this.fileHandle, this.tempRecord, 0, this.tempRecord.length, keyOffset);
        }
        if (this.isSequential()) {
            this.setIsAtEndOfFile(false);
            this.setIsAtBeginningOfFile(false);
        }
        if ((errno = this.file.getErrno()) != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        if (length <= 0) {
            if (errno == 8 && this.isSequential()) {
                this.lastAccessError = 0;
                this.lastWasARead = true;
                this.lastWasAStart = false;
                if (this.seqDirection >= 0) {
                    this.setIsAtEndOfFile(true);
                } else {
                    this.setIsAtBeginningOfFile(true);
                }
                this.setIOStatus(-10);
                this.readDataResult = true;
                return 0;
            }
            if (errno == 9) {
                if (this.isSequential()) {
                    this.lastWasARead = false;
                    this.lastAccessError = 0;
                    returnCode = -46;
                    this.setIOStatus(-46);
                    this.readDataResult = this.isInvalidKey(returnCode);
                    this.warning("AS400IndexedFile.idx_readData", "prior error file status ignored, can't read");
                    return 0;
                }
                this.setIOStatus(-23);
                this.readDataResult = true;
                this.warning("AS400IndexedFile.idx_readData", "invalid key, random record is missing");
                return 0;
            }
            this.fileMarkerKeyOffset = -1;
            this.readDataResult = this.isInvalidKey(returnCode);
            return 0;
        }
        this.fileMarkerKeyOffset = keyOffset;
        this.lastWasAStart = false;
        if (length > this.maximum) {
            returnCode = -4;
            this.setIOStatus(-4);
            length = this.maximum;
        }
        if (length < this.minimum) {
            returnCode = -4;
            this.setIOStatus(-4);
        }
        this.lastAccessError = 0;
        this.lastWasARead = true;
        if (this.dependingOn != null) {
            this.dependingOn.move(length);
        }
        System.arraycopy(this.tempRecord, 0, bytes, 0, length);
        this.readDataResult = false;
        return length;
    }

    @Override
    boolean idx_write(Variable fromVar, int mode, double timeout) {
        boolean withNoLock;
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        boolean locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        boolean bl = withNoLock = (mode & 0x200000) != 0;
        if (locking && withNoLock) {
            this.file.setF_NO_LOCK(-1);
        } else {
            this.file.setF_NO_LOCK(0);
        }
        int length = this.dependingOn != null ? this.dependingOn.toInt() : fromVar.length();
        if (length > this.maximum) {
            length = this.maximum;
        } else if (length < this.minimum) {
            length = this.minimum;
        }
        fromVar.flushToMemory();
        fromVar.getMemory().copy(fromVar.getAddress(), this.tempRecord, 0, length);
        int result = this.file.i_write(this.fileHandle, this.tempRecord, 0, this.tempRecord.length, length);
        int errno = this.file.getErrno();
        if (errno != 0) {
            if (errno == 7 && this.isSequential()) {
                int returnCode = -21;
                this.setIOStatus(-21);
                this.warning("AS400IndexedFile.idx_write", "invalid key sequence, possible duplicate key");
                return this.isInvalidKey(returnCode);
            }
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        if (!this.isSequential()) {
            this.setIsAtEndOfFile(false);
            this.setIsAtBeginningOfFile(false);
        }
        if (result == 0) {
            if (this.isOK()) {
                this.lastAccessError = 0;
            }
            return this.isInvalidKey(returnCode);
        }
        this.lastAccessError = 0;
        return false;
    }

    @Override
    boolean idx_rewrite(Variable fromVar, int mode, double timeout) {
        int length;
        boolean withNoLock;
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        boolean locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        boolean bl = withNoLock = (mode & 0x200000) != 0;
        if (locking && withNoLock) {
            this.file.setF_NO_LOCK(-1);
        } else {
            this.file.setF_NO_LOCK(0);
        }
        if (this.isSequential()) {
            Variable myKey = this.keyArray[0];
            Variable tempKey = this.getKeyFromBytes(0, this.tempRecord);
            if (tempKey != null && tempKey.compare((comparableByteArray)myKey, true) != 0) {
                this.lastWasARead = false;
                this.lastWasAStart = false;
                int returnCode = -22;
                this.setIOStatus(-22);
                this.warning("AS400IndexedFile.idx_write", "invalid key, duplicate primary key");
                return this.isInvalidKey(returnCode);
            }
        }
        if ((length = this.dependingOn != null ? this.dependingOn.toInt() : fromVar.length()) > this.maximum) {
            length = this.maximum;
        } else if (length < this.minimum) {
            length = this.minimum;
        }
        fromVar.flushToMemory();
        fromVar.getMemory().copy(fromVar.getAddress(), this.tempRecord, 0, length);
        int result = this.file.i_rewrite(this.fileHandle, this.tempRecord, 0, this.tempRecord.length, length);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        this.setIsAtEndOfFile(false);
        this.setIsAtBeginningOfFile(false);
        this.lastWasARead = false;
        this.lastWasAStart = false;
        if (result == 0) {
            if (this.isOK()) {
                this.lastAccessError = 0;
            }
            return this.isInvalidKey(returnCode);
        }
        this.lastAccessError = 0;
        return false;
    }

    @Override
    boolean idx_delete(int mode, double timeout) {
        boolean withNoLock;
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        boolean locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
        boolean bl = withNoLock = (mode & 0x200000) != 0;
        if (locking && withNoLock) {
            this.file.setF_NO_LOCK(-1);
        } else {
            this.file.setF_NO_LOCK(0);
        }
        int result = this.file.i_delete(this.fileHandle);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
        int returnCode = this.getPriorError();
        this.setIsAtEndOfFile(false);
        this.setIsAtBeginningOfFile(false);
        if (result == 0) {
            if (this.isOK()) {
                this.lastAccessError = 0;
            }
            return this.isInvalidKey(returnCode);
        }
        this.lastAccessError = 0;
        return false;
    }

    @Override
    void idx_unlock() {
        if (this.file == null) {
            this.setIOStatus(-90);
            return;
        }
        this.file.i_unlock(this.fileHandle);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
        }
    }

    @Override
    void idx_exclusive() {
    }

    @Override
    void idx_exclusiveConditionally() {
    }

    @Override
    void idx_unexclusive() {
    }

    @Override
    boolean idx_isOpen() {
        return this.isOpen;
    }

    @Override
    boolean idx_isInput() {
        return this.readable && !this.writable;
    }

    @Override
    boolean idx_isOutput() {
        return this.writable && !this.readable;
    }

    @Override
    boolean idx_isIO() {
        return this.readable && this.writable;
    }

    @Override
    boolean idx_isExtend() {
        return this.extend;
    }

    @Override
    boolean idx_isWritable() {
        return this.writable;
    }

    @Override
    boolean idx_isReadable() {
        return this.readable;
    }

    @Override
    boolean idx_isNewFile() {
        return this.isNewFile;
    }

    @Override
    boolean idx_deleteFile() {
        if (this.file == null) {
            this.setIOStatus(-90);
            return false;
        }
        int result = this.file.i_remove(this.filename);
        if (result == 0) {
            this.setIOStatus(-this.file.getErrno() - 80000);
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean begin() {
        if (!this.isOpen()) {
            return false;
        }
        this.file.i_begin(this.fileHandle);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
            return this.isOK();
        }
        return true;
    }

    @Override
    public boolean recover() {
        if (!this.isOpen()) {
            return false;
        }
        this.file.i_recover();
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
            return this.isOK();
        }
        return true;
    }

    @Override
    public boolean rollback() {
        if (!this.isOpen()) {
            return false;
        }
        this.file.i_rollback(this.fileHandle, 0);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
            return this.isOK();
        }
        return true;
    }

    @Override
    public boolean commit() {
        if (!this.isOpen()) {
            return false;
        }
        this.file.i_commit(this.fileHandle, 0);
        int errno = this.file.getErrno();
        if (errno != 0) {
            this.setIOStatus(-errno - 80000);
            return this.isOK();
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.file != null) {
                if (this.isOpen) {
                    this.idx_close(0);
                }
                this.file.i_exit();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }
}

