/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.dds.AS400Console;
import com.heirloomcomputing.dds.AS400TransactionDevice;
import com.heirloomcomputing.dds.DDSFile;
import com.heirloomcomputing.dds.DisplayFileObject;
import com.heirloomcomputing.dds.DisplayRecordObject;
import com.heirloomcomputing.ecs.exec.AS400Connect;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ScreenProperty;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.TransactionFile;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.XOpenInternational;
import com.heirloomcomputing.term.ScreenHandler;
import com.ibm.as400.access.AS400;
import java.awt.Color;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Vector;

public class AS400TransactionFile
extends TransactionFile {
    public static final boolean debugMode = false;
    protected String currentTerminal = "Console";
    protected DDSFile file = null;
    protected DisplayFileObject fileObject = null;
    protected ScreenHandler term = null;
    protected int defaultFG = 2;
    protected int defaultBG = 0;
    protected long lastSubfileRecordRead = -1L;

    protected static void debug(String text) {
        System.out.println("AS400TransactionFile: " + text);
    }

    @Override
    public long getLastSubfileRecordRead() {
        return this.lastSubfileRecordRead;
    }

    public void setLastSubfileRecordRead(long recordNumber) {
        this.lastSubfileRecordRead = recordNumber;
    }

    @Override
    public boolean open(int mode) {
        return super.open(mode);
    }

    @Override
    public boolean acquire(String programDeviceName) {
        boolean flag;
        if (programDeviceName == null) {
            programDeviceName = "";
        }
        if (programDeviceName.length() > 10) {
            programDeviceName = programDeviceName.substring(0, 10);
        }
        if (flag = super.acquire(programDeviceName)) {
            AS400TransactionDevice device = this.getTerminalDevice(programDeviceName);
            AS400TransactionDevice.setGroupingSeparator((char)XOpenInternational.groupingSymbol);
            AS400TransactionDevice.setZeroCharacter((char)XOpenInternational.zeroSymbol);
            AS400TransactionDevice.setCurrencySymbol((char)XOpenInternational.currencySymbol);
            AS400TransactionDevice.setDecimalSeparator((char)XOpenInternational.decimalSymbol);
            device.setJobDate(RuntimeEnvironment.getJobDate());
        }
        return flag;
    }

    private AS400TransactionDevice getTerminalDevice(String name) {
        try {
            Object[] oArray = (Object[])terminalDevices.get(name);
            if (oArray == null) {
                return null;
            }
            return (AS400TransactionDevice)oArray[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Object allocateTransactionDevice(String name) {
        this.defaultFG = 2;
        this.defaultBG = 0;
        try {
            int val;
            String dbg;
            int val2;
            String dfg = RuntimeEnvironment.getGlobalParameter("CONSOLEFG");
            if (dfg != null && (val2 = ScreenProperty.getColorFromString(dfg)) >= 0) {
                this.defaultFG = val2;
            }
            if ((dbg = RuntimeEnvironment.getGlobalParameter("CONSOLEBG")) != null && (val = ScreenProperty.getColorFromString(dbg)) >= 0) {
                this.defaultBG = val;
            }
        }
        catch (Throwable dfg) {
            // empty catch block
        }
        this.term = this.createScreenHandler(name, this.defaultFG, this.defaultBG);
        AS400 system2 = null;
        try {
            AS400Connect con;
            String osName = System.getProperty("os.name").toUpperCase().trim();
            if ((osName.indexOf("OS/400") >= 0 || osName.indexOf("OS400") >= 0 || osName.indexOf("ISERIES") >= 0) && (con = AS400Connect.getAS400Connection(this.context, null)) != null) {
                system2 = con.getSystemConnection(7);
            }
        }
        catch (Throwable t) {
            system2 = null;
        }
        AS400Console device = new AS400Console(name, this.term, this.defaultFG, this.defaultBG, system2);
        if (!device.open()) {
            return null;
        }
        this.currentTerminal = name;
        return device;
    }

    @Override
    protected boolean deallocateTransactionDevice(Object o) {
        if (o instanceof AS400TransactionDevice) {
            AS400TransactionDevice device = (AS400TransactionDevice)o;
            device.close();
            this.term.end();
            this.term = null;
            this.currentTerminal = device.getName();
            return true;
        }
        return false;
    }

    @Override
    protected boolean scrollTransactionDevice(int from, int to, boolean dirUp, int count) {
        if (this.currentTerminal == null) {
            return false;
        }
        AS400TransactionDevice device = this.getTerminalDevice(this.currentTerminal);
        if (device == null) {
            this.iostatus(9, 'G');
            return false;
        }
        if (!device.scroll(from, to, dirUp, count)) {
            this.iostatus(9, 'G');
            return false;
        }
        return true;
    }

    @Override
    protected int openTransactionFile(int mode) {
        try {
            char ch;
            String ddsFilename = this.getFilename().substring(12);
            int len = ddsFilename.length();
            boolean useSeparateIndicatorArea = false;
            if (len > 3 && ((ch = ddsFilename.charAt(len - 3)) == '-' || ch == '_') && ddsFilename.toUpperCase().endsWith("SI")) {
                useSeparateIndicatorArea = true;
                ddsFilename = ddsFilename.substring(0, len - 3);
            }
            this.file = new DDSFile(ddsFilename);
            if (!this.file.exists()) {
                this.iostatus(-35);
                this.warning("AS400TransactionFile.openTransactionFile", "file missing and non optional open");
                return -35;
            }
            this.fileObject = this.file.getDisplayFileObject();
            if (useSeparateIndicatorArea) {
                this.fileObject.setUseSeparateIndicatorArea(true);
            }
            return 0;
        }
        catch (Exception exception) {
            this.warning("AS400TransactionFile.openTransactionFile", "can't open file");
            return -30;
        }
    }

    @Override
    protected int closeTransactionFile(int mode) {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
        return 0;
    }

    @Override
    protected boolean isNewTransactionFile() {
        return true;
    }

    @Override
    protected int seekPastLastValidRecord() {
        return 0;
    }

    protected void updateControlArea(String keyPressed, String deviceName, String recordFormat) {
        if (this.controlArea == null) {
            return;
        }
        int controlAreaLength = this.controlArea.length();
        if (controlAreaLength < 2) {
            return;
        }
        int keyPressedLength = 0;
        if (keyPressed != null) {
            keyPressedLength = keyPressed.length();
        } else {
            keyPressed = "99";
            keyPressedLength = 2;
        }
        if (keyPressedLength < 2) {
            keyPressed = "00" + keyPressed;
            keyPressedLength += 2;
        }
        if (keyPressedLength > 2) {
            keyPressed = keyPressed.substring(keyPressedLength - 2);
        }
        int deviceNameLength = 0;
        if (deviceName != null) {
            deviceNameLength = deviceName.length();
        } else {
            deviceName = "";
        }
        if (deviceNameLength < 10) {
            deviceName = deviceName + "          ";
            deviceNameLength += 10;
        }
        if (deviceNameLength > 10) {
            deviceName = deviceName.substring(0, 10);
        }
        int recordFormatLength = 0;
        if (recordFormat != null) {
            recordFormatLength = recordFormat.length();
        } else {
            recordFormat = "";
        }
        if (recordFormatLength < 10) {
            recordFormat = recordFormat + "          ";
            recordFormatLength += 10;
        }
        if (recordFormatLength > 10) {
            recordFormat = recordFormat.substring(0, 10);
        }
        String totalString = keyPressed + deviceName + recordFormat;
        if (controlAreaLength < 12) {
            this.controlArea.move(totalString.substring(0, controlAreaLength));
            return;
        }
        if (controlAreaLength < 22) {
            this.controlArea.move(totalString.substring(0, controlAreaLength));
            return;
        }
        this.controlArea.move(totalString);
    }

    private AS400TransactionDevice getFirstInvitedDevice() {
        try {
            Enumeration elems = terminalDevices.elements();
            while (elems.hasMoreElements()) {
                AS400TransactionDevice d;
                Object[] oArray = (Object[])elems.nextElement();
                if (oArray == null || (d = (AS400TransactionDevice)oArray[0]) == null || !d.getInvite()) continue;
                return d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected int readSubfileRecord(String terminal, Variable indicators, String format, long recordNumber, Variable data, int len, boolean readNextModified) {
        int result;
        DisplayRecordObject recordObject;
        AS400TransactionDevice device;
        if (terminal == null || terminal.trim().length() == 0) {
            terminal = this.currentTerminal;
        }
        if ((device = this.getFirstInvitedDevice()) == null) {
            device = this.getTerminalDevice(terminal);
        }
        if (device == null) {
            this.iostatus(9, 'G');
            return -90;
        }
        this.currentTerminal = terminal;
        if (!(format != null && format.trim().length() != 0 || (format = device.getNameOfLastRecordWritten()) != null && format.trim().length() != 0)) {
            this.iostatus(9, 'K');
            return -90;
        }
        format = format.trim();
        if (indicators == null) {
            indicators = data;
        }
        if ((recordObject = this.file.allocateDisplayRecordObject(format)) == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        Vector responseIndicators = recordObject.getResponseIndicators();
        this.file.deallocateDisplayRecordObject(recordObject);
        boolean[] indicatorArray = new boolean[100];
        int dataOffset = 0;
        if (!this.fileObject.getUseSeparateIndicatorArea() && responseIndicators != null) {
            dataOffset = responseIndicators.size();
        }
        byte[] dataBytes = null;
        int dataLen = 0;
        if (data != null) {
            dataLen = data.length();
            dataBytes = new byte[dataLen];
        }
        if ((result = device.readSubfileRecord(this.file, format, indicatorArray, recordNumber, dataBytes, dataOffset, dataLen, readNextModified)) != 0) {
            if (result == Integer.MIN_VALUE) {
                this.iostatus(-90);
                this.warning("AS400TransactionFile.readSubfileRecord", "miscellaneous error");
                return -90;
            }
            if (result == -2147483647) {
                this.iostatus(1, '2');
                return -10;
            }
        }
        if (data != null) {
            data.fromByteArray(dataBytes);
        }
        this.setIndicatorArray(indicators, indicatorArray, responseIndicators);
        this.setLastSubfileRecordRead(device.getLastSubfileRecordRead());
        if (data == null) {
            return 0;
        }
        return len;
    }

    @Override
    protected int readRecord(String terminal, Variable indicators, String format, Variable data, int len) {
        int result;
        AS400TransactionDevice device;
        if (terminal == null || terminal.trim().length() == 0) {
            terminal = this.currentTerminal;
        }
        if ((device = this.getFirstInvitedDevice()) == null) {
            device = this.getTerminalDevice(terminal);
        }
        if (device == null) {
            this.iostatus(9, 'G');
            return -90;
        }
        this.currentTerminal = terminal;
        if (!(format != null && format.trim().length() != 0 || (format = device.getNameOfLastRecordWritten()) != null && format.trim().length() != 0)) {
            this.iostatus(9, 'K');
            return -90;
        }
        format = format.trim();
        if (indicators == null) {
            indicators = data;
        }
        device.setInvite(false);
        DisplayRecordObject dr = device.getActiveRecord(format);
        if (dr == null) {
            DisplayRecordObject recordObject = this.file.allocateDisplayRecordObject(format);
            if (recordObject == null) {
                this.iostatus(9, 'K');
                return -90;
            }
            if (recordObject.getInitializeRecord()) {
                this.file.deallocateDisplayRecordObject(recordObject);
                this.writeRecord(terminal, null, format, -1, null, 0, true);
                device.write();
                dr = device.getActiveRecord(format);
            } else {
                this.file.deallocateDisplayRecordObject(recordObject);
            }
            if (dr == null) {
                this.iostatus(9, 'K');
                return -90;
            }
        }
        Vector responseIndicators = dr.getResponseIndicators();
        boolean[] indicatorArray = new boolean[100];
        int dataOffset = 0;
        if (!this.fileObject.getUseSeparateIndicatorArea() && responseIndicators != null) {
            dataOffset = responseIndicators.size();
        }
        byte[] dataBytes = null;
        int dataLen = 0;
        if (data != null) {
            dataLen = data.length();
            dataBytes = new byte[dataLen];
        }
        if ((result = device.readRecord(this.file, format, indicatorArray, dataBytes, dataOffset, dataLen)) != 0) {
            this.iostatus(-90);
            return -90;
        }
        String keyPressedString = device.getKeyPressedString();
        if (data != null) {
            data.fromByteArray(dataBytes);
        }
        this.setIndicatorArray(indicators, indicatorArray, responseIndicators);
        this.updateControlArea(keyPressedString, this.currentTerminal, format);
        if (data == null) {
            return 0;
        }
        return len;
    }

    @Override
    protected int writeSubfileRecord(String terminal, Variable indicators, String format, long recordNumber, Variable data, int len) {
        AS400TransactionDevice device;
        if (terminal == null || terminal.trim().length() == 0) {
            terminal = this.currentTerminal;
        }
        if ((device = this.getTerminalDevice(terminal)) == null) {
            this.iostatus(9, 'G');
            return -90;
        }
        this.currentTerminal = terminal;
        if ((format == null || format.trim().length() == 0) && (format = this.file.getFirstRecordsFormatName()) == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        DisplayRecordObject recordObject = this.file.allocateDisplayRecordObject(format = format.trim());
        if (recordObject == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        boolean[] indicatorArray = null;
        int dataOffset = 0;
        if (indicators == null) {
            indicators = data;
        }
        Vector optionIndicators = recordObject.getOptionIndicators();
        indicatorArray = this.getIndicatorArray(indicators, optionIndicators);
        if (!this.fileObject.getUseSeparateIndicatorArea() && optionIndicators != null) {
            dataOffset = optionIndicators.size();
        }
        byte[] dataBytes = null;
        if (data != null) {
            dataBytes = data.toByteArray();
        }
        DisplayRecordObject controlRecord = null;
        controlRecord = this.file.allocateDisplayRecordObjectAfter(format);
        if (controlRecord == null) {
            this.iostatus(-90);
            return -90;
        }
        int result = device.writeSubfileRecord(this.file, recordObject, controlRecord, indicatorArray, recordNumber, dataBytes, dataOffset, len);
        this.file.deallocateDisplayRecordObject(controlRecord);
        this.file.deallocateDisplayRecordObject(recordObject);
        if (result != 0) {
            if (result == Integer.MIN_VALUE) {
                this.iostatus(-90);
                this.warning("AS400TransactionFile.writeSubfileRecord", "miscellaneous error");
                return -90;
            }
            if (result == 1) {
                this.iostatus(0, 'M');
                return 0;
            }
            if (result == 2) {
                this.iostatus(2, '4');
                this.warning("AS400TransactionFile.writeSubfileRecord", "write beyond boundary");
                return -24;
            }
            if (result == -2147483645) {
                this.iostatus(2, '2');
                this.warning("AS400TransactionFile.writeSubfileRecord", "write duplicate key");
                return -22;
            }
        }
        return 0;
    }

    @Override
    protected int writeRecord(String terminal, Variable indicators, String format, int startingAtLine, Variable data, int len) {
        return this.writeRecord(terminal, indicators, format, startingAtLine, data, len, false);
    }

    private int writeRecord(String terminal, Variable indicators, String format, int startingAtLine, Variable data, int len, boolean isINZRCD) {
        AS400TransactionDevice device;
        if (terminal == null || terminal.trim().length() == 0) {
            terminal = this.currentTerminal;
        }
        if ((device = this.getTerminalDevice(terminal)) == null) {
            this.iostatus(9, 'G');
            return -90;
        }
        this.currentTerminal = terminal;
        if ((format == null || format.trim().length() == 0) && (format = this.file.getFirstRecordsFormatName()) == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        DisplayRecordObject recordObject = this.file.allocateDisplayRecordObject(format = format.trim());
        if (recordObject == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        boolean[] indicatorArray = null;
        int dataOffset = 0;
        if (!isINZRCD) {
            if (indicators == null) {
                indicators = data;
            }
            Vector optionIndicators = recordObject.getOptionIndicators();
            indicatorArray = this.getIndicatorArray(indicators, optionIndicators);
            if (!this.fileObject.getUseSeparateIndicatorArea() && optionIndicators != null) {
                dataOffset = optionIndicators.size();
            }
        } else {
            indicatorArray = new boolean[100];
            for (int i = 0; i < 100; ++i) {
                indicatorArray[i] = true;
            }
        }
        byte[] dataBytes = null;
        if (data != null) {
            dataBytes = data.toByteArray();
        }
        int result = device.writeRecord(this.file, recordObject, indicatorArray, startingAtLine, dataBytes, dataOffset, len);
        this.file.deallocateDisplayRecordObject(recordObject);
        if (result != 0 && result == Integer.MIN_VALUE) {
            this.iostatus(-90);
            this.warning("AS400TransactionFile.writeRecord", "miscellaneous error");
            return -90;
        }
        return 0;
    }

    @Override
    protected int rewriteSubfileRecord(String terminal, Variable indicators, String format, long recordNumber, Variable data, int len) {
        AS400TransactionDevice device;
        if (terminal == null || terminal.trim().length() == 0) {
            terminal = this.currentTerminal;
        }
        if ((device = this.getTerminalDevice(terminal)) == null) {
            this.iostatus(9, 'G');
            return -90;
        }
        this.currentTerminal = terminal;
        if ((format == null || format.trim().length() == 0) && (format = this.file.getFirstRecordsFormatName()) == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        DisplayRecordObject recordObject = this.file.allocateDisplayRecordObject(format = format.trim());
        if (recordObject == null) {
            this.iostatus(9, 'K');
            return -90;
        }
        boolean[] indicatorArray = null;
        int dataOffset = 0;
        if (indicators == null) {
            indicators = data;
        }
        Vector optionIndicators = recordObject.getOptionIndicators();
        indicatorArray = this.getIndicatorArray(indicators, optionIndicators);
        if (!this.fileObject.getUseSeparateIndicatorArea() && optionIndicators != null) {
            dataOffset = optionIndicators.size();
        }
        byte[] dataBytes = null;
        if (data != null) {
            dataBytes = data.toByteArray();
        }
        int result = device.rewriteSubfileRecord(this.file, recordObject, indicatorArray, recordNumber, dataBytes, dataOffset, len);
        this.file.deallocateDisplayRecordObject(recordObject);
        if (result != 0) {
            if (result == Integer.MIN_VALUE) {
                this.iostatus(-90);
                this.warning("AS400TransactionFile.rewriteRecord", "miscellaneous error");
                return -90;
            }
            if (result == -2147483644) {
                this.iostatus(2, '1');
                this.warning("AS400TransactionFile.rewriteRecord", "invalid key, random record missing");
                return -23;
            }
        }
        return 0;
    }

    @Override
    protected int rewriteRecord(String terminal, Variable indicators, String format, Variable data, int len) {
        return -30;
    }

    @Override
    protected int getCurrentRecordStatus() {
        AS400TransactionDevice device = this.getFirstInvitedDevice();
        if (device == null) {
            device = this.getTerminalDevice(this.currentTerminal);
        }
        if (device != null && !device.getLastRecordReadActive()) {
            return 0;
        }
        return 2;
    }

    @Override
    protected boolean writeRequiresKeyNotPresent() {
        return false;
    }

    @Override
    protected boolean isCurrentRecordModified() {
        AS400TransactionDevice device = this.getFirstInvitedDevice();
        if (device == null) {
            device = this.getTerminalDevice(this.currentTerminal);
        }
        if (device == null) {
            return false;
        }
        return device.getLastRecordReadChanged();
    }

    private boolean[] getIndicatorArray(Variable indicators, Vector<Integer> indicatorsInRecord) {
        boolean[] result = new boolean[100];
        if (indicators == null) {
            return result;
        }
        if (this.fileObject.getUseSeparateIndicatorArea()) {
            Variable parent = indicators.getParent();
            if (parent == null) {
                parent = indicators;
            }
            parent.flushToMemory();
            int limit = indicators.length() * indicators.occurs();
            if (limit > 99) {
                limit = 99;
            }
            for (int i2 = 0; i2 < limit; ++i2) {
                char c = indicators.getChar(i2);
                boolean isDigit = Character.isDigit(c);
                if (!isDigit || c != '1') continue;
                result[i2 + 1] = true;
            }
            return result;
        }
        if (indicatorsInRecord == null) {
            return result;
        }
        indicators.flushToMemory();
        for (int i = 0; i < indicatorsInRecord.size(); ++i) {
            char c;
            int indic = 0;
            try {
                indic = indicatorsInRecord.elementAt(i);
            }
            catch (Exception i2) {
                // empty catch block
            }
            if (indic <= 0 || indic >= 100 || (c = indicators.getChar(i)) != '1') continue;
            result[indic] = true;
        }
        return result;
    }

    private void setIndicatorArray(Variable indicators, boolean[] indicatorArray, Vector<Integer> indicatorsInRecord) {
        if (indicatorArray == null || indicators == null) {
            return;
        }
        if (this.fileObject.getUseSeparateIndicatorArea()) {
            Variable parent = indicators.getParent();
            if (parent == null) {
                parent = indicators;
            }
            parent.flushToMemory();
            int limit = indicators.length() * indicators.occurs();
            if (limit > 99) {
                limit = 99;
            }
            for (int i = 0; i < limit; ++i) {
                indicators.setChar(i, indicatorArray[i + 1] ? (char)'1' : '0');
            }
        } else {
            if (indicatorsInRecord == null) {
                return;
            }
            indicators.flushToMemory();
            for (int i = 0; i < indicatorsInRecord.size(); ++i) {
                int indic = 0;
                try {
                    indic = indicatorsInRecord.elementAt(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (indic <= 0 || indic >= 100) continue;
                indicators.setChar(i, indicatorArray[indic] ? (char)'1' : '0');
            }
        }
    }

    private ScreenHandler createScreenHandler(String title, int defaultFG, int defaultBG) {
        ScreenHandler term = IO.current().getScreenHandler(title);
        term.setDefaultColors(defaultFG, defaultBG);
        Color fg = ScreenProperty.getColorObject(defaultFG);
        Color bg = ScreenProperty.getColorObject(defaultBG);
        Container pfw = term.getPanelForWindow();
        if (pfw != null) {
            pfw.setForeground(fg);
            pfw.setBackground(bg);
        }
        Shutdown.exitWhenFinished(false);
        return term;
    }
}

