/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.dragontechnology.barcode.BarcodeStrategy;
import com.dragontechnology.barcode.JBarcodeBean;
import com.heirloomcomputing.ecs.api.IGenericBarcode;
import java.awt.Color;

public class BarcodeDragon
implements IGenericBarcode {
    private Class<?> defaultBarCodeClass;
    private JBarcodeBean barcodeBean;

    private String getString(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value).trim();
    }

    private boolean getBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        String valueString = this.getString(value);
        if (valueString.length() > 0) {
            switch (valueString.charAt(0)) {
                case '1': 
                case 'J': 
                case 'T': 
                case 'Y': 
                case 'j': 
                case 't': 
                case 'y': {
                    return true;
                }
            }
        }
        return false;
    }

    private int getInt(Object value) {
        try {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(this.getString(value));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private double getDouble(Object value) {
        try {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return new Double(this.getString(value));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public void setProperty(String property, Object value) {
        if (this.barcodeBean == null) {
            this.barcodeBean = new JBarcodeBean();
            this.barcodeBean.setBackground(Color.white);
            this.barcodeBean.setBarcodeBackground(Color.white);
        }
        if ("TYPE".equals(property)) {
            String valueString = this.getString(value);
            if (valueString == null) {
                return;
            }
            valueString = valueString.replace('-', '_').replace(' ', '_');
            try {
                this.defaultBarCodeClass = Class.forName("com.dragontechnology.barcode." + valueString);
                BarcodeStrategy barcodeStrategy = (BarcodeStrategy)this.defaultBarCodeClass.newInstance();
                this.barcodeBean.setCodeType(barcodeStrategy);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if ("VALUE".equals(property) || "CODE".equals(property)) {
            this.barcodeBean.setCode(this.getString(value));
            return;
        }
        if ("CHECK_DIGIT_BOOL".equals(property)) {
            try {
                this.barcodeBean.setCheckDigit(this.getBoolean(value));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if ("SHOW_TEXT_BOOL".equals(property)) {
            this.barcodeBean.setShowText(this.getBoolean(value));
            return;
        }
        if ("NARROWEST_BAR_WIDTH_INT".equals(property)) {
            this.barcodeBean.setNarrowestBarWidth(this.getInt(value));
            return;
        }
        if ("ANGLE_DEGREES_DOUBLE".equals(property)) {
            this.barcodeBean.setAngleDegrees(this.getDouble(value));
            return;
        }
        if ("BARCODE_HEIGHT_INT".equals(property)) {
            this.barcodeBean.setBarcodeHeight(this.getInt(value));
            return;
        }
        if ("BACKGROUND_COLOR".equals(property)) {
            this.barcodeBean.setBackground((Color)value);
            return;
        }
        if ("BARCODE_BACKGROUND_COLOR".equals(property)) {
            this.barcodeBean.setBarcodeBackground((Color)value);
            return;
        }
    }

    @Override
    public Object getObject() {
        return this.barcodeBean;
    }
}

