/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.PackedDecimalI;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class BignumType
extends Numeric
implements Cloneable,
comparableByteArray {
    static final long serialVersionUID = 1L;
    protected transient Bignum safeValue = new Bignum();
    protected int storeSize = -1;
    final Memory _tempmemory = new UnbufferedMemory(20, "tempMemory");

    @Override
    public Object clone() {
        BignumType copy = (BignumType)super.clone();
        copy.safeValue = new Bignum();
        return copy;
    }

    @Override
    public comparableByteArray copy() {
        BignumType copy = (BignumType)super.copyVariable();
        copy.value = new Bignum(this.value);
        copy.safeValue = new Bignum();
        return copy;
    }

    @Override
    public abstract String getClassName();

    @Override
    public abstract String getUsage();

    @Override
    public abstract Numeric odoNumeric();

    @Override
    public abstract String toNumericString();

    @Override
    public abstract String toInspectString();

    @Override
    public abstract int getAcceptSize();

    @Override
    public abstract void calcStoreSize();

    public abstract void fillFromMemoryNow();

    public abstract void flushToMemoryNow();

    public BignumType(String setPic, String setValue) {
        super(setPic, setValue);
    }

    public BignumType() {
    }

    public BignumType(long value) {
        super(value);
    }

    @Override
    public Numeric negate() {
        this.updateFromMemory(false);
        return new Numeric(this.value.negate());
    }

    @Override
    public boolean isZero() {
        this.updateFromMemory(false);
        return this.value.isZero();
    }

    @Override
    public int compareZero() {
        this.updateFromMemory(false);
        return this.value.signum();
    }

    @Override
    public int getStoreSize() {
        return this.storeSize;
    }

    public int getNumberOfDigits() {
        return this.storeSize;
    }

    @Override
    public int getNumericInfo() {
        int numDigits = this.storeSize;
        if (numDigits < 0) {
            numDigits = 0;
        }
        return numDigits + (this.place << 8);
    }

    @Override
    protected int canStore(String stringValue) {
        int start;
        stringValue = stringValue.trim();
        int end = stringValue.length();
        for (start = 0; start <= end && stringValue.charAt(start) == '-' || stringValue.charAt(start) == '+'; ++start) {
        }
        stringValue = stringValue.substring(start, end);
        if (stringValue.indexOf(46) != -1) {
            for (end = stringValue.length() - 1; end >= 0 && stringValue.charAt(end) == '0'; --end) {
            }
        }
        ++end;
        for (start = 0; start < end && stringValue.charAt(start) == '0'; ++start) {
        }
        stringValue = stringValue.substring(start, end);
        int index = stringValue.indexOf(46);
        int length = stringValue.length();
        if (index >= 0) {
            int foundDecimal = length - index - 1;
            int foundWhole = length - foundDecimal - 1;
            if (foundWhole > this.storeSize - this.place) {
                return 8;
            }
            if (foundDecimal > this.place) {
                return 4;
            }
        } else if (length > this.storeSize - this.place) {
            return 8;
        }
        return 0;
    }

    protected void truncate() {
        this.numericString = null;
        if (this.scale <= 0) {
            this.value.truncate(this.storeSize, this.place);
            if (Cache.forbid) {
                this.valid = true;
                this.dirty = true;
            }
            return;
        }
        byte bufferPlace = this.place;
        if (this.place > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        this.value.truncate(this.storeSize, bufferPlace);
        this.value.movingPoint(this.scale, bufferPlace);
        if (Cache.forbid) {
            this.valid = true;
            this.dirty = true;
        }
    }

    protected void truncateSE() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.truncatePreserveOnFalse(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (Cache.forbid) {
                this.valid = true;
                this.dirty = true;
            }
            return;
        }
        byte bufferPlace = this.place;
        if (bufferPlace > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        if (this.value.truncatePreserveOnFalse(this.storeSize, bufferPlace)) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (bufferPlace > 0) {
            this.value.movingPointLeft(this.scale);
        } else {
            this.value.movingPointRight(this.scale);
        }
        if (Cache.forbid) {
            this.valid = true;
            this.dirty = true;
        }
    }

    protected void roundSE() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.roundPreserve(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (Cache.forbid) {
                this.valid = true;
                this.dirty = true;
            }
            return;
        }
        byte bufferPlace = this.place;
        if (bufferPlace > 0) {
            this.value.movingPointRight(this.scale);
            bufferPlace = (byte)(bufferPlace - this.scale);
        } else {
            this.value.movingPointLeft(this.scale);
        }
        if (this.value.roundPreserve(this.storeSize, bufferPlace)) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (bufferPlace > 0) {
            this.value.movingPointLeft(this.scale);
        } else {
            this.value.movingPointRight(this.scale);
        }
        if (Cache.forbid) {
            this.valid = true;
            this.dirty = true;
        }
    }

    protected void truncateToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            this.value.truncate(this.storeSize, this.place);
            if (this.signPosition == 0) {
                this.value.makeUnsigned();
            }
        } else {
            byte bufferPlace = this.place;
            if (this.place > 0) {
                this.value.movingPointRight(this.scale);
                bufferPlace = (byte)(bufferPlace - this.scale);
            } else {
                this.value.movingPointLeft(this.scale);
            }
            this.value.truncate(this.storeSize, bufferPlace);
            this.value.movingPoint(this.scale, bufferPlace);
            if (this.signPosition == 0) {
                this.value.makeUnsigned();
            }
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
    }

    protected void truncateSEToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.truncatePreserveOnFalse(this.storeSize, this.place)) {
                this.setSizeError();
                if (RuntimeEnvironment.isIBM && onSizeErrorCond) {
                    this.value.make(this.safeValue);
                } else if (Variable.RoundOverflow) {
                    if (this.getUsage().equals("Binary")) {
                        this.value.round(this.storeSize, this.place);
                    } else {
                        this.value.truncate(this.storeSize, this.place);
                    }
                } else if (Variable.TruncateDecimal) {
                    this.value.truncate(this.storeSize, this.place);
                } else {
                    this.value.make(this.safeValue);
                }
            } else if (this.signPosition == 0) {
                this.value.makeUnsigned();
            }
        } else {
            byte bufferPlace = this.place;
            if (bufferPlace > 0) {
                this.value.movingPointRight(this.scale);
                bufferPlace = (byte)(bufferPlace - this.scale);
            } else {
                this.value.movingPointLeft(this.scale);
            }
            if (this.value.truncatePreserveOnFalse(this.storeSize, bufferPlace)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else {
                if (bufferPlace > 0) {
                    this.value.movingPointLeft(this.scale);
                } else {
                    this.value.movingPointRight(this.scale);
                }
                if (this.signPosition == 0) {
                    this.value.makeUnsigned();
                }
            }
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
        onSizeErrorCond = false;
    }

    protected void roundSEToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.roundPreserve(this.storeSize, this.place)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else if (this.signPosition == 0) {
                this.value.makeUnsigned();
            }
        } else {
            byte bufferPlace = this.place;
            if (bufferPlace > 0) {
                this.value.movingPointRight(this.scale);
                bufferPlace = (byte)(bufferPlace - this.scale);
            } else {
                this.value.movingPointLeft(this.scale);
            }
            if (this.value.roundPreserve(this.storeSize, bufferPlace)) {
                this.setSizeError();
                this.value.make(this.safeValue);
            } else {
                if (bufferPlace > 0) {
                    this.value.movingPointLeft(this.scale);
                } else {
                    this.value.movingPointRight(this.scale);
                }
                if (this.signPosition == 0) {
                    this.value.makeUnsigned();
                }
            }
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
    }

    protected void roundToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            this.value.round(this.storeSize, this.place);
            if (this.signPosition == 0) {
                this.value.makeUnsigned();
            }
        } else {
            byte bufferPlace = this.place;
            if (bufferPlace > 0) {
                this.value.movingPointRight(this.scale);
                bufferPlace = (byte)(bufferPlace - this.scale);
            } else {
                this.value.movingPointLeft(this.scale);
            }
            this.value.round(this.storeSize, bufferPlace);
            if (bufferPlace > 0) {
                this.value.movingPointLeft(this.scale);
            } else {
                this.value.movingPointRight(this.scale);
            }
            if (this.signPosition == 0) {
                this.value.makeUnsigned();
            }
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
    }

    protected void validateTruncateSEToMemory() {
        this.numericString = null;
        if (this.scale <= 0) {
            if (this.value.truncatePreserveOnFalse(this.storeSize, this.place)) {
                this.setSizeError();
            } else {
                this.valid = true;
                this.dirty = true;
                if (this.signPosition == 0) {
                    this.value.makeUnsigned();
                }
            }
        } else {
            byte bufferPlace = this.place;
            if (bufferPlace > 0) {
                this.value.movingPointRight(this.scale);
                bufferPlace = (byte)(bufferPlace - this.scale);
            } else {
                this.value.movingPointLeft(this.scale);
            }
            if (this.value.truncatePreserveOnFalse(this.storeSize, bufferPlace)) {
                this.setSizeError();
            } else {
                this.valid = true;
                this.dirty = true;
                if (bufferPlace > 0) {
                    this.value.movingPointLeft(this.scale);
                } else {
                    this.value.movingPointRight(this.scale);
                }
                if (this.signPosition == 0) {
                    this.value.makeUnsigned();
                }
            }
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
            this.cleanAncestors();
        }
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
    }

    @Override
    public final void fillFromMemory() {
        if (Cache.standard) {
            if (this.alwaysFlush) {
                return;
            }
            if (this.notify != null) {
                this.notify.flushToMemory();
            } else if (this.pointerMemory != null) {
                this.pointerMemory.flushToMemory(this, true);
            }
            this.fillFromMemoryNow();
        } else if (Cache.forbid && !this.valid) {
            if (this.redefinedFrom != null) {
                ++ModifyOnce;
                if (this.redefinedFrom.dirty) {
                    this.redefinedFrom.flushDirtyToMemory();
                } else {
                    this.redefinedFrom.cleanChildren(true);
                }
            }
            if (this.redefinedTo != null) {
                if (this.redefinedFrom == null) {
                    ++ModifyOnce;
                }
                for (Variable tmp : this.redefinedTo) {
                    if (tmp.dirty) {
                        tmp.flushDirtyToMemory();
                        continue;
                    }
                    tmp.cleanChildren(true);
                }
            }
            this.cleanChildren(true);
            this.fillFromMemoryNow();
            this.valid = true;
            this.dirty = false;
        }
    }

    @Override
    public final void flushDirtyToMemory() {
        if (Cache.standard) {
            this.numericString = null;
            if (this.alwaysFlush) {
                return;
            }
            this.dirty = false;
            this.flushToMemoryNow();
        } else if (Cache.forbid) {
            if (this.dirty && !this.valid) {
                this.flushToMemoryNow();
            } else if (!this.dirty) {
                this.cleanChildren(true);
                this.cleanAncestors();
            } else {
                this.flushToMemoryNow();
                this.dirty = false;
            }
        }
    }

    @Override
    public final void flushToMemory() {
        if (Cache.standard) {
            this.numericString = null;
            if (this.alwaysFlush) {
                return;
            }
            if (!this.dirty) {
                if (this.notify != null) {
                    this.notify.flushToMemory();
                } else if (this.pointerMemory != null) {
                    this.pointerMemory.flushToMemory(this, false);
                }
                return;
            }
            this.dirty = false;
            this.flushToMemoryNow();
        } else if (this.dirty && !this.valid) {
            this.flushToMemoryNow();
            this.dirty = false;
            this.valid = true;
        } else if (!this.dirty) {
            this.valid = false;
            this.cleanAncestors();
        } else {
            this.flushToMemoryNow();
            this.dirty = false;
        }
    }

    @Override
    public final void updateFromMemory(boolean andMarkDirty) {
        if (Cache.standard) {
            if (this.alwaysFlush) {
                if (andMarkDirty && !this.dirty || !andMarkDirty && !this.valid) {
                    this.fillFromMemoryNow();
                }
                return;
            }
            if (andMarkDirty) {
                this.setDirty();
            } else {
                this.setValid();
            }
        } else if (Cache.forbid && !this.valid) {
            ++ModifyOnce;
            this.cleanAncestors();
            if (this.redefinedFrom != null) {
                if (this.redefinedFrom.dirty) {
                    this.redefinedFrom.flushDirtyToMemory();
                } else {
                    this.redefinedFrom.cleanChildren(true);
                }
            }
            if (this.redefinedTo != null) {
                for (Variable tmp : this.redefinedTo) {
                    if (tmp.dirty) {
                        tmp.flushDirtyToMemory();
                        continue;
                    }
                    tmp.cleanChildren(true);
                }
            }
            this.cleanChildren(true);
            this.fillFromMemoryNow();
            this.valid = true;
            this.dirty = false;
        }
    }

    public final void updateToMemory() {
        if (this.signPosition == 0 && this.value.makeUnsignedCheck()) {
            this.numericString = null;
        }
        if (Cache.standard) {
            this.flushToMemoryNow();
        } else {
            this.valid = true;
            this.dirty = true;
        }
    }

    @Override
    public final Numeric add(int param) {
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.adding(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric add(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        param.updateFromMemory(true);
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        if (this == param) {
            Bignum tmp = new Bignum(param.toBignum());
            this.value.adding(tmp);
        } else {
            this.value.adding(param.toBignum());
        }
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric add(Bignum param) {
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.adding(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable add(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().add(param2.toBignum());
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable add(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.add(param2.toBignum());
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable add(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().add(param2);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable add(Bignum param1, Bignum param2) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.add(param2);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric addRounded(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.adding(param.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric addRounded(Bignum param) {
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.adding(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().add(param2.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.add(param2.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().add(param2);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable addRounded(Bignum param1, Bignum param2) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.add(param2);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric sub(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        if (this == param) {
            Bignum tmp = new Bignum(param.toBignum());
            this.value.subtracting(tmp);
        } else {
            this.value.subtracting(param.toBignum());
        }
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric sub(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().subtract(param2.toBignum());
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric subRounded(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.subtracting(param.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric subRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().subtract(param2.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric mul(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        Bignum paramValue = param.toBignum();
        this.value.multiplying(paramValue);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric mul(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().multiply(param2.toBignum());
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric mulRounded(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        Bignum paramValue = param.toBignum();
        this.value.multiplying(paramValue);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric mulRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().multiply(param2.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric div(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum paramn = param.toBignum();
        if (paramn.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.dividing(paramn);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric div(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum param2n = param2.toBignum();
        if (param2n.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().divide(param2n);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric divRounded(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum paramn = param.toBignum();
        if (paramn.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.dividing(paramn);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric divRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum param2n = param2.toBignum();
        if (param2n.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().divide(param2n);
        this.roundSEToMemory();
        return this;
    }

    public final Numeric idiv(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum paramn = param.toBignum();
        if (paramn.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value = this.value.integerDivide(paramn)[0];
        this.truncateSEToMemory();
        return this;
    }

    public final Numeric idiv(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.safeValue.make(this.value);
        Bignum param2n = param2.toBignum();
        if (param2n.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.value = param1.toBignum().integerDivide(param2n)[0];
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric mod(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum paramn = param.toBignum();
        if (paramn.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.remaindering(paramn);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric mod(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum param2n = param2.toBignum();
        if (param2n.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1.toBignum().remainder(param2n);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric pow(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum paramn = param.toBignum();
        if (this.value.isZero() && paramn.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.safeValue.make(this.value);
        this.value.powing(paramn);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric pow(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum param1n = param1.toBignum();
        Bignum param2n = param2.toBignum();
        if (param1n.isZero() && param2n.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1n.pow(param2n);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Numeric powRounded(Numeric param) {
        if (param.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum paramn = param.toBignum();
        if (this.value.isZero() && paramn.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.updateFromMemory(true);
        this.value.powing(paramn);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Numeric powRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        Bignum param1n = param1.toBignum();
        Bignum param2n = param2.toBignum();
        if (param1n.isZero() && param2n.isZero()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value = param1n.pow(param2n);
        this.roundSEToMemory();
        return this;
    }

    @Override
    void performNumericValidation(Object obj) {
        if (((Numeric)obj).value.requiresNumericValidate()) {
            if (obj instanceof DisplayP) {
                ((DisplayP)obj).checkNumericContent();
            } else if (obj instanceof DisplayMVS) {
                ((DisplayMVS)obj).checkNumericContent();
            } else if (obj instanceof PackedDecimalI) {
                ((PackedDecimalI)obj).checkNumericContent();
            }
        }
    }

    @Override
    public final int compare(Numeric param) {
        this.performNumericValidation(this);
        this.performNumericValidation(param);
        Bignum thisBignum = this.toBignum();
        Bignum paramn = param.toBignum();
        if (RuntimeEnvironment.isIBM) {
            if (thisBignum.isiAmNotNumeric() || paramn.isiAmNotNumeric()) {
                if (param.isHighValues()) {
                    return this.isHighValues() ? 0 : -1;
                }
                if (this.isHighValues()) {
                    return param.isHighValues() ? 0 : 1;
                }
                if (this.getUsage().equals("PackedDecimalI") && param.getUsage().equals("PackedDecimalI")) {
                    return this.compare(param.toString());
                }
                if ((param.getName().equals("ZEROS") || param.getUsage().equals("Display") && param.getName().isEmpty()) && this.signPosition == 0) {
                    String ZeroStr = new String(new char[this.itemSize]).replace('\u0000', '0');
                    if (memoryCharset != null) {
                        ZeroStr = new String(ZeroStr.getBytes(memoryCharset), defaultCharset);
                    }
                    return this.compare(ZeroStr);
                }
                PackedDecimalI op1 = null;
                PackedDecimalI op2 = null;
                if (this.getUsage().equals("PackedDecimalI") && !thisBignum.isiAmNotNumeric()) {
                    op1 = (PackedDecimalI)this;
                } else if (this.getUsage().equals("DisplayP") || this.getUsage().equals("DisplayMVS")) {
                    op1 = new PackedDecimalI();
                    op1.declare(this._tempmemory, 0, this.itemSize / 2 + 1, "op1", this.picLength, this.toNumericValueString(), null, null, null, this.flagBits, this.getPlace(), this.getScale());
                }
                if (param.getUsage().equals("PackedDecimalI") && !paramn.isiAmNotNumeric()) {
                    op2 = (PackedDecimalI)param;
                } else if (param.getUsage().equals("DisplayP") || param.getUsage().equals("DisplayMVS") || param.getUsage().equals("Display")) {
                    op2 = new PackedDecimalI();
                    op2.declare(this._tempmemory, 10, param.itemSize / 2 + 1, "op2", param.picLength, param.toNumericValueString(), null, null, null, param.flagBits, param.getPlace(), param.getScale());
                }
                if (op1 != null && op2 != null) {
                    return op1.toBignum().compareTo(op2.toBignum());
                }
                return this.compare(param.toString());
            }
        } else if (thisBignum.isiAmNotNumeric() || paramn.isiAmNotNumeric()) {
            return this.compare(param.toString());
        }
        Bignum leftValue = this.redefinedFrom != null && this.redefinedFrom instanceof DataPointer ? new Bignum(((DataPointer)this.redefinedFrom).getPointerAddress()) : this.value;
        return leftValue.compareTo(paramn);
    }

    @Override
    public final int compare(Numeric param, String alphabet) {
        return this.compare(param);
    }

    @Override
    public final int compare(Index i) {
        this.updateFromMemory(false);
        int v_int = this.value.intValue();
        int i_int = i.toInt();
        if (v_int < i_int) {
            return -1;
        }
        if (v_int > i_int) {
            return 1;
        }
        return 0;
    }

    @Override
    public final char toChar() {
        this.updateFromMemory(false);
        return (char)this.value.intValue();
    }

    @Override
    public final byte toByte() {
        this.updateFromMemory(false);
        return (byte)this.value.intValue();
    }

    @Override
    public final short toShort() {
        this.updateFromMemory(false);
        return (short)this.value.intValue();
    }

    @Override
    public final int toInt() {
        this.updateFromMemory(false);
        return this.value.intValue();
    }

    @Override
    public final long toLong() {
        this.updateFromMemory(false);
        return this.value.longValue();
    }

    @Override
    public final String toString() {
        return this.getString();
    }

    @Override
    public final Bignum toBignum() {
        if (this.redefinedFrom != null && this.redefinedFrom instanceof DataPointer) {
            return new Bignum(((DataPointer)this.redefinedFrom).getPointerAddress());
        }
        this.updateFromMemory(false);
        return this.value;
    }

    @Override
    public final Bignum toModifyBignum() {
        this.updateFromMemory(false);
        if (this.redefinedFrom != null && this.redefinedFrom instanceof DataPointer) {
            return new Bignum(((DataPointer)this.redefinedFrom).getPointerAddress());
        }
        return new Bignum(this.value);
    }

    @Override
    public final float toFloat() {
        this.updateFromMemory(false);
        return this.value.floatValue();
    }

    @Override
    public final double toDouble() {
        this.updateFromMemory(false);
        return this.value.doubleValue();
    }

    @Override
    public final boolean toBoolean() {
        this.updateFromMemory(false);
        return !this.value.isZero();
    }

    @Override
    public final BigInteger toBigInteger() {
        this.updateFromMemory(false);
        return this.value.bigIntegerValue();
    }

    @Override
    public final Variable move(char param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(byte param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(short param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(int param) {
        Handle h = this.getHandle();
        if (h != null) {
            h.set(param);
        }
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(long param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(String param) {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("move(String): Hi. param=" + param + ". this.toDebugString2()=" + this.toDebugString2() + ". QualifiedCobolName=" + this.getQualifiedCobolName());
        }
        if (this.dirty) {
            this.value.make(param, '.');
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, '.');
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("move(String): Bye. param=" + param + ". this.toDebugString2()=" + this.toDebugString2() + ". QualifiedCobolName=" + this.getQualifiedCobolName());
        }
        return this;
    }

    @Override
    public Variable move(char[] param) {
        if (this.dirty) {
            this.value.make(param, param.length);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, param.length);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public Variable move(char[] param, int length) {
        if (this.dirty) {
            this.value.make(param, length);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, length);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public Variable move(char[] param, int offset, int length) {
        if (this.dirty) {
            this.value.make(param, offset, length);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, offset, length);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public Variable move(byte[] param) {
        if (this.dirty) {
            this.value.make(param, param.length);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, param.length);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public Variable move(byte[] param, int length) {
        if (this.dirty) {
            this.value.make(param, length);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, length);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public Variable move(byte[] param, int offset, int length) {
        if (this.dirty) {
            this.value.make(param, offset, length);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param, offset, length);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(Bignum param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable moveR(Bignum param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.roundToMemory();
        return this;
    }

    @Override
    public final Variable move(float param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    @Override
    public final Variable move(double param) {
        if (this.dirty) {
            this.value.make(param);
        } else {
            this.setDirtyNoFill();
            this.value = new Bignum(param);
        }
        this.truncateToMemory();
        return this;
    }

    private void ibmZonedDecAlphaMove(String param) {
        int address = this.pointerAddress;
        int len = this.length(this.pointerMemory.getTopOfMemory() - address);
        int paramLength = param.length();
        int load = paramLength - len;
        byte[] asBytes = param.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = param.getBytes(memoryCharset);
            for (int j = 0; j < asBytes.length; ++j) {
                if (asBytes[j] == -1) continue;
                asBytes[j] = ebcdicBytes[j];
            }
        }
        if (RuntimeEnvironment.isIBMASC) {
            asBytes = param.getBytes(Charset.forName("Cp1047"));
            int n = paramLength - 1;
            asBytes[n] = (byte)(asBytes[n] | 0xF0);
            try {
                String str = new String(asBytes, "Cp1047");
                asBytes = str.getBytes();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (load > 0) {
            for (int i = load; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        } else if (load < 0) {
            int i;
            load = -load;
            for (i = 0; i < load; ++i) {
                this.pointerMemory.setByte(address++, (byte)48);
            }
            for (i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        } else {
            for (int i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        }
    }

    @Override
    public final Variable move(Numeric param) {
        Handle copy;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("0: Numeric. Input param.toDebugString2()=" + param.toDebugString2() + ". ");
        }
        if (this.handle != null && (copy = param.getHandle()) != null) {
            this.handle.set(copy);
        }
        if (param.getChild() != null || param.isGroupMove()) {
            if (Cache.forbid) {
                param.flushDirtyToMemory();
            }
            this.move((Variable)param);
        } else {
            this.setDirtyNoFill();
            this.performNumericValidation(param);
            if (RuntimeEnvironment.isIBM && param.value.isiAmNotNumeric() && (param instanceof DisplayP && this instanceof DisplayP || param instanceof DisplayMVS && this instanceof DisplayMVS)) {
                this.ibmZonedDecAlphaMove(param.toString());
            } else {
                this.value = param.toModifyBignum();
                this.truncateToMemory();
            }
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Numeric: last(ie, after MOVE): toDebugString2()=" + this.toDebugString2() + ". ");
        }
        if (LogSetup.IS_LOGGING_INFO && this.value.toLongAtPlace(0) != param.toLong()) {
            LogSetup.LOGGER.warning("NUMERIC TRUNCATION at: MOVE " + ("".equals(param.getName()) ? param.toNumericString() : param.getName()) + " TO " + this.getName() + ". From field = " + param.toNumericString() + ". After MOVE, " + this.getName() + "=" + this.value.toNumericString() + ". MOVE " + ("".equals(param.getName()) ? param.toNumericString() : param.getQualifiedCobolName()) + " TO " + this.getQualifiedCobolName() + ".");
        }
        return this;
    }

    @Override
    public Variable move(Variable param) {
        Object paramString;
        Handle copy;
        if (this.handle != null && (copy = param.getHandle()) != null) {
            this.handle.set(copy);
        }
        this.setDirtyNoFill();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("move(Variable): param: QualifiedCobolName=" + param.getQualifiedCobolName() + ". toString()=" + param.toString() + ". toDisplayString()=" + param.toDisplayString() + ". toInspectString()=" + param.toInspectString() + ". toCompareString()=" + param.toCompareString() + ". toNumericString()=" + param.toNumericString() + ". this.QualifiedCobolName=" + this.getQualifiedCobolName() + ".");
        }
        if (param.isNotRefmodVar() && param.picLength == 0 && (param.getChild() != null || param.isGroupMove())) {
            paramString = param.toString();
            int paramStringLength = ((String)paramString).length();
            if (paramStringLength == this.itemSize) {
                this.setString((String)paramString);
            } else if (paramStringLength > this.itemSize) {
                this.setString(((String)paramString).substring(0, this.itemSize));
            } else {
                this.setString((String)paramString + BignumType.all(' ', this.itemSize - paramStringLength));
            }
            this.dirty = false;
            this.valid = false;
            if (Cache.forbid) {
                this.valid = false;
            }
            this.dirty = false;
        } else {
            if (param.isSpecial()) {
                paramString = param.specialCharArray(this);
                this.value = new Bignum((char[])paramString, 46);
                if (this.value.isiAmNotNumeric()) {
                    this.dirty = false;
                }
            } else {
                paramString = param.toNumericString();
                this.value = new Bignum((String)paramString, '.');
                if (this.value.isiAmNotNumeric()) {
                    this.dirty = false;
                }
            }
            this.truncateToMemory();
        }
        return this;
    }

    @Override
    public final Variable moveSE(char param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(byte param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(short param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(int param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(long param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(String param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param, this.getDecimal());
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public Variable moveSE(Bignum param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(float param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(double param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param.toBignum());
        this.truncateSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSE(Variable param) {
        param.flushToMemory();
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.moveSE(param.toString());
        return this;
    }

    @Override
    public final Variable moveSER(char param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(byte param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(short param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(int param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(long param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(String param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param, '.');
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(Bignum param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(float param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(double param) {
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param);
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveR(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param.toBignum());
        this.roundToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(Numeric param) {
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        if (!this.dirty) {
            this.setDirty();
        }
        this.safeValue.make(this.value);
        this.value.make(param.toBignum());
        this.roundSEToMemory();
        return this;
    }

    @Override
    public final Variable moveSER(Variable param) {
        param.flushToMemory();
        if (param.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.moveSER(param.toString());
        return this;
    }

    public final Bignum getValue() {
        return this.value;
    }

    @Override
    public final String toScalelessString() {
        this.updateFromMemory(false);
        if (this.scale <= 0) {
            return this.value.toString();
        }
        Bignum descaledValue = new Bignum(this.value);
        if (this.place > 0) {
            descaledValue.movingPointRight(this.scale);
        } else {
            descaledValue.movingPointLeft(this.scale);
        }
        return descaledValue.toString();
    }

    @Override
    protected final String toCompareString() {
        this.updateFromMemory(false);
        this.performNumericValidation(this);
        String valueString = this.value.isiAmNotNumeric() ? ((Variable)this).toDisplayString() : this.value.toString();
        int i = valueString.indexOf(46);
        if (i > 0) {
            valueString = valueString.substring(0, i);
        } else if (i == 0) {
            valueString = "0";
        }
        if (memoryCharset != null) {
            valueString = new String(valueString.getBytes(memoryCharset), defaultCharset);
        }
        return valueString;
    }

    @Override
    public String toDisplayString() {
        char signChar;
        int deficit;
        boolean negative;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("0: dirty=" + this.dirty + ". value=" + this.value + ". this.getName()=" + this.getName() + ". picLength=" + this.picLength + ". place=" + this.place + ". picArray=" + Arrays.toString(this.getPictureArray()) + ". ");
        }
        this.updateFromMemory(false);
        String s = this.value.toString();
        if (s == null || s.length() == 0) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finest("1: s==null: dirty=" + this.dirty + ". value=" + this.value + ". this.getName()=" + this.getName() + ". picLength=" + this.picLength + ". place=" + this.place + ". picArray=" + Arrays.toString(this.getPictureArray()) + ". ");
            }
            return new String(new char[this.picLength]).replace('\u0000', '0');
        }
        boolean bl = negative = s.charAt(0) == '-';
        if (negative) {
            s = s.substring(1);
        }
        byte right = this.place >= 0 ? this.place : (byte)0;
        int foundDecimal = -1;
        if (right > 0) {
            foundDecimal = s.indexOf(46);
            if (foundDecimal < 1) {
                s = s + "." + new String(new char[right]).replace('\u0000', '0');
            } else {
                int foundPlaces = s.length() - foundDecimal - 1;
                if (foundPlaces != right) {
                    s = foundPlaces < this.place ? s + new String(new char[right - foundPlaces]).replace('\u0000', '0') : s.substring(0, s.length() - (foundPlaces - right));
                }
            }
        }
        if ((deficit = this.picLength - (s = s.replace(".", "")).length()) < 0) {
            deficit = 0;
        } else if (deficit > 32) {
            deficit = 32;
        }
        char c = signChar = negative ? (char)'-' : '+';
        if (this.signPosition == 2 || this.signPosition == 4) {
            return signChar + new String(new char[deficit]).replace('\u0000', '0') + s;
        }
        if (this.signPosition == 3 || this.signPosition == 5) {
            return new String(new char[deficit]).replace('\u0000', '0') + s + signChar;
        }
        return new String(new char[deficit]).replace('\u0000', '0') + s;
    }

    public ZonedDescription getZonedDescriptionInstance() {
        return null;
    }

    @Override
    public boolean isNumeric() {
        ZonedDescription z = this.getZonedDescriptionInstance();
        if (z == null) {
            return true;
        }
        return this.isNumeric(z);
    }

    @Override
    public void initData() {
        this.pointerMemory.set(this.pointerAddress, this.length(), (byte)0);
    }
}

