/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public final class BinaryRev
extends Binary
implements Cloneable,
comparableByteArray {
    private static final long serialVersionUID = 1L;

    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.BinaryRev";
    }

    public BinaryRev() {
        this.itemSize = 8;
    }

    public BinaryRev(Handle handle) {
        super(handle);
    }

    public BinaryRev(long longValue, boolean signed, int bytes, int digits) {
        super(longValue);
        this.valid = true;
        this.dirty = true;
        this.signPosition = (byte)(signed ? 3 : 0);
        this.itemSize = bytes;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        if (digits < 0) {
            digits = -1;
        }
        this.storeSize = digits;
        this.calcStoreSize();
    }

    public BinaryRev(Handle handle, boolean temporary) {
        super(handle);
        this.itemSize = 6;
        if (temporary) {
            this.value = new Bignum(handle.getHandleNumber());
            this.dirty = true;
            this.signPosition = 0;
            this.pointerMemory = new Memory(this.itemSize, new String[0]);
            this.pointerAddress = 0;
            this.storeSize = 14;
        }
    }

    @Override
    public int getUsageNumber() {
        return 3;
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            if (this.scale > 0) {
                byte temporaryPlace = this.place;
                Bignum storeValue = this.value;
                if (this.place > 0) {
                    storeValue = this.value.movePointRight(this.scale);
                    temporaryPlace = (byte)(temporaryPlace - this.scale);
                } else {
                    storeValue = this.value.movePointLeft(this.scale);
                }
                long temp = temporaryPlace == 0 ? storeValue.longValue() : storeValue.toLongAtPlace(this.place);
                switch (this.itemSize) {
                    case 1: {
                        this.pointerMemory.setByteReverse(this.pointerAddress, (byte)temp);
                        return;
                    }
                    case 2: {
                        this.pointerMemory.setShortReverse(this.pointerAddress, (short)temp);
                        return;
                    }
                    case 4: {
                        this.pointerMemory.setIntReverse(this.pointerAddress, (int)temp);
                        return;
                    }
                    case 8: {
                        this.pointerMemory.setLongReverse(this.pointerAddress, temp);
                        return;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.pointerMemory.setDataReverse(this.pointerAddress, temp, this.itemSize);
                        return;
                    }
                }
                return;
            }
            long temp = this.place == 0 ? this.value.longValue() : this.value.toLongAtPlace(this.place);
            switch (this.itemSize) {
                case 1: {
                    this.pointerMemory.setByteReverse(this.pointerAddress, (byte)temp);
                    return;
                }
                case 2: {
                    this.pointerMemory.setShortReverse(this.pointerAddress, (short)temp);
                    return;
                }
                case 4: {
                    this.pointerMemory.setIntReverse(this.pointerAddress, (int)temp);
                    return;
                }
                case 8: {
                    this.pointerMemory.setLongReverse(this.pointerAddress, temp);
                    return;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    this.pointerMemory.setDataReverse(this.pointerAddress, temp, this.itemSize);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in BINARY-REV storage of " + this.getQualifiedCobolName(), (Throwable)e);
            return;
        }
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            if (this.scale > 0) {
                byte temporaryPlace = this.place;
                if (this.place > 0) {
                    temporaryPlace = (byte)(temporaryPlace - this.scale);
                }
                long memoryValue = 0L;
                switch (this.itemSize) {
                    case 1: {
                        memoryValue = this.pointerMemory.getByteReverse(this.pointerAddress);
                        break;
                    }
                    case 2: {
                        memoryValue = this.pointerMemory.getShortReverse(this.pointerAddress);
                        break;
                    }
                    case 4: {
                        memoryValue = this.pointerMemory.getIntReverse(this.pointerAddress);
                        break;
                    }
                    case 8: {
                        memoryValue = this.pointerMemory.getLongReverse(this.pointerAddress);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        memoryValue = this.pointerMemory.getDataReverse(this.pointerAddress, this.itemSize);
                        break;
                    }
                    default: {
                        CobolException.runtimeError("Unknown size of BINARY-REV data.", null);
                    }
                }
                this.value = null;
                if (this.signPosition == 0 && memoryValue < 0L) {
                    switch (this.itemSize) {
                        case 1: {
                            memoryValue &= 0xFFL;
                            break;
                        }
                        case 2: {
                            memoryValue &= 0xFFFFL;
                            break;
                        }
                        case 3: {
                            memoryValue &= 0xFFFFFFL;
                            break;
                        }
                        case 4: {
                            memoryValue &= 0xFFFFFFFFL;
                            break;
                        }
                        case 5: {
                            memoryValue &= 0xFFFFFFFFFFL;
                            break;
                        }
                        case 6: {
                            memoryValue &= 0xFFFFFFFFFFFFL;
                            break;
                        }
                        case 7: {
                            memoryValue &= 0xFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 8: {
                            this.value = new Bignum(memoryValue &= Long.MAX_VALUE, (int)temporaryPlace);
                            this.value.multiplying(2L);
                        }
                    }
                }
                if (this.value == null) {
                    this.value = new Bignum(memoryValue, (int)temporaryPlace);
                }
                this.numericString = null;
                this.value.movingPoint(this.scale, temporaryPlace);
            } else {
                long memoryValue = 0L;
                switch (this.itemSize) {
                    case 1: {
                        memoryValue = this.pointerMemory.getByteReverse(this.pointerAddress);
                        break;
                    }
                    case 2: {
                        memoryValue = this.pointerMemory.getShortReverse(this.pointerAddress);
                        break;
                    }
                    case 4: {
                        memoryValue = this.pointerMemory.getIntReverse(this.pointerAddress);
                        break;
                    }
                    case 8: {
                        memoryValue = this.pointerMemory.getLongReverse(this.pointerAddress);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        memoryValue = this.pointerMemory.getDataReverse(this.pointerAddress, this.itemSize);
                        break;
                    }
                    default: {
                        CobolException.runtimeError("Unknown size of BINARY-REV data.", null);
                    }
                }
                this.value = null;
                if (this.signPosition == 0 && memoryValue < 0L) {
                    switch (this.itemSize) {
                        case 1: {
                            memoryValue &= 0xFFL;
                            break;
                        }
                        case 2: {
                            memoryValue &= 0xFFFFL;
                            break;
                        }
                        case 3: {
                            memoryValue &= 0xFFFFFFL;
                            break;
                        }
                        case 4: {
                            memoryValue &= 0xFFFFFFFFL;
                            break;
                        }
                        case 5: {
                            memoryValue &= 0xFFFFFFFFFFL;
                            break;
                        }
                        case 6: {
                            memoryValue &= 0xFFFFFFFFFFFFL;
                            break;
                        }
                        case 7: {
                            memoryValue &= 0xFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 8: {
                            this.value = new Bignum(memoryValue &= Long.MAX_VALUE, (int)this.place);
                            this.value.multiplying(2L);
                        }
                    }
                }
                if (this.value == null) {
                    this.value = new Bignum(memoryValue, (int)this.place);
                }
                this.numericString = null;
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in BINARY-REV retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public int getType() {
        return this.getBasicType(176);
    }
}

