/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile {
    private RandomAccessFile raf = null;
    private boolean reading = false;
    protected byte[] inbuf;
    protected int incount;
    protected int inpos;
    protected int inmarkpos = -1;
    protected int inmarklimit;
    protected byte[] outbuf;
    protected int outcount;

    public BufferedRandomAccessFile(RandomAccessFile raf) {
        this.raf = raf;
        this.inbuf = new byte[2048];
        this.outbuf = new byte[512];
    }

    public BufferedRandomAccessFile(RandomAccessFile raf, int size) {
        this.raf = raf;
        if (size <= 0) {
            size = 2048;
        }
        this.inbuf = new byte[size];
        this.outbuf = new byte[size];
    }

    public BufferedRandomAccessFile(RandomAccessFile raf, int inputSize, int outputSize) {
        this.raf = raf;
        if (inputSize <= 0) {
            inputSize = 2048;
        }
        if (outputSize <= 0) {
            outputSize = 2048;
        }
        this.inbuf = new byte[inputSize];
        this.outbuf = new byte[outputSize];
    }

    private void discard() {
        this.incount = 0;
        this.inpos = 0;
        this.reading = false;
    }

    private void infill() throws IOException {
        if (this.inmarkpos < 0) {
            this.inpos = 0;
        } else if (this.inpos >= this.inbuf.length) {
            if (this.inmarkpos > 0) {
                int sz = this.inpos - this.inmarkpos;
                System.arraycopy(this.inbuf, this.inmarkpos, this.inbuf, 0, sz);
                this.inpos = sz;
                this.inmarkpos = 0;
            } else if (this.inbuf.length >= this.inmarklimit) {
                this.inmarkpos = -1;
                this.inpos = 0;
            } else {
                int nsz = this.inpos * 2;
                if (nsz > this.inmarklimit) {
                    nsz = this.inmarklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.inbuf, 0, nbuf, 0, this.inpos);
                this.inbuf = nbuf;
            }
        }
        int n = this.raf.read(this.inbuf, this.inpos, this.inbuf.length - this.inpos);
        this.incount = n <= 0 ? this.inpos : n + this.inpos;
    }

    public synchronized int read() throws IOException {
        if (!this.reading) {
            this.flush();
        }
        if (this.inpos >= this.incount) {
            this.infill();
            if (this.inpos >= this.incount) {
                return -1;
            }
        }
        return this.inbuf[this.inpos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int avail;
        if (!this.reading) {
            this.flush();
        }
        if ((avail = this.incount - this.inpos) <= 0) {
            if (len >= this.inbuf.length && this.inmarkpos < 0) {
                return this.raf.read(b, off, len);
            }
            this.infill();
            avail = this.incount - this.inpos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.inbuf, this.inpos, b, off, cnt);
        this.inpos += cnt;
        return cnt;
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private void flush() throws IOException {
        if (this.outcount > 0) {
            this.raf.write(this.outbuf, 0, this.outcount);
            this.outcount = 0;
        }
        this.reading = true;
    }

    public synchronized void write(int b) throws IOException {
        if (this.reading) {
            this.discard();
        }
        if (this.outcount >= this.outbuf.length) {
            this.flush();
        }
        this.outbuf[this.outcount++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.reading) {
            this.discard();
        }
        if (len >= this.outbuf.length) {
            this.flush();
            this.raf.write(b, off, len);
            return;
        }
        if (len > this.outbuf.length - this.outcount) {
            this.flush();
        }
        System.arraycopy(b, off, this.outbuf, this.outcount, len);
        this.outcount += len;
    }

    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void seek(long position) throws IOException {
        this.incount = 0;
        this.inpos = 0;
        if (this.outcount > 0) {
            this.raf.write(this.outbuf, 0, this.outcount);
            this.outcount = 0;
        }
        this.raf.seek(position);
    }

    public final void close() throws IOException {
        this.flush();
        this.raf.close();
    }
}

