/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.debug.DataWatchPoint;
import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.Level88;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.exec.relFile;
import com.heirloomcomputing.ecs.exec.seqFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public abstract class CobolBase {
    static Vector<basicFile> openFilesList = new Vector();
    HashMap<String, String> cicsCondBreaks = new HashMap();
    public static String $X$_exceptionInfo;
    static Throwable currentThrownException;
    static TreeMap<String, String> _debug_constantsMap;
    static String[] _debug_Constants;
    static String objSuffix;
    TreeMap<String, Object> _debug_Cobol2JavaMap = null;
    TreeMap<String, Object> Section01s;

    public void _debug_AddCICSConditionalBreak(String cond, String paraLabel) {
        if (cond == null || paraLabel == null || paraLabel.isEmpty()) {
            return;
        }
        this.cicsCondBreaks.put(cond.toUpperCase(), paraLabel);
    }

    public void _debug_deleteCICSConditionalBreak(String cond) {
        if (cond == null) {
            return;
        }
        this.cicsCondBreaks.remove(cond.toUpperCase());
    }

    public String _debug_getCICSConditionalBreaks() {
        String retVal = this.cicsCondBreaks.toString();
        return retVal.substring(1, retVal.length() - 1);
    }

    public static int _debug_getExceptionLine(Throwable _throw) {
        StackTraceElement[] stacks;
        for (StackTraceElement stack : stacks = _throw.getStackTrace()) {
            if (stack.getClassName().startsWith("com.heirloomcomputing.")) continue;
            return stack.getLineNumber();
        }
        return 0;
    }

    public static Object _debug_getExceptionString(Throwable _throw) {
        if (currentThrownException == _throw) {
            return "";
        }
        currentThrownException = _throw;
        return _throw;
    }

    public static int _debug_getException() {
        return Integer.parseInt($X$_exceptionInfo);
    }

    protected void _debug_buildConstantsInfo() {
        if (_debug_constantsMap != null) {
            return;
        }
        _debug_constantsMap = new TreeMap();
        Class<?> mainPgm = this.getClass();
        while (mainPgm.getEnclosingClass() != null) {
            mainPgm = mainPgm.getEnclosingClass();
        }
        Field[] ff = null;
        try {
            ff = mainPgm.getFields();
            for (int i = 0; i < ff.length; ++i) {
                if (!ff[i].getName().startsWith("$X$") || ff[i].getName().equals("$X$_exceptionInfo")) continue;
                if (ff[i].get(null) instanceof Variable) {
                    _debug_constantsMap.put(ff[i].getName().substring(3).replaceAll("_", "-"), ((Variable)ff[i].get(null)).toDisplayString());
                    continue;
                }
                if (ff[i].get(null) instanceof byte[]) {
                    _debug_constantsMap.put(ff[i].getName().substring(3).replaceAll("_", "-"), new String((byte[])ff[i].get(null)));
                    continue;
                }
                if (ff[i].get(null) instanceof char[]) {
                    _debug_constantsMap.put(ff[i].getName().substring(3).replaceAll("_", "-"), new String((char[])ff[i].get(null)));
                    continue;
                }
                _debug_constantsMap.put(ff[i].getName().substring(3).replaceAll("_", "-"), ff[i].get(null).toString());
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            return;
        }
    }

    public String[] _debug_getConstantsInfo() {
        this._debug_buildConstantsInfo();
        if (_debug_Constants != null) {
            return _debug_Constants;
        }
        _debug_Constants = new String[_debug_constantsMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : _debug_constantsMap.entrySet()) {
            CobolBase._debug_Constants[i++] = entry.getKey() + ":" + entry.getValue();
        }
        return _debug_Constants;
    }

    public String _debug_getConstantInfo(String key) {
        this._debug_buildConstantsInfo();
        if (_debug_constantsMap.containsKey(key)) {
            return _debug_constantsMap.get(key);
        }
        return null;
    }

    public String _debug_getCobolSection(String cobolVar) {
        Object cobolObject = this._debug_Cobol2JavaMap.get(cobolVar);
        String filName = "Fil$" + cobolVar + "$";
        for (Map.Entry<String, Object> es : this.Section01s.entrySet()) {
            if (es.getValue() != cobolObject && !es.getKey().startsWith(filName)) continue;
            return es.getKey().substring(0, 3);
        }
        return "";
    }

    Object[] _debug_getCobolSection01s(String section, int type) {
        this._debug_buildCobol2JavaMap();
        String _secName = null;
        if (section.equals("Working-Storage Variables")) {
            _secName = "Wrk$";
        }
        if (section.equals("Shared-Storage Variables")) {
            _secName = "Shr$";
        }
        if (section.equals("Linkage Variables")) {
            _secName = "Lnk$";
        }
        if (section.equals("File Section")) {
            _secName = "Fil$";
        }
        if (section.equals("Local Storage Variables")) {
            _secName = "Lcl$";
        }
        if (section.equals("Screen Section")) {
            _secName = "Scr$";
        }
        SortedMap<String, Object> sub = this.Section01s.subMap(_secName, _secName + "~");
        if (type == 0) {
            return sub.keySet().toArray();
        }
        return sub.values().toArray();
    }

    Object[] _debug_getCobolNames(String highKey) {
        this._debug_buildCobol2JavaMap();
        return this._debug_Cobol2JavaMap.tailMap(highKey).keySet().toArray();
    }

    boolean _debug_isObjectRefVariable(String varName) {
        varName = varName + objSuffix;
        if (this.Section01s.containsKey("Wrk$" + varName)) {
            return true;
        }
        if (this.Section01s.containsKey("Shr$" + varName)) {
            return true;
        }
        if (this.Section01s.containsKey("Lnk$" + varName)) {
            return true;
        }
        if (this.Section01s.containsKey("Fil$" + varName)) {
            return true;
        }
        if (this.Section01s.containsKey("Scr$" + varName)) {
            return true;
        }
        return this.Section01s.containsKey("Lcl$" + varName);
    }

    void _debug_buildCobol2JavaMap() {
        if (this._debug_Cobol2JavaMap != null) {
            return;
        }
        Field[] ff = null;
        try {
            this._debug_Cobol2JavaMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.Section01s = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            Field[] progFields = this.getClass().getFields();
            for (int x = 0; x < progFields.length; ++x) {
                String _secName = progFields[x].getType().getSimpleName();
                if (!_secName.equals("Wrk") && !_secName.equals("Shr") && !_secName.equals("Lnk") && !_secName.equals("Fil") && !_secName.equals("Scr") && !_secName.equals("Lcl") && !_secName.equals("Context")) continue;
                Object _object = progFields[x].get(this);
                ff = _object.getClass().getFields();
                if (_secName.equals("Context")) {
                    this._debug_Cobol2JavaMap.put("return-code", _object);
                    continue;
                }
                for (int i = 0; i < ff.length; ++i) {
                    String vname;
                    if (ff[i].get(_object) == null) {
                        this._debug_Cobol2JavaMap.put(ff[i].getName(), ff[i].get(_object));
                        this.Section01s.put(_secName + "$" + ff[i].getName() + objSuffix, ff[i].get(_object));
                        continue;
                    }
                    if (ff[i].get(_object).getClass().isArray()) continue;
                    if (ff[i].get(_object) instanceof Variable) {
                        if (((Variable)ff[i].get((Object)_object)).isRenames == 1 && !ff[i].getName().contains(((Variable)ff[i].get(_object)).getName())) {
                            this._debug_Cobol2JavaMap.put(ff[i].getName(), ff[i].get(_object));
                            this.Section01s.put(_secName + "$" + ff[i].getName(), ff[i].get(_object));
                            continue;
                        }
                        if (((Variable)ff[i].get(_object)).isFiller()) {
                            this._debug_Cobol2JavaMap.put(ff[i].getName(), ff[i].get(_object));
                        } else {
                            vname = ((Variable)ff[i].get(_object)).getQualifiedName();
                            if (vname.startsWith("com.")) {
                                vname = ff[i].getName();
                            }
                            this._debug_Cobol2JavaMap.put(vname, ff[i].get(_object));
                        }
                        if (((Variable)ff[i].get(_object)).getParent() != null) continue;
                        vname = ((Variable)ff[i].get(_object)).getQualifiedName();
                        if (vname.startsWith("com.")) {
                            vname = ff[i].getName();
                        }
                        if (_secName.equalsIgnoreCase("Fil")) {
                            this.Section01s.put(_secName + "$" + ff[i].getName().substring(ff[i].getName().lastIndexOf("_OF_") + 4).replaceAll("_", "-") + "$" + vname, ff[i].get(_object));
                            continue;
                        }
                        this.Section01s.put(_secName + "$" + vname, ff[i].get(_object));
                        continue;
                    }
                    if (ff[i].get(_object) instanceof Level88) {
                        vname = ((Level88)ff[i].get(_object)).getQualifiedName();
                        if (vname.contains("com.heirloomcomputing")) {
                            vname = ff[i].getName();
                        }
                        this._debug_Cobol2JavaMap.put(vname, ff[i].get(_object));
                        continue;
                    }
                    if (ff[i].get(_object) instanceof basicFile) {
                        this._debug_Cobol2JavaMap.put(ff[i].getName().replaceAll("_", "-"), ff[i].get(_object));
                        continue;
                    }
                    if (!ff[i].getType().getName().startsWith("com.heirloomcomputing")) {
                        this._debug_Cobol2JavaMap.put(ff[i].getName(), ff[i].get(_object));
                        this.Section01s.put(_secName + "$" + ff[i].getName() + objSuffix, ff[i].get(_object));
                        continue;
                    }
                    this._debug_Cobol2JavaMap.put(ff[i].getName(), ff[i].get(_object));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object _debug_getFileObject(String key) {
        return this._debug_Cobol2JavaMap.get(key);
    }

    public String _debug_getCobolObjectReference(String name, String qualifier) {
        try {
            if (name.indexOf(46) == -1) {
                return "!!!Unable to map object reference!!!";
            }
            String[] fieldName = name.split("\\.", 2);
            Field sectionField = this.getClass().getField(fieldName[0]);
            Class<?> sectionClass = sectionField.getType();
            Field javaVar = sectionClass.getField(fieldName[1]);
            Object retObj = javaVar.get(sectionField.get(this));
            if (retObj != null) {
                return retObj.toString();
            }
            return "null";
        }
        catch (NoSuchFieldException e) {
            return "!!!Unable to map object reference!!!";
        }
        catch (Exception err) {
            return err.toString();
        }
    }

    public Object _debug_getCobolHoverVariable(String name, String qualifier) {
        NavigableMap<String, Object> submap;
        this._debug_buildCobol2JavaMap();
        Object result = this._debug_Cobol2JavaMap.get(name);
        if (result == null && (submap = this._debug_Cobol2JavaMap.subMap(name, true, name + "_~", true)).size() > 0) {
            String hoverword = "";
            hoverword = qualifier != null && !qualifier.isEmpty() && qualifier != name ? name + "_OF_" + qualifier : name;
            if (hoverword.indexOf("_OF_") != -1) {
                hoverword = hoverword.replaceAll("_OF_", "_OF_.*");
            }
            hoverword = "(?i)" + hoverword + "(_OF_.*)*";
            String matchkey = "";
            for (String key : submap.keySet()) {
                if (key.matches(hoverword)) {
                    if (!matchkey.isEmpty()) {
                        if (key.contains(matchkey + "__")) continue;
                        return "Ambiguous data reference. Select a valid pre-qualifier.";
                    }
                    matchkey = key;
                    continue;
                }
                if (matchkey.isEmpty()) continue;
                return this._debug_Cobol2JavaMap.get(matchkey);
            }
            if (!matchkey.isEmpty()) {
                return this._debug_Cobol2JavaMap.get(matchkey);
            }
        }
        if (result == null) {
            result = this._debug_getConstantInfo(name);
        }
        return result;
    }

    int _debug_compare(String expr1, String expr2) {
        Variable leftExprObj = (Variable)this._debug_getCobolHoverVariable(expr1, "");
        Variable rightExprObj = null;
        try {
            Integer.parseInt(expr2);
            rightExprObj = new Numeric(expr2);
        }
        catch (NumberFormatException nfe) {
            rightExprObj = (Variable)this._debug_getCobolHoverVariable(expr2, "");
        }
        if (leftExprObj instanceof DataPointer) {
            if (rightExprObj instanceof DataPointer) {
                return ((DataPointer)leftExprObj).compare((DataPointer)rightExprObj);
            }
            return ((DataPointer)leftExprObj).compare(rightExprObj);
        }
        if (leftExprObj instanceof Numeric) {
            return ((Numeric)leftExprObj).compare((Numeric)rightExprObj);
        }
        return 0;
    }

    Object _debug_getWatchpointSet() {
        return DataWatchPoint.getWatchpointSet();
    }

    protected void _debug_loadWatchpoints(String pgmName) {
        ArrayList<String> watchSet = DataWatchPoint.getWatchpoints(pgmName);
        for (int i = 0; i < watchSet.size(); ++i) {
            String[] watchElements = watchSet.get(i).split(":", 5);
            Object element = this._debug_getCobolHoverVariable(watchElements[0], "");
            if (element == null) continue;
            if (!watchElements[1].isEmpty()) {
                element = ((Variable)element).idx(watchElements[1]);
            }
            ((Variable)element).setWatchpointBreak(Integer.parseInt(watchElements[3]), watchElements[4]);
        }
    }

    public void returnCobolExcepToIDE(boolean exitOk, String desc) {
        RuntimeEnvironment.setReturnExcepToIDE(exitOk, desc);
    }

    public void setTraceSwitch(boolean trace2) {
        RuntimeEnvironment.setTraceSwitch(trace2);
    }

    public void _debug_SQL_break() {
    }

    public void _debug_Next_Sentence() {
    }

    public static String printDCBSystemInfo(String filename) {
        Properties pros = System.getProperties();
        Set<String> keyvalSet = pros.stringPropertyNames();
        StringBuilder result = new StringBuilder();
        ArrayList<String> parseSet = new ArrayList<String>();
        parseSet.add(filename);
        for (int i = 0; i < parseSet.size(); ++i) {
            String keyStart = ((String)parseSet.get(i)).toUpperCase().replace('.', '_') + "-";
            Iterator<String> iterator = keyvalSet.iterator();
            while (iterator.hasNext()) {
                String keyval;
                String origkey = keyval = iterator.next();
                if (!(keyval = keyval.toUpperCase()).startsWith(keyStart)) continue;
                result.append(keyval + "=" + pros.getProperty(origkey) + "\n");
                if (!keyval.endsWith("-ASSOCIATES")) continue;
                String[] assVals = pros.getProperty(origkey).split(",");
                for (int j = 0; j < assVals.length; ++j) {
                    if (assVals[j].trim().isEmpty()) continue;
                    parseSet.add(assVals[j]);
                }
            }
            result.append("**********************************************\n");
        }
        return result.toString();
    }

    public void _closeFiles(Object fil, Context _context) {
        if (_context.getParent() == null) {
            int i;
            Vector<basicFile> vFiles = _context.getFiles();
            for (i = 0; i < vFiles.size(); ++i) {
                if (!(vFiles.get(i) instanceof idxFile && ((idxFile)vFiles.get(i)).isOpen() || vFiles.get(i) instanceof relFile && ((relFile)vFiles.get(i)).isOpen()) && (!(vFiles.get(i) instanceof seqFile) || !((seqFile)vFiles.get(i)).isOpen())) continue;
                vFiles.get(i).close();
            }
            for (i = 0; i < openFilesList.size(); ++i) {
                if (!(openFilesList.get(i) instanceof idxFile && ((idxFile)openFilesList.get(i)).isOpen() || openFilesList.get(i) instanceof relFile && ((relFile)openFilesList.get(i)).isOpen()) && (!(openFilesList.get(i) instanceof seqFile) || !((seqFile)openFilesList.get(i)).isOpen())) continue;
                openFilesList.get(i).close();
            }
            openFilesList.clear();
        } else {
            Vector<basicFile> vFiles = _context.getFiles();
            for (int i = 0; i < vFiles.size(); ++i) {
                if (openFilesList.contains(vFiles.get(i))) {
                    if (vFiles.get(i) instanceof idxFile && !((idxFile)vFiles.get(i)).isOpen()) {
                        openFilesList.remove(vFiles.get(i));
                        continue;
                    }
                    if (vFiles.get(i) instanceof relFile && !((relFile)vFiles.get(i)).isOpen()) {
                        openFilesList.remove(vFiles.get(i));
                        continue;
                    }
                    if (!(vFiles.get(i) instanceof seqFile) || ((seqFile)vFiles.get(i)).isOpen()) continue;
                    openFilesList.remove(vFiles.get(i));
                    continue;
                }
                if (vFiles.get(i) instanceof idxFile && ((idxFile)vFiles.get(i)).isOpen()) {
                    openFilesList.add(vFiles.get(i));
                    continue;
                }
                if (vFiles.get(i) instanceof relFile && ((relFile)vFiles.get(i)).isOpen()) {
                    openFilesList.add(vFiles.get(i));
                    continue;
                }
                if (!(vFiles.get(i) instanceof seqFile) || !((seqFile)vFiles.get(i)).isOpen()) continue;
                openFilesList.add(vFiles.get(i));
            }
        }
    }

    static {
        currentThrownException = null;
        _debug_constantsMap = null;
        _debug_Constants = null;
        objSuffix = "(Object)";
    }

    protected static interface computeExpr {
        public Bignum run();
    }
}

