/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.AbendException;
import com.heirloomcomputing.ecs.exec.AppletExitException;
import com.heirloomcomputing.ecs.exec.CobolBase;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Dialog;
import com.heirloomcomputing.ecs.exec.ExitProgramException;
import com.heirloomcomputing.ecs.exec.IPCException;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Shutdown;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class CobolException {
    public static final int IGNORE_EXCEPTION = 0;
    public static final int RETHROW_EXCEPTION = 1;
    public static final int EXIT_PROGRAM = 2;
    public static final int DEFAULT_BEHAVIOR = 2;
    public static final String IGNORE = "Ignore";
    public static final String PROCEED = "Proceed";
    public static final String EXIT = "Exit";
    public static final String DETAILS = "Details";
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;
    public static final String EXCEPTION_TABLE_INDEX = "*** TABLE INDEX BOUND EXCEPTION ***";
    public static final String ERROR_UNSPECIFIED = "*** UNSPECIFIED RUNTIME ERROR ***";
    public static final String EXCEPTION_UNSPECIFIED = "*** UNSPECIFIED RUNTIME EXCEPTION ***";
    public static final String EXCEPTION_SECURITY = "*** PROGRAM ATTEMPTED TO PERFORM OPERATION FORBIDDEN BY ENVIRONMENT SECURITY ***";
    private static final String PGM = "CobolException";
    private static boolean cobolStackOut = false;
    private static final String SPACES = "                    ";
    private static final String[] SECTION_NAMES = new String[]{"wrk", "WORKING-STORAGE SECTION:", "lcl", "LOCAL-STORAGE SECTION:", "shr", "SHARED-STORAGE SECTION:", "fil", "FILE SECTION:", "scr", "SCREEN SECTION:", "lnk", "LINKAGE SECTION:", "cmn", "COMMUNICATION SECTION:", "rpt", "REPORT SECTION:", "cns", "CONSTANT SECTION:"};

    public static final int abend(String name, String longMessage, Throwable throwable) {
        while (throwable instanceof AbendException) {
            AbendException abendException = (AbendException)throwable;
            if (abendException.hasBeenPresented()) {
                return 1;
            }
            abendException.setPresented(true);
            int defaultBehavior = abendException.getDefaultBehavior();
            if (defaultBehavior >= 0) {
                return defaultBehavior;
            }
            name = abendException.getMessage();
            longMessage = abendException.getLongMessage();
            Throwable tentative = abendException.getAbendException();
            if (throwable == tentative || tentative == null) break;
            throwable = tentative;
        }
        if (Shutdown.performErrorProcedures()) {
            return 0;
        }
        if (throwable instanceof AppletExitException) {
            throw new AppletExitException("Applet cannot STOP RUN or otherwise force termination");
        }
        if (name == null) {
            if (throwable instanceof Error) {
                name = throwable instanceof OutOfMemoryError ? "*** Out Of Memory ***" : ERROR_UNSPECIFIED;
            } else if (throwable instanceof RuntimeException) {
                if (throwable instanceof ArrayIndexOutOfBoundsException) {
                    name = EXCEPTION_TABLE_INDEX;
                } else if (throwable instanceof SecurityException) {
                    name = EXCEPTION_SECURITY;
                } else if (throwable instanceof IPCException) {
                    Throwable nestedException;
                    name = "Error calling program";
                    IPCException ipcException = (IPCException)throwable;
                    String ipcMessage = ipcException.getMessage();
                    if (ipcMessage != null) {
                        if (longMessage == null) {
                            longMessage = ipcMessage;
                        }
                        name = name + ": " + ipcMessage;
                    }
                    if ((nestedException = ipcException.getIPCException()) != null) {
                        throwable = nestedException;
                    }
                } else {
                    name = "*** RUNTIME EXCEPTION " + throwable + " ***";
                }
            } else {
                name = throwable instanceof IOException ? "*** I-O EXCEPTION " + throwable + " ***" : EXCEPTION_UNSPECIFIED;
            }
        }
        return CobolException.internalRuntimeError(name, longMessage, throwable);
    }

    public static final void dumpError(Object program, Throwable t) {
        PrintStream out = System.out;
        CobolException.dumpError(program, out, t, false);
    }

    public static final void dumpError(Object program, Throwable t, boolean dumpError) {
        String abndFileInd;
        PrintStream out = System.out;
        if (RuntimeEnvironment.isEBPEnv() && (abndFileInd = System.getProperty("ABEND-INDICATOR")) != null) {
            File abndFile = new File(abndFileInd);
            try {
                if (!abndFile.exists()) {
                    abndFile.createNewFile();
                }
            }
            catch (IOException err) {
                err.printStackTrace();
            }
        }
        CobolException.dumpError(program, out, t, dumpError);
    }

    public static final void dumpError(Object program, PrintStream out, Throwable t) {
        CobolException.dumpError(program, out, t, false);
    }

    public static final void dumpError(Object program, PrintStream out, Throwable t, boolean symbolDump) {
        AbendException abendException;
        if (t instanceof AbendException && !(abendException = (AbendException)t).hasDump()) {
            return;
        }
        if (t instanceof ExitProgramException || t instanceof SecurityException) {
            return;
        }
        out.println("----");
        out.println("EXCEPTION STACK TRACE");
        out.println("----");
        CobolException.dumpCobolStack(t);
        out.println("JAVA STACK TRACE");
        out.println("----");
        t.printStackTrace(out);
        out.println("");
        out.println("----");
        out.println("PROGRAM INFORMATION");
        out.println("----");
        CobolException.dumpError(0, program, out, symbolDump);
        out.println("");
    }

    public static void dumpCobolStack(Throwable t) {
        if (cobolStackOut) {
            return;
        }
        if (!RuntimeEnvironment.returnExcepToIDE()) {
            cobolStackOut = true;
        }
        StackTraceElement[] stack = t.getStackTrace();
        String lastFileName = "";
        int jline = 0;
        TreeMap<Integer, int[]> lineMap = new TreeMap<Integer, int[]>();
        HashMap<Integer, String[]> fileMap = new HashMap<Integer, String[]>();
        String smapDir = System.getenv("SMAP_DIR");
        String[] dirList = new String[]{};
        for (int i = 0; i < stack.length; ++i) {
            Map.Entry probLine;
            if (stack[i].getClassName().startsWith("com.heirloomcomputing") || stack[i].getClassName().startsWith("java.") || stack[i].getClassName().startsWith("javax.") || stack[i].getClassName().startsWith("com.ibm.") || stack[i].getClassName().startsWith("com.sun.") || stack[i].getClassName().startsWith("org.apache.") || stack[i].getClassName().startsWith("org.aspectj.") || stack[i].getClassName().startsWith("sun.") || stack[i].getClassName().startsWith("sunw.") || stack[i].getMethodName().equals("call") || stack[i].getMethodName().equals("callGiving") || stack[i].getMethodName().equals("run") || stack[i].getMethodName().equals("main") || stack[i].getMethodName().equals("perform")) continue;
            jline = stack[i].getLineNumber();
            if (!lastFileName.equalsIgnoreCase(stack[i].getFileName())) {
                String dirPath;
                lineMap.clear();
                fileMap.clear();
                lastFileName = stack[i].getFileName();
                File f = null;
                InputStream is = CobolException.class.getClassLoader().getResourceAsStream(lastFileName + ".smap");
                if ((smapDir == null || smapDir.isEmpty()) && is == null) {
                    out.println("\n\n----");
                    out.println("COBOL Stack trace unavailable.");
                    out.println("Use 'SMAP_DIR' environment variable to point to SMAP file location or ensure they are on $CLASSPATH.");
                    return;
                }
                if (i == 0 && smapDir != null) {
                    if (File.separatorChar == '/') {
                        smapDir.replace('\\', '/');
                    } else if (File.separatorChar == '\\') {
                        smapDir.replace('/', '\\');
                    }
                    out.println("\n\n----");
                    out.println("COBOL STACK TRACE");
                    out.println("----");
                    dirList = smapDir.split(File.pathSeparator);
                }
                String[] stringArray = dirList;
                int n = stringArray.length;
                for (int j = 0; j < n && (!(f = new File(dirPath = (dirPath = stringArray[j]).endsWith(File.separator) ? dirPath + stack[i].getFileName() + ".smap" : dirPath + File.separatorChar + stack[i].getFileName() + ".smap")).exists() || f.isDirectory()); ++j) {
                    f = null;
                }
                if (f == null && is == null) continue;
                if (f != null && f.exists() && !f.isDirectory() || is != null) {
                    try {
                        BufferedReader br = is == null ? new BufferedReader(new FileReader(f)) : new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        int fnum = 0;
                        int javaLine = 0;
                        int totJavaLines = 0;
                        while ((line = br.readLine()) != null && !line.startsWith("*L")) {
                        }
                        while ((line = br.readLine()) != null && !line.startsWith("*")) {
                            int[] remInfo = new int[3];
                            String splits = line.substring(0, line.indexOf(33));
                            int cobline = Integer.valueOf(splits);
                            if (line.indexOf(35) != -1) {
                                splits = line.substring(line.indexOf(35) + 1, line.indexOf(58));
                                fnum = Integer.valueOf(splits);
                            }
                            totJavaLines = 0;
                            if (line.indexOf(44) != -1) {
                                splits = line.substring(line.indexOf(58) + 1, line.indexOf(44));
                                javaLine = Integer.valueOf(splits);
                                splits = line.substring(line.indexOf(44) + 1, line.lastIndexOf(126));
                                totJavaLines = Integer.valueOf(splits);
                            } else {
                                splits = line.substring(line.indexOf(58) + 1, line.lastIndexOf(126));
                                javaLine = Integer.valueOf(splits);
                            }
                            remInfo[0] = totJavaLines;
                            remInfo[1] = fnum;
                            remInfo[2] = cobline;
                            lineMap.put(javaLine, remInfo);
                        }
                        while ((line = br.readLine()) != null && !line.startsWith("*F")) {
                        }
                        while ((line = br.readLine()) != null) {
                            if (line.startsWith("-")) continue;
                            if (line.startsWith("*")) break;
                            String[] splitarr = line.split(" ");
                            int len = splitarr.length;
                            if (line.startsWith("+")) {
                                line = br.readLine();
                                fileMap.put(Integer.valueOf(splitarr[len - 2]), new String[]{splitarr[len - 1], line});
                                continue;
                            }
                            fileMap.put(Integer.valueOf(splitarr[len - 2]), new String[]{splitarr[len - 1], "./" + splitarr[len - 1]});
                        }
                        br.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((probLine = lineMap.floorEntry(jline)) == null || probLine.getKey() != jline && (jline <= probLine.getKey() || jline > probLine.getKey() + ((int[])probLine.getValue())[0])) continue;
            err.println("==>" + ((String[])fileMap.get(((int[])probLine.getValue())[1]))[0] + "::" + ((int[])probLine.getValue())[2] + "::" + ((String[])fileMap.get(((int[])probLine.getValue())[1]))[1]);
        }
        err.println("----\n");
    }

    private static void dumpError(int indent, PrintStream out, String msg) {
        try {
            out.print(CobolException.spaces(indent));
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.println(msg);
    }

    private static String spaces(int indent) {
        if (indent > SPACES.length()) {
            indent = SPACES.length();
        }
        return SPACES.substring(0, indent);
    }

    private static void dumpError(int indent, Object program, PrintStream out, boolean symbolDump) {
        Field[] fields;
        CobolException.dumpError(indent, out, "Object:");
        ++indent;
        if (program == null) {
            CobolException.dumpError(indent, out, "null");
            return;
        }
        Class<?> klass = program.getClass();
        ClassLoader classLoader = klass.getClassLoader();
        CobolException.dumpError(indent, out, "Class              : " + String.valueOf(klass));
        CobolException.dumpError(indent, out, "Class Loader       : " + String.valueOf(classLoader));
        CobolException.dumpError(indent, out, "Text Representation: " + String.valueOf(program));
        if (symbolDump && (fields = klass.getDeclaredFields()) != null && fields.length >= 1) {
            int sectionNamesLength = SECTION_NAMES.length;
            for (int i = 0; i < fields.length; ++i) {
                Field examine = fields[i];
                String fieldName = examine.getName();
                if (fieldName == null) continue;
                for (int j = 0; j < sectionNamesLength; j += 2) {
                    if (!fieldName.equals(SECTION_NAMES[j])) continue;
                    CobolException.dumpError(indent, out, SECTION_NAMES[j + 1]);
                    try {
                        Object result = examine.get(program);
                        Field[] dataFields = result.getClass().getFields();
                        for (int k = 0; k < dataFields.length; ++k) {
                            CobolException.dumpError(indent + 1, out, dataFields[k], result);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static char toHexChar(int value) {
        if (value >= 0 && value <= 9) {
            return (char)(48 + value);
        }
        if (value >= 10 && value <= 15) {
            return (char)(65 + (value - 10));
        }
        return '0';
    }

    private static void dumpError(int indent, PrintStream out, Field field, Object program) {
        try {
            String fieldName = field.getName();
            if (fieldName == null) {
                return;
            }
            if (fieldName.startsWith("_")) {
                return;
            }
            try {
                int index = -1;
                do {
                    if ((index = fieldName.indexOf("_OF_", index + 1)) < 0) continue;
                    String left = "";
                    String right = "";
                    try {
                        left = fieldName.substring(0, index);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        right = fieldName.substring(index + 4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fieldName = left + " OF " + right;
                    index += 4;
                } while (index >= 0);
            }
            catch (Exception index) {
                // empty catch block
            }
            fieldName = fieldName.replace('_', '-');
            fieldName = fieldName.toUpperCase();
            Object result = field.get(program);
            String fieldValue = null;
            fieldValue = result instanceof IDatatype ? ((IDatatype)result).toText() : String.valueOf(result);
            StringBuffer hexValue = new StringBuffer();
            StringBuffer unicodeValue = new StringBuffer();
            boolean unicode = false;
            char value = '\u0000';
            int j = 0;
            String linesep = "\n";
            try {
                linesep = System.getProperty("line.separator");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                for (int i = 0; i < fieldValue.length(); ++i) {
                    value = fieldValue.charAt(i);
                    if (value > '\u00ff') {
                        unicode = true;
                    }
                    hexValue.append(CobolException.toHexChar(value / 16));
                    hexValue.append(CobolException.toHexChar(value & 0xF));
                    if (++j == 16) {
                        hexValue.append(linesep).append(CobolException.spaces(indent + 2));
                        j = 0;
                        continue;
                    }
                    hexValue.append(' ');
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            try {
                j = 0;
                if (unicode) {
                    for (int i = 0; i < fieldValue.length(); ++i) {
                        value = fieldValue.charAt(i);
                        unicodeValue.append(CobolException.toHexChar(value / 4096 & 0xF));
                        unicodeValue.append(CobolException.toHexChar(value / 256 & 0xF));
                        unicodeValue.append(CobolException.toHexChar(value / 16 & 0xF));
                        unicodeValue.append(CobolException.toHexChar(value & 0xF));
                        if (++j == 8) {
                            unicodeValue.append(linesep).append(CobolException.spaces(indent + 2));
                            j = 0;
                            continue;
                        }
                        unicodeValue.append(' ');
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CobolException.dumpError(indent, out, fieldName + ":");
            CobolException.dumpError(indent + 1, out, "Text Value   :");
            CobolException.dumpError(indent + 2, out, "'" + fieldValue + "'");
            CobolException.dumpError(indent + 1, out, "Hex Value    :");
            CobolException.dumpError(indent + 2, out, hexValue.toString());
            if (unicode) {
                CobolException.dumpError(indent + 1, out, "Unicode Value:");
                CobolException.dumpError(indent + 2, out, unicodeValue.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final int getEnvReturnCode(int rccode) {
        return rccode;
    }

    private static JPanel getErrorPanel(Throwable throwable) {
        JPanel panel = new JPanel(new BorderLayout());
        JTextPane title = new JTextPane();
        title.setEditable(false);
        title.setText("A runtime method invoked by the " + RuntimeEnvironment.getIDEComponentDesc() + " component of the IDE has caused an Exception.\nIt is recommended that the component be restarted. The stacktrace info for the exception is shown below.");
        JTextArea textArea = new JTextArea(5, 20);
        JScrollPane scrollPane = new JScrollPane(textArea, 22, 32);
        textArea.setEditable(false);
        panel.add((Component)title, "North");
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(600, 300));
        if (throwable != null) {
            for (StackTraceElement ste : throwable.getStackTrace()) {
                textArea.append(ste.getClassName() + "::" + ste.getFileName() + "::" + ste.getMethodName() + "::" + ste.getLineNumber() + "\n");
            }
            textArea.setCaretPosition(1);
        }
        return panel;
    }

    public static final void runtimeError(String name, String longMessage, Throwable throwable) {
        if (RuntimeEnvironment.returnExcepToIDE()) {
            err.println("\nCobolException:" + RuntimeEnvironment.getIDEComponentDesc());
            err.println("\n" + name);
            return;
        }
        CobolException.reportDetails(err, throwable, name, longMessage);
        if (RuntimeEnvironment.returnExcepToIDE()) {
            JOptionPane.showMessageDialog(null, CobolException.getErrorPanel(throwable), "RecordEditor:COBOL Runtime Error", 0);
            return;
        }
        if (RuntimeEnvironment.canJVMExit()) {
            if (RuntimeEnvironment.isEBPEnv()) {
                System.exit(CobolException.getEnvReturnCode(32));
            } else {
                System.exit(CobolException.getEnvReturnCode(2));
            }
        }
        Throwable originalException = throwable;
        if (Shutdown.performErrorProcedures()) {
            return;
        }
        if (throwable instanceof AbendException) {
            AbendException abendException;
            Throwable tentative2;
            do {
                if ((abendException = (AbendException)throwable).hasBeenPresented()) {
                    if (originalException instanceof AbendException) {
                        throw (AbendException)originalException;
                    }
                    throw abendException;
                }
                abendException.setPresented(true);
                name = abendException.getMessage();
                longMessage = abendException.getLongMessage();
            } while (throwable != (tentative2 = abendException.getAbendException()) && tentative2 != null && (throwable = tentative2) instanceof AbendException);
            switch (abendException.getDefaultBehavior()) {
                case 0: {
                    return;
                }
                case 2: {
                    try {
                        Shutdown.exit(10);
                    }
                    catch (Exception tentative2) {
                        // empty catch block
                    }
                }
                case 1: {
                    if (originalException instanceof AbendException) {
                        throw (AbendException)originalException;
                    }
                    AbendException presentedException = new AbendException(name, longMessage, abendException, name, false);
                    presentedException.setPresented(true);
                    throw presentedException;
                }
            }
        }
        if (throwable instanceof AppletExitException) {
            throw new AppletExitException("Applet cannot STOP RUN or otherwise force termination");
        }
        if (name == null) {
            if (throwable instanceof Error) {
                name = throwable instanceof OutOfMemoryError ? "*** Out Of Memory ***" : ERROR_UNSPECIFIED;
            } else if (throwable instanceof RuntimeException) {
                if (throwable instanceof ArrayIndexOutOfBoundsException) {
                    name = EXCEPTION_TABLE_INDEX;
                } else if (throwable instanceof SecurityException) {
                    name = EXCEPTION_SECURITY;
                } else if (throwable instanceof IPCException) {
                    Throwable nestedException;
                    name = "Error calling program";
                    IPCException ipcException = (IPCException)throwable;
                    String ipcMessage = ipcException.getMessage();
                    if (ipcMessage != null) {
                        if (longMessage == null) {
                            longMessage = ipcMessage;
                        }
                        name = name + ": " + ipcMessage;
                    }
                    if ((nestedException = ipcException.getIPCException()) != null) {
                        throwable = nestedException;
                    }
                } else {
                    name = "*** RUNTIME EXCEPTION " + throwable + " ***";
                }
            } else {
                name = throwable instanceof IOException ? "*** I-O EXCEPTION " + throwable + " ***" : EXCEPTION_UNSPECIFIED;
            }
        }
        switch (CobolException.internalRuntimeError(name, longMessage, throwable)) {
            case 0: {
                return;
            }
            case 2: {
                try {
                    Shutdown.exit(10);
                }
                catch (Exception ipcException) {
                    // empty catch block
                }
            }
            case 1: {
                if (originalException instanceof AbendException) {
                    throw (AbendException)originalException;
                }
                AbendException presentedException = new AbendException(name, longMessage, throwable, "AUSR", false);
                presentedException.setPresented(true);
                throw presentedException;
            }
        }
    }

    public static final void runtimeError(Throwable throwable) {
        CobolException.runtimeError((String)null, null, throwable);
    }

    public static final void runtimeError(String name) {
        CobolException.runtimeError(name, null, null);
    }

    public static final void runtimeError() {
        CobolException.runtimeError((String)null, null, null);
    }

    public static final void runtimeError(String name, Throwable throwable) {
        CobolException.runtimeError(name, null, throwable);
    }

    public static final int runtimeError(Context context, String name, String longMessage, Throwable throwable) {
        if (context == null) {
            CobolException.runtimeError(name, longMessage, throwable);
            return 0;
        }
        CobolException.reportDetails(err, throwable, name, longMessage);
        Object result = context.abend(name, longMessage, throwable, "PCBL", true, true);
        if (result instanceof Integer) {
            int resultInt = (Integer)result;
            if (resultInt == -1) {
                Shutdown.exit(10);
            }
            return resultInt;
        }
        return 0;
    }

    public static final int runtimeError(Context context, Throwable throwable) {
        return CobolException.runtimeError(context, null, throwable);
    }

    public static final int runtimeError(Context context, String name) {
        return CobolException.runtimeError(context, name, null);
    }

    public static final int runtimeError(Context context) {
        return CobolException.runtimeError(context, null, null);
    }

    public static final int runtimeError(Context context, String name, Throwable throwable) {
        return CobolException.runtimeError(context, name, null, throwable);
    }

    private static void reportDetails(PrintStream out, Throwable throwable, String name, String longMessage) {
        if (RuntimeEnvironment.returnExcepToIDE()) {
            out.println("\nCobolException:" + RuntimeEnvironment.getIDEComponentDesc());
        } else {
            out.println("\nCobolException:");
        }
        if (name != null || longMessage != null) {
            if (name == null) {
                name = "";
            }
            if (longMessage == null) {
                longMessage = "";
            }
            out.println(name + "\n" + longMessage);
        }
        if (throwable == null) {
            throwable = new Throwable();
        }
        CobolException.dumpCobolStack(throwable);
        throwable.printStackTrace(out);
        if (RuntimeEnvironment.canJVMExit() && !RuntimeEnvironment.returnExcepToIDE()) {
            if (CobolBase.$X$_exceptionInfo == null) {
                CobolBase.$X$_exceptionInfo = String.valueOf(CobolBase._debug_getExceptionLine(throwable));
            }
            CobolBase.$X$_exceptionInfo = null;
        }
    }

    public static boolean isDumpRequested(Throwable exception) {
        try {
            if (exception == null) {
                return true;
            }
            if (exception instanceof AbendException) {
                return ((AbendException)exception).hasDump();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return true;
    }

    public static String getDumpMessage(Throwable exception) {
        try {
            if (exception instanceof AbendException) {
                AbendException abendException = (AbendException)exception;
                return abendException.getDumpMessage();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int internalRuntimeError(String name, String longMessage, Throwable throwable) {
        if (!Context.isMainApplication()) {
            return 1;
        }
        if (throwable instanceof AbendException) {
            AbendException abendException = (AbendException)throwable;
            if (abendException.hasBeenPresented()) {
                return 1;
            }
            abendException.setPresented(true);
        }
        String paramCobolException = RuntimeEnvironment.getGlobalParameter("COBOL-EXCEPTION");
        boolean textModeOnly = false;
        if (paramCobolException != null && (paramCobolException = paramCobolException.trim().toUpperCase()).length() > 0) {
            if (paramCobolException.indexOf(68) >= 0) {
                CobolException.reportDetails(out, throwable, name, longMessage);
            }
            char c = paramCobolException.charAt(0);
            switch (c) {
                case 'A': {
                    break;
                }
                case 'I': 
                case 'S': {
                    return 0;
                }
                case 'C': 
                case 'P': {
                    if (!paramCobolException.equalsIgnoreCase("PROMPT")) return 1;
                    break;
                }
                case 'E': 
                case 'X': {
                    return 2;
                }
                case 'T': {
                    textModeOnly = true;
                    break;
                }
            }
        }
        if (!textModeOnly) {
            Class<CobolException> c = CobolException.class;
            // MONITORENTER : com.heirloomcomputing.ecs.exec.CobolException.class
            try {
                CobolExceptionDialog cobolException = new CobolExceptionDialog(name, longMessage, throwable);
                cobolException.setVisible(true);
                int result = cobolException.getResult();
                cobolException.setVisible(false);
                cobolException.dispose();
                // MONITOREXIT : c
                return result;
            }
            catch (Throwable t) {
                textModeOnly = true;
                // MONITOREXIT : c
            }
        }
        if (out == null) {
            return 1;
        }
        out.println("");
        out.println("*** " + name + " ***");
        out.println("");
        String text = null;
        try {
            for (int counter = 0; counter < 16 && (text = Dialog.singleLineOfTextInput("Details, Ignore, Proceed, Exit: ")) != null && text.length() > 0; ++counter) {
                if ((text = text.toUpperCase()).startsWith("I")) return 0;
                if (text.startsWith("S")) {
                    return 0;
                }
                if (text.startsWith("P")) return 1;
                if (text.startsWith("C")) {
                    return 1;
                }
                if (text.startsWith("E")) return 2;
                if (text.startsWith("X")) {
                    return 2;
                }
                if (!text.startsWith("D")) continue;
                CobolException.reportDetails(out, throwable, name, longMessage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CobolException.reportDetails(out, throwable, name, longMessage);
        return 2;
    }

    static class StringBufferOutput
    extends OutputStream {
        private StringBuffer result = new StringBuffer();

        StringBufferOutput() {
        }

        public String toString() {
            return this.result.toString();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.result.append(new String(this.result));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.result.append(new String(b, off, len));
        }

        @Override
        public void write(int b) {
            this.result.append((char)b);
        }
    }

    static class CobolExceptionDialog
    extends Frame
    implements ActionListener,
    WindowListener {
        private Container centerPanel;
        private Button detailsButton;
        private CardLayout cardLayout;
        private TextArea textArea;
        private Button ignoreButton;
        private Button proceedButton;
        private Button exitButton;
        private static final String PANEL_DETAILS_BUTTON = "button";
        private static final String PANEL_TRACE_DISPLAY = "trace";
        private int resultCode = 0;

        CobolExceptionDialog(String name, String longMessage, Throwable throwable) {
            super("COBOL Runtime Exception");
            this.setBackground(SystemColor.control);
            this.setForeground(SystemColor.controlText);
            Panel northPanel = new Panel();
            northPanel.setLayout(new GridLayout(0, 1));
            northPanel.add(new Label(name, 1));
            this.centerPanel = new Panel();
            this.cardLayout = new CardLayout();
            this.centerPanel.setLayout(this.cardLayout);
            Panel detailsButtonPanel = new Panel();
            detailsButtonPanel.setLayout(new FlowLayout(2));
            this.detailsButton = new Button(CobolException.DETAILS);
            detailsButtonPanel.add(this.detailsButton);
            this.centerPanel.add(PANEL_DETAILS_BUTTON, detailsButtonPanel);
            String traceMessage = null;
            if (throwable != null) {
                StringBufferOutput stackTrace = new StringBufferOutput();
                PrintWriter printWriter = new PrintWriter(stackTrace);
                if (longMessage != null) {
                    printWriter.println(longMessage);
                    printWriter.println("");
                }
                throwable.printStackTrace(printWriter);
                printWriter.close();
                traceMessage = stackTrace.toString().trim();
            }
            if ((traceMessage == null || traceMessage.length() == 0) && (traceMessage = longMessage) == null) {
                traceMessage = "No trace information available.";
            }
            if (traceMessage != null) {
                Panel tracePanel = new Panel();
                tracePanel.setLayout(new BorderLayout());
                this.textArea = new TextArea(traceMessage, 5, 60, 1);
                tracePanel.add(this.textArea);
                this.textArea.setEditable(false);
                this.centerPanel.add(PANEL_TRACE_DISPLAY, tracePanel);
            }
            Panel southPanel = new Panel();
            southPanel.setLayout(new FlowLayout(2));
            this.ignoreButton = new Button(CobolException.IGNORE);
            southPanel.add(this.ignoreButton);
            this.proceedButton = new Button(CobolException.PROCEED);
            southPanel.add(this.proceedButton);
            this.exitButton = new Button("Exit Program");
            southPanel.add(this.exitButton);
            this.ignoreButton.addActionListener(this);
            this.proceedButton.addActionListener(this);
            this.exitButton.addActionListener(this);
            this.detailsButton.addActionListener(this);
            this.cardLayout.show(this.centerPanel, PANEL_DETAILS_BUTTON);
            this.setLayout(new BorderLayout());
            this.add("North", northPanel);
            this.add("Center", this.centerPanel);
            this.add("South", southPanel);
            this.addWindowListener(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.pack();
            this.center();
        }

        public void center() {
            Dimension ourSize = this.getSize();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - ourSize.width) / 2, (screenSize.height - ourSize.height) / 2);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this.detailsButton) {
                this.cardLayout.show(this.centerPanel, PANEL_TRACE_DISPLAY);
            } else if (source == this.ignoreButton) {
                this.setResult(0);
            } else if (source == this.proceedButton) {
                this.setResult(1);
            } else if (source == this.exitButton) {
                this.setResult(2);
            }
        }

        @Override
        public void windowClosing(WindowEvent event) {
            this.setResult(2);
        }

        @Override
        public void windowActivated(WindowEvent event) {
        }

        @Override
        public void windowClosed(WindowEvent event) {
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
        }

        @Override
        public void windowDeiconified(WindowEvent event) {
        }

        @Override
        public void windowIconified(WindowEvent event) {
        }

        @Override
        public void windowOpened(WindowEvent event) {
        }

        final synchronized void setResult(int result) {
            try {
                this.resultCode = result;
            }
            catch (Exception e) {
                this.resultCode = -1;
            }
            this.notify();
        }

        final synchronized int getResult() {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return -1;
            }
            return this.resultCode;
        }
    }
}

