/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LNF;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class CobolTable
extends JTable {
    public static final String[] blankTitle;
    private int cacheColumns;
    private int cacheRows;
    private RowHeader mRowHeaders;
    private Variable data;
    private JScrollPane scrollPane;
    private int populateColumn;
    private int populateRow;

    public CobolTable(Object[][] data, Object[] cols, Object[] rows) {
        super(data, cols);
        if (rows != null) {
            this.mRowHeaders = new RowHeader(this, rows);
        }
        this.setCellSelectionEnabled(true);
        this.setAutoResizeMode(0);
        this.cacheColumns = cols.length;
        this.cacheRows = rows.length;
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void setReorderingAllowed(boolean state) {
        this.getTableHeader().setReorderingAllowed(state);
    }

    public void setData(Variable value) {
        this.data = value;
    }

    public RowHeader getRowHeaders() {
        return this.mRowHeaders;
    }

    public static Component createScrollPaneForTable(CobolTable table) {
        if (table.mRowHeaders != null) {
            RowHeader rowHeaders = table.getRowHeaders();
            try {
                table.scrollPane = new JScrollPane(table);
            }
            catch (Throwable t) {
                table.scrollPane = new JScrollPane(table);
            }
            JViewport view = new JViewport();
            view.add(rowHeaders);
            Dimension rd = rowHeaders.getPreferredSize();
            view.setPreferredSize(rd);
            table.scrollPane.setRowHeader(view);
            Dimension td = table.getPreferredSize();
            td.width += rd.width + 12;
            td.height += 24;
            table.scrollPane.setPreferredSize(td);
            return table.scrollPane;
        }
        return new JScrollPane(table);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            Variable item = this.data.subscript(row + 1, column + 1);
            item.move(String.valueOf(value));
            value = item.toDisplayString();
            super.setValueAt(value, row, column);
            item.releaseSubscript();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setUsingData() {
        if (this.data == null) {
            return;
        }
        try {
            int cols = this.cacheColumns;
            int rows = this.cacheRows;
            int c = 0;
            int r = 0;
            Variable element = null;
            for (c = 0; c < cols; ++c) {
                for (r = 0; r < rows; ++r) {
                    element = this.data.subscript(r + 1, c + 1);
                    this.setValueAt(element.toDisplayString(), r, c);
                    element.releaseSubscript();
                }
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getPopulateColumn() {
        return this.populateColumn + 1;
    }

    public int getPopulateRow() {
        return this.populateRow + 1;
    }

    public void setPopulateColumn(int c) {
        this.populateColumn = c - 1;
    }

    public void setPopulateRow(int r) {
        this.populateRow = r - 1;
    }

    public void setPopulateData(String s) {
        this.setValueAt(s, this.populateRow, this.populateColumn);
        this.repaint();
    }

    public String getPopulateData() {
        try {
            return this.getValueAt(this.populateRow, this.populateColumn).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        LNF.setNativeLookAndFeel();
        blankTitle = new String[]{" "};
    }

    private class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            Font myFont = this.getFont();
            if ((myFont.getStyle() & 1) != 0) {
                myFont = new Font(myFont.getName(), myFont.getStyle() & 0xFFFFFFFE, myFont.getSize());
                this.setFont(myFont);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class RowHeader
    extends JTable
    implements ListSelectionListener {
        private JTable mParentTable;

        public RowHeader(JTable parentTable, Object[] rows) {
            super(new Object[parentTable.getRowCount()][1], blankTitle);
            this.mParentTable = parentTable;
            int maxWidth = 0;
            Font defaultFont = this.getFont();
            FontMetrics fm = Utils.getFontMetrics(defaultFont);
            for (int i = 0; i < this.mParentTable.getRowCount() && i < rows.length; ++i) {
                this.setValueAt(rows[i], i, 0);
                String s = String.valueOf(rows[i]);
                int width = fm.stringWidth(s);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            ButtonRenderer rend = new ButtonRenderer();
            TableColumn col = this.getColumnModel().getColumn(0);
            col.setCellRenderer(rend);
            Dimension dim = this.getPreferredSize();
            dim.width = maxWidth + 40;
            this.setPreferredSize(dim);
            this.getSelectionModel().addListSelectionListener(this);
            this.setBackground(SystemColor.control);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            try {
                this.mParentTable.clearSelection();
                int[] rows = this.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    this.mParentTable.addRowSelectionInterval(rows[i], rows[i]);
                }
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

