/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Numeric;

public class Comp1MVS
extends Comp1 {
    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.Comp1MVS";
    }

    @Override
    public final String getUsage() {
        return "Comp1MVS";
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            this.flushToMemory();
            this.floatValue = this.pointerMemory.getFloat370(this.pointerAddress);
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-1-MVS retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            this.pointerMemory.setFloat370(this.pointerAddress, this.floatValue);
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-1-MVS storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public int getType() {
        return this.getBasicType(880);
    }

    @Override
    public final int compare(Numeric param) {
        this.updateFromMemory(false);
        float paramn = param.toFloat();
        int parami = Float.floatToIntBits(paramn);
        parami = ConvertData.f370toIEEE(ConvertData.fIEEEto370(parami));
        paramn = Float.intBitsToFloat(parami);
        if (this.floatValue < paramn) {
            return -1;
        }
        if (this.floatValue > paramn) {
            return 1;
        }
        return 0;
    }

    @Override
    public void initData() {
        this.pointerMemory.setFloat370(this.pointerAddress, 0.0f);
    }
}

