/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class CompS
extends BignumType
implements Cloneable,
comparableByteArray {
    private static boolean displayInternal = false;
    private static final Bignum LOWEST;
    private static final Bignum HIGHEST;

    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.CompS";
    }

    @Override
    public final String getUsage() {
        return "CompS";
    }

    @Override
    public int getStorageClass() {
        return 4;
    }

    @Override
    public final Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.parent;
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            odo = odo.parent;
            while (odo != null) {
                odo.itemSize += (difference *= odo.maxIndex);
                odo = odo.parent;
            }
        }
        return this;
    }

    public CompS() {
        this.itemSize = 2;
    }

    @Override
    public int getUsageNumber() {
        return 34;
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            Bignum storeValue = this.value;
            long temp = storeValue.longValue();
            this.pointerMemory.setShort(this.pointerAddress, (short)temp);
            return;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-S storage of " + this.getQualifiedCobolName(), (Throwable)e);
            return;
        }
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            this.value = new Bignum(this.pointerMemory.getShort(this.pointerAddress));
            this.numericString = null;
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in COMP-S retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final String toNumericString() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        if (this.numericString != null) {
            return this.numericString;
        }
        if (this.alwaysFlush) {
            return this.value.toString();
        }
        this.numericString = this.value.toString();
        return this.numericString;
    }

    @Override
    public final boolean isAlphabetic() {
        return false;
    }

    @Override
    public final boolean isAlphabeticUpper() {
        return false;
    }

    @Override
    public final boolean isAlphabeticLower() {
        return false;
    }

    @Override
    public boolean isNumeric(ZonedDescription zonedDescription) {
        return true;
    }

    @Override
    public final String toDisplayString() {
        if (displayInternal) {
            return this.toString();
        }
        return super.toDisplayString();
    }

    @Override
    public final String toInspectString() {
        return this.toDisplayString();
    }

    @Override
    public final int getAcceptSize() {
        int result = 5;
        if (this.signPosition != 0) {
            ++result;
        }
        return result;
    }

    @Override
    public final void calcStoreSize() {
        this.storeSize = 5;
    }

    @Override
    protected void truncate() {
        if (this.value.compareTo(HIGHEST) > 0) {
            this.value = new Bignum(HIGHEST);
            return;
        }
        if (this.value.compareTo(LOWEST) < 0) {
            this.value = new Bignum(LOWEST);
            return;
        }
    }

    @Override
    protected void truncateSE() {
        if (this.value.compareTo(HIGHEST) > 0) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (this.value.compareTo(LOWEST) < 0) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
    }

    @Override
    protected void roundSE() {
        if (this.value.compareTo(HIGHEST) > 0) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
        if (this.value.compareTo(LOWEST) < 0) {
            this.setSizeError();
            this.value.make(this.safeValue);
            return;
        }
    }

    @Override
    public int getArgumentType() {
        return this.signPosition == 0 ? 12 : 11;
    }

    @Override
    public byte[] getArgument() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        return ConvertData.nativeLongToGivenBytes(this.value.longValue(), this.length());
    }

    @Override
    public Object getObjectParameter() {
        return new Short(this.toShort());
    }

    @Override
    public void setArgument(byte[] data) {
        this.setDirtyNoFill();
        this.value.make(ConvertData.nativeBytesToLong(data));
        this.updateToMemory();
    }

    @Override
    public int getType() {
        return this.getBasicType(304);
    }

    static {
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.s");
        if (displaytype != null && displaytype.length() > 0 && (displaytype = displaytype.toUpperCase()).charAt(0) == 'I') {
            displayInternal = true;
        }
        LOWEST = new Bignum(Short.MIN_VALUE);
        HIGHEST = new Bignum(Short.MAX_VALUE);
    }
}

