/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.PopupDialog;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.term.Utilities;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Dialog {
    public static boolean showYesNoDialog(String title, String text) {
        try {
            PopupDialog popup = new PopupDialog(title, text, "YN");
            popup.setCentered(true);
            popup.setVisible(true);
            int result = popup.getResult();
            return result == 0;
        }
        catch (Throwable t) {
            System.out.println("");
            System.out.println("*** " + title + " ***");
            System.out.println("");
            System.out.println(text);
            System.out.println("");
            do {
                if ((text = Dialog.singleLineOfTextInput("Please enter Yes or No: ")) == null) {
                    text = "";
                }
                if (!(text = text.toUpperCase()).startsWith("N")) continue;
                return false;
            } while (!text.startsWith("Y"));
            return true;
        }
    }

    public static int showYesNoCancelDialog(String title, String text) {
        try {
            PopupDialog popup = new PopupDialog(title, text, "YNC");
            popup.setCentered(true);
            popup.setVisible(true);
            int result = popup.getResult();
            return 2 - result;
        }
        catch (Throwable t) {
            System.out.println("");
            System.out.println("*** " + title + " ***");
            System.out.println("");
            System.out.println(text);
            System.out.println("");
            do {
                if ((text = Dialog.singleLineOfTextInput("Please enter Yes, No, or Cancel: ")) == null) {
                    text = "";
                }
                if ((text = text.toUpperCase()).startsWith("C")) {
                    return 0;
                }
                if (!text.startsWith("N")) continue;
                return 1;
            } while (!text.startsWith("Y"));
            return 2;
        }
    }

    public static void showInformationDialog(String title, String text) {
        try {
            PopupDialog popup = new PopupDialog(title, text, "O");
            popup.setCentered(true);
            popup.setVisible(true);
            popup.getResult();
        }
        catch (Throwable t) {
            System.out.println("");
            System.out.println("*** " + title + " ***");
            System.out.println("");
            System.out.println(text);
            System.out.println("");
            Dialog.singleLineOfTextInput(ResourceManager.get("dialog.enter_to_continue", "Press Enter to continue: "));
        }
    }

    public static String showInputDialog(String title, String text, int columns, boolean secure) {
        try {
            String mode = "OCI";
            if (secure) {
                mode = mode + "*";
            }
            PopupDialog popup = new PopupDialog(title, text, mode, columns);
            popup.setCentered(true);
            popup.setVisible(true);
            int result = popup.getResult();
            if (result != 0 && result != 2) {
                return null;
            }
            return popup.getResultFieldString();
        }
        catch (Throwable t) {
            System.out.println("");
            System.out.println("*** " + title + " ***");
            System.out.println("");
            System.out.println(text);
            System.out.println("");
            return Dialog.singleLineOfTextInput(ResourceManager.get("dialog.enter_information", "Enter information: "));
        }
    }

    public static String singleLineOfTextInput(String prompt) {
        String text = null;
        try {
            try {
                System.out.print(prompt);
                System.out.flush();
            }
            catch (Throwable t2) {
                System.out.println("");
            }
            BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
            text = d.readLine();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return text;
    }

    public static String acceptStdin() {
        return Utilities.acceptStdin();
    }
}

