/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ICobolInterface;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import java.util.Vector;

public class Dispatcher
implements Runnable {
    private final Vector<ICobolInterface> queuePrograms = new Vector();
    private final Vector<Integer> queueTargets = new Vector();
    private int queueSize;
    private Thread thread;

    public Dispatcher() {
        this(10);
    }

    public Dispatcher(int queueSize) {
        this.queueSize = queueSize;
    }

    private boolean initializeThreading() {
        if (this.thread != null) {
            return true;
        }
        try {
            this.thread = new ThreadQueue(this);
            try {
                this.thread.setDaemon(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.thread.start();
        }
        catch (Throwable t) {
            this.thread = null;
            return false;
        }
        return true;
    }

    public void dispatch(ICobolInterface program, int target) {
        this.dispatch(program, target, this.queueSize);
    }

    public void dispatch(ICobolInterface program, int target, int type) {
        this.dispatch(program, new Integer(target), type);
    }

    public void dispatch(ICobolInterface program, Integer target) {
        this.dispatch(program, target, this.queueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(ICobolInterface program, Integer target, int type) {
        switch (type) {
            case -1: {
                try {
                    int targetParagraph = target;
                    program.perform(targetParagraph, targetParagraph);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
        }
        if (type <= 0) {
            type = 10;
        }
        if (!this.initializeThreading()) {
            return;
        }
        if (type < 10000 && this.queuePrograms.size() >= type) {
            return;
        }
        this.queueTargets.addElement(target);
        this.queuePrograms.addElement(program);
        Vector<ICobolInterface> vector = this.queuePrograms;
        synchronized (vector) {
            this.queuePrograms.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Vector<ICobolInterface> vector = this.queuePrograms;
                    synchronized (vector) {
                        while (this.queuePrograms.size() == 0) {
                            this.queuePrograms.wait();
                        }
                        ICobolInterface program = this.queuePrograms.elementAt(0);
                        Integer target = this.queueTargets.elementAt(0);
                        this.queuePrograms.removeElementAt(0);
                        this.queueTargets.removeElementAt(0);
                        try {
                            int targetParagraph = target;
                            program.perform(targetParagraph, targetParagraph);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

