/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public final class DisplayH
extends BignumType
implements Cloneable,
comparableByteArray {
    private static final long serialVersionUID = 1L;
    private static Boolean displayInternal = null;
    public static final String positiveDigits = "{ABCDEFGHI";
    public static final String unsignedDigits = "0123456789";
    public static final String negativeDigits = "}JKLMNOPQR";
    public static final String packedSigns = "\f\u001c\u001d\u001f,-/<=?LMO\\]_lmo|}\u007f\u008c\u008d\u008f\u009c\u009d\u009f\u00c0\u00c1\u00d1\u00f1\u00c2\u00d2\u00f2\u00c3\u00d3\u00f3\u00c4\u00d4\u00f4\u00c5\u00d5\u00f5\u00c6\u00d6\u00f6\u00c7\u00d7\u00f7\u00c8\u00d8\u00f8\u00c9\u00d9\u00f9";
    public static final char positiveChar = '+';
    public static final char negativeChar = '-';
    public static final char decimalChar = '.';
    public static final byte positiveByte = 43;
    public static final byte negativeByte = 45;
    public static final byte decimalByte = 46;
    public static final char[] positiveArray = new char[10];
    public static final char[] unsignedArray = new char[10];
    public static final char[] negativeArray = new char[10];
    public static final byte[] positiveByteArray = new byte[10];
    public static final byte[] unsignedByteArray = new byte[10];
    public static final byte[] negativeByteArray = new byte[10];
    private static final char[] indexPositive = new char[256];
    private static final char[] indexNegative = new char[256];
    private static ZonedDescription zonedDescription;

    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.DisplayH";
    }

    @Override
    public final String getUsage() {
        return "DisplayH";
    }

    private static boolean displayInternal() {
        if (displayInternal != null) {
            return displayInternal;
        }
        String displaytype = RuntimeEnvironment.getGlobalParameter("display.0");
        if (displaytype != null) {
            if (displaytype.length() > 0) {
                switch (displaytype.charAt(0)) {
                    case 'I': 
                    case 'i': {
                        displayInternal = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        displayInternal = false;
                    }
                }
            } else {
                displayInternal = true;
            }
        } else {
            displayInternal = true;
        }
        return displayInternal;
    }

    private static void setDatatype() {
        int i;
        int length = positiveDigits.length();
        for (i = 0; i < length; ++i) {
            DisplayH.indexPositive[positiveDigits.charAt((int)i)] = (char)(i + 48);
            DisplayH.positiveArray[i] = positiveDigits.charAt(i);
            DisplayH.positiveByteArray[i] = (byte)positiveDigits.charAt(i);
        }
        length = unsignedDigits.length();
        for (i = 0; i < length; ++i) {
            DisplayH.indexPositive[unsignedDigits.charAt((int)i)] = (char)(i + 48);
            DisplayH.unsignedArray[i] = unsignedDigits.charAt(i);
            DisplayH.unsignedByteArray[i] = (byte)unsignedDigits.charAt(i);
        }
        length = negativeDigits.length();
        for (i = 0; i < length; ++i) {
            DisplayH.indexNegative[negativeDigits.charAt((int)i)] = (char)(i + 48);
            DisplayH.negativeArray[i] = negativeDigits.charAt(i);
            DisplayH.negativeByteArray[i] = (byte)negativeDigits.charAt(i);
        }
    }

    public static final ZonedDescription getZonedDescription() {
        if (zonedDescription != null) {
            return zonedDescription;
        }
        zonedDescription = new ZonedDescription(){

            @Override
            public String getPositiveDigits() {
                return DisplayH.positiveDigits;
            }

            @Override
            public String getUnsignedDigits() {
                return DisplayH.unsignedDigits;
            }

            @Override
            public String getNegativeDigits() {
                return DisplayH.negativeDigits;
            }

            @Override
            public String getPackedSigns() {
                return DisplayH.packedSigns;
            }

            @Override
            public char getPositiveChar() {
                return '+';
            }

            @Override
            public char getNegativeChar() {
                return '-';
            }

            @Override
            public char getDecimalChar() {
                return '.';
            }
        };
        return zonedDescription;
    }

    @Override
    public ZonedDescription getZonedDescriptionInstance() {
        return DisplayH.getZonedDescription();
    }

    @Override
    public final Numeric odoNumeric() {
        Variable odo = this.findOdo();
        if (odo != null) {
            int newSize = odo.itemSize * odo.occurs();
            odo = odo.parent;
            int difference = newSize - odo.itemSize;
            odo.itemSize = newSize;
            odo = odo.parent;
            while (odo != null) {
                odo.itemSize += (difference *= odo.maxIndex);
                odo = odo.parent;
            }
        }
        return this;
    }

    public DisplayH() {
    }

    public DisplayH(String setPic, String setValue) {
        super(setPic, setValue);
        this.calcStoreSize();
    }

    public DisplayH(int itemSize, byte place, byte scale, byte signPosition) {
        this.itemSize = itemSize;
        this.place = place;
        this.scale = scale;
        this.picLength = itemSize;
        this.signPosition = signPosition;
        this.pointerMemory = new Memory(itemSize, new String[0]);
        this.pointerAddress = 0;
        this.calcStoreSize();
    }

    public DisplayH(int param) {
        this((long)param);
    }

    public DisplayH(long param) {
        this.itemSize = 18;
        this.place = 0;
        this.maxIndex = 1;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        this.signPosition = (byte)3;
        this.picLength = this.itemSize;
        this.calcStoreSize();
        this.move(param);
    }

    public DisplayH(String param) {
        int i;
        this.itemSize = 18;
        this.place = (byte)9;
        this.maxIndex = 1;
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        this.signPosition = (byte)3;
        this.picLength = this.itemSize;
        char c = this.getDecimal();
        if (c != '.' && (i = param.indexOf(46)) >= 0) {
            param = i == 0 ? c + param.substring(1) : (i == param.length() - 1 ? param.substring(0, param.length() - 1) + c : param.substring(0, i) + c + param.substring(i + 1));
        }
        this.calcStoreSize();
        this.move(param);
    }

    @Override
    public int getUsageNumber() {
        return 0;
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            this.numericString = null;
            int address = this.pointerAddress;
            this.value = new Bignum(this.pointerMemory, address, this.length(), (int)this.place, (int)this.scale, Bignum.InternalRep.DisplayH);
            if (this.value.isiAmNotNumeric()) {
                this.dirty = false;
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in DISPLAY-H retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            if (this.value.fitsInLong()) {
                byte bignumPlace = this.scale > 0 && this.place == 0 ? this.scale : this.place;
                long result = this.value.getLong(bignumPlace);
                int beginAddress = this.pointerAddress;
                int endAddress = beginAddress + this.length(this.pointerMemory.getTopOfMemory() - beginAddress);
                boolean negative = false;
                if (result < 0L) {
                    negative = true;
                    result = -result;
                }
                switch (this.signPosition) {
                    case 4: {
                        this.pointerMemory.setByte(beginAddress++, negative ? (byte)45 : 43);
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setByte(--endAddress, (byte)(48 + (int)(result % 10L)));
                            result /= 10L;
                        }
                        break;
                    }
                    case 5: {
                        this.pointerMemory.setByte(--endAddress, negative ? (byte)45 : 43);
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setByte(--endAddress, (byte)(48 + (int)(result % 10L)));
                            result /= 10L;
                        }
                        break;
                    }
                    case 2: {
                        ++beginAddress;
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setByte(--endAddress, (byte)(48 + (int)(result % 10L)));
                            result /= 10L;
                        }
                        this.pointerMemory.setByte(--beginAddress, negative ? negativeByteArray[(int)(result % 10L)] : positiveByteArray[(int)(result % 10L)]);
                        break;
                    }
                    case 3: {
                        this.pointerMemory.setByte(--endAddress, negative ? negativeByteArray[(int)(result % 10L)] : positiveByteArray[(int)(result % 10L)]);
                        result /= 10L;
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setByte(--endAddress, (byte)(48 + (int)(result % 10L)));
                            result /= 10L;
                        }
                        break;
                    }
                    case 0: {
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setByte(--endAddress, (byte)(48 + (int)(result % 10L)));
                            result /= 10L;
                        }
                        break;
                    }
                }
            } else {
                int l;
                boolean negative;
                int beginAddress = this.pointerAddress;
                String str = this.value.toString();
                boolean bl = negative = str.charAt(0) == '-';
                if (negative) {
                    str = str.substring(1);
                }
                int len = str.length();
                for (l = len - 1; l >= 0 && str.charAt(l) != '.'; --l) {
                }
                if (l > 0) {
                    str = str.substring(0, l) + str.substring(l + 1);
                    --len;
                } else if (l == 0) {
                    str = str.substring(1);
                    --len;
                }
                int endAddress = beginAddress + this.length(this.pointerMemory.getTopOfMemory() - beginAddress);
                switch (this.signPosition) {
                    case 4: {
                        this.pointerMemory.setByte(beginAddress++, negative ? (byte)45 : 43);
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setChar(--endAddress, len > 0 ? str.charAt(--len) : (char)'0');
                        }
                        break;
                    }
                    case 5: {
                        this.pointerMemory.setByte(--endAddress, negative ? (byte)45 : 43);
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setChar(--endAddress, len > 0 ? str.charAt(--len) : (char)'0');
                        }
                        break;
                    }
                    case 2: {
                        ++beginAddress;
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setChar(--endAddress, len > 0 ? str.charAt(--len) : (char)'0');
                        }
                        this.pointerMemory.setByte(--beginAddress, negative ? negativeByteArray[len > 0 ? str.charAt(--len) - 48 : 0] : positiveByteArray[len > 0 ? str.charAt(--len) - 48 : 0]);
                        break;
                    }
                    case 3: {
                        this.pointerMemory.setByte(--endAddress, negative ? negativeByteArray[len > 0 ? str.charAt(--len) - 48 : 0] : positiveByteArray[len > 0 ? str.charAt(--len) - 48 : 0]);
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setChar(--endAddress, len > 0 ? str.charAt(--len) : (char)'0');
                        }
                        break;
                    }
                    case 0: {
                        while (endAddress > beginAddress) {
                            this.pointerMemory.setChar(--endAddress, len > 0 ? str.charAt(--len) : (char)'0');
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in DISPLAY-H retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final String toNumericString() {
        String result;
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        if (this.numericString != null) {
            return this.numericString;
        }
        int desiredLength = this.length();
        if (this.signPosition == 4 || this.signPosition == 5) {
            --desiredLength;
        }
        if ((result = this.value.toString()).charAt(0) == '-') {
            int insertLength;
            if ((insertLength = ++desiredLength - result.length()) > 0) {
                char[] resultBuffer = new char[desiredLength];
                resultBuffer[0] = 45;
                int length = result.length();
                for (int i = 1; i <= insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(1, length, resultBuffer, insertLength + 1);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                this.numericString = new String(resultBuffer);
                return this.numericString;
            }
        } else {
            int insertLength = desiredLength - result.length();
            if (insertLength > 0) {
                int length = result.length();
                char[] resultBuffer = new char[desiredLength];
                for (int i = 0; i < insertLength; ++i) {
                    resultBuffer[i] = 48;
                }
                result.getChars(0, length, resultBuffer, insertLength);
                if (this.alwaysFlush) {
                    return new String(resultBuffer);
                }
                this.numericString = new String(resultBuffer);
                return this.numericString;
            }
        }
        this.numericString = result;
        return this.numericString;
    }

    @Override
    public final String toDisplayString() {
        if (DisplayH.displayInternal()) {
            return this.toString();
        }
        if (this.place <= 0 && (this.signPosition == 0 || this.signPosition == 4 || this.signPosition == 5)) {
            return this.toString();
        }
        return super.toDisplayString();
    }

    @Override
    public final String toInspectString() {
        if (!this.dirty) {
            this.updateFromMemory(false);
        }
        return this.value.toString();
    }

    @Override
    public final int getAcceptSize() {
        int result = this.length();
        if (this.signPosition == 2 || this.signPosition == 3) {
            ++result;
        }
        if (this.place > 0) {
            ++result;
        }
        return result;
    }

    @Override
    public final void calcStoreSize() {
        this.storeSize = this.signPosition == 4 || this.signPosition == 5 ? this.length() - 1 : this.length();
    }

    @Override
    public int getArgumentType() {
        switch (this.signPosition) {
            case 0: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public int relativeKeyLength() {
        return this.length();
    }

    @Override
    public int getType() {
        return this.getBasicType(400);
    }

    @Override
    public void initData() {
        for (int i = 0; i < this.length(); ++i) {
            this.setChar(i, '0');
        }
    }

    static {
        DisplayH.setDatatype();
    }
}

