/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import sun.misc.Unsafe;

public class ExternalUnbufferedMemory
extends Memory {
    private long memoryPointer;
    private int memorySize;
    private transient Unsafe theUnsafe = ExternalUnbufferedMemory.getUnsafe();

    public ExternalUnbufferedMemory() {
        this.alwaysFlush = true;
        this.memorySize = 0;
        this.memoryPointer = 0;
    }

    public ExternalUnbufferedMemory(int setAvailableMemory) {
        super(0, new String[0]);
        this.alwaysFlush = true;
        this.memorySize = setAvailableMemory;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, (byte)0);
    }

    public ExternalUnbufferedMemory(int setAvailableMemory, byte init) {
        super(0, new String[0]);
        this.alwaysFlush = true;
        this.memorySize = setAvailableMemory;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, init);
    }

    public ExternalUnbufferedMemory(int setAvailableMemory, String dataSectionName) {
        super(0, dataSectionName);
        this.alwaysFlush = true;
        this.memorySize = setAvailableMemory;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, (byte)0);
    }

    public ExternalUnbufferedMemory(byte[] data) {
        super(0, new String[0]);
        this.alwaysFlush = true;
        this.memorySize = data.length;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.copy(data, 0, 0, this.memorySize);
    }

    public ExternalUnbufferedMemory(boolean decimalIsComma) {
        super(decimalIsComma);
        this.alwaysFlush = true;
        this.memorySize = 0;
        this.memoryPointer = 0;
    }

    public ExternalUnbufferedMemory(int setAvailableMemory, boolean decimalIsComma) {
        super(0, decimalIsComma);
        this.alwaysFlush = true;
        this.memorySize = setAvailableMemory;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, (byte)0);
    }

    public ExternalUnbufferedMemory(int setAvailableMemory, String programName, boolean decimalIsComma) {
        super(0, programName, decimalIsComma);
        this.alwaysFlush = true;
        this.memorySize = setAvailableMemory;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, (byte)0);
    }

    public ExternalUnbufferedMemory(byte[] data, boolean decimalIsComma) {
        super(0, decimalIsComma);
        this.alwaysFlush = true;
        this.memorySize = data.length;
        this.memoryPointer = this.theUnsafe.allocateMemory(this.memorySize);
        this.copy(data, 0, 0, this.memorySize);
    }

    @Override
    public void Destructor() {
        if (this.memoryPointer != 0L) {
            this.theUnsafe.freeMemory(this.memoryPointer);
            this.memorySize = 0;
            this.memoryPointer = 0;
        }
    }

    @Override
    public int getTopOfMemory() {
        return this.memorySize;
    }

    @Override
    public void pad(int from, int size) {
        while (size-- > 0) {
            this.theUnsafe.putByte(this.memoryPointer + (long)from++, Variable.SPACE_BYTE);
        }
    }

    @Override
    public void copy(int from, byte[] toArray, int to, int size) {
        while (size-- > 0) {
            toArray[to++] = this.theUnsafe.getByte(this.memoryPointer + (long)from++);
        }
    }

    @Override
    public void copy(int from, Memory toMemory, int to, int size) {
        while (size-- > 0) {
            toMemory.setByte(to++, this.theUnsafe.getByte(this.memoryPointer + (long)from++));
        }
    }

    @Override
    public void copy(byte[] fromArray, int from, int to, int size) {
        while (size-- > 0) {
            this.theUnsafe.putByte(this.memoryPointer + (long)to++, fromArray[from++]);
        }
    }

    @Override
    public void copy(Memory fromMemory, int from, int to, int size) {
        while (size-- > 0) {
            this.theUnsafe.putByte(this.memoryPointer + (long)to++, fromMemory.getByte(from++));
        }
    }

    @Override
    public void copy(int from, int to, int size) {
        int topOfMemory = this.memorySize;
        if (from + size > topOfMemory) {
            size = topOfMemory - from;
        }
        if (to + size > topOfMemory) {
            size = topOfMemory - to;
        }
        while (size-- > 0) {
            this.theUnsafe.putByte(this.memoryPointer + (long)to++, this.theUnsafe.getByte(this.memoryPointer + (long)from++));
        }
    }

    @Override
    public byte[] getBytes(int addr, int len) {
        byte[] b = new byte[len];
        this.copy(addr, b, 0, len);
        return b;
    }

    @Override
    public String toString() {
        if (this.programName != null) {
            return "ExternalUnbufferedMemory (" + this.programName + ": " + System.identityHashCode(this) + ")";
        }
        return "ExternalUnbufferedMemory (" + System.identityHashCode(this) + ")";
    }

    @Override
    public String toString(int addr, int len, String enc) throws UnsupportedEncodingException {
        byte[] b = new byte[len];
        this.copy(addr, b, 0, len);
        return new String(b, addr, len, enc);
    }

    @Override
    public String toString(int addr, int len, Charset enc) {
        byte[] b = new byte[len];
        this.copy(addr, b, 0, len);
        return new String(b, addr, len, enc);
    }

    @Override
    public void set(int address, int size, byte b) {
        this.theUnsafe.setMemory(this.memoryPointer + (long)address, size, b);
    }

    @Override
    public void fill(char c) {
        byte b = (byte)c;
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, b);
    }

    @Override
    public void fill(byte b) {
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, b);
    }

    @Override
    public void fillZero() {
        byte b = 0;
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, b);
    }

    @Override
    public void fillSpace() {
        byte b = Variable.SPACE_BYTE;
        this.theUnsafe.setMemory(this.memoryPointer, this.memorySize, b);
    }

    @Override
    public byte getByte(int n) {
        return this.theUnsafe.getByte(this.memoryPointer + (long)n);
    }

    @Override
    public byte getByteReverse(int n) {
        return this.theUnsafe.getByte(this.memoryPointer + (long)n);
    }

    @Override
    public char getChar(int n) {
        return (char)(this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF);
    }

    @Override
    public char getCharReverse(int n) {
        return (char)(this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF);
    }

    @Override
    public short getShort(int n) {
        return (short)((this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF) << 8 | this.theUnsafe.getByte(this.memoryPointer + (long)n + 1L) & 0xFF);
    }

    @Override
    public short getShortReverse(int n) {
        return (short)((this.theUnsafe.getByte(this.memoryPointer + (long)n + 1L) & 0xFF) << 8 | this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF);
    }

    @Override
    public long getData(int addr, int size) {
        long value = 0L;
        byte piece = 0;
        if ((this.theUnsafe.getByte(this.memoryPointer + (long)addr) & 0x80) == 128) {
            long signmask = -1L;
            for (int i = 0; i < size; ++i) {
                piece = this.theUnsafe.getByte(this.memoryPointer + (long)addr + (long)i);
                value <<= 8;
                value |= (long)(piece & 0xFF);
                signmask <<= 8;
            }
            value |= signmask;
        } else {
            for (int i = 0; i < size; ++i) {
                piece = this.theUnsafe.getByte(this.memoryPointer + (long)addr + (long)i);
                value <<= 8;
                value |= (long)(piece & 0xFF);
            }
        }
        return value;
    }

    @Override
    public long getDataReverse(int addr, int size) {
        long value = 0L;
        byte piece = 0;
        if ((this.theUnsafe.getByte(this.memoryPointer + (long)addr + (long)size - 1L) & 0x80) == 128) {
            long signmask = -1L;
            for (int i = 0; i < size; ++i) {
                piece = this.theUnsafe.getByte(this.memoryPointer + (long)addr + (long)size - 1L);
                value <<= 8;
                value |= (long)(piece & 0xFF);
                signmask <<= 8;
            }
            value |= signmask;
        } else {
            for (int i = 0; i < size; ++i) {
                piece = this.theUnsafe.getByte(this.memoryPointer + (long)addr + (long)size - 1L);
                value <<= 8;
                value |= (long)(piece & 0xFF);
            }
        }
        return value;
    }

    @Override
    public int getInt(int n) {
        return (this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF) << 24 | (this.theUnsafe.getByte(this.memoryPointer + (long)n + 1L) & 0xFF) << 16 | (this.theUnsafe.getByte(this.memoryPointer + (long)n + 2L) & 0xFF) << 8 | this.theUnsafe.getByte(this.memoryPointer + (long)n + 3L) & 0xFF;
    }

    @Override
    public int getIntReverse(int n) {
        return (this.theUnsafe.getByte(this.memoryPointer + (long)n + 3L) & 0xFF) << 24 | (this.theUnsafe.getByte(this.memoryPointer + (long)n + 2L) & 0xFF) << 16 | (this.theUnsafe.getByte(this.memoryPointer + (long)n + 1L) & 0xFF) << 8 | this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF;
    }

    @Override
    public long getLong(int n) {
        return (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF) << 56 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 1L) & 0xFF) << 48 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 2L) & 0xFF) << 40 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 3L) & 0xFF) << 32 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 4L) & 0xFF) << 24 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 5L) & 0xFF) << 16 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 6L) & 0xFF) << 8 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 7L) & 0xFF);
    }

    @Override
    public long getLongReverse(int n) {
        return (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 7L) & 0xFF) << 56 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 6L) & 0xFF) << 48 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 5L) & 0xFF) << 40 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 4L) & 0xFF) << 32 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 3L) & 0xFF) << 24 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 2L) & 0xFF) << 16 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n + 1L) & 0xFF) << 8 | (long)(this.theUnsafe.getByte(this.memoryPointer + (long)n) & 0xFF);
    }

    @Override
    public void setByte(int n, byte b) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n, b);
    }

    @Override
    public void setByteReverse(int n, byte b) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n, b);
    }

    @Override
    public void setChar(int n, char c) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)c);
    }

    @Override
    public void setCharReverse(int n, char c) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)c);
    }

    @Override
    public void setShort(int n, short s) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(s >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(s & 0xFF));
    }

    @Override
    public void setShortReverse(int n, short s) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(s >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(s & 0xFF));
    }

    @Override
    public void setInt(int n, int i) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(i >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(i >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(i >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(i & 0xFF));
    }

    @Override
    public void setIntReverse(int n, int i) {
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(i >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(i >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(i >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(i & 0xFF));
    }

    @Override
    public void setLong(int n, long l) {
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(ms >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(ms >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(ms >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(ms & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 4L, (byte)(ls >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 5L, (byte)(ls >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 6L, (byte)(ls >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 7L, (byte)(ls & 0xFF));
    }

    @Override
    public void setLongReverse(int n, long l) {
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 7L, (byte)(ms >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 6L, (byte)(ms >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 5L, (byte)(ms >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 4L, (byte)(ms & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(ls >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(ls >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(ls >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(ls & 0xFF));
    }

    @Override
    public void setData(int addr, long value, int size) {
        long pointer = 0L;
        pointer = this.memoryPointer + (long)addr + (long)size - 1L;
        for (int i = 0; i < size; ++i) {
            byte piece = (byte)(value & 0xFFL);
            this.theUnsafe.putByte(pointer, piece);
            --pointer;
            value >>= 8;
        }
    }

    @Override
    public void setDataReverse(int addr, long value, int size) {
        long pointer = this.memoryPointer + (long)addr;
        for (int i = 0; i < size; ++i) {
            byte piece = (byte)(value & 0xFFL);
            this.theUnsafe.putByte(pointer, piece);
            ++pointer;
            value >>= 8;
        }
    }

    @Override
    public void setDouble(int n, double d) {
        long l = Double.doubleToLongBits(d);
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(ms >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(ms >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(ms >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(ms & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 4L, (byte)(ls >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 5L, (byte)(ls >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 6L, (byte)(ls >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 7L, (byte)(ls & 0xFF));
    }

    @Override
    public void setDouble370(int n, double d) {
        long src = Double.doubleToLongBits(d);
        long l = ConvertData.dIEEEto370(src);
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(ms >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(ms >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(ms >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(ms & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 4L, (byte)(ls >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 5L, (byte)(ls >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 6L, (byte)(ls >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 7L, (byte)(ls & 0xFF));
    }

    @Override
    public void setFloat(int n, float f) {
        int i = Float.floatToIntBits(f);
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(i >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(i >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(i >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(i & 0xFF));
    }

    @Override
    public void setFloat370(int n, float f) {
        int src = Float.floatToIntBits(f);
        int i = ConvertData.fIEEEto370(src);
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(i >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(i >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(i >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(i & 0xFF));
    }

    @Override
    public void setDoubleReverse(int n, double d) {
        long v = Double.doubleToLongBits(d);
        int b1 = (int)(v & 0xFFL);
        int b2 = (int)(v >> 8 & 0xFFL);
        int b3 = (int)(v >> 16 & 0xFFL);
        int b4 = (int)(v >> 24 & 0xFFL);
        int b5 = (int)(v >> 32 & 0xFFL);
        int b6 = (int)(v >> 40 & 0xFFL);
        int b7 = (int)(v >> 48 & 0xFFL);
        int b8 = (int)(v >> 56 & 0xFFL);
        v = (long)b1 << 56 | (long)b2 << 48 | (long)b3 << 40 | (long)b4 << 32 | (long)b5 << 24 | (long)b6 << 16 | (long)b7 << 8 | (long)b8;
        int ms = (int)(v >> 32);
        int ls = (int)(v & 0xFFFFFFFFFFFFFFFFL);
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(ms >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(ms >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(ms >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(ms & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 4L, (byte)(ls >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 5L, (byte)(ls >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 6L, (byte)(ls >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 7L, (byte)(ls & 0xFF));
    }

    @Override
    public void setFloatReverse(int n, float f) {
        int v = Float.floatToIntBits(f);
        int b1 = v & 0xFF;
        int b2 = v >> 8 & 0xFF;
        int b3 = v >> 16 & 0xFF;
        int b4 = v >> 24 & 0xFF;
        v = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        this.theUnsafe.putByte(this.memoryPointer + (long)n, (byte)(v >> 24 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 1L, (byte)(v >> 16 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 2L, (byte)(v >> 8 & 0xFF));
        this.theUnsafe.putByte(this.memoryPointer + (long)n + 3L, (byte)(v & 0xFF));
    }

    @Override
    public long getMemoryBasePointer() {
        return this.memoryPointer;
    }

    @Override
    public ExternalUnbufferedMemory setODOSlideMode() {
        this.odoSlideMode = true;
        return this;
    }
}

