/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.GuiSystem;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Semaphore;
import com.heirloomcomputing.ecs.exec.TermComponent;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LMenu;
import com.heirloomcomputing.ecs.jfc.LWindow;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Handle {
    public static final int CTL_LABEL = 1;
    public static final int CTL_ENTRY_FIELD = 2;
    public static final int CTL_PUSH_BUTTON = 3;
    public static final int CTL_CHECK_BOX = 4;
    public static final int CTL_RADIO_BUTTON = 5;
    public static final int CTL_SCROLL_BAR = 6;
    public static final int CTL_LIST_BOX = 7;
    public static final int CTL_COMBO_BOX = 8;
    public static final int CTL_FRAME = 9;
    public static final int CTL_TAB = 10;
    public static final int CTL_BAR = 11;
    public static final int CTL_GRID = 12;
    public static final int CTL_BITMAP = 13;
    public static final int CTL_TREE_VIEW = 14;
    public static final int CTL_WEB_BROWSER = 15;
    public static final int CTL_ACTIVE_X = 16;
    public static final int CTL_SLIDER = 1000;
    public static final int CTL_TOOLBAR = 1001;
    public static final int CTL_MESSAGE_BOX = 1002;
    public static final int CTL_WINDOW = 1003;
    public static final int CTL_STATUS_BAR = 1004;
    public static final int CTL_SPINNER = 1005;
    public static final int CTL_BITMAP_ICON = 1006;
    public static final int CTL_PAGER = 1007;
    public static final int CTL_MENU = 1008;
    public static final int CTL_MASTER_WINDOW = 1009;
    public static final int CTL_PROGRESS_BAR = 1010;
    public static final int CTL_COMPONENT = 2000;
    public static final int CTL_CONTAINER = 2001;
    public static final int CTL_JCOMPONENT = 2002;
    public static final int CTL_JCONTAINER = 2003;
    public static final int CTL_LCOMPONENT = 2004;
    public static final int CTL_LCONTAINER = 2005;
    public static final int CTL_CALENDAR = 2006;
    public static final int CTL_CALENDAR_FIELD = 2007;
    public static final String ITEM_HELP = "ItemHelp";
    public static final String HELP_CURSOR = "HelpCursor";
    public static final String CUT_SELECTION = "CutSelection";
    public static final String COPY_SELECTION = "CopySelection";
    public static final String PASTE_SELECTION = "PasteSelection";
    public static final String DELETE_SELECTION = "DeleteSelection";
    public static final String UNDO = "Undo";
    public static final int WINDOW_TITLE_DEFAULT = -1;
    public static final int WINDOW_TITLE_TOP = 0;
    public static final int WINDOW_TITLE_BOTTOM = 1;
    public static final int WINDOW_TITLE_LEFT = 0;
    public static final int WINDOW_TITLE_CENTER = 1;
    public static final int WINDOW_TITLE_RIGHT = 2;
    public static final int CTL_FIXED_FONT = -1;
    public static final int CTL_DEFAULT_FONT = -2;
    public static final int CTL_TRADITIONAL_FONT = -3;
    public static final int CTL_LARGE_FONT = -4;
    public static final int CTL_MEDIUM_FONT = -5;
    public static final int CTL_SMALL_FONT = -6;
    public static final int DEFAULT_EXCEPTION_VALUE = -32767;
    public static int exceptionValueItemHelp = -32767;
    public static int exceptionValueHelpCursor = -32767;
    public static int exceptionValueCutSelection = -32767;
    public static int exceptionValueCopySelection = -32767;
    public static int exceptionValuePasteSelection = -32767;
    public static int exceptionValueDeleteSelection = -32767;
    public static int exceptionValueUndo = -32767;
    private static final Vector<Handle> handles = new Vector();
    private static final Vector<Integer> freeHandles = new Vector();
    private static Properties printProps;
    private static AcceptEvent acceptObject;
    private static Component fontComponent;
    public static int FIXED_FONT_WIDTH;
    public static int FIXED_FONT_HEIGHT;
    private static Hashtable<String, Class<?>> forNameTable;
    public static Font FIXED_FONT;
    public static Font TRADITIONAL_FONT;
    public static Font DEFAULT_FONT;
    public static Font LARGE_FONT;
    public static Font MEDIUM_FONT;
    public static Font SMALL_FONT;
    public static Handle FIXED_FONT_HANDLE;
    public static Handle TRADITIONAL_FONT_HANDLE;
    public static Handle DEFAULT_FONT_HANDLE;
    public static Handle LARGE_FONT_HANDLE;
    public static Handle MEDIUM_FONT_HANDLE;
    public static Handle SMALL_FONT_HANDLE;
    public static FontMetrics FIXED_FONT_METRICS;
    public static FontMetrics TRADITIONAL_FONT_METRICS;
    public static FontMetrics DEFAULT_FONT_METRICS;
    public static FontMetrics LARGE_FONT_METRICS;
    public static FontMetrics MEDIUM_FONT_METRICS;
    public static FontMetrics SMALL_FONT_METRICS;
    private static final int HANDLE_NULL = 1;
    private String className;
    private int handleNumber;
    private Object handleObject;
    private Component handleComponent;
    private IO io;
    private static final Semaphore acceptSemaphore;
    public static final Handle NULL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetHandles() {
        Vector<Handle> vector = handles;
        synchronized (vector) {
            int size = handles.size();
            Handle examine = null;
            for (int i = 2; i < size; ++i) {
                try {
                    examine = handles.elementAt(i);
                    examine.destroyWithoutTracking();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            handles.removeAllElements();
            handles.addElement(null);
            handles.addElement(null);
            freeHandles.removeAllElements();
        }
    }

    private Handle(boolean state) {
        this.handleNumber = 1;
    }

    public Handle() {
    }

    public Handle(int value) {
        this(value, false);
    }

    public Handle(int value, boolean isTemporary) {
        Font handleObject = null;
        String handleString = null;
        switch (value) {
            case -1: {
                handleObject = FIXED_FONT;
                break;
            }
            case -2: {
                handleObject = DEFAULT_FONT;
                break;
            }
            case -3: {
                handleObject = TRADITIONAL_FONT;
                break;
            }
            case -4: {
                handleObject = LARGE_FONT;
                break;
            }
            case -5: {
                handleObject = MEDIUM_FONT;
                break;
            }
            case -6: {
                handleObject = SMALL_FONT;
                break;
            }
            case 2: {
                handleString = "com.heirloomcomputing.ecs.jfc.LEntryField";
                break;
            }
            case 3: {
                handleString = "com.heirloomcomputing.ecs.jfc.LPushButton";
                break;
            }
            case 4: {
                handleString = "com.heirloomcomputing.ecs.jfc.LCheckBox";
                break;
            }
            case 5: {
                handleString = "com.heirloomcomputing.ecs.jfc.LRadioButton";
                break;
            }
            case 6: {
                handleString = "com.heirloomcomputing.ecs.jfc.LScrollBar";
                break;
            }
            case 7: {
                handleString = "com.heirloomcomputing.ecs.jfc.LListBox";
                break;
            }
            case 8: {
                handleString = "com.heirloomcomputing.ecs.jfc.LComboBox";
                break;
            }
            case 9: {
                handleString = "com.heirloomcomputing.ecs.jfc.LFrame";
                break;
            }
            case 10: {
                handleString = "com.heirloomcomputing.ecs.jfc.LTabControl";
                break;
            }
            case 11: {
                handleString = "com.heirloomcomputing.ecs.jfc.LBar";
                break;
            }
            case 12: {
                handleString = "com.heirloomcomputing.ecs.jfc.LGrid";
                break;
            }
            case 13: {
                handleString = "com.heirloomcomputing.ecs.jfc.LBitmap";
                break;
            }
            case 14: {
                handleString = "com.heirloomcomputing.ecs.jfc.LTreeView";
                break;
            }
            case 15: {
                handleString = "com.heirloomcomputing.ecs.jfc.LWebBrowser";
                break;
            }
            case 1000: {
                handleString = "com.heirloomcomputing.ecs.jfc.LSlider";
                break;
            }
            case 1: {
                handleString = "com.heirloomcomputing.ecs.jfc.LLabel";
                break;
            }
            case 1001: {
                handleString = "com.heirloomcomputing.ecs.jfc.LToolBar";
                break;
            }
            case 1002: {
                handleString = "com.heirloomcomputing.ecs.jfc.LMessageBox";
                break;
            }
            case 1003: {
                handleString = "com.heirloomcomputing.ecs.jfc.LWindow";
                break;
            }
            case 1004: {
                handleString = "com.heirloomcomputing.ecs.jfc.LStatusBar";
                break;
            }
            case 1005: {
                handleString = "com.heirloomcomputing.ecs.jfc.LSpinner";
                break;
            }
            case 1007: {
                handleString = "com.heirloomcomputing.ecs.jfc.LPager";
                break;
            }
            case 1008: {
                handleString = "com.heirloomcomputing.ecs.jfc.LMenu";
                break;
            }
            case 1009: {
                handleString = "com.heirloomcomputing.ecs.jfc.LMasterWindow";
                break;
            }
            case 1010: {
                handleString = "com.heirloomcomputing.ecs.jfc.LProgressBar";
                break;
            }
            case 2000: {
                handleString = "java.awt.Component";
                break;
            }
            case 2001: {
                handleString = "java.awt.Container";
                break;
            }
            case 2002: {
                handleString = "javax.swing.JComponent";
                break;
            }
            case 2003: {
                handleString = "javax.swing.JContainer";
                break;
            }
            case 2004: {
                handleString = "com.heirloomcomputing.ecs.jfc.LComponent";
                break;
            }
            case 2005: {
                handleString = "com.heirloomcomputing.ecs.jfc.LContainer";
                break;
            }
            case 2006: {
                handleString = "com.heirloomcomputing.ecs.jfc.LCalendar";
                break;
            }
            case 2007: {
                handleString = "com.heirloomcomputing.ecs.jfc.LCalendarField";
                break;
            }
            default: {
                handleString = "com.heirloomcomputing.ecs.jfc.LLabel";
            }
        }
        if (isTemporary) {
            try {
                handleObject = Handle.forName(handleString).newInstance();
                handleString = null;
                this.handleComponent = (Component)((Object)handleObject);
                ((LComponent)this.handleComponent).setHandle(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (handleString != null) {
            this.className = handleString;
        } else {
            this.handleObject = handleObject;
            try {
                this.handleComponent = (Component)((Object)handleObject);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Handle(String className) {
        this.className = className;
    }

    public Handle(Object handleObject) {
        this.handleObject = handleObject;
        try {
            this.handleComponent = (Component)handleObject;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Handle(ThreadQueue handleObject) {
        this.handleObject = handleObject;
    }

    public Handle(Component handleObject) {
        this.handleObject = handleObject;
        this.handleComponent = handleObject;
    }

    public Handle(LComponent handleObject) {
        this.handleObject = handleObject;
        this.handleComponent = handleObject;
        handleObject.setHandle(this);
    }

    public Handle(LWindow handleObject) {
        this.handleObject = handleObject;
        this.handleComponent = handleObject;
        handleObject.setHandle(this);
    }

    private static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> c = null;
        c = forNameTable.get(name);
        if (c == null) {
            c = Class.forName(name);
            forNameTable.put(name, c);
        }
        return c;
    }

    public static String limit(String value, int length) {
        if (value == null) {
            return "";
        }
        if (value.length() <= length) {
            return value;
        }
        return value.substring(0, length);
    }

    public static void setExceptionValue(int exceptionValue, String identifier) {
        if (identifier == null) {
            return;
        }
        if (identifier.equals(ITEM_HELP)) {
            exceptionValueItemHelp = exceptionValue;
        } else if (identifier.equals(HELP_CURSOR)) {
            exceptionValueHelpCursor = exceptionValue;
        } else if (identifier.equals(CUT_SELECTION)) {
            exceptionValueCutSelection = exceptionValue;
        } else if (identifier.equals(COPY_SELECTION)) {
            exceptionValueCopySelection = exceptionValue;
        } else if (identifier.equals(PASTE_SELECTION)) {
            exceptionValuePasteSelection = exceptionValue;
        } else if (identifier.equals(DELETE_SELECTION)) {
            exceptionValueDeleteSelection = exceptionValue;
        } else if (identifier.equals(UNDO)) {
            exceptionValueUndo = exceptionValue;
        }
    }

    public static Object getLayoutManager(String s) {
        try {
            s = s.trim();
            if (s.equalsIgnoreCase("null")) {
                return null;
            }
            if (s.equalsIgnoreCase("none")) {
                return null;
            }
            if (s.equalsIgnoreCase("")) {
                return null;
            }
            Class<?> c = Class.forName(s);
            Object o = c.newInstance();
            return (LayoutManager)o;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean isInstantiated() {
        return this.handleObject != null;
    }

    public String toString() {
        switch (this.handleNumber) {
            case 0: {
                return "Handle unassigned-value [handleObject=" + String.valueOf(this.handleObject) + ", IO=" + String.valueOf(this.io) + "]";
            }
            case 1: {
                return "Handle null [handleObject=" + String.valueOf(this.handleObject) + ", IO=" + String.valueOf(this.io) + "]";
            }
        }
        return "Handle #" + this.handleNumber + " [handleObject=" + String.valueOf(this.handleObject) + ", IO=" + String.valueOf(this.io) + "]";
    }

    public static Component getComponent(int value) {
        String handleString = null;
        switch (value) {
            case -1: {
                break;
            }
            case -2: {
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                break;
            }
            case -5: {
                break;
            }
            case -6: {
                break;
            }
            case 2: {
                handleString = "com.heirloomcomputing.ecs.jfc.LEntryField";
                break;
            }
            case 3: {
                handleString = "com.heirloomcomputing.ecs.jfc.LPushButton";
                break;
            }
            case 4: {
                handleString = "com.heirloomcomputing.ecs.jfc.LCheckBox";
                break;
            }
            case 5: {
                handleString = "com.heirloomcomputing.ecs.jfc.LRadioButton";
                break;
            }
            case 6: {
                handleString = "com.heirloomcomputing.ecs.jfc.LScrollBar";
                break;
            }
            case 7: {
                handleString = "com.heirloomcomputing.ecs.jfc.LListBox";
                break;
            }
            case 8: {
                handleString = "com.heirloomcomputing.ecs.jfc.LComboBox";
                break;
            }
            case 9: {
                handleString = "com.heirloomcomputing.ecs.jfc.LFrame";
                break;
            }
            case 10: {
                handleString = "com.heirloomcomputing.ecs.jfc.LTabControl";
                break;
            }
            case 11: {
                handleString = "com.heirloomcomputing.ecs.jfc.LBar";
                break;
            }
            case 12: {
                handleString = "com.heirloomcomputing.ecs.jfc.LGrid";
                break;
            }
            case 13: {
                handleString = "com.heirloomcomputing.ecs.jfc.LBitmap";
                break;
            }
            case 14: {
                handleString = "com.heirloomcomputing.ecs.jfc.LTreeView";
                break;
            }
            case 15: {
                handleString = "com.heirloomcomputing.ecs.jfc.LWebBrowser";
                break;
            }
            case 1000: {
                handleString = "com.heirloomcomputing.ecs.jfc.LSlider";
                break;
            }
            case 1: {
                handleString = "com.heirloomcomputing.ecs.jfc.LLabel";
                break;
            }
            case 1001: {
                handleString = "com.heirloomcomputing.ecs.jfc.LToolBar";
                break;
            }
            case 1002: {
                handleString = "com.heirloomcomputing.ecs.jfc.LMessageBox";
                break;
            }
            case 1003: {
                handleString = "com.heirloomcomputing.ecs.jfc.LWindow";
                break;
            }
            case 1004: {
                handleString = "com.heirloomcomputing.ecs.jfc.LStatusBar";
                break;
            }
            case 1005: {
                handleString = "com.heirloomcomputing.ecs.jfc.LSpinner";
                break;
            }
            case 1007: {
                handleString = "com.heirloomcomputing.ecs.jfc.LPager";
                break;
            }
            case 1008: {
                handleString = "com.heirloomcomputing.ecs.jfc.LMenu";
                break;
            }
            case 1009: {
                handleString = "com.heirloomcomputing.ecs.jfc.LMasterWindow";
                break;
            }
            case 1010: {
                handleString = "com.heirloomcomputing.ecs.jfc.LProgressBar";
                break;
            }
            case 2000: {
                handleString = "java.awt.Component";
                break;
            }
            case 2001: {
                handleString = "java.awt.Container";
                break;
            }
            case 2002: {
                handleString = "javax.swing.JComponent";
                break;
            }
            case 2003: {
                handleString = "javax.swing.JContainer";
                break;
            }
            case 2004: {
                handleString = "com.heirloomcomputing.ecs.jfc.LComponent";
                break;
            }
            case 2005: {
                handleString = "com.heirloomcomputing.ecs.jfc.LContainer";
                break;
            }
            case 2006: {
                handleString = "com.heirloomcomputing.ecs.jfc.LCalendar";
                break;
            }
            case 2007: {
                handleString = "com.heirloomcomputing.ecs.jfc.LCalendarField";
                break;
            }
            default: {
                handleString = "com.heirloomcomputing.ecs.jfc.LLabel";
            }
        }
        try {
            if (handleString != null) {
                return (Component)Handle.forName(handleString).newInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setWindow(Handle windowHandle) {
        try {
            this.getTermComponent().setWindow(windowHandle.getComponent());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setWindow(Component c) {
        try {
            this.getTermComponent().setWindow(c);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Handle getWindowHandle() {
        try {
            return this.getTermComponent().getWindowHandle();
        }
        catch (Throwable t) {
            return NULL;
        }
    }

    public int getId() {
        try {
            return this.getTermComponent().getId();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public boolean isSpecialDisplay() {
        try {
            return this.getTermComponent().isSpecialDisplay();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean isAcceptable() {
        try {
            return this.getTermComponent().isAcceptable();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void eventProcedure() {
        this.getTermComponent().eventProcedure();
    }

    public void beforeProcedure() {
        this.getTermComponent().beforeProcedure();
    }

    public void afterProcedure() {
        this.getTermComponent().afterProcedure();
    }

    public void exceptionProcedure() {
        this.getTermComponent().exceptionProcedure();
    }

    public boolean hasEventProcedure() {
        return this.getTermComponent().hasEventProcedure();
    }

    public boolean hasBeforeProcedure() {
        return this.getTermComponent().hasBeforeProcedure();
    }

    public boolean hasAfterProcedure() {
        return this.getTermComponent().hasAfterProcedure();
    }

    public boolean hasExceptionProcedure() {
        return this.getTermComponent().hasExceptionProcedure();
    }

    public void setMenu(Handle h) {
        Component c = this.getComponent();
        Component menu = h.getComponent();
        try {
            if (menu instanceof LMenu) {
                LMenu lmenu = (LMenu)menu;
                if (c instanceof LWindow) {
                    ((LWindow)c).setMenuBar(h, lmenu);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public JComponent getMenu() {
        Component c = this.getComponent();
        try {
            if (c instanceof LWindow) {
                return (JComponent)((LWindow)c).getMenuBar();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Handle getMenuHandle() {
        Component c = this.getComponent();
        try {
            if (c instanceof LWindow) {
                return ((LWindow)c).getMenuHandle();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean displayUponWindowTitle(String title, int v, int h) {
        try {
            this.getTermComponent().setTitle(title);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void displayUponGlobalWindowTitle(String title, int v, int h) {
        try {
            Utilities.getMainWindowHandle().displayUponWindowTitle(title, v, h);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIO(IO ioObject) {
        if (this.io == ioObject) {
            return;
        }
        this.io = ioObject;
        try {
            this.getTermComponent().setIO(ioObject);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public IO getIO() {
        block10: {
            if (this.io != null) {
                return this.io;
            }
            try {
                if (this.getTermComponent().getControlType() != 1001) break block10;
                IO.setCurrentlyRegisteredWindow(this);
                try {
                    this.io = IO.allocateIO(this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.io != null) {
                    this.io.setIOHandle(this);
                    this.setIO(this.io);
                    this.io.display(this);
                }
                IO.setCurrentlyRegisteredWindow(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.io == null) {
            Component c = this.getComponent();
            while (c.getParent() != null) {
                c = c.getParent();
                try {
                    this.io = ((LComponent)c).getHandle().getIO();
                    if (this.io == null) continue;
                    return this.io;
                }
                catch (Throwable throwable) {
                }
            }
        }
        return this.io;
    }

    public void add(Handle c, float x, float y, boolean xpixels, boolean ypixels) {
        this.add(c.getComponent(), x, y, xpixels, ypixels);
    }

    public void add(Component c, float x, float y, boolean xpixels, boolean ypixels) {
        try {
            if (c instanceof LComponent) {
                LComponent lcomponent = (LComponent)c;
                if (x >= 0.0f) {
                    if (xpixels) {
                        lcomponent.setColumnPixels((int)x);
                    } else {
                        lcomponent.setColumn(x);
                    }
                }
                if (y >= 0.0f) {
                    if (ypixels) {
                        lcomponent.setLinePixels((int)y);
                    } else {
                        lcomponent.setLine(y);
                    }
                }
            }
        }
        catch (Throwable lcomponent) {
            // empty catch block
        }
        try {
            Container me = (Container)this.handleComponent;
            me.add(c);
            me.validate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Handle getHandle(int handleNumber) {
        try {
            return handles.elementAt(handleNumber);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Handle getHandleAt(String screenLoc) {
        try {
            if (screenLoc == null || screenLoc.length() <= 0) {
                return null;
            }
            int line = 0;
            int column = 0;
            int half = 0;
            half = screenLoc.length() / 2;
            String left = "";
            String right = "";
            try {
                left = screenLoc.substring(0, half);
                line = ConvertData.parseInt(left);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                right = screenLoc.substring(half);
                column = ConvertData.parseInt(right);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Handle.getHandleAt(line, column);
        }
        catch (Throwable t) {
            return NULL;
        }
    }

    public static Handle getHandleAtPixels(String screenLoc) {
        try {
            if (screenLoc == null || screenLoc.length() <= 0) {
                return null;
            }
            int line = 0;
            int column = 0;
            int half = 0;
            half = screenLoc.length() / 2;
            String left = "";
            String right = "";
            try {
                left = screenLoc.substring(0, half);
                line = ConvertData.parseInt(left);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                right = screenLoc.substring(half);
                column = ConvertData.parseInt(right);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Handle.getHandleAtPixels(line, column);
        }
        catch (Throwable throwable) {
            return NULL;
        }
    }

    public static Handle getHandleAt(int screenLoc) {
        try {
            int line = 0;
            int column = 0;
            if (screenLoc > 999) {
                line = screenLoc / 1000;
                column = screenLoc % 1000;
            } else if (screenLoc > 99) {
                line = screenLoc / 100;
                column = screenLoc % 100;
            } else {
                line = screenLoc / 10;
                column = screenLoc % 10;
            }
            return Handle.getHandleAt(line, column);
        }
        catch (Throwable throwable) {
            return NULL;
        }
    }

    public static Handle getHandleAtPixels(int screenLoc) {
        try {
            int line = 0;
            int column = 0;
            if (screenLoc > 999) {
                line = screenLoc / 1000;
                column = screenLoc % 1000;
            } else if (screenLoc > 99) {
                line = screenLoc / 100;
                column = screenLoc % 100;
            } else {
                line = screenLoc / 10;
                column = screenLoc % 10;
            }
            return Handle.getHandleAtPixels(line, column);
        }
        catch (Throwable throwable) {
            return NULL;
        }
    }

    public static Handle getHandleAt(double line, double column) {
        try {
            IO io = IO.getCurrentIONoCreate();
            if (io == null) {
                return NULL;
            }
            Handle windowHandle = io.getIOHandle();
            if (windowHandle == null) {
                return NULL;
            }
            Component c = windowHandle.getComponent();
            TermComponent cellDefiner = (TermComponent)((Object)c);
            line *= (double)cellDefiner.getCellHeight();
            column *= (double)cellDefiner.getCellWidth();
            try {
                Container container = (Container)((LWindow)c).getMasterWindow();
                Component[] components = container.getComponents();
                return Handle.getHandleAt((int)line, (int)column, components);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NULL;
    }

    public static Handle getHandleAtPixels(double line, double column) {
        try {
            IO io = IO.getCurrentIONoCreate();
            if (io == null) {
                return NULL;
            }
            Handle windowHandle = io.getIOHandle();
            if (windowHandle == null) {
                return NULL;
            }
            Component c = windowHandle.getComponent();
            try {
                Container container = (Container)((LWindow)c).getMasterWindow();
                Component[] components = container.getComponents();
                return Handle.getHandleAt((int)line, (int)column, components);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NULL;
    }

    public static Handle getHandleAtPixelsCells(double line, double column) {
        try {
            IO io = IO.getCurrentIONoCreate();
            if (io == null) {
                return NULL;
            }
            Handle windowHandle = io.getIOHandle();
            if (windowHandle == null) {
                return NULL;
            }
            Component c = windowHandle.getComponent();
            TermComponent cellDefiner = (TermComponent)((Object)c);
            column *= (double)cellDefiner.getCellWidth();
            try {
                Container container = (Container)((LWindow)c).getMasterWindow();
                Component[] components = container.getComponents();
                return Handle.getHandleAt((int)line, (int)column, components);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NULL;
    }

    public static Handle getHandleAtCellsPixels(double line, double column) {
        try {
            IO io = IO.getCurrentIONoCreate();
            if (io == null) {
                return NULL;
            }
            Handle windowHandle = io.getIOHandle();
            if (windowHandle == null) {
                return NULL;
            }
            Component c = windowHandle.getComponent();
            TermComponent cellDefiner = (TermComponent)((Object)c);
            line *= (double)cellDefiner.getCellHeight();
            try {
                Container container = (Container)((LWindow)c).getMasterWindow();
                Component[] components = container.getComponents();
                return Handle.getHandleAt((int)line, (int)column, components);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NULL;
    }

    public static Handle getHandleAt(int line, int column, Component[] components) {
        try {
            if (components == null) {
                return NULL;
            }
            int l = components.length;
            Component c = null;
            Component best = null;
            for (int i = 0; i < l; ++i) {
                c = components[i];
                Point p = c.getLocation();
                if (p.x != column || p.y != line) continue;
                best = c;
                break;
            }
            if (best == null) {
                int distx = 0;
                int disty = 0;
                int dist = 0;
                int bestDist = 800;
                for (int i = 0; i < l; ++i) {
                    c = components[i];
                    Point p = c.getLocation();
                    distx = p.x - column;
                    disty = p.y - line;
                    dist = distx * distx + disty * disty;
                    if (dist >= bestDist) continue;
                    best = c;
                    bestDist = dist;
                }
            }
            if (best == null) {
                return NULL;
            }
            return ((TermComponent)((Object)best)).getHandle();
        }
        catch (Throwable throwable) {
            return NULL;
        }
    }

    public static void setEnvironment(String name, String value) {
    }

    public void set(Object handleObject) {
        this.handleObject = handleObject;
        try {
            this.handleComponent = (Component)handleObject;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isNull() {
        return this.handleObject == null || this.handleNumber == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFreeHandle(int value) {
        Vector<Integer> vector = freeHandles;
        synchronized (vector) {
            freeHandles.addElement(new Integer(value));
        }
    }

    private static int getFreeHandle() {
        try {
            int which = freeHandles.size() - 1;
            if (which >= 0) {
                int freeHandle = freeHandles.elementAt(which);
                freeHandles.removeElementAt(which);
                return freeHandle;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return -1;
    }

    public static void destroyAll() {
        try {
            IO io = IO.getCurrentIONoCreate();
            if (io == null) {
                return;
            }
            Handle windowHandle = io.getIOHandle();
            Handle.destroyAll(windowHandle);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAll(Handle windowHandle) {
        try {
            if (windowHandle == null) {
                return;
            }
            Component c = windowHandle.getComponent();
            Container container = (Container)((LWindow)c).getMasterWindow();
            Component[] components = container.getComponents();
            int l = components.length;
            Object object = container.getTreeLock();
            synchronized (object) {
                for (int i = 0; i < l; ++i) {
                    try {
                        ((TermComponent)((Object)components[i])).getHandle().destroy();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void set(Handle copy) {
        if (copy == null) {
            return;
        }
        this.handleObject = copy.handleObject;
        this.handleComponent = copy.handleComponent;
        this.handleNumber = copy.handleNumber;
        this.io = copy.io;
        this.className = copy.className;
    }

    public void set(int copy) {
        this.set(Handle.getHandle(copy));
    }

    public static void destroy(int handleNumber) {
        try {
            if (handleNumber >= 2) {
                Handle.getHandle(handleNumber).destroy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block7: {
            try {
                if (this.handleNumber >= 2) {
                    Vector<Handle> vector = handles;
                    synchronized (vector) {
                        Handle oldObjectAtHandle = handles.elementAt(this.handleNumber);
                        this.destroyWithoutTracking();
                        if (oldObjectAtHandle == this) {
                            handles.setElementAt(null, this.handleNumber);
                            Handle.addFreeHandle(this.handleNumber);
                        }
                        break block7;
                    }
                }
                this.destroyWithoutTracking();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void destroyWithoutTracking() {
        try {
            Thread destroyThread = this.getThread();
            if (destroyThread != null) {
                try {
                    destroyThread.stop();
                }
                catch (Throwable throwable) {}
            } else if (this.handleComponent != null) {
                try {
                    this.handleComponent.setVisible(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.getTermComponent().destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (this.handleComponent instanceof Window) {
                        ((Window)this.handleComponent).dispose();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Container parent = this.handleComponent.getParent();
                if (parent != null) {
                    parent.remove(this.handleComponent);
                }
            }
            this.handleObject = null;
            this.handleComponent = null;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyScreen(Variable screenName) {
        if (screenName == null) {
            return;
        }
        Handle h = screenName.getHandle();
        if (SwingUtilities.isEventDispatchThread()) {
            if (h != null) {
                h.hide();
            }
            screenName = screenName.getChild();
            Handle.destroyScreenSiblings(screenName);
            if (h != null) {
                h.destroy();
            }
        } else {
            Component firstComponent = Handle.findFirstExistingComponent(screenName);
            if (firstComponent != null) {
                Object treeLock;
                Object object = treeLock = firstComponent.getTreeLock();
                synchronized (object) {
                    if (h != null) {
                        h.hide();
                    }
                    screenName = screenName.getChild();
                    Handle.destroyScreenSiblings(screenName);
                    if (h != null) {
                        h.destroy();
                    }
                }
            }
        }
    }

    public static void destroyScreenSiblings(Variable screenName) {
        if (screenName == null) {
            return;
        }
        Variable child = null;
        do {
            Handle h;
            if ((h = screenName.getHandle()) != null) {
                h.hide();
            }
            if ((child = screenName.getChild()) != null) {
                Handle.destroyScreenSiblings(child);
            }
            screenName = screenName.getSibling();
            if (h == null) continue;
            h.destroy();
        } while (screenName != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideScreen(Variable screenName) {
        if (screenName == null) {
            return;
        }
        Handle h = screenName.getHandle();
        if (SwingUtilities.isEventDispatchThread()) {
            if (h != null) {
                h.hide();
            }
            screenName = screenName.getChild();
            Handle.hideScreenSiblings(screenName);
        } else {
            Component firstComponent = Handle.findFirstExistingComponent(screenName);
            if (firstComponent != null) {
                Object treeLock;
                Object object = treeLock = firstComponent.getTreeLock();
                synchronized (object) {
                    if (h != null) {
                        h.hide();
                    }
                    screenName = screenName.getChild();
                    Handle.hideScreenSiblings(screenName);
                }
            }
        }
    }

    public static void hideScreenSiblings(Variable screenName) {
        if (screenName == null) {
            return;
        }
        Variable child = null;
        do {
            Handle h;
            if ((h = screenName.getHandle()) != null) {
                h.hide();
            }
            if ((child = screenName.getChild()) == null) continue;
            Handle.hideScreenSiblings(child);
        } while ((screenName = screenName.getSibling()) != null);
    }

    private static Component findFirstComponent(Variable screenName) {
        if (screenName == null) {
            return null;
        }
        Handle h = null;
        Component c = null;
        while (screenName != null) {
            h = screenName.getHandle();
            if (h != null && (c = h.getComponent()) != null) {
                return c;
            }
            c = Handle.findFirstComponent(screenName.getChild());
            if (c != null) {
                return c;
            }
            screenName = screenName.getSibling();
        }
        return null;
    }

    private static Component findFirstExistingComponent(Variable screenName) {
        if (screenName == null) {
            return null;
        }
        Handle h = null;
        Component c = null;
        while (screenName != null) {
            h = screenName.getHandle();
            if (h != null && (c = h.getExistingComponent()) != null) {
                return c;
            }
            c = Handle.findFirstExistingComponent(screenName.getChild());
            if (c != null) {
                return c;
            }
            screenName = screenName.getSibling();
        }
        return null;
    }

    public static boolean printScreen(Variable screenName) {
        if (screenName == null) {
            return false;
        }
        Component c = null;
        Handle h = screenName.getHandle();
        if (h != null && (c = h.getComponent()) != null) {
            return Handle.print(c);
        }
        c = Handle.findFirstComponent(screenName);
        if (c != null) {
            Container parent = null;
            do {
                if ((parent = c.getParent()) == null) continue;
                c = parent;
            } while (parent != null);
        }
        return Handle.print(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showScreen(Variable screenName) {
        if (screenName == null) {
            return;
        }
        Handle h = screenName.getHandle();
        if (SwingUtilities.isEventDispatchThread()) {
            screenName = screenName.getChild();
            Handle.showScreenSiblings(screenName);
            if (h != null) {
                h.show();
            }
        } else {
            Component firstComponent = Handle.findFirstExistingComponent(screenName);
            if (firstComponent != null) {
                Object treeLock;
                Object object = treeLock = firstComponent.getTreeLock();
                synchronized (object) {
                    screenName = screenName.getChild();
                    Handle.showScreenSiblings(screenName);
                    if (h != null) {
                        h.show();
                    }
                }
            }
        }
    }

    public static void showScreenSiblings(Variable screenName) {
        if (screenName == null) {
            return;
        }
        Variable child = null;
        do {
            Handle h = screenName.getHandle();
            child = screenName.getChild();
            if (child != null) {
                Handle.showScreenSiblings(child);
            }
            screenName = screenName.getSibling();
            if (h == null) continue;
            h.show();
        } while (screenName != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHandleNumber() {
        if (this.handleNumber != 0) {
            return this.handleNumber;
        }
        Vector<Handle> vector = handles;
        synchronized (vector) {
            int freeHandle = Handle.getFreeHandle();
            if (freeHandle >= 0) {
                this.handleNumber = freeHandle;
                handles.setElementAt(this, this.handleNumber);
            } else {
                this.handleNumber = handles.size();
                handles.addElement(this);
            }
        }
        return this.handleNumber;
    }

    public Object getObject() {
        if (this.handleObject != null) {
            return this.handleObject;
        }
        try {
            if (this.className != null) {
                this.handleObject = Handle.forName(this.className).newInstance();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.handleObject;
    }

    public Container getContainer() {
        try {
            return (Container)this.getComponent();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Component getComponentNoCreate() {
        if (this.handleComponent != null) {
            return this.handleComponent;
        }
        if (this.handleObject != null) {
            try {
                return (Component)this.handleObject;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    private Component getExistingComponent() {
        if (this.handleComponent != null) {
            return this.handleComponent;
        }
        if (this.handleObject != null) {
            try {
                return (Component)this.handleObject;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public Component getComponent() {
        if (this.handleComponent != null) {
            return this.handleComponent;
        }
        if (this.handleObject != null) {
            try {
                return (Component)this.handleObject;
            }
            catch (Throwable t) {
                return null;
            }
        }
        if (this.className == null) {
            return null;
        }
        try {
            if (this.className != null) {
                this.handleObject = Handle.forName(this.className).newInstance();
                this.handleComponent = (Component)this.handleObject;
                ((LComponent)this.handleComponent).setHandle(this);
                ((LComponent)this.handleComponent).setWindow();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.handleComponent;
    }

    public String getValue() {
        return this.getTermComponent().getValue();
    }

    public TermComponent getTermComponent() {
        try {
            return (TermComponent)((Object)this.handleComponent);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void show() {
        try {
            this.getComponent().setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final boolean print(Component component) {
        Component currentComponent;
        if (component == null) {
            return false;
        }
        Frame f = null;
        boolean status = false;
        for (currentComponent = component; currentComponent != null && !(currentComponent instanceof Frame); currentComponent = currentComponent.getParent()) {
        }
        f = (Frame)currentComponent;
        boolean newFrame = false;
        if (f == null) {
            f = new Frame();
            newFrame = true;
        }
        try {
            if (f != null) {
                try {
                    PrintJob job;
                    Toolkit t = component.getToolkit();
                    if (printProps == null) {
                        printProps = new Properties();
                    }
                    if ((job = t.getPrintJob(f, "Print", printProps)) == null) {
                        throw new Exception("Canceled");
                    }
                    Graphics page = job.getGraphics();
                    Dimension size = component.getSize();
                    Dimension pageSize = job.getPageDimension();
                    page.translate((pageSize.width - size.width) / 2, (pageSize.height - size.height) / 2);
                    page.setClip(0, 0, size.width, size.height);
                    if (component instanceof Container) {
                        ((Container)component).printComponents(page);
                    } else {
                        component.print(page);
                    }
                    page.dispose();
                    job.end();
                    status = true;
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newFrame) {
            try {
                f.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    public void print() {
        try {
            Component printable = this.getComponent();
            if (printable != null) {
                GuiSystem.print(printable);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void hide() {
        try {
            Component component = this.getExistingComponent();
            if (component != null) {
                component.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Thread getThread() {
        try {
            return (Thread)this.handleObject;
        }
        catch (Exception castingException) {
            return null;
        }
    }

    public ThreadQueue getThreadQueue() {
        try {
            return (ThreadQueue)this.handleObject;
        }
        catch (Exception castingException) {
            return null;
        }
    }

    public static Font getFont(int handle) {
        try {
            return Handle.getHandle(handle).getFont();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Font getFont() {
        try {
            Object object = this.getObject();
            if (object instanceof Font) {
                return (Font)object;
            }
            if (object instanceof Component) {
                return ((Component)object).getFont();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void setFont(Font font2) {
        try {
            Component c = this.getComponent();
            if (c != null) {
                c.setFont(font2);
            } else if (this.className == null) {
                this.handleObject = font2;
                this.handleComponent = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Handle requestFocus() {
        try {
            this.getComponent().requestFocus();
            ((Window)this.getComponent()).toFront();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public boolean isHandleNoTab() {
        return this.getTermComponent().isHandleNoTab();
    }

    public void addListeners() {
        this.getTermComponent().addListeners();
    }

    public void removeListeners() {
        this.getTermComponent().removeListeners();
    }

    public static Semaphore getAcceptSemaphore() {
        return acceptSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalAccept(AcceptEvent signalEvent) {
        Semaphore semaphore = acceptSemaphore;
        synchronized (semaphore) {
            Handle.setAcceptObject(signalEvent);
            acceptSemaphore.release();
        }
    }

    public static void signalAccept() {
        Handle.signalAccept(null);
    }

    public static final AcceptEvent getAcceptObject() {
        return acceptObject;
    }

    public static final void setAcceptObject(AcceptEvent o) {
        acceptObject = o;
    }

    public AcceptEvent accept() {
        return this.accept(-1L);
    }

    public AcceptEvent accept(long timeout) {
        try {
            return ((TermComponent)((Object)this.getComponent())).accept(timeout);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public AcceptEvent acceptWithoutRequestingFocus(long timeout) {
        try {
            return ((TermComponent)((Object)this.getComponent())).acceptWithoutRequestingFocus(timeout);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Handle display() {
        return this;
    }

    static void setupDefaultFonts() {
        String fixedFontName = RuntimeEnvironment.getGlobalParameter("FIXED-FONT");
        String traditionalFontName = RuntimeEnvironment.getGlobalParameter("TRADITIONAL-FONT");
        String largeFontName = RuntimeEnvironment.getGlobalParameter("LARGE-FONT");
        String mediumFontName = RuntimeEnvironment.getGlobalParameter("MEDIUM-FONT");
        String smallFontName = RuntimeEnvironment.getGlobalParameter("SMALL-FONT");
        String defaultFontName = RuntimeEnvironment.getGlobalParameter("DEFAULT-FONT");
        if (fixedFontName == null) {
            fixedFontName = "Courier-14";
        }
        if (traditionalFontName == null) {
            traditionalFontName = "SansSerif-12";
        }
        if (largeFontName == null) {
            largeFontName = "SansSerif-bold-12";
        }
        if (mediumFontName == null) {
            mediumFontName = "SansSerif-bold-12";
        }
        if (smallFontName == null) {
            smallFontName = "Serif-12";
        }
        if (defaultFontName != null) {
            if (defaultFontName.equalsIgnoreCase("FIXED")) {
                defaultFontName = fixedFontName;
            } else if (defaultFontName.equalsIgnoreCase("TRADITIONAL")) {
                defaultFontName = traditionalFontName;
            } else if (defaultFontName.equalsIgnoreCase("LARGE")) {
                defaultFontName = largeFontName;
            } else if (defaultFontName.equalsIgnoreCase("MEDIUM")) {
                defaultFontName = mediumFontName;
            } else if (defaultFontName.equalsIgnoreCase("SMALL")) {
                defaultFontName = smallFontName;
            }
        }
        if (defaultFontName == null) {
            defaultFontName = mediumFontName;
        }
        FIXED_FONT = Font.decode(fixedFontName);
        FIXED_FONT_HANDLE = new Handle(FIXED_FONT);
        try {
            FontMetrics fm = Utils.getFontMetrics(FIXED_FONT);
            FIXED_FONT_WIDTH = fm.charWidth('0');
            FIXED_FONT_HEIGHT = FIXED_FONT.getSize();
        }
        catch (Exception fm) {
            // empty catch block
        }
        TRADITIONAL_FONT = Font.decode(traditionalFontName);
        TRADITIONAL_FONT_HANDLE = new Handle(TRADITIONAL_FONT);
        LARGE_FONT = Font.decode(largeFontName);
        LARGE_FONT_HANDLE = new Handle(LARGE_FONT);
        MEDIUM_FONT = Font.decode(mediumFontName);
        MEDIUM_FONT_HANDLE = new Handle(MEDIUM_FONT);
        SMALL_FONT = Font.decode(smallFontName);
        SMALL_FONT_HANDLE = new Handle(SMALL_FONT);
        DEFAULT_FONT = Font.decode(defaultFontName);
        DEFAULT_FONT_HANDLE = new Handle(DEFAULT_FONT);
        Component baseComponent = Handle.getFontComponent();
        FIXED_FONT_METRICS = baseComponent.getFontMetrics(FIXED_FONT);
        TRADITIONAL_FONT_METRICS = baseComponent.getFontMetrics(TRADITIONAL_FONT);
        DEFAULT_FONT_METRICS = baseComponent.getFontMetrics(DEFAULT_FONT);
        LARGE_FONT_METRICS = baseComponent.getFontMetrics(LARGE_FONT);
        MEDIUM_FONT_METRICS = baseComponent.getFontMetrics(MEDIUM_FONT);
        SMALL_FONT_METRICS = baseComponent.getFontMetrics(SMALL_FONT);
    }

    public static Handle getFontObject(String name) {
        Font f = Font.getFont(name);
        if (f == null) {
            f = Font.decode(name);
        }
        return new Handle(f);
    }

    public static Component getFontComponent() {
        if (fontComponent == null) {
            try {
                fontComponent = new Canvas();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return fontComponent;
    }

    public static Font getFont(String name, int style, int size) {
        Font f = new Font(name, style, size);
        Component c = Handle.getFontComponent();
        if (c != null) {
            c.getFontMetrics(f);
        }
        return f;
    }

    public static Font decodeFont(String name) {
        Font f = Font.decode(name);
        Component c = Handle.getFontComponent();
        if (c != null) {
            c.getFontMetrics(f);
        }
        return f;
    }

    public static Handle getStandardObject(String name) {
        if (name == null) {
            return FIXED_FONT_HANDLE;
        }
        int c = 70;
        if (name.length() > 0) {
            c = Character.toUpperCase(name.charAt(0));
        }
        switch (c) {
            case 70: {
                return FIXED_FONT_HANDLE;
            }
            case 84: {
                return TRADITIONAL_FONT_HANDLE;
            }
            case 68: {
                return DEFAULT_FONT_HANDLE;
            }
            case 76: {
                return LARGE_FONT_HANDLE;
            }
            case 77: {
                return MEDIUM_FONT_HANDLE;
            }
            case 83: {
                return SMALL_FONT_HANDLE;
            }
        }
        return DEFAULT_FONT_HANDLE;
    }

    public static int getFixedFontWidth() {
        return FIXED_FONT_WIDTH;
    }

    public static int getFixedFontHeight() {
        return FIXED_FONT_HEIGHT;
    }

    static {
        FIXED_FONT_WIDTH = 8;
        FIXED_FONT_HEIGHT = 12;
        forNameTable = new Hashtable();
        handles.addElement(null);
        handles.addElement(null);
        acceptSemaphore = new Semaphore();
        try {
            Handle.setupDefaultFonts();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NULL = new Handle(0);
    }
}

