/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.ISpecialNames;
import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.KeyStroke;
import com.heirloomcomputing.ecs.exec.KeyStrokeAction;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ScreenProperty;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.XOpenScreen;
import com.heirloomcomputing.term.CursesHandler;
import com.heirloomcomputing.term.GUIHandler;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import com.heirloomcomputing.term.SyserrHandler;
import com.heirloomcomputing.term.SysoutHandler;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class IO {
    private static final boolean debugMode = false;
    public static final String PROP_CRT_STATUS = "crt_status";
    public static final String PROP_CURSOR = "cursor";
    public static final String PROP_EVENT_STATUS = "event_status";
    public static final String PROP_SCREEN_CONTROL = "screen_control";
    private static final int CHAR_STYLE = 0;
    private static final int JAVA_STYLE = 1;
    private static final int MF_STYLE = 2;
    private static final int ACU_STYLE = 3;
    public static final int STATUS_KEY1_OK = 0;
    public static final int STATUS_KEY1_USER_FUNC = 1;
    public static final int STATUS_KEY1_SYS_FUNC = 2;
    public static final int STATUS_KEY1_ERROR = 9;
    public static final int STATUS_KEY2_TERMINATOR = 0;
    public static final int STATUS_KEY2_AUTOSKIP = 1;
    private static final int NUM_FKEYS = 48;
    private static final Object lockObject = new Object();
    private static int BINARY_CRTKEY1 = -1;
    private static int keyCodeStyle = -1;
    private static Hashtable<String, IO> i;
    private static Hashtable<String, IO> o;
    private static boolean waitForTerminatorKey;
    private static boolean terminatorsInitialized;
    private static int numTerminators;
    private static int[] fkTerminatorMap;
    private static KeyValue[] fkTerminators;
    private static KeyValue[] normalTerminators;
    private static KeyValue[] allTerminators;
    private static Hashtable<String, IO> openFiles;
    private static Variable cursor;
    private static Variable wangCursor;
    private static Variable wangPFKey;
    private static Variable status;
    private static Variable eventStatus;
    private static Variable eventType;
    private static Variable eventWindow;
    private static Variable eventControlHandle;
    private static Variable eventControlId;
    private static Variable eventData1;
    private static Variable eventData2;
    private static Variable eventAction;
    protected static Variable acceptControl;
    protected static Variable controlValue;
    protected static Variable controlHandle;
    protected static Variable controlId;
    private static int externalCRTStatusKey1;
    private static int externalCRTStatusKey2;
    private static int externalCRTStatusKey3;
    private static int externalLineNumber;
    private static int externalColumnNumber;
    private static int externalKeyTerminatedInput;
    private static IO systemIO;
    private static IO syserrIO;
    private static IO consoleIO;
    private static IO currentIO;
    private static IO activeIO;
    private static IO ioFeedback;
    private static IO openFeedback;
    private static IO dataArea;
    private static IO localData;
    private static IO pipData;
    private static IO attributeData;
    private static Handle currentlyRegistered;
    private Handle ioHandle;
    private String titleString;
    private ScreenHandler screenHandler;
    private boolean screenHandlerIsGraphical;

    public static void resetStaticData() {
        BINARY_CRTKEY1 = -1;
        keyCodeStyle = -1;
        waitForTerminatorKey = false;
        cursor = null;
        wangCursor = null;
        wangPFKey = null;
        status = null;
        eventStatus = null;
        eventType = null;
        eventWindow = null;
        eventControlHandle = null;
        eventControlId = null;
        eventData1 = null;
        eventData2 = null;
        eventAction = null;
        acceptControl = null;
        controlValue = null;
        controlHandle = null;
        controlId = null;
        externalCRTStatusKey1 = 0;
        externalCRTStatusKey2 = 0;
        externalCRTStatusKey3 = 0;
        externalLineNumber = 1;
        externalColumnNumber = 1;
        externalKeyTerminatedInput = 0;
        currentIO = null;
        activeIO = null;
        ioFeedback = null;
        openFeedback = null;
        dataArea = null;
        localData = null;
        pipData = null;
        attributeData = null;
        currentlyRegistered = null;
        o = null;
        i = null;
        openFiles.clear();
        currentIO = null;
        consoleIO = null;
    }

    private static void initTerminatorArrays() {
        IO.setupFKTerminators();
        if (normalTerminators == null) {
            IO.setupNormalTerminators();
        }
        int n = 0;
        int f = 0;
        if (normalTerminators != null) {
            n = normalTerminators.length;
        }
        if (fkTerminators != null) {
            f = fkTerminators.length;
        }
        allTerminators = new KeyValue[n + f];
        if (fkTerminators != null) {
            System.arraycopy(fkTerminators, 0, allTerminators, 0, f);
        }
        if (normalTerminators != null) {
            System.arraycopy(normalTerminators, 0, allTerminators, f, n);
        }
        terminatorsInitialized = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getNextFK(String t) {
        int value;
        String temp;
        if (t == null) {
            return null;
        }
        int index = t.indexOf(",");
        if (index < 0) {
            temp = t.trim();
            t = null;
        } else {
            temp = t.substring(0, index).trim();
            try {
                t = t.substring(index + 1);
            }
            catch (Exception e) {
                t = null;
            }
        }
        if (temp.length() <= 0) return t;
        if (temp.charAt(0) == '!') {
            value = 2;
            temp = temp.substring(1);
        } else {
            value = 1;
        }
        if (temp.length() <= 0) return t;
        int dash = temp.indexOf(45);
        int start = 1;
        int end = 48;
        if (dash >= 0) {
            if (dash > 0) {
                try {
                    start = Integer.valueOf(temp.substring(0, dash));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (++dash < temp.length()) {
                try {
                    end = Integer.valueOf(temp.substring(dash));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (start <= 0 || start >= 48 || end <= 0 || end >= 48) return t;
            for (int i = start - 1; i <= end - 1; ++i) {
                IO.fkTerminatorMap[i] = value;
                if (value != 2) continue;
                --numTerminators;
            }
            return t;
        }
        try {
            int number = Integer.valueOf(temp);
            if (number <= 0 || number >= 48) return t;
            IO.fkTerminatorMap[number - 1] = value;
            if (value != 2) return t;
            --numTerminators;
            return t;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    private static int setupFKTerminatorMap() {
        numTerminators = 48;
        if (fkTerminatorMap != null) {
            for (int i = 0; i < fkTerminatorMap.length; ++i) {
                if (fkTerminatorMap[i] != 2) continue;
                --numTerminators;
            }
            return numTerminators;
        }
        fkTerminatorMap = new int[numTerminators];
        String t = RuntimeEnvironment.getGlobalParameter("PFTERMS");
        while (t != null) {
            t = IO.getNextFK(t);
        }
        return numTerminators;
    }

    private static void setupFKTerminators() {
        int numTerminators = IO.setupFKTerminatorMap();
        fkTerminators = new KeyValue[numTerminators];
        int index = 0;
        for (int i = 0; i < numTerminators; ++i) {
            while (index < fkTerminatorMap.length && fkTerminatorMap[index] == 2) {
                ++index;
            }
            if (index >= fkTerminatorMap.length) continue;
            switch (index) {
                case 0: {
                    IO.fkTerminators[i] = new KeyValue(112, 0);
                    break;
                }
                case 1: {
                    IO.fkTerminators[i] = new KeyValue(113, 0);
                    break;
                }
                case 2: {
                    IO.fkTerminators[i] = new KeyValue(114, 0);
                    break;
                }
                case 3: {
                    IO.fkTerminators[i] = new KeyValue(115, 0);
                    break;
                }
                case 4: {
                    IO.fkTerminators[i] = new KeyValue(116, 0);
                    break;
                }
                case 5: {
                    IO.fkTerminators[i] = new KeyValue(117, 0);
                    break;
                }
                case 6: {
                    IO.fkTerminators[i] = new KeyValue(118, 0);
                    break;
                }
                case 7: {
                    IO.fkTerminators[i] = new KeyValue(119, 0);
                    break;
                }
                case 8: {
                    IO.fkTerminators[i] = new KeyValue(120, 0);
                    break;
                }
                case 9: {
                    IO.fkTerminators[i] = new KeyValue(121, 0);
                    break;
                }
                case 10: {
                    IO.fkTerminators[i] = new KeyValue(122, 0);
                    break;
                }
                case 11: {
                    IO.fkTerminators[i] = new KeyValue(123, 0);
                    break;
                }
                case 12: {
                    IO.fkTerminators[i] = new KeyValue(112, 1);
                    break;
                }
                case 13: {
                    IO.fkTerminators[i] = new KeyValue(113, 1);
                    break;
                }
                case 14: {
                    IO.fkTerminators[i] = new KeyValue(114, 1);
                    break;
                }
                case 15: {
                    IO.fkTerminators[i] = new KeyValue(115, 1);
                    break;
                }
                case 16: {
                    IO.fkTerminators[i] = new KeyValue(116, 1);
                    break;
                }
                case 17: {
                    IO.fkTerminators[i] = new KeyValue(117, 1);
                    break;
                }
                case 18: {
                    IO.fkTerminators[i] = new KeyValue(118, 1);
                    break;
                }
                case 19: {
                    IO.fkTerminators[i] = new KeyValue(119, 1);
                    break;
                }
                case 20: {
                    IO.fkTerminators[i] = new KeyValue(120, 1);
                    break;
                }
                case 21: {
                    IO.fkTerminators[i] = new KeyValue(121, 1);
                    break;
                }
                case 22: {
                    IO.fkTerminators[i] = new KeyValue(122, 1);
                    break;
                }
                case 23: {
                    IO.fkTerminators[i] = new KeyValue(123, 1);
                    break;
                }
                case 24: {
                    IO.fkTerminators[i] = new KeyValue(112, 2);
                    break;
                }
                case 25: {
                    IO.fkTerminators[i] = new KeyValue(113, 2);
                    break;
                }
                case 26: {
                    IO.fkTerminators[i] = new KeyValue(114, 2);
                    break;
                }
                case 27: {
                    IO.fkTerminators[i] = new KeyValue(115, 2);
                    break;
                }
                case 28: {
                    IO.fkTerminators[i] = new KeyValue(116, 2);
                    break;
                }
                case 29: {
                    IO.fkTerminators[i] = new KeyValue(117, 2);
                    break;
                }
                case 30: {
                    IO.fkTerminators[i] = new KeyValue(118, 2);
                    break;
                }
                case 31: {
                    IO.fkTerminators[i] = new KeyValue(119, 2);
                    break;
                }
                case 32: {
                    IO.fkTerminators[i] = new KeyValue(120, 2);
                    break;
                }
                case 33: {
                    IO.fkTerminators[i] = new KeyValue(121, 2);
                    break;
                }
                case 34: {
                    IO.fkTerminators[i] = new KeyValue(122, 2);
                    break;
                }
                case 35: {
                    IO.fkTerminators[i] = new KeyValue(123, 2);
                    break;
                }
                case 36: {
                    IO.fkTerminators[i] = new KeyValue(112, 8);
                    break;
                }
                case 37: {
                    IO.fkTerminators[i] = new KeyValue(113, 8);
                    break;
                }
                case 38: {
                    IO.fkTerminators[i] = new KeyValue(114, 8);
                    break;
                }
                case 39: {
                    IO.fkTerminators[i] = new KeyValue(115, 8);
                    break;
                }
                case 40: {
                    IO.fkTerminators[i] = new KeyValue(116, 8);
                    break;
                }
                case 41: {
                    IO.fkTerminators[i] = new KeyValue(117, 8);
                    break;
                }
                case 42: {
                    IO.fkTerminators[i] = new KeyValue(118, 8);
                    break;
                }
                case 43: {
                    IO.fkTerminators[i] = new KeyValue(119, 8);
                    break;
                }
                case 44: {
                    IO.fkTerminators[i] = new KeyValue(120, 8);
                    break;
                }
                case 45: {
                    IO.fkTerminators[i] = new KeyValue(121, 8);
                    break;
                }
                case 46: {
                    IO.fkTerminators[i] = new KeyValue(122, 8);
                    break;
                }
                case 47: {
                    IO.fkTerminators[i] = new KeyValue(123, 8);
                }
            }
            ++index;
        }
    }

    private static boolean setupNormalTerminators() {
        String temp = RuntimeEnvironment.getGlobalParameter("TERMINATE");
        String modifier = null;
        String t2 = null;
        int comma = 0;
        KeyValue key = null;
        Class<KeyEvent> C2 = null;
        Field myField = null;
        Vector<KeyValue> terms = new Vector<KeyValue>();
        if (temp != null) {
            temp = temp.replace('-', '_');
        }
        String t = temp;
        while (t != null && comma >= 0 && comma < temp.length() - 1) {
            char c;
            t = temp = temp.substring(comma).trim();
            if ((comma = t.indexOf(44)) >= 0) {
                t = t.substring(0, comma).trim();
                ++comma;
            }
            modifier = null;
            t2 = t;
            int index = t2.indexOf("_");
            if (index >= 0) {
                modifier = t2.substring(0, index).trim().toUpperCase();
            }
            key = new KeyValue();
            if (modifier != null) {
                if (modifier.equals("CONTROL") || modifier.equals("CTRL")) {
                    key.setKeyModifier(2);
                    t2 = t2.substring(index + 1).trim();
                } else if (modifier.equals("ALT")) {
                    key.setKeyModifier(8);
                    t2 = t2.substring(index + 1).trim();
                } else if (modifier.equals("SHIFT")) {
                    key.setKeyModifier(1);
                    t2 = t2.substring(index + 1).trim();
                }
            }
            if (t2.length() == 1 && ((c = t2.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                if (modifier == null) {
                    key.setKeyChar(c);
                } else if (modifier.equals("SHIFT")) {
                    key.setKeyChar(t2.substring(0, 1).toUpperCase().charAt(0));
                }
            }
            t2 = "VK_" + t2.toUpperCase();
            C2 = KeyEvent.class;
            myField = null;
            try {
                myField = C2.getField(t2);
            }
            catch (NoSuchFieldException nfe) {
                myField = null;
            }
            if (myField == null) {
                CobolException.runtimeError("Bad TERMINATE value", "Unable to parse the TERMINATE value (" + t2 + ")", null);
                continue;
            }
            int code = 0;
            try {
                code = myField.getInt(null);
            }
            catch (IllegalAccessException nfe) {
                // empty catch block
            }
            key.setKeyCode(code);
            terms.addElement(key);
        }
        if (temp == null) {
            KeyValue k1 = new KeyValue('\r', 10, 0);
            normalTerminators = new KeyValue[1];
            IO.normalTerminators[0] = k1;
            return false;
        }
        normalTerminators = new KeyValue[terms.size()];
        for (int i = 0; i < terms.size(); ++i) {
            IO.normalTerminators[i] = (KeyValue)terms.elementAt(i);
        }
        return true;
    }

    public static void setFKTerminatorMap(int[] fkTermMap) {
        int max;
        if (fkTermMap == null) {
            return;
        }
        if (!terminatorsInitialized) {
            IO.initTerminatorArrays();
        }
        if (fkTerminatorMap == null) {
            fkTerminatorMap = new int[48];
        }
        if ((max = fkTermMap.length) > 48) {
            max = 48;
        }
        for (int i = 0; i < max; ++i) {
            IO.fkTerminatorMap[i] = fkTermMap[i];
        }
        IO.initTerminatorArrays();
    }

    public static void setFKTerminatorMapByKey(int[] fkKeyMap) {
        int i;
        if (fkKeyMap == null) {
            return;
        }
        int hi = -1;
        for (int i2 = 0; i2 < fkKeyMap.length; ++i2) {
            if (fkKeyMap[i2] <= hi) continue;
            hi = fkKeyMap[i2];
        }
        int[] fkTermMap = new int[hi];
        for (i = 0; i < hi; ++i) {
            fkTermMap[i] = 2;
        }
        for (i = 0; i < fkKeyMap.length; ++i) {
            int key = fkKeyMap[i] - 1;
            if (key < 0) continue;
            fkTermMap[key] = 1;
        }
        IO.setFKTerminatorMap(fkTermMap);
    }

    public static int[] getFKTerminatorMap() {
        if (!terminatorsInitialized) {
            IO.initTerminatorArrays();
        }
        return fkTerminatorMap;
    }

    public static int getNumFKTerminators() {
        if (!terminatorsInitialized) {
            IO.initTerminatorArrays();
        }
        return numTerminators;
    }

    public static KeyValue[] getNormalTerminators() {
        if (!terminatorsInitialized) {
            IO.initTerminatorArrays();
        }
        return normalTerminators;
    }

    public static KeyValue[] getFKTerminators() {
        if (!terminatorsInitialized) {
            IO.initTerminatorArrays();
        }
        return fkTerminators;
    }

    public static KeyValue[] getTerminators() {
        if (!terminatorsInitialized) {
            IO.initTerminatorArrays();
        }
        return allTerminators;
    }

    public static int getNumFKeys() {
        return 48;
    }

    public static boolean getWaitForTerminatorKey() {
        return waitForTerminatorKey;
    }

    public static void setWaitForTerminatorKey(boolean flag) {
        waitForTerminatorKey = flag;
    }

    public static boolean isKeyTerminatesField(KeyEvent evt) {
        KeyStrokeAction a = KeyStroke.getKeyStrokeAction(evt);
        if (a == null) {
            return IO.defaultIsKeyTerminatesField(evt);
        }
        if (a.isTerminating()) {
            return true;
        }
        return a.isEdit();
    }

    public static boolean isKeyTerminatesField(KeyValue kv) {
        KeyStrokeAction a = KeyStroke.getKeyStrokeAction(kv);
        if (a == null) {
            return IO.defaultIsKeyTerminatesField(kv);
        }
        if (a.isTerminating()) {
            return true;
        }
        return a.isEdit();
    }

    public static boolean isKeyTerminatesAccept(KeyEvent evt) {
        KeyStrokeAction a = KeyStroke.getKeyStrokeAction(evt);
        if (a == null) {
            return IO.defaultIsKeyTerminatesAccept(evt);
        }
        return a.isTerminating();
    }

    public static boolean isKeyTerminatesAccept(KeyValue kv) {
        KeyStrokeAction a = KeyStroke.getKeyStrokeAction(kv);
        if (a == null) {
            return IO.defaultIsKeyTerminatesAccept(kv);
        }
        return a.isTerminating();
    }

    public static boolean isEditToggleInsert(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 155 && val.getModifiers() == 0;
        }
        return a.isEditToggleInsert();
    }

    public static boolean isEditToggleInsert(KeyEvent val) {
        return IO.isEditToggleInsert(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditBackspace(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 8 && val.getModifiers() == 0;
        }
        return a.isEditBackspace();
    }

    public static boolean isEditBackspace(KeyEvent val) {
        return IO.isEditBackspace(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditDelete(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 127 && val.getModifiers() == 0;
        }
        return a.isEditDelete();
    }

    public static boolean isEditDelete(KeyEvent val) {
        return IO.isEditDelete(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditUp(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 38 && val.getModifiers() == 0;
        }
        return a.isEditUp();
    }

    public static boolean isEditUp(KeyEvent val) {
        return IO.isEditUp(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditDown(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 40 && val.getModifiers() == 0;
        }
        return a.isEditDown();
    }

    public static boolean isEditDown(KeyEvent val) {
        return IO.isEditDown(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditLeft(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 37 && val.getModifiers() == 0;
        }
        return a.isEditLeft();
    }

    public static boolean isEditLeft(KeyEvent val) {
        return IO.isEditLeft(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditRight(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 39 && val.getModifiers() == 0;
        }
        return a.isEditRight();
    }

    public static boolean isEditRight(KeyEvent val) {
        return IO.isEditRight(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditHome(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 36 && val.getModifiers() == 0;
        }
        return a.isEditHome();
    }

    public static boolean isEditHome(KeyEvent val) {
        return IO.isEditHome(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditEnd(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 35 && val.getModifiers() == 0;
        }
        return a.isEditEnd();
    }

    public static boolean isEditEnd(KeyEvent val) {
        return IO.isEditEnd(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToFirstField(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 36 && val.getModifiers() == 2;
        }
        return a.isEditMoveToFirstField();
    }

    public static boolean isEditMoveToFirstField(KeyEvent val) {
        return IO.isEditMoveToFirstField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToLastField(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 35 && val.getModifiers() == 2;
        }
        return a.isEditMoveToLastField();
    }

    public static boolean isEditMoveToLastField(KeyEvent val) {
        return IO.isEditMoveToLastField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToNextField(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 9 && val.getModifiers() == 0;
        }
        return a.isEditMoveToNextField();
    }

    public static boolean isEditMoveToNextField(KeyEvent val) {
        return IO.isEditMoveToNextField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToPreviousField(KeyStrokeAction a, KeyEvent val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 9 && val.getModifiers() == 1;
        }
        return a.isEditMoveToPreviousField();
    }

    public static boolean isEditMoveToPreviousField(KeyEvent val) {
        return IO.isEditMoveToPreviousField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditToggleInsert(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 155 && val.getModifiers() == 0;
        }
        return a.isEditToggleInsert();
    }

    public static boolean isEditToggleInsert(KeyValue val) {
        return IO.isEditToggleInsert(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditBackspace(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 8 && val.getModifiers() == 0;
        }
        return a.isEditBackspace();
    }

    public static boolean isEditBackspace(KeyValue val) {
        return IO.isEditBackspace(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditDelete(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 127 && val.getModifiers() == 0;
        }
        return a.isEditDelete();
    }

    public static boolean isEditDelete(KeyValue val) {
        return IO.isEditDelete(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditUp(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 38 && val.getModifiers() == 0;
        }
        return a.isEditUp();
    }

    public static boolean isEditUp(KeyValue val) {
        return IO.isEditUp(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditDown(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 40 && val.getModifiers() == 0;
        }
        return a.isEditDown();
    }

    public static boolean isEditDown(KeyValue val) {
        return IO.isEditDown(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditLeft(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 37 && val.getModifiers() == 0;
        }
        return a.isEditLeft();
    }

    public static boolean isEditLeft(KeyValue val) {
        return IO.isEditLeft(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditRight(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 39 && val.getModifiers() == 0;
        }
        return a.isEditRight();
    }

    public static boolean isEditRight(KeyValue val) {
        return IO.isEditRight(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditHome(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 36 && val.getModifiers() == 0;
        }
        return a.isEditHome();
    }

    public static boolean isEditHome(KeyValue val) {
        return IO.isEditHome(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditEnd(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 35 && val.getModifiers() == 0;
        }
        return a.isEditEnd();
    }

    public static boolean isEditEnd(KeyValue val) {
        return IO.isEditEnd(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToFirstField(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 36 && val.getModifiers() == 2;
        }
        return a.isEditMoveToFirstField();
    }

    public static boolean isEditMoveToFirstField(KeyValue val) {
        return IO.isEditMoveToFirstField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToLastField(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 35 && val.getModifiers() == 2;
        }
        return a.isEditMoveToLastField();
    }

    public static boolean isEditMoveToLastField(KeyValue val) {
        return IO.isEditMoveToLastField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToNextField(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 9 && val.getModifiers() == 0;
        }
        return a.isEditMoveToNextField();
    }

    public static boolean isEditMoveToNextField(KeyValue val) {
        return IO.isEditMoveToNextField(KeyStroke.getKeyStrokeAction(val), val);
    }

    public static boolean isEditMoveToPreviousField(KeyStrokeAction a, KeyValue val) {
        if (a == null || !a.isEdit()) {
            return val.getKeyCode() == 9 && val.getModifiers() == 1;
        }
        return a.isEditMoveToPreviousField();
    }

    public static boolean isEditMoveToPreviousField(KeyValue val) {
        return IO.isEditMoveToPreviousField(KeyStroke.getKeyStrokeAction(val), val);
    }

    private static boolean isDefaultEditKey(int keyCode) {
        switch (keyCode) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private static boolean defaultIsKeyTerminatesAccept(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c != '\b' && c < ' ') {
            return true;
        }
        KeyValue[] terminators = IO.getTerminators();
        if (terminators != null) {
            for (int i = 0; i < terminators.length; ++i) {
                KeyValue kv = terminators[i];
                if (kv == null || !kv.equals(evt)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean defaultIsKeyTerminatesAccept(KeyValue kv) {
        char c = kv.getKeyChar();
        if (c != '\b' && c < ' ') {
            return true;
        }
        KeyValue[] terminators = IO.getTerminators();
        if (terminators != null) {
            for (int i = 0; i < terminators.length; ++i) {
                KeyValue termKV = terminators[i];
                if (termKV == null || !termKV.equals(kv)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean defaultIsKeyTerminatesField(KeyEvent evt) {
        if (evt == null) {
            return false;
        }
        if (IO.isDefaultEditKey(evt.getKeyCode())) {
            return true;
        }
        return IO.defaultIsKeyTerminatesAccept(evt);
    }

    private static boolean defaultIsKeyTerminatesField(KeyValue kv) {
        if (kv == null) {
            return false;
        }
        if (IO.isDefaultEditKey(kv.getKeyCode())) {
            return true;
        }
        return IO.defaultIsKeyTerminatesAccept(kv);
    }

    public void setIOHandle(Handle h) {
        this.ioHandle = h;
    }

    public Handle getIOHandle() {
        return this.ioHandle;
    }

    public static IO allocateIO(Handle windowHandle) {
        return IO.allocateIO("CONSOLE:HANDLE_" + windowHandle.getHandleNumber());
    }

    private static IO allocateXOpenScreen(boolean hasGUI, boolean gosyserr, boolean gosysout) {
        return new XOpenScreen(hasGUI, gosyserr, gosysout);
    }

    private static IO allocateXOpenScreen() {
        return new XOpenScreen();
    }

    private static IO allocateIOInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return (IO)c.newInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static IO allocateIO(String name) {
        if (name == null) {
            return null;
        }
        String d = name;
        String fd = "";
        IO myIO = null;
        int index = d.indexOf(":");
        if (index >= 0) {
            if (index < d.length() - 1) {
                fd = d.substring(index + 1);
            }
            if ((myIO = openFiles.get(name = (d = d.substring(0, index).toUpperCase()) + ":" + fd)) != null) {
                return myIO;
            }
        } else {
            name = d = d.toUpperCase();
            myIO = openFiles.get(d);
            if (myIO != null) {
                return myIO;
            }
        }
        if (o != null) {
            myIO = o.get(d);
        }
        if (myIO == null) {
            if (i != null) {
                myIO = i.get(d);
            }
            if (myIO == null) {
                block47: {
                    if (i == null) {
                        i = new Hashtable();
                    }
                    if (o == null) {
                        o = new Hashtable();
                    }
                    if ("SYSTEM".equals(d) || "SYSOUT".equals(d) || "SYSIN".equals(d) || "STDOUT".equals(d) || "STDIN".equals(d)) {
                        myIO = IO.allocateXOpenScreen(false, false, true);
                        o.put("SYSTEM", myIO);
                        i.put("SYSTEM", myIO);
                        o.put("SYSOUT", myIO);
                        i.put("SYSIN", myIO);
                        o.put("STDOUT", myIO);
                        i.put("STDIN", myIO);
                    } else if ("SYSERR".equals(d) || "STDERR".equals(d)) {
                        myIO = IO.allocateXOpenScreen(false, true, false);
                        o.put("SYSERR", myIO);
                        o.put("STDERR", myIO);
                    } else if ("CONSOLE".equals(d)) {
                        myIO = IO.allocateXOpenScreen();
                        o.put("CONSOLE", myIO);
                        i.put("CONSOLE", myIO);
                    } else {
                        if ("SERVLET".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.ServletScreen");
                                o.put("SERVLET", myIO);
                                i.put("SERVLET", myIO);
                            }
                            catch (Throwable servletsNotPresent) {
                                myIO = o.get("SYSTEM");
                                if (myIO == null) {
                                    myIO = IO.allocateIO("SYSTEM");
                                }
                                if (myIO != null) {
                                    o.put("SERVLET", myIO);
                                    i.put("SERVLET", myIO);
                                }
                                break block47;
                            }
                        }
                        if ("I-O-FEEDBACK".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.AS400IOFeedback");
                                i.put("I-O-FEEDBACK", myIO);
                            }
                            catch (Throwable throwable) {}
                        } else if ("OPEN-FEEDBACK".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.AS400OpenFeedback");
                                i.put("OPEN-FEEDBACK", myIO);
                            }
                            catch (Throwable throwable) {}
                        } else if ("PIP-DATA".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.AS400PIPData");
                                i.put("PIP-DATA", myIO);
                            }
                            catch (Throwable throwable) {}
                        } else if ("ATTRIBUTE-DATA".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.AS400AttributeData");
                                i.put("ATTRIBUTE-DATA", myIO);
                            }
                            catch (Throwable throwable) {}
                        } else if ("DATA-AREA".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.AS400DataArea");
                                i.put("DATA-AREA", myIO);
                                o.put("DATA-AREA", myIO);
                            }
                            catch (Throwable throwable) {}
                        } else if ("LOCAL-DATA".equals(d)) {
                            try {
                                myIO = IO.allocateIOInstance("com.heirloomcomputing.ecs.exec.AS400LocalData");
                                i.put("LOCAL-DATA", myIO);
                                o.put("LOCAL-DATA", myIO);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (myIO == null) {
                    return null;
                }
            }
        }
        myIO = myIO.newInstance(fd);
        openFiles.put(name, myIO);
        return myIO;
    }

    public static Variable getCursor() {
        return cursor;
    }

    public static void setCursor(Variable myCursor) {
        cursor = myCursor;
    }

    public static Variable getWangCursor() {
        return wangCursor;
    }

    public static void setWangCursor(Variable v) {
        wangCursor = v;
    }

    public static Variable getWangPFKey() {
        return wangPFKey;
    }

    public static void setWangPFKey(Variable v) {
        wangPFKey = v;
    }

    public static Variable getCRTStatus() {
        return status;
    }

    public static void setCRTStatus(Variable myStatus) {
        status = myStatus;
    }

    public static void setScreenControl(Variable v) {
        try {
            acceptControl = null;
            controlValue = null;
            controlHandle = null;
            controlId = null;
            acceptControl = v.getChild();
            controlValue = acceptControl.getSibling();
            controlHandle = controlValue.getSibling();
            controlId = controlHandle.getSibling();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEventStatus(Variable v) {
        eventStatus = v;
        try {
            eventType = null;
            eventWindow = null;
            eventControlHandle = null;
            eventControlId = null;
            eventData1 = null;
            eventData2 = null;
            eventAction = null;
            eventType = v.getChild();
            eventWindow = eventType.getSibling();
            eventControlHandle = eventWindow.getSibling();
            eventControlId = eventControlHandle.getSibling();
            eventData1 = eventControlId.getSibling();
            eventData2 = eventData1.getSibling();
            eventAction = eventData2.getSibling();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void updateEventStatusToDefaults() {
        if (eventType != null) {
            eventType.move(0);
        }
        if (eventWindow != null) {
            eventWindow.move(Handle.NULL);
        }
        if (eventControlHandle != null) {
            eventControlHandle.move(Handle.NULL);
        }
        if (eventControlId != null) {
            eventControlId.move(0);
        }
        if (eventData1 != null) {
            eventData1.move(0);
        }
        if (eventData2 != null) {
            eventData2.move(0);
        }
        if (eventAction != null) {
            eventAction.move(0);
        }
    }

    private static boolean updateEventStatus(AcceptEvent evt) {
        try {
            if (evt == null) {
                IO.updateEventStatusToDefaults();
                return true;
            }
            try {
                if (eventType != null) {
                    eventType.move(evt.getEventType());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (eventWindow != null) {
                    eventWindow.move(evt.getWindow());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (eventControlHandle != null) {
                    eventControlHandle.move(evt.getControlHandle());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (eventControlId != null) {
                    eventControlId.move(evt.getControlId());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (eventData1 != null) {
                    eventData1.move(evt.getEventData1());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (eventData2 != null) {
                    eventData2.move(evt.getEventData2());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (eventAction != null) {
                    eventAction.move(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean updateStatus(AcceptEvent evt) {
        try {
            boolean result = IO.updateCRTStatus(evt);
            IO.updateEventStatus(evt);
            return result;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int processEventProcedure(AcceptEvent evt, ProcedurePointer p) {
        Object lockObject;
        if (evt == null || p == null) {
            return -1;
        }
        String buffer = null;
        int val = -1;
        Object object = lockObject = p.getLockObject();
        synchronized (object) {
            if (eventStatus != null) {
                buffer = eventStatus.toString();
            }
            IO.updateEventStatus(evt);
            p.perform();
            if (eventAction != null) {
                val = eventAction.toInt();
            }
            if (buffer != null) {
                eventStatus.setString(buffer);
            }
        }
        return val;
    }

    public static boolean updateStatus(KeyValue kv) {
        boolean result = IO.updateCRTStatus(kv);
        IO.updateEventStatus(null);
        return result;
    }

    public static boolean updateCRTStatus(AcceptEvent evt) {
        if (evt == null || evt.isTimeout()) {
            IO.setCRTStatusKey(3, 0, evt.getExceptionValue());
            return false;
        }
        if (evt.isExceptionCondition()) {
            IO.setCRTStatusKey(1, evt.getExceptionValue() & 0xFF, evt.getExceptionValue());
            return false;
        }
        if (evt.isKey()) {
            return IO.updateCRTStatus(new KeyValue((KeyEvent)evt.getEventObject()));
        }
        IO.setCRTStatusKey(0, 48, evt.getTerminationValue());
        return true;
    }

    private static int mapKeyCodeStyle(KeyValue terminator) {
        if (keyCodeStyle < 0) {
            keyCodeStyle = 3;
            try {
                String style = RuntimeEnvironment.getGlobalParameter("KEYCODESTYLE");
                if (style != null) {
                    if ("MF".equalsIgnoreCase(style)) {
                        keyCodeStyle = 2;
                    } else if ("JAVA".equalsIgnoreCase(style)) {
                        keyCodeStyle = 1;
                    } else if ("CHAR".equalsIgnoreCase(style)) {
                        keyCodeStyle = 0;
                    } else if ("OLD".equalsIgnoreCase(style)) {
                        keyCodeStyle = 0;
                    } else if ("ACU".equalsIgnoreCase(style)) {
                        keyCodeStyle = 3;
                    } else if ("ACUCOBOL".equalsIgnoreCase(style)) {
                        keyCodeStyle = 3;
                    } else if ("ACUCORP".equalsIgnoreCase(style)) {
                        keyCodeStyle = 3;
                    } else {
                        try {
                            keyCodeStyle = Integer.valueOf(style);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable t) {
                keyCodeStyle = 0;
            }
        }
        int ch = terminator.getKeyChar();
        if (keyCodeStyle == 1) {
            ch = (char)(terminator.getKeyCode() & 0xFF);
        } else if (keyCodeStyle == 2) {
            if (ch == 27 || ch == 65535) {
                int code = terminator.getKeyCode();
                if (ch == 27) {
                    ch = 0;
                } else if (code >= 112 && code <= 121) {
                    ch = (char)(code - 112 + 1);
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 1) {
                        ch += 10;
                    } else if (modifier == 2) {
                        ch += 20;
                    } else if (modifier == 8) {
                        ch += 30;
                    }
                } else if (code >= 122 && code <= 123) {
                    ch = (char)(code - 122 + 91);
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 1) {
                        ch += 2;
                    } else if (modifier == 2) {
                        ch += 4;
                    } else if (modifier == 8) {
                        ch += 6;
                    }
                } else if (code == 33) {
                    ch = 53;
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 2) {
                        ch = 55;
                    }
                } else if (code == 34) {
                    ch = 54;
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 2) {
                        ch = 56;
                    }
                }
            }
        } else if (keyCodeStyle == 3) {
            if (ch == 10) {
                ch = 13;
            } else if (ch == 65535) {
                int code = terminator.getKeyCode();
                if (code >= 112 && code <= 121) {
                    ch = (char)(code - 112 + 1);
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 1) {
                        ch += 10;
                    } else if (modifier == 2) {
                        ch += 20;
                    } else if (modifier == 8) {
                        ch += 30;
                    }
                } else if (code >= 122 && code <= 123) {
                    ch = (char)(code - 122 + 91);
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 1) {
                        ch += 2;
                    } else if (modifier == 2) {
                        ch += 4;
                    } else if (modifier == 8) {
                        ch += 6;
                    }
                } else if (code == 33) {
                    ch = 67;
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 2) {
                        ch = 55;
                    }
                } else if (code == 34) {
                    ch = 68;
                    int modifier = terminator.getKeyModifier();
                    if (modifier == 2) {
                        ch = 56;
                    }
                }
            }
        }
        return ch;
    }

    public static boolean updateCRTStatus(KeyValue terminator) {
        if (terminator == null) {
            IO.setCRTStatusKey(0, 49, 13);
            return true;
        }
        KeyStrokeAction a = KeyStroke.getKeyStrokeAction(terminator);
        if (a != null) {
            if (a.isException()) {
                IO.setCRTStatusKey(1, a.getException() & 0xFF, a.getException());
                return false;
            }
            IO.setCRTStatusKey(0, 48, a.getTermination());
            return true;
        }
        KeyValue[] n = IO.getNormalTerminators();
        for (int i = 0; i < n.length; ++i) {
            if (!terminator.equals(n[i])) continue;
            int ch = IO.mapKeyCodeStyle(terminator);
            IO.setCRTStatusKey(0, 48, ch);
            return true;
        }
        int[] map = IO.getFKTerminatorMap();
        int index = -1;
        switch (terminator.getKeyCode()) {
            case 112: {
                index = 0;
                break;
            }
            case 113: {
                index = 1;
                break;
            }
            case 114: {
                index = 2;
                break;
            }
            case 115: {
                index = 3;
                break;
            }
            case 116: {
                index = 4;
                break;
            }
            case 117: {
                index = 5;
                break;
            }
            case 118: {
                index = 6;
                break;
            }
            case 119: {
                index = 7;
                break;
            }
            case 120: {
                index = 8;
                break;
            }
            case 121: {
                index = 9;
                break;
            }
            case 122: {
                index = 10;
                break;
            }
            case 123: {
                index = 11;
                break;
            }
            case 27: {
                index = 27;
            }
        }
        if (index >= 0 && index < map.length) {
            if (index < 12) {
                if (terminator.getKeyModifier() == 1) {
                    index += 12;
                } else if (terminator.getKeyModifier() == 2) {
                    index += 24;
                } else if (terminator.getKeyModifier() == 8) {
                    index += 36;
                }
            }
            if (map[index] != 1) {
                int ch = IO.mapKeyCodeStyle(terminator);
                IO.setCRTStatusKey(2, index + 1, ch);
                return false;
            }
            int ch = IO.mapKeyCodeStyle(terminator);
            IO.setCRTStatusKey(1, index + 1, ch);
            return false;
        }
        IO.setCRTStatusKey(9, 0, 0);
        return false;
    }

    public static int getExternalCRTStatusKey1() {
        return externalCRTStatusKey1;
    }

    public static int getExternalCRTStatusKey2() {
        return externalCRTStatusKey2;
    }

    public static int getExternalCRTStatusKey3() {
        return externalCRTStatusKey3;
    }

    public static int getExternalLineNumber() {
        return externalLineNumber;
    }

    public static int getExternalColumnNumber() {
        return externalColumnNumber;
    }

    public static int getExternalKeyTerminatedInput() {
        return externalKeyTerminatedInput;
    }

    public static void setExternalCRTStatusKey1(int n) {
        externalCRTStatusKey1 = n;
    }

    public static void setExternalCRTStatusKey2(int n) {
        externalCRTStatusKey2 = n;
    }

    public static void setExternalCRTStatusKey3(int n) {
        externalCRTStatusKey3 = n;
    }

    public static void setExternalLineNumber(int n) {
        externalLineNumber = n;
    }

    public static void setExternalColumnNumber(int n) {
        externalColumnNumber = n;
    }

    public static void setExternalKeyTerminatedInput(int n) {
        externalKeyTerminatedInput = n;
    }

    public static final boolean isOperatorPressedTerminatorKey() {
        return externalCRTStatusKey1 == 0 && externalCRTStatusKey2 == 0;
    }

    public static final boolean isAutoSkipOutOfLastField() {
        return externalCRTStatusKey1 == 0 && externalCRTStatusKey2 == 1;
    }

    public static final boolean isUserDefinedFunctionKey() {
        return externalCRTStatusKey1 == 1;
    }

    public static final boolean isImplementationDependentFunctionKey() {
        return externalCRTStatusKey1 == 2;
    }

    public static final int getControlKey() {
        return IO.getExternalKeyTerminatedInput();
    }

    public static boolean setCRTStatusKey(int number, int number2, int number3) {
        externalCRTStatusKey1 = number;
        externalCRTStatusKey2 = number2;
        externalCRTStatusKey3 = number3;
        IO.setExternalKeyTerminatedInput(number3);
        if (status == null) {
            return false;
        }
        if (status instanceof Numeric) {
            status.move(number3);
            return true;
        }
        if (number != 0 && number != 1 && number != 2 && number != 9) {
            return false;
        }
        status.flushToMemory();
        if (BINARY_CRTKEY1 < 0) {
            BINARY_CRTKEY1 = 0;
            try {
                String s = RuntimeEnvironment.getGlobalParameter("CRTKEY1");
                if (s != null && (s = s.toUpperCase()).startsWith("B")) {
                    BINARY_CRTKEY1 = 1;
                }
            }
            catch (Throwable t) {
                BINARY_CRTKEY1 = 0;
            }
        }
        if (BINARY_CRTKEY1 > 0) {
            status.setChar(0, (char)number);
        } else {
            status.setChar(0, (char)(48 + number));
        }
        if (number2 < 0 || number2 > 255) {
            return false;
        }
        if (wangPFKey != null && number2 > 0 && number2 < 49) {
            wangPFKey.move(number2);
        }
        if (status.length() < 2) {
            return true;
        }
        if (keyCodeStyle == 2 && number == 1) {
            status.setChar(1, (char)number3);
        } else {
            status.setChar(1, (char)number2);
        }
        if (status.length() < 3) {
            return true;
        }
        status.setChar(2, (char)number3);
        return true;
    }

    public static int getCRTStatusKey1() {
        if (status == null) {
            return -1;
        }
        status.flushToMemory();
        char digit = status.getChar(0);
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        return digit;
    }

    public static boolean setCRTStatusKey1(int number) {
        IO.setExternalCRTStatusKey1(number);
        if (status == null) {
            return false;
        }
        if (number != 0 && number != 1 && number != 2 && number != 9) {
            return false;
        }
        status.flushToMemory();
        if (BINARY_CRTKEY1 < 0) {
            BINARY_CRTKEY1 = 0;
            try {
                String s = RuntimeEnvironment.getGlobalParameter("CRTKEY1");
                if (s != null && (s = s.toUpperCase()).startsWith("B")) {
                    BINARY_CRTKEY1 = 1;
                }
            }
            catch (Throwable t) {
                BINARY_CRTKEY1 = 0;
            }
        }
        if (BINARY_CRTKEY1 > 0) {
            status.setChar(0, (char)number);
        } else {
            status.setChar(0, (char)(48 + number));
        }
        return true;
    }

    public static int getCRTStatusKey2() {
        if (status == null) {
            return -1;
        }
        status.flushToMemory();
        return status.getChar(1);
    }

    public static boolean setCRTStatusKey2(int number) {
        IO.setExternalCRTStatusKey2(number);
        if (number < 0 || number > 255) {
            return false;
        }
        if (wangPFKey != null && number > 0 && number < 49) {
            wangPFKey.move(number);
        }
        if (status == null) {
            return false;
        }
        status.flushToMemory();
        status.setChar(1, (char)number);
        return true;
    }

    public static int getCRTStatusKey3() {
        return -1;
    }

    public static boolean setCRTStatusKey3(int number) {
        return false;
    }

    public static int getCursorColumn() {
        if (cursor == null) {
            return -1;
        }
        int column = -1;
        if (cursor.length() == 4) {
            try {
                column = Integer.valueOf(cursor.toString().substring(2));
            }
            catch (Exception exception) {}
        } else if (cursor.length() == 6) {
            try {
                column = Integer.valueOf(cursor.toString().substring(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return column;
    }

    public static int getCursorLine() {
        if (cursor == null) {
            return -1;
        }
        int line = -1;
        if (cursor.length() == 4) {
            try {
                line = Integer.valueOf(cursor.toString().substring(0, 2));
            }
            catch (Exception exception) {}
        } else if (cursor.length() == 6) {
            try {
                line = Integer.valueOf(cursor.toString().substring(0, 3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return line;
    }

    public static boolean setCursorColumn(int column) {
        IO.setExternalColumnNumber(column);
        if (cursor == null || column < 0) {
            return false;
        }
        if (wangCursor != null) {
            wangCursor.flushToMemory();
            wangCursor.setChar(1, (char)column);
        }
        String number = "" + column;
        String filler = "000";
        if (cursor.length() == 4) {
            if (number.length() > 2) {
                return false;
            }
            String curCol = cursor.toString();
            curCol = curCol.substring(0, 2);
            number = filler + number;
            curCol = curCol + number.substring(number.length() - 2, number.length());
            cursor.move(curCol);
        } else if (cursor.length() == 6) {
            if (number.length() > 3) {
                return false;
            }
            String curCol = cursor.toString();
            curCol = curCol.substring(0, 3);
            number = filler + number;
            curCol = curCol + number.substring(number.length() - 3, number.length());
            cursor.move(curCol);
        }
        return true;
    }

    public static boolean setCursorLine(int line) {
        IO.setExternalLineNumber(line);
        if (cursor == null || line < 0) {
            return false;
        }
        if (wangCursor != null) {
            wangCursor.flushToMemory();
            wangCursor.setChar(3, (char)line);
        }
        String number = "" + line;
        String filler = "000";
        if (cursor.length() == 4) {
            if (number.length() > 2) {
                return false;
            }
            String curCol = cursor.toString();
            curCol = curCol.substring(2);
            number = filler + number;
            curCol = number.substring(number.length() - 2, number.length()) + curCol;
            cursor.move(curCol);
        } else if (cursor.length() == 6) {
            if (number.length() > 3) {
                return false;
            }
            String curCol = cursor.toString();
            curCol = curCol.substring(3);
            number = filler + number;
            curCol = number.substring(number.length() - 3, number.length()) + curCol;
            cursor.move(curCol);
        }
        return true;
    }

    public static void using(Variable v, Variable from, Variable to) {
        if (v == null) {
            return;
        }
        v.setFromVariable(from);
        v.setToVariable(to);
    }

    public static void using(Variable v, Object from, Object to) {
        if (v == null) {
            return;
        }
        v.setFromVariable(from);
        v.setToVariable(to);
    }

    public Variable getFromVariable(Variable v) {
        return v != null ? v.getFromVariable() : null;
    }

    public Variable getToVariable(Variable v) {
        return v != null ? v.getToVariable() : null;
    }

    public static void setScreen(Variable v) {
    }

    public static void removeScreen(Variable v) {
        v.removeScreenProperty();
    }

    public static boolean isScreen(Variable v) {
        return v.isScreen();
    }

    public static void setProperty(Variable v, ScreenProperty p) {
        v.setScreen();
        v.setScreenProperty(p);
    }

    public static void setForegroundColor(Variable v, int value) {
        try {
            ScreenProperty p = v.getScreenProperty();
            if (p != null) {
                p.setForegroundColor(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setBackgroundColor(Variable v, int value) {
        try {
            ScreenProperty p = v.getScreenProperty();
            if (p != null) {
                p.setBackgroundColor(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setPropertyMask(Variable v, int mask) {
        try {
            ScreenProperty p = v.getScreenProperty();
            if (p != null) {
                p.setProperties(p.getProperties() | mask);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clearPropertyMask(Variable v, int mask) {
        try {
            ScreenProperty p = v.getScreenProperty();
            if (p != null) {
                p.setProperties(p.getProperties() & ~mask);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasProperties(Variable v) {
        return v.hasScreenProperty();
    }

    public static ScreenProperty getProperty(Variable v) {
        return v.getScreenProperty();
    }

    protected String filter(String s) {
        String changed = null;
        int len = s.length();
        int lastprintable = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch >= ' ' || ch == '\r' || ch == '\n') continue;
            if (i > lastprintable) {
                changed = changed == null ? s.substring(lastprintable, i) : changed + s.substring(lastprintable, i);
            } else if (changed == null) {
                changed = "";
            }
            lastprintable = i + 1;
            changed = changed + " ";
        }
        if (changed == null) {
            return s;
        }
        changed = changed + s.substring(lastprintable, len);
        return changed;
    }

    public static boolean isOpen(String filedesc) {
        return openFiles.get(filedesc) != null;
    }

    public static void deallocateIO(String filedesc) {
        IO myIO = null;
        myIO = openFiles.get(filedesc);
        if (myIO != null) {
            myIO.end();
            openFiles.remove(filedesc);
        }
    }

    public static void deallocateIO(IO myIO) {
        IO tempIO = null;
        String elem = null;
        Enumeration<String> enumer = openFiles.keys();
        while (enumer.hasMoreElements()) {
            elem = enumer.nextElement();
            tempIO = openFiles.get(elem);
            if (tempIO == null || tempIO != myIO) continue;
            myIO.end();
            openFiles.remove(elem);
        }
    }

    public static void deallocateIO() {
        Enumeration<IO> enumer = openFiles.elements();
        while (enumer.hasMoreElements()) {
            IO myIO = enumer.nextElement();
            myIO.end();
        }
        openFiles.clear();
    }

    private static void addShutdownHook() {
        Shutdown.addShutdownHook(new Thread(){

            @Override
            public void run() {
                IO.deallocateIO();
            }
        });
    }

    public final synchronized void write(byte[] d, int off, int len) {
        char[] myArray = new char[len];
        for (int i = 0; i < len; ++i) {
            myArray[i] = (char)d[off];
            ++off;
        }
        this.write(myArray, 0, len);
    }

    public final synchronized void write(char[] d, int off, int len) {
        this.displayNoAdvancing(new String(d, off, len));
    }

    public synchronized boolean getChar(Variable v) {
        KeyValue kv = this.getChar();
        if (kv == null) {
            return false;
        }
        char[] myArray = new char[7];
        char c = kv.getKeyChar();
        myArray[0] = (char)(c & 0xFF);
        myArray[1] = (char)(c >> 8 & 0xFF);
        myArray[2] = (char)(kv.getKeyModifier() & 0xFF);
        int code = kv.getKeyCode();
        myArray[3] = (char)(code & 0xFF);
        myArray[4] = (char)((code >>= 8) & 0xFF);
        myArray[5] = (char)((code >>= 8) & 0xFF);
        myArray[6] = (char)((code >>= 8) & 0xFF);
        v.move(myArray);
        return true;
    }

    public String getTitle() {
        return this.titleString;
    }

    public void setTitle(String message) {
        this.titleString = message;
    }

    public boolean display(ISpecialNames program, String text, float line, float column, boolean advance) {
        return this.display(text, line, column, advance);
    }

    public boolean display(ISpecialNames program, String text, float line, float column, boolean advance, ScreenProperty p) {
        return this.display(text, line, column, advance, p);
    }

    public boolean display(ISpecialNames program, Variable v, float line, float column, boolean advance) {
        return this.display(v, line, column, advance);
    }

    public boolean display(ISpecialNames program, Handle h) {
        return this.display(h);
    }

    public boolean display(ISpecialNames program, Handle h, float line, float column) {
        return this.display(h, line, column);
    }

    public boolean display(ISpecialNames program, Handle h, float line, float column, ScreenProperty p) {
        return this.display(h, line, column, p);
    }

    public boolean display(ISpecialNames program, Variable v, float line, float column, ScreenProperty p) {
        return this.display(v, line, column, p);
    }

    public boolean display(ISpecialNames program, String text, float line, float column, ScreenProperty props) {
        return this.display(text, line, column, props);
    }

    public synchronized boolean display(String text) {
        return this.display(text, -1.0f, -1.0f, true, null);
    }

    public synchronized boolean display(String text, int line, int column) {
        return this.display(text, line, (float)column, true, null);
    }

    public synchronized boolean display(String text, float line, float column) {
        return this.display(text, line, column, true, null);
    }

    public synchronized boolean display(String text, float line, float column, boolean advance) {
        return this.display(text, line, column, advance, null);
    }

    public synchronized boolean display(String text, int line, int column, ScreenProperty props) {
        return this.display(text, (float)line, (float)column, props);
    }

    public synchronized boolean display(String text, int line, int column, boolean advance) {
        return this.display(text, line, (float)column, advance, null);
    }

    public synchronized boolean display(Variable v) {
        return this.display(v, -1, -1, true);
    }

    public synchronized boolean display(Variable v, int line, int column) {
        return this.display(v, line, column, true);
    }

    public synchronized boolean display(Variable v, int line, int column, ScreenProperty props) {
        return this.display(v, (float)line, (float)column, props);
    }

    public synchronized boolean display(Variable v, int line, int column, boolean advance) {
        return this.display(v, (float)line, (float)column, advance);
    }

    public synchronized boolean display(Variable v, float line, float column) {
        return this.display(v, line, column, true);
    }

    public synchronized boolean displayNoAdvancing(String text) {
        return this.display(text, -1.0f, -1.0f, false, null);
    }

    public synchronized boolean displayNoAdvancing(String text, int line, int column) {
        return this.display(text, line, (float)column, false, null);
    }

    public synchronized boolean displayNoAdvancing(String text, float line, float column) {
        return this.display(text, line, column, false, null);
    }

    public synchronized boolean displayNoAdvancing(Variable v) {
        return this.display(v, -1, -1, false);
    }

    public synchronized boolean displayNoAdvancing(Variable v, int line, int column) {
        return this.display(v, line, column, false);
    }

    public synchronized boolean displayNoAdvancing(Variable v, float line, float column) {
        return this.display(v, line, column, false);
    }

    public synchronized boolean display(String text, Variable line, Variable column) {
        return this.display(text, line.toFloat(), column.toFloat(), true, null);
    }

    public synchronized boolean display(String text, Variable line, Variable column, ScreenProperty props) {
        return this.display(text, line.toFloat(), column.toFloat(), props);
    }

    public synchronized boolean display(String text, Variable line, Variable column, boolean advance) {
        return this.display(text, line.toFloat(), column.toFloat(), advance, null);
    }

    public synchronized boolean display(Variable v, Variable line, Variable column) {
        return this.display(v, line.toFloat(), column.toFloat(), true);
    }

    public synchronized boolean display(Variable v, Variable line, Variable column, ScreenProperty props) {
        return this.display(v, line.toFloat(), column.toFloat(), props);
    }

    public synchronized boolean display(Variable v, Variable line, Variable column, boolean advance) {
        return this.display(v, line.toFloat(), column.toFloat(), advance);
    }

    public synchronized boolean displayNoAdvancing(String text, Variable line, Variable column) {
        return this.display(text, line.toFloat(), column.toFloat(), false, null);
    }

    public synchronized boolean displayNoAdvancing(Variable v, Variable line, Variable column) {
        return this.display(v, line.toFloat(), column.toFloat(), false);
    }

    public synchronized boolean display(String text, float line, Variable column) {
        return this.display(text, line, column.toFloat(), true, null);
    }

    public synchronized boolean display(String text, float line, Variable column, ScreenProperty props) {
        return this.display(text, line, column.toFloat(), props);
    }

    public synchronized boolean display(String text, float line, Variable column, boolean advance) {
        return this.display(text, line, column.toFloat(), advance, null);
    }

    public synchronized boolean display(Variable v, float line, Variable column) {
        return this.display(v, line, column.toFloat(), true);
    }

    public synchronized boolean display(Variable v, float line, Variable column, ScreenProperty props) {
        return this.display(v, line, column.toFloat(), props);
    }

    public synchronized boolean display(Variable v, float line, Variable column, boolean advance) {
        return this.display(v, line, column.toFloat(), advance);
    }

    public synchronized boolean displayNoAdvancing(String text, float line, Variable column) {
        return this.display(text, line, column.toFloat(), false, null);
    }

    public synchronized boolean displayNoAdvancing(Variable v, float line, Variable column) {
        return this.display(v, line, column.toFloat(), false);
    }

    public synchronized boolean display(String text, Variable line, float column) {
        return this.display(text, line.toFloat(), column, true, null);
    }

    public synchronized boolean display(String text, Variable line, float column, ScreenProperty props) {
        return this.display(text, line.toFloat(), column, props);
    }

    public synchronized boolean display(String text, Variable line, float column, boolean advance) {
        return this.display(text, line.toFloat(), column, advance);
    }

    public synchronized boolean display(Variable v, Variable line, float column) {
        return this.display(v, line.toFloat(), column, true);
    }

    public synchronized boolean display(Variable v, Variable line, float column, ScreenProperty props) {
        return this.display(v, line.toFloat(), column, props);
    }

    public synchronized boolean display(Variable v, Variable line, float column, boolean advance) {
        return this.display(v, line.toFloat(), column, advance);
    }

    public synchronized boolean displayNoAdvancing(String text, Variable line, float column) {
        return this.display(text, line.toFloat(), column, false, null);
    }

    public synchronized boolean displayNoAdvancing(Variable v, Variable line, float column) {
        return this.display(v, line.toFloat(), column, false);
    }

    public synchronized boolean display(ISpecialNames program, String text) {
        return this.display(program, text, -1, -1, true);
    }

    public synchronized boolean display(ISpecialNames program, String text, int line, int column) {
        return this.display(program, text, line, column, true);
    }

    public synchronized boolean display(ISpecialNames program, String text, float line, float column) {
        return this.display(program, text, line, column, true);
    }

    public synchronized boolean display(ISpecialNames program, String text, int line, int column, ScreenProperty props) {
        return this.display(program, text, (float)line, (float)column, props);
    }

    public synchronized boolean display(ISpecialNames program, String text, int line, int column, boolean advance) {
        return this.display(program, text, (float)line, (float)column, advance);
    }

    public synchronized boolean display(ISpecialNames program, Variable v) {
        return this.display(program, v, -1, -1, true);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, int line, int column) {
        return this.display(program, v, line, column, true);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, int line, int column, ScreenProperty props) {
        return this.display(program, v, (float)line, (float)column, props);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, int line, int column, boolean advance) {
        return this.display(program, v, (float)line, (float)column, advance);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, float line, float column) {
        return this.display(program, v, line, column, true);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, String text) {
        return this.display(program, text, -1, -1, false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, String text, int line, int column) {
        return this.display(program, text, line, column, false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, String text, float line, float column) {
        return this.display(program, text, line, column, false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, Variable v) {
        return this.display(program, v, -1, -1, false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, Variable v, int line, int column) {
        return this.display(program, v, line, column, false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, Variable v, float line, float column) {
        return this.display(program, v, line, column, false);
    }

    public synchronized boolean display(ISpecialNames program, String text, Variable line, Variable column) {
        return this.display(program, text, line.toFloat(), column.toFloat(), true);
    }

    public synchronized boolean display(ISpecialNames program, String text, Variable line, Variable column, ScreenProperty props) {
        return this.display(program, text, line.toFloat(), column.toFloat(), props);
    }

    public synchronized boolean display(ISpecialNames program, String text, Variable line, Variable column, boolean advance) {
        return this.display(program, text, line.toFloat(), column.toFloat(), advance);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, Variable line, Variable column) {
        return this.display(program, v, line.toFloat(), column.toFloat(), true);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, Variable line, Variable column, ScreenProperty props) {
        return this.display(program, v, line.toFloat(), column.toFloat(), props);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, Variable line, Variable column, boolean advance) {
        return this.display(program, v, line.toFloat(), column.toFloat(), advance);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, String text, Variable line, Variable column) {
        return this.display(program, text, line.toFloat(), column.toFloat(), false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, Variable v, Variable line, Variable column) {
        return this.display(program, v, line.toFloat(), column.toFloat(), false);
    }

    public synchronized boolean display(ISpecialNames program, String text, float line, Variable column) {
        return this.display(program, text, line, column.toFloat(), true);
    }

    public synchronized boolean display(ISpecialNames program, String text, float line, Variable column, ScreenProperty props) {
        return this.display(program, text, line, column.toFloat(), props);
    }

    public synchronized boolean display(ISpecialNames program, String text, float line, Variable column, boolean advance) {
        return this.display(program, text, line, column.toFloat(), advance);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, float line, Variable column) {
        return this.display(program, v, line, column.toFloat(), true);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, float line, Variable column, ScreenProperty props) {
        return this.display(program, v, line, column.toFloat(), props);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, float line, Variable column, boolean advance) {
        return this.display(program, v, line, column.toFloat(), advance);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, String text, float line, Variable column) {
        return this.display(program, text, line, column.toFloat(), false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, Variable v, float line, Variable column) {
        return this.display(program, v, line, column.toFloat(), false);
    }

    public synchronized boolean display(ISpecialNames program, String text, Variable line, float column) {
        return this.display(program, text, line.toFloat(), column, true);
    }

    public synchronized boolean display(ISpecialNames program, String text, Variable line, float column, ScreenProperty props) {
        return this.display(program, text, line.toFloat(), column, props);
    }

    public synchronized boolean display(ISpecialNames program, String text, Variable line, float column, boolean advance) {
        return this.display(program, text, line.toFloat(), column, advance);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, Variable line, float column) {
        return this.display(program, v, line.toFloat(), column, true);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, Variable line, float column, ScreenProperty props) {
        return this.display(program, v, line.toFloat(), column, props);
    }

    public synchronized boolean display(ISpecialNames program, Variable v, Variable line, float column, boolean advance) {
        return this.display(program, v, line.toFloat(), column, advance);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, String text, Variable line, float column) {
        return this.display(program, text, line.toFloat(), column, false);
    }

    public synchronized boolean displayNoAdvancing(ISpecialNames program, Variable v, Variable line, float column) {
        return this.display(program, v, line.toFloat(), column, false);
    }

    public abstract boolean display(String var1, float var2, float var3, boolean var4, ScreenProperty var5);

    public abstract boolean display(Variable var1, float var2, float var3, boolean var4);

    public abstract boolean display(Handle var1);

    public abstract boolean display(Handle var1, float var2, float var3);

    public abstract boolean display(Handle var1, float var2, float var3, ScreenProperty var4);

    public synchronized boolean display(Variable v, float line, float column, ScreenProperty p) {
        if (IO.isScreen(v)) {
            return this.display(v, line, column);
        }
        Handle h = v.getHandle();
        if (h != null) {
            return this.display(h, line, column, p);
        }
        if (p == null) {
            return this.display(v, line, column);
        }
        String textString = p.isSize() ? v.toNationalString(p.getSize()) : v.toNationalString();
        return this.display(textString, line, column, p);
    }

    public synchronized boolean display(String text, float line, float column, ScreenProperty props) {
        if (props != null) {
            if (column >= 0.0f) {
                if (props.isColumnRelative()) {
                    props.setColumn(column + 1.0f);
                    column = 0.0f;
                }
            } else if (line > 0.0f) {
                column = 1.0f;
            }
            if (line >= 0.0f) {
                if (props.isLineRelative()) {
                    props.setLine(line);
                    line = 0.0f;
                }
            } else {
                line = 0.0f;
            }
        }
        return this.display(text, line, column, true, props);
    }

    private void setupAccept(ISpecialNames specialNames) {
        if (specialNames == null) {
            return;
        }
        try {
            IO.setCRTStatus((Variable)specialNames.getCrtStatus());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IO.setCursor((Variable)specialNames.getCursor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IO.setEventStatus((Variable)specialNames.getEventStatus());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IO.setScreenControl((Variable)specialNames.getScreenControl());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetAccept() {
        IO.setCRTStatus(null);
        IO.setCursor(null);
        IO.setEventStatus(null);
        IO.setScreenControl(null);
    }

    private void processEventQueue() {
        ThreadQueue.suspendCurrentOnLock();
    }

    public abstract boolean accept(Variable var1, float var2, float var3, long var4);

    public abstract boolean acceptOmitted(long var1);

    public abstract String accept(int var1, long var2);

    public synchronized boolean accept(Variable v) {
        return this.accept(v, -1, -1, -1L);
    }

    public synchronized boolean accept(Variable v, long timeout) {
        return this.accept(v, -1, -1, timeout);
    }

    public synchronized boolean accept(Variable v, int line, int column) {
        boolean result = this.accept(v, (float)line, (float)column, -1L);
        this.processEventQueue();
        return result;
    }

    public synchronized boolean accept(Variable v, int line, int column, long timeout) {
        boolean result = this.accept(v, (float)line, (float)column, timeout);
        this.processEventQueue();
        return result;
    }

    public synchronized boolean accept(Variable v, float line, float column) {
        boolean result = this.accept(v, line, column, -1L);
        this.processEventQueue();
        return result;
    }

    public synchronized boolean accept(Variable v, int line, int column, ScreenProperty props) {
        return this.accept(v, (float)line, (float)column, props);
    }

    public synchronized boolean accept(Variable v, Variable line, int column, ScreenProperty props) {
        return this.accept(v, line.toFloat(), (float)column, props);
    }

    public synchronized boolean accept(Variable v, int line, Variable column, ScreenProperty props) {
        return this.accept(v, (float)line, column.toFloat(), props);
    }

    public synchronized boolean accept(Variable v, Variable line, Variable column, ScreenProperty props) {
        return this.accept(v, line.toFloat(), column.toFloat(), props);
    }

    public synchronized boolean accept(Variable v, Variable line, float column, ScreenProperty props) {
        return this.accept(v, line.toFloat(), column, props);
    }

    public synchronized boolean accept(Variable v, float line, Variable column, ScreenProperty props) {
        return this.accept(v, line, column.toFloat(), props);
    }

    public synchronized boolean accept(Variable v, float line, float column, ScreenProperty props) {
        return this.accept(v, line, column, -1L, props);
    }

    public synchronized boolean accept(Variable v, int line, int column, long timeout, ScreenProperty props) {
        return this.accept(v, (float)line, (float)column, timeout, props);
    }

    public synchronized boolean accept(Variable v, float line, int column, long timeout, ScreenProperty props) {
        return this.accept(v, line, (float)column, timeout, props);
    }

    public synchronized boolean accept(Variable v, Variable line, int column, long timeout, ScreenProperty props) {
        return this.accept(v, line.toFloat(), (float)column, timeout, props);
    }

    public synchronized boolean accept(Variable v, int line, float column, long timeout, ScreenProperty props) {
        return this.accept(v, (float)line, column, timeout, props);
    }

    public synchronized boolean accept(Variable v, Variable line, float column, long timeout, ScreenProperty props) {
        return this.accept(v, line.toFloat(), column, timeout, props);
    }

    public synchronized boolean accept(Variable v, int line, Variable column, long timeout, ScreenProperty props) {
        return this.accept(v, (float)line, column.toFloat(), timeout, props);
    }

    public synchronized boolean accept(Variable v, float line, Variable column, long timeout, ScreenProperty props) {
        return this.accept(v, line, column.toFloat(), timeout, props);
    }

    public synchronized boolean accept(Variable v, Variable line, Variable column, long timeout, ScreenProperty props) {
        return this.accept(v, line.toFloat(), column.toFloat(), timeout, props);
    }

    public synchronized boolean accept(Variable v, float line, float column, long timeout, ScreenProperty props) {
        if (props == null) {
            return this.accept(v, line, column, timeout);
        }
        Variable temporaryScreen = new Variable();
        Variable hold = v.getSibling();
        v.setSibling(null);
        boolean isScreen = IO.isScreen(v);
        if (!isScreen) {
            if (column >= 0.0f) {
                if (props.isColumnRelative()) {
                    props.setColumn(column + 1.0f);
                    column = 0.0f;
                }
            } else if (line > 0.0f) {
                column = 1.0f;
            }
            if (line >= 0.0f) {
                if (props.isLineRelative()) {
                    props.setLine(line);
                    line = 0.0f;
                }
            } else {
                line = 0.0f;
            }
        }
        temporaryScreen.setChild(v);
        IO.setProperty(temporaryScreen, props);
        int currentLine = IO.getCursorLine();
        int currentColumn = IO.getCursorColumn();
        boolean result = this.accept(temporaryScreen, line, column);
        if (!isScreen) {
            IO.setCursorLine(currentLine);
            IO.setCursorColumn(currentColumn);
        }
        v.setSibling(hold);
        IO.removeScreen(temporaryScreen);
        this.processEventQueue();
        return result;
    }

    public synchronized boolean accept(ISpecialNames program, Variable v) {
        return this.accept(program, v, -1.0f, -1.0f, -1L);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, long timeout) {
        return this.accept(program, v, -1.0f, -1.0f, timeout);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, int line, int column) {
        return this.accept(program, v, (float)line, (float)column, -1L);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, float line, float column) {
        return this.accept(program, v, line, column, -1L);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, int line, int column, ScreenProperty props) {
        return this.accept(program, v, (float)line, (float)column, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, Variable line, int column, ScreenProperty props) {
        return this.accept(program, v, line.toFloat(), (float)column, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, int line, Variable column, ScreenProperty props) {
        return this.accept(program, v, (float)line, column.toFloat(), props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, Variable line, Variable column, ScreenProperty props) {
        return this.accept(program, v, line.toFloat(), column.toFloat(), props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, Variable line, float column, ScreenProperty props) {
        return this.accept(program, v, line.toFloat(), column, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, float line, Variable column, ScreenProperty props) {
        return this.accept(program, v, line, column.toFloat(), props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, int line, int column, long timeout, ScreenProperty props) {
        return this.accept(program, v, (float)line, (float)column, timeout, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, Variable line, int column, long timeout, ScreenProperty props) {
        return this.accept(program, v, line.toFloat(), (float)column, timeout, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, int line, Variable column, long timeout, ScreenProperty props) {
        return this.accept(program, v, (float)line, column.toFloat(), timeout, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, Variable line, Variable column, long timeout, ScreenProperty props) {
        return this.accept(program, v, line.toFloat(), column.toFloat(), timeout, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, Variable line, float column, long timeout, ScreenProperty props) {
        return this.accept(program, v, line.toFloat(), column, timeout, props);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, float line, Variable column, long timeout, ScreenProperty props) {
        return this.accept(program, v, line, column.toFloat(), timeout, props);
    }

    public boolean accept(ISpecialNames program, Variable v, float line, float column, long timeout) {
        this.setupAccept(program);
        boolean result = this.accept(v, line, column, timeout);
        this.resetAccept();
        this.processEventQueue();
        return result;
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, float line, float column, ScreenProperty props) {
        this.setupAccept(program);
        boolean result = this.accept(v, line, column, props);
        this.resetAccept();
        return result;
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, float line, float column, long timeout, ScreenProperty props) {
        this.setupAccept(program);
        boolean result = this.accept(v, line, column, timeout, props);
        this.resetAccept();
        return result;
    }

    public synchronized boolean accept(Handle h) {
        return this.accept(h, -1.0f, -1.0f, -1L, null);
    }

    public synchronized boolean accept(Handle h, float line, float column) {
        return this.accept(h, line, column, -1L, null);
    }

    public synchronized boolean accept(Handle h, float line, float column, long timeout) {
        return this.accept(h, line, column, timeout, null);
    }

    public boolean accept(ISpecialNames program, Handle h) {
        return this.accept(program, h, -1.0f, -1.0f, -1L, null);
    }

    public boolean accept(ISpecialNames program, Handle h, float line, float column) {
        return this.accept(program, h, line, column, -1L, null);
    }

    public boolean accept(ISpecialNames program, Handle h, float line, float column, long timeout) {
        return this.accept(program, h, line, column, timeout, null);
    }

    public boolean accept(ISpecialNames program, Handle h, float line, float column, long timeout, ScreenProperty props) {
        this.setupAccept(program);
        boolean result = this.accept(h, line, column, timeout, props);
        this.resetAccept();
        return result;
    }

    public boolean accept(Handle h, float line, float column, long timeout, ScreenProperty props) {
        Binary temporaryScreen = new Binary(h, true);
        if (props == null) {
            props = new ScreenProperty();
        }
        if (column >= 0.0f) {
            if (props.isColumnRelative()) {
                props.setColumn(column + 1.0f);
                column = 0.0f;
            }
        } else if (line > 0.0f) {
            column = 1.0f;
        }
        if (line >= 0.0f) {
            if (props.isLineRelative()) {
                props.setLine(line);
                line = 0.0f;
            }
        } else {
            line = 0.0f;
        }
        IO.setProperty(temporaryScreen, props);
        int currentLine = IO.getCursorLine();
        int currentColumn = IO.getCursorColumn();
        boolean result = this.accept((Variable)temporaryScreen, line, column);
        IO.setCursorLine(currentLine);
        IO.setCursorColumn(currentColumn);
        IO.removeScreen(temporaryScreen);
        this.processEventQueue();
        return result;
    }

    public synchronized String accept(int length) {
        return this.accept(length, -1L);
    }

    public String accept(ISpecialNames program, int length, long timeout) {
        this.setupAccept(program);
        String result = this.accept(length, timeout);
        this.resetAccept();
        this.processEventQueue();
        return result;
    }

    public synchronized boolean acceptFree(ISpecialNames program, Variable v) {
        return this.accept(program, v, -1.0f, -1.0f, -1L);
    }

    public synchronized boolean acceptFree(ISpecialNames program, Variable v, long timeout) {
        return this.accept(program, v, -1.0f, -1.0f, timeout);
    }

    public synchronized boolean acceptOmitted() {
        boolean result = this.acceptOmitted(-1L);
        this.processEventQueue();
        return result;
    }

    public synchronized boolean acceptOmitted(ISpecialNames program) {
        this.setupAccept(program);
        boolean result = this.acceptOmitted(-1L);
        this.resetAccept();
        this.processEventQueue();
        return result;
    }

    public boolean acceptOmitted(ISpecialNames program, long timeout) {
        this.setupAccept(program);
        boolean result = this.acceptOmitted(timeout);
        this.resetAccept();
        this.processEventQueue();
        return result;
    }

    public String acceptScreen(int position) {
        int size = position / 7500;
        int column = (position %= 7500) / 50;
        int line = position % 50;
        return this.acceptScreen(line, column, size);
    }

    public String acceptScreen(int line, int column, int size) {
        return Variable.all(' ', size);
    }

    protected abstract KeyValue getChar();

    public abstract IO newInstance(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO console() {
        Object object = lockObject;
        synchronized (object) {
            if (consoleIO == null) {
                consoleIO = IO.allocateIO("CONSOLE");
            }
            return consoleIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO system() {
        Object object = lockObject;
        synchronized (object) {
            if (systemIO == null) {
                systemIO = IO.allocateIO("SYSTEM");
            }
            return systemIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO syserr() {
        Object object = lockObject;
        synchronized (object) {
            if (syserrIO == null) {
                syserrIO = IO.allocateIO("SYSERR");
            }
            return syserrIO;
        }
    }

    public static IO servlet() {
        return IO.system();
    }

    public static IO printer() {
        return IO.system();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO ioFeedback() {
        Object object = lockObject;
        synchronized (object) {
            if (ioFeedback == null) {
                ioFeedback = IO.allocateIO("I-O-FEEDBACK");
            }
            return ioFeedback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO openFeedback() {
        Object object = lockObject;
        synchronized (object) {
            if (openFeedback == null) {
                openFeedback = IO.allocateIO("OPEN-FEEDBACK");
            }
            return openFeedback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO dataArea() {
        Object object = lockObject;
        synchronized (object) {
            if (dataArea == null) {
                dataArea = IO.allocateIO("DATA-AREA");
            }
            return dataArea;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO localData() {
        Object object = lockObject;
        synchronized (object) {
            if (localData == null) {
                localData = IO.allocateIO("LOCAL-DATA");
            }
            return localData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO pipData() {
        Object object = lockObject;
        synchronized (object) {
            if (pipData == null) {
                pipData = IO.allocateIO("PIP-DATA");
            }
            return pipData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO attributeData() {
        Object object = lockObject;
        synchronized (object) {
            if (attributeData == null) {
                attributeData = IO.allocateIO("ATTRIBUTE-DATA");
            }
            return attributeData;
        }
    }

    public static void setCurrentIO() {
        IO.setCurrentIO(IO.console());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentIO(IO param) {
        Object object = lockObject;
        synchronized (object) {
            currentIO = param;
        }
    }

    public static void setCurrentIO(Handle h) {
        IO.setCurrentIO(h.getIO());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO current() {
        Object object = lockObject;
        synchronized (object) {
            if (currentIO == null) {
                currentIO = IO.console();
            }
            return currentIO;
        }
    }

    public static IO getCurrentIONoCreate() {
        return currentIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO active() {
        Object object = lockObject;
        synchronized (object) {
            return IO.getActiveIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IO getActiveIO() {
        Object object = lockObject;
        synchronized (object) {
            return activeIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveIO(IO param) {
        Object object = lockObject;
        synchronized (object) {
            activeIO = param;
            IO.setCurrentIO(param);
        }
    }

    public static void setActiveIO(Handle h) {
        IO.setActiveIO(h.getIO());
    }

    public static void setActiveIO() {
        IO.setActiveIO(IO.console());
    }

    public static void setCurrentlyRegisteredWindow(Handle window) {
        currentlyRegistered = window;
    }

    public static Handle getCurrentlyRegisteredWindow() {
        return currentlyRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWindow(Handle windowHandle) {
        Class<IO> clazz = IO.class;
        synchronized (IO.class) {
            IO.setCurrentlyRegisteredWindow(windowHandle);
            IO io = windowHandle.getIO();
            if (io == null) {
                try {
                    io = IO.allocateIO(windowHandle);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (io != null) {
                    io.setIOHandle(windowHandle);
                    windowHandle.setIO(io);
                    io.display(windowHandle);
                }
            }
            if (currentIO == null) {
                IO.setCurrentIO(io);
            }
            IO.setCurrentlyRegisteredWindow(null);
            IO.setActiveIO(io);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static final String format(int n, int digits) {
        if (digits <= 0) {
            return "";
        }
        String result = String.valueOf(n);
        if (result.length() == digits) {
            return result;
        }
        if (result.length() > digits) {
            return result.substring(0, digits);
        }
        int deficitDigits = digits - result.length();
        char[] deficit = new char[deficitDigits];
        for (int i = 0; i < deficitDigits; ++i) {
            deficit[i] = 48;
        }
        return new StringBuffer(digits).append(deficit).append(result).toString();
    }

    private static char[] acucompx2(int value) {
        char[] result = new char[]{(char)(value >> 8 & 0xFF), (char)(value & 0xFF)};
        return result;
    }

    public String acceptTerminalInfo() {
        String terminalName = this.getClass().getName();
        boolean reverse = true;
        boolean blink = false;
        boolean underline = true;
        boolean dualIntensity = true;
        boolean columns132 = false;
        boolean color2 = true;
        boolean lineDrawing = false;
        int screenLines = 25;
        int screenColumns = 80;
        boolean localPrinter = true;
        boolean visibleAttributes = false;
        boolean graphicalInterface = true;
        int usableScreenHeight = 0;
        int usableScreenWidth = 0;
        int physicalScreenHeight = 0;
        int physicalScreenWidth = 0;
        try {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            usableScreenHeight = d.height;
            usableScreenWidth = d.width;
            physicalScreenHeight = d.height;
            physicalScreenWidth = d.width;
        }
        catch (Throwable d) {
            // empty catch block
        }
        terminalName = (terminalName + "          ").substring(0, 10);
        String result = new StringBuffer(34).append(terminalName).append(reverse ? (char)'Y' : 'N').append(blink ? (char)'Y' : 'N').append(underline ? (char)'Y' : 'N').append(dualIntensity ? (char)'Y' : 'N').append(columns132 ? (char)'Y' : 'N').append(color2 ? (char)'Y' : 'N').append(lineDrawing ? (char)'Y' : 'N').append(IO.format(screenLines, 3)).append(IO.format(screenColumns, 3)).append(localPrinter ? (char)'Y' : 'N').append(visibleAttributes ? (char)'Y' : 'N').append(graphicalInterface ? (char)'Y' : 'N').append(IO.acucompx2(usableScreenHeight)).append(IO.acucompx2(usableScreenWidth)).append(IO.acucompx2(physicalScreenHeight)).append(IO.acucompx2(physicalScreenWidth)).toString();
        return result;
    }

    public boolean display(String text, String FOR, String library, boolean lock2, int AT) {
        return this.display(text);
    }

    public boolean display(ISpecialNames program, String text, String FOR, String library, boolean lock2, int AT) {
        return this.display(text, FOR, library, lock2, AT);
    }

    public boolean display(String text, String FOR) {
        return this.display(text);
    }

    public boolean display(ISpecialNames program, String text, String FOR) {
        return this.display(text, FOR);
    }

    public synchronized boolean accept(Variable v, String device) {
        return this.accept(v);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, String device) {
        this.setupAccept(program);
        boolean result = this.accept(v, device);
        this.resetAccept();
        return result;
    }

    public synchronized boolean accept(Variable v, String device, String transactionFile) {
        return this.accept(v);
    }

    public synchronized boolean accept(ISpecialNames program, Variable v, String device, String transactionFile) {
        this.setupAccept(program);
        boolean result = this.accept(v, device, transactionFile);
        this.resetAccept();
        return result;
    }

    private static void output(String text) {
        System.out.println(text);
    }

    private ScreenHandler initializeTerminalOfType(int n, boolean debugMe) {
        int defaultBG;
        int defaultFG;
        ScreenHandler result;
        block19: {
            result = null;
            com.heirloomcomputing.term.Utilities.setCustomParameterTable(RuntimeEnvironment.getGlobalRuntimeEnvironment().getProperties());
            defaultFG = 2;
            defaultBG = 0;
            try {
                int val;
                String dbg;
                int val2;
                String dfg = RuntimeEnvironment.getGlobalParameter("CONSOLEFG");
                if (dfg != null && (val2 = ScreenProperty.getColorFromString(dfg)) >= 0) {
                    defaultFG = val2;
                }
                if ((dbg = RuntimeEnvironment.getGlobalParameter("CONSOLEBG")) != null && (val = ScreenProperty.getColorFromString(dbg)) >= 0) {
                    defaultBG = val;
                }
            }
            catch (Throwable dfg) {
                // empty catch block
            }
            try {
                if (n == 0) {
                    if (debugMe) {
                        IO.output("Attempting to initialize GUI based terminal");
                    }
                    result = new GUIHandler(null, ScreenProperty.getColorObject(defaultFG), ScreenProperty.getColorObject(defaultBG), Utilities.getLines(), Utilities.getColumns());
                    Shutdown.exitWhenFinished(false);
                } else if (n == 1) {
                    if (debugMe) {
                        IO.output("Attempting to initialize curses based terminal");
                    }
                    result = new CursesHandler();
                    Shutdown.exitWhenFinished(true);
                } else if (n == 2) {
                    if (debugMe) {
                        IO.output("Attempting to initialize SYSOUT based terminal");
                    }
                    result = new SysoutHandler();
                } else if (n == 3) {
                    if (debugMe) {
                        IO.output("Attempting to initialize SYSERR based terminal");
                    }
                    result = new SyserrHandler();
                }
                if (debugMe) {
                    IO.output("Initialization was successful");
                }
            }
            catch (Throwable t) {
                if (!debugMe) break block19;
                IO.output("Unable to initialize terminal.");
                t.printStackTrace(System.out);
            }
        }
        if (result != null) {
            result.setDefaultColors(defaultFG, defaultBG);
        }
        return result;
    }

    protected ScreenHandler initializeTerm(boolean hasGUI) {
        return this.initializeTerm(hasGUI, false, false);
    }

    protected ScreenHandler initializeTerm(boolean hasGUI, boolean gosyserr, boolean gosysout) {
        boolean debugMe = RuntimeEnvironment.isGlobalParameter("DEBUGGFX");
        boolean useCursesAnyway = RuntimeEnvironment.isGlobalParameter("USECURSES");
        ScreenHandler myTerm = null;
        if (gosyserr) {
            return this.initializeTerminalOfType(3, debugMe);
        }
        if (gosysout) {
            return this.initializeTerminalOfType(2, debugMe);
        }
        if (!hasGUI || hasGUI && useCursesAnyway && !Utilities.isApplet()) {
            if (debugMe) {
                IO.output("GUI capable environment = " + hasGUI);
                IO.output("Override to use curses as default = " + useCursesAnyway);
            }
            if ((myTerm = this.initializeTerminalOfType(1, debugMe)) == null) {
                myTerm = this.initializeTerminalOfType(2, debugMe);
            }
            return myTerm;
        }
        if (debugMe) {
            IO.output("GUI capable environment = " + hasGUI);
        }
        if ((myTerm = this.initializeTerminalOfType(0, debugMe)) == null) {
            myTerm = this.initializeTerminalOfType(1, debugMe);
        }
        if (myTerm == null) {
            myTerm = this.initializeTerminalOfType(2, debugMe);
        }
        return myTerm;
    }

    private void end() {
        if (this.screenHandler != null) {
            this.screenHandler.end();
            this.screenHandler = null;
        }
    }

    ScreenHandler getScreenHandlerIfPresent() {
        return this.screenHandler;
    }

    ScreenHandler getScreenHandler() {
        return this.getScreenHandler(false);
    }

    ScreenHandler getScreenHandler(boolean useWindowColors) {
        return this.getScreenHandler(true, null, false, false, useWindowColors);
    }

    ScreenHandler getScreenHandler(String title) {
        return this.getScreenHandler(true, title, false, false, false);
    }

    protected ScreenHandler getScreenHandler(boolean hasGUI, String title, boolean gosyserr, boolean gosysout) {
        return this.getScreenHandler(hasGUI, title, gosyserr, gosysout, false);
    }

    protected ScreenHandler getScreenHandler(boolean hasGUI, String title, boolean gosyserr, boolean gosysout, boolean useWindowColors) {
        if (this.screenHandler != null) {
            return this.screenHandler;
        }
        this.screenHandler = !gosyserr && !gosysout ? this.initializeTerm(hasGUI) : this.initializeTerm(hasGUI, gosyserr, gosysout);
        if (this.screenHandler == null) {
            return null;
        }
        boolean bl = this.screenHandlerIsGraphical = this.screenHandler.getPanelForWindow() != null;
        if (this.screenHandlerIsGraphical) {
            if (useWindowColors) {
                Utilities.associateNewTextPaneWithWindow(this.screenHandler, title, true);
            } else {
                Utilities.associateNewTextPaneWithWindow(this.screenHandler, title, ScreenProperty.getColorObject(this.screenHandler.getDefaultFG()), ScreenProperty.getColorObject(this.screenHandler.getDefaultBG()));
            }
        }
        this.screenHandler.clearScreen();
        this.screenHandler.refresh();
        return this.screenHandler;
    }

    public boolean isGraphical() {
        return this.screenHandlerIsGraphical;
    }

    static void attachScreenHandler(Object program) {
        try {
            Method m;
            ScreenHandler screenHandler;
            try {
                String lines = RuntimeEnvironment.getGlobalParameter("LINES");
                String columns = RuntimeEnvironment.getGlobalParameter("COLUMNS");
                if (lines == null && columns == null) {
                    Utilities.setLines(26);
                    Utilities.setColumns(80);
                }
            }
            catch (Exception lines) {
                // empty catch block
            }
            if ("GFX".equalsIgnoreCase(RuntimeEnvironment.getGlobalParameter("VIEWJ_MODE"))) {
                try {
                    screenHandler = IO.current().getScreenHandler(true);
                }
                catch (Exception e) {
                    screenHandler = IO.current().getScreenHandler();
                }
            } else {
                screenHandler = IO.current().getScreenHandler();
            }
            if ((m = program.getClass().getMethod("setScreenHandler", ScreenHandler.class)) == null) {
                return;
            }
            m.invoke(program, screenHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        numTerminators = 48;
        openFiles = new Hashtable();
        externalLineNumber = 1;
        externalColumnNumber = 1;
        IO.addShutdownHook();
    }
}

