/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exception.EcProgramNotFound;
import com.heirloomcomputing.ecs.exec.Dialog;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Shutdown;

public class IPCException
extends EcProgramNotFound {
    private static boolean VERBOSE_CALL = false;
    private Throwable nestedException;
    private String message;

    public IPCException(String name) {
        this.message = name;
        if (VERBOSE_CALL && name != null && name.startsWith("*") && !Dialog.showYesNoDialog("IPC Exception: Continue Execution?", name.substring(1))) {
            Shutdown.exit(10);
        }
        this.setExceptionStatement("CALL");
    }

    public IPCException(Throwable nestedException) {
        this(nestedException.toString());
        this.nestedException = nestedException;
        this.setExceptionStatement("CALL");
        this.setExceptionObject(nestedException);
    }

    public IPCException(Throwable nestedException, String message) {
        this(message);
        this.nestedException = nestedException;
        this.setExceptionStatement("CALL");
        this.setExceptionObject(nestedException);
    }

    public Throwable getIPCException() {
        return this.nestedException;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDescription() {
        return this.message;
    }

    static {
        VERBOSE_CALL = RuntimeEnvironment.isGlobalParameter("VERBOSE-CALL");
    }
}

