/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.BignumType;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.isam.ISAM;
import com.heirloomcomputing.isam.ISAMKey;
import com.heirloomcomputing.isam.ISAMRecord;
import java.math.BigDecimal;
import java.net.InetAddress;

public class ISAMConnect {
    public static final boolean debugMode = false;
    public static final int COMMIT_CONTEXT_PROGRAMMED = 0;
    public static final int COMMIT_CONTEXT_UNKNOWN = 1;
    public static final int COMMIT_CONTEXT_NO_TRX = 2;
    public static final int ROLLBACK_CONTEXT_PROGRAMMED = 0;
    public static final int ROLLBACK_CONTEXT_UNKNOWN = 1;
    public static final int ROLLBACK_CONTEXT_NO_TRX = 2;
    public static final int Finput = 0;
    public static final int Foutput = 1;
    public static final int Fio = 2;
    public static final int Fextend = 3;
    public static final int Fmulti_lock = 16;
    public static final int Fread_lock = 256;
    public static final int Fwrite_lock = 512;
    public static final int Fmass_update = 1536;
    public static final int Ftrans = 16384;
    public static final int F_EQUALS = 0;
    public static final int F_NOT_LESS = 1;
    public static final int F_GREATER = 2;
    public static final int F_LESS = 3;
    public static final int F_NOT_GREATER = 4;
    public static final int E_SYS_ERR = 1;
    public static final int E_PARAM_ERR = 2;
    public static final int E_TOO_MANY_FILES = 3;
    public static final int E_MODE_CLASH = 4;
    public static final int E_REC_LOCKED = 5;
    public static final int E_BROKEN = 6;
    public static final int E_DUPLICATE = 7;
    public static final int E_NOT_FOUND = 8;
    public static final int E_UNDEF_RECORD = 9;
    public static final int E_DISK_FULL = 10;
    public static final int E_FILE_LOCKED = 11;
    public static final int E_REC_CHANGED = 12;
    public static final int E_MISMATCH = 13;
    public static final int E_NO_MEMORY = 14;
    public static final int E_MISSING_FILE = 15;
    public static final int E_PERMISSION = 16;
    public static final int E_NO_SUPPORT = 17;
    public static final int E_NO_LOCKS = 18;
    public static final int E_INTERFACE = 19;
    public static final int E_LICENSE_ERR = 20;
    public static final int E_UNKNOWN_ERR = 21;
    public static final int W_NO_SUPPORT = 100;
    public static final int W_DUP_OK = 101;
    public static final int E_LOG_EXTERNAL = 1;
    public static final int E_LOG_TOO_MANY = 2;
    public static final int E_LOG_MISSING = 3;
    public static final int E_LOG_PERMISSION = 4;
    public static final int E_LOG_SYS_ERR = 5;
    public static final int E_LOG_CORRUPT = 6;
    public static final int E_LOG_LOCKED = 7;
    public static final int E_LOG_NO_MEMORY = 8;
    public static final int E_LOG_DISK_FULL = 9;
    public static final int E_NO_LOG = 10;
    public static final int E_RB_LOG_CORRUPT = 11;
    public static final int E_LOG_INCOMPLETE = 12;
    public static final int E_OPEN_NOT_LOGGED = 13;
    public static final int E_LOG_INTERFACE = 14;
    public static final int E_LOG_REMOTE = 15;
    public static final int E_LOG_NESTED_START = 16;
    public static final int E_LOG_TEMP = 17;
    public static final int W_LOG_NO_SUPPORT = 100;
    public static final int G_OK = 0;
    public static final int G_CONT = -1;
    public static final int G_CALL_NOTFOUND = -1;
    public static final int G_FILE_NOTFOUND = -1;
    public static final int G_STOP_RUN = -2;
    public static final int G_SOCKET_ERROR = -3;
    public static final int G_FILE_ERROR = -3;
    public static final int G_SYNC_NODEF = -4;
    public static final int G_COBOL_ERROR = -5;
    public static final int G_CONNECT_FAIL = -6;
    public static final int G_ERR_PWD = -7;
    public static final int G_TIMEOUT = -8;
    public static final int G_MISSING = 1;
    public static final int G_NOT_COBOL = 2;
    public static final int G_INTERNAL = 3;
    public static final int G_MEMORY = 4;
    public static final int G_VERSION = 5;
    public static final int G_RECURSIVE = 6;
    public static final int G_EXTERNAL = 7;
    public static final int G_LARGE_MODEL = 8;
    public static final int G_ECONNREFUSED = 25;
    public static final int G_JAPANESE = 14;
    static final String USER = "USER";
    public static final int EPERM = 1;
    public static final int ENOENT = 2;
    public static final int ESRCH = 3;
    public static final int EINTR = 4;
    public static final int EIO = 5;
    public static final int ENXIO = 6;
    public static final int E2BIG = 7;
    public static final int ENOEXEC = 8;
    public static final int EBADF = 9;
    public static final int ECHILD = 10;
    public static final int EAGAIN = 11;
    public static final int ENOMEM = 12;
    public static final int EACCES = 13;
    public static final int EFAULT = 14;
    public static final int ENOTBLK = 15;
    public static final int EBUSY = 16;
    public static final int EEXIST = 17;
    public static final int EXDEV = 18;
    public static final int ENODEV = 19;
    public static final int ENOTDIR = 20;
    public static final int EISDIR = 21;
    public static final int EINVAL = 22;
    public static final int ENFILE = 23;
    public static final int EMFILE = 24;
    public static final int ENOTTY = 25;
    public static final int ETXTBSY = 26;
    public static final int EFBIG = 27;
    public static final int ENOSPC = 28;
    public static final int ESPIPE = 29;
    public static final int EROFS = 30;
    public static final int EMLINK = 31;
    public static final int EPIPE = 32;
    public static final int EDOM = 33;
    public static final int ERANGE = 34;
    public static final int ENOMSG = 35;
    public static final int EIDRM = 36;
    public static final int ECHRNG = 37;
    public static final int EL2NSYNC = 38;
    public static final int EL3HLT = 39;
    public static final int EL3RST = 40;
    public static final int ELNRNG = 41;
    public static final int EUNATCH = 42;
    public static final int ENOCSI = 43;
    public static final int EL2HLT = 44;
    public static final int EDEADLK = 45;
    public static final int ENOLCK = 46;
    public static final int EBADE = 50;
    public static final int EBADR = 51;
    public static final int EXFULL = 52;
    public static final int ENOANO = 53;
    public static final int EBADRQC = 54;
    public static final int EBADSLT = 55;
    public static final int EDEADLOCK = 56;
    public static final int EBFONT = 57;
    public static final int ENOSTR = 60;
    public static final int ENODATA = 61;
    public static final int ETIME = 62;
    public static final int ENOSR = 63;
    public static final int ENONET = 64;
    public static final int ENOPKG = 65;
    public static final int EREMOTE = 66;
    public static final int ENOLINK = 67;
    public static final int EADV = 68;
    public static final int ESRMNT = 69;
    public static final int ECOMM = 70;
    public static final int EPROTO = 71;
    public static final int EMULTIHOP = 74;
    public static final int ELBIN = 75;
    public static final int EDOTDOT = 76;
    public static final int EBADMSG = 77;
    public static final int ENOTUNIQ = 80;
    public static final int EBADFD = 81;
    public static final int EREMCHG = 82;
    public static final int ELIBACC = 83;
    public static final int ELIBBAD = 84;
    public static final int ELIBSCN = 85;
    public static final int ELIBMAX = 86;
    public static final int ELIBEXEC = 87;
    public static final int ENOSYS = 88;
    public static final int ENMFILE = 89;
    public static final int ENOTEMPTY = 90;
    public static final int ENAMETOOLONG = 91;
    public static final int ELOOP = 92;
    public static final int EOPNOTSUPP = 95;
    public static final int EPFNOSUPPORT = 96;
    private boolean isTrace = false;
    private String host = "127.0.0.1";
    private boolean connected = false;
    private int returnCode = 0;
    private int errno = 0;
    private int f_no_lock = 0;
    private String comment = "";
    private String logical_params = "";
    private int maximum = 0;
    private int minimum = 0;
    private int numberOfKeys = 0;
    private Variable masterRecord = null;
    private Variable[] keyArray = null;
    private int[] keyLength = null;
    private boolean[] keyDuplicates = null;
    private int[] keyOffsets = null;
    private int lastKeynum = 0;
    private static final int[] errnoMap = new int[]{7, 4, 2, 2, 3, 6, 11, 5, 7, 7, 8, 8, 9, 11, 2, 1, 14};

    private static final void debug(String text) {
        System.out.println("ISAMConnect: " + text);
    }

    private static final void trace(String text) {
        System.out.println("ISAMConnect: " + text);
    }

    public boolean isTrace() {
        return this.isTrace;
    }

    public void setTrace(boolean flag) {
        this.isTrace = flag;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void setConnected(boolean flag) {
        this.connected = flag;
    }

    public int getErrno() {
        return this.errno;
    }

    private void setErrno(int val) {
        this.errno = val;
    }

    public int getF_NO_LOCK() {
        return this.f_no_lock;
    }

    public void setF_NO_LOCK(int val) {
        this.f_no_lock = val;
    }

    public int getNumberOfKeys() {
        return this.numberOfKeys;
    }

    private void setNumberOfKeys(int val) {
        this.numberOfKeys = val;
    }

    public int getMaximumRecordSize() {
        return this.maximum;
    }

    private void setMaximumRecordSize(int val) {
        this.maximum = val;
    }

    public int getMinimumRecordSize() {
        return this.minimum;
    }

    private void setMinimumRecordSize(int val) {
        this.minimum = val;
    }

    public static int strchr(String buff, char initChar) {
        return ISAMConnect.strchr(buff, 0, initChar);
    }

    public static int strchr(String buff, int offset, char initChar) {
        if (offset < 0) {
            return -1;
        }
        while (offset >= 0 && offset < buff.length() && buff.charAt(offset) != '\u0000' && buff.charAt(offset) != initChar) {
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(String buff, int offset, char[] chars) {
        char c;
        if (offset < 0) {
            return -1;
        }
        while (offset < buff.length() && (c = buff.charAt(offset)) != '\u0000') {
            int i;
            for (i = 0; i < chars.length && c != chars[i]; ++i) {
            }
            if (i != chars.length) continue;
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(StringBuffer buff, int offset, char initChar) {
        while (offset >= 0 && offset < buff.length() && buff.charAt(offset) != '\u0000' && buff.charAt(offset) != initChar) {
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strchr(StringBuffer buff, int offset, char[] chars) {
        char c;
        if (offset < 0) {
            return -1;
        }
        while (offset < buff.length() && (c = buff.charAt(offset)) != '\u0000') {
            int i;
            for (i = 0; i < chars.length && c != chars[i]; ++i) {
            }
            if (i != chars.length) continue;
            ++offset;
        }
        if (offset == buff.length()) {
            return -1;
        }
        return offset;
    }

    public static int strstr(String buff, int offset, String initString) {
        if (offset < 0) {
            return -1;
        }
        int nullOffset = buff.substring(offset).indexOf(0);
        int strOffset = buff.substring(offset).indexOf(initString);
        if (nullOffset < 0 || strOffset < 0) {
            return strOffset;
        }
        if (nullOffset < strOffset) {
            return -1;
        }
        return strOffset;
    }

    private String getSubstring(String text, int offset) {
        if (text == null) {
            return null;
        }
        int start = offset;
        while (offset < text.length() && text.charAt(offset) != '\u0000') {
            ++offset;
        }
        if (offset == start) {
            return text;
        }
        if (offset == text.length()) {
            return text.substring(start);
        }
        return text.substring(start, offset);
    }

    public static final String getHostnameFromString(String text) {
        String[] result = ISAMConnect.getHostnameAndFilenameFromString(text);
        if (result == null) {
            return null;
        }
        return result[0];
    }

    public static final String getFilenameFromString(String text) {
        String[] result = ISAMConnect.getHostnameAndFilenameFromString(text);
        if (result == null) {
            return null;
        }
        return result[1];
    }

    public static final String convertBackslashesToForwardSlashes(String n) {
        int offset = 0;
        int offsetN = 0;
        StringBuffer buff = new StringBuffer(n);
        while ((offset = ISAMConnect.strchr(buff, offsetN, '\\')) >= 0) {
            buff.setCharAt(offset, '/');
            offsetN = offset;
        }
        return buff.toString();
    }

    public static final String[] getHostnameAndFilenameFromString(String text) {
        if (text == null) {
            return null;
        }
        String[] result = new String[2];
        String path = text;
        String hostname = null;
        int offset = ISAMConnect.strchr(path = ISAMConnect.convertBackslashesToForwardSlashes(path), 0, ':');
        if (offset > 1) {
            hostname = path.substring(0, offset);
        } else if (offset >= 0) {
            hostname = null;
        }
        if (offset >= 0 && offset < path.length() - 1) {
            path = path.substring(offset + 1);
        }
        result[0] = hostname;
        result[1] = ISAMConnect.trimExtension(path);
        return result;
    }

    private static String trimExtension(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        if (!name.trim().endsWith(".dat")) {
            return name;
        }
        return name.substring(0, index);
    }

    private void parseLogicalParams(String params) {
        String text;
        if (params == null) {
            return;
        }
        int index = params.indexOf(44);
        if (index > 0) {
            text = params.substring(0, index).trim();
            try {
                this.maximum = Integer.valueOf(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                params = params.substring(index + 1);
            }
            catch (Exception e) {
                return;
            }
        }
        if ((index = params.indexOf(44)) > 0) {
            text = params.substring(0, index).trim();
            try {
                this.minimum = Integer.valueOf(text);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                params = params.substring(index + 1);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private String getUserName() {
        String pntUser = RuntimeEnvironment.getGlobalParameter("USERNAME");
        if (pntUser == null) {
            pntUser = RuntimeEnvironment.getGlobalParameter(USER);
        }
        if (this.isTrace()) {
            ISAMConnect.trace("login:  Username='" + pntUser + "'");
        }
        return pntUser;
    }

    private String getLocalHostname() {
        String localHostName = null;
        String explicitHost = RuntimeEnvironment.getGlobalParameter("LOCALHOST");
        if (explicitHost != null) {
            localHostName = explicitHost;
        } else {
            InetAddress localHost2;
            try {
                localHost2 = InetAddress.getLocalHost();
                localHostName = localHost2.getHostName();
            }
            catch (Exception localHost2) {
                // empty catch block
            }
            if (localHostName == null) {
                try {
                    localHost2 = InetAddress.getLocalHost();
                    localHostName = localHost2.getHostAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (localHostName == null) {
                localHostName = "127.0.0.1";
            }
        }
        if (this.isTrace()) {
            ISAMConnect.trace("login:  Local host name='" + localHostName + "'");
        }
        return localHostName;
    }

    private void disconnect() {
        this.setConnected(false);
    }

    private void ISAMConnectSendEnd() {
        if (!this.isConnected()) {
            return;
        }
        this.returnCode = 0;
        this.disconnect();
    }

    private boolean connect() {
        if (this.isTrace()) {
            ISAMConnect.trace("Connect:  Connecting...");
        }
        this.returnCode = 0;
        this.setErrno(0);
        if (this.isConnected()) {
            if (this.isTrace()) {
                ISAMConnect.trace("Connect:  Already connected...");
            }
            return true;
        }
        String host = this.getHost();
        if (this.isTrace()) {
            ISAMConnect.trace("Connect:  Host='" + host + "'");
        }
        this.setConnected(true);
        return true;
    }

    private boolean initSocketConnection(String hostname) {
        if (this.isTrace()) {
            ISAMConnect.trace("initSocketConnection:  hostname=" + hostname);
        }
        this.returnCode = 0;
        if (!this.isConnected()) {
            if (this.isTrace()) {
                ISAMConnect.trace("initSocketConnection:  Setting host to: '" + hostname + "'");
            }
            this.setHost(hostname);
            if (this.isTrace()) {
                ISAMConnect.trace("initSocketConnection:  Calling connect()...");
            }
            this.connect();
            if (this.returnCode != 0) {
                return false;
            }
            if (this.isTrace()) {
                ISAMConnect.trace("initSocketConnection:  Success!");
            }
            return true;
        }
        return true;
    }

    private void setISAMErrno(int n) {
        int index = n - 100;
        if (index < 0) {
            switch (n) {
                case 2: {
                    this.setErrno(15);
                    return;
                }
            }
            this.setErrno(1);
            return;
        }
        try {
            this.setErrno(errnoMap[index]);
            return;
        }
        catch (Exception exception) {
            this.setErrno(21);
            return;
        }
    }

    private int getDataType(Variable currentField) {
        switch (currentField.getStorageClass()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
            case 4: {
                int length = currentField.length();
                if (length <= 2) {
                    return 1;
                }
                if (length > 4) break;
                return 2;
            }
        }
        return 0;
    }

    private BigDecimal convertToBigDecimal(Variable currentField) {
        return currentField.toBignum().decimalValue();
    }

    private Object getVariableObject(Variable currentField) {
        int type = currentField.getTypeNumber();
        switch (type) {
            case 0: {
                switch (currentField.getUsageNumber()) {
                    case 3: {
                        int length = currentField.length();
                        if (length <= 2) {
                            return new Short(currentField.toShort());
                        }
                        if (length > 4) break;
                        return new Integer(currentField.toInt());
                    }
                    case 1: {
                        return new Float(currentField.toFloat());
                    }
                    case 2: {
                        return new Double(currentField.toDouble());
                    }
                    case 34: {
                        return new Short(currentField.toShort());
                    }
                    case 0: 
                    case 35: {
                        return this.convertToBigDecimal(currentField);
                    }
                    case 4: {
                        if (!(currentField instanceof BignumType)) break;
                        return this.convertToBigDecimal(currentField);
                    }
                }
                break;
            }
        }
        return currentField.toString();
    }

    private void moveBigDecimal(Variable currentField, BigDecimal value) {
        Bignum bigNum = new Bignum(value.toString());
        currentField.move(bigNum);
    }

    private int setVariableObject(Variable currentField, Object value) {
        int type = currentField.getTypeNumber();
        int length = currentField.length();
        switch (type) {
            case 0: {
                switch (currentField.getUsageNumber()) {
                    case 3: {
                        if (length <= 2) {
                            if (value instanceof Short) {
                                currentField.move((Short)value);
                                return length;
                            }
                            return -1;
                        }
                        if (length > 4) break;
                        if (value instanceof Integer) {
                            currentField.move((Integer)value);
                            return length;
                        }
                        return -1;
                    }
                    case 1: {
                        if (value instanceof Float) {
                            currentField.move(((Float)value).floatValue());
                            return length;
                        }
                        return -1;
                    }
                    case 2: {
                        if (value instanceof Double) {
                            currentField.move((double)((Double)value));
                            return length;
                        }
                        return -1;
                    }
                    case 34: {
                        if (value instanceof Short) {
                            currentField.move((Short)value);
                            return length;
                        }
                        return -1;
                    }
                    case 0: 
                    case 35: {
                        if (value instanceof BigDecimal) {
                            this.moveBigDecimal(currentField, (BigDecimal)value);
                            return length;
                        }
                        return -1;
                    }
                    case 4: {
                        if (!(currentField instanceof BignumType)) break;
                        if (value instanceof BigDecimal) {
                            this.moveBigDecimal(currentField, (BigDecimal)value);
                            return length;
                        }
                        return -1;
                    }
                }
                break;
            }
        }
        if (value instanceof String) {
            currentField.move((String)value);
            return length;
        }
        return -1;
    }

    private ISAMKey getKeyDescription(int i) {
        int masterRecordAddress = this.masterRecord.getAddress();
        ISAMKey key = new ISAMKey();
        int numSegments = 1;
        Variable[] list = null;
        Variable v = this.keyArray[i];
        if (v instanceof VariableList) {
            list = ((VariableList)v).getList();
            numSegments = list.length;
        }
        key.k_flags = this.keyDuplicates[i] ? 1 : 0;
        key.k_nparts = numSegments;
        if (numSegments == 1) {
            key.kp_start[0] = this.keyOffsets[i];
            key.kp_leng[0] = this.keyLength[i];
            key.kp_type[0] = this.getDataType(v);
        } else {
            for (int j = 0; j < numSegments; ++j) {
                if (list != null) {
                    v = list[j];
                }
                key.kp_start[j] = v.getAddress() - masterRecordAddress;
                key.kp_leng[j] = v.length();
                key.kp_type[j] = this.getDataType(v);
            }
        }
        return key;
    }

    private ISAMKey[] getKeyDescriptions() {
        if (this.numberOfKeys <= 0) {
            return null;
        }
        ISAMKey[] keys = new ISAMKey[this.numberOfKeys];
        for (int i = 0; i < this.numberOfKeys; ++i) {
            keys[i] = this.getKeyDescription(i);
        }
        return keys;
    }

    public int i_begin(IFilePtr rf) {
        this.returnCode = 0;
        this.setErrno(0);
        return 1;
    }

    public int i_close(IFilePtr rf) {
        this.lastKeynum = 0;
        if (rf == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        int result = ISAM.isclose((int)isfd);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public int i_commit(IFilePtr rf, int context) {
        this.returnCode = 0;
        this.setErrno(0);
        return 1;
    }

    public int i_delete(IFilePtr rf, byte[] record) {
        if (rf == null || record == null) {
            return 2;
        }
        return this.i_delete(rf, record, 0, record.length);
    }

    public int i_delete(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        ISAMRecord r = new ISAMRecord(record, offset, length);
        int isfd = rf.getISAMFilePointer();
        int result = ISAM.isdelete((int)isfd, (ISAMRecord)r);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public int i_exit() {
        this.returnCode = 0;
        this.ISAMConnectSendEnd();
        this.masterRecord = null;
        this.keyArray = null;
        this.keyLength = null;
        this.keyDuplicates = null;
        return 1;
    }

    public int i_info(IFilePtr rf, int mode, StringBuffer result) {
        if (result == null || rf == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        switch (mode) {
            case -1: {
                result.append(this.logical_params);
                break;
            }
            case -2: {
                return 0;
            }
            case -3: {
                result.append(this.comment);
                break;
            }
            case -5: 
            case -4: {
                this.setErrno(17);
                return 0;
            }
            case -6: {
                return 0;
            }
            default: {
                this.setErrno(17);
                return 0;
            }
        }
        return 1;
    }

    public int i_init(Variable masterRecord, Variable[] keyArray, int[] keyLength, boolean[] keyDuplicates, int[] keyOffsets, int numKeys) {
        this.returnCode = 0;
        this.masterRecord = masterRecord;
        this.numberOfKeys = numKeys;
        this.keyArray = keyArray;
        this.keyLength = keyLength;
        this.keyDuplicates = keyDuplicates;
        this.keyOffsets = keyOffsets;
        return this.returnCode == 0 ? 1 : 0;
    }

    public int i_make(String filename, String comment, String physical_params, String logical_params, String keys, String transTable) {
        if (filename == null || filename.trim().length() == 0 || keys == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        if (this.isTrace()) {
            ISAMConnect.trace("i_make:  filename='" + filename + "', comment='" + comment + "', physical_params='" + physical_params + "', logical_params='" + logical_params + "', keys='" + keys + "', transTable='" + transTable + "'");
        }
        this.setErrno(0);
        String[] result = ISAMConnect.getHostnameAndFilenameFromString(filename);
        if (result == null) {
            this.setErrno(2);
            return 0;
        }
        String hostname = result[0];
        filename = result[1];
        if (!this.isConnected() && !this.initSocketConnection(hostname)) {
            return 0;
        }
        this.comment = comment;
        this.logical_params = logical_params;
        this.parseLogicalParams(logical_params);
        ISAMKey[] keyDesc = this.getKeyDescriptions();
        int mode = 2050;
        mode = this.maximum != this.minimum ? (mode |= 0x10) : (mode |= 0);
        ISAM.isreclen = this.minimum;
        int isfd = ISAM.isbuild((String)filename, (int)this.maximum, (ISAMKey)keyDesc[0], (int)mode);
        if (isfd < 0) {
            if (ISAM.iserrno == 17) {
                int rc = ISAM.iserase((String)filename);
                if (rc < 0) {
                    this.setISAMErrno(ISAM.iserrno);
                    return 0;
                }
                ISAM.isreclen = this.minimum;
                isfd = ISAM.isbuild((String)filename, (int)this.maximum, (ISAMKey)keyDesc[0], (int)mode);
                if (isfd < 0) {
                    this.setISAMErrno(ISAM.iserrno);
                    return 0;
                }
            } else {
                this.setISAMErrno(ISAM.iserrno);
                return 0;
            }
        }
        int resultCode = 0;
        if (this.numberOfKeys > 1) {
            for (int i = 1; i < this.numberOfKeys; ++i) {
                ISAMKey key = keyDesc[i];
                ISAM.isreclen = this.minimum;
                resultCode = ISAM.isaddindex((int)isfd, (ISAMKey)key);
                if (resultCode >= 0) continue;
                this.setISAMErrno(ISAM.iserrno);
                return 0;
            }
        }
        if ((resultCode = ISAM.isclose((int)isfd)) < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public int i_next(IFilePtr rf, byte[] record) {
        return this.i_next(rf, record, 0, record.length);
    }

    public int i_next(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        ISAMRecord r = new ISAMRecord(record, offset, length);
        int mode = 2;
        int result = ISAM.isread((int)isfd, (ISAMRecord)r, (int)mode);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        int len = length;
        if (this.maximum != this.minimum) {
            len = ISAM.isreclen;
        }
        return len;
    }

    private int convertOpenMode(int mode) {
        int isamMode = 0;
        switch (mode & 3) {
            case 0: {
                isamMode = 0;
                break;
            }
            case 1: 
            case 3: {
                isamMode = 1;
                break;
            }
            default: {
                isamMode = 2;
            }
        }
        isamMode = this.maximum == this.minimum ? (isamMode |= 0) : (isamMode |= 0x10);
        isamMode = (mode & 0x600) != 0 ? (isamMode |= 0x800) : ((mode & 0x100) != 0 ? (isamMode |= 0x200) : ((mode & 0x200) != 0 ? (isamMode |= 0x800) : (isamMode |= 0x200)));
        if ((mode & 0x10) != 0) {
            // empty if block
        }
        if ((mode & 0x4000) != 0) {
            // empty if block
        }
        return isamMode;
    }

    public IFilePtr i_open(String filename, int mode, String logical_params) {
        String[] result;
        if (filename == null) {
            this.setErrno(2);
            return null;
        }
        this.lastKeynum = 0;
        this.returnCode = 0;
        this.setErrno(0);
        if (this.isTrace()) {
            ISAMConnect.trace("i_open:  filename='" + filename + "', mode='" + mode + "', logical_params='" + logical_params + "'");
        }
        if ((result = ISAMConnect.getHostnameAndFilenameFromString(filename)) == null) {
            this.setErrno(2);
            return null;
        }
        String hostname = result[0];
        filename = result[1];
        if (!this.isConnected() && !this.initSocketConnection(hostname)) {
            return null;
        }
        int isamMode = this.convertOpenMode(mode);
        ISAM.isreclen = this.maximum;
        int isfd = ISAM.isopen((String)filename, (int)isamMode);
        if (isfd < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return null;
        }
        this.logical_params = logical_params;
        if (mode == 3) {
            // empty if block
        }
        if (this.isTrace()) {
            ISAMConnect.trace("i_open:  Done, now creating fileptr");
        }
        IFilePtr fp = new IFilePtr(isfd);
        return fp;
    }

    public int i_previous(IFilePtr rf, byte[] record) {
        return this.i_previous(rf, record, 0, record.length);
    }

    public int i_previous(IFilePtr rf, byte[] record, int offset, int length) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        ISAMRecord r = new ISAMRecord(record, offset, length);
        int mode = 3;
        int result = ISAM.isread((int)isfd, (ISAMRecord)r, (int)mode);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        int len = length;
        if (this.maximum != this.minimum) {
            len = ISAM.isreclen;
        }
        return len;
    }

    public int i_read(IFilePtr rf, byte[] record, int keynum) {
        return this.i_read(rf, record, 0, record.length, keynum);
    }

    public int i_read(IFilePtr rf, byte[] record, int offset, int length, int keynum) {
        int result;
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        ISAMRecord r = new ISAMRecord(record, offset, length);
        int mode = 5;
        if (keynum != this.lastKeynum) {
            ISAMKey keyDesc = this.getKeyDescription(keynum);
            int result2 = ISAM.isstart((int)isfd, (ISAMKey)keyDesc, (int)keyDesc.k_len, (ISAMRecord)r, (int)mode);
            if (result2 < 0) {
                this.setISAMErrno(ISAM.iserrno);
                return 0;
            }
            mode = mode & 0xFFFFFFFA | 2;
            this.lastKeynum = keynum;
        }
        if ((result = ISAM.isread((int)isfd, (ISAMRecord)r, (int)mode)) < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        int len = length;
        if (this.maximum != this.minimum) {
            len = ISAM.isreclen;
        }
        return len;
    }

    public int i_recover() {
        this.setErrno(17);
        return 0;
    }

    public int i_remove(String filename) {
        if (filename == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        String[] result = ISAMConnect.getHostnameAndFilenameFromString(filename);
        if (result == null) {
            this.setErrno(2);
            return 0;
        }
        String hostname = result[0];
        filename = result[1];
        if (!this.isConnected() && !this.initSocketConnection(hostname)) {
            return this.returnCode;
        }
        int resultCode = ISAM.iserase((String)filename);
        if (resultCode < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public int i_rename(String fromname, String toname) {
        if (fromname == null || toname == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        String[] result = ISAMConnect.getHostnameAndFilenameFromString(fromname);
        if (result == null) {
            this.setErrno(2);
            return 0;
        }
        String fromHostName = result[0];
        fromname = result[1];
        result = ISAMConnect.getHostnameAndFilenameFromString(toname);
        if (result == null) {
            this.setErrno(2);
            return 0;
        }
        toname = result[1];
        if (!this.isConnected() && !this.initSocketConnection(fromHostName)) {
            return this.returnCode;
        }
        int resultCode = ISAM.isrename((String)fromname, (String)toname);
        if (resultCode < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public int i_rewrite(IFilePtr rf, byte[] record, int size) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        return this.i_rewrite(rf, record, 0, record.length, size);
    }

    public int i_rewrite(IFilePtr rf, byte[] record, int offset, int length, int size) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        ISAMRecord r = new ISAMRecord(record, offset, length);
        ISAM.isreclen = size;
        int result = ISAM.isrewrite((int)isfd, (ISAMRecord)r);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public int i_rollback(IFilePtr rf, int context) {
        this.returnCode = 0;
        this.setErrno(0);
        return 1;
    }

    private int convertStartMode(int mode) {
        switch (mode) {
            case 0: {
                return 5;
            }
            case 1: {
                return 7;
            }
            case 2: {
                return 6;
            }
        }
        return 5;
    }

    public int i_start(IFilePtr rf, byte[] record, int keynum, int keysize, int mode) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        return this.i_start(rf, record, 0, record.length, keynum, keysize, mode);
    }

    public int i_start(IFilePtr rf, byte[] record, int offset, int length, int keynum, int keysize, int mode) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        int startMode = this.convertStartMode(mode);
        ISAMRecord r = new ISAMRecord(record, offset, length);
        ISAMKey keyDesc = this.getKeyDescription(keynum);
        int result = ISAM.isstart((int)isfd, (ISAMKey)keyDesc, (int)keysize, (ISAMRecord)r, (int)startMode);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        this.lastKeynum = keynum;
        return 1;
    }

    public void i_sync(int all_files) {
        this.setErrno(17);
    }

    public int i_unlock(IFilePtr rf) {
        if (rf == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        return 1;
    }

    public int i_version(StringBuffer filename, StringBuffer file_version, StringBuffer int_version, int system_num) {
        this.returnCode = 0;
        try {
            filename.setLength(0);
            filename.append("ISAMConnect client");
            file_version.setLength(0);
            file_version.append("1.0.0");
            int_version.setLength(0);
            int_version.append("1");
            return 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int i_write(IFilePtr rf, byte[] record, int size) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        return this.i_write(rf, record, 0, record.length, size);
    }

    public int i_write(IFilePtr rf, byte[] record, int offset, int length, int size) {
        if (rf == null || record == null) {
            this.setErrno(2);
            return 0;
        }
        this.returnCode = 0;
        this.setErrno(0);
        int isfd = rf.getISAMFilePointer();
        ISAMRecord r = new ISAMRecord(record, offset, length);
        ISAM.isreclen = size;
        int result = ISAM.iswrite((int)isfd, (ISAMRecord)r);
        if (result < 0) {
            this.setISAMErrno(ISAM.iserrno);
            return 0;
        }
        return 1;
    }

    public class IFilePtr {
        private int file = -1;

        public IFilePtr(int kf) {
            this.file = kf;
        }

        public int getISAMFilePointer() {
            return this.file;
        }
    }
}

