/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.DisplayA;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Index
implements IDatatype,
Serializable {
    static final long serialVersionUID = 1L;
    private static final int MIN_VAL = 1;
    private static final int MAX_VAL = -1;
    private int index = 1;
    private int min;
    private int max;
    private boolean sizeErrorCondition;

    public Index(int setMax, int setMin) {
        if (this.max < this.min) {
            this.max = setMin;
            this.min = setMax;
        } else {
            this.min = setMin;
            this.max = setMax;
        }
    }

    public Index(int setMax) {
        this.max = setMax;
        this.min = 1;
    }

    public Index() {
        this.max = -1;
        this.min = 1;
    }

    public void copy(Index r) {
        this.index = r.index;
        this.min = r.index;
        this.max = r.index;
    }

    public Numeric copy() {
        return new Numeric(this.index);
    }

    public Bignum toBignum() {
        return new Bignum(this.index);
    }

    public Bignum toModifyBignum() {
        return new Bignum(this.index);
    }

    @Override
    public int toInt() {
        return this.index;
    }

    public boolean check() {
        if (this.max < this.min) {
            return false;
        }
        if (this.index < this.min) {
            this.index = this.max;
            return true;
        }
        if (this.index > this.max) {
            this.index = this.min;
            return true;
        }
        return false;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getPlace() {
        return 0;
    }

    public Index setTo(Numeric x) {
        this.index = x.toInt();
        return this;
    }

    public Index setTo(int x) {
        this.index = x;
        return this;
    }

    public Index setTo(Index x) {
        this.index = x.index;
        return this;
    }

    public Index setUp(Numeric x) {
        this.index += x.toInt();
        return this;
    }

    public Index move(int x) {
        this.index = x;
        return this;
    }

    public void set(int x) {
        this.index = x;
    }

    public Index move(Bignum x) {
        this.index = x.intValue();
        return this;
    }

    public Index move(Index x) {
        this.index = x.index;
        return this;
    }

    public Index move(Numeric x) {
        this.index = x.toInt();
        return this;
    }

    public Index move(Variable x) {
        this.index = x.toInt();
        return this;
    }

    public Index move(String stringValue) {
        int x = 0;
        try {
            x = Integer.parseInt(stringValue.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.index = x;
        return this;
    }

    public Index moveSE(int x) {
        this.index = x;
        return this;
    }

    public Index moveSE(Index x) {
        this.index = x.index;
        return this;
    }

    public Index moveSE(Numeric x) {
        this.index = x.toInt();
        return this;
    }

    public Index moveSE(Bignum x) {
        this.index = x.intValue();
        return this;
    }

    public Index moveSER(int x) {
        this.index = x;
        return this;
    }

    public Index moveSER(Index x) {
        this.index = x.index;
        return this;
    }

    public Index moveSER(Numeric x) {
        this.index = x.toInt();
        return this;
    }

    public Index moveSER(Bignum x) {
        this.index = x.intValue();
        return this;
    }

    public Index moveR(Bignum x) {
        this.index = x.intValue();
        return this;
    }

    public Index setUp(int x) {
        this.index += x;
        return this;
    }

    public Index setDown(Numeric x) {
        this.index -= x.toInt();
        return this;
    }

    public Index setDown(int x) {
        this.index -= x;
        return this;
    }

    public Index next() {
        ++this.index;
        return this;
    }

    public Index prev() {
        --this.index;
        return this;
    }

    public String toString() {
        return String.valueOf(this.index);
    }

    public String toDisplayString() {
        return String.valueOf(this.index);
    }

    public String toNationalString() {
        return String.valueOf(this.index);
    }

    public int compare(int n) {
        if (this.index < n) {
            return -1;
        }
        if (this.index > n) {
            return 1;
        }
        return 0;
    }

    public int compare(Numeric nv) {
        int n = nv.toInt();
        if (this.index < n) {
            return -1;
        }
        if (this.index > n) {
            return 1;
        }
        return 0;
    }

    public int compare(Variable nv) {
        int n = nv.toInt();
        if (this.index < n) {
            return -1;
        }
        if (this.index > n) {
            return 1;
        }
        return 0;
    }

    public int compare(Index n) {
        return this.compare(n.toInt());
    }

    public Index add(int x) {
        this.index += x;
        return this;
    }

    public Index add(Numeric x) {
        this.index += x.toInt();
        return this;
    }

    public Index add(Variable x) {
        this.index += x.toInt();
        return this;
    }

    public Index add(DisplayP x, Bignum y) {
        this.index = x.toInt() + y.intValue();
        return this;
    }

    public Index add(Bignum x, DisplayA y) {
        this.index = y.toInt() + x.intValue();
        return this;
    }

    public Index add(DisplayA x, Bignum y) {
        this.index = x.toInt() + y.intValue();
        return this;
    }

    public Index add(Bignum x, DisplayP y) {
        this.index = x.intValue() + y.toInt();
        return this;
    }

    public Index add(Bignum x, DisplayMVS y) {
        this.index = x.intValue() + y.toInt();
        return this;
    }

    public Index add(Bignum x, Bignum y) {
        this.index = x.intValue() + y.intValue();
        return this;
    }

    public Index sub(int x) {
        this.index -= x;
        return this;
    }

    public Index sub(Numeric x) {
        this.index -= x.toInt();
        return this;
    }

    public Index sub(Variable x) {
        this.index -= x.toInt();
        return this;
    }

    public void validate() {
    }

    public void setToValue(Numeric x) {
        this.index = x.toInt();
    }

    public void setToValue(int x) {
        this.index = x;
    }

    public void setToValue(Index x) {
        this.index = x.index;
    }

    public void setUpValue(Numeric x) {
        this.index += x.toInt();
    }

    public void setUpValue(int x) {
        this.index += x;
    }

    public void setDownValue(Numeric x) {
        this.index -= x.toInt();
    }

    public void setDownValue(int x) {
        this.index -= x;
    }

    public void setUpCheck(Numeric x) {
        this.index += x.toInt();
        if (!Variable.boundsCheck) {
            return;
        }
        if (this.max < this.min) {
            return;
        }
        if (this.index < this.min) {
            this.index = this.max;
            return;
        }
        if (this.index > this.max) {
            this.index = this.min;
            return;
        }
    }

    public void setUpCheck(int x) {
        this.index += x;
        if (!Variable.boundsCheck) {
            return;
        }
        if (this.max < this.min) {
            return;
        }
        if (this.index < this.min) {
            this.index = this.max;
            return;
        }
        if (this.index > this.max) {
            this.index = this.min;
            return;
        }
    }

    public void setDownCheck(Numeric x) {
        this.index -= x.toInt();
        if (!Variable.boundsCheck) {
            return;
        }
        if (this.max < this.min) {
            return;
        }
        if (this.index < this.min) {
            this.index = this.max;
            return;
        }
        if (this.index > this.max) {
            this.index = this.min;
            return;
        }
    }

    public void setDownCheck(int x) {
        this.index -= x;
        if (!Variable.boundsCheck) {
            return;
        }
        if (this.max < this.min) {
            return;
        }
        if (this.index < this.min) {
            this.index = this.max;
            return;
        }
        if (this.index > this.max) {
            this.index = this.min;
            return;
        }
    }

    public final boolean isSizeError() {
        if (this.sizeErrorCondition) {
            this.sizeErrorCondition = false;
            return true;
        }
        return false;
    }

    @Override
    public int getType() {
        return 48;
    }

    @Override
    public int getLength() {
        return this.toString().length();
    }

    @Override
    public int getSize() {
        return this.toString().length();
    }

    @Override
    public int getDecimalPositions() {
        return 0;
    }

    @Override
    public byte[] toByteArray() {
        String s = this.toString();
        int length = s.length();
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)s.charAt(i);
        }
        return result;
    }

    @Override
    public void toByteArray(byte[] param, int offset, int length) {
        String s = this.toString();
        for (int i = 0; i < length; ++i) {
            param[offset++] = (byte)s.charAt(i);
        }
    }

    private static String StringOf(byte[] source) {
        int length = source.length;
        char[] dest = new char[length];
        for (int i = 0; i < length; ++i) {
            dest[i] = (char)(source[i] & 0xFF);
        }
        return new String(dest);
    }

    private static String StringOf(byte[] source, int offset, int length) {
        char[] dest = new char[length];
        for (int i = 0; i < length; ++i) {
            dest[i] = (char)(source[offset++] & 0xFF);
        }
        return new String(dest);
    }

    @Override
    public void fromByteArray(byte[] param) {
        this.move(Index.StringOf(param));
    }

    @Override
    public void fromByteArray(byte[] param, int offset, int length) {
        this.move(Index.StringOf(param, offset, length));
    }

    @Override
    public String toText() {
        return this.toString();
    }

    @Override
    public void fromText(String param) {
        this.move(param);
    }

    @Override
    public boolean toBoolean() {
        return this.toInt() != 0;
    }

    @Override
    public byte toByte() {
        return (byte)this.toInt();
    }

    @Override
    public char toChar() {
        return (char)this.toInt();
    }

    @Override
    public short toShort() {
        return (short)this.toInt();
    }

    @Override
    public long toLong() {
        return this.toInt();
    }

    @Override
    public float toFloat() {
        return this.toInt();
    }

    @Override
    public double toDouble() {
        return this.toInt();
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(BigInteger.valueOf(this.toInt()));
    }

    @Override
    public IDatatype toDatatype() {
        return this;
    }

    @Override
    public void fromBoolean(boolean param) {
        if (param) {
            this.move(1);
        } else {
            this.move(0);
        }
    }

    @Override
    public void fromByte(byte param) {
        this.move(param);
    }

    @Override
    public void fromChar(char param) {
        this.move(param);
    }

    @Override
    public void fromShort(short param) {
        this.move(param);
    }

    @Override
    public void fromInt(int param) {
        this.move(param);
    }

    @Override
    public void fromLong(long param) {
        this.move((int)param);
    }

    @Override
    public void fromFloat(float param) {
        this.move((int)param);
    }

    @Override
    public void fromDouble(double param) {
        this.move((int)param);
    }

    @Override
    public void fromBigDecimal(BigDecimal param) {
        this.move(param.toString());
    }

    @Override
    public void fromDatatype(IDatatype param) {
        if (param instanceof Variable) {
            this.move(((Variable)param).toInt());
        } else {
            this.move(param.toString());
        }
    }

    @Override
    public Object[] getElements() {
        return null;
    }

    public void setDataPointer(Object value) {
        if (value instanceof Number) {
            this.move(((Number)value).intValue());
        } else {
            this.move(ConvertData.parseInt(String.valueOf(value)));
        }
    }

    @Override
    public void fromDataPointer(byte[] param) {
    }
}

