/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;

public abstract class LockRecord
implements FileConstants {
    private static final String LOCK_RECORD_CHANNEL = "com.heirloomcomputing.ecs.exec.jdk14.LockRecordChannel";
    private static final String LOCK_RECORD_NETWORK = "com.heirloomcomputing.ecs.exec.LockRecordNetwork";
    private static String[] lockRecordImplementations = new String[]{"com.heirloomcomputing.ecs.exec.LockRecordNetwork", "com.heirloomcomputing.ecs.exec.jdk14.LockRecordChannel"};
    private static Class<?> constructorClass = null;

    private static Class<?> findConstructorClass() {
        Class<?> result;
        String lockRecordExtension = RuntimeEnvironment.getGlobalParameter("LOCK-RECORD");
        try {
            if (lockRecordExtension != null) {
                if (lockRecordExtension.equalsIgnoreCase("JDK11")) {
                    lockRecordExtension = LOCK_RECORD_NETWORK;
                } else if (lockRecordExtension.equalsIgnoreCase("JDK14")) {
                    lockRecordExtension = LOCK_RECORD_CHANNEL;
                }
                lockRecordExtension = lockRecordExtension.replace('/', '.');
                if (lockRecordExtension.endsWith(".class")) {
                    lockRecordExtension = lockRecordExtension.substring(0, lockRecordExtension.length() - 6);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lockRecordExtension != null && lockRecordExtension.indexOf(46) < 0) {
            try {
                result = Class.forName("com.heirloomcomputing.ecs.exec.LockRecord" + lockRecordExtension);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (lockRecordExtension != null) {
            try {
                result = Class.forName(lockRecordExtension);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (lockRecordImplementations != null) {
            int length = lockRecordImplementations.length;
            for (int i = 0; i < length; ++i) {
                try {
                    result = Class.forName(lockRecordImplementations[i]);
                    if (result != null) {
                        return result;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static LockRecord create() {
        if (constructorClass == null) {
            constructorClass = LockRecord.findConstructorClass();
            if (RuntimeEnvironment.isGlobalParameter("LOCK_RECORD_VERBOSE")) {
                System.out.println("Lock Record Driver in use: class=" + constructorClass);
            }
        }
        try {
            LockRecord result = (LockRecord)constructorClass.newInstance();
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static LockRecord create(Object fileObject) {
        LockRecord result = LockRecord.create();
        if (result != null) {
            result.setFileObject(fileObject);
        }
        return result;
    }

    public static boolean isStatusNoErrors(int n) {
        return (n & 0x18) == 0;
    }

    public static boolean isStatusLocked(int n) {
        return (n & 1) != 0;
    }

    public static boolean isStatusRejected(int n) {
        return (n & 1) == 0;
    }

    public static boolean isStatusFileChanged(int n) {
        return (n & 2) != 0;
    }

    public static boolean isStatusRecordChanged(int n) {
        return (n & 4) != 0;
    }

    public static boolean isStatusErrorUnknown(int n) {
        return (n & 8) != 0;
    }

    public static boolean isStatusTooMany(int n) {
        return (n & 0x10) != 0;
    }

    public boolean lock(long record) {
        return this.lock(record, 1L);
    }

    public void unlock(long record) {
        this.unlock(record, 1L);
    }

    public boolean writeLock(long record) {
        return this.writeLock(record, 1L);
    }

    public void writeUnlock(long record) {
        this.writeUnlock(record, 1L);
    }

    public boolean readLock(long record) {
        return this.readLock(record, 1L);
    }

    public void readUnlock(long record) {
        this.readUnlock(record, 1L);
    }

    public boolean blockingReadLock(long record) {
        return this.blockingReadLock(record, 1L);
    }

    public boolean blockingWriteLock(long record) {
        return this.blockingWriteLock(record, 1L);
    }

    public abstract boolean isStatusLocked();

    public abstract boolean isStatusRejected();

    public abstract boolean isStatusRejectedNoErrors();

    public abstract boolean isStatusFileChanged();

    public abstract boolean isStatusRecordChanged();

    public abstract boolean isStatusErrorUnknown();

    public abstract boolean isStatusTooMany();

    public abstract void open(String var1, int var2);

    public abstract void setFileObject(Object var1);

    public abstract void unlockAll();

    public abstract void close();

    public abstract boolean exclusive();

    public abstract void unexclusive();

    public abstract boolean lock(long var1, long var3);

    public abstract void unlock(long var1, long var3);

    public abstract boolean writeLock(long var1, long var3);

    public abstract void writeUnlock(long var1, long var3);

    public abstract boolean readLock(long var1, long var3);

    public abstract void readUnlock(long var1, long var3);

    public abstract boolean blockingReadLock(long var1, long var3);

    public abstract boolean blockingWriteLock(long var1, long var3);
}

