/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;

public class LogFile {
    private static int loggingLevel = -1;
    private static String loggingFilter = null;
    public static final int LOG_DETAIL = 5;
    public static final int LOG_INFO = 4;
    public static final int LOG_WARNING = 3;
    public static final int LOG_ERROR = 2;
    public static final int LOG_CRITICAL = 1;

    public static void log(int severity, String type, String message, Throwable t) {
        if (loggingLevel < 0) {
            try {
                String s = RuntimeEnvironment.getGlobalParameter("LOGGING");
                loggingLevel = ConvertData.parseInt(s);
                loggingFilter = RuntimeEnvironment.getGlobalParameter("LOGGINGFILTER");
                if (loggingFilter != null) {
                    loggingFilter = loggingFilter.toUpperCase();
                }
            }
            catch (Throwable s) {
                // empty catch block
            }
            if (loggingLevel < 0) {
                loggingLevel = 0;
            }
        }
        if (loggingLevel < severity) {
            return;
        }
        if (loggingFilter != null && type != null) {
            type = type.toUpperCase();
            boolean found = false;
            for (int i = 0; i < loggingFilter.length(); ++i) {
                if (type.indexOf(loggingFilter.charAt(i)) >= 0) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        System.out.println("[LOG " + severity + ":" + type + ": '" + message + "']");
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }
}

