/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Version;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogSetup {
    private static final String PGM = "LogSetup";
    public static final String LOG_NAME = "com.heirloomcomputing";
    public static final Logger LOGGER = Logger.getLogger("com.heirloomcomputing");
    private static String logpath = ".";
    private static boolean IS_LOG_SETUP = false;
    private static final String logRuntimeParm = RuntimeEnvironment.getGlobalParameter("LOG");
    public static boolean IS_LOGGING = logRuntimeParm != null && !"false".equalsIgnoreCase(logRuntimeParm);
    public static final boolean IS_LOGGING_INFO = "info".equalsIgnoreCase(logRuntimeParm);

    public static void setup() {
        LogSetup.setup(null, null);
    }

    public static void setup(String logDir) {
        LogSetup.setup(logDir, null);
    }

    public static void setup(String logDir, String logLevel) {
        String func = "LogSetup.setup(s): ";
        if (IS_LOG_SETUP) {
            return;
        }
        if (logDir == null) {
            logDir = ".";
        }
        if ("".equals(logDir = logDir.trim()) || " ".equals(logDir)) {
            System.out.println("LogSetup.setup(s): directory of log file cannot be blank. logDir=" + logDir + ".");
        }
        logpath = logDir;
        File dir = null;
        try {
            dir = new File(logpath);
            if (!dir.exists()) {
                System.out.println("LogSetup.setup(s): directory does not exist. Its full name is " + dir.getAbsolutePath());
                System.exit(1);
            }
            if (!dir.isDirectory()) {
                System.out.println("LogSetup.setup(s): You must enter a directory name, not a file name. Its full name is " + dir.getAbsolutePath());
                System.exit(2);
            }
            if (logLevel == null) {
                logLevel = "ALL";
            }
            if ("".equals(logLevel = logLevel.trim())) {
                logLevel = "ALL";
            }
            logLevel = logLevel.toUpperCase();
            try {
                Level level = Level.parse(logLevel);
                LOGGER.setLevel(level);
            }
            catch (IllegalArgumentException iae) {
                logLevel = "ALL";
                LOGGER.setLevel(Level.ALL);
                LOGGER.warning("Logging level is set to ALL");
            }
            LOGGER.setUseParentHandlers(false);
            int LOG_ROTATION_COUNT = 3;
            FileHandler handler = new FileHandler(dir.getPath() + "/elastic_cobol.log", 0, 3);
            handler.setLevel(Level.ALL);
            Logger.getLogger(LOG_NAME).addHandler(handler);
            ConsoleHandler handlerConsole = new ConsoleHandler();
            handlerConsole.setLevel(Level.ALL);
            Logger.getLogger(LOG_NAME).addHandler(handlerConsole);
            LogSetup.checkSlf4jBridge();
            LogSetup.checkSysoutBridge();
            IS_LOG_SETUP = true;
        }
        catch (IOException e) {
            System.out.println("LogSetup.setup(s): Can't create log file handler");
            LOGGER.log(Level.SEVERE, "Can't create log file handler", e);
        }
        LOGGER.info("\n\t\tHeirloom Computing, Inc. " + Version.getVersion() + "\n");
        LOGGER.fine("LOCATION OF LOG FILE: dir.getPath()=" + dir.getPath() + "; dir.getAbsolutePath()=" + dir.getAbsolutePath() + ";");
        LOGGER.fine("Log Level is " + logLevel + ". Log to Console is ALL. Log to File is ALL.");
        LOGGER.fine("Runtime parm: LOG = " + logRuntimeParm);
    }

    public static void checkSlf4jBridge() {
        try {
            Class<?> slf4jBridgeHandler = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            LogManager.getLogManager().reset();
            Method removeHandlersForRootLogger = slf4jBridgeHandler.getMethod("removeHandlersForRootLogger", new Class[0]);
            removeHandlersForRootLogger.invoke(null, new Object[0]);
            Method install = slf4jBridgeHandler.getMethod("install", new Class[0]);
            install.invoke(null, new Object[0]);
            Logger rootLogger = Logger.getLogger(LOG_NAME);
            Handler[] handlers = rootLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                rootLogger.removeHandler(handlers[i]);
            }
            LogManager.getLogManager().getLogger(LOG_NAME).addHandler((Handler)slf4jBridgeHandler.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkSysoutBridge() {
        try {
            Class<?> sysoutBridgeHandler = Class.forName("uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J");
            Method sysoutHandlersForRootLogger = sysoutBridgeHandler.getMethod("sendSystemOutAndErrToSLF4J", new Class[0]);
            sysoutHandlersForRootLogger.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getLogpath() {
        return logpath;
    }

    public static void setLogpath(String logpath) {
        LogSetup.logpath = logpath;
    }

    public static boolean isLogSetup() {
        return IS_LOG_SETUP;
    }

    static {
        if (logRuntimeParm != null) {
            String logDir = RuntimeEnvironment.getGlobalParameter("LOGDIR");
            String logLevel = RuntimeEnvironment.getGlobalParameter("LOGLEVEL");
            if (logLevel == null) {
                logLevel = "true".equalsIgnoreCase(logRuntimeParm) ? "ALL" : ("false".equalsIgnoreCase(logRuntimeParm) ? "SEVERE" : logRuntimeParm.toUpperCase());
            }
            LogSetup.setup(logDir, logLevel);
        }
    }
}

