/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.BTreeHandler;
import com.heirloomcomputing.ecs.exec.MFBTreeNode;
import com.heirloomcomputing.ecs.exec.MFFile;
import com.heirloomcomputing.ecs.exec.MFFilePointer;
import com.heirloomcomputing.ecs.exec.bTreeNode;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public class MFBTreeHandler
extends BTreeHandler {
    public static final boolean debugMode = false;
    int order = 5;
    protected MFFile file = null;
    private int bTreeIndex = -1;

    public static void debug(String text) {
        System.out.println("MFBTreeHandler: " + text);
    }

    public MFBTreeHandler(MFFile file2, int bTreeIndex) {
        this.bTreeIndex = bTreeIndex;
        this.file = file2;
    }

    @Override
    int getBTreeType() {
        return 1;
    }

    @Override
    int getBTreeOrder() {
        return this.order;
    }

    @Override
    int compareLocation(Object location1, Object location2, boolean truncate) {
        if (!(location1 instanceof MFFilePointer) || !(location2 instanceof MFFilePointer)) {
            throw new RuntimeException("Location(s) are not of type MFFilePointer");
        }
        MFFilePointer pointer1 = (MFFilePointer)location1;
        MFFilePointer pointer2 = (MFFilePointer)location2;
        return pointer1.compare(pointer2, truncate);
    }

    private void initOrder(MFFile file2) {
        int filePointerSize = file2.getFilePointerSize();
        try {
            int nodeSize = file2.getIndexNodeRecordSize();
            int maxKeySize = this.getMaximumKeySize();
            int keyOverhead = maxKeySize + filePointerSize;
            boolean suppressLeading = file2.getSuppressLeadingChars(this.bTreeIndex);
            boolean suppressTrailing = file2.getSuppressTrailingSpaces(this.bTreeIndex);
            boolean suppressDuplicates = false;
            if (file2.getSuppressDuplicateKeys(this.bTreeIndex) && file2.getDuplicatesAllowed(this.bTreeIndex)) {
                suppressDuplicates = true;
            }
            keyOverhead = suppressDuplicates ? (!suppressLeading ? (!suppressTrailing ? filePointerSize + 2 : filePointerSize + 3) : (!suppressTrailing ? filePointerSize + 3 : filePointerSize + 4)) : (!suppressLeading ? (!suppressTrailing ? maxKeySize + filePointerSize : filePointerSize + 1) : (!suppressTrailing ? 5 : filePointerSize + 2));
            this.order = (nodeSize - (file2.isIdx8() ? 4 : 2) - 2) / keyOverhead;
        }
        catch (Exception e) {
            this.order = (file2.getIndexNodeRecordSize() - 6) / 6 + 1;
        }
    }

    @Override
    bTreeNode getBTreeNode(comparableByteArray keyTemplate) {
        this.initOrder(this.file);
        return new MFBTreeNode(this.file, this.order, keyTemplate, this.bTreeIndex, this.getMaximumKeySize());
    }

    @Override
    bTreeNode getBTreeNode(comparableByteArray keyTemplate, Object location) {
        if (!(location instanceof MFFilePointer)) {
            throw new RuntimeException("location not of type MFFilePointer");
        }
        this.initOrder(this.file);
        MFFilePointer pointer = (MFFilePointer)location;
        long key = pointer.getRecordKey();
        return new MFBTreeNode(this.file, this.order, key, keyTemplate, this.bTreeIndex, this.getMaximumKeySize());
    }
}

