/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.MediaImageBMP;
import com.heirloomcomputing.ecs.exec.MediaImageICO;
import com.heirloomcomputing.ecs.exec.Utilities;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;

public class MediaImage {
    public static final int BUTTON_TEXT = -16777216;
    public static final int BUTTON_SHADOW = -8355712;
    public static final int BUTTON_FACE = -4144960;
    public static final int BUTTON_HIGHLIGHT = -1;
    public static final int SELECTED_ITEM_BACKGROUND = -16776961;
    public static final int WINDOW_BACKGROUND = -65281;
    private static final int[] remapColors = new int[]{-16777216, -8355712, -4144960, -1, -16776961, -65281};

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Utilities.getClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classLoader;
    }

    public static Image getImage(URL url2) {
        return MediaImage.getImage(String.valueOf(url2));
    }

    public static Image getImage(String filename) {
        return MediaImage.getImage(filename, null);
    }

    public static Image getImage(String filename, Component usingComponent) {
        if (filename == null) {
            return null;
        }
        String ufilename = filename.toUpperCase();
        Image result = null;
        try {
            if (ufilename.endsWith(".BMP")) {
                result = MediaImage.getBmp(filename);
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (ufilename.endsWith(".ICO")) {
                result = MediaImage.getIco(filename);
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return MediaImage.getStandard(filename, usingComponent);
    }

    public static Image getBmp(String filename) throws Exception {
        InputStream fis = Utilities.getInputStream(filename);
        if (fis == null) {
            return null;
        }
        MediaImageBMP bmp = new MediaImageBMP();
        Image result = bmp.getImage(new BufferedInputStream(fis));
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Image getIco(String filename) throws Exception {
        int imageSelection = 0;
        try {
            int colonIndex = filename.indexOf(58);
            if (colonIndex >= 0 && (imageSelection = ConvertData.parseInt(filename.substring(0, colonIndex))) >= 1) {
                filename = filename.substring(colonIndex + 1);
                --imageSelection;
            }
        }
        catch (Throwable colonIndex) {
            // empty catch block
        }
        MediaImageICO ico = null;
        InputStream fis = Utilities.getInputStream(filename);
        if (fis == null) {
            return null;
        }
        Image result = null;
        try {
            ico = new MediaImageICO(new BufferedInputStream(fis));
            result = ico.getImage(imageSelection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Image getStandard(ClassLoader classLoader, String filename) {
        return MediaImage.getStandard(classLoader, filename, null);
    }

    public static Image getStandard(String filename) {
        return MediaImage.getStandard(MediaImage.getClassLoader(), filename, null);
    }

    public static Image getStandard(String filename, Component mediaComponent) {
        return MediaImage.getStandard(MediaImage.getClassLoader(), filename, mediaComponent);
    }

    public static Image getStandard(ClassLoader classLoader, String filename, Component mediaComponent) {
        Image img = MediaImage.getStandardNoWait(classLoader, filename, mediaComponent);
        if (img != null) {
            try {
                if (mediaComponent != null) {
                    MediaTracker tracker = new MediaTracker(mediaComponent);
                    tracker.addImage(img, 0);
                    try {
                        tracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return img;
    }

    public static Image getStandardNoWait(String filename, Component mediaComponent) {
        return MediaImage.getStandardNoWait(MediaImage.getClassLoader(), filename, mediaComponent);
    }

    public static Image getStandardNoWait(ClassLoader classLoader, String filename, Component mediaComponent) {
        Toolkit toolkit;
        URL location;
        block26: {
            location = null;
            toolkit = null;
            toolkit = mediaComponent != null ? mediaComponent.getToolkit() : Toolkit.getDefaultToolkit();
            try {
                URL resource = classLoader.getResource(filename);
                if (resource != null) {
                    return toolkit.getImage(resource);
                }
            }
            catch (Exception resource) {
                // empty catch block
            }
            try {
                byte[] image2;
                byte[] imageArray = null;
                InputStream in = null;
                if (classLoader != null && (in = classLoader.getResourceAsStream(filename)) == null) {
                    in = ClassLoader.getSystemResourceAsStream(filename);
                }
                if (in == null) {
                    in = ClassLoader.getSystemResourceAsStream(filename);
                }
                if (in == null) break block26;
                int offset = 0;
                int length = 0;
                int bytesRead = -1;
                imageArray = new byte[8192];
                try {
                    do {
                        if ((bytesRead = in.read(imageArray, offset, length = imageArray.length - offset)) < 0 || (offset += bytesRead) < imageArray.length) continue;
                        image2 = new byte[imageArray.length * 2];
                        System.arraycopy(imageArray, 0, image2, 0, offset);
                        imageArray = image2;
                    } while (bytesRead >= 0);
                }
                catch (Exception image22) {
                    // empty catch block
                }
                if (offset > 0) {
                    if (imageArray.length > offset) {
                        image2 = new byte[offset];
                        System.arraycopy(imageArray, 0, image2, 0, offset);
                        imageArray = image2;
                    }
                    return toolkit.createImage(imageArray);
                }
            }
            catch (Exception imageArray) {
                // empty catch block
            }
        }
        try {
            if (Utilities.isApplet() || filename.indexOf("://") >= 0) {
                try {
                    if (filename.indexOf("://") >= 0) {
                        location = new URL(filename);
                        Image img = Utilities.getApplet().getImage(location);
                        if (img != null) {
                            return img;
                        }
                        throw new Exception("Next");
                    }
                    try {
                        location = new URL(Utilities.getDocumentBase(), filename);
                        Image img = Utilities.getApplet().getImage(location);
                        if (img != null) {
                            return img;
                        }
                        throw new Exception("Next");
                    }
                    catch (Exception notFoundAtDocBase) {
                        try {
                            location = new URL(Utilities.getCodeBase(), filename);
                            Image img = Utilities.getApplet().getImage(location);
                            if (img != null) {
                                return img;
                            }
                            throw new Exception("Next");
                        }
                        catch (Exception notFoundAtCodeBase) {
                            location = new URL(filename);
                            Image img = Utilities.getApplet().getImage(location);
                            if (img != null) {
                                return img;
                            }
                            throw new Exception("Next");
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toolkit.getImage(filename);
    }

    public static int remapColor(int source) {
        int dest = source & 0xFFFFFF;
        for (int i = 0; i < remapColors.length; ++i) {
            if (dest != remapColors[i]) continue;
            switch (dest) {
                case -16777216: {
                    return SystemColor.controlText.getRGB();
                }
                case -8355712: {
                    return SystemColor.controlShadow.getRGB();
                }
                case -4144960: {
                    return SystemColor.control.getRGB();
                }
                case -1: {
                    return SystemColor.controlHighlight.getRGB();
                }
                case -16776961: {
                    return SystemColor.textHighlight.getRGB();
                }
                case -65281: {
                    return SystemColor.window.getRGB();
                }
            }
        }
        return source;
    }
}

