/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.MediaImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;

class MediaImageICO {
    private static final int BI_RGB = 0;
    private IconImage[] iconImages = null;
    private MemoryImageSource[] mis = null;
    private int curPos = 0;

    private int read(InputStream is) throws IOException {
        ++this.curPos;
        return is.read();
    }

    private boolean seek(InputStream is, int position) throws IOException {
        while (this.curPos < position) {
            if (this.read(is) >= 0) continue;
            return false;
        }
        return true;
    }

    MediaImageICO(InputStream is) throws IOException {
        this(is, 0);
    }

    MediaImageICO(InputStream is, int iconIndex) throws IOException {
        int i;
        int numImages = this.readHeader(is);
        if (numImages < 1) {
            throw new IOException("No icons present");
        }
        this.iconImages = new IconImage[numImages];
        IconDirEntry[] ide = new IconDirEntry[numImages];
        for (int i2 = 0; i2 < ide.length; ++i2) {
            ide[i2] = new IconDirEntry();
            this.readIDE(is, ide[i2]);
        }
        IconDirEntry swap = null;
        int length = ide.length;
        for (i = 0; i < length - 1; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (ide[i].imageOffset <= ide[j].imageOffset) continue;
                swap = ide[i];
                ide[i] = ide[j];
                ide[j] = swap;
            }
        }
        this.mis = new MemoryImageSource[ide.length];
        for (i = 0; i < ide.length; ++i) {
            int ix;
            this.iconImages[i] = new IconImage();
            this.iconImages[i].bmiHeader = new BitmapInfo();
            this.iconImages[i].numBytes = ide[i].bytesInRes;
            this.seek(is, ide[i].imageOffset);
            this.iconImages[i].bmiHeader = new BitmapInfo();
            this.readBMIHeader(is, this.iconImages[i].bmiHeader);
            MediaImageICO.AdjustIconImagePointers(this.iconImages[i]);
            int width = this.iconImages[i].width;
            int height = this.iconImages[i].height;
            short bitCount = this.iconImages[i].bmiHeader.bitCount;
            Color[] cmap = null;
            Color alpha = null;
            int alphaRGB = SystemColor.control.getRGB();
            try {
                Class<Color> colorClass = Color.class;
                Constructor constructor = colorClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                Integer zero = new Integer(0);
                alpha = (Color)constructor.newInstance(zero, zero, zero, zero);
            }
            catch (Throwable colorClass) {
                // empty catch block
            }
            if (alpha != null) {
                alphaRGB = alpha.getRGB();
            }
            if (bitCount != 24) {
                int cmaplen = this.iconImages[i].bmiHeader.clrUsed != 0 ? this.iconImages[i].bmiHeader.clrUsed : 1 << bitCount;
                cmap = new Color[cmaplen + 1];
                for (ix = 0; ix < cmaplen; ++ix) {
                    int b = this.read(is);
                    int g = this.read(is);
                    int r = this.read(is);
                    cmap[ix] = new Color(r, g, b);
                }
                cmap[ix] = new Color(127, 127, 127);
            }
            int limit = bitCount == 24 ? width * height * 3 : width * height;
            byte[] map = new byte[limit];
            byte[] mapAlpha = new byte[limit];
            switch (bitCount) {
                case 1: {
                    this.readIcon1(is, map, width, height, mapAlpha);
                    break;
                }
                case 4: {
                    this.readIcon4(is, map, width, height, this.iconImages[i].bmiHeader.compression, mapAlpha);
                    break;
                }
                case 8: {
                    this.readIcon8(is, map, width, height, this.iconImages[i].bmiHeader.compression, mapAlpha);
                    break;
                }
                default: {
                    this.readIcon24(is, map, width, height, mapAlpha);
                }
            }
            int[] image = new int[width * height];
            this.iconImages[i].bits = image;
            if (bitCount == 24) {
                for (ix = 0; ix < image.length; ++ix) {
                    image[ix] = mapAlpha[ix] != 0 && alpha != null ? alphaRGB : (map[3 * ix] & 0xFF) << 16 | (map[3 * ix + 1] & 0xFF) << 8 | map[3 * ix + 2] & 0xFF;
                }
                continue;
            }
            for (ix = 0; ix < image.length; ++ix) {
                image[ix] = mapAlpha[ix] != 0 && alpha != null ? alphaRGB : MediaImage.remapColor(cmap[map[ix] & 0xFF].getRGB());
            }
        }
    }

    int getIconCount() {
        return this.iconImages.length;
    }

    MemoryImageSource getMemoryImageSource(int i) {
        try {
            if (this.mis[i] == null) {
                this.mis[i] = new MemoryImageSource(this.iconImages[i].width, this.iconImages[i].height, this.iconImages[i].bits, 0, this.iconImages[i].width);
            }
            return this.mis[i];
        }
        catch (Exception noSuchIcon) {
            return null;
        }
    }

    Image getImage(int i) {
        MemoryImageSource mis = this.getMemoryImageSource(i);
        if (mis == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    private static void AdjustIconImagePointers(IconImage image) throws IOException {
        image.width = image.bmiHeader.width;
        image.height = image.bmiHeader.height / 2;
        image.colors = 1 << image.bmiHeader.bitCount;
    }

    private int readHeader(InputStream is) throws IOException {
        if (this.readInt16(is) != 0) {
            throw new IOException("Unexpected format");
        }
        if (this.readInt16(is) != 1) {
            throw new IOException("Unexpected format");
        }
        return this.readInt16(is);
    }

    private int readInt16(InputStream is) throws IOException {
        return this.read(is) | this.read(is) << 8;
    }

    private int readInt32(InputStream is) throws IOException {
        return this.read(is) | this.read(is) << 8 | this.read(is) << 16 | this.read(is) << 24;
    }

    private void readIDE(InputStream is, IconDirEntry ide) throws IOException {
        ide.width = (byte)this.read(is);
        ide.height = (byte)this.read(is);
        ide.colorCount = (byte)this.read(is);
        ide.reserved = (byte)this.read(is);
        ide.planes = (short)this.readInt16(is);
        ide.bitCount = (short)this.readInt16(is);
        ide.bytesInRes = this.readInt32(is);
        ide.imageOffset = this.readInt32(is);
    }

    private void readBMIHeader(InputStream is, BitmapInfo bmi) throws IOException {
        bmi.size = this.readInt32(is);
        bmi.width = this.readInt32(is);
        bmi.height = this.readInt32(is);
        bmi.planes = (short)this.readInt16(is);
        bmi.bitCount = (short)this.readInt16(is);
        bmi.compression = this.readInt32(is);
        bmi.sizeImage = this.readInt32(is);
        bmi.xPelsPerMeter = this.readInt32(is);
        bmi.yPelsPerMeter = this.readInt32(is);
        bmi.clrUsed = this.readInt32(is);
        bmi.clrImportant = this.readInt32(is);
    }

    private void readAndBitmap(InputStream is, byte[] map, int w, int h, byte[] mapAlpha) throws IOException {
        int c = 0;
        int padw = (w + 31) / 32 * 32;
        for (int i = h - 1; i >= 0; --i) {
            int bitnum = 0;
            int j = 0;
            while (j < padw) {
                if ((bitnum & 7) == 0) {
                    c = this.read(is);
                    bitnum = 0;
                }
                if (j < w) {
                    mapAlpha[j + i * w] = (byte)((c & 0x80) != 0 ? 1 : 0);
                    c <<= 1;
                }
                ++j;
                ++bitnum;
            }
        }
    }

    private void readIcon1(InputStream is, byte[] map, int w, int h, byte[] mapAlpha) throws IOException {
        int c = 0;
        int padw = (w + 31) / 32 * 32;
        for (int i = h - 1; i >= 0; --i) {
            int bitnum = 0;
            int j = 0;
            while (j < padw) {
                if ((bitnum & 7) == 0) {
                    c = this.read(is);
                    bitnum = 0;
                }
                if (j < w) {
                    map[j + i * w] = (byte)((c & 0x80) != 0 ? 1 : 0);
                    c <<= 1;
                }
                ++j;
                ++bitnum;
            }
        }
        this.readAndBitmap(is, map, w, h, mapAlpha);
    }

    private void readIcon4(InputStream is, byte[] map, int w, int h, int comp, byte[] mapAlpha) throws IOException {
        int c = 0;
        if (comp == 0) {
            int padw = (w + 7) / 8 * 8;
            for (int i = h - 1; i >= 0; --i) {
                int nybnum = 0;
                int j = 0;
                while (j < padw) {
                    if ((nybnum & 1) == 0) {
                        c = this.read(is);
                        nybnum = 0;
                    }
                    if (j < w) {
                        map[j + i * w] = (byte)((c & 0xF0) >>> 4);
                        c <<= 4;
                    }
                    ++j;
                    ++nybnum;
                }
            }
        } else {
            throw new IOException("Compression is not supported");
        }
        this.readAndBitmap(is, map, w, h, mapAlpha);
    }

    private void readIcon8(InputStream is, byte[] map, int w, int h, int comp, byte[] mapAlpha) throws IOException {
        if (comp == 0) {
            int padw = (w + 3) / 4 * 4;
            for (int i = h - 1; i >= 0; --i) {
                for (int j = 0; j < padw; ++j) {
                    int c = this.read(is);
                    if (j >= w) continue;
                    map[j + i * w] = (byte)c;
                }
            }
        } else {
            throw new IOException("Compression is not supported");
        }
        this.readAndBitmap(is, map, w, h, mapAlpha);
    }

    private void readIcon24(InputStream is, byte[] map, int w, int h, byte[] mapAlpha) throws IOException {
        int offset = 0;
        int padb = 4 - w * 3 % 4 & 3;
        for (int i = h - 1; i >= 0; --i) {
            int j;
            for (j = 0; j < w; ++j) {
                int b = this.read(is);
                int g = this.read(is);
                int r = this.read(is);
                offset = 3 * (j + i * w);
                map[offset] = (byte)r;
                map[offset + 1] = (byte)g;
                map[offset + 2] = (byte)b;
            }
            for (j = 0; j < padb; ++j) {
                is.read();
            }
        }
        this.readAndBitmap(is, map, w, h, mapAlpha);
    }

    class IconDirEntry {
        byte width;
        byte height;
        byte colorCount;
        byte reserved;
        short planes;
        short bitCount;
        int bytesInRes;
        int imageOffset;

        IconDirEntry() {
        }
    }

    class BitmapInfo {
        int size;
        int width;
        int height;
        short planes;
        short bitCount;
        int compression;
        int sizeImage;
        int xPelsPerMeter;
        int yPelsPerMeter;
        int clrUsed;
        int clrImportant;

        BitmapInfo() {
        }
    }

    class IconImage {
        int width;
        int height;
        int colors;
        int[] bits = null;
        int numBytes;
        BitmapInfo bmiHeader;

        IconImage() {
        }
    }
}

