/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.ExternalUnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Interval;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.QuickVector;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.XOpenInternational;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import sun.misc.Unsafe;

public class Memory {
    protected final byte[] memory;
    protected final String programName;
    protected boolean odoSlideMode = false;
    public boolean alwaysFlush = Cache.alwaysFlush;
    public static char ALSO = (char)63743;
    public static char HIGH = (char)255;
    public static char LOW = '\u0000';
    private static char globalCurrencySymbol = XOpenInternational.currencySymbol;
    private static char globalCommaSymbol = (char)(RuntimeEnvironment.isIBM ? 44 : (int)XOpenInternational.groupingSymbol);
    private static char globalDecimalSymbol = (char)(RuntimeEnvironment.isIBM ? 46 : (int)XOpenInternational.decimalSymbol);
    private static String globalCollatingSequence = null;
    private static char globalLowValue = LOW;
    private static char globalHighValue = HIGH;
    private Interval[] intervals;
    private int intervalCount;
    private boolean dynamic = false;
    private boolean shared = false;
    private static Unsafe theUnsafe = null;
    private static boolean is64bitJVM = false;
    private static int byteArrOffset = 16;
    private static int baseOffset = 0;

    public Memory() {
        this.memory = new byte[0];
        this.programName = null;
    }

    public Memory(int setAvailableMemory, String ... name) {
        this.memory = new byte[setAvailableMemory];
        this.programName = name.length == 1 ? name[0] : null;
    }

    public Memory(int setAvailableMemory, String dataSectionName) {
        this.memory = new byte[setAvailableMemory];
        this.programName = dataSectionName;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("Memory(int setAvailableMemory,String dataSectionName):  memory.length=" + this.memory.length + ". dataSectionName=" + dataSectionName + ". ");
        }
    }

    public Memory(int setAvailableMemory, boolean decimalIsComma) {
        this.memory = new byte[setAvailableMemory];
        this.programName = null;
        if (decimalIsComma) {
            Memory.setDecimalIsComma();
        }
    }

    public Memory(int setAvailableMemory, String programName, boolean decimalIsComma) {
        this.memory = new byte[setAvailableMemory];
        this.programName = programName;
        if (decimalIsComma) {
            Memory.setDecimalIsComma();
        }
    }

    public Memory(byte[] data) {
        this.memory = data;
        this.programName = "Dynamic";
    }

    public Memory(boolean decimalIsComma) {
        this.memory = new byte[0];
        this.programName = null;
        if (decimalIsComma) {
            Memory.setDecimalIsComma();
        }
    }

    public Memory(byte[] data, boolean decimalIsComma) {
        this.memory = data;
        this.programName = "Dynamic";
        if (decimalIsComma) {
            Memory.setDecimalIsComma();
        }
    }

    public void Destructor() {
    }

    public int getTopOfMemory() {
        return this.memory.length;
    }

    public static char getGlobalCurrency() {
        return globalCurrencySymbol;
    }

    public static char getGlobalComma() {
        return globalCommaSymbol;
    }

    public static char getGlobalDecimal() {
        return globalDecimalSymbol;
    }

    public static String getGlobalCollatingSequence() {
        return globalCollatingSequence;
    }

    public static void setGlobalCurrency(char c) {
        globalCurrencySymbol = c;
    }

    public static void setGlobalComma(char c) {
        globalCommaSymbol = c;
    }

    public static void setGlobalDecimal(char c) {
        globalDecimalSymbol = c;
    }

    public static void setGlobalCollatingSequence(String s) {
        globalCollatingSequence = s;
        if (s == null) {
            return;
        }
        globalLowValue = s.charAt(0);
        for (globalHighValue = HIGH; globalHighValue > '\u0000' && s.indexOf(globalHighValue) >= 0; globalHighValue = (char)(globalHighValue - '\u0001')) {
        }
        if (globalHighValue < '\u0000') {
            globalHighValue = HIGH;
        }
    }

    public static void setDecimalIsComma() {
        globalDecimalSymbol = (char)44;
        globalCommaSymbol = (char)46;
    }

    public String getCollatingSequence() {
        if (globalCollatingSequence == null) {
            return XOpenInternational.collatingSequence;
        }
        return globalCollatingSequence;
    }

    public char getHighValue() {
        return globalHighValue;
    }

    public char getLowValue() {
        return globalLowValue;
    }

    public void setCollatingSequence(String collatingSequence) {
        if (collatingSequence != null) {
            Memory.setGlobalCollatingSequence(collatingSequence);
        }
    }

    public void pad(int from, int size) {
        while (size-- > 0) {
            this.memory[from++] = Variable.SPACE_BYTE;
        }
    }

    public void copy(int from, byte[] toArray, int to, int size) {
        System.arraycopy(this.memory, from, toArray, to, size);
    }

    public void copy(int from, Memory toMemory, int to, int size) {
        if (from < 0 || from > this.memory.length || to < 0 || to > toMemory.getTopOfMemory()) {
            throw new RuntimeException("MOVE outside memory range");
        }
        if (size > this.memory.length - from) {
            size = this.memory.length - from;
        }
        if (size > toMemory.getTopOfMemory() - to) {
            size = toMemory.getTopOfMemory() - to;
        }
        if (toMemory.getClass() == this.getClass() || !toMemory.getClass().getName().contains("External")) {
            System.arraycopy(this.memory, from, toMemory.memory, to, size);
        } else {
            toMemory.copy(this.memory, from, to, size);
        }
    }

    public void copy(byte[] fromArray, int from, int to, int size) {
        System.arraycopy(fromArray, from, this.memory, to, size);
    }

    public void copy(Memory fromMemory, int from, int to, int size) {
        if (fromMemory instanceof ExternalUnbufferedMemory) {
            if (fromMemory.memory.length < size) {
                System.arraycopy(fromMemory.getBytes(from, fromMemory.memory.length), 0, this.memory, to, fromMemory.memory.length);
            } else {
                System.arraycopy(fromMemory.getBytes(from, size), 0, this.memory, to, size);
            }
        } else if (fromMemory.memory.length < size) {
            System.arraycopy(fromMemory.memory, from, this.memory, to, fromMemory.memory.length);
        } else {
            System.arraycopy(fromMemory.memory, from, this.memory, to, size);
        }
    }

    public void copy(int from, int to, int size) {
        int topOfMemory = this.memory.length;
        if (from + size > topOfMemory) {
            size = topOfMemory - from;
        }
        if (to + size > topOfMemory) {
            size = topOfMemory - to;
        }
        if (size > 0) {
            System.arraycopy(this.memory, from, this.memory, to, size);
        }
    }

    public byte[] getBytes(int addr, int len) {
        byte[] b = new byte[len];
        this.copy(addr, b, 0, len);
        return b;
    }

    public String toString(int addr, int len, String enc) throws UnsupportedEncodingException {
        return new String(this.memory, addr, len, enc);
    }

    public String toString(int addr, int len, Charset enc) {
        return new String(this.memory, addr, len, enc);
    }

    public void set(int address, int size, byte b) {
        int last = address + size;
        while (address < last) {
            this.memory[address++] = b;
        }
    }

    public void fill(char c) {
        byte b = (byte)c;
        int length = this.memory.length;
        for (int i = 0; i < length; ++i) {
            this.memory[i] = b;
        }
    }

    public void fill(byte b) {
        int length = this.memory.length;
        for (int i = 0; i < length; ++i) {
            this.memory[i] = b;
        }
    }

    public void fillZero() {
        byte b = 0;
        int length = this.memory.length;
        for (int i = 0; i < length; ++i) {
            this.memory[i] = b;
        }
    }

    public void fillSpace() {
        byte b = Variable.SPACE_BYTE;
        int length = this.memory.length;
        for (int i = 0; i < length; ++i) {
            this.memory[i] = b;
        }
    }

    public byte getByte(int n) {
        return this.memory[n];
    }

    public byte getByteReverse(int n) {
        return this.memory[n];
    }

    public char getChar(int n) {
        return (char)(this.memory[n] & 0xFF);
    }

    public char getCharReverse(int n) {
        return (char)(this.memory[n] & 0xFF);
    }

    public short getShort(int n) {
        return (short)((this.memory[n] & 0xFF) << 8 | this.memory[n + 1] & 0xFF);
    }

    public short getShortReverse(int n) {
        return (short)((this.memory[n + 1] & 0xFF) << 8 | this.memory[n] & 0xFF);
    }

    public long getData(int addr, int size) {
        long value = 0L;
        byte piece = 0;
        if ((this.memory[addr] & 0x80) == 128) {
            long signmask = -1L;
            for (int i = 0; i < size; ++i) {
                piece = this.memory[addr + i];
                value <<= 8;
                value |= (long)(piece & 0xFF);
                signmask <<= 8;
            }
            value |= signmask;
        } else {
            for (int i = 0; i < size; ++i) {
                piece = this.memory[addr + i];
                value <<= 8;
                value |= (long)(piece & 0xFF);
            }
        }
        return value;
    }

    public long getDataReverse(int addr, int size) {
        long value = 0L;
        byte piece = 0;
        if ((this.memory[addr + size - 1] & 0x80) == 128) {
            long signmask = -1L;
            for (int i = 0; i < size; ++i) {
                piece = this.memory[addr + size - i - 1];
                value <<= 8;
                value |= (long)(piece & 0xFF);
                signmask <<= 8;
            }
            value |= signmask;
        } else {
            for (int i = 0; i < size; ++i) {
                piece = this.memory[addr + size - i - 1];
                value <<= 8;
                value |= (long)(piece & 0xFF);
            }
        }
        return value;
    }

    public int getInt(int n) {
        return (this.memory[n] & 0xFF) << 24 | (this.memory[n + 1] & 0xFF) << 16 | (this.memory[n + 2] & 0xFF) << 8 | this.memory[n + 3] & 0xFF;
    }

    public int getIntReverse(int n) {
        return (this.memory[n + 3] & 0xFF) << 24 | (this.memory[n + 2] & 0xFF) << 16 | (this.memory[n + 1] & 0xFF) << 8 | this.memory[n] & 0xFF;
    }

    public long getLong(int n) {
        return (long)(this.memory[n] & 0xFF) << 56 | (long)(this.memory[n + 1] & 0xFF) << 48 | (long)(this.memory[n + 2] & 0xFF) << 40 | (long)(this.memory[n + 3] & 0xFF) << 32 | (long)(this.memory[n + 4] & 0xFF) << 24 | (long)(this.memory[n + 5] & 0xFF) << 16 | (long)(this.memory[n + 6] & 0xFF) << 8 | (long)(this.memory[n + 7] & 0xFF);
    }

    public long getLongReverse(int n) {
        return (long)(this.memory[n + 7] & 0xFF) << 56 | (long)(this.memory[n + 6] & 0xFF) << 48 | (long)(this.memory[n + 5] & 0xFF) << 40 | (long)(this.memory[n + 4] & 0xFF) << 32 | (long)(this.memory[n + 3] & 0xFF) << 24 | (long)(this.memory[n + 2] & 0xFF) << 16 | (long)(this.memory[n + 1] & 0xFF) << 8 | (long)(this.memory[n] & 0xFF);
    }

    public double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    public float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public double getDouble370(int n) {
        long value = this.getLong(n);
        value = ConvertData.d370toIEEE(value);
        return Double.longBitsToDouble(value);
    }

    public float getFloat370(int n) {
        int value = this.getInt(n);
        value = ConvertData.f370toIEEE(value) & 0xFFFFFFFF;
        return Float.intBitsToFloat(value);
    }

    public double getDoubleReverse(int n) {
        long v = this.getLong(n);
        int b1 = (int)(v & 0xFFL);
        int b2 = (int)(v >> 8 & 0xFFL);
        int b3 = (int)(v >> 16 & 0xFFL);
        int b4 = (int)(v >> 24 & 0xFFL);
        int b5 = (int)(v >> 32 & 0xFFL);
        int b6 = (int)(v >> 40 & 0xFFL);
        int b7 = (int)(v >> 48 & 0xFFL);
        int b8 = (int)(v >> 56 & 0xFFL);
        v = (long)b1 << 56 | (long)b2 << 48 | (long)b3 << 40 | (long)b4 << 32 | (long)b5 << 24 | (long)b6 << 16 | (long)b7 << 8 | (long)b8;
        return Double.longBitsToDouble(v);
    }

    public float getFloatReverse(int n) {
        int v = this.getInt(n);
        int b1 = v & 0xFF;
        int b2 = v >> 8 & 0xFF;
        int b3 = v >> 16 & 0xFF;
        int b4 = v >> 24 & 0xFF;
        v = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        return Float.intBitsToFloat(v);
    }

    public void setByte(int n, byte b) {
        this.memory[n] = b;
    }

    public void setByteReverse(int n, byte b) {
        this.memory[n] = b;
    }

    public void setChar(int n, char c) {
        this.memory[n] = (byte)c;
    }

    public void setCharReverse(int n, char c) {
        this.memory[n] = (byte)c;
    }

    public void setShort(int n, short s) {
        this.memory[n] = (byte)(s >> 8 & 0xFF);
        this.memory[n + 1] = (byte)(s & 0xFF);
    }

    public void setShortReverse(int n, short s) {
        this.memory[n + 1] = (byte)(s >> 8 & 0xFF);
        this.memory[n] = (byte)(s & 0xFF);
    }

    public void setInt(int n, int i) {
        this.memory[n] = (byte)(i >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(i >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(i >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(i & 0xFF);
    }

    public void setIntReverse(int n, int i) {
        this.memory[n + 3] = (byte)(i >> 24 & 0xFF);
        this.memory[n + 2] = (byte)(i >> 16 & 0xFF);
        this.memory[n + 1] = (byte)(i >> 8 & 0xFF);
        this.memory[n] = (byte)(i & 0xFF);
    }

    public void setLong(int n, long l) {
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.memory[n] = (byte)(ms >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(ms >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(ms >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(ms & 0xFF);
        this.memory[n + 4] = (byte)(ls >> 24 & 0xFF);
        this.memory[n + 5] = (byte)(ls >> 16 & 0xFF);
        this.memory[n + 6] = (byte)(ls >> 8 & 0xFF);
        this.memory[n + 7] = (byte)(ls & 0xFF);
    }

    public void setLongReverse(int n, long l) {
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.memory[n + 7] = (byte)(ms >> 24 & 0xFF);
        this.memory[n + 6] = (byte)(ms >> 16 & 0xFF);
        this.memory[n + 5] = (byte)(ms >> 8 & 0xFF);
        this.memory[n + 4] = (byte)(ms & 0xFF);
        this.memory[n + 3] = (byte)(ls >> 24 & 0xFF);
        this.memory[n + 2] = (byte)(ls >> 16 & 0xFF);
        this.memory[n + 1] = (byte)(ls >> 8 & 0xFF);
        this.memory[n] = (byte)(ls & 0xFF);
    }

    public void setData(int addr, long value, int size) {
        int pointer = 0;
        pointer = addr + size - 1;
        for (int i = 0; i < size; ++i) {
            byte piece;
            this.memory[pointer] = piece = (byte)(value & 0xFFL);
            --pointer;
            value >>= 8;
        }
    }

    public void setDataReverse(int addr, long value, int size) {
        int pointer = addr;
        for (int i = 0; i < size; ++i) {
            byte piece;
            this.memory[pointer] = piece = (byte)(value & 0xFFL);
            ++pointer;
            value >>= 8;
        }
    }

    public void setDouble(int n, double d) {
        long l = Double.doubleToLongBits(d);
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.memory[n] = (byte)(ms >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(ms >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(ms >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(ms & 0xFF);
        this.memory[n + 4] = (byte)(ls >> 24 & 0xFF);
        this.memory[n + 5] = (byte)(ls >> 16 & 0xFF);
        this.memory[n + 6] = (byte)(ls >> 8 & 0xFF);
        this.memory[n + 7] = (byte)(ls & 0xFF);
    }

    public void setDouble370(int n, double d) {
        long src = Double.doubleToLongBits(d);
        long l = ConvertData.dIEEEto370(src);
        int ms = (int)(l >> 32);
        int ls = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.memory[n] = (byte)(ms >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(ms >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(ms >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(ms & 0xFF);
        this.memory[n + 4] = (byte)(ls >> 24 & 0xFF);
        this.memory[n + 5] = (byte)(ls >> 16 & 0xFF);
        this.memory[n + 6] = (byte)(ls >> 8 & 0xFF);
        this.memory[n + 7] = (byte)(ls & 0xFF);
    }

    public void setFloat(int n, float f) {
        int i = Float.floatToIntBits(f);
        this.memory[n] = (byte)(i >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(i >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(i >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(i & 0xFF);
    }

    public void setFloat370(int n, float f) {
        int src = Float.floatToIntBits(f);
        int i = ConvertData.fIEEEto370(src);
        this.memory[n] = (byte)(i >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(i >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(i >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(i & 0xFF);
    }

    public void setDoubleReverse(int n, double d) {
        long v = Double.doubleToLongBits(d);
        int b1 = (int)(v & 0xFFL);
        int b2 = (int)(v >> 8 & 0xFFL);
        int b3 = (int)(v >> 16 & 0xFFL);
        int b4 = (int)(v >> 24 & 0xFFL);
        int b5 = (int)(v >> 32 & 0xFFL);
        int b6 = (int)(v >> 40 & 0xFFL);
        int b7 = (int)(v >> 48 & 0xFFL);
        int b8 = (int)(v >> 56 & 0xFFL);
        v = (long)b1 << 56 | (long)b2 << 48 | (long)b3 << 40 | (long)b4 << 32 | (long)b5 << 24 | (long)b6 << 16 | (long)b7 << 8 | (long)b8;
        int ms = (int)(v >> 32);
        int ls = (int)(v & 0xFFFFFFFFFFFFFFFFL);
        this.memory[n] = (byte)(ms >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(ms >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(ms >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(ms & 0xFF);
        this.memory[n + 4] = (byte)(ls >> 24 & 0xFF);
        this.memory[n + 5] = (byte)(ls >> 16 & 0xFF);
        this.memory[n + 6] = (byte)(ls >> 8 & 0xFF);
        this.memory[n + 7] = (byte)(ls & 0xFF);
    }

    public void setFloatReverse(int n, float f) {
        int v = Float.floatToIntBits(f);
        int b1 = v & 0xFF;
        int b2 = v >> 8 & 0xFF;
        int b3 = v >> 16 & 0xFF;
        int b4 = v >> 24 & 0xFF;
        v = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        this.memory[n] = (byte)(v >> 24 & 0xFF);
        this.memory[n + 1] = (byte)(v >> 16 & 0xFF);
        this.memory[n + 2] = (byte)(v >> 8 & 0xFF);
        this.memory[n + 3] = (byte)(v & 0xFF);
    }

    public char getCurrency() {
        return globalCurrencySymbol;
    }

    public void setCurrency(char currencySymbol) {
        Memory.setGlobalCurrency(currencySymbol);
    }

    public char getComma() {
        return globalCommaSymbol;
    }

    public void setComma(char commaSymbol) {
        Memory.setGlobalComma(commaSymbol);
    }

    public char getDecimal() {
        return globalDecimalSymbol;
    }

    public void setDecimal(char decimalSymbol) {
        Memory.setGlobalDecimal(decimalSymbol);
    }

    public String toString() {
        if (this.programName != null) {
            return "Memory (" + this.programName + ": " + System.identityHashCode(this) + ")";
        }
        return "Memory (" + System.identityHashCode(this) + ")";
    }

    public void flushToMemory(Variable v, boolean andInvalidate) {
    }

    public void invalidateCache(Variable v) {
        v.dirty = false;
        v.valid = false;
        QuickVector notify = v.notify;
        if (notify != null) {
            int l = notify.size();
            for (int i = l - 1; i >= 0; --i) {
                Variable other = notify.elementData[i];
                other.dirty = false;
                other.valid = false;
            }
        }
    }

    public void removeNotify(Variable v) {
        if (this.alwaysFlush || v.alwaysFlush) {
            return;
        }
        QuickVector notify = v.notify;
        if (notify != null) {
            int l = notify.size();
            for (int i = l - 1; i >= 0; --i) {
                Variable other = notify.elementData[i];
                if (other.notify == null) continue;
                if (other.notify.size() == 1) {
                    other.notify = null;
                    continue;
                }
                other.notify.removeElement(v);
            }
            v.notify = null;
        }
        this.removeInterval(v);
        for (v = v.getChild(); v != null; v = v.getSibling()) {
            this.removeNotify(v);
        }
    }

    private final void removeInterval(Variable v) {
        int start = v.pointerAddress;
        int end = start + v.itemSize - 1;
        int hi = this.intervalCount - 1;
        int lo = 0;
        int index = (hi + lo) / 2;
        while (hi >= lo) {
            int intervalsStart = this.intervals[index].start;
            if (intervalsStart > start) {
                hi = index - 1;
                index = (hi + lo) / 2;
                continue;
            }
            if (intervalsStart >= start) break;
            lo = index + 1;
            index = (hi + lo) / 2;
        }
        if (v.isNumericInstance()) {
            while (index < this.intervalCount && this.intervals[index].start <= end) {
                this.intervals[index++].removeElementNums(v);
            }
        } else {
            while (index < this.intervalCount && this.intervals[index].start <= end) {
                this.intervals[index++].removeElementVars(v);
            }
        }
    }

    public void addNotifyChildren(Variable v) {
        if (this.alwaysFlush || v.alwaysFlush) {
            return;
        }
        this.addNotifyChildrenInternal(v);
    }

    public void addNotify(Variable v) {
        if (this.alwaysFlush || v.alwaysFlush) {
            return;
        }
        this.addNotifyInternal(v);
    }

    public void delayNotifyChildren(Variable v) {
        v.notifyDelayed = true;
        for (v = v.getChild(); v != null; v = v.getSibling()) {
            this.delayNotifyChildren(v);
        }
    }

    private final void addNotifyChildrenInternal(Variable v) {
        this.addNotifyInternal(v);
        for (v = v.getChild(); v != null; v = v.getSibling()) {
            this.addNotifyChildrenInternal(v);
        }
    }

    private final void addNotifyInternal(Variable v) {
        if (this.intervals == null) {
            this.intervals = new Interval[128];
        }
        int size = v.itemSize;
        int start = v.pointerAddress;
        int end = start + size - 1;
        int hi = this.intervalCount - 1;
        int lo = 0;
        int index = (hi + lo) / 2;
        while (hi >= lo) {
            int intervalsStart = this.intervals[index].start;
            if (intervalsStart > start) {
                hi = index - 1;
                index = (hi + lo) / 2;
                continue;
            }
            if (intervalsStart >= start) break;
            lo = index + 1;
            index = (hi + lo) / 2;
        }
        QuickVector notify = null;
        int startIndex = index;
        if (v.isNumericInstance()) {
            Interval[] newIntervals;
            int endIndex;
            Variable other;
            int i;
            Variable[] elementData;
            int pointers_size;
            QuickVector pointers;
            if (index < this.intervalCount && this.intervals[index].start <= end) {
                int size2;
                int addr2;
                pointers = this.intervals[index].vars;
                if (pointers == null) {
                    this.intervals[index].vars = new QuickVector();
                } else {
                    pointers_size = pointers.size();
                    elementData = pointers.elementData;
                    for (i = 0; i < pointers_size; ++i) {
                        other = elementData[i];
                        addr2 = other.pointerAddress;
                        size2 = other.itemSize;
                        if (!(start <= addr2 ? end >= addr2 : size2 + addr2 - 1 >= start)) continue;
                        if (notify == null) {
                            notify = new QuickVector(other);
                        } else {
                            notify.addElement(other);
                        }
                        if (other.notify == null) {
                            other.notify = new QuickVector(v);
                            continue;
                        }
                        other.notify.addElement(v);
                    }
                }
                pointers = this.intervals[index].nums;
                if (pointers == null) {
                    this.intervals[index].nums = new QuickVector();
                } else {
                    pointers_size = pointers.size();
                    elementData = pointers.elementData;
                    for (i = 0; i < pointers_size; ++i) {
                        other = elementData[i];
                        if (v == other) continue;
                        addr2 = other.pointerAddress;
                        size2 = other.itemSize;
                        if (!(start <= addr2 ? end >= addr2 : size2 + addr2 - 1 >= start)) continue;
                        if (notify == null) {
                            notify = new QuickVector(other);
                        } else {
                            notify.addElement(other);
                        }
                        if (other.notify == null) {
                            other.notify = new QuickVector(v);
                            continue;
                        }
                        other.notify.addElement(v);
                    }
                }
                ++index;
            }
            while (index < this.intervalCount && this.intervals[index].start <= end) {
                pointers = this.intervals[index].vars;
                if (pointers == null) {
                    this.intervals[index].vars = new QuickVector();
                } else {
                    pointers_size = pointers.size();
                    elementData = pointers.elementData;
                    for (i = 0; i < pointers_size; ++i) {
                        other = elementData[i];
                        if (other.firstIntervalPage != this.intervals[index] || end < other.pointerAddress) continue;
                        if (notify == null) {
                            notify = new QuickVector(other);
                        } else {
                            notify.addElement(other);
                        }
                        if (other.notify == null) {
                            other.notify = new QuickVector(v);
                            continue;
                        }
                        other.notify.addElement(v);
                    }
                }
                pointers = this.intervals[index].nums;
                if (pointers == null) {
                    this.intervals[index].nums = new QuickVector();
                } else {
                    pointers_size = pointers.size();
                    elementData = pointers.elementData;
                    for (i = 0; i < pointers_size; ++i) {
                        other = elementData[i];
                        if (other.firstIntervalPage != this.intervals[index] || v == other || end < other.pointerAddress) continue;
                        if (notify == null) {
                            notify = new QuickVector(other);
                        } else {
                            notify.addElement(other);
                        }
                        if (other.notify == null) {
                            other.notify = new QuickVector(v);
                            continue;
                        }
                        other.notify.addElement(v);
                    }
                }
                ++index;
            }
            v.notify = notify;
            if ((endIndex = --index) < startIndex) {
                if (endIndex < 0) {
                    this.intervals[0] = new Interval(start, end, v);
                    this.intervalCount = 1;
                    return;
                }
                endIndex = startIndex;
            }
            if (index < 0) {
                index = 0;
            }
            int carry_start = start;
            int carry_end = end;
            boolean carry = true;
            Interval insertion = null;
            Interval insertion2 = null;
            Interval existingInterval = null;
            v.firstIntervalPage = null;
            for (index = startIndex; index <= endIndex; ++index) {
                existingInterval = this.intervals[index];
                if (carry_start < existingInterval.start) {
                    if (carry_end < existingInterval.end) {
                        if (carry_end < existingInterval.start) {
                            insertion = new Interval(carry_start, carry_end, v);
                            if (this.intervalCount > this.intervals.length - 2) {
                                newIntervals = new Interval[this.intervals.length * 2];
                                System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                                this.intervals = newIntervals;
                            }
                            System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                            this.intervals[index] = insertion;
                            if (v.firstIntervalPage == null) {
                                v.firstIntervalPage = insertion;
                            }
                            ++this.intervalCount;
                            ++endIndex;
                            ++index;
                            carry = false;
                            continue;
                        }
                        insertion = new Interval(carry_start, existingInterval.start - 1, v);
                        insertion2 = new Interval(existingInterval, carry_end + 1, existingInterval.end);
                        existingInterval.appendNumeric(v);
                        if (this.intervalCount > this.intervals.length - 2) {
                            newIntervals = new Interval[this.intervals.length * 2];
                            System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                            this.intervals = newIntervals;
                        }
                        System.arraycopy(this.intervals, index, this.intervals, index + 2, this.intervalCount - index);
                        this.intervals[index] = insertion;
                        this.intervals[index + 1] = existingInterval;
                        this.intervals[index + 2] = insertion2;
                        if (v.firstIntervalPage == null) {
                            v.firstIntervalPage = insertion;
                        }
                        this.intervalCount += 2;
                        endIndex += 2;
                        index += 2;
                        carry = false;
                        continue;
                    }
                    if (carry_end == existingInterval.end) {
                        insertion = new Interval(carry_start, existingInterval.start - 1, v);
                        existingInterval.appendNumeric(v);
                        if (this.intervalCount > this.intervals.length - 2) {
                            newIntervals = new Interval[this.intervals.length * 2];
                            System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                            this.intervals = newIntervals;
                        }
                        System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                        this.intervals[index] = insertion;
                        if (v.firstIntervalPage == null) {
                            v.firstIntervalPage = insertion;
                        }
                        ++this.intervalCount;
                        ++endIndex;
                        ++index;
                        carry = false;
                        continue;
                    }
                    if (carry_end <= existingInterval.end) continue;
                    insertion = new Interval(carry_start, existingInterval.start - 1, v);
                    existingInterval.appendNumeric(v);
                    carry_start = this.intervals[index].end + 1;
                    if (this.intervalCount > this.intervals.length - 2) {
                        newIntervals = new Interval[this.intervals.length * 2];
                        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                        this.intervals = newIntervals;
                    }
                    System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                    this.intervals[index] = insertion;
                    if (v.firstIntervalPage == null) {
                        v.firstIntervalPage = insertion;
                    }
                    ++this.intervalCount;
                    ++endIndex;
                    ++index;
                    continue;
                }
                if (carry_start == existingInterval.start) {
                    if (carry_end < existingInterval.end) {
                        insertion = new Interval(existingInterval, carry_end + 1, existingInterval.end);
                        existingInterval.end = carry_end;
                        existingInterval.appendNumeric(v);
                        if (this.intervalCount > this.intervals.length - 2) {
                            newIntervals = new Interval[this.intervals.length * 2];
                            System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                            this.intervals = newIntervals;
                        }
                        System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                        this.intervals[index] = existingInterval;
                        this.intervals[index + 1] = insertion;
                        if (v.firstIntervalPage == null) {
                            v.firstIntervalPage = existingInterval;
                        }
                        ++this.intervalCount;
                        ++endIndex;
                        ++index;
                        carry = false;
                        continue;
                    }
                    if (carry_end == existingInterval.end) {
                        this.intervals[index].addElementIfNecessary(v);
                        carry = false;
                        if (v.firstIntervalPage != null) continue;
                        v.firstIntervalPage = existingInterval;
                        continue;
                    }
                    if (carry_end <= existingInterval.end) continue;
                    existingInterval.appendNumeric(v);
                    carry_start = existingInterval.end + 1;
                    if (v.firstIntervalPage != null) continue;
                    v.firstIntervalPage = existingInterval;
                    continue;
                }
                if (carry_start <= existingInterval.start) continue;
                if (carry_end < existingInterval.end) {
                    insertion = new Interval(existingInterval, carry_start, carry_end);
                    insertion.appendNumeric(v);
                    insertion2 = new Interval(existingInterval, carry_end + 1, existingInterval.end);
                    existingInterval.end = carry_start - 1;
                    if (this.intervalCount > this.intervals.length - 2) {
                        newIntervals = new Interval[this.intervals.length * 2];
                        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                        this.intervals = newIntervals;
                    }
                    System.arraycopy(this.intervals, index, this.intervals, index + 2, this.intervalCount - index);
                    this.intervals[index] = existingInterval;
                    this.intervals[index + 1] = insertion;
                    this.intervals[index + 2] = insertion2;
                    if (v.firstIntervalPage == null) {
                        v.firstIntervalPage = insertion;
                    }
                    startIndex = index + 1;
                    this.intervalCount += 2;
                    endIndex += 2;
                    index += 2;
                    carry = false;
                    continue;
                }
                if (carry_end == existingInterval.end) {
                    insertion = new Interval(existingInterval, carry_start, existingInterval.end);
                    insertion.appendNumeric(v);
                    existingInterval.end = carry_start - 1;
                    if (this.intervalCount > this.intervals.length - 2) {
                        newIntervals = new Interval[this.intervals.length * 2];
                        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                        this.intervals = newIntervals;
                    }
                    System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                    this.intervals[index] = existingInterval;
                    this.intervals[index + 1] = insertion;
                    if (v.firstIntervalPage == null) {
                        v.firstIntervalPage = insertion;
                    }
                    ++this.intervalCount;
                    ++endIndex;
                    ++index;
                    carry = false;
                    continue;
                }
                if (carry_end <= existingInterval.end || carry_start > existingInterval.end) continue;
                insertion = new Interval(existingInterval, carry_start, existingInterval.end);
                insertion.appendNumeric(v);
                existingInterval.end = carry_start - 1;
                carry_start = insertion.end + 1;
                if (this.intervalCount > this.intervals.length - 2) {
                    newIntervals = new Interval[this.intervals.length * 2];
                    System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                    this.intervals = newIntervals;
                }
                System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                this.intervals[index] = existingInterval;
                this.intervals[index + 1] = insertion;
                if (v.firstIntervalPage == null) {
                    v.firstIntervalPage = insertion;
                }
                ++this.intervalCount;
                ++endIndex;
                ++index;
            }
            if (carry) {
                if (this.intervalCount > this.intervals.length - 2) {
                    newIntervals = new Interval[this.intervals.length * 2];
                    System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                    this.intervals = newIntervals;
                }
                if (this.intervalCount - index > 0) {
                    System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                }
                this.intervals[index] = new Interval(carry_start, carry_end, v);
                if (v.firstIntervalPage == null) {
                    v.firstIntervalPage = this.intervals[index];
                }
                ++this.intervalCount;
            }
        } else {
            Interval[] newIntervals;
            int endIndex;
            Variable other;
            int i;
            Variable[] elementData;
            int pointers_size;
            QuickVector pointers;
            if (index < this.intervalCount && this.intervals[index].start <= end) {
                pointers = this.intervals[index].nums;
                if (pointers == null) {
                    this.intervals[index].nums = new QuickVector();
                } else {
                    pointers_size = pointers.size();
                    elementData = pointers.elementData;
                    for (i = 0; i < pointers_size; ++i) {
                        other = elementData[i];
                        int addr2 = other.pointerAddress;
                        int size2 = other.itemSize;
                        if (!(start <= addr2 ? end >= addr2 : size2 + addr2 - 1 >= start)) continue;
                        if (notify == null) {
                            notify = new QuickVector(other);
                        } else {
                            notify.addElement(other);
                        }
                        if (other.notify == null) {
                            other.notify = new QuickVector(v);
                            continue;
                        }
                        other.notify.addElement(v);
                    }
                }
                ++index;
            }
            while (index < this.intervalCount && this.intervals[index].start <= end) {
                pointers = this.intervals[index].nums;
                if (pointers == null) {
                    this.intervals[index].nums = new QuickVector();
                } else {
                    pointers_size = pointers.size();
                    elementData = pointers.elementData;
                    for (i = 0; i < pointers_size; ++i) {
                        other = elementData[i];
                        if (other.firstIntervalPage != this.intervals[index] || end < other.pointerAddress) continue;
                        if (notify == null) {
                            notify = new QuickVector(other);
                        } else {
                            notify.addElement(other);
                        }
                        if (other.notify == null) {
                            other.notify = new QuickVector(v);
                            continue;
                        }
                        other.notify.addElement(v);
                    }
                }
                ++index;
            }
            v.notify = notify;
            if ((endIndex = --index) < startIndex) {
                if (endIndex < 0) {
                    this.intervals[0] = new Interval(start, end, v);
                    this.intervalCount = 1;
                    return;
                }
                endIndex = startIndex;
            }
            if (index < 0) {
                index = 0;
            }
            int carry_start = start;
            int carry_end = end;
            boolean carry = true;
            Interval insertion = null;
            Interval insertion2 = null;
            Interval existingInterval = null;
            v.firstIntervalPage = null;
            for (index = startIndex; index <= endIndex; ++index) {
                existingInterval = this.intervals[index];
                if (carry_start < existingInterval.start) {
                    if (carry_end < existingInterval.end) {
                        if (carry_end < existingInterval.start) {
                            insertion = new Interval(carry_start, carry_end, v);
                            if (this.intervalCount > this.intervals.length - 2) {
                                newIntervals = new Interval[this.intervals.length * 2];
                                System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                                this.intervals = newIntervals;
                            }
                            System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                            this.intervals[index] = insertion;
                            if (v.firstIntervalPage == null) {
                                v.firstIntervalPage = insertion;
                            }
                            ++this.intervalCount;
                            ++endIndex;
                            ++index;
                            carry = false;
                            continue;
                        }
                        insertion = new Interval(carry_start, existingInterval.start - 1, v);
                        insertion2 = new Interval(existingInterval, carry_end + 1, existingInterval.end);
                        existingInterval.appendVariable(v);
                        if (this.intervalCount > this.intervals.length - 2) {
                            newIntervals = new Interval[this.intervals.length * 2];
                            System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                            this.intervals = newIntervals;
                        }
                        System.arraycopy(this.intervals, index, this.intervals, index + 2, this.intervalCount - index);
                        this.intervals[index] = insertion;
                        this.intervals[index + 1] = existingInterval;
                        this.intervals[index + 2] = insertion2;
                        if (v.firstIntervalPage == null) {
                            v.firstIntervalPage = insertion;
                        }
                        this.intervalCount += 2;
                        endIndex += 2;
                        index += 2;
                        carry = false;
                        continue;
                    }
                    if (carry_end == existingInterval.end) {
                        insertion = new Interval(carry_start, existingInterval.start - 1, v);
                        existingInterval.appendVariable(v);
                        if (this.intervalCount > this.intervals.length - 2) {
                            newIntervals = new Interval[this.intervals.length * 2];
                            System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                            this.intervals = newIntervals;
                        }
                        System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                        this.intervals[index] = insertion;
                        if (v.firstIntervalPage == null) {
                            v.firstIntervalPage = insertion;
                        }
                        ++this.intervalCount;
                        ++endIndex;
                        ++index;
                        carry = false;
                        continue;
                    }
                    if (carry_end <= existingInterval.end) continue;
                    insertion = new Interval(carry_start, existingInterval.start - 1, v);
                    existingInterval.appendVariable(v);
                    carry_start = this.intervals[index].end + 1;
                    if (this.intervalCount > this.intervals.length - 2) {
                        newIntervals = new Interval[this.intervals.length * 2];
                        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                        this.intervals = newIntervals;
                    }
                    System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                    this.intervals[index] = insertion;
                    if (v.firstIntervalPage == null) {
                        v.firstIntervalPage = insertion;
                    }
                    ++this.intervalCount;
                    ++endIndex;
                    ++index;
                    continue;
                }
                if (carry_start == existingInterval.start) {
                    if (carry_end < existingInterval.end) {
                        insertion = new Interval(existingInterval, carry_end + 1, existingInterval.end);
                        existingInterval.end = carry_end;
                        existingInterval.appendVariable(v);
                        if (this.intervalCount > this.intervals.length - 2) {
                            newIntervals = new Interval[this.intervals.length * 2];
                            System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                            this.intervals = newIntervals;
                        }
                        System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                        this.intervals[index] = existingInterval;
                        this.intervals[index + 1] = insertion;
                        if (v.firstIntervalPage == null) {
                            v.firstIntervalPage = existingInterval;
                        }
                        ++this.intervalCount;
                        ++endIndex;
                        ++index;
                        carry = false;
                        continue;
                    }
                    if (carry_end == existingInterval.end) {
                        this.intervals[index].addElementIfNecessary(v);
                        carry = false;
                        if (v.firstIntervalPage != null) continue;
                        v.firstIntervalPage = existingInterval;
                        continue;
                    }
                    if (carry_end <= existingInterval.end) continue;
                    existingInterval.appendVariable(v);
                    carry_start = existingInterval.end + 1;
                    if (v.firstIntervalPage != null) continue;
                    v.firstIntervalPage = existingInterval;
                    continue;
                }
                if (carry_start <= existingInterval.start) continue;
                if (carry_end < existingInterval.end) {
                    insertion = new Interval(existingInterval, carry_start, carry_end);
                    insertion.appendVariable(v);
                    insertion2 = new Interval(existingInterval, carry_end + 1, existingInterval.end);
                    existingInterval.end = carry_start - 1;
                    if (this.intervalCount > this.intervals.length - 2) {
                        newIntervals = new Interval[this.intervals.length * 2];
                        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                        this.intervals = newIntervals;
                    }
                    System.arraycopy(this.intervals, index, this.intervals, index + 2, this.intervalCount - index);
                    this.intervals[index] = existingInterval;
                    this.intervals[index + 1] = insertion;
                    this.intervals[index + 2] = insertion2;
                    if (v.firstIntervalPage == null) {
                        v.firstIntervalPage = insertion;
                    }
                    startIndex = index + 1;
                    this.intervalCount += 2;
                    endIndex += 2;
                    index += 2;
                    carry = false;
                    continue;
                }
                if (carry_end == existingInterval.end) {
                    insertion = new Interval(existingInterval, carry_start, existingInterval.end);
                    insertion.appendVariable(v);
                    existingInterval.end = carry_start - 1;
                    if (this.intervalCount > this.intervals.length - 2) {
                        newIntervals = new Interval[this.intervals.length * 2];
                        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                        this.intervals = newIntervals;
                    }
                    System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                    this.intervals[index] = existingInterval;
                    this.intervals[index + 1] = insertion;
                    if (v.firstIntervalPage == null) {
                        v.firstIntervalPage = insertion;
                    }
                    ++this.intervalCount;
                    ++endIndex;
                    ++index;
                    carry = false;
                    continue;
                }
                if (carry_end <= existingInterval.end || carry_start > existingInterval.end) continue;
                insertion = new Interval(existingInterval, carry_start, existingInterval.end);
                insertion.appendVariable(v);
                existingInterval.end = carry_start - 1;
                carry_start = insertion.end + 1;
                if (this.intervalCount > this.intervals.length - 2) {
                    newIntervals = new Interval[this.intervals.length * 2];
                    System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                    this.intervals = newIntervals;
                }
                System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                this.intervals[index] = existingInterval;
                this.intervals[index + 1] = insertion;
                if (v.firstIntervalPage == null) {
                    v.firstIntervalPage = insertion;
                }
                ++this.intervalCount;
                ++endIndex;
                ++index;
            }
            if (carry) {
                if (this.intervalCount > this.intervals.length - 2) {
                    newIntervals = new Interval[this.intervals.length * 2];
                    System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervalCount);
                    this.intervals = newIntervals;
                }
                if (this.intervalCount - index > 0) {
                    System.arraycopy(this.intervals, index, this.intervals, index + 1, this.intervalCount - index);
                }
                this.intervals[index] = new Interval(carry_start, carry_end, v);
                if (v.firstIntervalPage == null) {
                    v.firstIntervalPage = this.intervals[index];
                }
                ++this.intervalCount;
            }
        }
    }

    public void setDynamic() {
        this.dynamic = true;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setShared() {
        this.shared = true;
    }

    public boolean isShared() {
        return this.shared;
    }

    public Memory setODOSlideMode() {
        this.odoSlideMode = true;
        return this;
    }

    public boolean isODOSlideMode() {
        return this.odoSlideMode;
    }

    protected static Unsafe getUnsafe() {
        if (theUnsafe != null) {
            return theUnsafe;
        }
        try {
            is64bitJVM = "64".equals(System.getProperty("sun.arch.data.model"));
            byteArrOffset = is64bitJVM ? 16 : ("ppc".equals(System.getProperty("os.arch")) ? 8 : 12);
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            theUnsafe = (Unsafe)f.get(null);
            baseOffset = theUnsafe.arrayBaseOffset(Object[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theUnsafe;
    }

    public long getMemoryBasePointer() {
        Object[] memByteArrayObject = new Object[]{this.memory};
        if (is64bitJVM) {
            long value = Memory.getUnsafe().getLong(memByteArrayObject, baseOffset);
            if (value >= 0L) {
                return value + (long)byteArrOffset;
            }
            return (0xFFFFFFFFFFFFFFFFL & value) + (long)byteArrOffset;
        }
        int value = Memory.getUnsafe().getInt(memByteArrayObject, baseOffset);
        if (value >= 0) {
            return value + byteArrOffset;
        }
        return (0xFFFFFFFFL & (long)value) + (long)byteArrOffset;
    }

    public boolean isSetTo(byte[] param) {
        return param == this.memory;
    }
}

