/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class NIORandomAccessFile
extends RandomAccessFile {
    boolean reading;
    boolean dirty;
    boolean firstTime;
    private String bufferType = null;
    private ByteBuffer buf;
    private FileChannel fileChannel;
    String filename;
    private long filePos;
    private long fileLength;
    private long bufStartFilePos;
    private long bufEndFilePos;
    private int bufOps;
    private int notBufOps;
    private int writeLimit;
    private int bytesInBuf;
    private final int bufSize;
    private boolean bufferDisabled;
    private static final int DEFAULT_BUF_SIZE = 0x100000;

    public NIORandomAccessFile(String filename, String mode, int bufsize, String bufType) throws IOException {
        this(new File(filename), mode, bufsize);
        this.bufferType = bufType;
    }

    public NIORandomAccessFile(File filename, String mode, int bufsize, String bufType) throws IOException {
        this(filename, mode, bufsize);
        this.bufferType = bufType;
    }

    public NIORandomAccessFile(String filename, String mode, int bufsize) throws IOException {
        this(new File(filename), mode, bufsize);
    }

    public NIORandomAccessFile(File file2, String mode, int bufsize) throws IOException {
        super(file2, mode);
        this.filename = file2.getName();
        this.fileChannel = this.getChannel();
        this.bytesInBuf = 0;
        this.writeLimit = 0;
        this.bufEndFilePos = this.filePos = (long)0;
        this.bufStartFilePos = this.filePos;
        this.notBufOps = 0;
        this.bufOps = 0;
        this.fileLength = this.fileChannel.size();
        this.reading = true;
        this.firstTime = true;
        this.dirty = false;
        this.buf = bufsize > 8191 ? ByteBuffer.allocateDirect(bufsize) : ByteBuffer.allocate(bufsize);
        this.bufSize = bufsize;
        this.buf.position(this.buf.limit());
    }

    public NIORandomAccessFile(File file2, String mode) throws IOException {
        this(file2, mode, 0x100000);
        this.fileLength = file2.length();
    }

    public NIORandomAccessFile(String filename, String mode) throws IOException {
        this(new File(filename), mode, 0x100000);
    }

    @Override
    public final int read() throws IOException {
        if (this.isBufferDisabled()) {
            return super.read();
        }
        this.reading = true;
        switch (this.syncPositions()) {
            case -1: {
                return -1;
            }
            case 1: {
                return super.read();
            }
        }
        int bufRemaining = this.buf.remaining();
        if (bufRemaining == 0) {
            this.buf.clear();
            this.fileChannel.position(this.filePos);
            int bytesRead = this.fileChannel.read(this.buf);
            if (bytesRead == -1 || bufRemaining + bytesRead < 1) {
                return -1;
            }
            this.buf.flip();
        }
        ++this.filePos;
        return this.buf.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isBufferDisabled()) {
            return super.read(b, off, len);
        }
        this.reading = true;
        switch (this.syncPositions()) {
            case -1: {
                return -1;
            }
            case 1: {
                return super.read(b, off, len);
            }
        }
        int bufRemaining = this.buf.remaining();
        if (bufRemaining < len) {
            if (bufRemaining == 0) {
                this.buf.clear();
            } else {
                this.buf.compact();
            }
            this.bytesInBuf = this.buf.position();
            this.fileChannel.position(this.filePos + (long)this.bytesInBuf);
            int bytesRead = this.fileChannel.read(this.buf);
            if (bytesRead == -1 && this.bytesInBuf == 0) {
                return -1;
            }
            this.bytesInBuf += bytesRead;
            this.buf.flip();
            bufRemaining = this.buf.remaining();
        }
        if (bufRemaining >= len) {
            this.buf.get(b, off, len);
            this.filePos += (long)len;
            return len;
        }
        this.buf.get(b, off, bufRemaining);
        this.filePos += (long)bufRemaining;
        int bytesProcessed = bufRemaining;
        int offset = off + bufRemaining;
        int lenRemaining = len - bufRemaining;
        while (len > bytesProcessed) {
            this.buf.clear();
            this.fileChannel.position(this.filePos);
            this.bytesInBuf = this.fileChannel.read(this.buf);
            if (this.bytesInBuf == -1) {
                this.bytesInBuf = 0;
                this.buf.limit(this.buf.position());
                break;
            }
            this.bufStartFilePos = this.filePos;
            this.bufEndFilePos = this.bufStartFilePos + (long)this.bufSize - 1L;
            this.buf.flip();
            bufRemaining = this.buf.remaining();
            if (lenRemaining > bufRemaining) {
                this.buf.get(b, offset, bufRemaining);
                this.filePos += (long)bufRemaining;
                bytesProcessed += bufRemaining;
                offset += bufRemaining;
                lenRemaining -= bufRemaining;
                continue;
            }
            this.buf.get(b, offset, lenRemaining);
            this.filePos += (long)lenRemaining;
            bytesProcessed += lenRemaining;
            break;
        }
        return bytesProcessed;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.isBufferDisabled()) {
            return super.read(b);
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.isBufferDisabled()) {
            super.write(b);
            this.filePos += 32L;
            if (this.filePos > this.fileLength) {
                this.fileLength = this.filePos;
            }
            return;
        }
        this.reading = false;
        switch (this.syncPositions()) {
            case 1: {
                super.write(b);
                return;
            }
        }
        int bufRemaining = this.buf.remaining();
        if (bufRemaining == 0) {
            this.flush(false, false);
            this.buf.clear();
        }
        ++this.filePos;
        this.dirty = true;
        this.buf.putInt(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block15: {
            int bufRemaining;
            block14: {
                if (this.isBufferDisabled()) {
                    super.write(b, off, len);
                    this.filePos += (long)len;
                    if (this.filePos > this.fileLength) {
                        this.fileLength = this.filePos;
                    }
                    return;
                }
                this.reading = false;
                switch (this.syncPositions()) {
                    case 1: {
                        super.write(b, off, len);
                        return;
                    }
                }
                bufRemaining = this.buf.remaining();
                if (bufRemaining < len) break block14;
                this.dirty = true;
                this.buf.put(b, off, len);
                this.filePos += (long)len;
                if (this.buf.position() > this.writeLimit) {
                    this.writeLimit = this.buf.position();
                }
                if (this.writeLimit <= this.bytesInBuf) break block15;
                this.bytesInBuf = this.writeLimit;
                break block15;
            }
            this.dirty = true;
            this.buf.put(b, off, bufRemaining);
            this.filePos += (long)bufRemaining;
            if (this.buf.position() > this.writeLimit) {
                this.writeLimit = this.buf.position();
            }
            if (this.writeLimit > this.bytesInBuf) {
                this.bytesInBuf = this.writeLimit;
            }
            int bytesProcessed = bufRemaining;
            int offset = off + bufRemaining;
            int lenRemaining = len - bufRemaining;
            this.buf.flip();
            this.syncPositions();
            this.buf.limit(this.buf.capacity());
            while (len > bytesProcessed) {
                bufRemaining = this.buf.remaining();
                if (lenRemaining > bufRemaining) {
                    this.dirty = true;
                    this.buf.put(b, offset, bufRemaining);
                    if (this.buf.position() > this.writeLimit) {
                        this.writeLimit = this.buf.position();
                    }
                    if (this.writeLimit > this.bytesInBuf) {
                        this.bytesInBuf = this.writeLimit;
                    }
                    this.buf.flip();
                    this.filePos += (long)bufRemaining;
                    bytesProcessed += bufRemaining;
                    offset += bufRemaining;
                    lenRemaining -= bufRemaining;
                    this.syncPositions();
                    this.buf.limit(this.buf.capacity());
                    continue;
                }
                this.dirty = true;
                this.buf.put(b, offset, lenRemaining);
                if (this.buf.position() > this.writeLimit) {
                    this.writeLimit = this.buf.position();
                }
                if (this.writeLimit > this.bytesInBuf) {
                    this.bytesInBuf = this.writeLimit;
                }
                this.buf.flip();
                this.filePos += (long)lenRemaining;
                bytesProcessed += lenRemaining;
                break;
            }
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.isBufferDisabled()) {
            super.write(b);
            this.filePos += (long)b.length;
            if (this.filePos > this.fileLength) {
                this.fileLength = this.filePos;
            }
        } else {
            this.write(b, 0, b.length);
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePos;
    }

    @Override
    public long length() throws IOException {
        return this.fileLength;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.filePos = pos;
        this.fileChannel.position(this.filePos);
    }

    private void flush(boolean writeMetaData, boolean writeToDisk) throws IOException {
        if (this.writeLimit > 0 && this.dirty) {
            this.buf.position(this.bytesInBuf);
            this.fileChannel.position(this.bufStartFilePos);
            this.buf.flip();
            this.fileChannel.write(this.buf);
            this.fileLength = this.fileChannel.size();
            this.writeLimit = 0;
        }
        if (writeToDisk) {
            this.fileChannel.force(writeMetaData);
        }
        this.fileChannel.position(this.filePos);
        this.buf.flip();
        this.dirty = false;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.flush(false, true);
        this.fileChannel.truncate(newLength);
        this.fileLength = newLength;
        this.fileChannel.position(this.filePos);
    }

    @Override
    public void close() throws IOException {
        if (this.isBufferDisabled()) {
            super.close();
        } else if (this.fileChannel.isOpen()) {
            this.flush(true, true);
            this.fileChannel.close();
        }
    }

    private void initPos() {
        this.firstTime = false;
        this.bufStartFilePos = this.filePos;
        this.bufEndFilePos = this.bufStartFilePos + (long)this.bufSize - 1L;
    }

    private boolean isBufferedPos() {
        return this.filePos >= this.bufStartFilePos && this.filePos <= this.bufEndFilePos;
    }

    private int syncPositions() throws IOException {
        if (this.isBufferedPos()) {
            this.bufOps <<= 1;
            this.bufOps |= 1;
            this.notBufOps <<= 1;
            if (this.firstTime) {
                this.initPos();
                if (this.reading) {
                    this.buf.position(this.buf.limit());
                    return 0;
                }
            }
            if (this.reading) {
                if (this.dirty && this.bytesInBuf > 0) {
                    if (this.bytesInBuf > this.adjustedBufPos()) {
                        this.buf.limit(this.bytesInBuf);
                    } else {
                        this.flush(false, true);
                        this.buf.clear();
                        this.bytesInBuf = 0;
                        this.fileChannel.position(this.filePos);
                        int bytesRead = this.fileChannel.read(this.buf);
                        if (bytesRead == -1 && this.buf.position() == 0) {
                            bytesRead = 0;
                        }
                        this.bytesInBuf += bytesRead;
                        this.buf.flip();
                        this.bufStartFilePos = this.filePos;
                        this.bufEndFilePos = this.bufStartFilePos + (long)this.bufSize - 1L;
                    }
                }
            } else {
                this.buf.limit(this.buf.capacity());
            }
            this.buf.position(this.adjustedBufPos());
        } else {
            this.notBufOps <<= 1;
            this.notBufOps |= 1;
            this.bufOps <<= 1;
            int totBufOps = this.bitsOnTotal(this.bufOps);
            int totNotBufOps = this.bitsOnTotal(this.notBufOps);
            if (totNotBufOps > totBufOps && totBufOps + totNotBufOps > 9 && !"DDNAME".equals(this.bufferType)) {
                this.setBufferDisabled(true);
            }
            if (this.dirty) {
                if (this.reading) {
                    this.flush(false, true);
                } else {
                    this.flush(false, false);
                }
                if (this.isBufferDisabled()) {
                    return 1;
                }
            }
            if (this.reading && this.filePos >= this.fileLength) {
                return -1;
            }
            this.buf.clear();
            this.bytesInBuf = 0;
            this.bufStartFilePos = this.filePos;
            this.bufEndFilePos = this.bufStartFilePos + (long)this.bufSize - 1L;
            if (this.reading) {
                this.buf.position(this.buf.limit());
            } else if (this.bufStartFilePos < this.fileLength) {
                this.bytesInBuf = this.fileChannel.read(this.buf);
                if (this.bytesInBuf < 0) {
                    this.bytesInBuf = 0;
                }
                this.buf.flip();
            }
        }
        return 0;
    }

    private int adjustedBufPos() {
        if (this.filePos > this.bufStartFilePos) {
            return (int)(this.filePos - this.bufStartFilePos);
        }
        return 0;
    }

    private int bitsOnTotal(int a) {
        int totOn = 0;
        for (int i = 0; i < 32; ++i) {
            totOn += (a & 1 << i) != 0 ? 1 : 0;
        }
        return totOn;
    }

    private boolean isBufferDisabled() {
        return this.bufferDisabled;
    }

    private void setBufferDisabled(boolean bufferDisabled) {
        this.bufferDisabled = bufferDisabled;
    }

    public long getCurrentBufferPosition() {
        return this.buf.position();
    }
}

