/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.PackedDecimal;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;

public final class PackedDecimalI
extends PackedDecimal
implements Cloneable,
comparableByteArray {
    private static String DataType = null;

    @Override
    public final String getClassName() {
        return "com.heirloomcomputing.ecs.exec.PackedDecimalI";
    }

    @Override
    public final String getUsage() {
        return "PackedDecimalI";
    }

    @Override
    protected void calcPadding() {
        this.usePadding = (this.picLength & 1) == 0;
    }

    @Override
    public final void flushToMemoryNow() {
        try {
            byte temporaryPlace = this.place;
            Bignum storeValue = this.value;
            if (this.scale > 0) {
                if (temporaryPlace > 0) {
                    storeValue = this.value.movePointRight(this.scale);
                    temporaryPlace = (byte)(temporaryPlace - this.scale);
                } else {
                    storeValue = this.value.movePointLeft(this.scale);
                }
            }
            boolean negative = false;
            String absbuffer = storeValue.toString();
            int length = absbuffer.length();
            if (length > 2 && absbuffer.startsWith("0.")) {
                absbuffer = absbuffer.substring(1);
                --length;
            } else if (length > 1 && absbuffer.charAt(0) == '-') {
                negative = true;
                if (length > 3 && absbuffer.startsWith("-0.")) {
                    absbuffer = absbuffer.substring(2);
                    length -= 2;
                } else {
                    absbuffer = absbuffer.substring(1);
                    --length;
                }
            }
            int byteLow = 14;
            int byteHigh = 14;
            int decimal = absbuffer.indexOf(46);
            if (decimal < 0) {
                decimal = length;
            }
            int load = decimal - (this.picLength - temporaryPlace);
            int offset = this.pointerAddress;
            if (this.signPosition == 2 || this.signPosition == 4) {
                int signNibble;
                int n = signNibble = negative ? 13 : 12;
                if (this.usePadding) {
                    byteLow = signNibble;
                    byteHigh = 0;
                    this.pointerMemory.setByte(offset++, (byte)(byteLow << 4 | byteHigh));
                } else {
                    byteLow = signNibble;
                    if (load >= 0) {
                        if (load == decimal) {
                            ++load;
                        }
                        if (load >= length) {
                            byteHigh = 0;
                        } else {
                            switch (absbuffer.charAt(load)) {
                                case '0': {
                                    byteHigh = 0;
                                    break;
                                }
                                case '1': {
                                    byteHigh = 1;
                                    break;
                                }
                                case '2': {
                                    byteHigh = 2;
                                    break;
                                }
                                case '3': {
                                    byteHigh = 3;
                                    break;
                                }
                                case '4': {
                                    byteHigh = 4;
                                    break;
                                }
                                case '5': {
                                    byteHigh = 5;
                                    break;
                                }
                                case '6': {
                                    byteHigh = 6;
                                    break;
                                }
                                case '7': {
                                    byteHigh = 7;
                                    break;
                                }
                                case '8': {
                                    byteHigh = 8;
                                    break;
                                }
                                case '9': {
                                    byteHigh = 9;
                                    break;
                                }
                                case '+': {
                                    byteHigh = 12;
                                    break;
                                }
                                case '-': {
                                    byteHigh = 13;
                                    break;
                                }
                                default: {
                                    byteHigh = 14;
                                    break;
                                }
                            }
                        }
                    } else {
                        byteHigh = 0;
                    }
                    ++load;
                    this.pointerMemory.setByte(offset++, (byte)(byteLow << 4 | byteHigh));
                }
                for (int i = 1; i < this.itemSize; ++i) {
                    if (load >= 0) {
                        if (load == decimal) {
                            ++load;
                        }
                        if (load >= length) {
                            byteLow = 0;
                        } else {
                            switch (absbuffer.charAt(load)) {
                                case '0': {
                                    byteLow = 0;
                                    break;
                                }
                                case '1': {
                                    byteLow = 1;
                                    break;
                                }
                                case '2': {
                                    byteLow = 2;
                                    break;
                                }
                                case '3': {
                                    byteLow = 3;
                                    break;
                                }
                                case '4': {
                                    byteLow = 4;
                                    break;
                                }
                                case '5': {
                                    byteLow = 5;
                                    break;
                                }
                                case '6': {
                                    byteLow = 6;
                                    break;
                                }
                                case '7': {
                                    byteLow = 7;
                                    break;
                                }
                                case '8': {
                                    byteLow = 8;
                                    break;
                                }
                                case '9': {
                                    byteLow = 9;
                                    break;
                                }
                                case '+': {
                                    byteLow = 12;
                                    break;
                                }
                                case '-': {
                                    byteLow = 13;
                                    break;
                                }
                                default: {
                                    byteLow = 14;
                                    break;
                                }
                            }
                        }
                    } else {
                        byteLow = 0;
                    }
                    if (++load >= 0) {
                        if (load == decimal) {
                            ++load;
                        }
                        if (load >= length) {
                            byteHigh = 0;
                        } else {
                            switch (absbuffer.charAt(load)) {
                                case '0': {
                                    byteHigh = 0;
                                    break;
                                }
                                case '1': {
                                    byteHigh = 1;
                                    break;
                                }
                                case '2': {
                                    byteHigh = 2;
                                    break;
                                }
                                case '3': {
                                    byteHigh = 3;
                                    break;
                                }
                                case '4': {
                                    byteHigh = 4;
                                    break;
                                }
                                case '5': {
                                    byteHigh = 5;
                                    break;
                                }
                                case '6': {
                                    byteHigh = 6;
                                    break;
                                }
                                case '7': {
                                    byteHigh = 7;
                                    break;
                                }
                                case '8': {
                                    byteHigh = 8;
                                    break;
                                }
                                case '9': {
                                    byteHigh = 9;
                                    break;
                                }
                                case '+': {
                                    byteHigh = 12;
                                    break;
                                }
                                case '-': {
                                    byteHigh = 13;
                                    break;
                                }
                                default: {
                                    byteHigh = 14;
                                    break;
                                }
                            }
                        }
                    } else {
                        byteHigh = 0;
                    }
                    ++load;
                    this.pointerMemory.setByte(offset++, (byte)(byteLow << 4 | byteHigh));
                }
            } else {
                int signNibble = this.signPosition == 0 ? 15 : (negative ? 13 : 12);
                int i = 0;
                if (this.usePadding) {
                    byteLow = 0;
                    if (load >= 0) {
                        if (load == decimal) {
                            ++load;
                        }
                        if (load >= length) {
                            byteHigh = 0;
                        } else {
                            switch (absbuffer.charAt(load)) {
                                case '0': {
                                    byteHigh = 0;
                                    break;
                                }
                                case '1': {
                                    byteHigh = 1;
                                    break;
                                }
                                case '2': {
                                    byteHigh = 2;
                                    break;
                                }
                                case '3': {
                                    byteHigh = 3;
                                    break;
                                }
                                case '4': {
                                    byteHigh = 4;
                                    break;
                                }
                                case '5': {
                                    byteHigh = 5;
                                    break;
                                }
                                case '6': {
                                    byteHigh = 6;
                                    break;
                                }
                                case '7': {
                                    byteHigh = 7;
                                    break;
                                }
                                case '8': {
                                    byteHigh = 8;
                                    break;
                                }
                                case '9': {
                                    byteHigh = 9;
                                    break;
                                }
                                case '+': {
                                    byteHigh = 12;
                                    break;
                                }
                                case '-': {
                                    byteHigh = 13;
                                    break;
                                }
                                default: {
                                    byteHigh = 14;
                                    break;
                                }
                            }
                        }
                    } else {
                        byteHigh = 0;
                    }
                    ++load;
                    this.pointerMemory.setByte(offset++, (byte)(byteLow << 4 | byteHigh));
                    i = 1;
                }
                int itemSizeMinus1 = this.itemSize - 1;
                while (i < itemSizeMinus1) {
                    if (load >= 0) {
                        if (load == decimal) {
                            ++load;
                        }
                        if (load >= length) {
                            byteLow = 0;
                        } else {
                            switch (absbuffer.charAt(load)) {
                                case '0': {
                                    byteLow = 0;
                                    break;
                                }
                                case '1': {
                                    byteLow = 1;
                                    break;
                                }
                                case '2': {
                                    byteLow = 2;
                                    break;
                                }
                                case '3': {
                                    byteLow = 3;
                                    break;
                                }
                                case '4': {
                                    byteLow = 4;
                                    break;
                                }
                                case '5': {
                                    byteLow = 5;
                                    break;
                                }
                                case '6': {
                                    byteLow = 6;
                                    break;
                                }
                                case '7': {
                                    byteLow = 7;
                                    break;
                                }
                                case '8': {
                                    byteLow = 8;
                                    break;
                                }
                                case '9': {
                                    byteLow = 9;
                                    break;
                                }
                                case '+': {
                                    byteLow = 12;
                                    break;
                                }
                                case '-': {
                                    byteLow = 13;
                                    break;
                                }
                                default: {
                                    byteLow = 14;
                                    break;
                                }
                            }
                        }
                    } else {
                        byteLow = 0;
                    }
                    if (++load >= 0) {
                        if (load == decimal) {
                            ++load;
                        }
                        if (load >= length) {
                            byteHigh = 0;
                        } else {
                            switch (absbuffer.charAt(load)) {
                                case '0': {
                                    byteHigh = 0;
                                    break;
                                }
                                case '1': {
                                    byteHigh = 1;
                                    break;
                                }
                                case '2': {
                                    byteHigh = 2;
                                    break;
                                }
                                case '3': {
                                    byteHigh = 3;
                                    break;
                                }
                                case '4': {
                                    byteHigh = 4;
                                    break;
                                }
                                case '5': {
                                    byteHigh = 5;
                                    break;
                                }
                                case '6': {
                                    byteHigh = 6;
                                    break;
                                }
                                case '7': {
                                    byteHigh = 7;
                                    break;
                                }
                                case '8': {
                                    byteHigh = 8;
                                    break;
                                }
                                case '9': {
                                    byteHigh = 9;
                                    break;
                                }
                                case '+': {
                                    byteHigh = 12;
                                    break;
                                }
                                case '-': {
                                    byteHigh = 13;
                                    break;
                                }
                                default: {
                                    byteHigh = 14;
                                    break;
                                }
                            }
                        }
                    } else {
                        byteHigh = 0;
                    }
                    ++load;
                    this.pointerMemory.setByte(offset++, (byte)(byteLow << 4 | byteHigh));
                    ++i;
                }
                if (load >= 0) {
                    if (load == decimal) {
                        ++load;
                    }
                    if (load >= length) {
                        byteLow = 0;
                    } else {
                        switch (absbuffer.charAt(load)) {
                            case '0': {
                                byteLow = 0;
                                break;
                            }
                            case '1': {
                                byteLow = 1;
                                break;
                            }
                            case '2': {
                                byteLow = 2;
                                break;
                            }
                            case '3': {
                                byteLow = 3;
                                break;
                            }
                            case '4': {
                                byteLow = 4;
                                break;
                            }
                            case '5': {
                                byteLow = 5;
                                break;
                            }
                            case '6': {
                                byteLow = 6;
                                break;
                            }
                            case '7': {
                                byteLow = 7;
                                break;
                            }
                            case '8': {
                                byteLow = 8;
                                break;
                            }
                            case '9': {
                                byteLow = 9;
                                break;
                            }
                            case '+': {
                                byteLow = 12;
                                break;
                            }
                            case '-': {
                                byteLow = 13;
                                break;
                            }
                            default: {
                                byteLow = 14;
                                break;
                            }
                        }
                    }
                } else {
                    byteLow = 0;
                }
                ++load;
                byteHigh = signNibble;
                this.pointerMemory.setByte(offset++, (byte)(byteLow << 4 | byteHigh));
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL-I storage of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    @Override
    public final void fillFromMemoryNow() {
        try {
            int offset = this.pointerAddress;
            this.numericString = null;
            boolean digitFound = false;
            if (this.scale <= 0) {
                int decimal = this.picLength - this.place;
                if (this.usePadding) {
                    ++decimal;
                }
                if (this.fillArray == null) {
                    this.fillArray = new char[this.itemSize * 2 + 4];
                }
                int resultCounter = 1;
                this.fillArray[0] = 48;
                block58: for (int i = 0; i < this.itemSize; ++i) {
                    int b = this.pointerMemory.getByte(offset++) & 0xFF;
                    if (numericValdityChecking) {
                        if (i == 0 && (this.signPosition == 2 || this.signPosition == 4)) {
                            if (DisplayP.getZonedDescription().getPackedSigns().indexOf(b) < 0) {
                                if (RuntimeEnvironment.isEBPEnv()) {
                                    Context.exitAbendActiveContext(199);
                                }
                                CobolException.runtimeError("Data Exception: COMP-3 element '" + this.getQualifiedCobolName().toUpperCase() + "' does not have a valid leading sign: " + this.toHexString());
                            }
                        } else if (i == this.itemSize - 1 && (this.signPosition == 3 || this.signPosition == 5) && DisplayP.getZonedDescription().getPackedSigns().indexOf(b) < 0) {
                            if (RuntimeEnvironment.isEBPEnv()) {
                                Context.exitAbendActiveContext(199);
                            }
                            CobolException.runtimeError("Data Exception: COMP-3 element '" + this.getQualifiedCobolName().toUpperCase() + "' does not have a valid trailing sign: " + this.toHexString());
                        }
                    }
                    if (resultCounter - 1 == decimal) {
                        this.fillArray[resultCounter++] = 46;
                    }
                    switch (b >> 4 & 0xF) {
                        case 0: {
                            this.fillArray[resultCounter++] = 48;
                            digitFound = true;
                            break;
                        }
                        case 1: {
                            this.fillArray[resultCounter++] = 49;
                            digitFound = true;
                            break;
                        }
                        case 2: {
                            this.fillArray[resultCounter++] = 50;
                            digitFound = true;
                            break;
                        }
                        case 3: {
                            this.fillArray[resultCounter++] = 51;
                            digitFound = true;
                            break;
                        }
                        case 4: {
                            this.fillArray[resultCounter++] = 52;
                            digitFound = true;
                            break;
                        }
                        case 5: {
                            this.fillArray[resultCounter++] = 53;
                            digitFound = true;
                            break;
                        }
                        case 6: {
                            this.fillArray[resultCounter++] = 54;
                            digitFound = true;
                            break;
                        }
                        case 7: {
                            this.fillArray[resultCounter++] = 55;
                            digitFound = true;
                            break;
                        }
                        case 8: {
                            this.fillArray[resultCounter++] = 56;
                            digitFound = true;
                            break;
                        }
                        case 9: {
                            this.fillArray[resultCounter++] = 57;
                            digitFound = true;
                            break;
                        }
                        case 13: {
                            this.fillArray[0] = 45;
                            break;
                        }
                        case 11: {
                            this.fillArray[0] = PD_NUMPROCB2;
                        }
                    }
                    if (resultCounter - 1 == decimal) {
                        this.fillArray[resultCounter++] = 46;
                    }
                    switch (b & 0xF) {
                        case 0: {
                            this.fillArray[resultCounter++] = 48;
                            digitFound = true;
                            continue block58;
                        }
                        case 1: {
                            this.fillArray[resultCounter++] = 49;
                            digitFound = true;
                            continue block58;
                        }
                        case 2: {
                            this.fillArray[resultCounter++] = 50;
                            digitFound = true;
                            continue block58;
                        }
                        case 3: {
                            this.fillArray[resultCounter++] = 51;
                            digitFound = true;
                            continue block58;
                        }
                        case 4: {
                            this.fillArray[resultCounter++] = 52;
                            digitFound = true;
                            continue block58;
                        }
                        case 5: {
                            this.fillArray[resultCounter++] = 53;
                            digitFound = true;
                            continue block58;
                        }
                        case 6: {
                            this.fillArray[resultCounter++] = 54;
                            digitFound = true;
                            continue block58;
                        }
                        case 7: {
                            this.fillArray[resultCounter++] = 55;
                            digitFound = true;
                            continue block58;
                        }
                        case 8: {
                            this.fillArray[resultCounter++] = 56;
                            digitFound = true;
                            continue block58;
                        }
                        case 9: {
                            this.fillArray[resultCounter++] = 57;
                            digitFound = true;
                            continue block58;
                        }
                        case 13: {
                            this.fillArray[0] = 45;
                            continue block58;
                        }
                        case 11: {
                            this.fillArray[0] = PD_NUMPROCB2;
                        }
                    }
                }
                if (!digitFound) {
                    this.value = new Bignum();
                    this.value.setiAmNotNumeric(true);
                    this.dirty = false;
                } else {
                    this.value = new Bignum(this.fillArray, resultCounter);
                }
            } else {
                byte temporaryPlace = this.place;
                if (this.place > 0) {
                    temporaryPlace = (byte)(temporaryPlace - this.scale);
                }
                int decimal = this.picLength - temporaryPlace;
                if (this.usePadding) {
                    ++decimal;
                }
                if (this.fillArray == null) {
                    this.fillArray = new char[this.itemSize * 2 + 4];
                }
                int resultCounter = 1;
                this.fillArray[0] = 48;
                block59: for (int i = 0; i < this.itemSize; ++i) {
                    int b = this.pointerMemory.getByte(offset++) & 0xFF;
                    if (numericValdityChecking) {
                        if (i == 0 && (this.signPosition == 2 || this.signPosition == 4)) {
                            if (DisplayP.getZonedDescription().getPackedSigns().indexOf(b) < 0) {
                                if (RuntimeEnvironment.isEBPEnv()) {
                                    Context.exitAbendActiveContext(199);
                                }
                                CobolException.runtimeError("Data Exception: COMP-3 element '" + this.getQualifiedCobolName().toUpperCase() + "' does not have a valid leading sign: " + this.toHexString());
                            }
                        } else if (i == this.itemSize - 1 && (this.signPosition == 3 || this.signPosition == 5) && DisplayP.getZonedDescription().getPackedSigns().indexOf(b) < 0) {
                            if (RuntimeEnvironment.isEBPEnv()) {
                                Context.exitAbendActiveContext(199);
                            }
                            CobolException.runtimeError("Data Exception: COMP-3 element '" + this.getQualifiedCobolName().toUpperCase() + "' does not have a valid trailing sign: " + this.toHexString());
                        }
                    }
                    if (resultCounter - 1 == decimal) {
                        this.fillArray[resultCounter++] = 46;
                    }
                    switch (b >> 4 & 0xF) {
                        case 0: {
                            this.fillArray[resultCounter++] = 48;
                            digitFound = true;
                            break;
                        }
                        case 1: {
                            this.fillArray[resultCounter++] = 49;
                            digitFound = true;
                            break;
                        }
                        case 2: {
                            this.fillArray[resultCounter++] = 50;
                            digitFound = true;
                            break;
                        }
                        case 3: {
                            this.fillArray[resultCounter++] = 51;
                            digitFound = true;
                            break;
                        }
                        case 4: {
                            this.fillArray[resultCounter++] = 52;
                            digitFound = true;
                            break;
                        }
                        case 5: {
                            this.fillArray[resultCounter++] = 53;
                            digitFound = true;
                            break;
                        }
                        case 6: {
                            this.fillArray[resultCounter++] = 54;
                            digitFound = true;
                            break;
                        }
                        case 7: {
                            this.fillArray[resultCounter++] = 55;
                            digitFound = true;
                            break;
                        }
                        case 8: {
                            this.fillArray[resultCounter++] = 56;
                            digitFound = true;
                            break;
                        }
                        case 9: {
                            this.fillArray[resultCounter++] = 57;
                            digitFound = true;
                            break;
                        }
                        case 13: {
                            this.fillArray[0] = 45;
                            break;
                        }
                        case 11: {
                            this.fillArray[0] = PD_NUMPROCB2;
                        }
                    }
                    if (resultCounter - 1 == decimal) {
                        this.fillArray[resultCounter++] = 46;
                    }
                    switch (b & 0xF) {
                        case 0: {
                            this.fillArray[resultCounter++] = 48;
                            digitFound = true;
                            continue block59;
                        }
                        case 1: {
                            this.fillArray[resultCounter++] = 49;
                            digitFound = true;
                            continue block59;
                        }
                        case 2: {
                            this.fillArray[resultCounter++] = 50;
                            digitFound = true;
                            continue block59;
                        }
                        case 3: {
                            this.fillArray[resultCounter++] = 51;
                            digitFound = true;
                            continue block59;
                        }
                        case 4: {
                            this.fillArray[resultCounter++] = 52;
                            digitFound = true;
                            continue block59;
                        }
                        case 5: {
                            this.fillArray[resultCounter++] = 53;
                            digitFound = true;
                            continue block59;
                        }
                        case 6: {
                            this.fillArray[resultCounter++] = 54;
                            digitFound = true;
                            continue block59;
                        }
                        case 7: {
                            this.fillArray[resultCounter++] = 55;
                            digitFound = true;
                            continue block59;
                        }
                        case 8: {
                            this.fillArray[resultCounter++] = 56;
                            digitFound = true;
                            continue block59;
                        }
                        case 9: {
                            this.fillArray[resultCounter++] = 57;
                            digitFound = true;
                            continue block59;
                        }
                        case 13: {
                            this.fillArray[0] = 45;
                            continue block59;
                        }
                        case 11: {
                            this.fillArray[0] = PD_NUMPROCB2;
                        }
                    }
                }
                if (!digitFound) {
                    this.value = new Bignum();
                    this.value.setiAmNotNumeric(true);
                    this.dirty = false;
                } else {
                    this.value = new Bignum(this.fillArray, resultCounter);
                }
                this.value.movingPoint(this.scale, temporaryPlace);
            }
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL-I retrieval of " + this.getQualifiedCobolName(), (Throwable)e);
        }
    }

    public final boolean checkNumericContent() {
        this.value.setNumericValidate(false);
        try {
            int offset = this.pointerAddress;
            this.numericString = null;
            boolean lowNibbleSign = false;
            boolean highNibbleSign = false;
            block8: for (int i = 0; i < this.itemSize; ++i) {
                highNibbleSign = false;
                lowNibbleSign = false;
                int b = this.pointerMemory.getByte(offset++) & 0xFF;
                if (i == 0 && (this.signPosition == 2 || this.signPosition == 4)) {
                    highNibbleSign = true;
                    if (!PackedDecimalI.isSignedValid(b >> 4 & 0xF)) {
                        this.value.setiAmNotNumeric(true);
                        return false;
                    }
                } else if (i == this.itemSize - 1) {
                    if (this.signPosition == 0) {
                        lowNibbleSign = true;
                        if (!this.isSignUnsigned(b & 0xF)) {
                            this.value.setiAmNotNumeric(true);
                            return false;
                        }
                    } else if (this.signPosition == 3 || this.signPosition == 5) {
                        lowNibbleSign = true;
                        if (!PackedDecimalI.isSignedValid(b & 0xF)) {
                            this.value.setiAmNotNumeric(true);
                            return false;
                        }
                    }
                }
                if (!highNibbleSign) {
                    switch (b >> 4 & 0xF) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            break;
                        }
                        default: {
                            this.value.setiAmNotNumeric(true);
                            return false;
                        }
                    }
                }
                if (lowNibbleSign) continue;
                switch (b & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        continue block8;
                    }
                    default: {
                        this.value.setiAmNotNumeric(true);
                        return false;
                    }
                }
            }
            this.value.setiAmNotNumeric(false);
        }
        catch (Exception e) {
            CobolException.runtimeError("Error in PACKED-DECIMAL-I CheckNumericContent " + this.getQualifiedCobolName(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public int getType() {
        return this.getBasicType(464);
    }

    @Override
    public boolean isNumeric(ZonedDescription zonedDescription) {
        int l = this.length();
        boolean signLeading = false;
        boolean signTrailing = false;
        this.flushToMemory();
        switch (this.signPosition) {
            case 2: 
            case 4: {
                signLeading = true;
                break;
            }
            case 3: 
            case 5: {
                signTrailing = true;
                break;
            }
        }
        for (int i = 0; i < l; ++i) {
            char c = this.pointerMemory.getChar(this.pointerAddress + i);
            if (signLeading && i == 0) {
                if (!PackedDecimalI.isSignedValid(c >> 4)) {
                    return false;
                }
                c = (char)(c & 0xF);
            } else if (i == l - 1) {
                if (signTrailing) {
                    if (!PackedDecimalI.isSignedValid(c)) {
                        return false;
                    }
                    if (this.value.requiresNumericValidate()) {
                        this.checkNumericContent();
                    }
                    return !this.value.isiAmNotNumeric();
                }
                if (!signLeading) {
                    if (RuntimeEnvironment.isIBM ? !this.isSignUnsigned(c) : (c & 0xF) >= 10 && !this.isSignUnsigned(c)) {
                        return false;
                    }
                    if (i != 0) {
                        return true;
                    }
                }
            }
            if ((c & 0xF0) <= 144 && (c & 0xF) <= 9) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initData() {
        int e = this.pointerAddress + this.length();
        super.initData();
        if (this.signPosition == 3 || this.signPosition == 5) {
            this.pointerMemory.setByte(e - 1, (byte)12);
        } else if (this.signPosition == 2 || this.signPosition == 4) {
            this.pointerMemory.setByte(0, (byte)12);
        } else if (this.signPosition == 0) {
            this.pointerMemory.setByte(e - 1, (byte)15);
        }
    }

    @Override
    public Variable moveSE(Bignum param) {
        return super.moveSE(param);
    }

    static {
        DataType = RuntimeEnvironment.getGlobalParameter("DT");
    }
}

