/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.TransactionFile;
import com.heirloomcomputing.ecs.exec.XmlFile;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.exec.intrdrFile;
import com.heirloomcomputing.ecs.exec.relFile;
import com.heirloomcomputing.ecs.exec.seqFile;
import java.util.Hashtable;
import java.util.Vector;

public class RecordFile {
    private static final Hashtable<String, Class<?>> forNameTable = new Hashtable();
    public static Vector<String> additionalProtocols = null;
    private static final String[][] highlevelProtocols = new String[][]{{"VSQL:", "com.heirloomcomputing.ecs.isamsql.VSQL"}, {"VDB:", "com.heirloomcomputing.ecs.isamsql.VDB"}, {"CB:", "com.heirloomcomputing.ecs.mfc.CB"}, {"ROX:", "com.heirloomcomputing.ecs.xio.ROX"}, {"ZOS:", "com.heirloomcomputing.ecs.zos.zOS"}, {"VSAM:", "com.heirloomcomputing.ecs.zos.zOS"}, {"ZFILE:", "com.heirloomcomputing.ecs.zos.zOS"}, {"VSESYSIN:", "com.heirloomcomputing.ecs.vse.VSEAssign"}, {"VSEPRINTER:", "com.heirloomcomputing.ecs.vse.VSEAssign"}, {"VSEGDG:", "com.heirloomcomputing.ecs.vse.VSEGDG"}};

    private static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> c = null;
        c = forNameTable.get(name);
        if (c == null) {
            c = Class.forName(name);
            forNameTable.put(name, c);
        }
        return c;
    }

    public static void init(Context context) {
        RecordFile.init(context.getFilesReadOnly());
    }

    public static void init(Vector<basicFile> files) {
        if (files == null) {
            return;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            try {
                basicFile file2 = files.elementAt(i);
                file2.init();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void startTransaction(Context context) {
        RecordFile.startTransaction(context.getFilesReadOnly());
    }

    private static void startTransaction(Vector<basicFile> files) {
        if (files == null) {
            return;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            basicFile f = files.elementAt(i);
            f.begin();
        }
    }

    public static void commitTransaction(Context context) {
        RecordFile.commitTransaction(context.getFilesReadOnly());
    }

    private static void commitTransaction(Vector<basicFile> files) {
        if (files == null) {
            return;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            basicFile f = files.elementAt(i);
            f.commit();
        }
    }

    public static void rollbackTransaction(Context context) {
        RecordFile.rollbackTransaction(context.getFilesReadOnly());
    }

    private static void rollbackTransaction(Vector<basicFile> files) {
        if (files == null) {
            return;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            basicFile f = files.elementAt(i);
            f.rollback();
        }
    }

    public static void recoverTransaction(Context context) {
        RecordFile.recoverTransaction(context.getFilesReadOnly());
    }

    private static void recoverTransaction(Vector<basicFile> files) {
        if (files == null) {
            return;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            basicFile f = files.elementAt(i);
            f.recover();
        }
    }

    public static seqFile getSeqFile(Context context) {
        if (context != null) {
            return RecordFile.getSeqFile(context.getFiles());
        }
        return RecordFile.getSeqFile((Vector<basicFile>)null);
    }

    public static seqFile getSeqFile(Context context, String unused, String ddName) {
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if (dsName == null && ddName != null) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("No DSN associated with DD name '" + ddName + "'. Use property \"-D" + ddName + "=protocol:datasetname\" or environment variable \"" + ddName + "=protocol:datasetname\" or EBP \"//" + ddName.toUpperCase() + " DD DSN=datasetname,DCB=PROTOCOL=protocol,DISP=SHR\". Using default file handler and potentially opening '" + ddName + "' as file name.");
            }
            return new seqFile();
        }
        seqFile seq = RecordFile.getSeqFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName);
        if (seq != null) {
            if (ddName != null) {
                seq.ddName = ddName;
            }
            if (dsName != null) {
                seq.setFilename(dsName);
            }
        }
        return seq;
    }

    private static seqFile getSeqFile(Vector<basicFile> files) {
        seqFile file2 = new seqFile();
        if (files != null) {
            files.addElement(file2);
        }
        return file2;
    }

    public static seqFile getSeqFile(Context context, String ddName) {
        seqFile seq;
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if ((seq = RecordFile.getSeqFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName)) != null) {
            if (ddName != null) {
                seq.ddName = ddName;
            }
            if (dsName != null) {
                seq.setFilename(dsName);
            }
        }
        return seq;
    }

    private static seqFile getSeqFile(Vector<basicFile> files, String protocol) {
        block7: {
            String highProtocol = "unknown";
            try {
                highProtocol = RecordFile.getHighlevelProtocolMap(protocol);
                if (highProtocol != null) {
                    String classname = highProtocol + "SequentialFile";
                    Class<?> c = RecordFile.forName(classname);
                    seqFile file2 = (seqFile)c.newInstance();
                    if (files != null) {
                        files.addElement(file2);
                    }
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer("Sequential file '" + protocol + "' being handled by '" + classname + "'");
                    }
                    return file2;
                }
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("Sequential file '" + protocol + "' being handled by default handler");
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING) break block7;
                LogSetup.LOGGER.severe("Sequential file handler not found for protocol '" + protocol + "' " + e.getMessage());
            }
        }
        seqFile file3 = new seqFile();
        if (files != null) {
            files.addElement(file3);
        }
        return file3;
    }

    public static intrdrFile getIntrdrFile(Context context) {
        if (context != null) {
            return RecordFile.getIntrdrFile(context.getFiles());
        }
        return RecordFile.getIntrdrFile((Vector<basicFile>)null);
    }

    public static intrdrFile getIntrdrFile(Context context, String unused, String ddName) {
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if (dsName == null && ddName != null) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("No DSN associated with DD name '" + ddName + "'. Use property \"-D" + ddName + "=protocol:datasetname\" or environment variable \"" + ddName + "=protocol:datasetname\" or EBP \"//" + ddName.toUpperCase() + " DD DSN=datasetname,DCB=PROTOCOL=protocol,DISP=SHR\". Using default file handler and potentially opening '" + ddName + "' as file name.");
            }
            return new intrdrFile();
        }
        intrdrFile intrdr = RecordFile.getIntrdrFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName);
        if (intrdr != null) {
            if (ddName != null) {
                intrdr.ddName = ddName;
            }
            if (dsName != null) {
                intrdr.setFilename(dsName);
            }
        }
        return intrdr;
    }

    private static intrdrFile getIntrdrFile(Vector<basicFile> files) {
        intrdrFile file2 = new intrdrFile();
        if (files != null) {
            files.addElement(file2);
        }
        return file2;
    }

    public static intrdrFile getIntrdrFile(Context context, String ddName) {
        intrdrFile intrdr;
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if ((intrdr = RecordFile.getIntrdrFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName)) != null) {
            if (ddName != null) {
                intrdr.ddName = ddName;
            }
            if (dsName != null) {
                intrdr.setFilename(dsName);
            }
        }
        return intrdr;
    }

    private static intrdrFile getIntrdrFile(Vector<basicFile> files, String protocol) {
        block7: {
            String highProtocol = "unknown";
            try {
                highProtocol = RecordFile.getHighlevelProtocolMap(protocol);
                if (highProtocol != null) {
                    String classname = highProtocol + "SequentialFile";
                    Class<?> c = RecordFile.forName(classname);
                    intrdrFile file2 = (intrdrFile)c.newInstance();
                    if (files != null) {
                        files.addElement(file2);
                    }
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer("Sequential file '" + protocol + "' being handled by '" + classname + "'");
                    }
                    return file2;
                }
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("Sequential file '" + protocol + "' being handled by default handler");
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING) break block7;
                LogSetup.LOGGER.severe("Sequential file handler not found for protocol '" + protocol + "' " + e.getMessage());
            }
        }
        intrdrFile file3 = new intrdrFile();
        if (files != null) {
            files.addElement(file3);
        }
        return file3;
    }

    public static relFile getRelFile(Context context) {
        return RecordFile.getRelFile(context == null ? (Vector<basicFile>)null : context.getFiles());
    }

    public static relFile getRelFile(Context context, String unused, String ddName) {
        relFile rel;
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if ((rel = RecordFile.getRelFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName)) != null) {
            if (ddName != null) {
                rel.ddName = ddName;
            }
            if (dsName != null) {
                rel.setFilename(dsName);
            }
        }
        return rel;
    }

    private static relFile getRelFile(Vector<basicFile> files) {
        relFile file2 = new relFile();
        if (files != null) {
            files.addElement(file2);
        }
        return file2;
    }

    public static relFile getRelFile(Context context, String ddName) {
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if (dsName == null && ddName != null) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("No DSN associated with DD name '" + ddName + "'. Use property \"-D" + ddName + "=protocol:datasetname\" or environment variable \"" + ddName + "=protocol:datasetname\" or EBP \"//" + ddName.toUpperCase() + " DD DSN=datasetname,DCB=PROTOCOL=protocol,DISP=SHR\". Using default file handler and potentially opening '" + ddName + "' as file name.");
            }
            return new relFile();
        }
        relFile rel = RecordFile.getRelFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName);
        if (rel != null) {
            if (ddName != null) {
                rel.ddName = ddName;
            }
            if (dsName != null) {
                rel.setFilename(dsName);
            }
        }
        return rel;
    }

    public static relFile getRelFile(Vector<basicFile> files, String protocol) {
        block7: {
            String highProtocol = "unknown";
            try {
                highProtocol = RecordFile.getHighlevelProtocolMap(protocol);
                if (highProtocol != null) {
                    String classname = highProtocol + "RelativeFile";
                    Class<?> c = RecordFile.forName(classname);
                    relFile file2 = (relFile)c.newInstance();
                    if (files != null) {
                        files.addElement(file2);
                    }
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer("Relative file '" + protocol + "' being handled by '" + classname + "'");
                    }
                    return file2;
                }
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("Relative file '" + protocol + "' being handled by default handler");
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING) break block7;
                LogSetup.LOGGER.severe("Relative file handler not found for protocol '" + protocol + "' " + e.getMessage());
            }
        }
        relFile file3 = new relFile();
        if (files != null) {
            files.addElement(file3);
        }
        return file3;
    }

    public static idxFile getIdxFile(Context context) {
        return RecordFile.getIdxFile(context == null ? (Vector<basicFile>)null : context.getFiles());
    }

    public static idxFile getIdxFile(Context context, String dsName, String ddName) {
        if (dsName != null && dsName.startsWith("env:")) {
            ddName = dsName;
            dsName = null;
        }
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if (dsName == null && ddName != null) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("No DSN associated with DD name '" + ddName + "'. Use property \"-D" + ddName + "=protocol:datasetname\" or environment variable \"" + ddName + "=protocol:datasetname\" or EBP \"//" + ddName.toUpperCase() + " DD DSN=datasetname,DCB=PROTOCOL=protocol,DISP=SHR\". Using default file handler and potentially opening '" + ddName + "' as file name.");
            }
            return new idxFile();
        }
        idxFile idx = RecordFile.getIdxFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName);
        if (idx != null) {
            if (ddName != null) {
                idx.ddName = ddName;
            }
            if (dsName != null) {
                idx.setFilename(dsName);
            }
        }
        return idx;
    }

    private static idxFile getIdxFile(Vector<basicFile> files) {
        idxFile file2 = new idxFile();
        if (files != null) {
            files.addElement(file2);
        }
        return file2;
    }

    public static idxFile getIdxFile(Context context, String ddName) {
        idxFile idx;
        String dsName = null;
        if (ddName != null) {
            String nameValue = basicFile.resolveExpandedAlias(ddName);
            if (nameValue != null) {
                String[] nameAndValue = nameValue.split("=");
                ddName = nameAndValue[0];
                dsName = nameAndValue[1];
            } else {
                dsName = ddName;
                ddName = null;
            }
        }
        if ((idx = RecordFile.getIdxFile(context == null ? (Vector<basicFile>)null : context.getFiles(), dsName)) != null) {
            if (ddName != null) {
                idx.ddName = ddName;
            }
            if (dsName != null) {
                idx.setFilename(dsName);
            }
        }
        return idx;
    }

    public static idxFile getIdxFile(Vector<basicFile> files, String protocol) {
        block7: {
            String highProtocol = "unknown";
            try {
                highProtocol = RecordFile.getHighlevelProtocolMap(protocol);
                if (highProtocol != null) {
                    String classname = highProtocol + "IndexedFile";
                    Class<?> c = RecordFile.forName(classname);
                    idxFile file2 = (idxFile)c.newInstance();
                    if (files != null) {
                        files.addElement(file2);
                    }
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer("Index file '" + protocol + "' being handled by '" + classname + "'");
                    }
                    return file2;
                }
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finer("Index file '" + protocol + "' being handled by default handler");
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING) break block7;
                LogSetup.LOGGER.severe("Index file handler not found for '" + protocol + "' " + e.getMessage());
            }
        }
        idxFile file3 = new idxFile();
        if (files != null) {
            files.addElement(file3);
        }
        return file3;
    }

    public static Object getTransactionFile(Context context) {
        return RecordFile.getTransactionFile(context == null ? (Vector<basicFile>)null : context.getFiles());
    }

    private static Object getTransactionFile(Vector<basicFile> files) {
        try {
            Class<?> c = RecordFile.forName("com.heirloomcomputing.ecs.exec.AS400TransactionFile");
            TransactionFile file2 = (TransactionFile)c.newInstance();
            if (files != null) {
                files.addElement(file2);
            }
            return file2;
        }
        catch (Throwable t) {
            throw new RuntimeException("AS400TransactionFile class not found.");
        }
    }

    public static Object getTransactionFile(Context context, String protocol) {
        return RecordFile.getTransactionFile(context == null ? (Vector<basicFile>)null : context.getFiles(), protocol);
    }

    private static Object getTransactionFile(Vector<basicFile> files, String protocol) {
        char ch;
        if (protocol == null) {
            return RecordFile.getTransactionFile(files);
        }
        if (protocol.length() > 12 && ((ch = protocol.charAt(11)) == '-' || ch == '_') && protocol.toUpperCase().startsWith("WORKSTATION")) {
            try {
                Class<?> c = RecordFile.forName("com.heirloomcomputing.ecs.exec.AS400TransactionFile");
                TransactionFile file2 = (TransactionFile)c.newInstance();
                if (files != null) {
                    files.addElement(file2);
                }
                return file2;
            }
            catch (Throwable t) {
                throw new RuntimeException("AS400TransactionFile class not found.");
            }
        }
        try {
            String highProtocol = RecordFile.getHighlevelProtocolMap(protocol);
            if (highProtocol != null) {
                String classname = highProtocol + "TransactionFile";
                Class<?> c = RecordFile.forName(classname);
                TransactionFile file3 = (TransactionFile)c.newInstance();
                if (files != null) {
                    files.addElement(file3);
                }
                return file3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return RecordFile.getTransactionFile(files);
    }

    public static XmlFile getXmlFile(Context context) {
        return RecordFile.getXmlFile(context == null ? (Vector<basicFile>)null : context.getFiles());
    }

    private static XmlFile getXmlFile(Vector<basicFile> files) {
        try {
            Class<?> c = RecordFile.forName("com.heirloomcomputing.ecs.exec.XmlFile");
            XmlFile file2 = (XmlFile)c.newInstance();
            if (files != null) {
                files.addElement(file2);
            }
            return file2;
        }
        catch (Throwable t) {
            throw new RuntimeException("XmlFile class not found.");
        }
    }

    public static XmlFile getXmlFile(Context context, String protocol) {
        return RecordFile.getXmlFile(context == null ? (Vector<basicFile>)null : context.getFiles(), protocol);
    }

    private static XmlFile getXmlFile(Vector<basicFile> files, String protocol) {
        char ch;
        if (protocol == null) {
            return RecordFile.getXmlFile(files);
        }
        if (protocol.length() > 12 && ((ch = protocol.charAt(11)) == '-' || ch == '_') && protocol.toUpperCase().startsWith("WORKSTATION")) {
            try {
                Class<?> c = RecordFile.forName("com.heirloomcomputing.ecs.exec.XmlFile");
                XmlFile file2 = (XmlFile)c.newInstance();
                if (files != null) {
                    files.addElement(file2);
                }
                return file2;
            }
            catch (Throwable t) {
                throw new RuntimeException("XmlFile class not found.");
            }
        }
        try {
            String highProtocol = RecordFile.getHighlevelProtocolMap(protocol);
            if (highProtocol != null) {
                String classname = highProtocol + "XmlFile";
                Class<?> c = RecordFile.forName(classname);
                XmlFile file3 = (XmlFile)c.newInstance();
                if (files != null) {
                    files.addElement(file3);
                }
                return file3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return RecordFile.getXmlFile(files);
    }

    public static String[][] getHighlevelProtocols() {
        return highlevelProtocols;
    }

    public static int getHighlevelProtocolCount() {
        return highlevelProtocols.length;
    }

    public static String getHighlevelProtocol(int n) {
        return highlevelProtocols[n][0];
    }

    public static String getHighlevelProtocolMap(int n) {
        return highlevelProtocols[n][1];
    }

    public static String getHighlevelProtocolMap(String protocol) {
        int index;
        if (protocol != null && (index = protocol.indexOf(58)) >= 0) {
            int i;
            protocol = protocol.substring(0, index + 1);
            int length = RecordFile.getHighlevelProtocolCount();
            for (i = 0; i < length; ++i) {
                if (!RecordFile.getHighlevelProtocol(i).equalsIgnoreCase(protocol)) continue;
                return RecordFile.getHighlevelProtocolMap(i);
            }
            if (additionalProtocols != null) {
                length = additionalProtocols.size();
                for (i = 0; i < length; ++i) {
                    String temp = additionalProtocols.elementAt(i);
                    if (!temp.equalsIgnoreCase(protocol)) continue;
                    return temp;
                }
            }
        }
        return null;
    }

    public static void addHighlevelProtocol(String name) {
        if (additionalProtocols == null) {
            additionalProtocols = new Vector();
        }
        additionalProtocols.addElement(name);
    }

    public static void unlockAllRecords(Context context) {
        RecordFile.unlockAllRecords(context.getFilesReadOnly());
    }

    private static void unlockAllRecords(Vector<basicFile> files) {
        if (files == null) {
            return;
        }
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            try {
                basicFile file2 = files.elementAt(i);
                file2.unlock();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

