/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.RecordServerFile;
import com.heirloomcomputing.ecs.exec.SessionManager;
import com.heirloomcomputing.ecs.exec.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class RecordServer
extends Thread {
    public static final int DEFAULT_SERVER_PORT = 6586;
    public static final boolean debugMode = false;
    private static boolean serviceMode = false;
    public static final int OPEN_MANUAL = 8192;
    public static final int OPEN_AUTOMATIC = 16384;
    public static final int OPEN_MULTIPLE = 65536;
    public static final int OPEN_RECORD_MODES = 90112;
    public static final int STATUS_LOCK_REJECTED = 0;
    public static final int STATUS_LOCK_OBTAINED = 1;
    public static final int STATUS_FILE_CHANGED = 2;
    public static final int STATUS_RECORD_CHANGED = 4;
    public static final int STATUS_ERROR_UNKNOWN = 8;
    public static final int STATUS_TOO_MANY = 16;
    private static boolean show = false;
    private static boolean consoleMode = true;
    private static boolean visibleExit = false;
    private static String[] acceptableHosts = null;
    private static ServerSocket ssocket = null;
    private static int sessionCounter = 0;
    private int session = 0;
    private Socket socket = null;
    private DataInputStream is;
    private DataOutputStream os;
    private static Hashtable<String, RecordServerFile> recordServerFiles = new Hashtable();

    private static void verbose(String message) {
        if (show) {
            System.out.println(message);
        }
    }

    private void message(String message) {
        if (show) {
            System.out.println(this.session + ": " + message);
        }
    }

    private static boolean visiblePrompt(String msg) {
        int result = JOptionPane.showConfirmDialog(null, msg, msg, 2);
        return result == 0;
    }

    public static void service(boolean shutdown, boolean eclipse, String[] params) {
        serviceMode = true;
        visibleExit = eclipse;
        if (shutdown) {
            if (eclipse && !RecordServer.visiblePrompt("Shutting down Record Server...")) {
                System.exit(0);
                return;
            }
            RecordServer.shutdown(6586);
            System.exit(0);
        } else {
            if (eclipse && !RecordServer.visiblePrompt("Initializing Record Server...")) {
                System.exit(0);
                return;
            }
            RecordServer.main(params);
        }
    }

    public static void main(String[] args) {
        int serverPort = 6586;
        String arg = null;
        if (serviceMode) {
            consoleMode = false;
        }
        for (int i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg == null) continue;
            if (arg.equalsIgnoreCase("quiet")) {
                show = false;
                continue;
            }
            if (arg.equalsIgnoreCase("verbose")) {
                show = true;
                continue;
            }
            if (arg.equalsIgnoreCase("daemon") || arg.equalsIgnoreCase("demon")) {
                consoleMode = false;
                continue;
            }
            if (arg.equalsIgnoreCase("console")) {
                consoleMode = true;
                continue;
            }
            if (arg.equalsIgnoreCase("quit") || arg.equalsIgnoreCase("exit") || arg.equalsIgnoreCase("stop") || arg.equalsIgnoreCase("shutdown")) {
                RecordServer.shutdown(serverPort);
                continue;
            }
            if (arg.equalsIgnoreCase("help") || arg.equals("?")) {
                System.out.println("RecordServer [options] [server_port_#]");
                System.out.println("");
                System.out.println("Options: quiet, verbose, daemon, console, stop, help, {server-port-number}");
                continue;
            }
            try {
                serverPort = Integer.parseInt(args[i].trim());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        acceptableHosts = args;
        RecordServer.verbose("Elastic COBOL Record Server");
        RecordServer.verbose("Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.");
        RecordServer.verbose("");
        RecordServer.verbose("Starting server on port " + serverPort + "...");
        RecordServer.serve(serverPort);
    }

    private static void shutdown(int serverPort) {
        try {
            Socket s = new Socket("127.0.0.1", serverPort);
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            out.writeUTF("quit");
            out.writeInt(-1);
            out.flush();
            out.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println("Error occurred shutting down server:");
            e.printStackTrace(System.out);
        }
        System.exit(0);
    }

    public static void serve(int serverPort) {
        try {
            if (ssocket != null) {
                ssocket.close();
                ssocket = null;
            }
            ssocket = new ServerSocket(serverPort);
            ssocket.setSoTimeout(0);
        }
        catch (IOException e) {
            RecordServer.verbose("ERROR: Could not open ServerSocket: " + e);
            if (visibleExit) {
                JOptionPane.showMessageDialog(null, "Record Server Already Executing\nMust Shutdown Before Start");
            }
            System.exit(0);
            return;
        }
        RecordServer.verbose("ServerSocket successfully opened.");
        new RecordServer().start();
        if (!consoleMode) {
            return;
        }
        try {
            BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
            boolean quit = false;
            do {
                String line;
                if ((line = d.readLine()) != null) {
                    if ((line = line.toUpperCase()).startsWith("E") || line.startsWith("X") || line.startsWith("Q")) {
                        quit = true;
                    }
                    if (line.startsWith("V")) {
                        Version.outputVersion();
                    }
                }
                System.out.println("ConsoleCommand> " + line);
            } while (!quit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    @Override
    public void run() {
        RecordServer pool = new RecordServer();
        try {
            byte[] address;
            this.session = ++sessionCounter;
            if (show) {
                this.message("Session Waiting on Connection");
            }
            this.socket = ssocket.accept();
            this.socket.setSoTimeout(0);
            this.socket.setTcpNoDelay(true);
            pool.start();
            InetAddress inetAddress = this.socket.getInetAddress();
            if (show) {
                this.message("Session Verifying Connection to " + inetAddress);
            }
            if ((address = inetAddress.getAddress())[0] == 127 && address[1] == 0 && address[2] == 0 && address[3] == 1) {
                this.message("Local Host Connection Accepted");
            } else {
                boolean accepted = false;
                if (acceptableHosts != null) {
                    for (int i = 0; i < acceptableHosts.length; ++i) {
                        if (acceptableHosts[i].equalsIgnoreCase(inetAddress.toString())) {
                            accepted = true;
                            continue;
                        }
                        if (!acceptableHosts[i].equalsIgnoreCase("ANY")) continue;
                        accepted = true;
                    }
                }
                if (!accepted) {
                    this.message("Connection refused to " + inetAddress + ".");
                    this.socket.close();
                    return;
                }
            }
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            if (show) {
                this.message("Session established.");
            }
            try {
                String filename = this.is.readUTF();
                int mode = this.is.readInt();
                this.serve(mode, filename);
                if (show) {
                    this.message("Session is closed.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.os.flush();
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serve(int mode, String filename) {
        SessionManager session;
        RecordServerFile recordServerFile;
        block31: {
            if (mode < 0) {
                System.exit(0);
            }
            boolean single = (mode & 0x10000) == 0;
            recordServerFile = null;
            Hashtable<String, RecordServerFile> hashtable = recordServerFiles;
            synchronized (hashtable) {
                recordServerFile = recordServerFiles.get(filename);
                if (recordServerFile == null) {
                    recordServerFile = new RecordServerFile(filename);
                    recordServerFiles.put(filename, recordServerFile);
                    if (show) {
                        this.message("Creating new RecordServerFile for '" + filename + "';" + mode + " " + recordServerFile);
                    }
                } else if (show) {
                    this.message("Obtained current RecordServerFile for '" + filename + "';" + mode + " " + recordServerFile);
                }
            }
            session = recordServerFile.addRecordSession(mode);
            boolean haveExclusiveLock = false;
            if (session != null) {
                try {
                    int command = 0;
                    do {
                        boolean show_file;
                        long timeoutDelay;
                        long recordNumber;
                        if ((command = this.is.readInt()) == 1) {
                            if (haveExclusiveLock) {
                                if (show) {
                                    this.message("EXCLUSIVE (PRE-EXISTING)");
                                }
                                this.os.writeInt(1);
                                this.os.flush();
                                continue;
                            }
                            if (recordServerFile.setExclusiveLock()) {
                                if (show) {
                                    this.message("EXCLUSIVE OBTAINED");
                                }
                                this.os.writeInt(1);
                                this.os.flush();
                                haveExclusiveLock = true;
                                continue;
                            }
                            if (show) {
                                this.message("EXCLUSIVE REJECTED");
                            }
                            this.os.writeInt(0);
                            this.os.flush();
                            continue;
                        }
                        if (command == 2) {
                            if (show) {
                                this.message("UN-EXCLUSIVE");
                            }
                            if (!haveExclusiveLock) continue;
                            recordServerFile.clearExclusiveLock();
                            continue;
                        }
                        if (command == 3) {
                            boolean show_file2;
                            recordNumber = this.is.readLong();
                            int notifyResult = recordServerFile.lock(session, recordNumber);
                            boolean show_record = (notifyResult & 4) != 0;
                            boolean bl = show_file2 = (notifyResult & 2) != 0;
                            if ((notifyResult & 1) != 0) {
                                this.os.writeInt(notifyResult);
                                this.os.flush();
                                if (single && recordNumber >= 0L) {
                                    if (show) {
                                        this.message("UNLOCK ALL BUT " + recordNumber);
                                    }
                                    recordServerFile.unlockAllBut(session, recordNumber);
                                }
                                if (!show) continue;
                                this.message("LOCK " + recordNumber + " OBTAINED (" + (show_record ? "R" : "") + (show_file2 ? "F" : "") + ")");
                                continue;
                            }
                            this.os.writeInt(notifyResult);
                            this.os.flush();
                            if (!show) continue;
                            this.message("LOCK " + recordNumber + " REJECTED (" + (show_record ? "R" : "") + (show_file2 ? "F" : "") + ")");
                            continue;
                        }
                        if (command == 4) {
                            recordNumber = this.is.readLong();
                            if (show) {
                                this.message("UNLOCK " + recordNumber);
                            }
                            recordServerFile.unlock(session, recordNumber);
                            continue;
                        }
                        if (command == 5 || command == 0) {
                            if (show) {
                                this.message("UNLOCK ALL");
                            }
                            recordServerFile.unlockSession(session);
                            continue;
                        }
                        if (command != 6) continue;
                        recordNumber = this.is.readLong();
                        int notifyResult = recordServerFile.lock(session, recordNumber, timeoutDelay = this.is.readLong());
                        boolean show_record = (notifyResult & 4) != 0;
                        boolean bl = show_file = (notifyResult & 2) != 0;
                        if ((notifyResult & 1) != 0) {
                            this.os.writeInt(notifyResult);
                            this.os.flush();
                            if (single && recordNumber >= 0L) {
                                if (show) {
                                    this.message("UNLOCK ALL BUT " + recordNumber);
                                }
                                recordServerFile.unlockAllBut(session, recordNumber);
                            }
                            if (!show) continue;
                            this.message("BLOCKING LOCK " + recordNumber + " OBTAINED (" + (show_record ? "R" : "") + (show_file ? "F" : "") + ")");
                            continue;
                        }
                        this.os.writeInt(notifyResult);
                        this.os.flush();
                        if (!show) continue;
                        this.message("BLOCKING LOCK " + recordNumber + " REJECTED (" + (show_record ? "R" : "") + (show_file ? "F" : "") + ")");
                    } while (command != 0);
                }
                catch (Exception e) {
                    if (!haveExclusiveLock) break block31;
                    recordServerFile.clearExclusiveLock();
                }
            }
        }
        recordServerFile.removeSession(session);
    }
}

