/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.SessionManager;
import java.util.Vector;

class RecordServerFile {
    private final Object unlockSignal = new Object();
    private static final boolean debugMode = false;
    private static final boolean debugPerformance = false;
    private long start = 0L;
    private long countSEL = 0L;
    private long totalSEL = 0L;
    private long countCEL = 0L;
    private long totalCEL = 0L;
    private long countARS = 0L;
    private long totalARS = 0L;
    private long countUL = 0L;
    private long totalUL = 0L;
    private long countUS = 0L;
    private long totalUS = 0L;
    private long countUAB = 0L;
    private long totalUAB = 0L;
    private long countL = 0L;
    private long totalL = 0L;
    private long countBL = 0L;
    private long totalBL = 0L;
    private long countBlocks = 0L;
    private String filename;
    private Vector<SessionManager> sessions = new Vector();
    private boolean allLocked = false;
    private int occurrance = 0;
    private static int occurrances;
    public static final long POLL_TIMEOUT = 33L;

    private void outputPerformance() {
        System.out.println("-- record server file performance --");
        if (this.countSEL != 0L) {
            System.out.println("SetExclLock  :" + this.countSEL + " Total:" + this.totalSEL + " Avg:" + (double)this.totalSEL / (double)this.countSEL);
        }
        if (this.countCEL != 0L) {
            System.out.println("ClearExclLock:" + this.countCEL + " Total:" + this.totalCEL + " Avg:" + (double)this.totalCEL / (double)this.countCEL);
        }
        if (this.countARS != 0L) {
            System.out.println("AddRecordSess:" + this.countARS + " Total:" + this.totalARS + " Avg:" + (double)this.totalARS / (double)this.countARS);
        }
        if (this.countUL != 0L) {
            System.out.println("Unlock       :" + this.countUL + " Total:" + this.totalUL + " Avg:" + (double)this.totalUL / (double)this.countUL);
        }
        if (this.countUAB != 0L) {
            System.out.println("UnlockAllBut :" + this.countUAB + " Total:" + this.totalUAB + " Avg:" + (double)this.totalUAB / (double)this.countUAB);
        }
        if (this.countUS != 0L) {
            System.out.println("UnlockSession:" + this.countUS + " Total:" + this.totalUS + " Avg:" + (double)this.totalUS / (double)this.countUS);
        }
        if (this.countL != 0L) {
            System.out.println("Lock         :" + this.countL + " Total:" + this.totalL + " Avg:" + (double)this.totalL / (double)this.countL);
        }
        if (this.countBL != 0L) {
            System.out.println("Block Lock   :" + this.countBL + " Total:" + this.totalBL + " Avg:" + (double)this.totalBL / (double)this.countBL);
        }
        if (this.countBlocks != 0L) {
            System.out.println("Blocks       :" + this.countBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setExclusiveLock() {
        Vector<SessionManager> vector = this.sessions;
        synchronized (vector) {
            if (this.allLocked) {
                return false;
            }
            for (int i = 0; i < this.sessions.size(); ++i) {
                SessionManager session;
                SessionManager sessionManager = session = this.sessions.elementAt(i);
                synchronized (sessionManager) {
                    if (!session.isLockEmpty()) {
                        return false;
                    }
                    continue;
                }
            }
            this.allLocked = true;
            return true;
        }
    }

    public void clearExclusiveLock() {
        this.allLocked = false;
    }

    public boolean isExclusiveLock() {
        return this.allLocked;
    }

    public RecordServerFile(String filename) {
        this.filename = filename;
        this.occurrance = occurrances++;
    }

    public String toString() {
        return "RecordServerFile (" + this.occurrance + ":" + this.filename + ") " + (this.allLocked ? "EXCLUSIVE" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionManager addRecordSession(int mode) {
        Vector<SessionManager> vector = this.sessions;
        synchronized (vector) {
            SessionManager session = new SessionManager();
            session.setMode(mode);
            this.sessions.addElement(session);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(SessionManager session) {
        Vector<SessionManager> vector = this.sessions;
        synchronized (vector) {
            try {
                int sessions_size = this.sessions.size();
                for (int i = 0; i < sessions_size; ++i) {
                    SessionManager examine = this.sessions.elementAt(i);
                    if (examine != session) continue;
                    this.sessions.removeElementAt(i);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMode(int number) {
        Vector<SessionManager> vector = this.sessions;
        synchronized (vector) {
            return this.sessions.elementAt(number).getMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockSession(int number) {
        Object object = this.sessions;
        synchronized (object) {
            SessionManager session;
            SessionManager sessionManager = session = this.sessions.elementAt(number);
            synchronized (sessionManager) {
                session.unlockAll();
            }
        }
        object = this.unlockSignal;
        synchronized (object) {
            try {
                this.unlockSignal.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockSession(SessionManager session) {
        Object object = session;
        synchronized (object) {
            session.unlockAll();
        }
        object = this.unlockSignal;
        synchronized (object) {
            try {
                this.unlockSignal.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(long recordNumber) {
        Object object = this.sessions;
        synchronized (object) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                SessionManager session = this.sessions.elementAt(i);
                if (!this.unlock(session, recordNumber)) continue;
                Object object2 = this.unlockSignal;
                synchronized (object2) {
                    try {
                        this.unlockSignal.notifyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.yield();
                return true;
            }
        }
        object = this.unlockSignal;
        synchronized (object) {
            try {
                this.unlockSignal.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.yield();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(SessionManager session, long unlockNumber) {
        Object object = session;
        synchronized (object) {
            if (session.unlock(unlockNumber) == 0) {
                Object object2 = this.unlockSignal;
                synchronized (object2) {
                    try {
                        this.unlockSignal.notifyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.yield();
                return true;
            }
        }
        object = this.unlockSignal;
        synchronized (object) {
            try {
                this.unlockSignal.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.yield();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAllBut(SessionManager session, long retainNumber) {
        Object object = session;
        synchronized (object) {
            session.unlockAllBut(retainNumber);
        }
        object = this.unlockSignal;
        synchronized (object) {
            try {
                this.unlockSignal.notifyAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lock(SessionManager session, long recordNumber) {
        if (this.allLocked) {
            return 0;
        }
        Vector<SessionManager> vector = this.sessions;
        synchronized (vector) {
            SessionManager sessionManager = session;
            synchronized (sessionManager) {
                int result = session.isLocked(recordNumber);
                if (result == 0) {
                    int notifyResult = 1;
                    if (session.isFileChanged()) {
                        notifyResult |= 2;
                    }
                    return notifyResult;
                }
                if (this.isLocked(recordNumber, session)) {
                    int notifyResult = 0;
                    if (session.isFileChanged()) {
                        notifyResult |= 2;
                    }
                    return notifyResult;
                }
                result = !this.isLockedInSession(recordNumber, session) ? session.lock(recordNumber) : 3;
                int notifyResult = 0;
                boolean obtainedNewWriteLock = false;
                switch (result) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 3: {
                        if (recordNumber >= 0L) {
                            obtainedNewWriteLock = true;
                        }
                        notifyResult |= 1;
                        break;
                    }
                    case 2: {
                        if (recordNumber >= 0L) {
                            obtainedNewWriteLock = true;
                        }
                        notifyResult |= 5;
                        break;
                    }
                    case 4: {
                        notifyResult |= 0x10;
                        break;
                    }
                    case 5: {
                        notifyResult |= 8;
                    }
                }
                if (session.isFileChanged()) {
                    notifyResult |= 2;
                }
                if (session.isFileAlwaysRecordChanged()) {
                    notifyResult |= 4;
                }
                if (obtainedNewWriteLock) {
                    int sessions_size = this.sessions.size();
                    for (int i = 0; i < sessions_size; ++i) {
                        int notifyStatus;
                        SessionManager notifySession = this.sessions.elementAt(i);
                        if (notifySession == session || (notifyStatus = notifySession.notify(recordNumber)) != 3) continue;
                        notifyResult |= 8;
                    }
                }
                return notifyResult;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lock(SessionManager session, long recordNumber, long timeout) {
        int sequence = 0;
        long finalTimeout = System.currentTimeMillis() + timeout;
        boolean failure = false;
        do {
            boolean bl = failure = ((sequence = this.lock(session, recordNumber)) & 1) == 0;
            if (!failure || System.currentTimeMillis() >= finalTimeout) break;
            Object object = this.unlockSignal;
            synchronized (object) {
                try {
                    this.unlockSignal.wait(timeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (failure && System.currentTimeMillis() < finalTimeout);
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocked(long recordNumber, SessionManager currentSession) {
        int sessions_size = this.sessions.size();
        for (int i = 0; i < sessions_size; ++i) {
            SessionManager session = this.sessions.elementAt(i);
            if (session == currentSession) continue;
            SessionManager sessionManager = session;
            synchronized (sessionManager) {
                int result = session.isLocked(recordNumber);
                if (recordNumber < 0L) {
                    if (result == 1) {
                        return true;
                    }
                } else if (result == 0 || result == 1) {
                    return true;
                }
                continue;
            }
        }
        return false;
    }

    private boolean isLockedInSession(long recordNumber, SessionManager session) {
        int result = session.isLocked(recordNumber);
        return recordNumber < 0L ? result == 1 : result == 0 || result == 1;
    }

    private void yield() {
        try {
            Thread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

