/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ServletScreen;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletContext
extends Context {
    private HttpServlet servlet;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletScreen SERVLET = null;
    private boolean servletLogging = false;

    public HttpServlet getHttpServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public HttpSession getHttpSession() {
        HttpSession result = this.request.getSession(false);
        if (result == null) {
            result = this.request.getSession(true);
        }
        return result;
    }

    private void logServlet(String s) {
        if (!this.servletLogging) {
            return;
        }
        System.out.println("ServletLog: " + s);
    }

    private void logServlet(Throwable t) {
        if (!this.servletLogging) {
            return;
        }
        t.printStackTrace(System.out);
    }

    @Override
    public Object getObject(String name) {
        if (name != null) {
            if ((name = name.toUpperCase()).equals("SERVLET")) {
                return this.servlet;
            }
            if (name.equals("REQUEST")) {
                return this.request;
            }
            if (name.equals("RESPONSE")) {
                return this.response;
            }
            if (name.equals("CONFIG")) {
                return this.getServletConfig();
            }
            if (name.equals("SESSION")) {
                return this.getHttpSession();
            }
        }
        return super.getObject(name);
    }

    public ServletContext(HttpServlet httpServlet, HttpServletRequest req, HttpServletResponse res, boolean gzip) {
        this(httpServlet, req, res, gzip, false);
    }

    public ServletContext(HttpServlet httpServlet, HttpServletRequest req, HttpServletResponse res, boolean gzip, boolean servletLogging) {
        this();
        this.servletLogging = servletLogging;
        try {
            this.servlet = httpServlet;
            this.request = req;
            this.response = res;
            this.SERVLET = new ServletScreen(servletLogging);
            PrintWriter writer = null;
            this.response.setContentType("text/html");
            if (res != null) {
                String encodings;
                if (gzip && (encodings = this.request.getHeader("Accept-Encoding")) != null && encodings.indexOf("gzip") >= 0) {
                    this.response.setHeader("Content-Encoding", "gzip");
                    writer = new PrintWriter(new GZIPOutputStream((OutputStream)res.getOutputStream()), false);
                }
                if (writer == null) {
                    writer = res.getWriter();
                }
            }
            this.SERVLET.setObject(writer, req);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ServletContext() {
        this(null, "default", null, false);
    }

    public ServletContext(String programName) {
        this(null, programName, null, false);
    }

    public ServletContext(Context baseContext) {
        this(baseContext, baseContext.programName, baseContext.program, false);
    }

    public ServletContext(Context baseContext, String programName) {
        this(baseContext, programName, baseContext.program, false);
    }

    public ServletContext(Context baseContext, String programName, Object program) {
        this(baseContext, programName, program, false);
    }

    public ServletContext(Context baseContext, String programName, Object program, boolean servletLogging) {
        super(baseContext, programName, program);
        this.servletLogging = servletLogging;
        if (baseContext instanceof ServletContext) {
            this.setupServlet((ServletContext)baseContext);
        }
    }

    @Override
    public void setupContext(Context baseContext, String programName, Object program) {
        super.setupContext(baseContext, programName, program);
        this.setupServlet((ServletContext)baseContext);
    }

    public void setupServlet(ServletContext c) {
        this.request = c.request;
        this.response = c.response;
        this.SERVLET = c.SERVLET;
    }

    public void setupServlet(Context c) {
        try {
            this.setupServlet((ServletContext)c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Context create(Context context) {
        return new ServletContext(context);
    }

    @Override
    public Context create() {
        return new ServletContext();
    }

    @Override
    public void setIdentifiedBy(Variable v, String name) {
        if (name == null || name.length() == 0) {
            return;
        }
    }

    @Override
    public void setIdentifiedBy(Variable v, String name, String defaultValue) {
        if (name == null || name.length() == 0) {
            return;
        }
    }

    private String safeString(Object o) {
        if (o == null) {
            return "";
        }
        return String.valueOf(o);
    }

    private String getServletParameter(String name) {
        String check = name.toUpperCase().replace('_', '-');
        if (check.equals("COOKIES")) {
            return String.valueOf(this.request.getCookies().length);
        }
        if (check.startsWith("COOKIE-")) {
            return this.safeString(this.request.getCookies()[Integer.parseInt(name.substring(7).trim())]);
        }
        if (check.equals("METHOD")) {
            return this.safeString(this.request.getMethod());
        }
        if (check.equals("REQUEST-URI")) {
            return this.safeString(this.request.getRequestURI());
        }
        if (check.equals("PATH")) {
            return this.safeString(this.request.getServletPath());
        }
        if (check.equals("PATH-INFO")) {
            return this.safeString(this.request.getPathInfo());
        }
        if (check.equals("PATH-TRANSLATED")) {
            return this.safeString(this.request.getPathTranslated());
        }
        if (check.equals("QUERY-STRING")) {
            return this.safeString(this.request.getQueryString());
        }
        if (check.equals("REMOTE-USER")) {
            return this.safeString(this.request.getRemoteUser());
        }
        if (check.equals("AUTH-TYPE")) {
            return this.safeString(this.request.getAuthType());
        }
        if (check.startsWith("HEADER-")) {
            return this.safeString(this.request.getHeader(name.substring(7)));
        }
        if (check.equals("REQUESTED-SESSION-ID")) {
            return this.safeString(this.request.getRequestedSessionId());
        }
        if (check.equals("REQUESTED-SESSION-ID-VALID")) {
            return this.request.isRequestedSessionIdValid() ? "1" : "0";
        }
        if (check.equals("REQUESTED-SESSION-ID-FROM-COOKIE")) {
            return this.request.isRequestedSessionIdFromCookie() ? "1" : "0";
        }
        if (check.equals("REQUESTED-SESSION-ID-FROM-URL")) {
            return this.request.isRequestedSessionIdFromURL() ? "1" : "0";
        }
        if (check.equals("CONTENT-LENGTH")) {
            return String.valueOf(this.request.getContentLength());
        }
        if (check.equals("CONTENT-TYPE")) {
            return this.safeString(this.request.getContentType());
        }
        if (check.equals("PROTOCOL")) {
            return this.safeString(this.request.getProtocol());
        }
        if (check.equals("SCHEME")) {
            return this.safeString(this.request.getScheme());
        }
        if (check.equals("SERVER-NAME")) {
            return this.safeString(this.request.getServerName());
        }
        if (check.equals("SERVER-PORT")) {
            return String.valueOf(this.request.getServerPort());
        }
        if (check.equals("REMOTE-ADDR")) {
            return this.safeString(this.request.getRemoteAddr());
        }
        if (check.equals("REMOTE-HOST")) {
            return this.safeString(this.request.getRemoteHost());
        }
        if (check.startsWith("PARAMETER-")) {
            return this.safeString(this.request.getParameter(name.substring(10)));
        }
        if (check.startsWith("PARAMETER#-")) {
            int index = name.indexOf(45, 11);
            if (index >= 0) {
                return this.safeString(this.request.getParameterValues(name.substring(11, index))[Integer.parseInt(name.substring(index + 1).trim())]);
            }
            return this.safeString(this.request.getParameter(name.substring(11)));
        }
        if (check.equals("CHARACTER-ENCODING")) {
            return this.safeString(this.request.getCharacterEncoding());
        }
        if (check.equals("SESSION-CREATION-TIME")) {
            return this.safeString(new Date(this.getHttpSession().getCreationTime()));
        }
        if (check.equals("SESSION-ID")) {
            return this.safeString(this.getHttpSession().getId());
        }
        if (check.equals("SESSION-LAST-ACCESSED-TIME")) {
            return this.safeString(new Date(this.getHttpSession().getLastAccessedTime()));
        }
        if (check.equals("SESSION-NEW")) {
            return this.getHttpSession().isNew() ? "1" : "0";
        }
        if (check.startsWith("SESSION-PARAMETER-")) {
            try {
                return this.safeString(this.getHttpSession().getAttribute(name.substring(18)));
            }
            catch (Exception dep) {
                return this.safeString(this.getHttpSession().getAttribute(name.substring(18)));
            }
        }
        if (check.equals("SESSION-MAX-INACTIVE-INTERVAL")) {
            return String.valueOf(this.getHttpSession().getMaxInactiveInterval());
        }
        if (check.startsWith("SESSION-ATTRIBUTE-")) {
            return this.safeString(this.getHttpSession().getAttribute(name.substring(18)));
        }
        if (check.startsWith("CONTAINS-HEADER-")) {
            return this.response.containsHeader(name.substring(16)) ? "1" : "0";
        }
        if (check.startsWith("ATTRIBUTE-")) {
            return this.safeString(this.request.getAttribute(name.substring(10)));
        }
        if (check.startsWith("INIT-PARAMETER-")) {
            return this.safeString(this.getServletConfig().getInitParameter(name.substring(15)));
        }
        if (check.startsWith("NAME")) {
            return this.safeString(this.getServletConfig().getServletName());
        }
        if (check.equals("USER-AGENT")) {
            return this.safeString(this.request.getHeader("User-Agent"));
        }
        return null;
    }

    @Override
    public String getParameter(String name) {
        String value = null;
        try {
            String check = name.toUpperCase().replace('_', '-');
            if (check.startsWith("SERVLET-") ? (value = this.getServletParameter(name.substring(8))) != null : check.startsWith("HTTP-") && (value = this.getServletParameter(name.substring(5))) != null) {
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            value = RuntimeEnvironment.getGlobalParameter(name);
            if (value != null) {
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter(name);
            if (value != null) {
                return value;
            }
            value = this.request.getParameter(name);
            if (value != null) {
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setEnvironment(String name, String value) {
        String check;
        if (name != null) {
            name = name.trim();
        }
        if (value != null) {
            value = value.trim();
        }
        if ((check = name.toUpperCase().replace('_', '-')).startsWith("SERVLET-")) {
            this.setParameter(name, value);
        } else if (check.startsWith("HTTP-")) {
            this.setParameter(name, value);
        } else {
            super.setEnvironment(name, value);
        }
    }

    @Override
    public void setParameter(String name, String value) {
        block19: {
            try {
                String check = name.toUpperCase().replace('_', '-');
                boolean found = false;
                if (check.startsWith("SERVLET-")) {
                    check = check.substring(8);
                    name = name.substring(8);
                    found = true;
                } else if (check.startsWith("HTTP-")) {
                    check = check.substring(5);
                    name = name.substring(5);
                    found = true;
                }
                if (!found) break block19;
                if (check.equals("REDIRECT")) {
                    this.response.sendRedirect(this.response.encodeURL(value.trim()));
                    return;
                }
                if (check.startsWith("HEADER-")) {
                    this.response.setHeader(name.substring(7), value.trim());
                    return;
                }
                if (check.startsWith("STATUS-")) {
                    this.response.setStatus(Integer.parseInt(name.substring(7)));
                    return;
                }
                if (check.equals("CONTENT-LENGTH")) {
                    this.response.setContentLength(Integer.parseInt(value.trim()));
                    return;
                }
                if (check.equals("CONTENT-TYPE")) {
                    this.response.setContentType(value.trim());
                    return;
                }
                if (check.startsWith("SESSION-PARAMETER-")) {
                    try {
                        this.getHttpSession().setAttribute(name.substring(18), (Object)value.trim());
                    }
                    catch (Exception dep) {
                        this.getHttpSession().setAttribute(name.substring(18), (Object)value.trim());
                    }
                    return;
                }
                if (check.equals("SESSION-MAX-INACTIVE-INTERVAL")) {
                    this.getHttpSession().setMaxInactiveInterval(Integer.parseInt(value.trim()));
                    return;
                }
                if (check.startsWith("SESSION-ATTRIBUTE-")) {
                    if (value.trim().length() == 0) {
                        this.getHttpSession().removeAttribute(name.substring(18));
                    } else {
                        this.getHttpSession().setAttribute(name.substring(18), (Object)value.trim());
                    }
                    return;
                }
                if (check.equals("SESSION-INVALIDATE")) {
                    if (RuntimeEnvironment.isParameterValue(value)) {
                        this.getHttpSession().invalidate();
                    }
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RuntimeEnvironment.setGlobalParameter(name, value);
    }

    @Override
    public IO console() {
        return IO.system();
    }

    @Override
    public IO system() {
        return IO.system();
    }

    @Override
    public IO syserr() {
        return IO.syserr();
    }

    @Override
    public IO printer() {
        return IO.printer();
    }

    @Override
    public IO current() {
        return IO.system();
    }

    @Override
    public IO servlet() {
        return this.SERVLET;
    }

    @Override
    public IO session() {
        return this.SERVLET;
    }

    @Override
    public IO defaultio() {
        return this.SERVLET;
    }
}

