/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Dialog;
import com.heirloomcomputing.ecs.exec.ExitProgramException;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class Shutdown {
    private static final Object cobolThreadDepObject = new Object();
    private static String continueRunMessage = "Continue run (Yes/No)? ";
    private static int cobolThreadDependencies;
    private static boolean shouldExitProgram;
    protected static int appReturnCode;
    private static Vector<ProcedurePointer> shutdownProcedures;
    private static Vector<ProcedurePointer> errorProcedures;
    private static boolean shutdownHookAdded;

    private static int getReturnCode(Numeric param) {
        return param.toInt();
    }

    private static int getReturnCode(Variable param) {
        return param.generateReturnCode();
    }

    public static final void exitWhenFinished(boolean status) {
        shouldExitProgram = status;
    }

    public static final void requestExit() {
        Shutdown.requestExit(Utilities.getMainWindow());
    }

    public static final void requestExit(Window mainWindow) {
        try {
            Shutdown.waitForThreadQueues();
            if (shouldExitProgram) {
                try {
                    IO.deallocateIO();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mainWindow != null) {
                    try {
                        mainWindow.dispatchEvent(new WindowEvent(mainWindow, 201));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (RuntimeEnvironment.canJVMExit()) {
                System.exit(CobolException.getEnvReturnCode(appReturnCode));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static final void waitForThreadQueues() {
        try {
            Thread currentThread = Thread.currentThread();
            ThreadGroup threadGroup = currentThread.getThreadGroup();
            int aliveCount = 0;
            do {
                aliveCount = 0;
                int activeCount = threadGroup.activeCount();
                Thread[] threads = new Thread[activeCount];
                activeCount = threadGroup.enumerate(threads);
                for (int i = 0; i < activeCount; ++i) {
                    if (threads[i] == currentThread || threads[i] == null) continue;
                    try {
                        if (!threads[i].isAlive() || !(threads[i] instanceof ThreadQueue)) continue;
                        ++aliveCount;
                        threads[i].join();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } while (aliveCount > 0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static final void exit(String stopLiteral, int param) {
        try {
            String temp = RuntimeEnvironment.getGlobalParameter("CONTINUE-RUN-MESSAGE");
            if (temp != null) {
                continueRunMessage = temp.trim();
            }
            if (!Dialog.showYesNoDialog(stopLiteral, continueRunMessage)) {
                Shutdown.exit(param);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static final void exit(int param) {
        if (System.out != null) {
            System.out.flush();
        }
        if (System.err != null) {
            System.err.flush();
        }
        if (RuntimeEnvironment.canJVMExit()) {
            Shutdown.System_exit(CobolException.getEnvReturnCode(param));
        }
        throw new ExitProgramException("System Exit (" + param + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseCobolThreadDependencies() {
        Object object = cobolThreadDepObject;
        synchronized (object) {
            ++cobolThreadDependencies;
        }
    }

    public static final void exit() {
        Shutdown.exit(0);
    }

    public static final void exit(Numeric param) {
        Shutdown.exit(Shutdown.getReturnCode(param));
    }

    public static final void exit(Variable param) {
        Shutdown.exit(Shutdown.getReturnCode(param));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decreaseCobolThreadDependencies() {
        Object object = cobolThreadDepObject;
        synchronized (object) {
            if (--cobolThreadDependencies <= 0) {
                cobolThreadDepObject.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitCobolThreadDependencies() {
        Object object = cobolThreadDepObject;
        synchronized (object) {
            if (cobolThreadDependencies > 0) {
                try {
                    cobolThreadDepObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static void System_exit(int value) {
        if (Utilities.isApplet()) {
            return;
        }
        Shutdown.waitCobolThreadDependencies();
        try {
            System.exit(value);
        }
        catch (SecurityException s) {
            throw s;
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ExitProgramException("System Exit (" + value + ")");
    }

    public static final void userExit() {
        ThreadQueue.initiateShutdown();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Shutdown.exit();
    }

    private static boolean performShutdownProcedures() {
        return Shutdown.perform(shutdownProcedures);
    }

    static boolean performErrorProcedures() {
        return Shutdown.perform(errorProcedures);
    }

    private static boolean perform(Vector<ProcedurePointer> procedures) {
        boolean handled = false;
        if (procedures != null) {
            int size = procedures.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ProcedurePointer procedure = procedures.elementAt(i);
                    if (!(procedure instanceof Runnable)) continue;
                    ((Runnable)procedure).run();
                    handled = true;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return handled;
    }

    public static void addShutdownProcedure(ProcedurePointer routine) {
        if (shutdownProcedures == null) {
            shutdownProcedures = new Vector();
        }
        shutdownProcedures.addElement(routine);
    }

    public static void removeShutdownProcedure(ProcedurePointer routine) {
        if (shutdownProcedures == null) {
            return;
        }
        shutdownProcedures.removeElement(routine);
    }

    public static void addErrorProcedure(ProcedurePointer routine) {
        if (errorProcedures == null) {
            errorProcedures = new Vector();
        }
        errorProcedures.addElement(routine);
    }

    public static void removeErrorProcedure(ProcedurePointer routine) {
        if (errorProcedures == null) {
            return;
        }
        errorProcedures.removeElement(routine);
    }

    public static synchronized void addShutdownHook(Thread hook) {
        try {
            Runtime register = Runtime.getRuntime();
            Class[] c = new Class[]{Thread.class};
            Method m = Runtime.class.getDeclaredMethod("addShutdownHook", c);
            if (m != null) {
                try {
                    m.invoke((Object)register, hook);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static synchronized void removeShutdownHook(Thread hook) {
        try {
            Runtime register = Runtime.getRuntime();
            Class[] c = new Class[]{Thread.class};
            Method m = Runtime.class.getDeclaredMethod("removeShutdownHook", c);
            if (m != null) {
                try {
                    m.invoke((Object)register, hook);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static boolean isShutdownHookAdded() {
        return shutdownHookAdded;
    }

    public static synchronized void addShutdownHook() {
        if (shutdownHookAdded) {
            return;
        }
        shutdownHookAdded = true;
        Shutdown.addShutdownHook(new Thread(){

            @Override
            public void run() {
                ThreadQueue.initiateShutdown();
                Shutdown.performShutdownProcedures();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.out != null) {
                    System.out.flush();
                }
                if (System.err != null) {
                    System.err.flush();
                }
            }
        });
    }
}

