/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.util.IntervalMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class SmartMemory
extends Memory {
    private IntervalMap<Variable, Variable> intervals = new IntervalMap(new IntervalStartComparator(), new IntervalMaxComparator(), new IntervalComparator(), new IntervalExtentComparator());

    public SmartMemory() {
    }

    public SmartMemory(int setAvailableMemory) {
        super(setAvailableMemory, new String[0]);
    }

    public SmartMemory(int setAvailableMemory, String dataSectionName) {
        super(setAvailableMemory, dataSectionName);
    }

    public SmartMemory(byte[] data) {
        super(data);
    }

    public SmartMemory(boolean decimalIsComma) {
        super(decimalIsComma);
    }

    public SmartMemory(int setAvailableMemory, boolean decimalIsComma) {
        super(setAvailableMemory, decimalIsComma);
    }

    public SmartMemory(int setAvailableMemory, String programName, boolean decimalIsComma) {
        super(setAvailableMemory, programName, decimalIsComma);
    }

    public SmartMemory(byte[] data, boolean decimalIsComma) {
        super(data, decimalIsComma);
    }

    @Override
    public final void addNotify(Variable v) {
        if (v.getName() == null) {
            return;
        }
        Variable head = this.intervals.get(v);
        if (head != null) {
            ArrayList<Variable> dups = head.commonAddr;
            if (v.itemSize * v.maxIndex > head.itemSize * head.maxIndex) {
                Variable newHead = v;
                head.commonAddr = null;
                newHead.commonAddr = dups;
                this.intervals.remove(head);
                this.intervals.put(newHead, newHead);
                v = head;
                head = newHead;
            }
            if (dups == null) {
                head.commonAddr = new ArrayList();
                head.commonAddr.add(v);
            } else {
                int insert = 0;
                boolean inserted = false;
                for (Variable oneDup : dups) {
                    if (v.itemSize * v.maxIndex > oneDup.itemSize * oneDup.maxIndex) {
                        dups.add(insert, v);
                        inserted = true;
                        break;
                    }
                    ++insert;
                }
                if (!inserted) {
                    dups.add(v);
                }
            }
        } else {
            this.intervals.put(v, v);
        }
    }

    @Override
    public final void removeNotify(Variable v) {
        block2: {
            Variable search;
            block3: {
                search = this.intervals.get(v);
                if (search == null) break block2;
                if (search != v) break block3;
                this.intervals.remove(search);
                if (search.commonAddr == null || search.commonAddr.size() <= 0) break block2;
                Variable switcheroo = search.commonAddr.get(0);
                search.commonAddr.remove(0);
                switcheroo.commonAddr = search.commonAddr;
                search.commonAddr = null;
                this.intervals.put(switcheroo, switcheroo);
                break block2;
            }
            if (search.commonAddr != null) {
                Iterator<Variable> iter = search.commonAddr.iterator();
                while (iter.hasNext()) {
                    Variable other = iter.next();
                    if (other != v) continue;
                    iter.remove();
                    break;
                }
            }
        }
    }

    @Override
    public final void addNotifyChildren(Variable v) {
    }

    public final void setMemory(Variable v) {
        if (v.pointerMemory != null && v.pointerMemory instanceof SmartMemory) {
            this.removeNotify(v);
        }
        v.pointerMemory = this;
        this.addNotify(v);
    }

    private static boolean overlaps(Variable v1, Variable v2) {
        return v1.pointerAddress >= v2.pointerAddress && v1.pointerAddress < v2.pointerAddress + v2.itemSize * v2.maxIndex || v2.pointerAddress >= v1.pointerAddress && v2.pointerAddress < v1.pointerAddress + v1.itemSize * v2.maxIndex;
    }

    @Override
    public final void flushToMemory(Variable v, boolean andInvalidate) {
        for (Variable other : this.intervals.overlapMap(v).navigableKeySet()) {
            if (v != other) {
                if (other.dirty) {
                    other.flushDirtyToMemory();
                }
                if (andInvalidate) {
                    other.valid = false;
                }
            }
            if (other.commonAddr == null) continue;
            for (Variable other2 : other.commonAddr) {
                if (v == other2 || !SmartMemory.overlaps(other2, v)) continue;
                if (other2.dirty) {
                    other2.flushDirtyToMemory();
                }
                if (!andInvalidate) continue;
                other2.valid = false;
            }
        }
    }

    @Override
    public final void invalidateCache(Variable v) {
        for (Variable other : this.intervals.overlapMap(v).navigableKeySet()) {
            other.invalidateCache();
            if (other.commonAddr == null) continue;
            for (Variable other2 : other.commonAddr) {
                other2.invalidateCache();
            }
        }
    }

    public final void dump(int from, int to) {
        boolean damaged = false;
        int lastStart = 0;
        System.out.println("+++ dump(" + from + ", " + to + ")");
        Variable start = new Variable();
        start.pointerAddress = from;
        Variable finish = new Variable();
        finish.pointerAddress = to;
        for (Variable other : this.intervals.overlapMap(start).navigableKeySet()) {
            System.out.println("+++    head=" + other.getName() + ", start=" + other.pointerAddress + ", end=" + (other.pointerAddress + other.itemSize * other.maxIndex));
            if (other.pointerAddress < lastStart) {
                damaged = true;
            }
            if (other.commonAddr == null) continue;
            for (Variable other2 : other.commonAddr) {
                System.out.println("+++    dup=" + other2.getName() + ", start=" + other2.pointerAddress + ", end=" + (other2.pointerAddress + other2.itemSize * other2.maxIndex));
                if (other2.pointerAddress == other.pointerAddress) continue;
                damaged = true;
            }
        }
        if (damaged) {
            System.out.println("+++ *** DAMAGED ***");
        }
    }

    private class IntervalExtentComparator
    implements Comparator<Variable> {
        private IntervalExtentComparator() {
        }

        @Override
        public int compare(Variable arg1, Variable arg2) {
            if (arg1.pointerAddress > arg2.pointerAddress + arg2.itemSize) {
                return 1;
            }
            if (arg1.pointerAddress < arg2.pointerAddress + arg2.itemSize) {
                return -1;
            }
            return 0;
        }
    }

    private class IntervalComparator
    implements Comparator<Variable> {
        private IntervalComparator() {
        }

        @Override
        public int compare(Variable arg1, Variable arg2) {
            if (arg1.pointerAddress >= arg2.pointerAddress && arg1.pointerAddress < arg2.pointerAddress + arg2.itemSize || arg2.pointerAddress >= arg1.pointerAddress && arg2.pointerAddress < arg1.pointerAddress + arg1.itemSize) {
                return 0;
            }
            if (arg1.pointerAddress < arg2.pointerAddress) {
                return -1;
            }
            return 1;
        }
    }

    private class IntervalMaxComparator
    implements Comparator<Variable> {
        private IntervalMaxComparator() {
        }

        @Override
        public int compare(Variable arg0, Variable arg1) {
            int max0 = arg0.pointerAddress + arg0.itemSize;
            int max1 = arg1.pointerAddress + arg1.itemSize;
            if (max0 > max1) {
                return 1;
            }
            if (max0 < max1) {
                return -1;
            }
            if (arg0.pointerAddress < arg1.pointerAddress) {
                return 1;
            }
            if (arg0.pointerAddress > arg1.pointerAddress) {
                return -1;
            }
            return 0;
        }
    }

    private class IntervalStartComparator
    implements Comparator<Variable> {
        private IntervalStartComparator() {
        }

        @Override
        public int compare(Variable arg0, Variable arg1) {
            if (arg0.pointerAddress > arg1.pointerAddress) {
                return 1;
            }
            if (arg0.pointerAddress < arg1.pointerAddress) {
                return -1;
            }
            return 0;
        }
    }
}

