/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class SqlConnectionFactory {
    public static final int IMMEDIATE = 0;
    public static final int PROGRAM = 1;
    public static final int UOW = 2;
    public static final int TASK = 3;
    public static final int SESSION = 4;
    public static final int GLOBAL = 5;
    public static final String DEFAULT_NAME = null;
    public static final String PROPERTY_SEP = "**";

    public static Connection create() throws SQLException {
        return SqlConnectionFactory.create(null, null, null, null, null);
    }

    public static Connection create(Object url2) throws SQLException {
        return SqlConnectionFactory.create(url2, null, null, null, null);
    }

    public static Connection create(Object url2, String driverName) throws SQLException {
        return SqlConnectionFactory.create(url2, driverName, null, null, null);
    }

    public static Connection create(Object url2, String driverName, Object username) throws SQLException {
        return SqlConnectionFactory.create(url2, driverName, username, null, null);
    }

    public static Connection create(Object url2, String driverName, Object username, Object password) throws SQLException {
        return SqlConnectionFactory.create(url2, driverName, username, password, null);
    }

    public static Connection create(Object passUrl, String driverName, Object passUsername, Object passPassword, Context namingContext) throws SQLException {
        String password;
        if (passUrl instanceof Connection) {
            return (Connection)passUrl;
        }
        String url2 = passUrl != null ? String.valueOf(passUrl) : null;
        String username = passUsername != null ? String.valueOf(passUsername) : null;
        String string2 = password = passPassword != null ? String.valueOf(passPassword) : null;
        if (url2 != null && url2.equals("null")) {
            url2 = null;
        }
        if (username != null && username.equals("null")) {
            username = null;
        }
        if (password != null && password.equals("null")) {
            password = null;
        }
        if (url2 != null) {
            url2 = url2.trim();
        }
        if (driverName != null) {
            driverName = driverName.trim();
        }
        if (username != null) {
            username = username.trim();
        }
        if (password != null) {
            password = password.trim();
        }
        if (url2 == null) {
            url2 = RuntimeEnvironment.getGlobalParameter("sql.default.connection");
        }
        Connection con = null;
        if (url2 != null) {
            if (url2.startsWith("ds:") || url2.startsWith("jndi:")) {
                try {
                    con = SqlConnectionFactory.connectDataSource(url2, driverName, username, password, namingContext);
                    if (con != null) {
                        return con;
                    }
                }
                catch (NoClassDefFoundError e) {
                    LogSetup.LOGGER.warning("Caught java.lang.NoClassDefFoundError for url that starts with 'ds:' or 'jndi:'. Caught exception while trying to find Data Source. \nurl=" + url2 + "driverName=" + driverName + ". username=" + username + ".");
                }
            } else if (!url2.startsWith("jdbc:")) {
                try {
                    con = SqlConnectionFactory.connectDataSource(url2, driverName, username, password, namingContext);
                    if (con != null) {
                        return con;
                    }
                }
                catch (NoClassDefFoundError e) {
                    LogSetup.LOGGER.warning("Caught java.lang.NoClassDefFoundError for unknown url. Caught exception while trying to find Data Source. \nurl=" + url2 + "driverName=" + driverName + ". username=" + username + ".");
                }
            }
        }
        if (con == null) {
            con = SqlConnectionFactory.connectDriverManager(url2, driverName, username, password);
        }
        if (con != null) {
            SqlConnectionFactory.setDefaultConnectionParameters(con);
            return con;
        }
        return null;
    }

    private static Connection connectDriverManager(String url2, String driverName, String username, String password) throws SQLException {
        int index;
        Connection con = null;
        if (url2 != null && !url2.toLowerCase().startsWith("jdbc:")) {
            url2 = "jdbc:" + url2;
        }
        SqlConnectionFactory.loadDriverName(driverName);
        if (url2 != null && (index = url2.indexOf(PROPERTY_SEP)) >= 0) {
            Properties p = SqlConnectionFactory.buildProperties(url2);
            try {
                url2 = url2.substring(0, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (username != null && p.get("user") == null) {
                    p.put("user", username);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (password != null && p.get("password") == null) {
                    p.put("password", password);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            url2 = url2.substring(0, index);
            con = DriverManager.getConnection(url2, p);
        }
        if (con == null) {
            if (url2 == null) {
                throw new SQLException("Elastic COBOL SQL: 99000.C1: DB not connected. CONNECT or SET CONNECTION not issued prior to SQL statement. No DEFAULT connection attributes are available.", "99000");
            }
            con = DriverManager.getConnection(url2, username, password);
        }
        return con;
    }

    private static String loadDriverName(String driverName) {
        if (driverName == null) {
            return null;
        }
        try {
            Class.forName(driverName).newInstance();
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static final Connection connectDataSource(String url2, String driverName, String username, String password, Context namingContext) throws SQLException {
        Connection con = null;
        if (url2 == null) {
            return null;
        }
        if (url2.startsWith("ds:")) {
            url2 = url2.substring(3).trim();
        } else if (url2.startsWith("jndi:")) {
            url2 = url2.substring(5).trim();
        }
        if (url2.length() == 0) {
            return null;
        }
        try {
            Context ctx = namingContext == null ? new InitialContext() : namingContext;
            DataSource ds = (DataSource)ctx.lookup(url2);
            con = username == null && password == null ? ds.getConnection() : ds.getConnection(username, password);
            if (namingContext == null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            LogSetup.LOGGER.severe("JNDI lookup of url failed with javax.naming.NamingException. This means that the Data Source does not exists or cannot be found. Perhaps JNDI naming service must be setup with Data Source entry.\nurl=" + url2 + ". driverName=" + driverName + ". username=" + username + ".");
        }
        return con;
    }

    private static Properties buildProperties(String url2) {
        Properties p = new Properties();
        int index = -1;
        while (url2 != null && (index = url2.indexOf(PROPERTY_SEP)) >= 0) {
            try {
                url2 = url2.substring(index + PROPERTY_SEP.length());
                String prop = null;
                try {
                    index = url2.indexOf(PROPERTY_SEP, index);
                    if (index >= 0) {
                        prop = url2.substring(0, index);
                        url2 = url2.substring(index + PROPERTY_SEP.length());
                    } else {
                        prop = url2;
                        url2 = null;
                    }
                }
                catch (Exception t) {
                    break;
                }
                try {
                    if (prop != null && (index = prop.indexOf(61)) >= 0) {
                        String name = prop.substring(0, index);
                        String value = prop.substring(index + 1);
                        p.put(name, value);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception t2) {
                break;
            }
            if (index >= 0) continue;
        }
        return p;
    }

    private static void setDefaultConnectionParameters(Connection con) {
        char c;
        String value2;
        try {
            value2 = RuntimeEnvironment.getGlobalParameter("sql.autocommit");
            if (value2 != null) {
                if ((value2 = value2.trim()).length() > 0) {
                    c = value2.charAt(0);
                    switch (c) {
                        case '1': 
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            con.setAutoCommit(true);
                            break;
                        }
                        default: {
                            con.setAutoCommit(false);
                            break;
                        }
                        case 'V': 
                        case 'v': {
                            System.out.println("SQL Autocommit status: " + con.getAutoCommit());
                        }
                        case 'D': 
                        case 'd': 
                    }
                }
            } else {
                con.setAutoCommit(false);
            }
        }
        catch (Exception value2) {
            // empty catch block
        }
        try {
            value2 = RuntimeEnvironment.getGlobalParameter("sql.isolation");
            if (value2 != null && (value2 = value2.trim()).length() > 0) {
                c = value2.charAt(0);
                switch (c) {
                    case 'V': 
                    case 'v': {
                        System.out.println("SQL Transaction Isolation status: " + con.getTransactionIsolation());
                        break;
                    }
                    default: {
                        con.setTransactionIsolation(Integer.parseInt(value2));
                    }
                }
            }
        }
        catch (Exception value3) {
            // empty catch block
        }
        try {
            value2 = RuntimeEnvironment.getGlobalParameter("sql.catalog");
            if (value2 != null && (value2 = value2.trim()).length() > 0) {
                con.setCatalog(value2);
            }
        }
        catch (Exception value4) {
            // empty catch block
        }
        try {
            value2 = RuntimeEnvironment.getGlobalParameter("SQL-READ-ONLY");
            if (value2 != null && (value2 = value2.trim()).length() > 0) {
                c = value2.charAt(0);
                switch (c) {
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        con.setReadOnly(true);
                        break;
                    }
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        con.setReadOnly(false);
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        System.out.println("SQL Read Only status: " + con.isReadOnly());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disconnect(Connection con) throws SQLException {
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("Hello. ");
        }
        if (con != null && !con.isClosed()) {
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.fine("Close SQL connection. ");
            }
            con.close();
        }
    }

    private SqlConnectionFactory() {
    }
}

