/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.SqlConstants;
import com.heirloomcomputing.ecs.exec.SqlContext;
import com.heirloomcomputing.ecs.exec.SqlCursors;
import com.heirloomcomputing.ecs.exec.SqlDataArea;
import com.heirloomcomputing.ecs.exec.Variable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class SqlCursor {
    public static final int ORACLE_UNSUPPORTED_FEATURE = 17023;
    public static final String DEFAULT_CURSOR_NAME = "default";
    private static Boolean flagAlwaysUseEmptyStringAsLowValues = null;
    public static final int MODE_ANSI = 0;
    public static final int MODE_ORACLE = 1;
    private String name;
    private String psName = null;
    private final Vector<CursorParameter> parameterGenerator = new Vector();
    private boolean valid = true;
    private boolean withHold;
    private SQLWarning sqlWarning;
    private ResultSet rs;
    private PreparedStatement ps = null;
    private boolean opened;
    private boolean logMode;
    private Variable sqlda;
    private int prefetchSize = -1;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private Boolean isDB2;
    private Boolean isSQLServer = null;
    private SqlCursors parent;
    private int openSequence;
    private boolean emulateUpdateStatement = false;
    private Boolean emulateNamedCursors = null;

    public SqlCursor(String name) {
        this(name, false, null);
    }

    public SqlCursor(String name, boolean withHold, SqlCursors parent) {
        this.withHold = withHold;
        this.parent = parent;
        this.name = name != null && name.equals(DEFAULT_CURSOR_NAME) ? null : name;
    }

    public void setPrefetchSize(int value) {
        this.prefetchSize = value;
    }

    public void setFetchSize(int value) {
        this.fetchSize = value;
    }

    public void setMaxRows(int value) {
        this.maxRows = value;
    }

    public void setQueryTimeout(int value) {
        this.queryTimeout = value;
    }

    private static void alwaysUseEmptyStringAsLowValues(Connection con) {
        block5: {
            if (con != null) {
                try {
                    DatabaseMetaData md = con.getMetaData();
                    if (md.getDriverName().toLowerCase().startsWith("postgres")) {
                        flagAlwaysUseEmptyStringAsLowValues = true;
                        break block5;
                    }
                    flagAlwaysUseEmptyStringAsLowValues = RuntimeEnvironment.isGlobalParameter("SQL_USE_EMPTY_STRING_AS_NULL_VALUE", false);
                }
                catch (SQLException e) {
                    flagAlwaysUseEmptyStringAsLowValues = true;
                }
            } else {
                flagAlwaysUseEmptyStringAsLowValues = RuntimeEnvironment.isGlobalParameter("SQL_USE_EMPTY_STRING_AS_NULL_VALUE", false);
            }
        }
    }

    public void setLogMode(boolean state) {
        this.logMode = state;
    }

    public final void log(String s) {
        if (this.logMode) {
            SqlContext.log("CURSOR[" + this.name + "]: " + s);
        }
    }

    public final void log(Throwable t) {
        if (this.logMode) {
            SqlContext.log(t);
        }
    }

    public SQLWarning getSQLWarning() {
        SQLWarning backup = this.sqlWarning;
        this.sqlWarning = null;
        return backup;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public void setValid(boolean state) {
        this.valid = state;
    }

    public void setWithHold(boolean hold) {
        this.withHold = hold;
    }

    public final void resetParameters() {
        this.parameterGenerator.setSize(0);
    }

    public final SqlCursor reset(boolean withHold) {
        block3: {
            if (this.logMode) {
                this.log("Reset (Hold=" + withHold + ")");
            }
            this.resetParameters();
            try {
                this.deallocate();
            }
            catch (SQLException e) {
                if (!this.logMode) break block3;
                this.log("During reset of cursor, ignorable exception: " + e);
            }
        }
        this.valid = true;
        this.withHold = withHold;
        return this;
    }

    public final SqlCursor reset() {
        return this.reset(this.withHold);
    }

    public final boolean isHold() {
        return this.withHold;
    }

    public final SqlCursor setObject(Object parameter) {
        this.parameterGenerator.addElement(new CursorParameter(parameter, this));
        return this;
    }

    public final SqlCursor setObject(Object parameter, Object nullIndicator) {
        IDatatype indicator = null;
        try {
            indicator = (IDatatype)nullIndicator;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.parameterGenerator.addElement(new CursorParameter(parameter, indicator, this));
        return this;
    }

    public final SqlCursor setObject(Object parameter, Object nullIndicator, int oracleType) {
        IDatatype indicator = null;
        try {
            indicator = (IDatatype)nullIndicator;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (oracleType == 262) {
            Variable parm;
            Variable child;
            if (parameter instanceof Variable && (child = (parm = (Variable)parameter).getChild()) != null && (child = child.getSibling()) != null) {
                Variable data = child;
                this.parameterGenerator.addElement(new CursorParameter(data, indicator, oracleType, this));
            }
        } else {
            this.parameterGenerator.addElement(new CursorParameter(parameter, indicator, oracleType, this));
        }
        return this;
    }

    public final SqlCursor setObject(Object parameter, Object nullIndicator, int oracleType, String dateFormat) {
        IDatatype indicator = null;
        try {
            indicator = (IDatatype)nullIndicator;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.parameterGenerator.addElement(new CursorParameter(parameter, indicator, oracleType, dateFormat, this));
        return this;
    }

    private void setObjectCommon(int slot, Object value) throws SQLException {
        if (value == null) {
            this.getPreparedStatement().setString(slot, null);
        } else if (this.isDB2.booleanValue() && value instanceof byte[]) {
            this.getPreparedStatement().setBytes(slot, (byte[])value);
        } else {
            this.getPreparedStatement().setObject(slot, value);
        }
    }

    public final SqlCursor setObject(int slot, Object parameter) throws SQLException {
        Object value = new CursorParameter(parameter, this).getObject();
        this.setObjectCommon(slot, value);
        return this;
    }

    public final SqlCursor setObject(int slot, Object parameter, Object nullIndicator) throws SQLException {
        IDatatype indicator = null;
        try {
            indicator = (IDatatype)nullIndicator;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Object value = new CursorParameter(parameter, indicator, this).getObject();
        this.setObjectCommon(slot, value);
        return this;
    }

    public final SqlCursor setObject(int slot, Object parameter, Object nullIndicator, int oracleType) throws SQLException {
        IDatatype indicator = null;
        try {
            indicator = (IDatatype)nullIndicator;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Object value = new CursorParameter(parameter, indicator, oracleType, this).getObject();
        this.setObjectCommon(slot, value);
        return this;
    }

    public final SqlCursor setObject(int slot, Object parameter, Object nullIndicator, int oracleType, String dateFormat) throws SQLException {
        IDatatype indicator = null;
        try {
            indicator = (IDatatype)nullIndicator;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Object value = new CursorParameter(parameter, indicator, oracleType, dateFormat, this).getObject();
        this.setObjectCommon(slot, value);
        return this;
    }

    private void setSpecific(int slot, Object value, int sqlTypeIs) throws SQLException {
        if (value instanceof Integer) {
            this.getPreparedStatement().setInt(slot, (Integer)value);
        }
        if (value == null || value instanceof String || value instanceof char[] || sqlTypeIs == -1 || sqlTypeIs == 96 || sqlTypeIs == 97) {
            String valueStr = null;
            if (value != null) {
                valueStr = value instanceof String ? (String)value : (value instanceof byte[] ? new String((byte[])value) : (value instanceof char[] ? new String((char[])value) : value.toString()));
            }
            this.getPreparedStatement().setString(slot, valueStr);
        } else if (value instanceof byte[] && sqlTypeIs == 263) {
            byte[] valueByt = null;
            if (value != null) {
                if (value instanceof String) {
                    valueByt = ((String)value).getBytes();
                } else if (value instanceof byte[]) {
                    valueByt = (byte[])value;
                }
            }
            this.getPreparedStatement().setBytes(slot, valueByt);
        } else if (value instanceof Integer || value instanceof Short || sqlTypeIs == 3) {
            Integer valueInt = null;
            if (value instanceof Integer) {
                valueInt = (Integer)value;
            } else if (value instanceof Integer) {
                valueInt = (Integer)value;
            } else if (value instanceof Short) {
                valueInt = ((Short)value).intValue();
            } else if (value instanceof String) {
                try {
                    valueInt = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.getPreparedStatement().setInt(slot, valueInt);
        } else if (value instanceof Long || sqlTypeIs == 8) {
            Long valueLng = null;
            if (value instanceof Long) {
                valueLng = (Long)value;
            } else if (value instanceof String) {
                try {
                    valueLng = Long.parseLong((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.getPreparedStatement().setLong(slot, valueLng);
        } else if (value instanceof Float || value instanceof Double || sqlTypeIs == 4) {
            Float valueFlt = null;
            if (value instanceof Float) {
                valueFlt = (Float)value;
            } else if (value instanceof Double) {
                valueFlt = Float.valueOf(((Double)value).floatValue());
            } else if (value instanceof String) {
                try {
                    valueFlt = Float.valueOf(Float.parseFloat((String)value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.getPreparedStatement().setFloat(slot, valueFlt.floatValue());
        } else {
            this.setObjectCommon(slot, value);
        }
    }

    public final SqlCursor generate() throws SQLException {
        block9: {
            if (this.isSQLServer == null) {
                Connection con = this.getPreparedStatement().getConnection();
                if (con != null) {
                    try {
                        DatabaseMetaData md = con.getMetaData();
                        if (md.getDriverName().toLowerCase().contains("microsoft")) {
                            this.isSQLServer = true;
                            break block9;
                        }
                        this.isSQLServer = false;
                    }
                    catch (SQLException e) {
                        this.isSQLServer = false;
                    }
                } else {
                    this.isSQLServer = false;
                }
            }
        }
        int parameterGeneratorSize = this.parameterGenerator.size();
        CursorParameter cursorParameter = null;
        Object value = null;
        for (int i = 0; i < parameterGeneratorSize; ++i) {
            cursorParameter = this.parameterGenerator.elementAt(i);
            value = cursorParameter.getObject();
            if (this.logMode) {
                this.log("Param " + (i + 1) + " set to {" + value + "}");
            }
            if (this.isDB2.booleanValue() || this.isSQLServer.booleanValue()) {
                this.setSpecific(i + 1, value, cursorParameter.getSqlTypeIs());
                continue;
            }
            this.setObjectCommon(i + 1, value);
        }
        return this;
    }

    public final void setPSName(String psName) {
        this.psName = psName;
    }

    public final boolean ofPSName(String psName) {
        if (psName == null) {
            return false;
        }
        return this.psName.equals(psName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean open() throws SQLException {
        if (this.logMode) {
            this.log("Open");
        }
        int count = 0;
        this.valid = true;
        this.sqlWarning = null;
        PreparedStatement ps = this.getPreparedStatement();
        if (ps == null) {
            throw new SQLException("Elastic COBOL SQL: 34000.R12: Cursor has no declared PreparedStatement", "34000");
        }
        SqlCursor sqlCursor = this;
        synchronized (sqlCursor) {
            block31: {
                boolean isResultSet;
                block30: {
                    block29: {
                        block28: {
                            if (flagAlwaysUseEmptyStringAsLowValues == null) {
                                SqlCursor.alwaysUseEmptyStringAsLowValues(ps.getConnection());
                            }
                            this.generate();
                            if (this.opened && this.name != null) {
                                if (this.logMode) {
                                    this.log("Cannot open already opened, named cursor");
                                }
                                return false;
                            }
                            if (this.isHold()) {
                                this.openSequence = this.parent.assignNextOpenSequence();
                            }
                            isResultSet = false;
                            if (this.prefetchSize >= 0) {
                                try {
                                    ps.setFetchSize(this.prefetchSize);
                                }
                                catch (Throwable t) {
                                    if (!this.logMode) break block28;
                                    this.log(t);
                                }
                            }
                        }
                        if (this.maxRows >= 0) {
                            try {
                                ps.setMaxRows(this.maxRows);
                            }
                            catch (Throwable t) {
                                if (!this.logMode) break block29;
                                this.log(t);
                            }
                        }
                    }
                    if (this.queryTimeout >= 0) {
                        try {
                            ps.setQueryTimeout(this.queryTimeout);
                        }
                        catch (Throwable t) {
                            if (!this.logMode) break block30;
                            this.log(t);
                        }
                    }
                }
                isResultSet = ps.execute();
                this.sqlWarning = ps.getWarnings();
                if (!isResultSet && (count = ps.getUpdateCount()) < 0) {
                    if (this.logMode) {
                        this.log("No data, no update count");
                    }
                    this.opened = false;
                    this.rs = null;
                    throw new SQLException("Elastic COBOL SQL: 24000.R11: Cursor has neither data nor update count", "24000");
                }
                while (!isResultSet) {
                    isResultSet = ps.getMoreResults();
                    if (isResultSet) continue;
                    count = ps.getUpdateCount();
                    if (count < 0) break;
                    if (!this.logMode) continue;
                    this.log("Count: " + count);
                }
                if (isResultSet) {
                    this.rs = ps.getResultSet();
                    if (this.sqlWarning == null) {
                        this.sqlWarning = this.rs.getWarnings();
                    }
                } else {
                    this.rs = null;
                }
                if (this.fetchSize >= 0 && this.rs != null) {
                    try {
                        this.rs.setFetchSize(this.fetchSize);
                    }
                    catch (Throwable t) {
                        if (!this.logMode) break block31;
                        this.log(t);
                    }
                }
            }
            this.opened = true;
        }
        if (this.logMode) {
            this.log("Open is successful.");
        }
        return this.opened;
    }

    public final boolean isOpen() {
        return this.opened;
    }

    public final boolean isPrepared() {
        return this.getPreparedStatement() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean close() throws SQLException {
        if (this.logMode) {
            this.log("Close");
        }
        this.valid = false;
        SqlCursor sqlCursor = this;
        synchronized (sqlCursor) {
            if (!this.opened) {
                if (this.logMode) {
                    this.log("Cannot close unopened cursor");
                }
                return false;
            }
            this.opened = false;
            if (this.rs != null) {
                try {
                    if (this.logMode) {
                        this.log("Closing ResultSet");
                    }
                    this.rs.close();
                }
                finally {
                    this.rs = null;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean deallocate() throws SQLException {
        if (this.logMode) {
            this.log("Deallocate");
        }
        this.valid = false;
        SqlCursor sqlCursor = this;
        synchronized (sqlCursor) {
            this.opened = false;
            if (this.rs != null) {
                try {
                    if (this.logMode) {
                        this.log("Closing ResultSet");
                    }
                    this.rs.close();
                }
                finally {
                    this.rs = null;
                }
            }
            this.closePs();
        }
        return true;
    }

    public final void declare(PreparedStatement ps1) throws SQLException {
        if (this.logMode) {
            this.log("Declare statement " + this.getPreparedStatement());
        }
        this.updatePs(ps1);
        if (this.getPreparedStatement() != null) {
            try {
                if (this.name != null && !this.emulateNamedCursors()) {
                    this.getPreparedStatement().setCursorName(this.name);
                }
                this.determineHighValuesAsBytes(this.getPreparedStatement().getConnection());
            }
            catch (SQLException e) {
                if (this.logMode) {
                    this.log("Error setting cursor name.  Database or JDBC driver may not support setting cursor name");
                }
                if (e.getErrorCode() == 17023) {
                    if (this.logMode) {
                        this.log("Oracle or compatible JDBC driver does not support this feature, will not attempt to use named cursors again");
                    }
                    this.emulateUpdateStatement = true;
                    this.emulateNamedCursors = true;
                    this.isDB2 = false;
                }
                throw e;
            }
        }
    }

    public final void describe(Variable sqldaParm) throws SQLException {
        if (this.getPreparedStatement() == null || sqldaParm == null) {
            return;
        }
        this.setSqlda(sqldaParm);
        this.describe();
    }

    private final void describe() throws SQLException {
        ResultSetMetaData rsmd = this.getPreparedStatement().getMetaData();
        try {
            SqlDataArea sda = new SqlDataArea(this.sqlda);
            sda.populateFromRsmd(rsmd);
            sda.populateIntoSqlda(this.sqlda);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Elastic COBOL SQL: 07000.R2" + e.getMessage(), "07000", e);
        }
    }

    public final void describeFromResultSet(Variable sqlda, ResultSet rs) throws SQLException {
        try {
            SqlDataArea sda = new SqlDataArea(sqlda);
            sda.populateFromRs(rs);
            sda.populateIntoSqlda(sqlda);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Elastic COBOL SQL: 07000.R3" + e.getMessage(), "07000", e);
        }
    }

    public final ResultSet getResultSet() throws SQLException {
        if (!this.valid) {
            if (this.logMode) {
                this.log("Invalid cursor, no result set, already fetched to end (24000)");
            }
            throw new SQLException("Elastic COBOL SQL: 24000.R10: Invalid cursors have no result-sets", "24000");
        }
        if (this.opened) {
            if (this.logMode) {
                this.log("Result set: " + this.rs);
            }
            return this.rs;
        }
        if (this.logMode) {
            this.log("Unopened, no result set (24000)");
        }
        throw new SQLException("Elastic COBOL SQL: 24000.R1: Unopened cursors have no result-sets", "24000");
    }

    public void setResultSet(ResultSet rs) throws SQLException {
        this.rs = rs;
        this.opened = !rs.isClosed();
        this.valid = this.opened;
    }

    public final PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    public Variable getSqlda() {
        return this.sqlda;
    }

    public void setSqlda(Variable sqlda) {
        this.sqlda = sqlda;
    }

    public final int updateWhereCurrent(String updateString, Object[] params, Object[] indics) throws SQLException {
        if (indics != null) {
            int length = indics.length;
            if (params != null) {
                if (length > params.length) {
                    length = params.length;
                }
                for (int i = 0; i < length; ++i) {
                    int indicator;
                    if (!(indics[i] instanceof IDatatype) || (indicator = ((IDatatype)indics[i]).toInt()) >= 0) continue;
                    params[i] = null;
                }
            }
        }
        return this.updateWhereCurrent(updateString, params);
    }

    public final int updateWhereCurrent(String updateString, Object[] params) throws SQLException {
        if (params == null || params.length == 0 || updateString == null) {
            return this.updateWhereCurrent(updateString);
        }
        int param = 0;
        int index = -1;
        String left = null;
        String right = null;
        while ((index = updateString.indexOf(63)) >= 0) {
            try {
                left = updateString.substring(0, index);
            }
            catch (Exception e) {
                left = "";
            }
            try {
                right = updateString.substring(index + 1);
            }
            catch (Exception e) {
                right = "";
            }
            String value = null;
            if (param >= params.length) break;
            if (params[param] == null) {
                value = "NULL";
            } else if (params[param] instanceof IDatatype) {
                char sign;
                IDatatype data = (IDatatype)params[param];
                String text = data.toText();
                value = (data.getType() & 0x10) == 16 ? ((sign = text.charAt(text.length() - 1)) == '+' ? text.substring(0, text.length() - 1) : (sign == '-' ? "-" + text.substring(0, text.length() - 1) : text)) : "'" + text + "'";
            } else {
                value = "'" + params[param].toString() + "'";
            }
            ++param;
            updateString = left + value + right;
            if (index >= 0) continue;
        }
        return this.updateWhereCurrent(updateString);
    }

    public final int updateWhereCurrent(String updateString) throws SQLException {
        if (this.emulateUpdateStatement) {
            if (this.logMode) {
                this.log("Update where current using limited emulation: " + updateString);
            }
            this.rs.moveToCurrentRow();
            int setIndex = updateString.indexOf("SET ");
            if (setIndex >= 0) {
                updateString = updateString.substring(setIndex + 4);
                int index = -1;
                String part = null;
                do {
                    if ((index = updateString.indexOf(44)) >= 0) {
                        part = updateString.substring(0, index).trim();
                        updateString = updateString.substring(index + 1).trim();
                    } else {
                        part = updateString;
                    }
                    int equals = part.indexOf(61);
                    if (equals < 0) continue;
                    String column = part.substring(0, equals).trim();
                    String value = part.substring(equals + 1).trim();
                    if (value.equalsIgnoreCase("NULL")) {
                        this.rs.updateNull(column);
                        continue;
                    }
                    if (value.length() >= 2 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'' || value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        boolean isDoubleQuote = value.charAt(0) == '\"';
                        value = value.substring(1, value.length() - 1);
                        value = isDoubleQuote ? value.replaceAll("\"\"", "\"") : value.replaceAll("''", "'");
                        this.rs.updateString(column, value);
                        continue;
                    }
                    int length = value.length();
                    boolean decimalFound = false;
                    boolean signFound = false;
                    boolean exponentFound = false;
                    char c = '\u0000';
                    block10: for (int i = 0; i < length; ++i) {
                        c = value.charAt(i);
                        switch (c) {
                            case '-': {
                                if (signFound || !exponentFound && i != 0 && i != length - 1) {
                                    throw new SQLException("Elastic COBOL 08003: This driver requires Elastic COBOL emulate the UPDATE SET clause.  Expressions and DBMS constants are not allowed ('" + column + "=" + value + "')", "08003");
                                }
                                if (i == length - 1) {
                                    value = value.charAt(length - 1) + value.substring(0, length - 1);
                                }
                                signFound = true;
                                continue block10;
                            }
                            case '+': {
                                if (signFound || i != 0 && i != length - 1) {
                                    throw new SQLException("Elastic COBOL 08003: This driver requires Elastic COBOL emulate the UPDATE SET clause.  Expressions and DBMS constants are not allowed ('" + column + "=" + value + "')", "08003");
                                }
                                if (i == 0) {
                                    value = value.substring(1);
                                } else if (i == length - 1) {
                                    value = value.substring(0, length - 1);
                                }
                                signFound = true;
                                continue block10;
                            }
                            case '.': {
                                if (decimalFound) {
                                    throw new SQLException("Elastic COBOL 08003: This driver requires Elastic COBOL emulate the UPDATE SET clause.  Expressions and DBMS constants are not allowed ('" + column + "=" + value + "')", "08003");
                                }
                                decimalFound = true;
                                continue block10;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                continue block10;
                            }
                            case 'E': 
                            case 'e': {
                                if (exponentFound) {
                                    throw new SQLException("Elastic COBOL 08003: This driver requires Elastic COBOL emulate the UPDATE SET clause.  Expressions and DBMS constants are not allowed ('" + column + "=" + value + "')", "08003");
                                }
                                exponentFound = true;
                                signFound = true;
                                continue block10;
                            }
                            default: {
                                throw new SQLException("Elastic COBOL 08003: This driver requires Elastic COBOL emulate the UPDATE SET clause.  Expressions and DBMS constants are not allowed ('" + column + "=" + value + "')", "08003");
                            }
                        }
                    }
                    this.rs.updateString(column, value);
                } while (index >= 0);
            }
            this.rs.updateRow();
            return 1;
        }
        if (this.logMode) {
            this.log("Update where current: " + updateString);
        }
        this.rs.moveToCurrentRow();
        String cursorName = this.name;
        try {
            cursorName = this.rs.getCursorName();
        }
        catch (SQLException sqlException) {
            cursorName = this.name;
        }
        String command = updateString + " WHERE CURRENT OF " + cursorName;
        if (this.logMode) {
            this.log("Update where current, full command: " + command);
        }
        Connection con = null;
        if (this.getPreparedStatement() != null) {
            con = this.getPreparedStatement().getConnection();
            Statement statement = con.createStatement();
            int count = statement.executeUpdate(command);
            this.sqlWarning = statement.getWarnings();
            statement.close();
            return count;
        }
        throw new SQLException("Elastic COBOL 08003", "08003");
    }

    public void setPs(PreparedStatement ps) {
        this.ps = ps;
    }

    private void updatePs(PreparedStatement ps1) {
        this.closePs();
        this.setPs(ps1);
    }

    private void closePs() {
        try {
            if (this.getPreparedStatement() != null) {
                if (this.logMode) {
                    this.log("Closing PreparedStatement");
                }
                this.getPreparedStatement().close();
            }
        }
        catch (Exception t) {
            if (this.logMode) {
                this.log("Close of PreparedStatement: " + String.valueOf(t));
            }
        }
        finally {
            this.setPs(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRs() throws SQLException {
        SqlCursor sqlCursor = this;
        synchronized (sqlCursor) {
            this.opened = false;
            if (this.rs != null) {
                try {
                    if (this.logMode) {
                        this.log("Closing ResultSet");
                    }
                    this.rs.close();
                }
                finally {
                    this.rs = null;
                }
            }
        }
    }

    private boolean emulateNamedCursors() {
        if (this.emulateNamedCursors == null && this.getPreparedStatement() != null) {
            try {
                String databaseProductName = this.getPreparedStatement().getConnection().getMetaData().getDatabaseProductName();
                this.emulateNamedCursors = databaseProductName.toLowerCase().contains("db2");
            }
            catch (SQLException e) {
                this.emulateNamedCursors = false;
            }
        }
        return this.emulateNamedCursors;
    }

    public Boolean getHighValuesAsBytes() {
        return this.isDB2;
    }

    private void determineHighValuesAsBytes(Connection con) {
        try {
            this.isDB2 = con.getMetaData().getDatabaseProductName().toLowerCase().contains("db2");
        }
        catch (SQLException e) {
            this.isDB2 = false;
        }
    }

    public int getOpenSequence() {
        return this.openSequence;
    }

    static class CursorParameter {
        private final Object parameter;
        private final IDatatype indicator;
        private final int oracleType;
        private final String dateFormat;
        private final SqlCursor cursor;

        public CursorParameter(Object parameter, IDatatype indicator, int oracleType, String dateFormat, SqlCursor cursor) {
            this.parameter = parameter;
            this.indicator = indicator;
            this.oracleType = oracleType;
            this.dateFormat = dateFormat;
            this.cursor = cursor;
        }

        public CursorParameter(Object parameter, IDatatype indicator, int oracleType, SqlCursor cursor) {
            this(parameter, indicator, oracleType, null, cursor);
        }

        public CursorParameter(Object parameter, IDatatype indicator, SqlCursor cursor) {
            this(parameter, indicator, 0, null, cursor);
        }

        public CursorParameter(Object parameter, SqlCursor cursor) {
            this(parameter, null, 0, null, cursor);
        }

        public int getSqlTypeIs() {
            return this.oracleType;
        }

        public Object getObject() {
            if (this.parameter instanceof Variable) {
                Variable param = (Variable)this.parameter;
                if (flagAlwaysUseEmptyStringAsLowValues.booleanValue() && SqlConstants.STOREDASSTRING(this.oracleType) && param.isLowValues()) {
                    return new String("");
                }
                if (this.cursor.getHighValuesAsBytes().booleanValue() && param.isHighValues()) {
                    return param.toString().getBytes();
                }
                if (param instanceof Binary) {
                    return param.getSqlObject(3, this.indicator, this.dateFormat);
                }
                return param.getSqlObject(this.oracleType, this.indicator, this.dateFormat);
            }
            return this.parameter;
        }
    }
}

