/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.AppletExitException;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ThreadQueueMessage;
import com.heirloomcomputing.ecs.jfc.LWindow;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ThreadQueue
extends Thread {
    private static ThreadGroup defaultThreadGroup = null;
    private static final String defaultName = "Thread Queue";
    private static int defaultThreadNumber = 0;
    private static final Vector<ThreadQueue> trackThreads = new Vector();
    private static boolean isTrackingThreads = false;
    private static boolean allThreadsStopped = false;
    private static boolean lockNotUsed = true;
    private boolean locked = false;
    private Object lockObject = new Object();
    private Object lockRecognized = new Object();
    private Handle windowHandle;
    private static long lockLimit = 0L;
    private static boolean shutdownInitiated = false;
    private static boolean appletExit = false;
    private final Vector<ThreadQueueMessage> directedMessages = new Vector();
    private static ThreadQueue defaultThreadQueue = null;
    private ThreadQueue lastThreadQueue = null;
    public static final int THREAD_PRIORITY_RANGE = 9;
    public static final double THREAD_PRIORITY_MULTIPLIER = 2.7466658528397473E-4;
    public static int lockLevel = 0;
    private static final Object lockLevelObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadQueue(ThreadGroup threadGroup, Runnable runnable, String name) {
        super(threadGroup, runnable, name);
        if (isTrackingThreads) {
            Vector<ThreadQueue> vector = trackThreads;
            synchronized (vector) {
                trackThreads.addElement(this);
            }
        }
    }

    public ThreadQueue(Runnable runnable, String name) {
        this(defaultThreadGroup, runnable, name);
    }

    public ThreadQueue(Runnable runnable) {
        this(defaultThreadGroup, runnable, ThreadQueue.defaultName());
    }

    public ThreadQueue(String name) {
        this(defaultThreadGroup, null, name);
    }

    public ThreadQueue() {
        this(defaultThreadGroup, null, ThreadQueue.defaultName());
    }

    public static void setDefaultThreadGroup(ThreadGroup g) {
        defaultThreadGroup = g;
    }

    private static final String defaultName() {
        return "Thread Queue (#" + ++defaultThreadNumber + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAllThreads() {
        Vector<ThreadQueue> vector = trackThreads;
        synchronized (vector) {
            int size = trackThreads.size();
            for (int i = 0; i < size; ++i) {
                ThreadQueue q = trackThreads.elementAt(i);
                if (q != null && q.isAlive()) {
                    try {
                        q.interrupt();
                        q.stop();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                trackThreads.setElementAt(null, i);
            }
        }
        lockNotUsed = false;
        appletExit = false;
        allThreadsStopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void suspendAllThreads() {
        Vector<ThreadQueue> vector = trackThreads;
        synchronized (vector) {
            int size = trackThreads.size();
            for (int i = 0; i < size; ++i) {
                ThreadQueue q = trackThreads.elementAt(i);
                if (q == null || !q.isAlive()) continue;
                try {
                    q.suspend();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeAllThreads() {
        Vector<ThreadQueue> vector = trackThreads;
        synchronized (vector) {
            int size = trackThreads.size();
            for (int i = 0; i < size; ++i) {
                ThreadQueue q = trackThreads.elementAt(i);
                if (q == null || !q.isAlive()) continue;
                try {
                    q.resume();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static ThreadGroup defaultThreadGroup() {
        return defaultThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetThreadGroup() {
        defaultThreadGroup = null;
        isTrackingThreads = false;
        Vector<ThreadQueue> vector = trackThreads;
        synchronized (vector) {
            trackThreads.removeAllElements();
        }
        allThreadsStopped = false;
    }

    public static void trackThreads() {
        isTrackingThreads = true;
    }

    public final void lock() {
        if (lockNotUsed) {
            lockNotUsed = false;
            String temp = RuntimeEnvironment.getGlobalParameter("LOCK-THREAD-TIME-LIMIT");
            if (temp != null) {
                lockLimit = ConvertData.parseInt(temp);
            }
        }
        this.locked = true;
        this.waitOnRecognition();
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public static void initiateShutdown() {
        shutdownInitiated = true;
        lockNotUsed = false;
    }

    public static void initiateAppletExit() {
        lockNotUsed = false;
        appletExit = true;
    }

    public static void resetAppletExit() {
        appletExit = false;
        shutdownInitiated = false;
    }

    public static boolean isAppletShutdown() {
        return appletExit || shutdownInitiated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspendOnLock() {
        if (this.locked) {
            this.recognizeLock();
            Object object = this.lockObject;
            synchronized (object) {
                try {
                    this.lockObject.wait();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.locked = false;
        }
    }

    public static void suspendCurrentOnLock() {
        if (lockNotUsed) {
            return;
        }
        if (appletExit) {
            appletExit = false;
            throw new AppletExitException("Applet Exit: initiated by suspendCurrentOnLock");
        }
        if (allThreadsStopped) {
            throw new AppletExitException("Thread terminated");
        }
        if (Thread.interrupted()) {
            throw new AppletExitException("Thread interrupted");
        }
        if (shutdownInitiated) {
            System.exit(0);
            return;
        }
        try {
            ThreadQueue.currentThreadQueue().suspendOnLock();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock() {
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recognizeLock() {
        try {
            Object object = this.lockRecognized;
            synchronized (object) {
                this.lockRecognized.notifyAll();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitOnRecognition() {
        try {
            Object object = this.lockRecognized;
            synchronized (object) {
                this.lockRecognized.wait(lockLimit);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void controlsWindow(Handle windowHandle) {
        this.windowHandle = windowHandle;
    }

    public static final void die() {
        try {
            ThreadQueue threadQueue = (ThreadQueue)Thread.currentThread();
            if (threadQueue != null) {
                threadQueue.dieing();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void dieing() {
        if (this.windowHandle != null) {
            try {
                LWindow lWindow = (LWindow)this.windowHandle.getComponentNoCreate();
                if (lWindow != null && lWindow.isBindToThread()) {
                    this.windowHandle.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.windowHandle = null;
        }
    }

    public final void send(String object) {
        this.send(new ThreadQueueMessage(object, ThreadQueue.currentThreadQueue()));
    }

    public final void send(String object, ThreadQueue threadQueue) {
        this.send(new ThreadQueueMessage(object, threadQueue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(ThreadQueueMessage threadQueueMessage) {
        try {
            Object object = this.directedMessages;
            synchronized (object) {
                this.directedMessages.addElement(threadQueueMessage);
                this.directedMessages.notifyAll();
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sendBroadcast(String object) {
        try {
            Thread currentThread = Thread.currentThread();
            ThreadGroup threadGroup = currentThread.getThreadGroup();
            int activeCount = threadGroup.activeCount();
            Thread[] threads = new Thread[activeCount];
            activeCount = threadGroup.enumerate(threads);
            ThreadQueue currentThreadQueue = ThreadQueue.currentThreadQueue();
            ThreadQueueMessage message = new ThreadQueueMessage(object, currentThreadQueue);
            for (int i = 0; i < activeCount; ++i) {
                if (threads[i] == currentThread) continue;
                try {
                    ((ThreadQueue)threads[i]).send(message);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ThreadQueueMessage receive(ThreadQueue requiredThreadQueue, long millis) throws InterruptedException {
        ThreadQueueMessage message = null;
        long timeout = millis;
        if (timeout <= 0L) {
            timeout = -1L;
        }
        timeout += System.currentTimeMillis();
        if (millis < 0L) {
            timeout = 0L;
        }
        int previous = 0;
        Vector<ThreadQueueMessage> vector = this.directedMessages;
        synchronized (vector) {
            do {
                if (this.directedMessages.size() == previous) {
                    if (millis > 0L) {
                        this.directedMessages.wait(millis);
                    } else if (millis < 0L) {
                        if (requiredThreadQueue != null) {
                            this.directedMessages.wait(250L);
                        } else {
                            this.directedMessages.wait();
                        }
                    }
                }
                previous = this.directedMessages.size();
                if (this.directedMessages.size() > 0) {
                    if (requiredThreadQueue != null) {
                        int length = this.directedMessages.size();
                        for (int i = 0; i < length; ++i) {
                            message = this.directedMessages.elementAt(i);
                            if (message.getSender() != requiredThreadQueue) continue;
                            this.directedMessages.removeElementAt(i);
                            this.lastThreadQueue = requiredThreadQueue;
                            return message;
                        }
                    }
                    if (requiredThreadQueue == null) {
                        message = this.directedMessages.elementAt(0);
                        this.directedMessages.removeElementAt(0);
                        this.lastThreadQueue = message.getSender();
                        return message;
                    }
                }
                if (requiredThreadQueue != null && !requiredThreadQueue.isAlive()) {
                    throw new InterruptedException("10");
                }
                if (timeout <= 0L || System.currentTimeMillis() <= timeout) continue;
                throw new InterruptedException("99");
            } while (requiredThreadQueue != null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ThreadQueueMessage wait(ThreadQueue requiredThreadQueue, long millis) throws InterruptedException {
        ThreadQueueMessage message = null;
        long timeout = millis;
        if (timeout <= 0L) {
            timeout = -1L;
        }
        timeout += System.currentTimeMillis();
        if (millis < 0L) {
            timeout = 0L;
        }
        ThreadGroup threadGroup = null;
        int activeCount = 0;
        Thread[] threads = null;
        if (requiredThreadQueue == null) {
            threadGroup = Thread.currentThread().getThreadGroup();
            activeCount = threadGroup.activeCount();
            threads = new Thread[activeCount];
            activeCount = threadGroup.enumerate(threads);
        }
        Vector<ThreadQueueMessage> vector = this.directedMessages;
        synchronized (vector) {
            do {
                if (requiredThreadQueue != null) {
                    if (!requiredThreadQueue.isAlive()) {
                        throw new InterruptedException("10");
                    }
                } else {
                    for (int i = 0; i < activeCount; ++i) {
                        if (threads[i].isAlive()) continue;
                        throw new InterruptedException("10");
                    }
                }
                if (millis > 0L) {
                    this.directedMessages.wait(millis);
                } else if (millis < 0L) {
                    this.directedMessages.wait(250L);
                }
                if (this.directedMessages.size() > 0) {
                    if (requiredThreadQueue != null) {
                        int length = this.directedMessages.size();
                        for (int i = 0; i < length; ++i) {
                            message = this.directedMessages.elementAt(i);
                            if (message.getSender() != requiredThreadQueue) continue;
                            this.lastThreadQueue = requiredThreadQueue;
                            return message;
                        }
                    }
                    if (requiredThreadQueue == null) {
                        message = this.directedMessages.elementAt(0);
                        this.lastThreadQueue = message.getSender();
                        return message;
                    }
                }
                if (requiredThreadQueue != null && !requiredThreadQueue.isAlive()) {
                    throw new InterruptedException("10");
                }
                if (timeout <= 0L || System.currentTimeMillis() <= timeout) continue;
                throw new InterruptedException("99");
            } while (requiredThreadQueue != null);
        }
        return null;
    }

    public static ThreadQueue currentThreadQueue() {
        try {
            return (ThreadQueue)Thread.currentThread();
        }
        catch (Throwable throwable) {
            if (defaultThreadQueue == null) {
                defaultThreadQueue = new ThreadQueue();
            }
            return defaultThreadQueue;
        }
    }

    public final ThreadQueue lastThreadQueue() {
        return this.lastThreadQueue;
    }

    public final void setLastThreadQueue(ThreadQueue threadQueue) {
        this.lastThreadQueue = threadQueue;
    }

    public static ThreadQueue getLastThreadQueue() {
        try {
            return ThreadQueue.currentThreadQueue().lastThreadQueue();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ThreadQueue createThreadQueue(Runnable runnable) {
        ThreadQueue lastThreadQueue = new ThreadQueue(runnable);
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue useThreadQueue(ThreadQueue lastThreadQueue) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue useThreadQueue(Handle handleIn, ThreadQueue lastThreadQueue) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            handleIn.set(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue useThreadQueue(ThreadQueue lastThreadQueue, Handle handleIn) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            handleIn.set(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue startThreadQueue(ThreadQueue lastThreadQueue) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            lastThreadQueue.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue startThreadQueue(Handle handleIn, ThreadQueue lastThreadQueue) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            handleIn.set(lastThreadQueue);
            lastThreadQueue.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue startThreadQueue(ThreadQueue lastThreadQueue, Handle handleIn) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            handleIn.set(lastThreadQueue);
            lastThreadQueue.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue startEventQueue(ThreadQueue lastThreadQueue) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            SwingUtilities.invokeLater(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue startEventQueue(Handle handleIn, ThreadQueue lastThreadQueue) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            handleIn.set(lastThreadQueue);
            SwingUtilities.invokeLater(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static ThreadQueue startEventQueue(ThreadQueue lastThreadQueue, Handle handleIn) {
        try {
            ThreadQueue.currentThreadQueue().setLastThreadQueue(lastThreadQueue);
            handleIn.set(lastThreadQueue);
            SwingUtilities.invokeLater(lastThreadQueue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return lastThreadQueue;
    }

    public static int cobolPriorityToJavaPriority(int value) {
        return (int)(2.7466658528397473E-4 * (double)value) + 1;
    }

    public static int javaPriorityToCobolPriority(int value) {
        return (int)((double)(value - 1) / 2.7466658528397473E-4);
    }

    public final int getCobolPriority() {
        try {
            return ThreadQueue.javaPriorityToCobolPriority(Thread.currentThread().getPriority());
        }
        catch (Throwable throwable) {
            return 16384;
        }
    }

    public final void setCobolPriority(int priority) {
        try {
            Thread.currentThread().setPriority(ThreadQueue.cobolPriorityToJavaPriority(priority));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockThreads(boolean allThreads) {
        Object object = lockLevelObject;
        synchronized (object) {
            if (lockLevel < 0) {
                lockLevel = 0;
            }
            if (++lockLevel == 1) {
                Thread currentThread = Thread.currentThread();
                ThreadGroup threadGroup = currentThread.getThreadGroup();
                int activeCount = threadGroup.activeCount();
                Thread[] threads = new Thread[activeCount];
                activeCount = threadGroup.enumerate(threads);
                for (int i = 0; i < activeCount; ++i) {
                    try {
                        if (threads[i] == currentThread) continue;
                        if (allThreads) {
                            threads[i].suspend();
                            continue;
                        }
                        ((ThreadQueue)threads[i]).lock();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockThreads(boolean allThreads) {
        Object object = lockLevelObject;
        synchronized (object) {
            if (--lockLevel < 0) {
                lockLevel = 0;
            } else if (lockLevel == 0) {
                Thread currentThread = Thread.currentThread();
                ThreadGroup threadGroup = currentThread.getThreadGroup();
                int activeCount = threadGroup.activeCount();
                Thread[] threads = new Thread[activeCount];
                activeCount = threadGroup.enumerate(threads);
                for (int i = 0; i < activeCount; ++i) {
                    try {
                        if (threads[i] == currentThread) continue;
                        if (allThreads) {
                            threads[i].resume();
                            continue;
                        }
                        ((ThreadQueue)threads[i]).unlock();
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

