/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;

public final class Tiler {
    private static int screen_x = 640;
    private static int screen_y = 480;
    private static int stagger_x = 20;
    private static int stagger_y = 20;
    private static int x = -1;
    private static int y = -1;

    static void determineScreenSize() {
        try {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            screen_x = d.width;
            screen_y = d.height;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Point getNextLocation(int width, int height) {
        return Tiler.getNextLocation(width, height, 0, 0);
    }

    public static Point getNextLocation(int width, int height, int alterx, int altery) {
        if (width < 50 || height < 50) {
            width = 320;
            height = 200;
        }
        width += 4;
        height += 18;
        if (x < 0) {
            x = (screen_x - width) / 2;
            y = (screen_y - height) / 2;
        } else {
            if (width < 128) {
                width = 128;
            }
            if (height < 64) {
                height = 64;
            }
            if ((x += stagger_x) + width > screen_x || (y += stagger_y) + height > screen_y) {
                x = 0;
                y = 0;
            }
        }
        if (alterx != 0) {
            x = alterx;
        }
        if (altery != 0) {
            y = altery;
        }
        return new Point(x, y);
    }

    public static Point getNextLocation(int width, int height, Window parentWindow) {
        return Tiler.getNextLocation(width, height, parentWindow, 0, 0);
    }

    public static Point getNextLocation(int width, int height, Window parentWindow, int alterx, int altery) {
        if (width < 50 || height < 50) {
            width = 320;
            height = 200;
        }
        if (parentWindow == null) {
            return Tiler.getNextLocation(width, height, alterx, altery);
        }
        Point parentLocation = parentWindow.getLocationOnScreen();
        Dimension parentSize = parentWindow.getSize();
        int centerX = parentLocation.x + parentSize.width / 2;
        int centerY = parentLocation.y + parentSize.height / 2;
        if (centerX < 0 || centerY < 0) {
            return Tiler.getNextLocation(width, height);
        }
        int x = centerX - width / 2;
        int y = centerY - height / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (alterx != 0) {
            x = parentLocation.x + alterx;
        }
        if (altery != 0) {
            y = parentLocation.y + altery;
        }
        return new Point(x, y);
    }

    static {
        Tiler.determineScreenSize();
    }
}

