/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import java.util.Hashtable;

public abstract class TransactionFile
extends basicFile {
    public static final boolean debugMode = false;
    public static final boolean debugTransaction = false;
    public static final String DEFAULT_DEVICE_NAME = "Console";
    public static final int STATUS_UNINITIALIZED = 0;
    public static final int STATUS_DELETED = 1;
    public static final int STATUS_VALID = 2;
    public static final int STATUS_IMPOSSIBLE = 3;
    protected String filename;
    protected Variable filenameVariable;
    protected Variable dependingOn;
    protected int minimum = -1;
    protected int maximum = -1;
    protected int permanentMinimum = -1;
    protected int permanentMaximum = -1;
    protected TransactionFile externalFile;
    protected Variable fileStatus;
    protected int priorErrorCode;
    protected long maxDigitsInKey = 999999999999999999L;
    protected Variable relativeKey;
    protected long readRecord;
    protected int readSize;
    protected boolean keyAlreadyPresent;
    protected int alignment = 1;
    protected boolean isOpen;
    protected int accessMode = -1;
    protected boolean optional;
    protected boolean readable;
    protected boolean writable;
    protected boolean extend;
    protected int newModes;
    protected boolean override_variable;
    protected boolean override_fixed;
    protected boolean override_varying;
    protected LockRecord lockRecord = LockRecord.create();
    protected Variable fileStatus2;
    protected Variable controlArea;
    protected static final Hashtable<String, Object[]> terminalDevices = new Hashtable();

    protected static void debug(String text) {
        System.out.println("TransactionFile: " + text);
    }

    protected int getLockPosition() {
        return this.relativeKey == null || this.isSequential() ? (int)(this.readRecord + 1L) : (int)this.relativeKey.toLong();
    }

    protected int inner_readNext(boolean subfile, String terminal, Variable indicators, String format, Variable data) {
        this.readSize = this.getCurrentRecordDataSize();
        if (this.readSize <= 0) {
            this.readSize = data.length();
        }
        int result = -1;
        long savedReadRecord = this.readRecord++;
        int status = 2;
        this.keyAlreadyPresent = false;
        if (this.readRecord > this.maxDigitsInKey) {
            return -14;
        }
        try {
            result = this.readSubfileRecord(terminal, indicators, format, this.readRecord, data, this.readSize, true);
        }
        catch (Throwable t) {
            result = -30;
        }
        if (result < 0) {
            if (savedReadRecord > 0L) {
                this.readRecord = savedReadRecord;
            }
            if (this.isAtEnd(result)) {
                result = -10;
                this.iostatus(1, '2');
            } else {
                this.iostatus(result);
            }
            this.updateRelativeKey();
            return result;
        }
        if (result >= 0) {
            this.readRecord = this.getLastSubfileRecordRead();
            status = this.getCurrentRecordStatus();
            boolean bl = this.keyAlreadyPresent = status == 2;
            if (!this.keyAlreadyPresent && status == 0) {
                result = -10;
                this.iostatus(1, '2');
            }
        }
        this.updateRelativeKey();
        if (this.variable()) {
            this.readSize = result;
        }
        int returnCode = result;
        if (this.dependingOn != null) {
            this.dependingOn.move(this.readSize);
        }
        if (returnCode > 0 && returnCode != this.readSize) {
            returnCode = -4;
        }
        if (returnCode >= 0) {
            returnCode = 0;
        }
        this.iostatus(returnCode);
        return returnCode;
    }

    protected int inner_read(boolean subfile, String terminal, Variable indicators, String format, Variable data) {
        int result;
        int returnCode;
        if (subfile && (returnCode = this.position()) != 0 && returnCode != -10) {
            this.iostatus(returnCode);
            return returnCode;
        }
        this.readSize = this.getCurrentRecordDataSize();
        if (this.readSize <= 0) {
            this.readSize = data.length();
        }
        boolean isDeletedErrorTrue = false;
        try {
            if (subfile) {
                result = this.readSubfileRecord(terminal, indicators, format, this.readRecord, data, this.readSize, false);
            } else {
                result = this.readRecord(terminal, indicators, format, data, this.readSize);
                this.readRecord = 0L;
                this.updateRelativeKey();
            }
        }
        catch (Throwable t) {
            result = -30;
        }
        if (result < 0) {
            isDeletedErrorTrue = true;
        } else {
            this.keyAlreadyPresent = false;
            int status = this.getCurrentRecordStatus();
            if (status == 0) {
                this.iostatus(1, '2');
                return -10;
            }
            if (status == 1) {
                isDeletedErrorTrue = true;
            } else if (status == 2) {
                this.keyAlreadyPresent = true;
            } else {
                isDeletedErrorTrue = true;
            }
        }
        if (isDeletedErrorTrue) {
            if (this.priorError() == 46) {
                this.iostatus(0);
            } else {
                this.iostatus(1, '2');
                return -10;
            }
        }
        if (result < 0) {
            this.iostatus(1, '2');
            return -10;
        }
        if (this.variable()) {
            this.readSize = result;
            if (this.readSize < 0) {
                returnCode = this.readSize;
                this.iostatus(returnCode);
                this.readSize = -1;
                return returnCode;
            }
        }
        returnCode = result;
        if (this.dependingOn != null) {
            this.dependingOn.move(this.readSize);
        }
        if (returnCode > 0 && returnCode != this.readSize) {
            returnCode = -4;
        }
        if (returnCode >= 0) {
            returnCode = 0;
        }
        this.iostatus(returnCode);
        return returnCode;
    }

    protected int inner_write(boolean subfile, String terminal, Variable indicators, String format, int startingAtLine, Variable data) {
        int size;
        if (!this.isWritable()) {
            return -48;
        }
        if (subfile) {
            ++this.readRecord;
            int returnCode = this.position();
            if (returnCode != 0 && returnCode != -10) {
                this.iostatus(returnCode);
                return returnCode;
            }
            if (this.keyAlreadyPresent && this.writeRequiresKeyNotPresent()) {
                return -22;
            }
            this.updateRelativeKey();
        }
        if ((size = data.length()) <= 0) {
            size = this.getCurrentRecordDataSize();
        }
        if (this.dependingOn != null) {
            size = this.dependingOn.toInt();
        }
        int result = 0;
        try {
            result = subfile ? this.writeSubfileRecord(terminal, indicators, format, this.readRecord, data, size) : this.writeRecord(terminal, indicators, format, startingAtLine, data, size);
        }
        catch (Throwable t) {
            result = -30;
        }
        return result;
    }

    protected int inner_rewrite(boolean subfile, String terminal, Variable indicators, String format, Variable data) {
        int size;
        if (this.isSequential() || this.relativeKey == null) {
            int returnCode;
            if (this.readSize == -1) {
                return -43;
            }
            if (!this.isIO()) {
                return -49;
            }
            int size2 = data.length();
            if (size2 <= 0) {
                size2 = this.getCurrentRecordDataSize();
            }
            if (this.dependingOn != null) {
                size2 = this.dependingOn.toInt();
            }
            try {
                returnCode = subfile ? this.rewriteSubfileRecord(terminal, indicators, format, -1L, data, size2) : this.rewriteRecord(terminal, indicators, format, data, size2);
            }
            catch (Throwable t) {
                returnCode = -30;
            }
            if (returnCode == -90) {
                return -49;
            }
            if (returnCode == -48) {
                return -49;
            }
            return returnCode;
        }
        if (!this.isIO()) {
            return -49;
        }
        if (subfile) {
            ++this.readRecord;
            int returnCode = this.position();
            if (returnCode != 0 && returnCode != -10) {
                this.iostatus(returnCode);
                return returnCode;
            }
            this.updateRelativeKey();
        }
        if ((size = data.length()) <= 0) {
            size = this.getCurrentRecordDataSize();
        }
        if (this.dependingOn != null) {
            size = this.dependingOn.toInt();
        }
        int result = 0;
        try {
            result = subfile ? this.rewriteSubfileRecord(terminal, indicators, format, this.readRecord, data, size) : this.rewriteRecord(terminal, indicators, format, data, size);
        }
        catch (Throwable t) {
            result = -30;
        }
        return result;
    }

    @Override
    public boolean open(int mode) {
        try {
            int returnCode;
            mode = this.setOpenMode(mode);
            this.readRecord = 0L;
            this.maximum = this.permanentMaximum;
            this.minimum = this.permanentMinimum;
            this.override_variable = false;
            this.override_fixed = false;
            this.override_varying = false;
            if ((this.newModes & 1) != 0) {
                this.override_fixed = true;
            }
            if ((this.newModes & 2) != 0) {
                this.override_variable = true;
            }
            if ((this.newModes & 4) != 0) {
                this.override_varying = true;
            }
            if (this.filenameVariable != null) {
                this.setFilename(this.filenameVariable.toString());
            }
            this.lockRecord.open(this.getFilename(), mode & 0x16000);
            this.readSize = -1;
            if ((mode & 1) != 0) {
                this.setReadable(true);
            } else {
                this.setReadable(false);
            }
            if ((mode & 2) != 0) {
                this.setWritable(true);
            } else {
                this.setWritable(false);
            }
            if ((mode & 4) != 0) {
                this.setWritable(true);
                mode |= 1;
                this.setExtend(true);
            } else {
                this.setExtend(false);
            }
            if (this.optional) {
                mode |= 8;
            }
            try {
                returnCode = this.openTransactionFile(mode);
            }
            catch (Throwable t) {
                returnCode = -30;
            }
            this.iostatus(returnCode);
            boolean bl = this.isOpen = returnCode == 0;
            if (!this.isOpen) {
                return false;
            }
            this.isNewTransactionFile();
            if (terminalDevices.get(DEFAULT_DEVICE_NAME) == null && !this.acquire(DEFAULT_DEVICE_NAME)) {
                this.iostatus(9, 'H');
                this.close();
                return false;
            }
            this.readRecord = 0L;
            if (this.isExtend()) {
                this.readRecord = this.seekPastLastValidRecord();
                if (this.readRecord < 0L) {
                    this.readRecord = 0L;
                }
                this.updateRelativeKey();
            }
            return this.isOpen;
        }
        catch (Throwable t) {
            this.iostatus(-30);
            return false;
        }
    }

    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        double seconds = timeout.toDouble();
        boolean success = false;
        long currentTime = System.currentTimeMillis();
        long finalTime = currentTime + (long)(seconds * 1000.0);
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || System.currentTimeMillis() >= finalTime) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && System.currentTimeMillis() < finalTime);
        return success;
    }

    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        int attempts = timeout.toInt();
        if (attempts < 0) {
            attempts = 0;
        }
        ++attempts;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success || --attempts <= 0) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success && attempts > 0);
        return success;
    }

    public synchronized boolean openTimeoutRetries(int mode) {
        int timeout_mask = 0x2100000;
        mode &= ~timeout_mask;
        boolean success = false;
        do {
            this.iostatus(0);
            success = this.open(mode);
            if (success) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!success);
        return success;
    }

    @Override
    public boolean close() {
        return this.close(0);
    }

    public boolean close(int mode) {
        if (!this.isOpen()) {
            this.setIOStatus(-42);
            return false;
        }
        this.readSize = -1;
        this.lockRecord.close();
        int returnCode = this.closeTransactionFile(mode);
        this.iostatus(returnCode);
        this.isOpen = returnCode == 0;
        return !this.isOpen;
    }

    public boolean readNext(Variable data) {
        return this.readNext(false, null, null, null, data);
    }

    public boolean readNext(boolean subfile, String terminal, Variable indicators, String format, Variable data) {
        try {
            this.iostatus(0);
            if (!this.isOpen() || !this.isReadable()) {
                int returnCode = -47;
                this.setIOStatus(-47);
                return this.isInvalidKey(returnCode);
            }
            if (this.isRandom()) {
                return this.read(data);
            }
            int returnCode = this.inner_readNext(subfile, terminal, indicators, format, data);
            if (returnCode <= -10) {
                this.readSize = -1;
            }
            return this.isAtEnd(returnCode);
        }
        catch (Throwable t) {
            this.iostatus(-30);
            return false;
        }
    }

    public boolean readNext(Variable data, int mode, Numeric timeout) {
        return this.readNext(false, null, null, null, data, mode, timeout);
    }

    public boolean readNext(boolean subfile, String terminal, Variable indicators, String format, Variable data, int mode, Numeric timeout) {
        block19: {
            try {
                boolean locking;
                if (!this.isOpen() || !this.isReadable()) {
                    int returnCode = -47;
                    this.setIOStatus(-47);
                    return this.isInvalidKey(returnCode);
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.readNext(subfile, terminal, indicators, format, data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                int lockNumber = 0;
                if (!locking) break block19;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber)) {
                        boolean status = this.readNext(subfile, terminal, indicators, format, data);
                        if (this.isInput()) {
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        if (this.isOK()) {
                            if (this.lockingSingle()) {
                                return status;
                            }
                            if ((mode & 0x200000) != 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            if (this.lockingManual() && (mode & 0x1000000) == 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            return status;
                        }
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x200000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable t) {
                this.iostatus(-30);
            }
        }
        return false;
    }

    @Override
    public boolean read(Variable data) {
        return this.read(false, null, null, null, data);
    }

    public boolean read(boolean subfile, String terminal, Variable indicators, String format, Variable data) {
        try {
            this.iostatus(0);
            if (!this.isOpen() || !this.isReadable()) {
                int returnCode = -47;
                this.setIOStatus(-47);
                return this.isInvalidKey(returnCode);
            }
            int returnCode = this.inner_read(subfile, terminal, indicators, format, data);
            if (returnCode <= -10) {
                this.readSize = -1;
            }
            return this.isinvalidkey(returnCode);
        }
        catch (Throwable t) {
            this.iostatus(-30);
            return false;
        }
    }

    public boolean read(Variable data, int mode, Numeric timeout) {
        return this.read(false, null, null, null, data, mode, timeout);
    }

    public boolean read(boolean subfile, String terminal, Variable indicators, String format, Variable data, int mode, Numeric timeout) {
        block19: {
            try {
                boolean locking;
                if (!this.isOpen() || !this.isReadable()) {
                    int returnCode = -47;
                    this.setIOStatus(-47);
                    return this.isInvalidKey(returnCode);
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.read(subfile, terminal, indicators, format, data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                int lockNumber = 0;
                if (!locking) break block19;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber)) {
                        boolean status = this.read(subfile, terminal, indicators, format, data);
                        if (this.isInput()) {
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        if (this.isOK()) {
                            if (this.lockingSingle()) {
                                return status;
                            }
                            if ((mode & 0x200000) != 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            if (this.lockingManual() && (mode & 0x1000000) == 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            return status;
                        }
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x200000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable t) {
                this.iostatus(-30);
            }
        }
        return false;
    }

    public boolean rewrite(Variable data) {
        return this.rewrite(false, null, null, null, data);
    }

    public boolean rewrite(boolean subfile, String terminal, Variable indicators, String format, Variable data) {
        try {
            if (!this.isOpen() || !this.isIO()) {
                int returnCode = -49;
                this.setIOStatus(-49);
                return this.isInvalidKey(returnCode);
            }
            data.flushToMemory();
            this.iostatus(0);
            int returnCode = this.inner_rewrite(subfile, terminal, indicators, format, data);
            this.iostatus(returnCode);
            this.readSize = -1;
            return this.isinvalidkey(returnCode);
        }
        catch (Throwable t) {
            this.iostatus(-30);
            return false;
        }
    }

    public boolean rewrite(Variable data, int mode, Numeric timeout) {
        return this.rewrite(false, null, null, null, data, mode, timeout);
    }

    public boolean rewrite(boolean subfile, String terminal, Variable indicators, String format, Variable data, int mode, Numeric timeout) {
        block15: {
            try {
                boolean locking;
                if (!this.isOpen() || !this.isIO()) {
                    int returnCode = -49;
                    this.setIOStatus(-49);
                    return this.isInvalidKey(returnCode);
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.rewrite(subfile, terminal, indicators, format, data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                int lockNumber = 0;
                if (!locking) break block15;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber)) {
                        boolean status = this.rewrite(subfile, terminal, indicators, format, data);
                        if (this.isOK()) {
                            if (this.lockingMultiple() && (mode & 0x200000) == 0 || (mode & 0x1000000) != 0) {
                                return status;
                            }
                            if (this.lockingSingle()) {
                                return status;
                            }
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable t) {
                this.iostatus(-30);
            }
        }
        return false;
    }

    @Override
    public boolean write(Variable data) {
        return this.write(false, null, null, null, -1, data);
    }

    public boolean write(boolean subfile, String terminal, Variable indicators, String format, int startingAtLine, Variable data) {
        if (!this.isOpen() || !this.isWritable()) {
            int returnCode = -48;
            this.setIOStatus(-48);
            return this.isInvalidKey(returnCode);
        }
        data.flushToMemory();
        this.iostatus(0);
        int returnCode = this.inner_write(subfile, terminal, indicators, format, startingAtLine, data);
        this.iostatus(returnCode);
        this.readSize = -1;
        return this.isinvalidkey(returnCode);
    }

    public boolean write(Variable data, int mode, Numeric timeout) {
        return this.write(false, null, null, null, -1, data, mode, timeout);
    }

    public boolean write(boolean subfile, String terminal, Variable indicators, String format, int startingAtLine, Variable data, int mode, Numeric timeout) {
        block14: {
            try {
                boolean locking;
                if (!this.isOpen() || !this.isWritable()) {
                    int returnCode = -48;
                    this.setIOStatus(-48);
                    return this.isInvalidKey(returnCode);
                }
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.write(subfile, terminal, indicators, format, startingAtLine, data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                int lockNumber = 0;
                if (!locking) break block14;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber)) {
                        boolean status = this.write(subfile, terminal, indicators, format, startingAtLine, data);
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x1000000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable t) {
                this.iostatus(-30);
            }
        }
        return false;
    }

    @Override
    public void unlock() {
        this.lockRecord.unlockAll();
        this.iostatus(0);
    }

    public void exclusive() {
        while (!this.lockRecord.exclusive()) {
            this.iostatus(-93);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.iostatus(0);
    }

    public void exclusiveConditionally() {
        if (this.lockRecord.exclusive()) {
            this.iostatus(0);
        } else {
            this.iostatus(-93);
        }
    }

    public void unexclusive() {
        this.lockRecord.unexclusive();
        this.iostatus(0);
    }

    public void flushCache() {
    }

    protected boolean isRandom() {
        return this.accessMode == 2;
    }

    protected boolean isDynamic() {
        return this.accessMode == 4;
    }

    protected boolean isSequential() {
        return this.accessMode == 1;
    }

    public int position() {
        this.readRecord = this.getPosition();
        return 0;
    }

    public int getPosition() {
        return this.relativeKey == null || this.isSequential() ? (int)this.readRecord : (int)this.relativeKey.toLong();
    }

    protected void updateRelativeKey() {
        if (this.relativeKey != null) {
            this.relativeKey.move(this.readRecord);
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String assignTo) {
        if (assignTo.startsWith("env:")) {
            String envname = assignTo.substring(4);
            this.filename = RuntimeEnvironment.getGlobalParameter(envname);
            if (this.filename == null) {
                this.filename = envname;
            }
        } else {
            this.filename = assignTo;
        }
    }

    @Override
    public void init() {
        this.readSize = -1;
        if (this.isOpen) {
            this.close();
        }
    }

    @Override
    public Numeric getLinageCounter() {
        return new Numeric(1);
    }

    public String toString() {
        return "TRANSACTION FILE";
    }

    @Override
    public Object getObject() {
        return null;
    }

    public void finalize() {
        this.init();
    }

    @Override
    public boolean advance(int n) {
        return false;
    }

    @Override
    public boolean advance() {
        return false;
    }

    @Override
    public boolean advancePage() {
        return false;
    }

    public int getSize() {
        return this.maximum;
    }

    public int getCurrentRecordDataSize() {
        if (this.dependingOn != null) {
            try {
                return this.dependingOn.toInt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getSize();
    }

    public int currentSize() {
        return this.getCurrentRecordDataSize();
    }

    public boolean fixed() {
        if (this.override_fixed) {
            return true;
        }
        return !this.variable();
    }

    public boolean variable() {
        if (this.override_variable) {
            return true;
        }
        return this.minimum != this.maximum || this.dependingOn != null;
    }

    public void setFixed() {
        this.newModes = 1;
    }

    public void setVariable() {
        this.newModes = 2;
    }

    public final TransactionFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof TransactionFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        this.externalFile = (TransactionFile)copy;
        this.priorErrorCode = this.externalFile.priorErrorCode;
        return this;
    }

    public boolean isReadable() {
        return this.externalFile != null ? this.externalFile.isReadable() : this.readable;
    }

    public boolean isWritable() {
        return this.externalFile != null ? this.externalFile.isWritable() : this.writable;
    }

    public boolean isExtend() {
        return this.externalFile != null ? this.externalFile.isExtend() : this.extend;
    }

    public void setReadable(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setReadable(state);
        }
        this.readable = state;
    }

    public void setWritable(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setWritable(state);
        }
        this.writable = state;
    }

    public void setExtend(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setExtend(state);
        }
        this.extend = state;
    }

    public boolean isInput() {
        return this.isReadable() && !this.isWritable();
    }

    public boolean isOutput() {
        return this.isWritable() && !this.isReadable() && !this.isExtend();
    }

    public boolean isIO() {
        return this.isReadable() && this.isWritable();
    }

    public boolean isinvalidkey(int returnCode) {
        return returnCode >= -29 && returnCode <= -20;
    }

    public boolean isInvalidKey(int returnCode) {
        return this.isinvalidkey(returnCode);
    }

    public boolean useException() {
        return this.priorError() >= 10;
    }

    public boolean useExceptionNotInvalid() {
        int rc = this.priorError();
        if (rc > 0) {
            rc = -rc;
        }
        return rc <= 10 && rc != -22 && rc != -23 && rc != -24;
    }

    public boolean useAtEnd() {
        return this.priorError() == -10 || this.priorError() == 10 || this.priorError() == 14 || this.priorError() == -14;
    }

    public boolean isOK() {
        return this.priorError() > -10;
    }

    public boolean isAtEnd(int returnCode) {
        if (returnCode == -23 || returnCode == -10) {
            if (this.isSequential()) {
                this.iostatus(-10);
            }
            return true;
        }
        return false;
    }

    public boolean isNoData() {
        return false;
    }

    public int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useException(int specific) {
        if (this.useException()) {
            return specific;
        }
        return -1;
    }

    public int useExceptionNotInvalid(int specific, int input, int output, int io, int extend) {
        if (this.useExceptionNotInvalid()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useExceptionNotInvalid(int specific) {
        if (this.useExceptionNotInvalid()) {
            return specific;
        }
        return -1;
    }

    public int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.priorError() == 10 || this.priorError() == -10) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public int useAtEnd(int specific) {
        if ((this.priorError() == 10 || this.priorError() == -10) && specific >= 0) {
            return specific;
        }
        return -1;
    }

    public void iostatus(String x) {
        try {
            this.iostatus(-Integer.parseInt(x.trim()));
        }
        catch (Exception e) {
            this.iostatus(0);
        }
    }

    public void iostatus(int status1, char status2) {
        if (status1 < 0 || status1 > 9) {
            this.iostatus(0);
            return;
        }
        int status = status1 * 10;
        if (Character.isDigit(status2)) {
            try {
                status += Integer.parseInt("" + status2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = status = status < 0 ? -status : 0;
        if (status == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            this.fileStatus.move("" + status1 + status2);
        }
    }

    public void setIOStatus(int status) {
        this.iostatus(status);
    }

    public void iostatus(int status) {
        int n = status = status < 0 ? -status : 0;
        if (status == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.move("00");
            } else if (status < 10) {
                this.fileStatus.move("0" + status);
            } else {
                this.fileStatus.move(status);
            }
        }
    }

    public void setPriorError(int status) {
        if (this.externalFile != null) {
            this.externalFile.setPriorError(status);
        }
        this.priorErrorCode = status;
    }

    @Override
    public int priorError() {
        return this.externalFile != null ? this.externalFile.priorError() : this.priorErrorCode;
    }

    public boolean deleteFile() {
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean acquire(String programDeviceName) {
        ReferenceCount rc;
        Object[] o;
        if (programDeviceName == null) {
            programDeviceName = "";
        }
        if (programDeviceName.length() > 10) {
            programDeviceName = programDeviceName.substring(0, 10);
        }
        if ((o = terminalDevices.get(programDeviceName)) == null) {
            o = new Object[2];
            o[0] = this.allocateTransactionDevice(programDeviceName);
            if (o[0] == null) {
                this.iostatus(9, 'H');
                return false;
            }
            o[1] = new ReferenceCount();
            terminalDevices.put(programDeviceName, o);
        }
        if ((rc = (ReferenceCount)o[1]).isAcquired()) {
            this.iostatus(9, 'H');
            return false;
        }
        rc.acquire();
        rc.increase();
        return true;
    }

    public boolean drop(String programDeviceName) {
        Object[] o;
        if (programDeviceName == null) {
            programDeviceName = "";
        }
        if (programDeviceName.length() > 10) {
            programDeviceName = programDeviceName.substring(0, 10);
        }
        if ((o = terminalDevices.get(programDeviceName)) == null) {
            return true;
        }
        if (!this.deallocateTransactionDevice(o[0])) {
            return false;
        }
        ReferenceCount rc = (ReferenceCount)o[1];
        rc.decrease();
        rc.drop();
        if (rc.value == 0) {
            terminalDevices.remove(programDeviceName);
        }
        return true;
    }

    public boolean rolling(int from, int to, boolean dirUp, int count) {
        this.scrollTransactionDevice(from, to, dirUp, count);
        return false;
    }

    public TransactionFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable relativeKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes, Variable controlArea) {
        String assignTo = "";
        this.filenameVariable = filenameVariable;
        if (filenameVariable != null) {
            assignTo = filenameVariable.toString();
        }
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, relativeKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn, newModes, controlArea);
    }

    public TransactionFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable relativeKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes, Variable controlArea) {
        try {
            this.newModes = newModes;
            this.controlArea = controlArea;
            this.optional = optional;
            this.setFilename(assignTo);
            this.fileStatus = fileStatus;
            this.relativeKey = relativeKey;
            this.accessMode = accessMode;
            this.dependingOn = dependingOn;
            this.minimum = recordFrom;
            this.maximum = recordTo;
            if (this.maximum < 0) {
                this.maximum = -1;
            }
            if (this.minimum < 0) {
                this.minimum = -1;
            }
            if (this.minimum < 0 && this.maximum >= 0) {
                this.minimum = this.maximum;
            }
            if (this.maximum < 0 && this.minimum >= 0) {
                this.maximum = this.minimum;
            }
            if (this.minimum > this.maximum) {
                this.maximum = this.minimum;
            }
            this.permanentMaximum = this.maximum;
            this.permanentMinimum = this.minimum;
            if (relativeKey != null) {
                String maxPic = Variable.HIGH_VALUES.special(relativeKey);
                int length = relativeKey.relativeKeyLength();
                maxPic = Variable.all('9', length - relativeKey.getPlace());
                try {
                    this.maxDigitsInKey = Integer.parseInt(maxPic);
                }
                catch (Exception e) {
                    this.maxDigitsInKey = 999999999999999999L;
                }
            } else {
                this.maxDigitsInKey = 999999999999999999L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public TransactionFile endDeclare() {
        return this;
    }

    public TransactionFile setPassword(Variable identifier) {
        return this;
    }

    public TransactionFile setDuplicatePrimary() {
        throw new RuntimeException("Duplicate Primary is not supported for transaction files.");
    }

    public TransactionFile setFileStatus2(Variable v) {
        this.fileStatus2 = v;
        return this;
    }

    public TransactionFile setFileStatus3(Variable v) {
        return this;
    }

    protected abstract Object allocateTransactionDevice(String var1);

    protected abstract boolean deallocateTransactionDevice(Object var1);

    protected abstract boolean scrollTransactionDevice(int var1, int var2, boolean var3, int var4);

    protected abstract int openTransactionFile(int var1);

    protected abstract int closeTransactionFile(int var1);

    protected abstract boolean isNewTransactionFile();

    protected abstract int seekPastLastValidRecord();

    protected abstract long getLastSubfileRecordRead();

    protected abstract int readSubfileRecord(String var1, Variable var2, String var3, long var4, Variable var6, int var7, boolean var8);

    protected abstract int readRecord(String var1, Variable var2, String var3, Variable var4, int var5);

    protected abstract int writeSubfileRecord(String var1, Variable var2, String var3, long var4, Variable var6, int var7);

    protected abstract int writeRecord(String var1, Variable var2, String var3, int var4, Variable var5, int var6);

    protected abstract int rewriteSubfileRecord(String var1, Variable var2, String var3, long var4, Variable var6, int var7);

    protected abstract int rewriteRecord(String var1, Variable var2, String var3, Variable var4, int var5);

    protected abstract int getCurrentRecordStatus();

    protected abstract boolean isCurrentRecordModified();

    protected abstract boolean writeRequiresKeyNotPresent();

    private final class ReferenceCount {
        public int value = 0;
        public boolean isAcquired = false;

        private ReferenceCount() {
        }

        public void increase() {
            ++this.value;
        }

        public boolean decrease() {
            if (this.value == 0) {
                return false;
            }
            --this.value;
            return true;
        }

        public void acquire() {
            this.isAcquired = true;
        }

        public void drop() {
            this.isAcquired = false;
        }

        public boolean isAcquired() {
            return this.isAcquired;
        }
    }
}

