/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.debug.DataWatchPoint;
import com.heirloomcomputing.ecc.HCILicensing;
import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exception.StopRun;
import com.heirloomcomputing.ecs.exec.ArrayIndexOutOfBoundsVariable;
import com.heirloomcomputing.ecs.exec.Bignum;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.Bitmask;
import com.heirloomcomputing.ecs.exec.Cache;
import com.heirloomcomputing.ecs.exec.CobolException;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.DataPointerSubscript;
import com.heirloomcomputing.ecs.exec.Display;
import com.heirloomcomputing.ecs.exec.DisplayMVS;
import com.heirloomcomputing.ecs.exec.DisplayP;
import com.heirloomcomputing.ecs.exec.ExternalUnbufferedMemory;
import com.heirloomcomputing.ecs.exec.ExternalUnbufferedSpaceClearedMemory;
import com.heirloomcomputing.ecs.exec.FormatDateTime;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.ICobolInterface;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.Interval;
import com.heirloomcomputing.ecs.exec.Level88;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.NumericSubscript;
import com.heirloomcomputing.ecs.exec.PackedDecimal;
import com.heirloomcomputing.ecs.exec.PackedDecimalI;
import com.heirloomcomputing.ecs.exec.QuickVector;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ScreenProperty;
import com.heirloomcomputing.ecs.exec.SharedMemory;
import com.heirloomcomputing.ecs.exec.SynkronixGui;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.UnbufferedSpaceClearedMemory;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.VariableSubscript;
import com.heirloomcomputing.ecs.exec.XOpenInternational;
import com.heirloomcomputing.ecs.exec.ZonedDescription;
import com.heirloomcomputing.ecs.exec.comparableByteArray;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.util.String2;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import oracle.sql.ROWID;

public class Variable
implements Cloneable,
comparableByteArray,
IDatatype,
Serializable {
    static final long serialVersionUID = 1L;
    private static final String PGM = "Variable";
    private static final boolean IS_DEBUG = false;
    public static final int MAX_CONSTANT_DIGITS = 200;
    public static final int FLAG_JUST_RIGHT = 1;
    public static final int FLAG_BLANK_WHEN_ZERO = 2;
    public static final int FLAG_HAS_INITIAL_VALUE = 4;
    public static final int FLAG_SYNC_LEFT = 8;
    public static final int FLAG_SYNC_RIGHT = 16;
    public static final int FLAG_SYNC = 24;
    public static final int FLAG_INTERNATIONAL = 32;
    public static final int FLAG_CONTAINS_INTERNATIONAL = 64;
    public static final int FLAG_FILLER = 128;
    public static final int FLAG_NATIVE = 256;
    public static final int FLAG_PRUNE_CHAR = 512;
    public static final int FLAG_PRUNE_GFX = 1024;
    public static final int FLAG_SCREEN = 2048;
    public static final int FLAG_NULL = 4096;
    public static final int FLAG_VARCHAR = 8192;
    public static final int FLAG_BLOB = 16384;
    public static final int FLAG_VARCHAR2 = 32768;
    public static final int FLAG_ODO_OBJECT = 65536;
    public static final int FLAG_ARRAY = 131072;
    public static final int FLAG_ANYVARCHAR = 40960;
    public static final int FLAG_TABLE_ELEMENT = 262144;
    public static final int FLAG_STARRED_WHEN_ZERO = 524288;
    public static final int FLAG_REDEFINES = 0x100000;
    public static final int FLAG_SIGN_LEADING = 0x200000;
    public static final int FLAG_SIGN_TRAILING = 0x400000;
    public static final int FLAG_SIGN_SEPARATE = 0x800000;
    public static final int FLAG_SIGNED = 0x600000;
    public static final int FLAG_SIGN_LEADING_SEPARATE = 0xA00000;
    public static final int FLAG_SIGN_TRAILING_SEPARATE = 0xC00000;
    public static final int FLAG_USAGE_MISC = 0x1000000;
    public static final int FLAG_USAGE_EXTERNAL_FORM = 0x2000000;
    public static final int FLAG_TYPE_NUMERIC = 0x4000000;
    public static final int FLAG_TYPE_EDITED = 0x8000000;
    public static final int FLAG_TYPE_NATIONAL = 0x10000000;
    public static final int FLAG_TYPE_ALPHABETIC = 0x20000000;
    public static final int FLAG_IDENTIFIED = 0x40000000;
    public static final int FLAG_TYPE_NUMERIC_EDITED = 0xC000000;
    public static final int FLAG_TYPE_ALPHANUMERIC = 0;
    public static final int FLAG_TYPE_ALPHANUMERIC_EDITED = 0x8000000;
    public static final int FLAG_TYPE_NATIONAL_EDITED = 0x18000000;
    public static final int FLAG_TYPE_MASK = 0x1C000000;
    public static final int FLAG_TYPE_FULLMASK = 0x3C000000;
    public static final int FLAG_TYPE_UNEDITED_MASK = 0x14000000;
    public static final int FLAG_INITIAL_MOVE_MASK = 524315;
    private static final String DEFAULT_NAME = "";
    public static int SPACE_INT = 32;
    public static char SPACE_CHAR = (char)32;
    public static char ZERO_CHAR = (char)48;
    public static final int FORMAT_EC_ASCII = 0;
    public static final int FORMAT_IBM_ASCII = 1;
    public static final int FORMAT_ACUCOBOL_ASCII = 2;
    public static final int FORMAT_IBM_EBCDIC = 3;
    public static boolean SPECIAL_CHAR_HIGH_LOW_VALUES = true;
    public static final byte SPECIAL_NONE = 0;
    public static final byte SPECIAL_ALL = 1;
    public static final byte SPECIAL_ZEROES = 2;
    public static final byte SPECIAL_SPACES = 3;
    public static final byte SPECIAL_HIGH_VALUES = 4;
    public static final byte SPECIAL_LOW_VALUES = 5;
    public static final byte SPECIAL_QUOTES = 6;
    public static final byte SPECIAL_AQUOTES = 9;
    public static final char CHAR_HIGH_VALUES = '\ufeff';
    public static final char CHAR_LOW_VALUES = '\ufefe';
    public static final char CHAR_ALL = '\ufefd';
    public static final char CHAR_ZEROES = '\ufefc';
    public static final char CHAR_SPACES = '\ufefb';
    public static final char CHAR_QUOTES = '\ufefa';
    public static final char CHAR_ALSO = '\ufeef';
    public static final char CHAR_AQUOTES = '\ufef9';
    public static final char DEFAULT_COMMA = ',';
    public static final char DEFAULT_DECIMAL = '.';
    public static final int CHAR_A = 1;
    public static final int CHAR_ALPHABETIC = 1;
    public static final int CHAR_9 = 2;
    public static final int CHAR_P = 4;
    public static final int CHAR_V = 8;
    public static final int CHAR_S = 16;
    public static final int CHAR_NUMERIC = 30;
    public static final int CHAR_N = 262144;
    public static final int CHAR_X = 32;
    public static final int CHAR_ALPHANUMERIC = 262179;
    public static final int CHAR_B = 64;
    public static final int CHAR_0 = 128;
    public static final int CHAR_SLASH = 256;
    public static final int CHAR_ALPHANUMERIC_EDITED = 262627;
    public static final int CHAR_Z = 512;
    public static final int CHAR_COMMA = 1024;
    public static final int CHAR_DECIMAL = 2048;
    public static final int CHAR_STAR = 4096;
    public static final int CHAR_PLUS = 8192;
    public static final int CHAR_MINUS = 16384;
    public static final int CHAR_CR = 32768;
    public static final int CHAR_DB = 65536;
    public static final int CHAR_CURRENCY = 131072;
    public static final int CHAR_NUMERIC_EDITED = 262094;
    public static final int CHAR_BOOLEAN = 524288;
    public static final byte NUMERIC = 0;
    public static final byte NUMERIC_EDITED = 1;
    public static final byte ALPHANUMERIC = 2;
    public static final byte ALPHANUMERIC_EDITED = 3;
    public static final byte ALPHABETIC = 4;
    public static final byte INDEX = 5;
    public static final byte UNKNOWN = -1;
    public static final byte IGNORE = 7;
    public static final byte POINTER = 8;
    public static final byte NATIONAL = 31;
    public static final byte NATIONAL_EDITED = 32;
    public static final byte BOOLEAN = 33;
    public static final byte NO_SYNC = 0;
    public static final byte SYNC_NONE = 0;
    public static final byte SYNC_LEFT = 1;
    public static final byte SYNC_RIGHT = 2;
    public static final byte SIGN_NONE = 0;
    public static final byte SIGN_UNSPECIFIED = 3;
    public static final byte SIGN_LEADING = 2;
    public static final byte SIGN_TRAILING = 3;
    public static final byte SIGN_LEADING_SEPARATE = 4;
    public static final byte SIGN_TRAILING_SEPARATE = 5;
    public static final byte DISPLAY = 0;
    public static final byte COMP1 = 1;
    public static final byte COMP2 = 2;
    public static final byte BINARY = 3;
    public static final byte PACKED_DECIMAL = 4;
    public static final byte MISC = 5;
    public static final byte COMPS = 34;
    public static final byte COMPD = 35;
    public static final byte EXTERNAL_FORM = 36;
    public static final byte COMP1R = 37;
    public static final byte COMP1MVS = 38;
    public static final byte COMP2R = 39;
    public static final byte COMP2MVS = 40;
    public static final byte HANDLE = 41;
    public static final byte COMPX = 42;
    public static final byte BINARY_R = 43;
    public static final byte COMPX_R = 44;
    public static final byte PACKED_DECIMAL_I = 45;
    public static final byte PACKED_DECIMAL_A = 46;
    public static final byte COMP_6 = 47;
    public static final byte PD_ALTPLUS = 10;
    public static final byte PD_ALTMINUS = 11;
    public static final byte PD_BULLPLUS = 11;
    public static final byte PD_NCRPLUS = 11;
    public static final byte PD_PLUS = 12;
    public static final byte PD_MINUS = 13;
    public static final byte PD_PAD = 14;
    public static final byte PD_UNSIGNED = 15;
    public static char PD_NUMPROCB1 = (char)45;
    public static char PD_NUMPROCB2 = (char)45;
    public static final char ALSO = '\uf8ff';
    public static final char HIGH = '\uf8fe';
    public static final char LOW = '\uf8fd';
    public static final int STORAGE_CLASS_NON_NUMERIC = -1;
    public static final int STORAGE_CLASS_DISPLAY = 0;
    public static final int STORAGE_CLASS_FLOAT = 1;
    public static final int STORAGE_CLASS_DOUBLE = 2;
    public static final int STORAGE_CLASS_PACKED_DECIMAL = 3;
    public static final int STORAGE_CLASS_BINARY = 4;
    private static final String[] NUMERIC_PICTURE = new String[]{"", "9", "99", "999", "9999", "99999", "999999", "9999999", "99999999", "999999999", "9999999999", "99999999999", "999999999999", "9999999999999", "99999999999999", "999999999999999", "9999999999999999", "99999999999999999", "999999999999999999", "9999999999999999999", "99999999999999999999", "999999999999999999999", "9999999999999999999999", "99999999999999999999999", "999999999999999999999999", "9999999999999999999999999", "99999999999999999999999999", "999999999999999999999999999", "9999999999999999999999999999", "99999999999999999999999999999", "999999999999999999999999999999", "9999999999999999999999999999999"};
    public static final int ATYPE_NUM_EDITED = 0;
    public static final int ATYPE_NUM_UNSIGNED = 1;
    public static final int ATYPE_NUM_SIGN_SEP = 2;
    public static final int ATYPE_NUM_SIGNED = 3;
    public static final int ATYPE_NUM_SEP_LEAD = 4;
    public static final int ATYPE_NUM_LEADING = 5;
    public static final int ATYPE_COMP_SIGNED = 6;
    public static final int ATYPE_COMP_UNSIGNED = 7;
    public static final int ATYPE_PACKED_POSITIVE = 8;
    public static final int ATYPE_PACKED_SIGNED = 9;
    public static final int ATYPE_PACKED_UNSIGNED = 10;
    public static final int ATYPE_BINARY_SIGNED = 11;
    public static final int ATYPE_BINARY_UNSIGNED = 12;
    public static final int ATYPE_NATIVE_SIGNED = 13;
    public static final int ATYPE_NATIVE_UNSIGNED = 14;
    public static final int ATYPE_ALPHANUM = 16;
    public static final int ATYPE_JUST_AN = 17;
    public static final int ATYPE_ALPHABETIC = 18;
    public static final int ATYPE_JUST_ALPHA = 19;
    public static final int ATYPE_ALPHA_EDITED = 20;
    public static final int ATYPE_GROUP = 22;
    public static final int ATYPE_FLOAT = 23;
    public static final int ATYPE_NATIONAL = 24;
    public static final int ATYPE_JUST_NAT = 25;
    public static final int ATYPE_NAT_EDITED = 26;
    public static final int ATYPE_WIDE = 27;
    public static final int ATYPE_JUST_WIDE = 28;
    public static final int ATYPE_WIDE_EDITED = 29;
    public static final int ATYPE_ARRAY = 95;
    public static final int ATYPE_INDEX = 96;
    public static final int ATYPE_NUMERIC = 97;
    public static final int ATYPE_UNKNOWN = -1;
    public static final int ATYPE_INVALID = -2;
    public static byte SPACE_BYTE = (byte)32;
    public static final int DEBUG_STRING_THRESHOLD = 128;
    public static final int CAN_STORE_OK = 0;
    public static final int CAN_STORE_WARNING_SPACES = 1;
    public static final int CAN_STORE_WARNING_TRUNCATION = 2;
    public static final int CAN_STORE_ERROR_NUMERIC_DECIMAL = 4;
    public static final int CAN_STORE_ERROR_NUMERIC_WHOLE = 8;
    public static final int CAN_STORE_ERROR_STRING = 16;
    public static final int XML_CONTENT = 1;
    public static final int XML_CONTENT_OFFSET = 2;
    public static final int XML_CONTENT_LENGTH = 4;
    public static final int XML_CONTENT_DATA = 8;
    public static final int XML_CONTENT_NAME = 65536;
    public static final int XML_ANY_CONTENT = 65550;
    public static final int XML_ATTRIBUTE = 16;
    public static final int XML_ATTRIBUTE_NAME = 131072;
    public static final int XML_ATTRIBUTE_URI = 32;
    public static final int XML_ATTRIBUTE_LOCAL = 64;
    public static final int XML_ATTRIBUTE_QNAME = 128;
    public static final int XML_ATTRIBUTE_TYPE = 256;
    public static final int XML_ATTRIBUTE_DATA = 512;
    public static final int XML_ATTRIBUTE_LENGTH = 1024;
    public static final int XML_ANY_ATTRIBUTE = 133088;
    public static final int XML_LOCATOR = 2048;
    public static final int XML_LOCATOR_PUBLIC = 4096;
    public static final int XML_LOCATOR_SYSTEM = 8192;
    public static final int XML_LOCATOR_LINE = 16384;
    public static final int XML_LOCATOR_COLUMN = 32768;
    public static final int XML_ANY_LOCATOR = 61440;
    private static final Pattern DATE_PATTERN_ISO = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private static final Pattern DATE_PATTERN_USA = Pattern.compile("^\\d{2}/\\d{2}/\\d{4}$");
    private static final Pattern TIME_PATTERN = Pattern.compile("^\\d{2}:\\d{2}:\\d{2}$");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d{6}$");
    private static Boolean sqlInferDateTime = null;
    private static Boolean sqlLowValueIsSpace = null;
    private static int narg = -1;
    private static boolean initializationComplete;
    private static char shiftIn;
    private static char shiftOut;
    private static boolean useShiftInOut;
    private static boolean trimGetSqlObject;
    private static String internationalEncoding;
    private static boolean internationalEncodingUseHigh;
    private static String byteEncoding;
    public static Charset defaultCharset;
    public static Charset memoryCharset;
    private static PackedSignEncoding packedSignEncoding;
    private static String sqlEncoding;
    protected static Charset sqlCharset;
    private static boolean checkedSqlEncoding;
    protected static boolean numericValdityChecking;
    protected static boolean numToAlphaIsZeroFilledRightJustified;
    protected static boolean boundsCheck;
    protected int[] idxString;
    private boolean isrefmod = false;
    public byte isRenames = 0;
    Interval firstIntervalPage;
    QuickVector notify;
    boolean notifyDelayed = false;
    Object[] arrayChild;
    protected int picLength;
    protected int itemSize;
    protected static final int ITEMSIZE_NOTSET = -1000;
    protected int resetItemSize = -1000;
    protected int maxItemSize = -1000;
    protected int flagBits;
    protected int minIndex = 1;
    protected int maxIndex = 1;
    protected byte signPosition;
    protected byte place;
    protected byte scale;
    protected Variable parent;
    protected Handle handle;
    protected String numericString;
    protected Memory pointerMemory;
    protected int pointerAddress;
    protected boolean alwaysFlush;
    protected boolean dirty;
    protected boolean valid;
    private Variable nextSibling;
    private Variable firstChild;
    private Variable dependingOnVariable;
    protected Variable redefinedFrom;
    protected ArrayList<Variable> redefinedTo;
    protected ArrayList<Variable> commonAddr;
    private Object fromVariable;
    private Object toVariable;
    private String name = "";
    protected String initValue;
    private ScreenProperty screenProperty;
    private String format;
    private Display surrogate;
    private char[] picArray;
    protected char[] right_array;
    protected char[] left_array;
    private Object guiObject;
    private int eventHandler;
    private int indicator = -1;
    private int xmlBits;
    private byte specialType;
    private boolean sizeErrorCondition;
    private char[] picForNumberArray;
    protected int picForNumberLength;
    private boolean setAddressChanged = false;
    private ArrayList<Level88> level88s = null;
    private static BufferOverrunSettings BufferOverrunCheck;
    private static boolean ODOMoveLenCheck;
    private static String DataType;
    public static boolean RoundOverflow;
    public static boolean TruncateDecimal;
    protected static boolean ConvertNumericsToInt;
    private long modifyOnce = 0L;
    protected static long ModifyOnce;
    protected boolean useGroupMove = false;
    boolean isInitialized = false;
    private static final String JCS_DATE_PARAMETER = "jcsjobdate";
    byte[] initBytes;
    protected String watchpointValue = null;
    protected int watchpointBreakType = 0;
    private int unusedVarsTop = 0;
    private int unusedVarsBot = 0;
    public int subscript = -1;
    public static final Variable ZEROES;
    public static final Variable ZERO;
    public static final Variable ZEROS;
    public static final Variable SPACES;
    public static final Variable SPACE;
    public static final Variable HIGH_VALUES;
    public static final Variable HIGH_VALUE;
    public static final Variable LOW_VALUES;
    public static final Variable LOW_VALUE;
    public static final Variable QUOTES;
    public static final Variable QUOTE;
    public static final Variable AQUOTES;
    public static final Variable AQUOTE;
    public static final String HIGH_VALUES_STRING;
    public static final String LOW_VALUES_STRING;
    public static final String QUOTES_STRING = "\"";
    public static final String AQUOTES_STRING = "'";
    public static final String SPACES_STRING = " ";
    public static final String ZEROES_STRING = "0";
    protected boolean odoNoSlide = false;
    String qualifiedName = null;
    static Object initAlphanumeric;
    static Object initAlphabetic;
    static Object initNumeric;
    static Object initAlphanumericEdited;
    static Object initNumericEdited;
    static Object initNational;
    static Object initNationalEdited;
    static boolean sub;
    static Context _currContext;
    private static boolean initSPComplete;
    private String upperBounds = "";
    private String lowerBounds = "";
    int[] maxDim = null;
    int[] minDim = null;
    Variable[] dependsVars = null;

    public boolean isWatched() {
        return DataWatchPoint.watchPointMap != null && DataWatchPoint.watchPointMap.contains(this);
    }

    public void setWatchpointBreak(int breakmode, String breakValue) {
        DataWatchPoint.setWatchpointMap(this);
        if (this instanceof DataPointer) {
            breakmode = 0;
        }
        this.watchpointBreakType = breakmode;
        if (this.watchpointBreakType <= 1) {
            if (this instanceof Numeric) {
                this.watchpointValue = ((Numeric)this).toNumericString();
            } else if (!(this instanceof DataPointer)) {
                this.watchpointValue = this.toString();
            }
        } else if (this.watchpointBreakType == 2) {
            this.watchpointValue = breakValue;
        }
    }

    public void removeWatchpointBreak() {
        DataWatchPoint.removeWatchpointMap(this);
        this.watchpointBreakType = 0;
        this.watchpointValue = DEFAULT_NAME;
    }

    public boolean isBreakValid() {
        boolean result = false;
        if (this instanceof Numeric) {
            if (this.watchpointBreakType == 0 || this.watchpointBreakType == 1 && ((Numeric)this).compare(new Numeric(this.watchpointValue)) != 0) {
                result = true;
                this.watchpointValue = ((Numeric)this).toNumericString();
            } else if (this.watchpointBreakType == 2 && ((Numeric)this).compare(new Numeric(this.watchpointValue)) == 0) {
                result = true;
            }
        } else if (this instanceof DataPointer) {
            result = true;
        } else {
            String newValue = this.toString();
            if (this.watchpointBreakType == 0 || this.watchpointBreakType == 1 && newValue.compareTo(this.watchpointValue) != 0) {
                result = true;
                this.watchpointValue = newValue;
            } else if (this.watchpointBreakType == 2 && newValue.compareTo(this.watchpointValue) == 0) {
                result = true;
            }
        }
        return result;
    }

    public Variable reset() {
        this.specialType = 0;
        this.signPosition = 0;
        this.scale = 0;
        this.place = 0;
        this.itemSize = 0;
        this.picLength = 0;
        this.maxItemSize = -1000;
        this.resetItemSize = -1000;
        this.flagBits = 0;
        this.minIndex = 1;
        this.maxIndex = 1;
        this.xmlBits = 0;
        this.sizeErrorCondition = false;
        this.picForNumberLength = 0;
        this.setAddressChanged = false;
        return this;
    }

    public Variable notifyParent() {
        this.flushToMemory();
        this.valid = false;
        if (this.parent != null) {
            this.parent.useGroupMove = true;
        }
        return this;
    }

    public boolean isGroupMove() {
        return this.useGroupMove;
    }

    public Variable() {
    }

    public Variable(byte[] data) {
        this.itemSize = data.length;
        this.pointerMemory = new Memory(data);
        this.setUsageMisc();
    }

    public Variable(byte[] data, int length) {
        if (data != null && length > 0) {
            byte[] copy = new byte[length];
            if (length > data.length) {
                System.arraycopy(data, 0, copy, 0, data.length);
            } else {
                System.arraycopy(data, 0, copy, 0, length);
            }
            this.itemSize = length;
            this.pointerMemory = new Memory(copy);
            this.setUsageMisc();
        } else {
            CobolException.runtimeError("Invalid data or length in Variable Constructor");
        }
    }

    public Variable(byte[] data, int offset, int length) {
        if (data != null && offset >= 0 && length > 0) {
            byte[] copy = new byte[length];
            if (offset + length > data.length) {
                System.arraycopy(data, offset, copy, 0, data.length);
            } else {
                System.arraycopy(data, offset, copy, 0, length);
            }
            this.itemSize = length;
            this.pointerMemory = new Memory(copy);
            this.setUsageMisc();
        } else {
            CobolException.runtimeError("Invalid data or length in Variable Constructor");
        }
    }

    public Variable(byte[] data, Memory useMemory, int address) {
        this.alwaysFlush = useMemory.alwaysFlush;
        this.itemSize = data.length;
        this.pointerMemory = useMemory;
        this.pointerAddress = address;
        useMemory.copy(data, 0, address, data.length);
        this.setUsageMisc();
    }

    public Variable(Variable old) {
        if (old == null) {
            old = new Variable(SPACES_STRING);
        }
        if (old.itemSize == 0) {
            old = new Variable(old.toString());
        }
        old.flushToMemory();
        this.itemSize = old.itemSize;
        this.maxItemSize = old.maxItemSize;
        this.specialType = old.specialType;
        this.pointerMemory = old.pointerMemory;
        this.pointerAddress = old.pointerAddress;
        this.name = old.name;
        this.picArray = old.picArray;
        this.initValue = old.initValue;
        this.picLength = old.picLength;
        this.parent = old.parent;
        this.firstChild = old.firstChild;
        this.nextSibling = old.nextSibling;
        this.minIndex = old.minIndex;
        this.maxIndex = old.maxIndex;
        this.dependingOnVariable = old.dependingOnVariable;
        this.redefinedFrom = old.redefinedFrom;
        this.redefinedTo = old.redefinedTo;
        this.signPosition = old.signPosition;
        this.flagBits = old.flagBits;
        this.xmlBits = old.xmlBits;
        this.alwaysFlush = old.alwaysFlush;
        this.format = old.format;
        this.place = old.place;
        this.scale = old.scale;
        this.surrogate = old.surrogate;
        this.handle = old.handle;
        this.eventHandler = old.eventHandler;
        this.numericString = old.numericString;
        this.fromVariable = old.fromVariable;
        this.toVariable = old.toVariable;
        this.screenProperty = old.screenProperty;
        this.setAddressChanged = old.setAddressChanged;
    }

    public Variable(Memory setMemory, int setAddress, int setItemSize) {
        this.pointerMemory = setMemory;
        this.pointerAddress = setAddress;
        this.maxItemSize = this.itemSize = setItemSize;
        this.setUsageMisc();
    }

    public Variable(String setValue) {
        this(null, null, setValue);
    }

    public Variable(String setPic, String setValue) {
        this(null, setPic, setValue);
    }

    public Variable(String setPic, String setValue, boolean isGuiField) {
        this(null, setPic, setValue, isGuiField);
    }

    public Variable(String setName, String setPic, String setValue) {
        this(setName, setPic, setValue, false);
    }

    public Variable(String setName, String setPic, String setValue, boolean isGuiField) {
        char CURRENT_DECIMAL = this.getDecimal();
        char CURRENT_COMMA = this.getComma();
        this.name = setName;
        if (setPic == null && setValue == null) {
            setValue = SPACES_STRING;
        }
        if (Variable.isEmptyString(setPic) && !Variable.isEmptyString(setValue)) {
            this.calculatePicture(setValue);
            this.pointerMemory = new Memory(this.itemSize, new String[0]);
            this.setString(setValue);
            this.fillFromMemory();
        } else if (setValue.length() == 0) {
            this.picArray = null;
            this.picLength = 0;
            this.itemSize = 0;
            this.pointerMemory = new Memory(0, new String[0]);
        } else {
            setPic = this.calcPictureAndType(setPic, setValue);
            if (this.isTypeNumericEdited()) {
                this.setJustRight(true);
            }
            if (isGuiField && this.isTypeNumericEdited() && CURRENT_DECIMAL != '.') {
                setPic = setPic.replace('.', '^');
                setPic = setPic.replace(',', CURRENT_COMMA);
                setPic = setPic.replace('^', CURRENT_DECIMAL);
                setValue = setValue.replace('.', '^');
                setValue = setValue.replace(',', CURRENT_COMMA);
                setValue = setValue.replace('^', CURRENT_DECIMAL);
                setPic = this.calcPictureAndType(setPic, setValue);
            }
            this.picLength = this.itemSize = setPic.length();
            this.picArray = new char[this.itemSize];
            setPic.getChars(0, this.itemSize, this.picArray, 0);
            this.pointerMemory = new Memory(this.itemSize, new String[0]);
            if (Variable.isEmptyString(setValue)) {
                if (this.isTypeNumeric() || this.isTypeNumericEdited()) {
                    this.move(ZEROES);
                } else {
                    this.move(SPACES);
                }
            } else {
                this.setString(setValue);
                this.fillFromMemory();
            }
        }
    }

    private String calcPictureAndType(String setPic, String setValue) {
        char c = ' ';
        char CURRENT_DECIMAL = this.getDecimal();
        char CURRENT_COMMA = this.getComma();
        boolean decimalFound = false;
        this.signPosition = 0;
        this.place = 0;
        this.scale = 0;
        int picChars = 0;
        int setPicLength = setPic != null ? setPic.length() : setValue.length();
        StringBuffer newPic = new StringBuffer(256);
        block23: for (int i = 0; i < setPicLength; ++i) {
            char lc = c;
            c = Character.toUpperCase(setPic.charAt(i));
            switch (c) {
                case 'R': {
                    if (lc != 67) continue block23;
                    c = '_';
                    continue block23;
                }
                case 'C': {
                    picChars |= 0x8000;
                    newPic.append("C_");
                    this.signPosition = (byte)3;
                    continue block23;
                }
                case 'D': {
                    picChars |= 0x10000;
                    newPic.append("D_");
                    this.signPosition = (byte)3;
                    continue block23;
                }
                case 'A': {
                    picChars |= 1;
                    newPic.append('A');
                    continue block23;
                }
                case 'X': {
                    picChars |= 0x20;
                    newPic.append('X');
                    continue block23;
                }
                case 'Z': {
                    picChars |= 0x200;
                    newPic.append('Z');
                    continue block23;
                }
                case '9': {
                    picChars |= 2;
                    newPic.append('9');
                    if (!decimalFound) continue block23;
                    this.place = (byte)(this.place + 1);
                    continue block23;
                }
                case 'P': {
                    picChars |= 4;
                    this.scale = (byte)(this.scale + 1);
                    continue block23;
                }
                case 'S': {
                    picChars |= 0x10;
                    this.signPosition = (byte)3;
                    continue block23;
                }
                case 'V': {
                    picChars |= 8;
                    decimalFound = true;
                    continue block23;
                }
                case '.': {
                    if (CURRENT_DECIMAL != '.') continue block23;
                    picChars |= 0x800;
                    newPic.append(CURRENT_DECIMAL);
                    decimalFound = true;
                    continue block23;
                }
                case ',': {
                    if (CURRENT_DECIMAL == ',') {
                        picChars |= 0x800;
                        newPic.append(CURRENT_DECIMAL);
                        decimalFound = true;
                    }
                    if (CURRENT_COMMA != ',') continue block23;
                    picChars |= 0x400;
                    newPic.append(CURRENT_COMMA);
                    continue block23;
                }
                case 'B': {
                    if (lc == 'D') {
                        c = '_';
                        continue block23;
                    }
                    picChars |= 0x40;
                    newPic.append('B');
                    continue block23;
                }
                case '0': {
                    picChars |= 0x80;
                    newPic.append('0');
                    continue block23;
                }
                case '/': {
                    picChars |= 0x100;
                    newPic.append('/');
                    continue block23;
                }
                case ':': {
                    picChars |= 0x100;
                    newPic.append(':');
                    continue block23;
                }
                case '*': {
                    picChars |= 0x1000;
                    newPic.append('*');
                    if (!decimalFound) continue block23;
                    this.place = (byte)(this.place + 1);
                    continue block23;
                }
                case '+': {
                    picChars |= 0x2000;
                    newPic.append('+');
                    this.signPosition = (byte)3;
                    continue block23;
                }
                case '-': {
                    picChars |= 0x4000;
                    newPic.append('-');
                    this.signPosition = (byte)3;
                    continue block23;
                }
                case '$': {
                    picChars |= 0x20000;
                    newPic.append('$');
                    if (!decimalFound) continue block23;
                    this.place = (byte)(this.place + 1);
                    continue block23;
                }
                case '(': {
                    c = lc;
                    int repPoint = i + 1;
                    while (setPic.charAt(i) != ')') {
                        ++i;
                    }
                    int rep = Integer.parseInt(setPic.substring(repPoint, i));
                    newPic.append(Variable.all(c, rep - 1));
                    continue block23;
                }
                default: {
                    if (!LogSetup.IS_LOGGING_INFO) continue block23;
                    LogSetup.LOGGER.info("calcPictureAndType(): switch(c) hit default case because c is invalid. c=" + c + ". setPic=" + setPic + ". ");
                }
            }
        }
        int type = -1;
        if (picChars == 1) {
            type = 4;
        }
        if ((picChars | 0x1E) == 30) {
            type = 1;
        }
        if (type == -1 && (picChars | 0x40023) == 262179) {
            type = 2;
        }
        if (type == -1 && (picChars | 0x401E3) == 262627 && (picChars & 0x21) != 0 && (picChars & 0x1C0) != 0) {
            type = 3;
        }
        if (type == 0) {
            type = 1;
        }
        if (type == -1 && (picChars | 0x3FFCE) == 262094) {
            type = 1;
        }
        if (type == -1) {
            CobolException.runtimeError("Variable(name,picture,initial_value) contains PICTURE of unknown type", null);
        }
        this.setTypeNumber((byte)type);
        String newPicString = newPic.toString();
        return newPicString;
    }

    public Variable(Object o) {
        this(String.valueOf(o));
    }

    static Variable newVariableOfSize(int size) {
        Variable newVariable = new Variable();
        newVariable.pointerMemory = new Memory(size, new String[0]);
        newVariable.itemSize = size;
        return newVariable;
    }

    public static Variable create(String setValue) {
        Variable result = new Variable();
        if (setValue == null) {
            setValue = SPACES_STRING;
        }
        result.itemSize = setValue.length();
        result.pointerMemory = new Memory(result.itemSize, new String[0]);
        result.setString(setValue);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkTrimGetSqlObject() {
        String s;
        block9: {
            try {
                s = System.getProperty("java.vm.vendor");
                if (s != null && s.toUpperCase().indexOf("ORACLE") >= 0) {
                    trimGetSqlObject = true;
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block9;
                LogSetup.LOGGER.info("catch (Exception e) 1st");
                e.printStackTrace();
            }
        }
        try {
            s = RuntimeEnvironment.getGlobalParameter("sql.trimright");
            if (s == null || s.length() <= 0) return;
            switch (s.charAt(0)) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    trimGetSqlObject = true;
                    return;
                }
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    trimGetSqlObject = false;
                    return;
                }
                default: {
                    if (!LogSetup.IS_LOGGING_INFO) return;
                    LogSetup.LOGGER.info("switch() hit default case because s=" + s + ". ");
                }
            }
            return;
        }
        catch (Exception e) {
            if (!LogSetup.IS_LOGGING_INFO) return;
            LogSetup.LOGGER.info("catch (Exception e) 2nd");
            e.printStackTrace();
        }
    }

    public final Variable getFromVariable() {
        return this.getDelayedVariable(this.fromVariable);
    }

    private final Variable getDelayedVariable(Object fromVariable) {
        block25: {
            Object[] list;
            if (fromVariable == null) {
                return null;
            }
            if (fromVariable instanceof Variable) {
                return (Variable)fromVariable;
            }
            if (fromVariable instanceof Object[] && (list = (Object[])fromVariable).length > 0) {
                try {
                    Variable baseVariable;
                    block26: {
                        baseVariable = (Variable)list[0];
                        int ref = 0;
                        int count = 0;
                        Object part = null;
                        int partValue = 0;
                        if (list.length <= 1) break block25;
                        for (int i = 1; i < list.length; ++i) {
                            if (list[i] == null) {
                                ref = i + 1;
                                break;
                            }
                            ++count;
                        }
                        if (count > 0) {
                            int[] dims = new int[count];
                            for (int i = 0; i < count; ++i) {
                                part = list[i + 1];
                                partValue = part instanceof IDatatype ? ((IDatatype)part).toInt() : (part instanceof Number ? ((Number)part).intValue() : 1);
                                try {
                                    dims[i] = partValue;
                                    continue;
                                }
                                catch (Exception e2) {
                                    dims[i] = 1;
                                    if (!LogSetup.IS_LOGGING_INFO) continue;
                                    LogSetup.LOGGER.info("catch (Exception e2)");
                                    e2.printStackTrace();
                                }
                            }
                            baseVariable = baseVariable.subscript(dims);
                        }
                        try {
                            int length;
                            int left;
                            block28: {
                                block27: {
                                    if (ref <= 0) break block26;
                                    left = ref;
                                    length = ref + 1;
                                    if (left >= list.length) {
                                        left = -1;
                                    }
                                    if (length >= list.length) {
                                        length = -1;
                                    }
                                    if (left >= 0) {
                                        try {
                                            part = list[left];
                                            left = part instanceof IDatatype ? ((IDatatype)part).toInt() : (part instanceof Number ? ((Number)part).intValue() : 1);
                                        }
                                        catch (Exception e) {
                                            left = -1;
                                            if (!LogSetup.IS_LOGGING_INFO) break block27;
                                            LogSetup.LOGGER.info("catch (Exception e)");
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                if (length >= 0) {
                                    try {
                                        part = list[length];
                                        length = part instanceof IDatatype ? ((IDatatype)part).toInt() : (part instanceof Number ? ((Number)part).intValue() : 1);
                                    }
                                    catch (Exception e) {
                                        length = -1;
                                        if (!LogSetup.IS_LOGGING_INFO) break block28;
                                        LogSetup.LOGGER.info("catch (Exception e)");
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (left >= 0 && length >= 0) {
                                baseVariable = baseVariable.ref(left, length);
                            } else if (left >= 0) {
                                baseVariable = baseVariable.ref(left);
                            }
                        }
                        catch (Exception refException) {
                            if (!LogSetup.IS_LOGGING_INFO) break block26;
                            LogSetup.LOGGER.info("catch (Exception refException)");
                            refException.printStackTrace();
                        }
                    }
                    return baseVariable;
                }
                catch (Exception e) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (Exception e)");
                        e.printStackTrace();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public final Variable getToVariable() {
        return this.getDelayedVariable(this.toVariable);
    }

    public final void setFromVariable(Object from) {
        this.fromVariable = from;
    }

    public final void setToVariable(Object to) {
        this.toVariable = to;
    }

    public final ScreenProperty getScreenProperty() {
        return this.screenProperty;
    }

    public final void setScreenProperty(ScreenProperty property) {
        this.screenProperty = property;
    }

    public final void removeScreenProperty() {
        this.screenProperty = null;
    }

    public final boolean hasScreenProperty() {
        return this.screenProperty != null;
    }

    public final ScreenProperty screenProperty() {
        if (this.screenProperty == null) {
            this.screenProperty = new ScreenProperty();
            this.setScreen();
        }
        return this.screenProperty;
    }

    public final void setFAC(String fac) {
        if (fac != null && fac.length() > 0) {
            this.setFAC(fac.charAt(0));
        }
    }

    public final void setFAC(int fac) {
        if (this.screenProperty != null) {
            this.screenProperty.setFAC(fac);
        }
    }

    public final int getFAC() {
        return this.screenProperty != null ? this.screenProperty.getFAC() : 0;
    }

    public final boolean isAlteredFAC() {
        return true;
    }

    public final boolean isFAC(String text) {
        if (text != null && text.length() > 0) {
            return this.isFAC(text.charAt(0));
        }
        return false;
    }

    public final boolean isFAC(int facMask) {
        int fac = this.getFAC();
        return (fac & facMask) == facMask;
    }

    private static String StringOf(byte[] source, int offset, int length) {
        char[] dest = new char[length];
        for (int i = 0; i < length; ++i) {
            dest[i] = (char)(source[offset++] & 0xFF);
        }
        return new String(dest);
    }

    public static byte[] byteArrayOf(String param) {
        if (param == null) {
            return null;
        }
        byte[] asBytes = param.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = param.getBytes(memoryCharset);
            for (int j = 0; j < asBytes.length; ++j) {
                if (asBytes[j] == -1) continue;
                asBytes[j] = ebcdicBytes[j];
            }
        }
        return asBytes;
    }

    public String getClassName() {
        return "com.heirloomcomputing.ecs.exec.Variable";
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.length());
    }

    public byte[] toByteArray(int length) {
        if (this.pointerMemory == null) {
            return null;
        }
        this.flushToMemory();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Before 'System.arraycopy(): Variable name=" + this.getName() + ". 'memory' is a byte[]. pointerMemory.memory.length=" + this.pointerMemory.getTopOfMemory() + ". Number of bytes to copy is length=itemsize=" + length + ". Copy starting at byte # pointerAddress=" + this.pointerAddress + ". pointerAddress+length=" + (this.pointerAddress + length));
        }
        byte[] result = new byte[length];
        if (this.pointerMemory.getTopOfMemory() < this.pointerAddress + length) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("'ERROR -ABORT: System;arraycopy() will cause java.lang.ArrayIndexOutOfBoundsException: Variable name=" + this.getName() + ". 'memory' is a byte[]. pointerMemory.memory.length=" + this.pointerMemory.getTopOfMemory() + ". Number of bytes to copy is length=itemsize=" + length + ". Copy starting at byte # pointerAddress=" + this.pointerAddress + ". pointerAddress+length=" + (this.pointerAddress + length));
            }
            length = this.pointerMemory.getTopOfMemory();
        }
        this.pointerMemory.copy(this.pointerAddress, result, 0, length);
        return result;
    }

    @Override
    public void fromByteArray(byte[] source) {
        if (this.pointerMemory == null) {
            return;
        }
        int sourceLength = source.length;
        int length = this.length();
        if (sourceLength > length) {
            sourceLength = length;
        }
        this.writeBytesToMemory(source, 0, sourceLength);
    }

    public void writeBytesToMemory(byte[] bytes, int offset, int len) {
        this.prepareMemoryForWrite();
        this.pointerMemory.copy(bytes, offset, this.pointerAddress, len);
    }

    public int getStorageClass() {
        return -1;
    }

    public final Variable setInternational() {
        this.flagBits |= 0x60;
        if (this.parent != null) {
            this.parent.setContainsInternational(true);
        }
        return this;
    }

    public final Variable setInternational(boolean state) {
        this.flagBits = state ? (this.flagBits |= 0x60) : (this.flagBits &= 0xFFFFFF9F);
        if (this.parent != null) {
            this.parent.setContainsInternational(state);
        }
        return this;
    }

    public final Variable setContainsInternational(boolean state) {
        this.flagBits = state ? (this.flagBits |= 0x40) : (this.flagBits &= 0xFFFFFFBF);
        if (this.parent != null) {
            this.parent.setContainsInternational(state);
        }
        return this;
    }

    public final boolean isInternational() {
        return (this.flagBits & 0x20) != 0;
    }

    public final boolean isContainingInternational() {
        return (this.flagBits & 0x40) != 0;
    }

    public final boolean isUsageMisc() {
        return (this.flagBits & 0x1000000) != 0;
    }

    public final boolean isUsageExternalForm() {
        return (this.flagBits & 0x2000000) != 0;
    }

    protected final void setUsageMisc() {
        this.flagBits |= 0x1000000;
    }

    protected final void setUsageExternalForm() {
        this.flagBits |= 0x2000000;
    }

    public boolean isNative() {
        return (this.flagBits & 0x100) != 0;
    }

    public final void setNative(boolean state) {
        this.flagBits = state ? (this.flagBits |= 0x100) : (this.flagBits &= 0xFFFFFEFF);
    }

    private boolean isMovableAsNumericEdited() {
        return (this.flagBits & 0x3D000000) == 0xC000000;
    }

    public byte[] toIdxByteArray() {
        int i;
        this.flushToMemory();
        int picLength = 0;
        if (this.picArray != null) {
            picLength = this.picArray.length;
        }
        int initValueLength = 0;
        if (this.initValue != null) {
            initValueLength = this.initValue.length();
        }
        byte[] data = new byte[49 + picLength + initValueLength];
        data[0] = this.specialType;
        int address = 0;
        address = this.pointerAddress;
        byte[] examine = ConvertData.intToBytes(address);
        data[1] = examine[0];
        data[2] = examine[1];
        data[3] = examine[2];
        data[4] = examine[3];
        examine = ConvertData.intToBytes(picLength);
        data[5] = examine[0];
        data[6] = examine[1];
        data[7] = examine[2];
        data[8] = examine[3];
        examine = ConvertData.intToBytes(this.length());
        data[9] = examine[0];
        data[10] = examine[1];
        data[11] = examine[2];
        data[12] = examine[3];
        examine = ConvertData.intToBytes(0);
        data[13] = examine[0];
        data[14] = examine[1];
        data[15] = examine[2];
        data[16] = examine[3];
        data[17] = 0;
        data[18] = 0;
        data[19] = 0;
        data[20] = 0;
        examine = ConvertData.intToBytes(this.minIndex);
        data[21] = examine[0];
        data[22] = examine[1];
        data[23] = examine[2];
        data[24] = examine[3];
        examine = ConvertData.intToBytes(this.maxIndex);
        data[25] = examine[0];
        data[26] = examine[1];
        data[27] = examine[2];
        data[28] = examine[3];
        data[29] = 0;
        data[30] = 0;
        data[31] = this.signPosition;
        data[32] = (byte)(this.flagBits >> 3 & 3);
        data[33] = (byte)this.flagBits;
        data[34] = this.place;
        data[35] = this.scale;
        data[36] = 0;
        examine = this.dependingOnVariable != null ? ConvertData.intToBytes(this.dependingOnVariable.toInt()) : ConvertData.intToBytes(-1);
        data[37] = examine[0];
        data[38] = examine[1];
        data[39] = examine[2];
        data[40] = examine[3];
        examine = ConvertData.intToBytes(picLength);
        data[41] = examine[0];
        data[42] = examine[1];
        data[43] = examine[2];
        data[44] = examine[3];
        examine = ConvertData.intToBytes(initValueLength);
        data[45] = examine[0];
        data[46] = examine[1];
        data[47] = examine[2];
        data[48] = examine[3];
        for (i = 0; i < picLength; ++i) {
            data[49 + i] = (byte)this.picArray[i];
        }
        for (i = 0; i < initValueLength; ++i) {
            data[49 + picLength + i] = (byte)this.initValue.charAt(i);
        }
        return data;
    }

    static Variable fromIdxByteArray(String className, byte[] data) {
        Variable result = null;
        try {
            result = (Variable)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            result = new Variable();
        }
        result.specialType = data[0];
        result.picLength = ConvertData.bytesToInt(data, 5);
        result.itemSize = ConvertData.bytesToInt(data, 9);
        result.pointerMemory = new Memory(result.itemSize, new String[0]);
        result.minIndex = ConvertData.bytesToInt(data, 21);
        result.maxIndex = ConvertData.bytesToInt(data, 25);
        result.signPosition = data[31];
        result.flagBits = data[33];
        result.place = data[34];
        result.scale = data[35];
        int dependingOnValue = ConvertData.bytesToInt(data, 37);
        result.dependingOnVariable = dependingOnValue == -1 ? null : new Numeric(dependingOnValue);
        int picLength = ConvertData.bytesToInt(data, 41);
        int initValueLength = ConvertData.bytesToInt(data, 45);
        if (picLength != 0) {
            String pic = Variable.StringOf(data, 49, picLength);
            result.picArray = new char[picLength];
            pic.getChars(0, picLength, result.picArray, 0);
        } else {
            result.picArray = null;
        }
        result.initValue = initValueLength != 0 ? Variable.StringOf(data, 49 + picLength, initValueLength) : null;
        result.calcPadding();
        return result;
    }

    static Variable fromIdxByteArray(String className, byte[] data, Memory memory, int offsetAddress) {
        Variable result = null;
        try {
            result = (Variable)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            result = new Variable();
        }
        result.alwaysFlush = memory.alwaysFlush;
        result.specialType = data[0];
        result.picLength = ConvertData.bytesToInt(data, 5);
        result.itemSize = ConvertData.bytesToInt(data, 9);
        result.pointerMemory = memory;
        result.pointerAddress = ConvertData.bytesToInt(data, 1) - offsetAddress;
        result.minIndex = ConvertData.bytesToInt(data, 21);
        result.maxIndex = ConvertData.bytesToInt(data, 25);
        result.signPosition = data[31];
        result.flagBits = data[33];
        result.place = data[34];
        result.scale = data[35];
        int dependingOnValue = ConvertData.bytesToInt(data, 37);
        result.dependingOnVariable = dependingOnValue == -1 ? null : new Numeric(dependingOnValue);
        int picLength = ConvertData.bytesToInt(data, 41);
        int initValueLength = ConvertData.bytesToInt(data, 45);
        if (picLength != 0) {
            String pic = Variable.StringOf(data, 49, picLength);
            result.picArray = new char[picLength];
            pic.getChars(0, picLength, result.picArray, 0);
        } else {
            result.picArray = null;
        }
        result.initValue = initValueLength != 0 ? Variable.StringOf(data, 49 + picLength, initValueLength) : null;
        result.calcPadding();
        return result;
    }

    public final int getEventHandler() {
        return this.eventHandler;
    }

    public final void setEventHandler(ICobolInterface program, int handler) {
        SynkronixGui.mapVariableToProgram(this, program);
        this.eventHandler = handler;
    }

    public final Object getGuiObject() {
        return this.guiObject;
    }

    public final void setGuiObject(Object o) {
        this.guiObject = o;
    }

    public final String special(Variable referenceVariable) {
        if (this.specialType == 0) {
            return null;
        }
        int length = referenceVariable.picLength;
        if (length <= 0) {
            length = referenceVariable.length();
        }
        char CURRENT_DECIMAL = this.getDecimal();
        switch (this.specialType) {
            case 1: {
                return Variable.all(this.toString(), length);
            }
            case 2: {
                return Variable.all('0', length);
            }
            case 3: {
                return Variable.all(' ', length);
            }
            case 6: {
                return Variable.all('\"', length);
            }
            case 9: {
                return Variable.all('\'', length);
            }
        }
        if (referenceVariable.isDefinedNumeric()) {
            switch (this.specialType) {
                case 4: {
                    return new StringBuffer(length + 1).append(Variable.all('9', length - referenceVariable.place)).append(CURRENT_DECIMAL).append(Variable.all('9', (int)referenceVariable.place)).toString();
                }
                case 5: {
                    if (referenceVariable.signPosition == 0) {
                        return new StringBuffer(length + 1).append(Variable.all('0', length - referenceVariable.place)).append(CURRENT_DECIMAL).append(Variable.all('0', (int)referenceVariable.place)).toString();
                    }
                    return new StringBuffer(length + 2).append('-').append(Variable.all('9', length - referenceVariable.place)).append(CURRENT_DECIMAL).append(Variable.all('9', (int)referenceVariable.place)).toString();
                }
            }
        } else {
            Memory memory = referenceVariable.pointerMemory;
            boolean signFound = false;
            switch (this.specialType) {
                case 4: {
                    String collatingSequence = memory.getCollatingSequence();
                    char[] carray = new char[length + 2];
                    int count = 0;
                    block41: for (int i = 0; i < length; ++i) {
                        switch (referenceVariable.getPic(i)) {
                            case 'P': {
                                carray[count++] = 48;
                                continue block41;
                            }
                            case 'S': {
                                carray[count++] = 32;
                                continue block41;
                            }
                            case 'A': 
                            case 'X': {
                                carray[count++] = collatingSequence == null ? Memory.HIGH : memory.getHighValue();
                                continue block41;
                            }
                            case '.': {
                                if (CURRENT_DECIMAL != '.') continue block41;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block41;
                            }
                            case ',': {
                                if (CURRENT_DECIMAL != ',') continue block41;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block41;
                            }
                            case 'V': {
                                if (CURRENT_DECIMAL != 'V') continue block41;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block41;
                            }
                            case '+': {
                                if (signFound) {
                                    carray[count++] = 57;
                                    continue block41;
                                }
                                carray[count++] = 43;
                                signFound = true;
                                continue block41;
                            }
                            case '-': {
                                if (signFound) {
                                    carray[count++] = 57;
                                    continue block41;
                                }
                                carray[count++] = 32;
                                signFound = true;
                                continue block41;
                            }
                            case 'C': {
                                signFound = true;
                                continue block41;
                            }
                            case 'D': {
                                signFound = true;
                                continue block41;
                            }
                            case '*': 
                            case '9': 
                            case 'Z': {
                                carray[count++] = 57;
                            }
                        }
                    }
                    return new String(carray, 0, count);
                }
                case 5: {
                    char[] carray = new char[length + 2];
                    int count = 0;
                    int lowdigit = 57;
                    if (referenceVariable.signPosition == 0) {
                        lowdigit = 48;
                    }
                    block42: for (int i = 0; i < length; ++i) {
                        switch (referenceVariable.getPic(i)) {
                            case 'P': {
                                carray[count++] = 48;
                                continue block42;
                            }
                            case 'S': {
                                carray[count++] = 32;
                                continue block42;
                            }
                            case 'A': 
                            case 'X': {
                                carray[count++] = memory == null ? (char)'\u0000' : memory.getLowValue();
                                continue block42;
                            }
                            case '.': {
                                if (CURRENT_DECIMAL != '.') continue block42;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block42;
                            }
                            case ',': {
                                if (CURRENT_DECIMAL != ',') continue block42;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block42;
                            }
                            case 'V': {
                                if (CURRENT_DECIMAL != 'V') continue block42;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block42;
                            }
                            case '+': {
                                if (signFound) {
                                    carray[count++] = lowdigit;
                                    continue block42;
                                }
                                if (lowdigit != 48) {
                                    carray[count++] = 45;
                                }
                                signFound = true;
                                continue block42;
                            }
                            case '-': {
                                if (signFound) {
                                    carray[count++] = lowdigit;
                                    continue block42;
                                }
                                if (lowdigit != 48) {
                                    carray[count++] = 45;
                                }
                                signFound = true;
                                continue block42;
                            }
                            case 'C': {
                                if (signFound) continue block42;
                                carray[count++] = 67;
                                carray[count++] = 82;
                                signFound = true;
                                continue block42;
                            }
                            case 'D': {
                                if (signFound) continue block42;
                                carray[count++] = 68;
                                carray[count++] = 66;
                                signFound = true;
                                continue block42;
                            }
                            case '*': 
                            case '9': 
                            case 'Z': {
                                carray[count++] = lowdigit;
                                continue block42;
                            }
                            default: {
                                if (!LogSetup.IS_LOGGING_INFO) continue block42;
                                LogSetup.LOGGER.info("switch() default case hit because referenceVariable.getPic(i)=" + referenceVariable.getPic(i) + " is unaccounted for. referenceVariable: " + referenceVariable.toDebugString2());
                            }
                        }
                    }
                    return new String(carray, 0, count);
                }
            }
        }
        return null;
    }

    public final char[] specialCharArray(Variable referenceVariable) {
        if (this.specialType == 0) {
            return null;
        }
        int length = referenceVariable.picLength;
        char CURRENT_DECIMAL = this.getDecimal();
        if (length <= 0) {
            length = referenceVariable.length();
        }
        switch (this.specialType) {
            case 1: {
                return Variable.allCharArray(this.toString(), length);
            }
            case 2: {
                return Variable.allCharArray('0', length);
            }
            case 3: {
                return Variable.allCharArray(' ', length);
            }
            case 6: {
                return Variable.allCharArray('\"', length);
            }
            case 9: {
                return Variable.allCharArray('\'', length);
            }
        }
        if (referenceVariable.isDefinedNumeric()) {
            switch (this.specialType) {
                case 4: {
                    if (SPECIAL_CHAR_HIGH_LOW_VALUES) {
                        char[] carray = new char[length];
                        for (int i = 0; i < length; ++i) {
                            carray[i] = 255;
                        }
                        return carray;
                    }
                    char[] carray = new char[++length];
                    for (int i = 0; i < length; ++i) {
                        carray[i] = 57;
                    }
                    carray[--length - referenceVariable.place] = CURRENT_DECIMAL;
                    return carray;
                }
                case 5: {
                    if (SPECIAL_CHAR_HIGH_LOW_VALUES) {
                        char[] carray = new char[length];
                        for (int i = 0; i < length; ++i) {
                            carray[i] = '\u0000';
                        }
                        return carray;
                    }
                    if (referenceVariable.signPosition == 0) {
                        char[] carray = new char[++length];
                        for (int i = 0; i < length; ++i) {
                            carray[i] = 48;
                        }
                        carray[--length - referenceVariable.place] = CURRENT_DECIMAL;
                        return carray;
                    }
                    char[] carray = new char[length += 2];
                    for (int i = 1; i < length; ++i) {
                        carray[i] = 57;
                    }
                    carray[0] = 45;
                    carray[(length -= 2) - referenceVariable.place + 1] = CURRENT_DECIMAL;
                    return carray;
                }
            }
        } else {
            Memory memory = referenceVariable.pointerMemory;
            boolean signFound = false;
            switch (this.specialType) {
                case 4: {
                    String collatingSequence = memory.getCollatingSequence();
                    char[] carray = new char[length + 2];
                    int count = 0;
                    block46: for (int i = 0; i < length; ++i) {
                        switch (referenceVariable.getPic(i)) {
                            case 'P': {
                                carray[count++] = 48;
                                continue block46;
                            }
                            case 'S': {
                                carray[count++] = 32;
                                continue block46;
                            }
                            case 'A': 
                            case 'X': {
                                carray[count++] = collatingSequence == null ? Memory.HIGH : memory.getHighValue();
                                continue block46;
                            }
                            case '.': {
                                if (CURRENT_DECIMAL != '.') continue block46;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block46;
                            }
                            case ',': {
                                if (CURRENT_DECIMAL != ',') continue block46;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block46;
                            }
                            case 'V': {
                                if (CURRENT_DECIMAL != 'V') continue block46;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block46;
                            }
                            case '+': {
                                if (signFound) {
                                    carray[count++] = 57;
                                    continue block46;
                                }
                                carray[count++] = 43;
                                signFound = true;
                                continue block46;
                            }
                            case '-': {
                                if (signFound) {
                                    carray[count++] = 57;
                                    continue block46;
                                }
                                carray[count++] = 32;
                                signFound = true;
                                continue block46;
                            }
                            case 'C': {
                                signFound = true;
                                continue block46;
                            }
                            case 'D': {
                                signFound = true;
                                continue block46;
                            }
                            case '*': 
                            case '9': 
                            case 'Z': {
                                carray[count++] = 57;
                                continue block46;
                            }
                            default: {
                                if (!LogSetup.IS_LOGGING_INFO) continue block46;
                                LogSetup.LOGGER.info("2 switch() default case hit because referenceVariable.getPic(i)=" + referenceVariable.getPic(i) + " is unaccounted for. referenceVariable: " + referenceVariable.toDebugString2());
                            }
                        }
                    }
                    if (count == carray.length) {
                        return carray;
                    }
                    char[] carray2 = new char[count];
                    System.arraycopy(carray, 0, carray2, 0, count);
                    return carray2;
                }
                case 5: {
                    char[] carray = new char[length + 2];
                    int count = 0;
                    int lowdigit = 57;
                    if (referenceVariable.signPosition == 0) {
                        lowdigit = 48;
                    }
                    block47: for (int i = 0; i < length; ++i) {
                        switch (referenceVariable.getPic(i)) {
                            case 'P': {
                                carray[count++] = 48;
                                continue block47;
                            }
                            case 'S': {
                                carray[count++] = 32;
                                continue block47;
                            }
                            case 'A': 
                            case 'X': {
                                carray[count++] = memory == null ? (char)'\u0000' : memory.getLowValue();
                                continue block47;
                            }
                            case '.': {
                                if (CURRENT_DECIMAL != '.') continue block47;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block47;
                            }
                            case ',': {
                                if (CURRENT_DECIMAL != ',') continue block47;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block47;
                            }
                            case 'V': {
                                if (CURRENT_DECIMAL != 'V') continue block47;
                                carray[count++] = CURRENT_DECIMAL;
                                continue block47;
                            }
                            case '+': {
                                if (signFound) {
                                    carray[count++] = lowdigit;
                                    continue block47;
                                }
                                if (lowdigit != 48) {
                                    carray[count++] = 45;
                                }
                                signFound = true;
                                continue block47;
                            }
                            case '-': {
                                if (signFound) {
                                    carray[count++] = lowdigit;
                                    continue block47;
                                }
                                if (lowdigit != 48) {
                                    carray[count++] = 45;
                                }
                                signFound = true;
                                continue block47;
                            }
                            case 'C': {
                                if (signFound) continue block47;
                                carray[count++] = 67;
                                carray[count++] = 82;
                                signFound = true;
                                continue block47;
                            }
                            case 'D': {
                                if (signFound) continue block47;
                                carray[count++] = 68;
                                carray[count++] = 66;
                                signFound = true;
                                continue block47;
                            }
                            case '*': 
                            case '9': 
                            case 'Z': {
                                carray[count++] = lowdigit;
                                continue block47;
                            }
                            default: {
                                if (!LogSetup.IS_LOGGING_INFO) continue block47;
                                LogSetup.LOGGER.info("3 switch() default case hit because referenceVariable.getPic(i)=" + referenceVariable.getPic(i) + " is unaccounted for. referenceVariable: " + referenceVariable.toDebugString2());
                            }
                        }
                    }
                    if (count == carray.length) {
                        return carray;
                    }
                    char[] carray2 = new char[count];
                    System.arraycopy(carray, 0, carray2, 0, count);
                    return carray2;
                }
            }
        }
        return null;
    }

    public final int getPlace() {
        return this.place;
    }

    public final void setPlace(int place) {
        this.place = (byte)place;
    }

    public final int getScale() {
        return this.scale;
    }

    public final void setScale(int scale) {
        this.scale = (byte)scale;
    }

    public final void setNull(boolean state) {
        this.setFlagBits(4096, state);
    }

    public final void setNull() {
        this.setFlagBits(4096);
    }

    public final void setNotNull() {
        this.clearFlagBits(4096);
    }

    public final boolean isNull() {
        return (this.flagBits & 0x1000) == 4096;
    }

    public final boolean isNotNull() {
        return (this.flagBits & 0x1000) != 4096;
    }

    public final boolean isVarChar() {
        return (this.flagBits & 0x2000) == 8192;
    }

    public final boolean isVarChar2() {
        return (this.flagBits & 0x8000) == 32768;
    }

    public final boolean isPreferredKey() {
        return (this.flagBits & 0x4000) == 16384;
    }

    public final boolean isArray() {
        return (this.flagBits & 0x20000) == 131072;
    }

    public final boolean isSignTrailing() {
        return (this.flagBits & 0x600000) != 0 && (this.flagBits & 0x200000) == 0;
    }

    private final boolean isAnyVarChar() {
        return (this.flagBits & 0xA000) != 0;
    }

    public final Variable setVarChar() {
        this.flagBits |= 0x2000;
        return this;
    }

    public final Variable setVarChar2() {
        this.flagBits |= 0x8000;
        return this;
    }

    public final Variable setPreferredKey() {
        this.flagBits |= 0x4000;
        return this;
    }

    public final void clearPreferredKey() {
        this.flagBits &= 0xFFFFBFFF;
    }

    public final Variable setArray() {
        this.flagBits |= 0x20000;
        return this;
    }

    public final void clearArray() {
        this.flagBits &= 0xFFFDFFFF;
    }

    public final void setScreen(boolean state) {
        this.setFlagBits(2048, state);
    }

    public final void setScreen() {
        this.setFlagBits(2048);
    }

    public final void clearScreen() {
        this.clearFlagBits(2048);
    }

    public final void setTableElement() {
        this.numericString = null;
        this.maxIndex = 1;
        this.minIndex = 1;
        this.notify = null;
        this.valid = false;
        this.dirty = false;
        this.setFlagBits(262144);
        this.notifyDelayed = true;
    }

    public final void clearTableElement() {
        this.clearFlagBits(262144);
    }

    public final boolean isTableElement() {
        return (this.flagBits & 0x40000) == 262144;
    }

    public final boolean isScreen() {
        return (this.flagBits & 0x800) == 2048;
    }

    public final void setPruneToCharacter(boolean state) {
        this.flagBits = state ? (this.flagBits |= 0x200) : (this.flagBits &= 0xFFFFFDFF);
    }

    public final void setPruneToCharacter() {
        this.flagBits |= 0x200;
    }

    public final void setPruneToGraphics(boolean state) {
        this.flagBits = state ? (this.flagBits |= 0x400) : (this.flagBits &= 0xFFFFFBFF);
    }

    public final void setPruneToGraphics() {
        this.flagBits |= 0x400;
    }

    public final boolean isPruneToCharacter() {
        return (this.flagBits & 0x200) == 512;
    }

    public final boolean isPruneToGraphics() {
        return (this.flagBits & 0x400) == 1024;
    }

    private final void setFlagBits(int value, boolean state) {
        if (state) {
            this.setFlagBits(value);
        } else {
            this.clearFlagBits(value);
        }
    }

    private final void setFlagBits(int value) {
        this.flagBits |= value;
    }

    private final void clearFlagBits(int value) {
        this.flagBits &= ~value;
    }

    public final boolean isJustRight() {
        return (this.flagBits & 1) != 0;
    }

    public final void setJustRight(boolean state) {
        this.setFlagBits(1, state);
    }

    public final boolean isFlagRedefines() {
        return (this.flagBits & 0x100000) != 0;
    }

    public final void setFlagRedefines(boolean state) {
        this.setFlagBits(0x100000, state);
    }

    public final Variable settingFlagRedefines(boolean state) {
        this.setFlagRedefines(state);
        return this;
    }

    public final boolean isBlankWhenZero() {
        return (this.flagBits & 2) != 0;
    }

    public final void setBlankWhenZero(boolean state) {
        this.setFlagBits(2, state);
    }

    public final Variable settingBlankWhenZero(boolean state) {
        this.setBlankWhenZero(state);
        return this;
    }

    public final boolean isStarredWhenZero() {
        return (this.flagBits & 0x80000) != 0;
    }

    public final void setStarredWhenZero(boolean state) {
        this.setFlagBits(524288, state);
    }

    public final Variable settingStarredWhenZero() {
        this.setStarredWhenZero(true);
        return this;
    }

    public final Variable settingStarredWhenZero(boolean state) {
        this.setStarredWhenZero(state);
        return this;
    }

    private final void calculateFlagsFromPicChars(int picChars) {
        if ((picChars & 0x1000) != 0 && (picChars & 2) == 0) {
            this.setStarredWhenZero(true);
        } else if ((picChars & 0x200) != 0 && (picChars & 2) == 0) {
            this.setBlankWhenZero(true);
        }
    }

    public final int getSignPosition() {
        return this.signPosition;
    }

    public final void setSignPosition(int signType) {
        this.signPosition = (byte)signType;
        this.calcPadding();
    }

    public final void setSignNone() {
        this.signPosition = 0;
        this.calcPadding();
    }

    public final void setSignLeading() {
        this.signPosition = (byte)2;
        this.calcPadding();
    }

    public final void setSignTrailing() {
        this.signPosition = (byte)3;
        this.calcPadding();
    }

    public final void setSignLeadingSeparate() {
        this.signPosition = (byte)4;
        this.calcPadding();
    }

    public final void setSignTrailingSeparate() {
        this.signPosition = (byte)5;
        this.calcPadding();
    }

    public final int getSync() {
        return (this.flagBits & 0x18) >> 3;
    }

    public final void setSync(int syncType) {
        this.clearFlagBits(24);
        this.setFlagBits(syncType << 3);
    }

    public final void setSyncNone() {
        this.clearFlagBits(24);
    }

    public final void setSyncLeft() {
        this.clearFlagBits(16);
        this.setFlagBits(8);
    }

    public final void setSyncRight() {
        this.clearFlagBits(8);
        this.setFlagBits(16);
    }

    public final int occurs() {
        if (this.dependingOnVariable == null || this.dependingOnVariable.pointerMemory == null) {
            return this.maxIndex;
        }
        return this.dependingOnVariable.toInt();
    }

    public final int subOccurs() {
        if (this.dependingOnVariable != null) {
            return this.dependingOnVariable.toInt();
        }
        if (this.isArray()) {
            return this.maxIndex;
        }
        if (this.firstChild != null) {
            return this.firstChild.subOccurs();
        }
        return 1;
    }

    public final int firstOccurs() {
        if (this.dependingOnVariable != null) {
            return this.dependingOnVariable.toInt();
        }
        if (this.isArray()) {
            return this.maxIndex;
        }
        if (this.parent != null) {
            return this.parent.firstOccurs();
        }
        return 1;
    }

    public final Variable getDependingOnVariable() {
        return this.dependingOnVariable;
    }

    public final int getMaxIndex() {
        return this.maxIndex;
    }

    protected final Variable findOdo() {
        if (this.getDependingOnVariable() != null) {
            return this;
        }
        Variable sibling = this.firstChild;
        while (sibling != null) {
            Variable child = sibling.findOdo();
            if (child != null) {
                return child;
            }
            sibling = sibling.nextSibling;
        }
        return null;
    }

    public final Variable odo() {
        Variable odo = this.findOdo();
        if (odo != null) {
            return this.odo(odo, -1, false);
        }
        return this;
    }

    public final Variable odo(Variable odo, int siblingSize, boolean inGroup) {
        if (siblingSize == -1) {
            return this.odoslide();
        }
        this.odoNoSlide = true;
        int currentItemSizeOfOdo = odo.itemSize * odo.occurs();
        Variable odoParent = odo.parent;
        int itemSizeOfOdoParent = currentItemSizeOfOdo + siblingSize;
        int difference = itemSizeOfOdoParent - odoParent.itemSize;
        if (difference != 0) {
            if (odoParent.resetItemSize == -1000) {
                odoParent.resetItemSize = odoParent.itemSize;
            }
            odoParent.itemSize = itemSizeOfOdoParent;
            Variable odoGrandParent = odoParent.parent;
            while (odoGrandParent != null) {
                difference *= odoGrandParent.maxIndex;
                if (odoGrandParent.resetItemSize == -1000) {
                    odoGrandParent.resetItemSize = odoGrandParent.itemSize;
                }
                odoGrandParent.itemSize += difference;
                odoGrandParent = odoGrandParent.parent;
            }
        }
        return this;
    }

    public static final void setUnusedVarsSizes(Variable var) {
        if (var.firstChild != null) {
            if (var.pointerAddress != var.firstChild.pointerAddress) {
                var.firstChild.unusedVarsTop = var.firstChild.pointerAddress - var.pointerAddress;
            }
            Variable.setUnusedVarsSizes(var.firstChild);
        }
        if (var.nextSibling != null) {
            if ((var.nextSibling.flagBits & 0x100000) != 0x100000 && var.pointerAddress + var.itemSize * var.maxIndex != var.nextSibling.pointerAddress) {
                var.unusedVarsBot = var.nextSibling.pointerAddress - (var.pointerAddress + var.itemSize * var.maxIndex);
            }
            Variable.setUnusedVarsSizes(var.nextSibling);
        }
        if (var.parent != null && var.nextSibling == null && (var.flagBits & 0x100000) != 0x100000 && var.parent.pointerAddress + var.parent.itemSize * var.parent.maxIndex != var.pointerAddress + var.itemSize * var.maxIndex) {
            var.unusedVarsBot = var.parent.pointerAddress + var.parent.itemSize * var.parent.maxIndex - (var.pointerAddress + var.itemSize * var.maxIndex);
        }
    }

    private final void adjust(int adjustedAddress) {
        if (this.firstChild == null) {
            return;
        }
        int adjustedSize = 0;
        int resetAdjustedAddress = 0;
        Variable child = this.firstChild;
        while (child != null) {
            if ((child.flagBits & 0x100000) == 0x100000) {
                resetAdjustedAddress = adjustedAddress;
                adjustedAddress = child.pointerAddress = child.redefinedFrom.pointerAddress;
            } else {
                if (child == this.firstChild) {
                    adjustedAddress += child.unusedVarsTop;
                    adjustedSize += child.unusedVarsTop;
                }
                child.pointerAddress = adjustedAddress;
            }
            child.adjust(adjustedAddress);
            int totalChildSize = child.itemSize * Math.max(Math.min(child.occurs(), child.maxIndex), child.minIndex);
            if (child.arrayChild != null) {
                Variable[] varArrayChild = (Variable[])child.arrayChild;
                int delta = adjustedAddress - varArrayChild[1].pointerAddress;
                if (delta != 0) {
                    for (int i0 = 1; i0 < varArrayChild.length; ++i0) {
                        varArrayChild[i0].pointerAddress += delta;
                    }
                }
            }
            if ((child.flagBits & 0x100000) == 0x100000) {
                adjustedAddress = resetAdjustedAddress;
            } else {
                adjustedAddress += totalChildSize + child.unusedVarsBot;
                adjustedSize += totalChildSize + child.unusedVarsBot;
            }
            child = child.nextSibling;
        }
        if (this.resetItemSize == -1000 && this.itemSize != adjustedSize) {
            this.resetItemSize = this.itemSize;
        }
        this.itemSize = adjustedSize;
    }

    public final Variable odoslide() {
        Variable top = this;
        while (top.parent != null) {
            top = top.parent;
        }
        top.adjust(top.pointerAddress);
        return this;
    }

    public final Variable rodo(Variable odo, int siblingSize, boolean inGroup) {
        if (!ODOMoveLenCheck || !inGroup) {
            this.odo(odo, siblingSize, inGroup);
        } else {
            boolean anythingChanged = false;
            while (odo != null) {
                if (odo.resetItemSize != -1000) {
                    if (odo.itemSize != odo.resetItemSize) {
                        anythingChanged = true;
                        odo.itemSize = odo.resetItemSize;
                    }
                    odo.resetItemSize = -1000;
                }
                odo = odo.parent;
            }
            if (siblingSize != -1 || anythingChanged) {
                // empty if block
            }
        }
        return this;
    }

    public Numeric odoNumeric() {
        return (Numeric)this.odo();
    }

    public Numeric odoNumeric(Variable odo, int siblingSize, boolean inGroup) {
        return (Numeric)this.odo(odo, siblingSize, inGroup);
    }

    public final int dimensions() {
        int dim = 0;
        Variable parent = this;
        do {
            if (!parent.isArray()) continue;
            ++dim;
        } while ((parent = parent.parent) != null);
        return dim;
    }

    public final Object[] createArray() {
        if (this.arrayChild != null) {
            return this.arrayChild;
        }
        int dims = this.dimensions();
        if (this.isNumericInstance()) {
            switch (dims) {
                case 1: {
                    this.arrayChild = this.createNumericArray1();
                    return this.arrayChild;
                }
                case 2: {
                    this.arrayChild = this.createNumericArray2();
                    return this.arrayChild;
                }
                case 3: {
                    this.arrayChild = this.createNumericArray3();
                    return this.arrayChild;
                }
                case 4: {
                    this.arrayChild = this.createNumericArray4();
                    return this.arrayChild;
                }
                case 5: {
                    this.arrayChild = this.createNumericArray5();
                    return this.arrayChild;
                }
                case 6: {
                    this.arrayChild = this.createNumericArray6();
                    return this.arrayChild;
                }
                case 7: {
                    this.arrayChild = this.createNumericArray7();
                    return this.arrayChild;
                }
                case 8: {
                    this.arrayChild = this.createNumericArray8();
                    return this.arrayChild;
                }
            }
        } else {
            switch (dims) {
                case 1: {
                    this.arrayChild = this.createArray1();
                    return this.arrayChild;
                }
                case 2: {
                    this.arrayChild = this.createArray2();
                    return this.arrayChild;
                }
                case 3: {
                    this.arrayChild = this.createArray3();
                    return this.arrayChild;
                }
                case 4: {
                    this.arrayChild = this.createArray4();
                    return this.arrayChild;
                }
                case 5: {
                    this.arrayChild = this.createArray5();
                    return this.arrayChild;
                }
                case 6: {
                    this.arrayChild = this.createArray6();
                    return this.arrayChild;
                }
                case 7: {
                    this.arrayChild = this.createArray7();
                    return this.arrayChild;
                }
                case 8: {
                    this.arrayChild = this.createArray8();
                    return this.arrayChild;
                }
            }
        }
        return null;
    }

    public final int dimension(int n) {
        int dim = 0;
        Variable parent = this;
        do {
            if (parent.isArray()) {
                ++dim;
            }
            if (dim != n) continue;
            return parent.maxIndex;
        } while ((parent = parent.parent) != null);
        return 1;
    }

    public void upperBound(int idx, int n) {
        int dim = 0;
        Variable parent = this;
        do {
            if (parent.isArray()) {
                ++dim;
            }
            if (dim != n) continue;
            if (parent.dependingOnVariable != null) {
                if (parent.dependingOnVariable.toInt() == 0) {
                    this.maxDim[idx] = parent.maxIndex;
                } else {
                    this.dependsVars[idx] = parent.dependingOnVariable;
                }
            } else {
                this.maxDim[idx] = parent.maxIndex;
            }
            return;
        } while ((parent = parent.parent) != null);
        this.maxDim[idx] = 1;
    }

    public int lowerBound(int n) {
        int dim = 0;
        Variable parent = this;
        do {
            if (parent.isArray()) {
                ++dim;
            }
            if (dim != n) continue;
            return parent.minIndex;
        } while ((parent = parent.parent) != null);
        return 1;
    }

    public final int dimensionTotal() {
        Variable parent = this;
        int n = 1;
        do {
            n *= parent.maxIndex;
        } while ((parent = parent.parent) != null);
        return n;
    }

    protected Variable setupSubscript(int offset) {
        this.setAddress(offset);
        this.arrayChild = null;
        this.setTableElement();
        return this;
    }

    public Variable subscript(int[] usingIndex) {
        try {
            Variable temp = this;
            Variable result = (Variable)this.clone();
            int dimension = usingIndex.length - 1;
            int offset = this.pointerAddress;
            while (true) {
                int dimension_subscript;
                if (temp != null && !temp.isArray()) {
                    temp = temp.parent;
                    continue;
                }
                if (temp == null) {
                    CobolException.runtimeError("Table Subscript has illegal depth on " + this.getName() + ".", null);
                    return null;
                }
                if ((dimension_subscript = usingIndex[dimension--] - 1) >= temp.maxIndex || dimension_subscript < 0) {
                    CobolException.runtimeError("Illegal Table Subscript " + (dimension_subscript + 1) + " for size " + temp.maxIndex + " on " + this.getName() + ".", null);
                    return null;
                }
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    return result.setupSubscript(offset);
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    private final Variable updateSubscript(int[] usingIndex, Memory memory, int offset) {
        try {
            Variable temp = this;
            int dimension = usingIndex.length - 1;
            while (true) {
                if (temp != null && !temp.isArray()) {
                    temp = temp.parent;
                    continue;
                }
                if (temp == null) {
                    CobolException.runtimeError("Table Subscript has illegal depth on " + this.getName() + ".", null);
                    return null;
                }
                int dimension_subscript = usingIndex[dimension--] - 1;
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    this.alwaysFlush = memory.alwaysFlush;
                    this.pointerMemory = memory;
                    this.pointerAddress = offset;
                    this.setTableElement();
                    return this;
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    public final Variable subscript(int n1) {
        return this.subscript(new int[]{n1});
    }

    public final Variable subscript(int n1, int n2) {
        return this.subscript(new int[]{n1, n2});
    }

    public final Variable subscript(int n1, int n2, int n3) {
        return this.subscript(new int[]{n1, n2, n3});
    }

    public final Variable subscript(int n1, int n2, int n3, int n4) {
        return this.subscript(new int[]{n1, n2, n3, n4});
    }

    public final Variable subscript(int n1, int n2, int n3, int n4, int n5) {
        return this.subscript(new int[]{n1, n2, n3, n4, n5});
    }

    public final Variable subscript(int n1, int n2, int n3, int n4, int n5, int n6) {
        return this.subscript(new int[]{n1, n2, n3, n4, n5, n6});
    }

    public final Variable subscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.subscript(new int[]{n1, n2, n3, n4, n5, n6, n7});
    }

    public final Variable subscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.subscript(new int[]{n1, n2, n3, n4, n5, n6, n7, n8});
    }

    public Numeric numericSubscript(int[] usingIndex) {
        try {
            Variable temp = this;
            Numeric result = (Numeric)this.clone();
            int dimension = usingIndex.length - 1;
            int offset = this.pointerAddress;
            while (true) {
                int dimension_subscript;
                if (temp != null && !temp.isArray()) {
                    temp = temp.parent;
                    continue;
                }
                if (temp == null) {
                    CobolException.runtimeError("Table Subscript has illegal depth on " + this.getName() + ".", null);
                    return null;
                }
                if ((dimension_subscript = usingIndex[dimension--] - 1) >= temp.maxIndex || dimension_subscript < 0) {
                    CobolException.runtimeError("Illegal Table Subscript " + (dimension_subscript + 1) + " for size " + temp.maxIndex + " on " + this.getName() + ".", null);
                    return null;
                }
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    result.setupSubscript(offset);
                    return result;
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    public Numeric updateNumericSubscript(int[] usingIndex, Memory memory, int offset) {
        try {
            Variable temp = this;
            int dimension = usingIndex.length - 1;
            while (true) {
                if (temp != null && !temp.isArray()) {
                    temp = temp.parent;
                    continue;
                }
                if (temp == null) {
                    CobolException.runtimeError("Table Subscript has illegal depth on " + this.getName() + ".", null);
                    return null;
                }
                int dimension_subscript = usingIndex[dimension--] - 1;
                offset += dimension_subscript * temp.itemSize;
                if (dimension < 0) {
                    this.alwaysFlush = true;
                    this.pointerMemory = memory;
                    this.pointerAddress = offset;
                    this.setTableElement();
                    return (Numeric)this;
                }
                temp = temp.parent;
            }
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    public Numeric numericSubscript(int n1) {
        return this.numericSubscript(new int[]{n1});
    }

    public Numeric numericSubscript(int n1, int n2) {
        return this.numericSubscript(new int[]{n1, n2});
    }

    public Numeric numericSubscript(int n1, int n2, int n3) {
        return this.numericSubscript(new int[]{n1, n2, n3});
    }

    public Numeric numericSubscript(int n1, int n2, int n3, int n4) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4});
    }

    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5});
    }

    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5, int n6) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5, n6});
    }

    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7});
    }

    public Numeric numericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return this.numericSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7, n8});
    }

    public Numeric updateNumericSubscript(int n1, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, int n3, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2, n3}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, int n3, int n4, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2, n3, n4}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, int n3, int n4, int n5, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2, n3, n4, n5}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2, n3, n4, n5, n6}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7}, memory, offset);
    }

    public Numeric updateNumericSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Memory memory, int offset) {
        return this.updateNumericSubscript(new int[]{n1, n2, n3, n4, n5, n6, n8}, memory, offset);
    }

    private Variable updateSubscript(int n1, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, int n3, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2, n3}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, int n3, int n4, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2, n3, n4}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, int n3, int n4, int n5, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2, n3, n4, n5}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, int n3, int n4, int n5, int n6, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2, n3, n4, n5, n6}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7}, memory, offset);
    }

    private Variable updateSubscript(int n1, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Memory memory, int offset) {
        return this.updateSubscript(new int[]{n1, n2, n3, n4, n5, n6, n7, n8}, memory, offset);
    }

    public final Variable ref() {
        int length;
        for (length = this.itemSize - 1; length >= 0 && (this.pointerMemory.getByte(this.pointerAddress + length) == 32 || this.pointerMemory.getByte(this.pointerAddress + length) == 0); --length) {
        }
        return this.ref(1, length + 1);
    }

    public final Variable ref(int start) {
        return this.ref(start, this.itemSize - start + 1);
    }

    public final Variable ref(int start, int length) {
        this.flushToMemory();
        if (start < 1) {
            if ("5".equals(DataType)) {
                start = 1;
            } else {
                CobolException.runtimeError("Invalid reference modifier start (" + start + ")");
                return this;
            }
        }
        Variable result = new Variable(this);
        --start;
        if (this.isInternational()) {
            start *= 2;
            length *= 2;
        }
        result.setAddress(this.pointerAddress + start);
        int refLength = this.refLength();
        if (start + length > refLength) {
            length -= start + length - refLength;
        }
        result.itemSize = result.maxItemSize = length;
        result.picArray = null;
        result.picLength = 0;
        result.minIndex = 1;
        result.maxIndex = 1;
        result.dependingOnVariable = null;
        result.redefinedFrom = null;
        result.redefinedTo = null;
        result.numericString = null;
        if (result.notify == null) {
            result.notify = new QuickVector(this);
            this.notifyDelayed = false;
        } else {
            result.notify = result.notify.copy();
            result.notify.addElement(this);
        }
        result.flagBits = this.flagBits;
        result.flagBits &= 0xC3FFFFFF;
        result.setUsageMisc();
        result.xmlBits = this.xmlBits;
        result.format = this.format;
        result.isrefmod = true;
        return result;
    }

    final char getPic(int n) {
        if (n < 0 || n > this.itemSize) {
            return '\u0000';
        }
        if (this.picArray != null) {
            return this.picArray[n];
        }
        return this.isTypeNumeric() ? (char)'9' : 'X';
    }

    final char[] getPictureArray() {
        return this.picArray;
    }

    private void calculatePicture(String setValue) {
        int setValueLength = setValue.length();
        char[] newPicArray = new char[setValueLength];
        int counter = 0;
        boolean signFound = false;
        boolean decimalFound = false;
        char CURRENT_DECIMAL = this.getDecimal();
        this.place = 0;
        this.scale = 0;
        this.signPosition = 0;
        this.itemSize = 0;
        int picChars = 0;
        this.flagBits &= 0xC3FFFFFF;
        block5: for (int i = 0; i < setValueLength; ++i) {
            char c = setValue.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    picChars |= 2;
                    newPicArray[counter++] = 57;
                    if (decimalFound) {
                        this.place = (byte)(this.place + 1);
                    }
                    ++this.itemSize;
                    continue block5;
                }
                case ',': 
                case '.': {
                    if (decimalFound) {
                        picChars = 32;
                        this.picLength = this.itemSize = setValueLength;
                        this.picArray = null;
                        return;
                    }
                    picChars |= 0x800;
                    newPicArray[counter++] = CURRENT_DECIMAL;
                    ++this.itemSize;
                    decimalFound = true;
                    continue block5;
                }
                case '+': 
                case '-': {
                    if (i == 0) {
                        if (signFound) {
                            picChars = 32;
                            this.picLength = this.itemSize = setValueLength;
                            this.picArray = null;
                            return;
                        }
                        newPicArray[counter++] = 43;
                        picChars |= 0x2000;
                        signFound = true;
                        this.signPosition = (byte)4;
                        ++this.itemSize;
                        continue block5;
                    }
                }
                default: {
                    picChars = 32;
                    this.picLength = this.itemSize = setValueLength;
                    this.picArray = null;
                    return;
                }
            }
        }
        this.picLength = counter;
        if (counter == setValueLength) {
            this.picArray = newPicArray;
        } else {
            this.picArray = new char[counter];
            System.arraycopy(newPicArray, 0, this.picArray, 0, counter);
        }
        this.calculateFlagsFromPicChars(picChars);
    }

    public boolean holdsValidNumeric() {
        if (this.pointerMemory == null) {
            return false;
        }
        this.flushToMemory();
        int offset = this.pointerAddress;
        int length = this.itemSize;
        char CURRENT_DECIMAL = this.getDecimal();
        byte b = 0;
        block3: for (int load = 0; load < length; ++load) {
            b = this.pointerMemory.getByte(offset++);
            switch (b) {
                case 44: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: {
                    continue block3;
                }
                default: {
                    if (b == CURRENT_DECIMAL) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isSpecial() {
        return this.specialType != 0;
    }

    private static boolean isEmptyString(String param) {
        return param == null || param.length() == 0;
    }

    public final boolean isFiller() {
        return (this.flagBits & 0x80) == 128;
    }

    public final String getName() {
        return this.name != null ? this.name : super.toString();
    }

    public final String getQualifiedCobolName() {
        String name2 = this.getName();
        name2 = name2.replace('_', '-');
        if (this.parent != null) {
            name2 = name2 + " of " + this.parent.getQualifiedCobolName();
        }
        return name2;
    }

    public final String getQualifiedName() {
        if (this.qualifiedName != null) {
            return this.qualifiedName;
        }
        this.qualifiedName = this.getName();
        if (this.parent != null) {
            this.qualifiedName = this.qualifiedName + "_OF_" + this.parent.getQualifiedName();
        }
        return this.qualifiedName;
    }

    public final void setName(String x) {
        this.name = x;
    }

    public final String getHyphenName() {
        if (this.name == null) {
            return null;
        }
        int i = this.name.indexOf(32);
        int j = this.name.indexOf(45);
        int k = this.name.indexOf(95);
        int max = Integer.MAX_VALUE;
        if (i < 0) {
            i = Integer.MAX_VALUE;
        }
        if (j < 0) {
            j = Integer.MAX_VALUE;
        }
        if (k < 0) {
            k = Integer.MAX_VALUE;
        }
        if (j < i) {
            i = j;
        }
        if (k < i) {
            i = k;
        }
        if (i == Integer.MAX_VALUE) {
            return this.name.toUpperCase();
        }
        return this.name.substring(0, i).toUpperCase();
    }

    public void init() {
        if (this.initValue != null) {
            this.move(this.initValue);
        }
    }

    public final boolean hasInitialValue() {
        return this.initValue != null;
    }

    public final boolean hasFormat() {
        return this.format != null;
    }

    final boolean isGroup() {
        return this.firstChild != null;
    }

    final boolean isChild() {
        return this.parent != null;
    }

    final boolean isElementary() {
        return this.firstChild == null;
    }

    public final Variable getParent() {
        return this.parent;
    }

    public final Variable getChild() {
        return this.firstChild;
    }

    public final Variable getChild(int n) {
        Variable temp = this.firstChild;
        while (n > 1) {
            temp = temp.nextSibling;
            if (temp == null) {
                return null;
            }
            --n;
        }
        return temp;
    }

    public final Object[] getDirectChildren() {
        Variable child = this.firstChild;
        ArrayList<Variable> rslt = new ArrayList<Variable>();
        while (child != null) {
            rslt.add(child);
            child = child.nextSibling;
        }
        return rslt.toArray();
    }

    public void validateNumericContent() {
        if (this.isGroup()) {
            Object[] children = this.getDirectChildren();
            for (int i = 0; i < children.length; ++i) {
                if (((Variable)children[i]).isGroup()) {
                    ((Variable)children[i]).validateNumericContent();
                    continue;
                }
                if (children[i] instanceof DisplayP) {
                    ((DisplayP)children[i]).value.setNumericValidate(true);
                    continue;
                }
                if (children[i] instanceof DisplayMVS) {
                    ((DisplayMVS)children[i]).value.setNumericValidate(true);
                    continue;
                }
                if (!(children[i] instanceof PackedDecimalI)) continue;
                Object[] arrayElements = ((PackedDecimalI)children[i]).getElements();
                if (arrayElements != null) {
                    if (arrayElements.getClass().getComponentType().getName().endsWith(".Variable;")) continue;
                    this.requestPendingArrayNumericValidation(arrayElements);
                    continue;
                }
                ((PackedDecimalI)children[i]).value.setNumericValidate(true);
            }
        }
    }

    void requestPendingArrayNumericValidation(Object[] arrayElements) {
        for (Object eachArrayElement : arrayElements) {
            if (eachArrayElement instanceof ArrayIndexOutOfBoundsVariable || eachArrayElement == null) continue;
            if (eachArrayElement.getClass().isArray()) {
                this.requestPendingArrayNumericValidation((Object[])eachArrayElement);
                continue;
            }
            if (eachArrayElement instanceof DisplayP) {
                ((DisplayP)eachArrayElement).value.setNumericValidate(true);
                continue;
            }
            if (eachArrayElement instanceof DisplayMVS) {
                ((DisplayMVS)eachArrayElement).value.setNumericValidate(true);
                continue;
            }
            if (!(eachArrayElement instanceof PackedDecimalI)) continue;
            ((PackedDecimalI)eachArrayElement).value.setNumericValidate(true);
        }
    }

    public final int getChildrenCount() {
        Variable temp = this.firstChild;
        int i = 0;
        while (temp != null) {
            temp = temp.nextSibling;
            ++i;
        }
        return i;
    }

    public final List<Variable> getChildrenWithArrayElementsAsItems() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Object[] children = this.getDirectChildren();
        for (int a = 0; a < children.length; ++a) {
            Variable v = (Variable)children[a];
            if (v instanceof ArrayIndexOutOfBoundsVariable) continue;
            Object[] arrayElements = v.getElements();
            if (v.isArray()) {
                for (int i = 0; i < arrayElements.length; ++i) {
                    Variable arrayElement = (Variable)arrayElements[i];
                    if (arrayElement instanceof ArrayIndexOutOfBoundsVariable) continue;
                    arrayElement.subscript = i;
                    result.add(arrayElement);
                }
                continue;
            }
            if (v.arrayChild == null) {
                result.add(v);
                continue;
            }
            Variable arrayElement2 = (Variable)arrayElements[this.subscript];
            result.add(arrayElement2);
        }
        return result;
    }

    public final ArrayList<Variable> getElementaryItems() {
        ArrayList<Variable> elementaryItems = new ArrayList<Variable>();
        if (this.isElementary()) {
            elementaryItems.add(this);
            return elementaryItems;
        }
        Variable child = this.firstChild;
        while (child != null) {
            if (child.isElementary()) {
                elementaryItems.add(child);
                child = child.nextSibling;
                continue;
            }
            ArrayList<Variable> cei = child.getElementaryItems();
            elementaryItems.addAll(cei);
            child = child.nextSibling;
        }
        return elementaryItems;
    }

    public final Variable getSibling() {
        return this.nextSibling;
    }

    final Variable setChild(Variable x) {
        this.firstChild = x;
        return this.firstChild;
    }

    final Variable setParent(Variable x) {
        this.parent = x;
        return this.parent;
    }

    final Variable setSibling(Variable x) {
        this.nextSibling = x;
        return this.nextSibling;
    }

    public final int getRecordPosition() {
        Variable current = this;
        Variable checkParent = null;
        while ((checkParent = current.parent) != null) {
            current = checkParent;
        }
        return this.pointerAddress - current.pointerAddress;
    }

    public Variable setExternal(Context context) {
        return this.setExternal(context, this.getName());
    }

    public Variable setExternal(Context context, String byName) {
        Variable master = (Variable)context.getExternal(this, byName);
        if (master != null) {
            this.redefines(master);
        }
        return this;
    }

    final Display surrogate() {
        if (this.surrogate == null) {
            int displayItemSize = 0;
            boolean signFound = false;
            boolean currencyFound = false;
            char currency = this.getCurrency();
            for (int i = 0; i < this.picLength; ++i) {
                char c = this.getPic(i);
                switch (c) {
                    case '+': 
                    case '-': {
                        if (signFound) {
                            ++displayItemSize;
                        }
                        signFound = true;
                        break;
                    }
                    case '*': 
                    case '9': 
                    case 'Z': {
                        ++displayItemSize;
                        break;
                    }
                    default: {
                        if (!LogSetup.IS_LOGGING_INFO) break;
                        LogSetup.LOGGER.info("5 switch() default case hit because c=" + c + " is unaccounted for. ");
                    }
                }
                if (c != currency) continue;
                if (currencyFound) {
                    ++displayItemSize;
                }
                currencyFound = true;
            }
            this.surrogate = new Display(displayItemSize, this.place, this.scale, signFound ? (byte)3 : 0);
        }
        return this.surrogate;
    }

    public Variable declare(Variable renames, Variable renamesThrough) {
        this.isRenames = 1;
        this.specialType = renames.specialType;
        this.pointerMemory = renames.pointerMemory;
        this.pointerAddress = renames.pointerAddress;
        this.alwaysFlush = renames.alwaysFlush;
        this.name = renames.name;
        this.initValue = renames.initValue;
        this.picLength = renames.picLength;
        this.itemSize = renames.itemSize;
        this.parent = renames.parent;
        this.firstChild = renames.firstChild;
        this.nextSibling = renames.nextSibling;
        this.minIndex = renames.minIndex;
        this.maxIndex = renames.maxIndex;
        this.dependingOnVariable = renames.dependingOnVariable;
        this.redefinedFrom = renames.redefinedFrom;
        this.redefinedTo = renames.redefinedTo;
        this.signPosition = renames.signPosition;
        this.flagBits = renames.flagBits;
        this.xmlBits = renames.xmlBits;
        this.format = renames.format;
        this.place = renames.place;
        this.scale = renames.scale;
        this.surrogate = renames.surrogate;
        this.itemSize = renamesThrough.pointerAddress + renamesThrough.itemSize - renames.pointerAddress;
        this.flagBits &= 0xC3FFFFFF;
        this.flagBits &= 0xFFFFFFFE;
        this.setUsageMisc();
        this.pointerMemory.addNotify(this);
        this.notifyDelayed = false;
        this.calcStoreSize();
        this.calcPadding();
        return this;
    }

    public Variable declare(Variable renames) {
        this.isRenames = 1;
        this.specialType = renames.specialType;
        this.pointerMemory = renames.pointerMemory;
        this.pointerAddress = renames.pointerAddress;
        this.alwaysFlush = renames.alwaysFlush;
        this.name = renames.name;
        this.initValue = renames.initValue;
        this.picLength = renames.picLength;
        this.itemSize = renames.itemSize;
        this.parent = renames.parent;
        this.firstChild = renames.firstChild;
        this.nextSibling = renames.nextSibling;
        this.minIndex = renames.minIndex;
        this.maxIndex = renames.maxIndex;
        this.dependingOnVariable = renames.dependingOnVariable;
        this.redefinedFrom = renames.redefinedFrom;
        this.redefinedTo = renames.redefinedTo;
        this.signPosition = renames.signPosition;
        this.flagBits = renames.flagBits;
        this.xmlBits = renames.xmlBits;
        this.format = renames.format;
        this.place = renames.place;
        this.scale = renames.scale;
        this.surrogate = renames.surrogate;
        this.fromVariable = renames.fromVariable;
        this.toVariable = renames.toVariable;
        this.screenProperty = renames.screenProperty;
        this.itemSize = renames.itemSize;
        this.pointerMemory.addNotify(this);
        this.notifyDelayed = false;
        this.calcStoreSize();
        this.calcPadding();
        return this;
    }

    public int getPicLength() {
        return this.picLength;
    }

    public final Variable declare(String setName, String setPic, String setValue, byte setType, byte setUsage, byte setSign, byte setSync, int setPlace, int setScale, Memory setMemory, int setPointer, int setItemSize, int setPicChars, int setSibOff, Variable setParent, Variable setChild, Variable setSibling, boolean setJust, boolean setBlank, int setMin, int setMax, Variable setDependingOnVariable) {
        this.flagBits = 0;
        this.xmlBits = 0;
        this.alwaysFlush = setMemory.alwaysFlush;
        this.initValue = setValue;
        this.name = setName;
        this.setTypeNumber(setType);
        this.maxItemSize = this.itemSize = setItemSize;
        this.parent = setParent;
        this.firstChild = setChild;
        this.nextSibling = setSibling;
        this.place = (byte)setPlace;
        this.scale = (byte)setScale;
        if (setUsage == 5) {
            this.setUsageMisc();
        } else if (setUsage == 36) {
            this.setUsageExternalForm();
        }
        this.signPosition = setSign;
        if (setPic != null) {
            this.picLength = setPic.length();
            this.picArray = new char[this.picLength];
            setPic.getChars(0, this.picLength, this.picArray, 0);
        } else {
            this.picArray = null;
            this.picLength = 0;
        }
        this.pointerMemory = setMemory;
        this.pointerAddress = setPointer;
        this.calcStoreSize();
        this.calcPadding();
        setMemory.addNotify(this);
        this.notifyDelayed = false;
        if (setValue != null) {
            this.setDirty();
        }
        this.minIndex = setMin;
        this.maxIndex = setMax;
        if (this.maxIndex > 1) {
            this.setArray();
            if (setDependingOnVariable != null) {
                this.dependingOnVariable = setDependingOnVariable;
                if (setMemory.isODOSlideMode()) {
                    setDependingOnVariable.flagBits |= 0x10000;
                }
            }
        } else {
            this.redefinedFrom = setDependingOnVariable;
            if (Cache.forbid) {
                if (setDependingOnVariable.redefinedTo == null) {
                    setDependingOnVariable.redefinedTo = new ArrayList(1);
                }
                setDependingOnVariable.redefinedTo.add(this);
            }
        }
        if (setValue != null) {
            this.flagBits |= 4;
            if ((this.flagBits & 0x3C000000) == 0x4000000) {
                this.move(setValue);
            } else {
                int correctFlagBits = this.flagBits;
                this.flagBits &= 0xC3FFFFFF;
                this.move(setValue);
                this.flagBits = correctFlagBits;
            }
        }
        if (this.parent == null) {
            Variable follow = this.firstChild;
            if (this.isArray()) {
                int[] dimensionParameter = new int[1];
                while (follow != null) {
                    dimensionParameter[0] = this.maxIndex;
                    follow.initTable(dimensionParameter);
                    follow = follow.nextSibling;
                }
            } else {
                while (follow != null) {
                    follow.initTable(null);
                    follow = follow.nextSibling;
                }
            }
        }
        if (setSync != 0) {
            this.flagBits |= setSync << 3;
        }
        if (setJust) {
            this.flagBits |= 1;
        }
        if (setBlank) {
            this.flagBits |= 2;
        }
        if (this.maxIndex > 1) {
            this.flagBits |= 0x20000;
        }
        return this;
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, int setPicLen, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setPlace, int setScale) {
        return this.declare(memorySpace, offset, setItemSize, setName, NUMERIC_PICTURE[setPicLen], initialValue, setParent, setChild, setSibling, flagBits, setPlace, setScale);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, int setPicLen, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setMin, int setMax, Variable setDependingOnVariable) {
        return this.declare(memorySpace, offset, setItemSize, setName, NUMERIC_PICTURE[setPicLen], initialValue, setParent, setChild, setSibling, flagBits, setMin, setMax, setDependingOnVariable);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, int setPicLen, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits) {
        return this.declare(memorySpace, offset, setItemSize, setName, NUMERIC_PICTURE[setPicLen], initialValue, setParent, setChild, setSibling, flagBits);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, int setPicLen, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setPlace, int setScale, int setMin, int setMax, Variable setDependingOnVariable) {
        return this.declare(memorySpace, offset, setItemSize, setName, NUMERIC_PICTURE[setPicLen], initialValue, setParent, setChild, setSibling, flagBits, setPlace, setScale, setMin, setMax, setDependingOnVariable);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int setFlagBits) {
        Variable follow;
        String func = "Variable.declare() 5th: ";
        this.alwaysFlush = memorySpace.alwaysFlush;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable.declare() 5th: . setName=" + setName + ". offset=" + offset + ". setItemSize=" + setItemSize + ". setPic=" + setPic + ". initialValue=" + initialValue + ". memorySpace=" + memorySpace.getClass().getName() + ". alwaysFlush=" + this.alwaysFlush + ". ");
        }
        this.initValue = initialValue;
        this.name = setName;
        this.maxItemSize = this.itemSize = setItemSize;
        this.parent = setParent;
        this.firstChild = setChild;
        this.nextSibling = setSibling;
        this.flagBits = setFlagBits;
        if ((this.flagBits & 0x600000) != 0) {
            boolean separate;
            boolean bl = separate = (this.flagBits & 0x800000) != 0;
            this.signPosition = (this.flagBits & 0x200000) != 0 ? (byte)(separate ? 4 : 2) : (byte)(separate ? 5 : 3);
        } else {
            this.signPosition = 0;
        }
        if (setPic != null) {
            this.picArray = setPic.toCharArray();
            this.picLength = this.picArray.length;
        }
        this.pointerMemory = memorySpace;
        this.pointerAddress = offset;
        this.calcStoreSize();
        this.calcPadding();
        memorySpace.addNotify(this);
        this.notifyDelayed = false;
        int bufferFlagBits = this.flagBits;
        this.flagBits &= 0xFFF7FFE4;
        if (this.isTypeNumeric() || this.isTypeNumericEdited()) {
            this.setJustRight(true);
        }
        if (initialValue != null) {
            this.flagBits |= 4;
            char[] savePicArray = this.picArray;
            if (this.picArray != null) {
                this.picArray = new char[savePicArray.length];
                for (int i = 0; i < this.picArray.length; ++i) {
                    this.picArray[i] = 88;
                }
            }
            this.move(initialValue);
            this.picArray = savePicArray;
        } else if (this.isTypePointer()) {
            this.flagBits |= 4;
            ((DataPointer)this).setPointerNull();
        }
        if (setParent == null && (follow = this.firstChild) != null) {
            if (this.isArray()) {
                int[] dimensionParameter = new int[]{this.maxIndex};
                do {
                    follow.initTable(dimensionParameter);
                } while ((follow = follow.nextSibling) != null);
            } else {
                do {
                    follow.initTable(null);
                } while ((follow = follow.nextSibling) != null);
            }
        }
        this.flagBits |= bufferFlagBits;
        return this;
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, boolean True, byte[] initialValue, Variable setParent, Variable setChild, Variable setSibling, int setFlagBits) {
        this.declare(memorySpace, offset, setItemSize, setName, setPic, (String)null, setParent, setChild, setSibling, setFlagBits);
        if (initialValue != null) {
            this.initValue = new String(initialValue, defaultCharset);
            this.move(initialValue);
        }
        return this;
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String setPicForNumber, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int setFlagBits) {
        String func = "Variable.declare() num ed no decimal: ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable.declare() num ed no decimal: . setName=" + setName + ". offset=" + offset + ". setItemSize=" + setItemSize + ". setPic=" + setPic + ". setPicForNumber=" + setPicForNumber + ". initialValue=" + initialValue + ". ");
        }
        if (setPicForNumber != null) {
            this.picForNumberArray = setPicForNumber.toCharArray();
            this.picForNumberLength = this.picForNumberArray.length;
        }
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, setFlagBits);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setPlace, int setScale) {
        this.place = (byte)setPlace;
        this.scale = (byte)setScale;
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, flagBits);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String setPicForNumber, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setPlace, int setScale) {
        String func = "Variable.declare() num ed decimal: ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable.declare() num ed decimal: . setName=" + setName + ". offset=" + offset + ". setItemSize=" + setItemSize + ". setPic=" + setPic + ". setPicForNumber=" + setPicForNumber + ". initialValue=" + initialValue + ". ");
        }
        if (setPicForNumber != null) {
            this.picForNumberArray = setPicForNumber.toCharArray();
            this.picForNumberLength = this.picForNumberArray.length;
        }
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, flagBits, setPlace, setScale);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String setPicForNumber, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setPlace, int setScale, int setMin, int setMax, Variable setDependingOnVariable) {
        String func = "Variable.declare() num ed decimal w/ redefined: ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable.declare() num ed decimal w/ redefined: . setName=" + setName + ". offset=" + offset + ". setItemSize=" + setItemSize + ". setPic=" + setPic + ". setPicForNumber=" + setPicForNumber + ". initialValue=" + initialValue + ". ");
        }
        this.minIndex = setMin;
        this.maxIndex = setMax;
        if (this.maxIndex > 1) {
            flagBits |= 0x20000;
        }
        if ((flagBits & 0x100000) == 0x100000) {
            this.redefinedFrom = setDependingOnVariable;
            if (Cache.forbid) {
                if (setDependingOnVariable.redefinedTo == null) {
                    setDependingOnVariable.redefinedTo = new ArrayList(1);
                }
                setDependingOnVariable.redefinedTo.add(this);
            }
        } else if (setDependingOnVariable != null) {
            this.dependingOnVariable = setDependingOnVariable;
            if (memorySpace.isODOSlideMode()) {
                setDependingOnVariable.flagBits |= 0x10000;
            }
        }
        if (setPicForNumber != null) {
            this.picForNumberArray = setPicForNumber.toCharArray();
            this.picForNumberLength = this.picForNumberArray.length;
        }
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, flagBits, setPlace, setScale);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String setPicForNumber, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setMin, int setMax, Variable setDependingOnVariable) {
        this.picForNumberArray = setPicForNumber.toCharArray();
        this.picForNumberLength = this.picForNumberArray.length;
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, flagBits, setMin, setMax, setDependingOnVariable);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setMin, int setMax, Variable setDependingOnVariable) {
        this.minIndex = setMin;
        this.maxIndex = setMax;
        if (this.maxIndex > 1) {
            flagBits |= 0x20000;
        }
        if ((flagBits & 0x100000) == 0x100000) {
            this.redefinedFrom = setDependingOnVariable;
            if (Cache.forbid) {
                if (setDependingOnVariable.redefinedTo == null) {
                    setDependingOnVariable.redefinedTo = new ArrayList(1);
                }
                setDependingOnVariable.redefinedTo.add(this);
            }
        } else if (setDependingOnVariable != null) {
            this.dependingOnVariable = setDependingOnVariable;
            if (memorySpace.isODOSlideMode()) {
                setDependingOnVariable.flagBits |= 0x10000;
            }
        }
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, flagBits);
    }

    public final Variable declare(Memory memorySpace, int offset, int setItemSize, String setName, String setPic, String initialValue, Variable setParent, Variable setChild, Variable setSibling, int flagBits, int setPlace, int setScale, int setMin, int setMax, Variable setDependingOnVariable) {
        this.place = (byte)setPlace;
        this.scale = (byte)setScale;
        this.minIndex = setMin;
        this.maxIndex = setMax;
        if (this.maxIndex > 1) {
            flagBits |= 0x20000;
        }
        if ((flagBits & 0x100000) == 0x100000) {
            this.redefinedFrom = setDependingOnVariable;
            if (Cache.forbid) {
                if (setDependingOnVariable.redefinedTo == null) {
                    setDependingOnVariable.redefinedTo = new ArrayList(1);
                }
                setDependingOnVariable.redefinedTo.add(this);
            }
        } else if (setDependingOnVariable != null) {
            this.dependingOnVariable = setDependingOnVariable;
            if (memorySpace.isODOSlideMode()) {
                setDependingOnVariable.flagBits |= 0x10000;
            }
        }
        return this.declare(memorySpace, offset, setItemSize, setName, setPic, initialValue, setParent, setChild, setSibling, flagBits);
    }

    public void dynamicType(int type, byte[] memory, int offset, int length, int decimalPositions, int scale, int pictureLength) {
        this.itemSize = length;
        switch (type & 7) {
            case 0: {
                this.signPosition = 0;
                break;
            }
            case 1: {
                this.signPosition = (byte)2;
                this.flagBits |= 0x200000;
                break;
            }
            case 2: {
                this.signPosition = (byte)3;
                this.flagBits |= 0x400000;
                break;
            }
            case 3: {
                this.signPosition = (byte)4;
                this.flagBits |= 0xA00000;
                break;
            }
            case 4: {
                this.signPosition = (byte)5;
                this.flagBits |= 0xC00000;
            }
        }
        switch (type & 8) {
            case 0: {
                break;
            }
            case 8: {
                this.flagBits |= 1;
            }
        }
        switch (type & 0x70) {
            case 32: {
                this.flagBits |= 0x1000000;
                break;
            }
            case 64: {
                this.flagBits |= 0x1020000;
            }
        }
        if ((type & 0x1000) == 4096) {
            this.flagBits |= 0x100000;
        }
        this.pointerMemory = new Memory(memory);
        this.pointerAddress = offset;
        this.picLength = pictureLength;
        if (this.isTypeNumeric()) {
            this.picArray = NUMERIC_PICTURE[this.picLength].toCharArray();
        }
        this.calcStoreSize();
        this.calcPadding();
        this.place = (byte)decimalPositions;
        this.scale = (byte)scale;
    }

    public void calcStoreSize() {
    }

    public int getStoreSize() {
        return -1;
    }

    private final void initTable(int[] indexesSoFar) {
        int i;
        if (this.isArray()) {
            if (indexesSoFar == null) {
                indexesSoFar = new int[]{this.maxIndex};
            } else {
                int[] expand = new int[indexesSoFar.length + 1];
                for (i = 0; i < indexesSoFar.length; ++i) {
                    expand[i] = indexesSoFar[i];
                }
                expand[indexesSoFar.length] = this.maxIndex;
                indexesSoFar = expand;
            }
        }
        if (this.firstChild == null) {
            if ((this.flagBits & 4) == 0) {
                return;
            }
            if (indexesSoFar == null) {
                return;
            }
            int dimension = indexesSoFar.length;
            int totalInitElements = indexesSoFar[0];
            for (i = 1; i < dimension; ++i) {
                totalInitElements *= indexesSoFar[i];
            }
            int[] currentIndex = new int[dimension];
            for (i = 0; i < dimension; ++i) {
                currentIndex[i] = 1;
            }
            String currentValue = this.toString();
            boolean loop = false;
            int j = 0;
            for (i = 0; i < totalInitElements; ++i) {
                Variable element = this.subscript(currentIndex);
                element.setString(currentValue);
                element.fillFromMemory();
                j = 0;
                do {
                    loop = false;
                    currentIndex[j] = currentIndex[j] + 1;
                    if (currentIndex[j] <= indexesSoFar[j]) continue;
                    currentIndex[j] = 1;
                    ++j;
                    loop = true;
                } while (loop && j < dimension);
            }
            return;
        }
        Variable temp = this.firstChild;
        while (temp != null) {
            temp.initTable(indexesSoFar);
            temp = temp.nextSibling;
        }
    }

    public Object clone() {
        try {
            Variable copy = (Variable)super.clone();
            copy.pointerMemory = this.pointerMemory;
            copy.pointerAddress = this.pointerAddress;
            copy.right_array = null;
            copy.left_array = null;
            copy.commonAddr = null;
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupported) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception cloneNotSupported)");
                cloneNotSupported.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public comparableByteArray copy() {
        try {
            this.flushToMemory();
            Variable copy = (Variable)super.clone();
            copy.notify = null;
            copy.notifyDelayed = false;
            copy.right_array = null;
            copy.left_array = null;
            this.copy(copy);
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupported) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception cloneNotSupported)");
                cloneNotSupported.printStackTrace();
            }
            return null;
        }
    }

    public Variable cleanCopy() {
        Variable copy = (Variable)this.copy();
        copy.initData();
        return copy;
    }

    protected void copy(Variable copy) {
        copy.pointerMemory = this.pointerMemory instanceof UnbufferedMemory ? new UnbufferedMemory(this.length()) : (this.pointerMemory instanceof UnbufferedSpaceClearedMemory ? new UnbufferedSpaceClearedMemory(this.length()) : (this.pointerMemory instanceof ExternalUnbufferedMemory ? new ExternalUnbufferedMemory(this.length()) : (this.pointerMemory instanceof ExternalUnbufferedSpaceClearedMemory ? new ExternalUnbufferedSpaceClearedMemory(this.length()) : new Memory(this.length(), new String[0]))));
        copy.pointerAddress = 0;
        Memory newMemory = copy.pointerMemory;
        Memory memory = this.pointerMemory;
        newMemory.setDecimal(memory.getDecimal());
        newMemory.setComma(memory.getComma());
        newMemory.setCurrency(memory.getCurrency());
        newMemory.setCollatingSequence(memory.getCollatingSequence());
        newMemory.copy(memory, this.pointerAddress, 0, this.length());
    }

    Variable createKeyFromBytes(byte[] tempBytes, int masterRecordAddress) {
        int length = tempBytes.length;
        Variable currentKey = (Variable)this.copy();
        if (length > currentKey.length()) {
            length = currentKey.length();
        }
        int offset = this.pointerAddress - masterRecordAddress;
        currentKey.getMemory().copy(tempBytes, offset, currentKey.getAddress(), length);
        return currentKey;
    }

    public final String getCollatingSequence() {
        if (this.pointerMemory == null) {
            return null;
        }
        try {
            return this.pointerMemory.getCollatingSequence();
        }
        catch (Exception anyException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception anyException)");
                anyException.printStackTrace();
            }
            return null;
        }
    }

    public static boolean isAlphabetic(char c) {
        return c == ' ' || XOpenInternational.uppercase.indexOf(c) >= 0 || XOpenInternational.lowercase.indexOf(c) >= 0;
    }

    public boolean isAlphabetic() {
        this.flushToMemory();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (Variable.isAlphabetic(this.getChar(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabeticUpper(char c) {
        return c == ' ' || XOpenInternational.uppercase.indexOf(c) >= 0;
    }

    public boolean isAlphabeticUpper() {
        this.flushToMemory();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (Variable.isAlphabeticUpper(this.getChar(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabeticLower(char c) {
        return c == ' ' || XOpenInternational.lowercase.indexOf(c) >= 0;
    }

    public boolean isAlphabeticLower() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (Variable.isAlphabeticLower(this.getChar(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isKanji() {
        try {
            if (this.isInternational()) {
                return false;
            }
            this.flushToMemory();
            for (int i = 0; i < this.length() - 1; i += 2) {
                char c1 = this.getChar(i);
                char c2 = this.getChar(i + 1);
                if (c1 == '@' && c2 == '@' || c1 >= 'A' && c1 <= '\u007f' && c2 >= 'A' && c2 <= '\u00fe') continue;
                return false;
            }
            return true;
        }
        catch (Exception checkException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception checkException)");
                checkException.printStackTrace();
            }
            return false;
        }
    }

    public boolean isSignValid(int c) {
        c &= 0xF;
        switch (packedSignEncoding) {
            case NOPFD: {
                return true;
            }
            case PFD: {
                return c == 12 || c == 13 || c == 15;
            }
            case MIG: {
                return c == 11 || c == 12 || c == 13 || c == 15;
            }
            case BULL: {
                return true;
            }
            case NCR: {
                return c == 11 || c == 13 || c == 15;
            }
        }
        return false;
    }

    public static boolean isSignedValid(int c) {
        c &= 0xF;
        switch (packedSignEncoding) {
            case NOPFD: {
                return c == 10 || c == 11 || c == 12 || c == 13 || c == 14 || c == 15;
            }
            case PFD: {
                return c == 12 || c == 13;
            }
            case MIG: {
                return c == 11 || c == 12 || c == 13;
            }
            case BULL: {
                return c == 10 || c == 11 || c == 12 || c == 13 || c == 14;
            }
            case NCR: {
                return c == 11 || c == 13;
            }
        }
        return false;
    }

    public boolean isSignUnsigned(int c) {
        c &= 0xF;
        switch (packedSignEncoding) {
            case NOPFD: 
            case PFD: {
                return c == 15;
            }
            case MIG: {
                return c == 15;
            }
            case BULL: {
                return true;
            }
            case NCR: {
                return c == 15;
            }
        }
        return false;
    }

    public boolean isSignNegative(int c) {
        c &= 0xF;
        switch (packedSignEncoding) {
            case NOPFD: {
                return c == 11 || c == 13;
            }
            case PFD: {
                return c == 13;
            }
            case MIG: {
                return c == 11 || c == 13;
            }
            case BULL: {
                return c == 13;
            }
            case NCR: {
                return c == 13;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        return this.isNumericInstance();
    }

    public boolean isNumeric(ZonedDescription zonedDescription) {
        if (!this.isrefmod && this.firstChild != null) {
            return this.isNumeric(zonedDescription, this);
        }
        String udigits = zonedDescription.getUnsignedDigits();
        String ndigits = zonedDescription.getNegativeDigits();
        String pdigits = zonedDescription.getPositiveDigits();
        char ndigit = zonedDescription.getNegativeChar();
        char pdigit = zonedDescription.getPositiveChar();
        int l = this.length();
        int offset1 = 0;
        int offset2 = 0;
        boolean signPresent = false;
        this.flushToMemory();
        String numberUsage = this.getUsage();
        if ("PackedDecimal".equals(numberUsage) || "PackedDecimalI".equals(numberUsage)) {
            char c;
            switch (this.signPosition) {
                case 3: 
                case 5: {
                    signPresent = true;
                    offset1 = l - 1;
                    offset2 = l - 2;
                    break;
                }
                case 2: 
                case 4: {
                    signPresent = true;
                    offset1 = 0;
                    offset2 = l - 1;
                    break;
                }
                default: {
                    offset2 = l - 1;
                    signPresent = false;
                }
            }
            if (signPresent && !this.isSignValid(c = this.pointerMemory.getChar(this.pointerAddress + offset1))) {
                return false;
            }
            for (int i = offset2; i >= 0; --i) {
                c = this.pointerMemory.getChar(this.pointerAddress + i);
                if (udigits.indexOf(c) >= 0) continue;
                int x = 0;
                String cx = String.format("%01x", c & 0xFFFF);
                try {
                    x = Integer.parseInt(cx);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (x <= 99) continue;
                return false;
            }
            return true;
        }
        switch (this.signPosition) {
            case 3: {
                char c = this.pointerMemory.getChar(this.pointerAddress + l - 1);
                if (ndigits.indexOf(c) < 0 && pdigits.indexOf(c) < 0) {
                    if (DataType == "3") {
                        if (udigits.indexOf(c) < 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                for (int i = l - 2; i >= 0; --i) {
                    if (udigits.indexOf(this.pointerMemory.getChar(this.pointerAddress + i)) >= 0) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                char c = this.pointerMemory.getChar(this.pointerAddress + 0);
                if (ndigits.indexOf(c) < 0 && pdigits.indexOf(c) < 0) {
                    if (DataType == "3") {
                        if (udigits.indexOf(c) < 0) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                for (int i = l - 1; i >= 1; --i) {
                    if (udigits.indexOf(this.pointerMemory.getChar(this.pointerAddress + i)) >= 0) continue;
                    return false;
                }
                return true;
            }
            case 5: {
                char c = this.pointerMemory.getChar(this.pointerAddress + l - 1);
                if (c != pdigit && c != ndigit) {
                    return false;
                }
                for (int i = l - 2; i >= 0; --i) {
                    if (udigits.indexOf(this.pointerMemory.getChar(this.pointerAddress + i)) >= 0) continue;
                    return false;
                }
                return true;
            }
            case 4: {
                char c = this.pointerMemory.getChar(this.pointerAddress + 0);
                if (c != pdigit && c != ndigit) {
                    return false;
                }
                for (int i = l - 1; i >= 1; --i) {
                    if (udigits.indexOf(this.pointerMemory.getChar(this.pointerAddress + i)) >= 0) continue;
                    return false;
                }
                return true;
            }
        }
        for (int i = l - 1; i >= 0; --i) {
            if (udigits.indexOf(this.pointerMemory.getChar(this.pointerAddress + i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public final boolean isNumeric(ZonedDescription zonedDescription, Variable check) {
        check = check.firstChild;
        while (check != null) {
            if (!check.isNumeric(zonedDescription)) {
                return false;
            }
            check = check.nextSibling;
        }
        return true;
    }

    public final boolean isClass(String classString) {
        this.flushToMemory();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (classString.indexOf(this.pointerMemory.getChar(this.pointerAddress + i)) != -1) continue;
            return false;
        }
        return true;
    }

    public final boolean isClass(byte[] classByteArray) {
        this.flushToMemory();
        int l = this.length();
        for (int i = 0; i < l; ++i) {
            byte b = this.pointerMemory.getByte(this.pointerAddress + i);
            boolean found = false;
            for (int j = 0; j < classByteArray.length; ++j) {
                if (classByteArray[j] != b) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public final boolean isClass(Variable classVariable) {
        return this.isClass(classVariable.toString());
    }

    public boolean isNumericInstance() {
        return false;
    }

    public final boolean isBetween(Variable param1, Variable param2) {
        return this.compare(param1) >= 0 && this.compare(param2) <= 0;
    }

    public int compareSpaces() {
        this.flushToMemory();
        int address = this.pointerAddress;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            byte by;
            if ((by = this.pointerMemory.getByte(address++)) == SPACE_BYTE) continue;
            return (by & 0xFF) - SPACE_BYTE;
        }
        return 0;
    }

    public int compare(int param) {
        return this.compare(new Numeric(param));
    }

    public int compare(Index param) {
        return this.compare(new Numeric(param.toInt()));
    }

    public boolean isZero() {
        return this.compare(new Numeric()) == 0;
    }

    public boolean isLowValues() {
        this.flushToMemory();
        int address = this.pointerAddress;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            try {
                if (this.pointerMemory.getByte(address++) == 0) continue;
                return false;
            }
            catch (RuntimeException e) {
                if (!LogSetup.IS_LOGGING_INFO) continue;
                LogSetup.LOGGER.info("catch (RuntimeException e)");
                e.printStackTrace();
            }
        }
        return true;
    }

    public static boolean isHighValues(byte[] ba) {
        for (int i = 0; i < ba.length; ++i) {
            if ((ba[i] & 0xFF) == 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isHighValues(char[] ca) {
        for (int i = 0; i < ca.length; ++i) {
            if ((ca[i] & 0xFF) == 255) continue;
            return false;
        }
        return true;
    }

    public boolean isHighValues() {
        if (this.pointerMemory == null || this.getUsageNumber() == 3) {
            return false;
        }
        this.flushToMemory();
        int address = this.getAddress();
        for (int i = 0; i < this.itemSize; ++i) {
            try {
                if ((this.getMemory().getByte(address++) & 0xFF) == 255) continue;
                return false;
            }
            catch (RuntimeException e) {
                if (!LogSetup.IS_LOGGING_INFO) continue;
                LogSetup.LOGGER.info("catch (RuntimeException e)");
                e.printStackTrace();
            }
        }
        return true;
    }

    public int compare(int param, String collatingSequence) {
        return this.compare(new Numeric(param), collatingSequence);
    }

    void performNumericValidation(Object obj) {
        if (((Numeric)obj).value.requiresNumericValidate()) {
            if (obj instanceof DisplayP) {
                ((DisplayP)obj).checkNumericContent();
            } else if (obj instanceof DisplayMVS) {
                ((DisplayMVS)obj).checkNumericContent();
            } else if (obj instanceof PackedDecimalI) {
                ((PackedDecimalI)obj).checkNumericContent();
            }
        }
    }

    public int compare(Variable param) {
        char[] paramSpecialCharArray;
        if (this.isTypeNumeric()) {
            this.performNumericValidation((Numeric)this);
        }
        if (param == SPACES && (!this.isTypeNumeric() || this.isTypeNumeric() && ((Numeric)this).value.isiAmNotNumeric())) {
            this.flushToMemory();
            int address = this.pointerAddress;
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                byte by;
                if ((by = this.pointerMemory.getByte(address++)) == SPACE_BYTE) continue;
                if ((by & 0xFF) == 255) {
                    return SPACE_BYTE;
                }
                return (by & 0xFF) - SPACE_BYTE;
            }
            return 0;
        }
        if (param.isNumericInstance()) {
            return this.compare((Numeric)param);
        }
        if (param.specialType == 2) {
            return this.compare((Display)ZEROES);
        }
        String thisCollatingSequence = this.getCollatingSequence();
        if (thisCollatingSequence != null) {
            return this.compare(param, thisCollatingSequence);
        }
        String paramCollatingSequence = param.getCollatingSequence();
        if (paramCollatingSequence != null) {
            thisCollatingSequence = paramCollatingSequence;
        }
        if ((paramSpecialCharArray = param.specialCharArray(this)) != null) {
            return this.compare(paramSpecialCharArray);
        }
        if (this.specialType != 0) {
            paramSpecialCharArray = this.specialCharArray(param);
            return -param.compare(paramSpecialCharArray);
        }
        if ((param.flagBits & 0x14000000) == 0 && this.isDefinedNumeric()) {
            String result = this.toNumericString();
            if (result.charAt(0) == '-') {
                return -param.compare(result.substring(1));
            }
            return -param.compare(result);
        }
        if ((this.flagBits & 0x3C000000) == 0xC000000 || (param.flagBits & 0x3C000000) == 0xC000000) {
            Bignum op1 = new Bignum(this.toScalelessString());
            Bignum op2 = new Bignum(param.toScalelessString());
            return op1.compareTo(op2);
        }
        param.flushToMemory();
        this.flushToMemory();
        int l1 = this.length();
        int l2 = param.length();
        int address = this.pointerAddress;
        int addressParam = param.getAddress();
        Memory memoryParam = param.getMemory();
        if (l1 > l2) {
            int i;
            for (i = 0; i < l2; ++i) {
                if (this.pointerMemory.getByte(address++) == memoryParam.getByte(addressParam++)) continue;
                return (this.pointerMemory.getByte(address - 1) & 0xFF) > (memoryParam.getByte(addressParam - 1) & 0xFF) ? 1 : -1;
            }
            for (i = l2; i < l1; ++i) {
                if (this.pointerMemory.getByte(address++) == SPACE_BYTE) continue;
                return (this.pointerMemory.getByte(address - 1) & 0xFF) > SPACE_BYTE ? 1 : -1;
            }
            return 0;
        }
        if (l2 > l1) {
            int i;
            for (i = 0; i < l1; ++i) {
                if (this.pointerMemory.getByte(address++) == memoryParam.getByte(addressParam++)) continue;
                return (this.pointerMemory.getByte(address - 1) & 0xFF) > (memoryParam.getByte(addressParam - 1) & 0xFF) ? 1 : -1;
            }
            for (i = l1; i < l2; ++i) {
                if (SPACE_BYTE == memoryParam.getByte(addressParam++)) continue;
                return SPACE_BYTE > (memoryParam.getByte(addressParam - 1) & 0xFF) ? 1 : -1;
            }
            return 0;
        }
        for (int i = 0; i < l1; ++i) {
            if (this.pointerMemory.getByte(address++) == memoryParam.getByte(addressParam++)) continue;
            return (this.pointerMemory.getByte(address - 1) & 0xFF) > (memoryParam.getByte(addressParam - 1) & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public int compare(Numeric param) {
        if (!this.isTypeNumericEdited() && !this.isTypeNumeric()) {
            this.performNumericValidation(param);
            if (this.isHighValues() || param.toBignum().isiAmNotNumeric()) {
                return this.compare(param.toString());
            }
            return this.strCompare(param);
        }
        int reverse = param.compare(this);
        if (reverse < 0) {
            return 1;
        }
        if (reverse > 0) {
            return -1;
        }
        return 0;
    }

    public int strCompare(Numeric param) {
        int paramStringLength;
        int type;
        String thisString;
        String paramString;
        this.flushToMemory();
        param.flushToMemory();
        String thisCollatingSequence = this.getCollatingSequence();
        if (thisCollatingSequence != null) {
            return this.compare(param, thisCollatingSequence);
        }
        String paramCollatingSequence = param.getCollatingSequence();
        if (paramCollatingSequence != null) {
            thisCollatingSequence = paramCollatingSequence;
        }
        String paramSpecialString = param.special(this);
        int sign = 32;
        if (paramSpecialString == null) {
            paramString = param.toCompareString();
            sign = param.toDisplayString().charAt(0);
        } else if (memoryCharset != null) {
            paramString = new String(paramSpecialString.getBytes(memoryCharset), defaultCharset);
            sign = paramSpecialString.charAt(0);
        } else {
            paramString = paramSpecialString;
            sign = paramSpecialString.charAt(0);
        }
        String thisSpecialString = this.special(param);
        String string2 = thisString = thisSpecialString == null ? this.toCompareString() : thisSpecialString;
        if (sign == 45 && (type = this.flagBits & 0x3C000000) != 0x4000000 && (type != 0xC000000 || this.signPosition == 0)) {
            paramString = paramString.substring(1);
        }
        if (thisString == null) {
            return paramString == null ? 0 : 1;
        }
        if (paramString == null) {
            return -1;
        }
        int thisStringLength = thisString.length();
        if (thisStringLength > (paramStringLength = paramString.length())) {
            if (thisString.charAt(thisStringLength - 1) == SPACE_CHAR) {
                paramString = paramString + Variable.all(SPACE_CHAR, thisStringLength - paramStringLength);
            } else if ("5".equals(DataType)) {
                String origParam = param.getOrigNumString();
                if (origParam != null) {
                    int origParamLength = origParam.length();
                    if (origParamLength > paramStringLength) {
                        paramString = origParam;
                        paramStringLength = origParamLength;
                    }
                    paramString = thisStringLength > paramStringLength ? paramString + Variable.all(SPACE_CHAR, thisStringLength - paramStringLength) : paramString.substring(paramStringLength - thisStringLength);
                } else {
                    paramString = Variable.all(ZERO_CHAR, thisStringLength - paramStringLength) + paramString;
                }
            } else {
                paramString = Variable.all(ZERO_CHAR, thisStringLength - paramStringLength) + paramString;
            }
        } else if (thisStringLength < paramStringLength) {
            paramString = this.isrefmod ? paramString.substring(0, thisStringLength) : paramString.substring(paramStringLength - thisStringLength);
        }
        int result = thisString.compareTo(paramString);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(Comp1 param) {
        int rc = param.compare(this);
        if (rc < 0) {
            return 1;
        }
        if (rc > 0) {
            return -1;
        }
        return 0;
    }

    public int compare(Comp2 param) {
        int rc = param.compare(this);
        if (rc < 0) {
            return 1;
        }
        if (rc > 0) {
            return -1;
        }
        return 0;
    }

    public int compare(DataPointer param) {
        int rc = param.compare(this);
        if (rc < 0) {
            return 1;
        }
        if (rc > 0) {
            return -1;
        }
        return 0;
    }

    public int compareNoCollateTruncate(Variable param) {
        if (param == SPACES) {
            this.flushToMemory();
            int address = this.pointerAddress;
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                if (this.pointerMemory.getByte(address++) == SPACE_BYTE) continue;
                return (this.pointerMemory.getByte(address - 1) & 0xFF) - SPACE_BYTE;
            }
            return 0;
        }
        if (param.specialType == 2) {
            return this.compareNoCollateTruncate((Display)ZEROES);
        }
        char[] paramSpecialCharArray = param.specialCharArray(this);
        if (paramSpecialCharArray != null) {
            return this.compareNoCollateTruncate(paramSpecialCharArray);
        }
        if (this.specialType != 0) {
            paramSpecialCharArray = this.specialCharArray(param);
            return -param.compareNoCollateTruncate(paramSpecialCharArray);
        }
        param.flushToMemory();
        this.flushToMemory();
        int l1 = this.length();
        int l2 = param.length();
        if (l1 > l2) {
            l1 = l2;
        }
        int result = 0;
        int address = this.pointerAddress;
        int addressParam = param.pointerAddress;
        Memory memoryParam = param.getMemory();
        for (int i = 0; i < l1; ++i) {
            if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (memoryParam.getByte(addressParam++) & 0xFF)) == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    public int compareNoCollateTruncate(String param) {
        int l2;
        this.flushToMemory();
        if (param == null) {
            return 0;
        }
        int address = this.pointerAddress;
        int l1 = this.length();
        if (l1 > (l2 = param.length())) {
            l1 = l2;
        }
        int result = 0;
        for (int i = 0; i < l1; ++i) {
            if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - param.charAt(i)) == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    public int compareNoCollateTruncate(char[] param) {
        int l2;
        this.flushToMemory();
        if (param == null) {
            return 0;
        }
        int address = this.pointerAddress;
        int l1 = this.length();
        if (l1 > (l2 = param.length)) {
            l1 = l2;
        }
        int result = 0;
        for (int i = 0; i < l1; ++i) {
            if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - param[i]) == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    public int compare(Numeric param, String collatingSequence) {
        int paramStringLength;
        int thisStringLength;
        int type;
        String paramStringText;
        String paramString;
        this.flushToMemory();
        param.flushToMemory();
        String paramSpecialString = param.special(this);
        String thisSpecialString = this.special(param);
        String thisString = thisSpecialString == null ? this.toCompareString() : thisSpecialString;
        if (paramSpecialString == null) {
            paramString = param.toCompareString();
            paramStringText = param.toString();
        } else {
            paramString = paramSpecialString;
            paramStringText = param.toString();
        }
        if (paramStringText.charAt(0) == '-' && (type = this.flagBits & 0x3C000000) != 0x4000000 && (type != 0xC000000 || this.signPosition == 0)) {
            paramString = paramString.substring(1);
        }
        if ((thisStringLength = thisString.length()) > (paramStringLength = paramString.length())) {
            if (thisString.charAt(thisStringLength - 1) == SPACE_CHAR) {
                paramString = paramString + Variable.all(SPACE_CHAR, thisStringLength - paramStringLength);
            } else if ("5".equals(DataType)) {
                String origParam = param.getOrigNumString();
                if (origParam != null) {
                    int origParamLength = origParam.length();
                    if (origParamLength > paramStringLength) {
                        paramString = origParam;
                        paramStringLength = origParamLength;
                    }
                    paramString = thisStringLength > paramStringLength ? paramString + Variable.all(SPACE_CHAR, thisStringLength - paramStringLength) : paramString.substring(paramStringLength - thisStringLength);
                } else {
                    paramString = Variable.all(ZERO_CHAR, thisStringLength - paramStringLength) + paramString;
                }
            } else {
                paramString = Variable.all(ZERO_CHAR, thisStringLength - paramStringLength) + paramString;
            }
        } else if (thisStringLength < paramStringLength) {
            paramString = paramString.substring(paramStringLength - thisStringLength);
        }
        int result = Variable.compareTo(thisString, paramString, collatingSequence);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(String param) {
        this.flushToMemory();
        if (param == null) {
            return 0;
        }
        if (this.pointerMemory == null) {
            return this.toString().compareTo(param);
        }
        int address = this.pointerAddress;
        String collatingSequence = this.pointerMemory.getCollatingSequence();
        if (collatingSequence != null) {
            return this.compare(param, collatingSequence);
        }
        byte[] asBytes = param.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = param.getBytes(memoryCharset);
            for (int j = 0; j < asBytes.length; ++j) {
                if (asBytes[j] == -1) continue;
                asBytes[j] = ebcdicBytes[j];
            }
        }
        int l1 = this.length(this.pointerMemory.getTopOfMemory() - address);
        int l2 = asBytes.length;
        int result = 0;
        if (l1 > l2) {
            int i;
            for (i = 0; i < l2; ++i) {
                if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (asBytes[i] & 0xFF)) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            for (i = l2; i < l1; ++i) {
                if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - SPACE_INT) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        if (l2 > l1) {
            int i;
            for (i = 0; i < l1; ++i) {
                if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (asBytes[i] & 0xFF)) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            for (i = l1; i < l2; ++i) {
                result = 32 - asBytes[i];
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        for (int i = 0; i < l1; ++i) {
            if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (asBytes[i] & 0xFF)) == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    public int compare(byte[] param) {
        int l2;
        this.flushToMemory();
        if (param == null) {
            return 0;
        }
        if (this.pointerMemory == null) {
            return this.toString().compareTo(new String(param, defaultCharset));
        }
        int address = this.pointerAddress;
        int l1 = this.length(this.pointerMemory.getTopOfMemory() - address);
        if (l1 > (l2 = param.length)) {
            int result;
            int i;
            for (i = 0; i < l2; ++i) {
                if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (param[i] & 0xFF)) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            for (i = l2; i < l1; ++i) {
                if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - SPACE_INT) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        if (l2 > l1) {
            int result;
            int i;
            for (i = 0; i < l1; ++i) {
                if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (param[i] & 0xFF)) == 0) continue;
                return result > 0 ? 1 : -1;
            }
            for (i = l1; i < l2; ++i) {
                result = 32 - param[i];
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        for (int i = 0; i < l1; ++i) {
            int result;
            if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (param[i] & 0xFF)) == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    public int compareNational(String param) {
        int param_length = param.length();
        char[] twice = new char[param_length * 2];
        int cursor = 0;
        for (int i = 0; i < param_length; ++i) {
            char c = param.charAt(i);
            twice[cursor++] = (char)(c >> 8 & 0xFF);
            twice[cursor++] = (char)(c & 0xFF);
        }
        return this.compare(twice);
    }

    public int compareNational(String param, String collatingSequence) {
        int param_length = param.length();
        char[] twice = new char[param_length * 2];
        int cursor = 0;
        for (int i = 0; i < param_length; ++i) {
            char c = param.charAt(i);
            twice[cursor++] = (char)(c >> 8 & 0xFF);
            twice[cursor++] = (char)(c & 0xFF);
        }
        return this.compare(twice, collatingSequence);
    }

    public int compare(char[] param) {
        this.flushToMemory();
        if (param == null) {
            return 0;
        }
        String thisString = this.toCompareString();
        String paramString = new String(param);
        if (memoryCharset != null && !Variable.isHighValues(param)) {
            paramString = new String(paramString.getBytes(memoryCharset), defaultCharset);
        }
        if (this.pointerMemory == null) {
            return thisString.compareTo(paramString);
        }
        String collatingSequence = this.pointerMemory.getCollatingSequence();
        if (collatingSequence != null) {
            return this.compare(param, collatingSequence);
        }
        int l1 = thisString.length();
        int l2 = paramString.length();
        int result = 0;
        if (l1 > l2) {
            char c1;
            int i;
            for (i = 0; i < l2; ++i) {
                char c2;
                c1 = thisString.charAt(i);
                result = (c1 & 0xFF) - ((c2 = paramString.charAt(i)) & 0xFF);
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            for (i = l2; i < l1; ++i) {
                c1 = thisString.charAt(i);
                result = (c1 & 0xFF) - SPACE_INT;
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        if (l2 > l1) {
            int i;
            for (i = 0; i < l1; ++i) {
                char c2;
                char c1 = thisString.charAt(i);
                result = (c1 & 0xFF) - ((c2 = paramString.charAt(i)) & 0xFF);
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            for (i = l1; i < l2; ++i) {
                char c2 = thisString.charAt(i);
                result = SPACE_INT - (c2 & 0xFF);
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        for (int i = 0; i < l1; ++i) {
            char c2;
            char c1 = thisString.charAt(i);
            result = (c1 & 0xFF) - ((c2 = paramString.charAt(i)) & 0xFF);
            if (result == 0) continue;
            return result > 0 ? 1 : -1;
        }
        return 0;
    }

    public static int compareTo(String one, String two, String collatingSequence) {
        if (collatingSequence == null) {
            int result = one.compareTo(two);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (two == null) {
            return 1;
        }
        if (one == null) {
            return -1;
        }
        int l1 = one.length();
        int l2 = two.length();
        int collen = collatingSequence.length();
        if (l1 > l2) {
            two = Variable.padStringToLength(l1, two);
        } else if (l1 < l2) {
            one = Variable.padStringToLength(l2, one);
        }
        for (int i = 0; i < l1; ++i) {
            int ione;
            int itwo = collatingSequence.indexOf(two.charAt(i));
            if (ione < 0) {
                ione = one.charAt(i) + collen;
            } else {
                for (ione = collatingSequence.indexOf(one.charAt(i)); ione > 0 && collatingSequence.charAt(ione - 1) == '\uf8ff'; ione -= 2) {
                }
            }
            if (itwo < 0) {
                itwo = two.charAt(i) + collen;
            } else {
                while (itwo > 0 && collatingSequence.charAt(itwo - 1) == '\uf8ff') {
                    itwo -= 2;
                }
            }
            if (ione > itwo) {
                return 1;
            }
            if (ione >= itwo) continue;
            return -1;
        }
        return 0;
    }

    public int compare(Variable param, String collatingSequence) {
        this.flushToMemory();
        param.flushToMemory();
        if (collatingSequence == null) {
            return this.compare(param);
        }
        String specialString = param.special(this);
        if (specialString != null) {
            return this.compare(specialString, collatingSequence);
        }
        if (this.specialType != 0) {
            specialString = this.special(param);
            return -param.compare(specialString, collatingSequence);
        }
        if (this.isDefinedNumeric() && (param.flagBits & 0x14000000) == 0) {
            String result = this.toNumericString();
            if (result.charAt(0) == '-') {
                return -param.compare(result.substring(1), collatingSequence);
            }
            return this.compare(param.toString(), collatingSequence);
        }
        if ((this.flagBits & 0x3C000000) == 0xC000000 || (param.flagBits & 0x3C000000) == 0xC000000) {
            Numeric op1 = new Numeric(this.toScalelessString());
            Numeric op2 = new Numeric(param.toScalelessString());
            return op1.compare(op2, collatingSequence);
        }
        return this.compare(param.toString(), collatingSequence);
    }

    public int compare(String param, String collatingSequence) {
        String comparator = this.toString();
        return this.compareStringsUsingCollatingSequence(comparator, param, collatingSequence);
    }

    public int compare(char[] param, String collatingSequence) {
        String comparator = this.toString();
        return this.compareStringsUsingCollatingSequence(comparator, new String(param), collatingSequence);
    }

    public int compareStringsUsingCollatingSequence(String first, String second, String collatingSequence) {
        int result;
        int l2;
        int l1 = first.length();
        if (l1 > (l2 = second.length())) {
            String padded = Variable.padStringToLength(l1, second);
            result = Variable.compareTo(first, padded, collatingSequence);
        } else if (l1 < l2) {
            String padded = Variable.padStringToLength(l2, first);
            result = Variable.compareTo(padded, second, collatingSequence);
        } else {
            result = Variable.compareTo(first, second, collatingSequence);
        }
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    private static String padStringToLength(int length, String originalStr) {
        String padded = String.format("%-" + length + "s", originalStr);
        return padded;
    }

    @Override
    public boolean supportsCompareBytes() {
        return true;
    }

    @Override
    public int compareBytes(byte[] bytes, int offset, int len, boolean truncate) {
        this.flushToMemory();
        int address = this.pointerAddress;
        int l1 = this.length() > len ? len : this.length();
        int i = 0;
        while (i < l1) {
            int result;
            if ((result = (this.pointerMemory.getByte(address++) & 0xFF) - (bytes[offset + i++] & 0xFF)) == 0) continue;
            return result > 0 ? 1 : -1;
        }
        if (!truncate) {
            if (this.length() > len) {
                return 1;
            }
            if (len > this.length()) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int compare(comparableByteArray x) {
        return this.compare(x, false);
    }

    @Override
    public int compare(comparableByteArray x, boolean truncate) {
        Variable varx = (Variable)x;
        if (truncate) {
            if (varx.isNumericInstance()) {
                return this.compareNoCollateTruncate((Numeric)varx);
            }
            return this.compareNoCollateTruncate(varx);
        }
        if (varx.isNumericInstance()) {
            return this.compare((Numeric)varx);
        }
        return this.compare(varx);
    }

    protected String toCompareString() {
        if (this.pointerMemory == null) {
            return null;
        }
        int l = this.length();
        char[] dest = new char[l];
        for (int i = 0; i < l; ++i) {
            dest[i] = this.pointerMemory.getChar(this.pointerAddress + i);
        }
        return new String(dest);
    }

    public boolean equalsPointer(DataPointer param) {
        return param.compare(this) == 0;
    }

    public boolean equalsPointer(Variable param) {
        DataPointer dp = new DataPointer(param);
        return dp.compare(this) == 0;
    }

    public final Variable all() {
        if (this.specialType == 0) {
            this.specialType = 1;
        }
        return this;
    }

    public final Variable zeroes() {
        this.specialType = (byte)2;
        return this;
    }

    public final Variable spaces() {
        this.specialType = (byte)3;
        return this;
    }

    public final Variable high_values() {
        this.specialType = (byte)4;
        return this;
    }

    public final Variable low_values() {
        this.specialType = (byte)5;
        return this;
    }

    public final Variable quotes() {
        this.specialType = (byte)6;
        return this;
    }

    public final Variable aquotes() {
        this.specialType = (byte)9;
        return this;
    }

    public static final String all(String fillString, int lengthToFill) {
        int length = fillString.length();
        char[] result = new char[lengthToFill];
        if (length == 1) {
            char fillChar = fillString.charAt(0);
            for (int innerCount = 0; innerCount < lengthToFill; ++innerCount) {
                result[innerCount] = fillChar;
            }
            return new String(result);
        }
        int count = 0;
        while (count < lengthToFill) {
            int innerCount = 0;
            while (innerCount < length && count < lengthToFill) {
                result[count++] = fillString.charAt(innerCount++);
            }
        }
        return new String(result);
    }

    public final String all(String fillString) {
        return Variable.all(fillString, this.length());
    }

    public static final String all(char fillString, int lengthToFill) {
        char[] result = new char[lengthToFill];
        for (int i = 0; i < lengthToFill; ++i) {
            result[i] = fillString;
        }
        return new String(result);
    }

    public final String all(char fillString) {
        return Variable.all(fillString, this.length());
    }

    public static final char[] allCharArray(String fillString, int lengthToFill) {
        int length = fillString.length();
        char[] result = new char[lengthToFill];
        if (length == 1) {
            char fillChar = fillString.charAt(0);
            for (int innerCount = 0; innerCount < lengthToFill; ++innerCount) {
                result[innerCount] = fillChar;
            }
            return result;
        }
        int count = 0;
        while (count < lengthToFill) {
            int innerCount = 0;
            while (innerCount < length && count < lengthToFill) {
                result[count++] = fillString.charAt(innerCount++);
            }
        }
        return result;
    }

    public final char[] allCharArray(String fillString) {
        return Variable.allCharArray(fillString, this.length());
    }

    public static final char[] allCharArray(char fillString, int lengthToFill) {
        char[] result = new char[lengthToFill];
        Arrays.fill(result, fillString);
        return result;
    }

    public final char[] allCharArray(char fillString) {
        return Variable.allCharArray(fillString, this.length());
    }

    @Override
    public int length() {
        if (BufferOverrunCheck == BufferOverrunSettings.EXTREME && this.pointerMemory != null) {
            return this.length(this.pointerMemory.getTopOfMemory() - this.pointerAddress);
        }
        return this.lengthBO();
    }

    public int length(int max) {
        int l = this.lengthBO();
        if (l < max) {
            return l;
        }
        return max;
    }

    public int refLength() {
        if (BufferOverrunCheck == BufferOverrunSettings.EXTREME && this.pointerMemory != null) {
            return this.pointerMemory.getTopOfMemory() - this.pointerAddress;
        }
        return this.lengthBO();
    }

    public int min(int l1, int l2) {
        if (l1 < l2) {
            return l1;
        }
        return l2;
    }

    public int lengthBO() {
        return this.maxItemSize == -1000 ? this.itemSize : (this.itemSize < this.maxItemSize ? this.itemSize : (BufferOverrunCheck == BufferOverrunSettings.STRICT ? this.maxItemSize : this.itemSize));
    }

    public int lengthMX() {
        return this.maxItemSize == -1000 ? this.itemSize : (this.maxItemSize < this.itemSize ? this.itemSize : (BufferOverrunCheck == BufferOverrunSettings.STRICT ? this.itemSize : this.maxItemSize));
    }

    public int lengthForLengthOfSyntax() {
        return BufferOverrunCheck == BufferOverrunSettings.STRICT ? this.lengthMX() : this.lengthBO();
    }

    public int relativeKeyLength() {
        return this.picLength > 0 ? this.picLength : this.length();
    }

    public int lengthNational() {
        return this.isInternational() ? this.length() / 2 : this.length();
    }

    public final int match(String pattern, int first, int last) {
        String stringValue = this.toString();
        int i = stringValue.indexOf(pattern, first);
        if (last >= 0 && i >= last) {
            return -1;
        }
        return i;
    }

    public final int match(String pattern, int first) {
        return this.match(pattern, first, -1);
    }

    public final int match(String pattern) {
        return this.match(pattern, 0, -1);
    }

    public final void acceptTodaysDate() {
        Calendar today = Calendar.getInstance();
        String monthString = Utilities.format(today.get(2) + 1, 2);
        String dateString = Utilities.format(today.get(5), 2);
        String yearString = Utilities.format(today.get(1) % 100, 4);
        this.move(new StringBuffer(6).append(monthString).append(dateString).append(yearString).toString());
    }

    public final void acceptTodaysName() {
        this.acceptDayName();
    }

    public final void acceptTimer() {
        Calendar now = Calendar.getInstance();
        long nowLong = now.getTimeInMillis();
        now.set(10, 0);
        now.set(12, 0);
        now.set(13, 0);
        long midnight = now.getTimeInMillis();
        nowLong -= midnight;
        nowLong = (long)((double)nowLong / 2.4);
        this.move(nowLong);
    }

    public final void acceptYYYYMMDD() {
        Calendar today = this.getCurrentCalendar();
        String monthString = Utilities.format(today.get(2) + 1, 2);
        String dateString = Utilities.format(today.get(5), 2);
        String yearString = Utilities.format(today.get(1), 4);
        this.move(new StringBuffer(8).append(yearString).append(monthString).append(dateString).toString());
    }

    public final void acceptYYYYDDD() {
        Calendar today = this.getCurrentCalendar();
        int year = today.get(1);
        int day_of_year = today.get(6);
        StringBuffer text = new StringBuffer(7);
        if (year >= 1000) {
            text.append(year);
        } else if (year >= 100) {
            text.append('0').append(year);
        } else if (year >= 10) {
            text.append("00").append(year);
        } else if (year > 0) {
            text.append("000").append(year);
        } else {
            text.append("0000");
        }
        if (day_of_year >= 100) {
            text.append(day_of_year);
        } else if (day_of_year >= 10) {
            text.append('0').append(day_of_year);
        } else if (day_of_year > 0) {
            text.append("00").append(day_of_year);
        } else {
            text.append("000");
        }
        this.move(text.toString());
    }

    public final void acceptDate() {
        Calendar today = this.getCurrentCalendar();
        String monthString = Utilities.format(today.get(2) + 1, 2);
        String dateString = Utilities.format(today.get(5), 2);
        String yearString = Utilities.format(today.get(1) % 100, 2);
        this.move(new StringBuffer(6).append(yearString).append(monthString).append(dateString).toString());
    }

    private Calendar getCurrentCalendar() {
        Calendar today = Calendar.getInstance();
        if (RuntimeEnvironment.getGlobalParameter(JCS_DATE_PARAMETER) != null) {
            try {
                String receivedDate = RuntimeEnvironment.getGlobalParameter(JCS_DATE_PARAMETER);
                DateTimeFormatter pattern = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                LocalDate localDate = LocalDate.parse(receivedDate, pattern);
                today.clear();
                today.set(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
            }
            catch (Exception e) {
                today = Calendar.getInstance();
            }
        }
        return today;
    }

    public final void acceptYear() {
        Calendar today = Calendar.getInstance();
        String yearString = Utilities.format(today.get(1), 4);
        this.move(yearString);
    }

    public final void acceptDay() {
        Calendar today = this.getCurrentCalendar();
        int year = today.get(1) % 100;
        int day_of_year = today.get(6);
        StringBuffer text = new StringBuffer(7);
        if (year >= 10) {
            text.append(year);
        } else if (year > 0) {
            text.append('0').append(year);
        } else {
            text.append("00");
        }
        if (day_of_year >= 100) {
            text.append(day_of_year);
        } else if (day_of_year >= 10) {
            text.append('0').append(day_of_year);
        } else if (day_of_year > 0) {
            text.append("00").append(day_of_year);
        } else {
            text.append("000");
        }
        this.move(text.toString());
    }

    public final void acceptDayOfWeek() {
        Calendar today = this.getCurrentCalendar();
        int dayOfWeek = today.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        this.move(Utilities.format(dayOfWeek, 1));
    }

    public final void acceptDayName() {
        Calendar today = this.getCurrentCalendar();
        int dayOfWeek = today.get(7);
        switch (dayOfWeek) {
            case 1: {
                this.move("Sunday");
            }
            case 2: {
                this.move("Monday");
            }
            case 3: {
                this.move("Tuesday");
            }
            case 4: {
                this.move("Wednesday");
            }
            case 5: {
                this.move("Thursday");
            }
            case 6: {
                this.move("Friday");
            }
            case 7: {
                this.move("Saturday");
            }
        }
        this.move("Unknownday");
    }

    public final void acceptTime() {
        GregorianCalendar cal = new GregorianCalendar();
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        int centis = cal.get(14) % 1000 / 10;
        char[] result = new char[]{(char)(48 + hours / 10), (char)(48 + hours % 10), (char)(48 + minutes / 10), (char)(48 + minutes % 10), (char)(48 + seconds / 10), (char)(48 + seconds % 10), (char)(48 + centis / 10), (char)(48 + centis % 10)};
        this.move(result);
    }

    public final void initialize(Variable init) {
        this.initialize(init, false);
    }

    public final void initialize(String init) {
        this.initialize(init, false);
    }

    public final void initialize() {
        this.initialize(false, false);
    }

    public final void initialize(Variable init, boolean includeFiller) {
        init.flushToMemory();
        this.setDirty();
        if (this.firstChild != null) {
            this.initializeSimple(init);
            return;
        }
        int n = this.dimensions();
        if (n == 0) {
            this.initializeSimple(init);
            return;
        }
        int[] dims = new int[n];
        int[] subscript = new int[n];
        for (int i = 0; i < n; ++i) {
            dims[n - i - 1] = this.dimension(i + 1);
            subscript[i] = 1;
        }
        int limit = this.dimensionTotal();
        int current = 0;
        boolean repeat = false;
        for (int i = 1; i <= limit; ++i) {
            this.subscript(subscript).initializeSimple(init);
            current = 0;
            if (i >= limit) continue;
            do {
                repeat = false;
                int n2 = current;
                subscript[n2] = subscript[n2] + 1;
                if (subscript[current] <= dims[current]) continue;
                subscript[current] = 1;
                ++current;
                repeat = true;
            } while (repeat);
        }
    }

    public final void initialize(String init, boolean includeFiller) {
        this.setDirty();
        if (this.firstChild != null) {
            this.initializeSimple(init);
            return;
        }
        int n = this.dimensions();
        if (n == 0) {
            this.initializeSimple(init);
            return;
        }
        int[] dims = new int[n];
        int[] subscript = new int[n];
        for (int i = 0; i < n; ++i) {
            dims[n - i - 1] = this.dimension(i + 1);
            subscript[i] = 1;
        }
        int limit = this.dimensionTotal();
        int current = 0;
        boolean repeat = false;
        for (int i = 1; i <= limit; ++i) {
            this.subscript(subscript).initializeSimple(init);
            current = 0;
            if (i >= limit) continue;
            do {
                repeat = false;
                int n2 = current;
                subscript[n2] = subscript[n2] + 1;
                if (subscript[current] <= dims[current]) continue;
                subscript[current] = 1;
                ++current;
                repeat = true;
            } while (repeat);
        }
    }

    public final void initialize(boolean initializeToValue, boolean includeFiller) {
        this.setDirty();
        if (this.firstChild != null) {
            this.initializeSimple();
            return;
        }
        int n = this.dimensions();
        if (n == 0) {
            this.initializeSimple();
            return;
        }
        int[] dims = new int[n];
        int[] subscript = new int[n];
        for (int i = 0; i < n; ++i) {
            dims[n - i - 1] = this.dimension(i + 1);
            subscript[i] = 1;
        }
        int limit = this.dimensionTotal();
        int current = 0;
        boolean repeat = false;
        for (int i = 1; i <= limit; ++i) {
            this.subscript(subscript).initializeSimple();
            current = 0;
            if (i >= limit) continue;
            do {
                repeat = false;
                int n2 = current;
                subscript[n2] = subscript[n2] + 1;
                if (subscript[current] <= dims[current]) continue;
                subscript[current] = 1;
                ++current;
                repeat = true;
            } while (repeat);
        }
    }

    public final void initializeSimple(String init) {
        this.setDirty();
        if (init == null) {
            this.initializeSimple();
            return;
        }
        Variable child = this.firstChild;
        if (child == null) {
            this.move(init);
            return;
        }
        while (child != null) {
            child.initialize(init);
            child = child.nextSibling;
        }
    }

    public final void initializeSimple(Variable init) {
        if (init == null) {
            this.initializeSimple();
            return;
        }
        init.flushToMemory();
        this.setDirty();
        if (init.isNumericInstance()) {
            this.initializeSimpleNumeric((Numeric)init);
            return;
        }
        Variable child = this.firstChild;
        if (child == null) {
            this.move(init);
            return;
        }
        while (child != null) {
            child.initialize(init);
            child = child.nextSibling;
        }
    }

    public final void initializeSimpleNumeric(Numeric init) {
        if (init == null) {
            this.initializeSimple();
            return;
        }
        init.flushToMemory();
        this.setDirty();
        Variable child = this.firstChild;
        if (child == null) {
            this.move(init);
            return;
        }
        while (child != null) {
            child.initialize(init);
            child = child.nextSibling;
        }
    }

    public final void initializeSimple() {
        this.setDirty();
        Variable child = this.firstChild;
        if (child == null) {
            this.initData();
        } else {
            while (child != null) {
                child.initialize();
                child = child.nextSibling;
            }
        }
    }

    public void initData() {
        if (this.isTypePointer()) {
            ((DataPointer)this).setPointerNull();
        } else {
            this.moveSpaces();
        }
    }

    public void doInitialize() {
        if (this.isInitialized) {
            this.fromByteArray(this.initBytes);
        } else {
            if (!this.alwaysFlush && this.pointerMemory != null) {
                this.pointerMemory.invalidateCache(this);
            }
            this.doInitialize(0, 0, null, null, null, null, null, null, null);
            this.isInitialized = true;
            this.initBytes = this.toByteArray();
        }
    }

    public void doInitializeWithFiller() {
        this.doInitialize(0, 1, null, null, null, null, null, null, null);
    }

    public void doInitialize(int initToValue, int withFiller, Object initializeAlphanumeric, Object initializeAlphabetic, Object initializeNumeric, Object initializeAlphanumericEdited, Object initializeNumericEdited, Object initializeNational, Object initializeNationalEdited) {
        initAlphanumeric = initializeAlphanumeric;
        initAlphabetic = initializeAlphabetic;
        initNumeric = initializeNumeric;
        initAlphanumericEdited = initializeAlphanumericEdited;
        initNumericEdited = initializeNumericEdited;
        initNational = initializeNational;
        initNationalEdited = initializeNationalEdited;
        sub = false;
        this.initializeData(this.idxString, initToValue, withFiller != 0);
    }

    public final void initializeData(int[] idxValue, int initToValue, boolean withFiller) {
        block96: {
            block95: {
                if (!this.isElementary() && !this.isrefmod) break block95;
                if (sub && (this.isFlagRedefines() || this.dependingOnVariable != null && !this.isArray())) {
                    return;
                }
                if (this.isFiller() && !withFiller) break block96;
                int initToValueType = 0;
                Object dataType = null;
                if ((this.flagBits & 0x3C000000) == 0x4000000) {
                    initToValueType = 4;
                    dataType = initNumeric;
                } else if ((this.flagBits & 0x3C000000) == 0xC000000) {
                    initToValueType = 16;
                    dataType = initNumericEdited;
                } else if ((this.flagBits & 0x3C000000) == 0x20000000) {
                    initToValueType = 1;
                    dataType = initAlphabetic;
                } else if ((this.flagBits & 0x3C000000) == 0) {
                    if (this.isInternational()) {
                        initToValueType = 32;
                        dataType = initNational;
                    } else {
                        initToValueType = 2;
                        dataType = initAlphanumeric;
                    }
                } else if ((this.flagBits & 0x3C000000) == 0x8000000) {
                    if (this.isInternational()) {
                        initToValueType = 64;
                        dataType = initNationalEdited;
                    } else {
                        initToValueType = 8;
                        dataType = initAlphanumericEdited;
                    }
                }
                if (initToValueType > 0) {
                    initToValue &= initToValueType;
                }
                Variable finalVar = null;
                int dim = this.dimensions();
                if (dim > 0 && !this.isrefmod) {
                    if (!sub && idxValue != null && idxValue.length == dim) {
                        finalVar = this;
                        this.initElementValue(dataType, finalVar, initToValue);
                    } else {
                        if (this.arrayChild == null) {
                            this.createArray();
                            if (_currContext != null && _currContext.getlnkPointerMemory().indexOf(this.pointerMemory.toString()) != -1) {
                                _currContext.setlnkArrayTable(this.arrayChild, this);
                            }
                        }
                        int idx8 = 0;
                        int idx7 = 0;
                        int idx6 = 0;
                        int idx5 = 0;
                        int idx4 = 0;
                        int idx3 = 0;
                        int idx2 = 0;
                        int idx1 = 0;
                        int i8 = 1;
                        int i7 = 1;
                        int i6 = 1;
                        int i5 = 1;
                        int i4 = 1;
                        int i3 = 1;
                        int i2 = 1;
                        int i1 = 1;
                        int i_7 = 1;
                        int i_6 = 1;
                        int i_5 = 1;
                        int i_4 = 1;
                        int i_3 = 1;
                        int i_2 = 1;
                        int i_1 = 1;
                        int incr = 0;
                        switch (dim) {
                            case 8: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i8 = idx8 = idxValue[incr];
                                    ++incr;
                                } else {
                                    idx8 = this.dimension(8);
                                }
                            }
                            case 7: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i7 = idx7 = idxValue[incr];
                                    i_7 = idx7;
                                    ++incr;
                                } else {
                                    idx7 = this.dimension(7);
                                }
                            }
                            case 6: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i6 = idx6 = idxValue[incr];
                                    i_6 = idx6;
                                    ++incr;
                                } else {
                                    idx6 = this.dimension(6);
                                }
                            }
                            case 5: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i5 = idx5 = idxValue[incr];
                                    i_5 = idx5;
                                    ++incr;
                                } else {
                                    idx5 = this.dimension(5);
                                }
                            }
                            case 4: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i4 = idx4 = idxValue[incr];
                                    i_4 = idx4;
                                    ++incr;
                                } else {
                                    idx4 = this.dimension(4);
                                }
                            }
                            case 3: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i3 = idx3 = idxValue[incr];
                                    i_3 = idx3;
                                    ++incr;
                                } else {
                                    idx3 = this.dimension(3);
                                }
                            }
                            case 2: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i2 = idx2 = idxValue[incr];
                                    i_2 = idx2;
                                    ++incr;
                                } else {
                                    idx2 = this.dimension(2);
                                }
                            }
                            case 1: {
                                if (idxValue != null && incr < idxValue.length) {
                                    i1 = idx1 = idxValue[incr];
                                    i_1 = idx1;
                                    break;
                                }
                                idx1 = this.dimension(1);
                            }
                        }
                        Object[] saveArrayChild = this.arrayChild;
                        VariableSubscript vs = null;
                        vs = this.arrayChild.length == 2 && this.arrayChild[1] instanceof VariableSubscript ? (VariableSubscript)this.arrayChild[1] : this.createVariableArray(dim);
                        switch (dim) {
                            case 8: {
                                while (i8 <= idx8) {
                                    while (i7 <= idx7) {
                                        while (i6 <= idx6) {
                                            while (i5 <= idx5) {
                                                while (i4 <= idx4) {
                                                    while (i3 <= idx3) {
                                                        while (i2 <= idx2) {
                                                            while (i1 <= idx1) {
                                                                finalVar = vs.get(i8, i7, i6, i5, i4, i3, i2, i1++);
                                                                this.initElementValue(dataType, finalVar, initToValue);
                                                            }
                                                            ++i2;
                                                            i1 = i_1;
                                                        }
                                                        ++i3;
                                                        i2 = i_2;
                                                    }
                                                    ++i4;
                                                    i3 = i_3;
                                                }
                                                ++i5;
                                                i4 = i_4;
                                            }
                                            ++i6;
                                            i5 = i_5;
                                        }
                                        ++i7;
                                        i6 = i_6;
                                    }
                                    ++i8;
                                    i7 = i_7;
                                }
                                break;
                            }
                            case 7: {
                                while (i7 <= idx7) {
                                    while (i6 <= idx6) {
                                        while (i5 <= idx5) {
                                            while (i4 <= idx4) {
                                                while (i3 <= idx3) {
                                                    while (i2 <= idx2) {
                                                        while (i1 <= idx1) {
                                                            finalVar = vs.get(i7, i6, i5, i4, i3, i2, i1++);
                                                            this.initElementValue(dataType, finalVar, initToValue);
                                                        }
                                                        ++i2;
                                                        i1 = i_1;
                                                    }
                                                    ++i3;
                                                    i2 = i_2;
                                                }
                                                ++i4;
                                                i3 = i_3;
                                            }
                                            ++i5;
                                            i4 = i_4;
                                        }
                                        ++i6;
                                        i5 = i_5;
                                    }
                                    ++i7;
                                    i6 = i_6;
                                }
                                break;
                            }
                            case 6: {
                                while (i6 <= idx6) {
                                    while (i5 <= idx5) {
                                        while (i4 <= idx4) {
                                            while (i3 <= idx3) {
                                                while (i2 <= idx2) {
                                                    while (i1 <= idx1) {
                                                        finalVar = vs.get(i6, i5, i4, i3, i2, i1++);
                                                        this.initElementValue(dataType, finalVar, initToValue);
                                                    }
                                                    ++i2;
                                                    i1 = i_1;
                                                }
                                                ++i3;
                                                i2 = i_2;
                                            }
                                            ++i4;
                                            i3 = i_3;
                                        }
                                        ++i5;
                                        i4 = i_4;
                                    }
                                    ++i6;
                                    i5 = i_5;
                                }
                                break;
                            }
                            case 5: {
                                while (i5 <= idx5) {
                                    while (i4 <= idx4) {
                                        while (i3 <= idx3) {
                                            while (i2 <= idx2) {
                                                while (i1 <= idx1) {
                                                    finalVar = vs.get(i5, i4, i3, i2, i1++);
                                                    this.initElementValue(dataType, finalVar, initToValue);
                                                }
                                                ++i2;
                                                i1 = i_1;
                                            }
                                            ++i3;
                                            i2 = i_2;
                                        }
                                        ++i4;
                                        i3 = i_3;
                                    }
                                    ++i5;
                                    i4 = i_4;
                                }
                                break;
                            }
                            case 4: {
                                while (i4 <= idx4) {
                                    while (i3 <= idx3) {
                                        while (i2 <= idx2) {
                                            while (i1 <= idx1) {
                                                finalVar = vs.get(i4, i3, i2, i1++);
                                                this.initElementValue(dataType, finalVar, initToValue);
                                            }
                                            ++i2;
                                            i1 = i_1;
                                        }
                                        ++i3;
                                        i2 = i_2;
                                    }
                                    ++i4;
                                    i3 = i_3;
                                }
                                break;
                            }
                            case 3: {
                                while (i3 <= idx3) {
                                    while (i2 <= idx2) {
                                        while (i1 <= idx1) {
                                            finalVar = vs.get(i3, i2, i1++);
                                            this.initElementValue(dataType, finalVar, initToValue);
                                        }
                                        ++i2;
                                        i1 = i_1;
                                    }
                                    ++i3;
                                    i2 = i_2;
                                }
                                break;
                            }
                            case 2: {
                                while (i2 <= idx2) {
                                    while (i1 <= idx1) {
                                        finalVar = vs.get(i2, i1++);
                                        this.initElementValue(dataType, finalVar, initToValue);
                                    }
                                    ++i2;
                                    i1 = i_1;
                                }
                                break;
                            }
                            case 1: {
                                while (i1 <= idx1) {
                                    finalVar = vs.get(i1++);
                                    this.initElementValue(dataType, finalVar, initToValue);
                                }
                                break;
                            }
                        }
                        this.arrayChild = saveArrayChild;
                    }
                } else {
                    finalVar = this;
                    this.initElementValue(dataType, finalVar, initToValue);
                }
                if (sub) break block96;
                sub = true;
                break block96;
            }
            if (sub && (this.isFlagRedefines() || this.dependingOnVariable != null && !this.isArray())) {
                return;
            }
            if (!sub) {
                sub = true;
            }
            Variable child = this.firstChild;
            while (child != null) {
                child.initializeData(idxValue, initToValue, withFiller);
                child = child.nextSibling;
            }
        }
    }

    void initElementValue(Object dataType, Variable finalVar, int initToValue) {
        if (dataType != null) {
            finalVar.move(dataType);
        } else if (initToValue != 0) {
            if (this.initValue != null && this.initValue.length() > 0) {
                finalVar.init();
            }
        } else if (initAlphanumeric == null && initAlphabetic == null && initNumeric == null && initAlphanumericEdited == null && initNumericEdited == null && initNational == null && initNationalEdited == null) {
            finalVar.initData();
        }
    }

    public Variable add(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.moveSE(param1.toBignum().add(param2.toBignum()));
        return this;
    }

    public Variable add(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.moveSE(param1.add(param2.toBignum()));
        return this;
    }

    public Variable add(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.numericString = null;
            this.setSizeError();
            return this;
        }
        this.moveSE(param1.toBignum().add(param2));
        return this;
    }

    public Variable add(Bignum param1, Bignum param2) {
        this.setDirtyNoFill();
        this.moveSE(param1.add(param2));
        return this;
    }

    public Variable addRounded(Numeric param1, Numeric param2) {
        if (param1.isSizeError() || param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.moveSE(param1.toBignum().add(param2.toBignum()));
        return this;
    }

    public Variable addRounded(Bignum param1, Numeric param2) {
        if (param2.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.moveSE(param1.add(param2.toBignum()));
        this.numericString = null;
        return this;
    }

    public Variable addRounded(Numeric param1, Bignum param2) {
        if (param1.isSizeError()) {
            this.setSizeError();
            return this;
        }
        this.moveSE(param1.toBignum().add(param2));
        this.numericString = null;
        return this;
    }

    public Variable addRounded(Bignum param1, Bignum param2) {
        this.moveSE(param1.add(param2));
        this.numericString = null;
        return this;
    }

    public String toInspectString() {
        return this.toString();
    }

    public final StringBuffer inspect() {
        return new StringBuffer(new String(new char[this.length()]));
    }

    public final char[] inspectArray() {
        return new char[this.length()];
    }

    public final int tallyingCharacters(StringBuffer inspectCheck, String afterString, String beforeString) {
        return this.tallyingCharacters(inspectCheck.toString().toCharArray(), afterString, beforeString);
    }

    public final int tallyingCharacters(char[] inspectCheck, String afterString, String beforeString) {
        int i = 0;
        int tally = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
        }
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        while (i < beforePoint) {
            if (inspectCheck[i] == '\u0000') {
                ++tally;
                inspectCheck[i] = 43;
            }
            ++i;
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int tallyingCharacters(char[] inspectCheck, byte[] afterString, byte[] beforeString) {
        if (afterString == null && beforeString == null) {
            return this.tallyingCharacters(inspectCheck, (String)null, (String)null);
        }
        if (afterString == null) {
            return this.tallyingCharacters(inspectCheck, (String)null, new String(beforeString));
        }
        if (beforeString == null) {
            return this.tallyingCharacters(inspectCheck, new String(afterString), (String)null);
        }
        return this.tallyingCharacters(inspectCheck, new String(afterString), new String(beforeString));
    }

    public final int tallyingLeading(StringBuffer inspectCheck, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
        }
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        int matchStringLength = matchString.length();
        while (i < beforePoint && value.regionMatches(i, matchString, 0, matchStringLength)) {
            int j;
            for (j = 0; j < matchStringLength; ++j) {
                if (inspectCheck.charAt(i + j) != '+') continue;
                return tally;
            }
            inspectCheck.setCharAt(i, '+');
            for (j = 1; j < matchStringLength; ++j) {
                inspectCheck.setCharAt(i + j, '_');
            }
            i += matchStringLength;
            ++tally;
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int tallyingLeading(char[] inspectCheck, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
        }
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        int matchStringLength = matchString.length();
        while (i < beforePoint && value.regionMatches(i, matchString, 0, matchStringLength)) {
            int j;
            for (j = 0; j < matchStringLength; ++j) {
                if (inspectCheck[i + j] != '+') continue;
                return tally;
            }
            inspectCheck[i] = 43;
            for (j = 1; j < matchStringLength; ++j) {
                inspectCheck[i + j] = 95;
            }
            i += matchStringLength;
            ++tally;
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int tallyingTrailing(char[] inspectCheck, String matchString, String afterString, String beforeString) {
        int tally;
        block10: {
            tally = 0;
            int i = 0;
            int beforePoint = this.length();
            String value = this.toInspectString();
            if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
                value = value.substring(1);
            }
            if (!Variable.isEmptyString(afterString)) {
                i = value.indexOf(afterString);
                if (i == -1) {
                    return 0;
                }
                i += afterString.length();
            }
            if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
                beforePoint = this.length();
            }
            int matchStringLength = matchString.length();
            int afterPoint = i;
            i = beforePoint;
            try {
                while (i > afterPoint && value.regionMatches(i - matchStringLength, matchString, 0, matchStringLength)) {
                    int j;
                    for (j = 0; j < matchStringLength; ++j) {
                        if (inspectCheck[i + j - matchStringLength] != '+') continue;
                        return tally;
                    }
                    inspectCheck[i - matchStringLength] = 43;
                    for (j = 1; j < matchStringLength; ++j) {
                        inspectCheck[i + j - matchStringLength] = 95;
                    }
                    i -= matchStringLength;
                    ++tally;
                }
            }
            catch (Exception goneBeyondBeginning) {
                if (!LogSetup.IS_LOGGING_INFO) break block10;
                LogSetup.LOGGER.info("catch (Exception goneBeyondBeginning)");
                goneBeyondBeginning.printStackTrace();
            }
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int tallyingTrailing(char[] inspectCheck, byte[] matchString, byte[] afterString, byte[] beforeString) {
        if (afterString == null && beforeString == null) {
            return this.tallyingTrailing(inspectCheck, new String(matchString), (String)null, (String)null);
        }
        if (afterString == null) {
            return this.tallyingTrailing(inspectCheck, new String(matchString), (String)null, new String(beforeString));
        }
        if (beforeString == null) {
            return this.tallyingTrailing(inspectCheck, new String(matchString), new String(afterString), (String)null);
        }
        return this.tallyingTrailing(inspectCheck, new String(matchString), new String(afterString), new String(beforeString));
    }

    public final int tallyingAll(StringBuffer inspectCheck, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = -1;
        String value = this.toInspectString();
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
        }
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
            --i;
        }
        int beforePoint = this.length();
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i + 1)) < 0) {
            beforePoint = this.length();
        }
        int matchStringLength = matchString.length();
        do {
            int j;
            if ((i = value.indexOf(matchString, i + 1)) < 0 || i >= beforePoint) continue;
            boolean alreadyDone = false;
            for (j = 0; j < matchStringLength && !alreadyDone; ++j) {
                if (inspectCheck.charAt(i + j) != '+') continue;
                alreadyDone = true;
            }
            if (!alreadyDone) {
                for (j = 0; j < matchStringLength; ++j) {
                    inspectCheck.setCharAt(i + j, '+');
                }
                i += matchStringLength;
                --i;
                ++tally;
                continue;
            }
            ++i;
        } while (i >= 0 && i < beforePoint);
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int tallyingAll(char[] inspectCheck, byte[] matchString, String afterString, String beforeString) {
        return this.tallyingAll(inspectCheck, new String(matchString), afterString, beforeString);
    }

    public final int tallyingAll(char[] inspectCheck, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = -1;
        String value = this.toInspectString();
        if (this.signPosition != 0 && (this.flagBits & 0x1C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
        }
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
            --i;
        }
        int beforePoint = this.length();
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i + 1)) < 0) {
            beforePoint = this.length();
        }
        int matchStringLength = matchString.length();
        do {
            int j;
            if ((i = value.indexOf(matchString, i + 1)) < 0 || i >= beforePoint) continue;
            boolean alreadyDone = false;
            for (j = 0; j < matchStringLength && !alreadyDone; ++j) {
                if (inspectCheck[i + j] != '+') continue;
                alreadyDone = true;
            }
            if (!alreadyDone) {
                for (j = 0; j < matchStringLength; ++j) {
                    inspectCheck[i + j] = 43;
                }
                i += matchStringLength;
                --i;
                ++tally;
                continue;
            }
            ++i;
        } while (i >= 0 && i < beforePoint);
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int tallyingAll(char[] inspectCheck, byte[] matchString, byte[] afterString, String beforeString) {
        if (afterString == null && beforeString == null) {
            return this.tallyingAll(inspectCheck, new String(matchString), (String)null, (String)null);
        }
        if (afterString == null) {
            return this.tallyingAll(inspectCheck, new String(matchString), (String)null, new String(beforeString));
        }
        if (beforeString == null) {
            return this.tallyingAll(inspectCheck, new String(matchString), new String(afterString), (String)null);
        }
        return this.tallyingAll(inspectCheck, new String(matchString), new String(afterString), new String(beforeString));
    }

    public final int replacingCharacters(StringBuffer inspectCheck, char replaceChar, String afterString, String beforeString) {
        int i = 0;
        int tally = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        while (i < beforePoint) {
            if (inspectCheck.charAt(i) == '\u0000') {
                ++tally;
                inspectCheck.setCharAt(i, '+');
                replaceValue[i] = replaceChar;
            }
            ++i;
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingCharacters(char[] inspectCheck, char replaceChar, String afterString, String beforeString) {
        int i = 0;
        int tally = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        while (i < beforePoint) {
            if (inspectCheck[i] == '\u0000') {
                ++tally;
                inspectCheck[i] = 43;
                replaceValue[i] = replaceChar;
            }
            ++i;
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingCharacters(StringBuffer inspectCheck, String replaceChar, String afterString, String beforeString) {
        return this.replacingCharacters(inspectCheck, replaceChar.charAt(0), afterString, beforeString);
    }

    public final int replacingCharacters(char[] inspectCheck, String replaceChar, String afterString, String beforeString) {
        return this.replacingCharacters(inspectCheck, replaceChar.charAt(0), afterString, beforeString);
    }

    public final int replacingLeading(StringBuffer inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        int matchStringLength = matchString.length();
        while (i < beforePoint && value.regionMatches(i, matchString, 0, matchStringLength)) {
            int j;
            for (j = 0; j < matchStringLength; ++j) {
                if (inspectCheck.charAt(i + j) != '+') continue;
                return tally;
            }
            for (j = 0; j < matchStringLength; ++j) {
                inspectCheck.setCharAt(i + j, '+');
                replaceValue[i + j] = replaceString.charAt(j);
            }
            i += matchStringLength;
            ++tally;
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingLeading(char[] inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = 0;
        int beforePoint = this.length();
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
            beforePoint = this.length();
        }
        int matchStringLength = matchString.length();
        while (i < beforePoint && value.regionMatches(i, matchString, 0, matchStringLength)) {
            int j;
            for (j = 0; j < matchStringLength; ++j) {
                if (inspectCheck[i + j] != '+') continue;
                return tally;
            }
            for (j = 0; j < matchStringLength; ++j) {
                inspectCheck[i + j] = 43;
                replaceValue[i + j] = replaceString.charAt(j);
            }
            i += matchStringLength;
            ++tally;
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingTrailing(char[] inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        char[] replaceValue;
        boolean restoreSign;
        int tally;
        block12: {
            tally = 0;
            int i = 0;
            int beforePoint = this.length();
            String value = this.toInspectString();
            restoreSign = false;
            if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
                value = value.substring(1);
                restoreSign = true;
            }
            replaceValue = value.toCharArray();
            if (!Variable.isEmptyString(afterString)) {
                i = value.indexOf(afterString);
                if (i == -1) {
                    return 0;
                }
                i += afterString.length();
            }
            if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i)) < 0) {
                beforePoint = this.length();
            }
            int matchStringLength = matchString.length();
            int afterPoint = i;
            i = beforePoint;
            try {
                while (i > afterPoint && value.regionMatches(i - matchStringLength, matchString, 0, matchStringLength)) {
                    int j;
                    for (j = 0; j < matchStringLength; ++j) {
                        if (inspectCheck[i + j - matchStringLength] != '+') continue;
                        return tally;
                    }
                    for (j = 0; j < matchStringLength; ++j) {
                        inspectCheck[i + j - matchStringLength] = 43;
                        replaceValue[i + j - matchStringLength] = replaceString.charAt(j);
                    }
                    i -= matchStringLength;
                    ++tally;
                }
            }
            catch (Exception goneBeyondBeginning) {
                if (!LogSetup.IS_LOGGING_INFO) break block12;
                LogSetup.LOGGER.info("catch (Exception goneBeyondBeginning)");
                goneBeyondBeginning.printStackTrace();
            }
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingAll(StringBuffer inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = -1;
        int beforePoint = this.length();
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length() - 1;
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i + 1)) < 0) {
            beforePoint = this.length();
        }
        do {
            int j;
            if ((i = value.indexOf(matchString, i + 1)) < 0 || i >= beforePoint) continue;
            boolean alreadyDone = false;
            for (j = 0; j < matchString.length() && !alreadyDone; ++j) {
                if (inspectCheck.charAt(i + j) != '+') continue;
                alreadyDone = true;
            }
            if (alreadyDone) continue;
            for (j = 0; j < matchString.length(); ++j) {
                inspectCheck.setCharAt(i + j, '+');
                replaceValue[i + j] = replaceString.charAt(j);
            }
            i += matchString.length() - 1;
            ++tally;
        } while (i >= 0 && i < beforePoint);
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingAll(char[] inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = -1;
        int beforePoint = this.length();
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            if (i == -1) {
                return 0;
            }
            i += afterString.length() - 1;
        }
        if (!Variable.isEmptyString(beforeString) && (beforePoint = value.indexOf(beforeString, i + 1)) < 0) {
            beforePoint = this.length();
        }
        do {
            int j;
            if ((i = value.indexOf(matchString, i + 1)) < 0 || i >= beforePoint) continue;
            boolean alreadyDone = false;
            int mslen = matchString.length();
            for (j = 0; j < mslen && !alreadyDone; ++j) {
                if (inspectCheck[i + j] != '+') continue;
                alreadyDone = true;
            }
            if (alreadyDone) continue;
            int rslen = replaceString.length();
            for (j = 0; j < mslen; ++j) {
                inspectCheck[i + j] = 43;
                replaceValue[i + j] = j < rslen ? replaceString.charAt(j) : (char)32;
            }
            i += mslen - 1;
            ++tally;
        } while (i >= 0 && i < beforePoint);
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public void replacingAll(char[] inspectCheck, String replaceString, byte[] matchString, String afterString, String beforeString) {
        if (afterString == null && beforeString == null) {
            this.replacingAll(inspectCheck, replaceString, new String(matchString), (String)null, (String)null);
        } else if (afterString == null) {
            this.replacingAll(inspectCheck, replaceString, new String(matchString), (String)null, beforeString);
        } else if (beforeString == null) {
            this.replacingAll(inspectCheck, replaceString, new String(matchString), afterString, (String)null);
        } else {
            this.replacingAll(inspectCheck, replaceString, new String(matchString), afterString, beforeString);
        }
    }

    public void replacingAll(char[] inspectCheck, byte[] replaceString, byte[] matchString, byte[] afterString, byte[] beforeString) {
        if (afterString == null && beforeString == null) {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), (String)null, (String)null);
        } else if (afterString == null) {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), (String)null, new String(beforeString));
        } else if (beforeString == null) {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), new String(afterString), (String)null);
        } else {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), new String(afterString), new String(beforeString));
        }
    }

    public void replacingAll(char[] inspectCheck, byte[] replaceString, byte[] matchString, String afterString, String beforeString) {
        if (afterString == null && beforeString == null) {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), (String)null, (String)null);
        } else if (afterString == null) {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), (String)null, beforeString);
        } else if (beforeString == null) {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), afterString, (String)null);
        } else {
            this.replacingAll(inspectCheck, new String(replaceString), new String(matchString), afterString, beforeString);
        }
    }

    public final int replacingFirst(StringBuffer inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = -1;
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString) && (i = value.indexOf(afterString)) == -1) {
            return 0;
        }
        if ((i = value.indexOf(matchString, i + 1)) >= 0) {
            int j;
            boolean alreadyDone = false;
            for (j = 0; j < matchString.length() && !alreadyDone; ++j) {
                if (inspectCheck.charAt(i + j) != '+') continue;
                alreadyDone = true;
            }
            if (!alreadyDone) {
                for (j = 0; j < matchString.length(); ++j) {
                    inspectCheck.setCharAt(i + j, '+');
                    replaceValue[i + j] = replaceString.charAt(j);
                }
                i += matchString.length() - 1;
                ++tally;
            } else {
                ++i;
            }
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final int replacingFirst(char[] inspectCheck, String replaceString, String matchString, String afterString, String beforeString) {
        int tally = 0;
        int i = -1;
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        char[] replaceValue = value.toCharArray();
        if (!Variable.isEmptyString(afterString) && (i = value.indexOf(afterString)) == -1) {
            return 0;
        }
        if ((i = value.indexOf(matchString, i + 1)) >= 0) {
            int j;
            boolean alreadyDone = false;
            for (j = 0; j < matchString.length() && !alreadyDone; ++j) {
                if (inspectCheck[i + j] != '+') continue;
                alreadyDone = true;
            }
            if (!alreadyDone) {
                for (j = 0; j < matchString.length(); ++j) {
                    inspectCheck[i + j] = 43;
                    replaceValue[i + j] = replaceString.charAt(j);
                }
                i += matchString.length() - 1;
                ++tally;
            } else {
                ++i;
            }
        }
        if (restoreSign) {
            this.move("-" + new String(replaceValue));
        } else {
            this.move(replaceValue);
        }
        if (this.isInternational()) {
            return tally >> 1;
        }
        return tally;
    }

    public final void inspectConverting(String fromString, String toString, String afterString, String beforeString) {
        int stopInspect;
        int i = 0;
        String value = this.toInspectString();
        boolean restoreSign = false;
        if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000 && value.charAt(0) == '-') {
            value = value.substring(1);
            restoreSign = true;
        }
        StringBuffer tempString = new StringBuffer(value);
        if (!Variable.isEmptyString(afterString)) {
            i = value.indexOf(afterString);
            i += afterString.length();
        }
        if (!Variable.isEmptyString(beforeString)) {
            stopInspect = value.indexOf(beforeString, i);
            if (stopInspect < 0) {
                stopInspect = this.length();
            }
        } else {
            stopInspect = this.length();
        }
        while (i < stopInspect) {
            char c = value.charAt(i);
            int theIndex = fromString.indexOf(c);
            if (theIndex >= 0) {
                tempString.setCharAt(i, toString.charAt(theIndex));
            }
            ++i;
        }
        if (restoreSign) {
            this.move("-" + tempString.toString());
        } else {
            this.move(tempString.toString());
        }
    }

    public final void inspectConverting(byte[] fromBytes, byte[] toBytes, String afterString, String beforeString) {
        this.inspectConverting(new String(fromBytes, StandardCharsets.ISO_8859_1), new String(toBytes, StandardCharsets.ISO_8859_1), afterString, beforeString);
    }

    public final void inspectConverting(byte[] fromBytes, String toString, String afterString, String beforeString) {
        this.inspectConverting(new String(fromBytes, StandardCharsets.ISO_8859_1), toString, afterString, beforeString);
    }

    public Variable moveSE(Numeric param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSE(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSE(Variable param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSE(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSE(String param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSE(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSE(Bignum param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSE(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSER(Numeric param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSER(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveR(Numeric param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveR(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSER(Variable param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSER(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSER(String param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSER(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveSER(Bignum param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveSER(param).isSizeError();
            if (!sizeError) {
                this.move(this.surrogate());
            }
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable moveR(Bignum param) {
        if (this.isTypeNumericEdited()) {
            boolean sizeError = this.surrogate().moveR(param).isSizeError();
            this.move(this.surrogate());
            return this.setSizeError(sizeError);
        }
        return this.move(param);
    }

    public Variable move(Numeric param) {
        Handle copy;
        String func = "Variable.move(Numeric): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Numeric: 0: this Name=" + this.getName() + ". param.toDebugString2=" + (param == null ? "null " : param.toDebugString2()));
        }
        if (param == null) {
            return this.move(SPACES_STRING);
        }
        if (this.handle != null && (copy = param.getHandle()) != null) {
            this.handle.set(copy);
        }
        Variable var = null;
        char[] specialCharArray = param.specialCharArray(this);
        if (specialCharArray != null) {
            char c;
            if (specialCharArray.length == 0) {
                specialCharArray = new char[]{'0'};
            }
            if ((this.flagBits & 0x14000000) == 0 && specialCharArray.length > 1 && ((c = specialCharArray[0]) == '-' || c == '+')) {
                char[] specialCharArraySubstring = new char[specialCharArray.length - 1];
                System.arraycopy(specialCharArray, 1, specialCharArraySubstring, 0, specialCharArraySubstring.length);
                var = this.move(specialCharArraySubstring);
                if (LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.finest("Variable.move(Numeric): 1: After move, this.DebugString2()=" + this.toDebugString2() + ".");
                }
                return var;
            }
            var = this.move(specialCharArray);
            if ((this.flagBits & 0x10000) != 0) {
                this.odoslide();
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finest("Variable.move(Numeric): 2: After move, this.DebugString2()=" + this.toDebugString2() + ".");
            }
            return var;
        }
        this.setDirtyNoFill();
        if (this.groupMove(param)) {
            return this;
        }
        String result = null;
        String numberUsage = param.getUsage();
        this.performNumericValidation(param);
        if ((this.flagBits & 0x14000000) == 0) {
            if ("Binary".equals(numberUsage)) {
                result = ((Binary)param).toNumericString(this.length(), true);
            } else if ("PackedDecimal".equals(numberUsage) || "PackedDecimalI".equals(numberUsage)) {
                result = param.value.isiAmNotNumeric() ? param.toString() : ((PackedDecimal)param).toNumericString(this.length(), true);
            } else {
                if (param.length() != 0 && (DataType == "1" || DataType == "3") && ("Binary".equals(numberUsage) || "PackedDecimalI".equals(numberUsage) || "DisplayMVS".equals(numberUsage) && param.place == 0 || "DisplayP".equals(numberUsage) && param.place == 0)) {
                    int i;
                    String paramAbs = DEFAULT_NAME;
                    if (param.value.isiAmNotNumeric()) {
                        paramAbs = param.toString();
                    } else {
                        paramAbs = param.toNumericValueString();
                        if (paramAbs.charAt(0) == '+' || paramAbs.charAt(0) == '-') {
                            paramAbs = paramAbs.substring(1);
                        }
                    }
                    int destLen = this.length();
                    int fromStart = 0;
                    int fromLen = paramAbs.length();
                    StringBuilder sb = new StringBuilder(DEFAULT_NAME);
                    for (i = fromStart; i < fromLen; ++i) {
                        sb.append(paramAbs.charAt(i));
                    }
                    if (sb.length() > destLen) {
                        sb.setLength(destLen);
                    } else if (sb.length() < destLen) {
                        for (i = sb.length(); i < destLen; ++i) {
                            sb.append(' ');
                        }
                    }
                    var = this.move(sb.toString());
                    if ((this.flagBits & 0x10000) != 0) {
                        this.odoslide();
                    }
                    return var;
                }
                result = param.toNumericString();
            }
        } else {
            result = param.toNumericString();
        }
        char CURRENT_DECIMAL = this.getDecimal();
        if ((this.flagBits & 0x14000000) == 0 || this.isUsageMisc()) {
            int decimalIndex;
            char c = result.charAt(0);
            if (c == '-' || c == '+') {
                result = result.substring(1);
            }
            if ((decimalIndex = result.indexOf(CURRENT_DECIMAL)) >= 0) {
                int resultLength = result.length();
                if (resultLength == 1) {
                    result = DEFAULT_NAME;
                } else {
                    int moveLength = resultLength - 1;
                    char[] resultArray = new char[moveLength];
                    if (decimalIndex == 0) {
                        result.getChars(1, resultLength, resultArray, 0);
                    } else if (decimalIndex == moveLength) {
                        result.getChars(0, moveLength, resultArray, 0);
                    } else {
                        result.getChars(0, decimalIndex, resultArray, 0);
                        result.getChars(decimalIndex + 1, resultLength, resultArray, decimalIndex);
                    }
                    var = this.move(resultArray, moveLength);
                    if ((this.flagBits & 0x10000) != 0) {
                        this.odoslide();
                    }
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finest("Variable.move(Numeric): 3: String result=" + result + ". After move, this.DebugString2()=" + this.toDebugString2() + ".");
                    }
                    return var;
                }
            }
        }
        var = this.move(result);
        if ((this.flagBits & 0x10000) != 0) {
            this.odoslide();
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable.move(Numeric): 4: String result=" + result + ". After move, this.DebugString2()=" + this.toDebugString2() + ".");
        }
        return var;
    }

    public Variable moveAll(String s) {
        int length = this.picLength;
        if (length <= 0) {
            length = this.length();
        }
        return this.move(Variable.allCharArray(s, length));
    }

    public Variable moveAll(Variable v) {
        int length = this.picLength;
        if (length <= 0) {
            length = this.length();
        }
        return this.move(Variable.allCharArray(v.toString(), length));
    }

    public Variable move(Variable param) {
        char[] specialCharArray;
        Handle copy;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable.move(Variable param): 0. param.toDebugString2=\n" + (param == null ? "null " : param.toDebugString2()) + ".\n this.Var: toDebugString2=\n" + this.toDebugString2() + ". ");
        }
        if (param == null) {
            return this.move(SPACES_STRING);
        }
        if (this.handle != null && (copy = param.getHandle()) != null) {
            this.handle.set(copy);
        }
        if ((specialCharArray = param.specialCharArray(this)) != null) {
            return this.move(specialCharArray);
        }
        param.flushToMemory();
        this.setDirtyNoFill();
        if ((this.flagBits & 0x3C000000) == 0xC000000 && ((param.flagBits & 0x1C000000) == 0 || param.isUsageMisc())) {
            if (!param.isGroup() && this.isMovableAsNumericEdited()) {
                String paramValue = param.toNumericValueString();
                this.move(paramValue);
                return this;
            }
            String paramString = param.toNumericString();
            int paramStringLength = paramString.length();
            int paramStringOffset = 0;
            if (paramStringLength > 0 && paramString.charAt(0) == '-') {
                paramStringOffset = 1;
                --paramStringLength;
            }
            if (paramStringLength > this.length()) {
                int address = this.pointerAddress;
                int len = this.length();
                for (int i = 0; i < len; ++i) {
                    this.pointerMemory.setChar(address++, paramString.charAt(paramStringOffset++));
                }
            } else {
                int i;
                int address = this.pointerAddress;
                for (i = 0; i < paramStringLength; ++i) {
                    this.pointerMemory.setChar(address++, paramString.charAt(paramStringOffset++));
                }
                while (i < this.length()) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                    ++i;
                }
            }
            this.fillFromMemory();
            if ((this.flagBits & 0x10000) != 0) {
                this.odoslide();
            }
            return this;
        }
        if (this.groupMove(param)) {
            this.validateNumericContent();
            return this;
        }
        int paramLength = param.lengthMX();
        if (this.isMovableAsNumericEdited()) {
            String paramValue = param.toNumericValueString();
            this.move(paramValue);
            return this;
        }
        int load = 0;
        int address = this.pointerAddress;
        try {
            int i;
            int len = this.length();
            if ((this.flagBits & 0x3C000000) == 0x8000000) {
                int i2;
                if (this.isJustRight()) {
                    int insertable = 0;
                    for (i2 = 0; i2 < len; ++i2) {
                        switch (this.picArray[i2]) {
                            case '9': 
                            case 'A': 
                            case 'X': {
                                ++insertable;
                            }
                        }
                    }
                    load = paramLength - insertable;
                }
                Memory memoryParam = param.getMemory();
                int paramAddress = param.getAddress();
                block18: for (i2 = 0; i2 < len; ++i2) {
                    switch (this.picArray[i2]) {
                        case '9': 
                        case 'A': 
                        case 'X': {
                            this.pointerMemory.setByte(address++, load >= 0 && load < paramLength ? memoryParam.getByte(paramAddress + load) : SPACE_BYTE);
                            ++load;
                            continue block18;
                        }
                        case 'B': {
                            this.pointerMemory.setByte(address++, SPACE_BYTE);
                            continue block18;
                        }
                        case '0': {
                            this.pointerMemory.setByte(address++, (byte)48);
                            continue block18;
                        }
                        case '/': {
                            this.pointerMemory.setByte(address++, (byte)47);
                            continue block18;
                        }
                        case ':': {
                            this.pointerMemory.setByte(address++, (byte)58);
                            continue block18;
                        }
                        case '@': {
                            this.pointerMemory.setByte(address++, (byte)0);
                        }
                    }
                }
                return this;
            }
            if (this.isJustRight()) {
                load = paramLength - this.length();
                if (load > 0) {
                    Memory memoryParam = param.pointerMemory;
                    load += param.pointerAddress;
                    for (int i3 = 0; i3 < len; ++i3) {
                        this.pointerMemory.setByte(address++, memoryParam.getByte(load++));
                    }
                    return this;
                }
                if (load < 0) {
                    int i4;
                    load = -load;
                    for (i4 = 0; i4 < load; ++i4) {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                    }
                    Memory memoryParam = param.pointerMemory;
                    load = param.pointerAddress;
                    for (i4 = 0; i4 < paramLength; ++i4) {
                        this.pointerMemory.setByte(address++, memoryParam.getByte(load++));
                    }
                    if ((this.flagBits & 0x10000) != 0) {
                        this.odoslide();
                    }
                    return this;
                }
            }
            if (paramLength >= len) {
                Memory memoryParam = param.pointerMemory;
                load = param.pointerAddress;
                for (int i5 = 0; i5 < len; ++i5) {
                    this.pointerMemory.setByte(address++, memoryParam.getByte(load++));
                }
                if ((this.flagBits & 0x10000) != 0) {
                    this.odoslide();
                }
                return this;
            }
            Memory memoryParam = param.pointerMemory;
            load = param.pointerAddress;
            for (i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, memoryParam.getByte(load++));
            }
            while (i < this.length()) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
                ++i;
            }
            if ((this.flagBits & 0x10000) != 0) {
                this.odoslide();
            }
            return this;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (ArrayIndexOutOfBoundsException e)");
                e.printStackTrace();
            }
            CobolException.runtimeError("Error in accessing Variable " + (address >= this.pointerMemory.getTopOfMemory() ? this.getQualifiedCobolName() : param.getQualifiedCobolName()), (Throwable)e);
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            CobolException.runtimeError("Error in accessing Variable " + this.getQualifiedCobolName() + " or " + param.getQualifiedCobolName(), (Throwable)e);
        }
        return this;
    }

    public boolean groupMove(Variable param) {
        if (param.isrefmod || this.isrefmod) {
            return false;
        }
        Memory source = null;
        int sourceAddress = 0;
        int destAddress = 0;
        try {
            if (param.firstChild != null || param.isGroupMove() || this.firstChild != null || this.isGroupMove()) {
                int paramLength = param.length();
                source = param.getMemory();
                sourceAddress = param.pointerAddress;
                destAddress = this.pointerAddress;
                if (paramLength == this.length()) {
                    this.pointerMemory.copy(source, sourceAddress, destAddress, this.length());
                } else if (paramLength < this.length()) {
                    int slack = this.length() - paramLength;
                    if (this.isJustRight()) {
                        this.pointerMemory.copy(source, sourceAddress, destAddress + slack, paramLength);
                        for (int i = 0; i < slack; ++i) {
                            this.pointerMemory.setByte(destAddress++, SPACE_BYTE);
                        }
                    } else {
                        this.pointerMemory.copy(source, sourceAddress, destAddress, paramLength);
                        destAddress += paramLength;
                        for (int i = 0; i < slack && destAddress < this.pointerMemory.getTopOfMemory(); ++i) {
                            this.pointerMemory.setByte(destAddress++, SPACE_BYTE);
                        }
                    }
                } else if (this.isJustRight()) {
                    this.pointerMemory.copy(source, sourceAddress + paramLength - this.length(), destAddress, this.length());
                } else {
                    this.pointerMemory.copy(source, sourceAddress, destAddress, this.length());
                }
                if ((this.flagBits & 0x10000) != 0) {
                    this.odoslide();
                }
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (ArrayIndexOutOfBoundsException e)");
                e.printStackTrace();
            }
            CobolException.runtimeError("Error in accessing group Variable " + (sourceAddress + this.length() - 1 >= source.getTopOfMemory() ? param.getQualifiedCobolName() : this.getQualifiedCobolName()), (Throwable)e);
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            CobolException.runtimeError("Error in accessing group Variable " + this.getQualifiedCobolName() + " or " + param.getQualifiedCobolName(), (Throwable)e);
        }
        return false;
    }

    public final Variable clearIfNumeric() {
        if ((this.flagBits & 0x3C000000) == 0x4000000) {
            this.flushToMemory();
            int address = this.pointerAddress;
            int len = this.length();
            for (int i = 0; i < this.length(); ++i) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
            }
        }
        return this;
    }

    public Variable moveZeroes() {
        return this.moveAll('0');
    }

    public final Variable moveSpaces() {
        if ((this.flagBits & 0x1C000000) == 0) {
            this.setDirtyNoFill();
            int address = this.pointerAddress;
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
            }
            if (this.isGroup()) {
                this.validateNumericContent();
            }
            return this;
        }
        if ((this.flagBits & 0x1C000000) == 0x8000000) {
            this.setDirtyNoFill();
            int address = this.pointerAddress;
            int len = this.length();
            block7: for (int i = 0; i < len; ++i) {
                switch (this.picArray[i]) {
                    case '@': {
                        this.pointerMemory.setChar(address++, '\u0000');
                        continue block7;
                    }
                    case '0': {
                        this.pointerMemory.setChar(address++, '0');
                        continue block7;
                    }
                    case '/': {
                        this.pointerMemory.setChar(address++, '/');
                        continue block7;
                    }
                    case ':': {
                        this.pointerMemory.setChar(address++, ':');
                        continue block7;
                    }
                    default: {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                    }
                }
            }
            return this;
        }
        return this.move(SPACES);
    }

    public final Variable moveLowValues() {
        if ((this.flagBits & 0x1C000000) == 0 || (this.flagBits & 0x1C000000) == 0x8000000) {
            this.setDirtyNoFill();
            int address = this.pointerAddress;
            int len = this.length();
            for (int i = 0; i < this.length(); ++i) {
                this.pointerMemory.setByte(address++, (byte)0);
            }
            return this;
        }
        return this.move(LOW_VALUES);
    }

    public Variable moveMultiple(String[] param) {
        if (param == null) {
            return this.move((String)null);
        }
        int length = param.length;
        if (length <= 0) {
            return this.move((String)null);
        }
        if (this.occurs() <= 1) {
            return this.move(param[0]);
        }
        for (int i = 0; i < length; ++i) {
            try {
                this.subscript(i + 1).move(param[i]);
                continue;
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) continue;
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
        }
        return this;
    }

    public Variable moveNational(String param) {
        char CURRENT_DECIMAL = this.getDecimal();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("param=" + param + ". name=" + this.getName() + ". this.nbrEdited=" + this.isTypeNumericEdited());
        }
        String paramUSA = param;
        if (this.isTypeNumericEdited() && CURRENT_DECIMAL != '.') {
            paramUSA = paramUSA.replace('.', '^');
            paramUSA = paramUSA.replace(',', '.');
            param = paramUSA = paramUSA.replace('^', ',');
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("param=" + param + ". paramUSA=" + paramUSA + ".");
        }
        if (this.isInternational()) {
            if (internationalEncoding != null) {
                try {
                    byte[] bytes = param.getBytes(internationalEncoding);
                    if (bytes != null) {
                        return this.move(bytes);
                    }
                    return this.moveSpaces();
                }
                catch (Exception e) {
                    if (LogSetup.IS_LOGGING_INFO) {
                        LogSetup.LOGGER.info("catch (Exception e)");
                        e.printStackTrace();
                    }
                    internationalEncoding = null;
                }
            }
            int param_length = param.length();
            char[] twice = new char[param_length * 2];
            int cursor = 0;
            for (int i = 0; i < param_length; ++i) {
                char c = param.charAt(i);
                twice[cursor++] = (char)(c >> 8 & 0xFF);
                twice[cursor++] = (char)(c & 0xFF);
            }
            return this.move(twice);
        }
        if (byteEncoding != null) {
            try {
                byte[] encodedBytes = param.getBytes(byteEncoding);
                if (encodedBytes != null) {
                    return this.move(encodedBytes);
                }
                return this.moveSpaces();
            }
            catch (Exception e) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch (Exception e)");
                    e.printStackTrace();
                }
                byteEncoding = null;
                return this.move(param);
            }
        }
        return this.move(param);
    }

    public Variable move(Number param) {
        return this.move(param.longValue());
    }

    public Variable move(Double param) {
        return this.move((double)param);
    }

    public Variable move(Float param) {
        return this.move(param.floatValue());
    }

    public Variable move(Object param) {
        if (param == null) {
            return this.move(SPACES_STRING);
        }
        if (param instanceof Variable) {
            if (param instanceof Numeric) {
                return this.move((Numeric)param);
            }
            return this.move((Variable)param);
        }
        if (param instanceof IDatatype) {
            this.fromText(((IDatatype)param).toText());
            return this;
        }
        return this.move(param.toString());
    }

    public void moveNewValue(String editedNum) {
        this.move(editedNum);
    }

    public Variable move(String editedNum) {
        int len;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("move(String editedNum): 0. editedNum=" + editedNum + ". this: Name=" + this.getName() + ". ");
        }
        if (editedNum == null) {
            editedNum = SPACES_STRING;
        }
        int load = 0;
        int paramLength = editedNum.length();
        this.setDirtyNoFill();
        if (this.isMovableAsNumericEdited()) {
            int i;
            int picturec = 0;
            char CURRENT_DECIMAL = this.getDecimal();
            char CURRENT_COMMA = this.getComma();
            int right_digits = 0;
            int left_digits = 0;
            boolean negative = false;
            boolean possibleCR = false;
            boolean possibleDB = false;
            boolean decimalInserted = false;
            boolean decimalFound = false;
            boolean zero = true;
            boolean hasExponent = false;
            boolean hasNegativeExponent = false;
            int exponent = 0;
            int store = this.length();
            if (this.right_array == null || this.right_array.length < paramLength) {
                this.right_array = new char[200];
                this.left_array = new char[200];
            }
            if (paramLength > 200) {
                editedNum = editedNum.substring(0, 200);
                paramLength = 200;
            }
            block42: for (i = 0; i < paramLength; ++i) {
                char c = editedNum.charAt(i);
                switch (c) {
                    case '-': {
                        if (hasExponent) {
                            hasNegativeExponent = true;
                            continue block42;
                        }
                        negative = true;
                        possibleCR = false;
                        possibleDB = false;
                        continue block42;
                    }
                    case 'C': 
                    case 'c': {
                        possibleCR = true;
                        possibleDB = false;
                        continue block42;
                    }
                    case 'R': 
                    case 'r': {
                        if (!possibleCR) continue block42;
                        negative = true;
                        continue block42;
                    }
                    case 'D': 
                    case 'd': {
                        possibleDB = true;
                        possibleCR = false;
                        continue block42;
                    }
                    case 'B': 
                    case 'b': {
                        if (!possibleDB) continue block42;
                        negative = true;
                        continue block42;
                    }
                    case 'E': {
                        hasExponent = true;
                        continue block42;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (!hasExponent) {
                            zero = false;
                        }
                    }
                    case '0': {
                        if (hasExponent) {
                            exponent = exponent * 10 + c - 48;
                            continue block42;
                        }
                        if (decimalFound) {
                            this.right_array[right_digits] = c;
                            ++right_digits;
                        } else if (!zero) {
                            this.left_array[left_digits] = c;
                            ++left_digits;
                        }
                        possibleCR = false;
                        possibleDB = false;
                        continue block42;
                    }
                    case '.': {
                        decimalFound = true;
                        possibleCR = false;
                        possibleDB = false;
                        continue block42;
                    }
                    default: {
                        possibleCR = false;
                        possibleDB = false;
                    }
                }
            }
            if (zero) {
                left_digits = 0;
                right_digits = 0;
            }
            if (exponent > 0) {
                if (hasNegativeExponent) {
                    System.arraycopy(this.right_array, 0, this.right_array, exponent, right_digits);
                    right_digits += exponent;
                    System.arraycopy(this.left_array, exponent < left_digits ? left_digits - exponent : 0, this.right_array, exponent < left_digits ? left_digits - exponent : exponent - left_digits, exponent < left_digits ? exponent : left_digits);
                    for (i = 0; i < exponent - left_digits; ++i) {
                        this.right_array[i] = 48;
                    }
                    left_digits = exponent < left_digits ? left_digits - exponent : 0;
                } else {
                    int len2 = right_digits > exponent ? right_digits : exponent - right_digits + 1;
                    System.arraycopy(this.right_array, 0, this.left_array, left_digits, len2);
                    for (i = left_digits + len2; i < left_digits + exponent; ++i) {
                        this.left_array[i] = 48;
                    }
                    left_digits += exponent;
                    if (right_digits > exponent) {
                        System.arraycopy(this.right_array, exponent, this.right_array, 0, right_digits - exponent);
                    }
                    if ((right_digits -= exponent) < 0) {
                        right_digits = 0;
                    }
                }
            }
            int left_string_length = left_digits;
            for (i = 0; i < left_string_length; ++i) {
                if (this.left_array[i] == '0') continue;
                if (i > 0) {
                    System.arraycopy(this.left_array, i, this.left_array, 0, left_digits -= i);
                }
                i = left_string_length + 1;
            }
            if (i == left_string_length) {
                left_digits = 0;
            }
            if (this.scale > 0) {
                if (this.place > 0) {
                    left_digits = 0;
                    System.arraycopy(this.right_array, 0, this.right_array, this.scale, right_digits);
                    right_digits += this.scale;
                    for (i = 0; i < this.scale; ++i) {
                        this.right_array[i] = 48;
                    }
                } else {
                    right_digits = 0;
                    if ((left_digits -= this.scale) < 0) {
                        left_digits = 0;
                    }
                }
            }
            if (left_digits == 0 && right_digits == 0) {
                zero = true;
            }
            int picExponentPlace = 0;
            int picExponentSign = 0;
            int picExponentDigits = 0;
            int picDecimal = -1;
            int picSignChars = 0;
            int picCurrencyChars = 0;
            for (i = this.picForNumberLength - 1; i >= 0; --i) {
                if (this.picForNumberArray[i] == '$') {
                    ++picCurrencyChars;
                }
                if (this.picForNumberArray[i] == 'E') {
                    picExponentPlace = this.picForNumberLength - i - 1;
                    if (this.picForNumberArray[i + 1] == '+') {
                        picExponentSign = 1;
                        picExponentDigits = this.picForNumberLength - i - 2;
                    } else if (this.picForNumberArray[i + 1] == '-') {
                        picExponentSign = 2;
                        picExponentDigits = this.picForNumberLength - i - 2;
                    } else {
                        picExponentDigits = this.picForNumberLength - i - 1;
                    }
                }
                if (this.picForNumberArray[i] != '.') continue;
                picDecimal = i;
            }
            if (this.picForNumberLength > 0 && (this.picForNumberArray[0] == '+' || this.picForNumberArray[0] == '+')) {
                picSignChars = 1;
            }
            if (picDecimal == -1) {
                picDecimal = picExponentPlace > 0 ? this.picForNumberLength - picExponentPlace - 1 - picSignChars : this.picForNumberLength - picSignChars;
            }
            if (zero && this.isBlankWhenZero()) {
                int address = this.pointerAddress;
                int len3 = this.length();
                for (i = 0; i < len3; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
            } else if (zero && this.isStarredWhenZero()) {
                for (i = this.picForNumberLength - 1; i >= 0; --i) {
                    this.setChar(i, this.picForNumberArray[i] == '.' ? CURRENT_DECIMAL : (char)'*');
                }
            } else {
                if (this.place == 0) {
                    decimalInserted = true;
                }
                if (picExponentDigits > 0) {
                    int adjusted = picDecimal - picSignChars;
                    if (left_digits == 0) {
                        int zeros;
                        for (zeros = 0; zeros < right_digits && this.right_array[zeros] == '0'; ++zeros) {
                        }
                        exponent = -zeros - adjusted;
                        while (adjusted > right_digits - zeros) {
                            this.right_array[right_digits++] = 48;
                        }
                        System.arraycopy(this.right_array, zeros, this.left_array, 0, adjusted);
                        left_digits = adjusted;
                        adjusted = right_digits - left_digits - zeros;
                        System.arraycopy(this.right_array, zeros + left_digits, this.right_array, 0, adjusted);
                        right_digits = adjusted;
                    } else if (left_digits > adjusted) {
                        exponent = left_digits - adjusted;
                        System.arraycopy(this.right_array, 0, this.right_array, exponent, right_digits);
                        right_digits += exponent;
                        System.arraycopy(this.left_array, adjusted, this.right_array, 0, exponent);
                        left_digits = adjusted;
                    }
                }
                int virtualPlace = this.place;
                picturec = 33;
                for (i = this.picForNumberLength - 1 - picExponentPlace; i >= 0 && store > 0; --i) {
                    int lc = picturec;
                    if (lc == 64) {
                        lc = 57;
                    }
                    picturec = this.picForNumberArray != null ? this.picForNumberArray[i] : (int)this.getPic(i);
                    block53: do {
                        switch (picturec) {
                            case 64: {
                                this.setChar(--store, '\u0000');
                                break;
                            }
                            case 69: {
                                int wrkExponent = exponent;
                                if (wrkExponent < 0) {
                                    wrkExponent = -wrkExponent;
                                }
                                do {
                                    char cc = (char)(48 + wrkExponent % 10);
                                    this.setChar(--store, cc);
                                } while ((wrkExponent /= 10) != 0);
                                if (picExponentSign == 1) {
                                    if (exponent < 0) {
                                        this.setChar(--store, '-');
                                    } else {
                                        this.setChar(--store, '+');
                                    }
                                } else if (picExponentSign == 2 && exponent < 0) {
                                    this.setChar(--store, '-');
                                }
                                this.setChar(--store, 'E');
                                break;
                            }
                            case 66: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picForNumberArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 47: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picForNumberArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, '/');
                                break;
                            }
                            case 58: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picForNumberArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ':');
                                break;
                            }
                            case 48: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picForNumberArray[i - 1];
                                }
                                this.setChar(--store, '0');
                                break;
                            }
                            case 44: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picForNumberArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, CURRENT_COMMA);
                                break;
                            }
                            case 46: {
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 80: {
                                picturec = 57;
                                break;
                            }
                            case 90: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (picCurrencyChars > 1) {
                                                this.setChar(--store, this.getCurrency());
                                                while (store > 0) {
                                                    this.setChar(--store, ' ');
                                                }
                                                continue;
                                            }
                                            this.setChar(--store, ' ');
                                        }
                                        i = -1;
                                        if (this.picForNumberArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block53;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 42: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (this.picForNumberArray[store - 1] == 'B') {
                                                this.setChar(--store, ' ');
                                                continue;
                                            }
                                            this.setChar(--store, '*');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block53;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    this.setChar(--store, '*');
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 43: {
                                if (store == 1 || store == this.length() && i > 0 && this.picForNumberArray[i - 1] != '+') {
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block53;
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 45: {
                                if (store == 1 || store == this.length() && i > 0 && this.picForNumberArray[i - 1] != '-') {
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block53;
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 36: {
                                if (store == 1) {
                                    this.setChar(--store, this.getCurrency());
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    this.setChar(--store, this.getCurrency());
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    if (this.picForNumberArray[0] == '-') {
                                        this.setChar(0, negative ? (char)'-' : ' ');
                                        break;
                                    }
                                    if (this.picForNumberArray[0] != '+') continue block53;
                                    this.setChar(0, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 57: {
                                if (decimalInserted) {
                                    if (--left_digits >= 0) {
                                        this.setChar(--store, this.left_array[left_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                } else if (virtualPlace > right_digits) {
                                    this.setChar(--store, '0');
                                    --virtualPlace;
                                } else {
                                    if (right_digits > this.place) {
                                        right_digits = this.place;
                                    }
                                    --virtualPlace;
                                    if (--right_digits >= 0) {
                                        this.setChar(--store, this.right_array[right_digits]);
                                        if (virtualPlace == 0) {
                                            decimalInserted = true;
                                        }
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                }
                                picturec = 64;
                                break;
                            }
                            case 86: {
                                decimalInserted = true;
                                break;
                            }
                            case 67: 
                            case 99: {
                                if (negative && store < this.picForNumberLength) {
                                    this.setChar(store, 'R');
                                    this.setChar(--store, 'C');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 68: 
                            case 100: {
                                if (negative && i < this.picForNumberLength) {
                                    this.setChar(store, 'B');
                                    this.setChar(--store, 'D');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            default: {
                                if (LogSetup.IS_LOGGING_INFO) {
                                    LogSetup.LOGGER.info("switch() default case hit because picturec=" + (char)picturec + " is unaccounted for. Picture=" + String.copyValueOf(this.getPictureArray()) + ". ");
                                }
                                this.setChar(--store, ' ');
                            }
                        }
                    } while (picturec == 57);
                }
            }
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finest("move(String editedNum) 1. Exit for numeric-edited: editedNum=" + editedNum + ". this.toDebugString2()=" + this.toDebugString2() + ". ");
            }
            return this;
        }
        int address = this.pointerAddress;
        if ((this.flagBits & 0x3C000000) == 0x8000000) {
            int i;
            int len4 = this.length();
            if (this.isJustRight()) {
                int insertable = 0;
                for (i = 0; i < len4; ++i) {
                    switch (this.picArray[i]) {
                        case '9': 
                        case 'A': 
                        case 'X': {
                            ++insertable;
                        }
                    }
                }
                load -= insertable - paramLength;
            }
            block66: for (i = 0; i < len4; ++i) {
                switch (this.picArray[i]) {
                    case '9': 
                    case 'A': 
                    case 'X': {
                        this.setChar(i, load >= 0 && load < paramLength ? editedNum.charAt(load) : (char)' ');
                        ++load;
                        ++address;
                        continue block66;
                    }
                    case 'B': {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                        continue block66;
                    }
                    case '0': {
                        this.pointerMemory.setChar(address++, '0');
                        continue block66;
                    }
                    case '/': {
                        this.pointerMemory.setChar(address++, '/');
                        continue block66;
                    }
                    case ':': {
                        this.pointerMemory.setChar(address++, ':');
                        continue block66;
                    }
                    case '@': {
                        this.pointerMemory.setChar(address++, '\u0000');
                    }
                }
            }
            return this;
        }
        byte[] asBytes = editedNum.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = editedNum.getBytes(memoryCharset);
            for (int j = 0; j < asBytes.length; ++j) {
                if (asBytes[j] == -1) continue;
                asBytes[j] = ebcdicBytes[j];
            }
        }
        if (this.isJustRight()) {
            int len5 = this.length(this.pointerMemory.getTopOfMemory() - address);
            if ((load -= len5 - paramLength) > 0) {
                for (int i = 0; i < len5; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[load++]);
                }
                return this;
            }
            if (load < 0) {
                int i;
                load = -load;
                for (i = 0; i < load; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
                for (i = 0; i < paramLength; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[i]);
                }
                return this;
            }
        }
        if (paramLength >= (len = this.length(this.pointerMemory.getTopOfMemory() - address))) {
            for (int i = 0; i < len; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        } else {
            int i;
            for (i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
            for (i = paramLength; i < len; ++i) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
            }
        }
        if (this.isGroup()) {
            this.validateNumericContent();
        }
        return this;
    }

    public Variable move(char[] param, int paramLength) {
        int len;
        if (param == null) {
            param = new char[]{' '};
        }
        this.setDirtyNoFill();
        if (this.isMovableAsNumericEdited()) {
            int i;
            int picturec = 0;
            char CURRENT_DECIMAL = this.getDecimal();
            char CURRENT_COMMA = this.getComma();
            int right_digits = 0;
            int left_digits = 0;
            boolean negative = false;
            boolean possibleCR = false;
            boolean possibleDB = false;
            boolean decimalInserted = false;
            boolean decimalFound = false;
            boolean zero = true;
            int picCurrencyChars = 0;
            int store = this.length();
            int size = paramLength;
            if (this.right_array == null || this.right_array.length < size) {
                this.right_array = new char[size];
                this.left_array = new char[size];
            }
            block40: for (i = 0; i < paramLength; ++i) {
                char c = param[i];
                switch (c) {
                    case '-': {
                        negative = true;
                        possibleCR = false;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'C': 
                    case 'c': {
                        possibleCR = true;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'R': 
                    case 'r': {
                        if (!possibleCR) continue block40;
                        negative = true;
                        continue block40;
                    }
                    case 'D': 
                    case 'd': {
                        possibleDB = true;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'B': 
                    case 'b': {
                        if (!possibleDB) continue block40;
                        negative = true;
                        continue block40;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        zero = false;
                    }
                    case '0': {
                        if (decimalFound) {
                            this.right_array[right_digits] = c;
                            ++right_digits;
                        } else if (!zero) {
                            this.left_array[left_digits] = c;
                            ++left_digits;
                        }
                        possibleCR = false;
                        possibleDB = false;
                        continue block40;
                    }
                    default: {
                        possibleCR = false;
                        possibleDB = false;
                        if (c != CURRENT_DECIMAL) continue block40;
                        decimalFound = true;
                    }
                }
            }
            if (zero) {
                left_digits = 0;
                right_digits = 0;
            }
            int left_string_length = left_digits;
            for (i = 0; i < left_string_length; ++i) {
                if (this.left_array[i] == '0') continue;
                if (i > 0) {
                    System.arraycopy(this.left_array, i, this.left_array, 0, left_digits -= i);
                }
                i = left_string_length + 1;
            }
            if (i == left_string_length) {
                left_digits = 0;
            }
            if (this.scale > 0) {
                if (this.place > 0) {
                    left_digits = 0;
                    System.arraycopy(this.right_array, 0, this.right_array, this.scale, right_digits);
                    right_digits += this.scale;
                    for (i = 0; i < this.scale; ++i) {
                        this.right_array[i] = 48;
                    }
                } else {
                    right_digits = 0;
                    if ((left_digits -= this.scale) < 0) {
                        left_digits = 0;
                    }
                }
            }
            if (left_digits == 0 && right_digits == 0) {
                zero = true;
            }
            for (i = this.picForNumberLength - 1; i >= 0; --i) {
                if (this.picForNumberArray[i] != '$') continue;
                ++picCurrencyChars;
            }
            int len2 = this.length();
            if (zero && this.isBlankWhenZero()) {
                int address = this.pointerAddress;
                for (i = 0; i < len2; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
            } else if (zero && this.isStarredWhenZero()) {
                for (i = this.picLength - 1; i >= 0; --i) {
                    this.setChar(i, this.picArray[i] == '.' ? CURRENT_DECIMAL : (char)'*');
                }
            } else {
                if (this.place == 0) {
                    decimalInserted = true;
                }
                int virtualPlace = this.place;
                picturec = 33;
                for (i = this.picLength - 1; i >= 0 && store > 0; --i) {
                    int lc = picturec;
                    if (lc == 64) {
                        lc = 57;
                    }
                    picturec = this.picArray != null ? this.picArray[i] : (int)this.getPic(i);
                    block47: do {
                        switch (picturec) {
                            case 64: {
                                this.setChar(--store, '\u0000');
                                break;
                            }
                            case 69: {
                                this.setChar(--store, 'E');
                                break;
                            }
                            case 66: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 47: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, '/');
                                break;
                            }
                            case 58: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ':');
                                break;
                            }
                            case 48: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                }
                                this.setChar(--store, '0');
                                break;
                            }
                            case 44: {
                                if (CURRENT_COMMA == ',') {
                                    if (left_digits <= 0 && decimalInserted && i > 0) {
                                        picturec = this.picArray[i - 1];
                                    } else {
                                        this.setChar(--store, CURRENT_COMMA);
                                    }
                                }
                                if (CURRENT_DECIMAL != 44) continue block47;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 46: {
                                if (CURRENT_DECIMAL != 46) continue block47;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 80: {
                                picturec = 57;
                                break;
                            }
                            case 90: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (picCurrencyChars > 1) {
                                                this.setChar(--store, this.getCurrency());
                                                while (store > 0) {
                                                    this.setChar(--store, ' ');
                                                }
                                                continue;
                                            }
                                            this.setChar(--store, ' ');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block47;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 42: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (this.picForNumberArray[store - 1] == 'B') {
                                                this.setChar(--store, ' ');
                                                continue;
                                            }
                                            this.setChar(--store, '*');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block47;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    this.setChar(--store, '*');
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 43: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '+') {
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block47;
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 45: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '-') {
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block47;
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 36: {
                                if (store == 1) {
                                    this.setChar(--store, this.getCurrency());
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    this.setChar(--store, this.getCurrency());
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    if (this.picArray[0] == '-') {
                                        this.setChar(0, negative ? (char)'-' : ' ');
                                        break;
                                    }
                                    if (this.getPic(0) != '+') continue block47;
                                    this.setChar(0, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 57: {
                                if (decimalInserted) {
                                    if (--left_digits >= 0) {
                                        this.setChar(--store, this.left_array[left_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                } else if (virtualPlace > right_digits) {
                                    this.setChar(--store, '0');
                                    --virtualPlace;
                                } else {
                                    if (right_digits > this.place) {
                                        right_digits = this.place;
                                    }
                                    --virtualPlace;
                                    if (--right_digits >= 0) {
                                        this.setChar(--store, this.right_array[right_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                }
                                picturec = 64;
                                break;
                            }
                            case 86: {
                                decimalInserted = true;
                                break;
                            }
                            case 67: 
                            case 99: {
                                if (negative && store < this.picLength) {
                                    this.setChar(store, 'R');
                                    this.setChar(--store, 'C');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 68: 
                            case 100: {
                                if (negative && i < this.picLength) {
                                    this.setChar(store, 'B');
                                    this.setChar(--store, 'D');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            default: {
                                if (LogSetup.IS_LOGGING_INFO) {
                                    LogSetup.LOGGER.info("6 switch() default case hit because picturec=" + (char)picturec + " is unaccounted for. Picture=" + String.copyValueOf(this.getPictureArray()) + ". ");
                                }
                                this.setChar(--store, ' ');
                            }
                        }
                    } while (picturec == 57);
                }
            }
            return this;
        }
        int address = this.pointerAddress;
        int load = 0;
        if ((this.flagBits & 0x1C000000) == 0x8000000) {
            int i;
            int len3 = this.length();
            if (this.isJustRight()) {
                int insertable = 0;
                for (i = 0; i < len3; ++i) {
                    switch (this.picArray[i]) {
                        case '9': 
                        case 'A': 
                        case 'X': {
                            ++insertable;
                        }
                    }
                }
                load = paramLength - insertable;
            }
            block59: for (i = 0; i < len3; ++i) {
                switch (this.picArray[i]) {
                    case '9': 
                    case 'A': 
                    case 'X': {
                        this.pointerMemory.setByte(address++, load >= 0 && load < paramLength ? (byte)param[load] : SPACE_BYTE);
                        ++load;
                        continue block59;
                    }
                    case 'B': {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                        continue block59;
                    }
                    case '0': {
                        this.pointerMemory.setChar(address++, '0');
                        continue block59;
                    }
                    case '/': {
                        this.pointerMemory.setChar(address++, '/');
                        continue block59;
                    }
                    case ':': {
                        this.pointerMemory.setChar(address++, ':');
                        continue block59;
                    }
                    case '@': {
                        this.pointerMemory.setChar(address++, '\u0000');
                    }
                }
            }
            return this;
        }
        String paramString = new String(param);
        byte[] asBytes = paramString.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = paramString.getBytes(memoryCharset);
            for (int j = 0; j < asBytes.length; ++j) {
                if (asBytes[j] == -1) continue;
                asBytes[j] = ebcdicBytes[j];
            }
        }
        if (this.isJustRight()) {
            int len4 = this.length(this.pointerMemory.getTopOfMemory() - address);
            load = paramLength - len4;
            if (load > 0) {
                for (int i = 0; i < len4; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[load++]);
                }
                return this;
            }
            if (load < 0) {
                int i;
                load = -load;
                for (i = 0; i < load; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
                for (i = 0; i < paramLength; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[i]);
                }
                return this;
            }
        }
        if (paramLength >= (len = this.length(this.pointerMemory.getTopOfMemory() - address))) {
            for (int i = 0; i < len; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        } else {
            int i;
            for (i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
            while (i < len) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
                ++i;
            }
        }
        return this;
    }

    public Variable move(char[] param) {
        return this.move(param, param.length);
    }

    public Variable move(char[] param, int paramOffset, int paramLength) {
        int len;
        if (param == null) {
            param = new char[]{' '};
        }
        this.setDirtyNoFill();
        if (this.isMovableAsNumericEdited()) {
            int i;
            int picturec = 0;
            char CURRENT_DECIMAL = this.getDecimal();
            char CURRENT_COMMA = this.getComma();
            int picCurrencyChars = 0;
            int right_digits = 0;
            int left_digits = 0;
            boolean negative = false;
            boolean possibleCR = false;
            boolean possibleDB = false;
            boolean decimalInserted = false;
            boolean decimalFound = false;
            boolean zero = true;
            int store = this.length();
            int size = paramLength;
            if (this.right_array == null || this.right_array.length < size) {
                this.right_array = new char[size];
                this.left_array = new char[size];
            }
            block40: for (i = 0; i < paramLength; ++i) {
                char c = param[i + paramOffset];
                switch (c) {
                    case '-': {
                        negative = true;
                        possibleCR = false;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'C': 
                    case 'c': {
                        possibleCR = true;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'R': 
                    case 'r': {
                        if (!possibleCR) continue block40;
                        negative = true;
                        continue block40;
                    }
                    case 'D': 
                    case 'd': {
                        possibleDB = true;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'B': 
                    case 'b': {
                        if (!possibleDB) continue block40;
                        negative = true;
                        continue block40;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        zero = false;
                    }
                    case '0': {
                        if (decimalFound) {
                            this.right_array[right_digits] = c;
                            ++right_digits;
                        } else if (!zero) {
                            this.left_array[left_digits] = c;
                            ++left_digits;
                        }
                        possibleCR = false;
                        possibleDB = false;
                        continue block40;
                    }
                    default: {
                        possibleCR = false;
                        possibleDB = false;
                        if (c != CURRENT_DECIMAL) continue block40;
                        decimalFound = true;
                    }
                }
            }
            if (zero) {
                left_digits = 0;
                right_digits = 0;
            }
            int left_string_length = left_digits;
            for (i = 0; i < left_string_length; ++i) {
                if (this.left_array[i] == '0') continue;
                if (i > 0) {
                    System.arraycopy(this.left_array, i, this.left_array, 0, left_digits -= i);
                }
                i = left_string_length + 1;
            }
            if (i == left_string_length) {
                left_digits = 0;
            }
            if (this.scale > 0) {
                if (this.place > 0) {
                    left_digits = 0;
                    System.arraycopy(this.right_array, 0, this.right_array, this.scale, right_digits);
                    right_digits += this.scale;
                    for (i = 0; i < this.scale; ++i) {
                        this.right_array[i] = 48;
                    }
                } else {
                    right_digits = 0;
                    if ((left_digits -= this.scale) < 0) {
                        left_digits = 0;
                    }
                }
            }
            if (left_digits == 0 && right_digits == 0) {
                zero = true;
            }
            for (i = this.picForNumberLength - 1; i >= 0; --i) {
                if (this.picForNumberArray[i] != '$') continue;
                ++picCurrencyChars;
            }
            if (zero && this.isBlankWhenZero()) {
                int address = this.pointerAddress;
                int len2 = this.length();
                for (i = 0; i < len2; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
            } else if (zero && this.isStarredWhenZero()) {
                for (i = this.picLength - 1; i >= 0; --i) {
                    this.setChar(i, this.picArray[i] == '.' ? CURRENT_DECIMAL : (char)'*');
                }
            } else {
                if (this.place == 0) {
                    decimalInserted = true;
                }
                int virtualPlace = this.place;
                picturec = 33;
                for (i = this.picLength - 1; i >= 0 && store > 0; --i) {
                    int lc = picturec;
                    if (lc == 64) {
                        lc = 57;
                    }
                    picturec = this.picArray != null ? this.picArray[i] : (int)this.getPic(i);
                    block47: do {
                        switch (picturec) {
                            case 64: {
                                this.setChar(--store, '\u0000');
                                break;
                            }
                            case 69: {
                                this.setChar(--store, 'E');
                                break;
                            }
                            case 66: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 47: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, '/');
                                break;
                            }
                            case 58: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ':');
                                break;
                            }
                            case 48: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                }
                                this.setChar(--store, '0');
                                break;
                            }
                            case 44: {
                                if (CURRENT_COMMA == ',') {
                                    if (left_digits <= 0 && decimalInserted && i > 0) {
                                        picturec = this.picArray[i - 1];
                                    } else {
                                        this.setChar(--store, CURRENT_COMMA);
                                    }
                                }
                                if (CURRENT_DECIMAL != 44) continue block47;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 46: {
                                if (CURRENT_DECIMAL != 46) continue block47;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 80: {
                                picturec = 57;
                                break;
                            }
                            case 90: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (picCurrencyChars > 1) {
                                                this.setChar(--store, this.getCurrency());
                                                while (store > 0) {
                                                    this.setChar(--store, ' ');
                                                }
                                                continue;
                                            }
                                            this.setChar(--store, ' ');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block47;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 42: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (this.picForNumberArray[store - 1] == 'B') {
                                                this.setChar(--store, ' ');
                                                continue;
                                            }
                                            this.setChar(--store, '*');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block47;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    this.setChar(--store, '*');
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 43: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '+') {
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block47;
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 45: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '-') {
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block47;
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 36: {
                                if (store == 1) {
                                    this.setChar(--store, this.getCurrency());
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    this.setChar(--store, this.getCurrency());
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    if (this.picArray[0] == '-') {
                                        this.setChar(0, negative ? (char)'-' : ' ');
                                        break;
                                    }
                                    if (this.getPic(0) != '+') continue block47;
                                    this.setChar(0, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 57: {
                                if (decimalInserted) {
                                    if (--left_digits >= 0) {
                                        this.setChar(--store, this.left_array[left_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                } else if (virtualPlace > right_digits) {
                                    this.setChar(--store, '0');
                                    --virtualPlace;
                                } else {
                                    if (right_digits > this.place) {
                                        right_digits = this.place;
                                    }
                                    --virtualPlace;
                                    if (--right_digits >= 0) {
                                        this.setChar(--store, this.right_array[right_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                }
                                picturec = 64;
                                break;
                            }
                            case 86: {
                                decimalInserted = true;
                                break;
                            }
                            case 67: 
                            case 99: {
                                if (negative && store < this.picLength) {
                                    this.setChar(store, 'R');
                                    this.setChar(--store, 'C');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 68: 
                            case 100: {
                                if (negative && i < this.picLength) {
                                    this.setChar(store, 'B');
                                    this.setChar(--store, 'D');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            default: {
                                if (LogSetup.IS_LOGGING_INFO) {
                                    LogSetup.LOGGER.info("7 switch() default case hit because picturec=" + (char)picturec + " is unaccounted for. Picture=" + String.copyValueOf(this.getPictureArray()) + ". ");
                                }
                                this.setChar(--store, ' ');
                            }
                        }
                    } while (picturec == 57);
                }
            }
            return this;
        }
        int load = 0;
        int address = this.pointerAddress;
        if ((this.flagBits & 0x1C000000) == 0x8000000) {
            int i;
            if (this.isJustRight()) {
                int insertable = 0;
                int len3 = this.length();
                for (i = 0; i < len3; ++i) {
                    switch (this.picArray[i]) {
                        case '9': 
                        case 'A': 
                        case 'X': {
                            ++insertable;
                        }
                    }
                }
                load = paramLength - insertable;
            }
            int len4 = this.length();
            block59: for (i = 0; i < len4; ++i) {
                switch (this.picArray[i]) {
                    case '9': 
                    case 'A': 
                    case 'X': {
                        this.pointerMemory.setByte(address++, load >= 0 && load < paramLength ? (byte)param[paramOffset + load] : SPACE_BYTE);
                        ++load;
                        continue block59;
                    }
                    case 'B': {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                        continue block59;
                    }
                    case '0': {
                        this.pointerMemory.setChar(address++, '0');
                        continue block59;
                    }
                    case '/': {
                        this.pointerMemory.setChar(address++, '/');
                        continue block59;
                    }
                    case ':': {
                        this.pointerMemory.setChar(address++, ':');
                        continue block59;
                    }
                    case '@': {
                        this.pointerMemory.setChar(address++, '\u0000');
                    }
                }
            }
            return this;
        }
        String paramString = new String(param, paramOffset, paramLength);
        byte[] asBytes = paramString.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = paramString.getBytes(memoryCharset);
            for (int j = 0; j < asBytes.length; ++j) {
                if (asBytes[j] == -1) continue;
                asBytes[j] = ebcdicBytes[j];
            }
        }
        if (this.isJustRight()) {
            int len5 = this.length(this.pointerMemory.getTopOfMemory() - address);
            load = paramLength - len5;
            if (load > 0) {
                for (int i = 0; i < len5; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[i]);
                }
                return this;
            }
            if (load < 0) {
                int i;
                load = -load;
                for (i = 0; i < load; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
                for (i = 0; i < paramLength; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[i]);
                }
                return this;
            }
        }
        if (paramLength >= (len = this.length(this.pointerMemory.getTopOfMemory() - address))) {
            for (int i = 0; i < len; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        } else {
            int i;
            for (i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
            while (i < this.length()) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
                ++i;
            }
        }
        return this;
    }

    public Variable move(byte[] param) {
        return this.move(param, 0, param.length);
    }

    public Variable move(byte[] param, int paramLength) {
        return this.move(param, 0, paramLength);
    }

    public Variable move(byte[] param, int paramOffset, int paramLength) {
        int len;
        if (param == null) {
            this.initData();
            return this;
        }
        this.setDirtyNoFill();
        if (this.isMovableAsNumericEdited()) {
            int i;
            int picturec = 0;
            char CURRENT_DECIMAL = this.getDecimal();
            char CURRENT_COMMA = this.getComma();
            int picCurrencyChars = 0;
            int right_digits = 0;
            int left_digits = 0;
            boolean negative = false;
            boolean possibleCR = false;
            boolean possibleDB = false;
            boolean decimalInserted = false;
            boolean decimalFound = false;
            boolean zero = true;
            int store = this.length();
            int size = paramLength;
            if (this.right_array == null || this.right_array.length < size) {
                this.right_array = new char[size];
                this.left_array = new char[size];
            }
            block40: for (i = 0; i < paramLength; ++i) {
                char c = (char)(param[i + paramOffset] & 0xFF);
                switch (c) {
                    case '-': {
                        negative = true;
                        possibleCR = false;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'C': 
                    case 'c': {
                        possibleCR = true;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'R': 
                    case 'r': {
                        if (!possibleCR) continue block40;
                        negative = true;
                        continue block40;
                    }
                    case 'D': 
                    case 'd': {
                        possibleDB = true;
                        possibleDB = false;
                        continue block40;
                    }
                    case 'B': 
                    case 'b': {
                        if (!possibleDB) continue block40;
                        negative = true;
                        continue block40;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        zero = false;
                    }
                    case '0': {
                        if (decimalFound) {
                            this.right_array[right_digits] = c;
                            ++right_digits;
                        } else if (!zero) {
                            this.left_array[left_digits] = c;
                            ++left_digits;
                        }
                        possibleCR = false;
                        possibleDB = false;
                        continue block40;
                    }
                    default: {
                        possibleCR = false;
                        possibleDB = false;
                        if (c != CURRENT_DECIMAL) continue block40;
                        decimalFound = true;
                    }
                }
            }
            if (zero) {
                left_digits = 0;
                right_digits = 0;
            }
            int left_string_length = left_digits;
            for (i = 0; i < left_string_length; ++i) {
                if (this.left_array[i] == '0') continue;
                if (i > 0) {
                    System.arraycopy(this.left_array, i, this.left_array, 0, left_digits -= i);
                }
                i = left_string_length + 1;
            }
            if (i == left_string_length) {
                left_digits = 0;
            }
            if (this.scale > 0) {
                if (this.place > 0) {
                    left_digits = 0;
                    System.arraycopy(this.right_array, 0, this.right_array, this.scale, right_digits);
                    right_digits += this.scale;
                    for (i = 0; i < this.scale; ++i) {
                        this.right_array[i] = 48;
                    }
                } else {
                    right_digits = 0;
                    if ((left_digits -= this.scale) < 0) {
                        left_digits = 0;
                    }
                }
            }
            if (left_digits == 0 && right_digits == 0) {
                zero = true;
            }
            for (i = this.picForNumberLength - 1; i >= 0; --i) {
                if (this.picForNumberArray[i] != '$') continue;
                ++picCurrencyChars;
            }
            if (zero && this.isBlankWhenZero()) {
                int address = this.pointerAddress;
                int len2 = this.length();
                for (i = 0; i < len2; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
            } else if (zero && this.isStarredWhenZero()) {
                for (i = this.picLength - 1; i >= 0; --i) {
                    this.setChar(i, this.picArray[i] == '.' ? CURRENT_DECIMAL : (char)'*');
                }
            } else {
                if (this.place == 0) {
                    decimalInserted = true;
                }
                int virtualPlace = this.place;
                picturec = 33;
                for (i = this.picLength - 1; i >= 0 && store > 0; --i) {
                    int lc = picturec;
                    if (lc == 64) {
                        lc = 57;
                    }
                    picturec = this.picArray != null ? this.picArray[i] : (int)this.getPic(i);
                    block47: do {
                        switch (picturec) {
                            case 64: {
                                this.setChar(--store, '\u0000');
                                break;
                            }
                            case 69: {
                                this.setChar(--store, 'E');
                                break;
                            }
                            case 66: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 47: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, '/');
                                break;
                            }
                            case 58: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ':');
                                break;
                            }
                            case 48: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                }
                                this.setChar(--store, '0');
                                break;
                            }
                            case 44: {
                                if (CURRENT_COMMA == ',') {
                                    if (left_digits <= 0 && decimalInserted && i > 0) {
                                        picturec = this.picArray[i - 1];
                                    } else {
                                        this.setChar(--store, CURRENT_COMMA);
                                    }
                                }
                                if (CURRENT_DECIMAL != 44) continue block47;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 46: {
                                if (CURRENT_DECIMAL != 46) continue block47;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 80: {
                                picturec = 57;
                                break;
                            }
                            case 90: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (picCurrencyChars > 1) {
                                                this.setChar(--store, this.getCurrency());
                                                while (store > 0) {
                                                    this.setChar(--store, ' ');
                                                }
                                                continue;
                                            }
                                            this.setChar(--store, ' ');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block47;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 42: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (this.picForNumberArray[store - 1] == 'B') {
                                                this.setChar(--store, ' ');
                                                continue;
                                            }
                                            this.setChar(--store, '*');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block47;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    this.setChar(--store, '*');
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 43: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '+') {
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block47;
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 45: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '-') {
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block47;
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 36: {
                                if (store == 1) {
                                    this.setChar(--store, this.getCurrency());
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    this.setChar(--store, this.getCurrency());
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    if (this.picArray[0] == '-') {
                                        this.setChar(0, negative ? (char)'-' : ' ');
                                        break;
                                    }
                                    if (this.getPic(0) != '+') continue block47;
                                    this.setChar(0, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 57: {
                                if (decimalInserted) {
                                    if (--left_digits >= 0) {
                                        this.setChar(--store, this.left_array[left_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                } else if (virtualPlace > right_digits) {
                                    this.setChar(--store, '0');
                                    --virtualPlace;
                                } else {
                                    if (right_digits > this.place) {
                                        right_digits = this.place;
                                    }
                                    --virtualPlace;
                                    if (--right_digits >= 0) {
                                        this.setChar(--store, this.right_array[right_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                }
                                picturec = 64;
                                break;
                            }
                            case 86: {
                                decimalInserted = true;
                                break;
                            }
                            case 67: 
                            case 99: {
                                if (negative && store < this.picLength) {
                                    this.setChar(store, 'R');
                                    this.setChar(--store, 'C');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 68: 
                            case 100: {
                                if (negative && i < this.picLength) {
                                    this.setChar(store, 'B');
                                    this.setChar(--store, 'D');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            default: {
                                this.setChar(--store, ' ');
                            }
                        }
                    } while (picturec == 57);
                }
            }
            return this;
        }
        int load = 0;
        int address = this.pointerAddress;
        if ((this.flagBits & 0x1C000000) == 0x8000000) {
            int i;
            if (this.isJustRight()) {
                int insertable = 0;
                int len3 = this.length();
                for (i = 0; i < len3; ++i) {
                    switch (this.picArray[i]) {
                        case '9': 
                        case 'A': 
                        case 'X': {
                            ++insertable;
                        }
                    }
                }
                load = paramLength - insertable;
            }
            int len4 = this.length();
            block59: for (i = 0; i < len4; ++i) {
                switch (this.picArray[i]) {
                    case '9': 
                    case 'A': 
                    case 'X': {
                        this.pointerMemory.setByte(address++, load >= 0 && load < paramLength ? param[paramOffset + load] : SPACE_BYTE);
                        ++load;
                        continue block59;
                    }
                    case 'B': {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                        continue block59;
                    }
                    case '0': {
                        this.pointerMemory.setChar(address++, '0');
                        continue block59;
                    }
                    case '/': {
                        this.pointerMemory.setChar(address++, '/');
                        continue block59;
                    }
                    case ':': {
                        this.pointerMemory.setChar(address++, ':');
                        continue block59;
                    }
                    case '@': {
                        this.pointerMemory.setChar(address++, '\u0000');
                    }
                }
            }
            return this;
        }
        byte[] asBytes = new byte[paramLength];
        System.arraycopy(param, paramOffset, asBytes, 0, paramLength);
        if (this.isJustRight()) {
            len = this.length(this.pointerMemory.getTopOfMemory() - address);
            load = paramLength - len;
            if (load > 0) {
                for (int i = 0; i < len; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[load + i]);
                }
                return this;
            }
            if (load < 0) {
                int i;
                load = -load;
                for (i = 0; i < load; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
                for (i = 0; i < paramLength; ++i) {
                    this.pointerMemory.setByte(address++, asBytes[i]);
                }
                return this;
            }
        }
        if (paramLength >= (len = this.length(this.pointerMemory.getTopOfMemory() - address))) {
            for (int i = 0; i < len; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
        } else {
            int i;
            for (i = 0; i < paramLength; ++i) {
                this.pointerMemory.setByte(address++, asBytes[i]);
            }
            while (i < len) {
                this.pointerMemory.setByte(address++, SPACE_BYTE);
                ++i;
            }
        }
        return this;
    }

    public Variable moveMax(String param) {
        this.move(param);
        return this;
    }

    public Variable moveAll(char param) {
        byte paramByte;
        this.setDirtyNoFill();
        int paramLength = this.length();
        if (this.isMovableAsNumericEdited()) {
            int i;
            int picturec = 0;
            char CURRENT_DECIMAL = this.getDecimal();
            char CURRENT_COMMA = this.getComma();
            int picCurrencyChars = 0;
            int right_digits = 0;
            int left_digits = 0;
            boolean negative = false;
            boolean possibleCR = false;
            boolean possibleDB = false;
            boolean decimalInserted = false;
            boolean decimalFound = false;
            boolean zero = true;
            int store = this.length();
            int size = paramLength;
            if (this.right_array == null || this.right_array.length < size) {
                this.right_array = new char[size];
                this.left_array = new char[size];
            }
            block42: for (i = 0; i < paramLength; ++i) {
                char c = param;
                switch (c) {
                    case '-': {
                        negative = true;
                        possibleCR = false;
                        possibleDB = false;
                        continue block42;
                    }
                    case 'C': 
                    case 'c': {
                        possibleCR = true;
                        possibleDB = false;
                        continue block42;
                    }
                    case 'R': 
                    case 'r': {
                        if (!possibleCR) continue block42;
                        negative = true;
                        continue block42;
                    }
                    case 'D': 
                    case 'd': {
                        possibleDB = true;
                        possibleDB = false;
                        continue block42;
                    }
                    case 'B': 
                    case 'b': {
                        if (!possibleDB) continue block42;
                        negative = true;
                        continue block42;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        zero = false;
                    }
                    case '0': {
                        if (decimalFound) {
                            this.right_array[right_digits] = c;
                            ++right_digits;
                        } else if (!zero) {
                            this.left_array[left_digits] = c;
                            ++left_digits;
                        }
                        possibleCR = false;
                        possibleDB = false;
                        continue block42;
                    }
                    default: {
                        possibleCR = false;
                        possibleDB = false;
                        if (c != CURRENT_DECIMAL) continue block42;
                        decimalFound = true;
                    }
                }
            }
            if (zero) {
                left_digits = 0;
                right_digits = 0;
            }
            int left_string_length = left_digits;
            for (i = 0; i < left_string_length; ++i) {
                if (this.left_array[i] == '0') continue;
                if (i > 0) {
                    System.arraycopy(this.left_array, i, this.left_array, 0, left_digits -= i);
                }
                i = left_string_length + 1;
            }
            if (i == left_string_length) {
                left_digits = 0;
            }
            if (this.scale > 0) {
                if (this.place > 0) {
                    left_digits = 0;
                    System.arraycopy(this.right_array, 0, this.right_array, this.scale, right_digits);
                    right_digits += this.scale;
                    for (i = 0; i < this.scale; ++i) {
                        this.right_array[i] = 48;
                    }
                } else {
                    right_digits = 0;
                    if ((left_digits -= this.scale) < 0) {
                        left_digits = 0;
                    }
                }
            }
            if (left_digits == 0 && right_digits == 0) {
                zero = true;
            }
            for (i = this.picForNumberLength - 1; i >= 0; --i) {
                if (this.picForNumberArray[i] != '$') continue;
                ++picCurrencyChars;
            }
            if (zero && this.isBlankWhenZero()) {
                int address = this.pointerAddress;
                int len = this.length();
                for (i = 0; i < len; ++i) {
                    this.pointerMemory.setByte(address++, SPACE_BYTE);
                }
            } else if (zero && this.isStarredWhenZero()) {
                for (i = this.picLength - 1; i >= 0; --i) {
                    this.setChar(i, this.picArray[i] == '.' ? CURRENT_DECIMAL : (char)'*');
                }
            } else {
                if (this.place == 0) {
                    decimalInserted = true;
                }
                int virtualPlace = this.place;
                picturec = 33;
                for (i = this.picLength - 1; i >= 0 && store > 0; --i) {
                    int lc = picturec;
                    if (lc == 64) {
                        lc = 57;
                    }
                    picturec = this.picArray != null ? this.picArray[i] : (int)this.getPic(i);
                    block49: do {
                        switch (picturec) {
                            case 64: {
                                this.setChar(--store, '\u0000');
                                break;
                            }
                            case 69: {
                                this.setChar(--store, 'E');
                                break;
                            }
                            case 66: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 47: {
                                if (left_digits <= 0 && decimalInserted && i > 0 && picCurrencyChars > 1) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, '/');
                                break;
                            }
                            case 58: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                    break;
                                }
                                this.setChar(--store, ':');
                                break;
                            }
                            case 48: {
                                if (left_digits <= 0 && decimalInserted && i > 0) {
                                    picturec = this.picArray[i - 1];
                                }
                                this.setChar(--store, '0');
                                break;
                            }
                            case 44: {
                                if (CURRENT_COMMA == ',') {
                                    if (left_digits <= 0 && decimalInserted && i > 0) {
                                        picturec = this.picArray[i - 1];
                                    } else {
                                        this.setChar(--store, CURRENT_COMMA);
                                    }
                                }
                                if (CURRENT_DECIMAL != 44) continue block49;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 46: {
                                if (CURRENT_DECIMAL != 46) continue block49;
                                this.setChar(--store, CURRENT_DECIMAL);
                                decimalInserted = true;
                                break;
                            }
                            case 80: {
                                picturec = 57;
                                break;
                            }
                            case 90: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (picCurrencyChars > 1) {
                                                this.setChar(--store, this.getCurrency());
                                                while (store > 0) {
                                                    this.setChar(--store, ' ');
                                                }
                                                continue;
                                            }
                                            this.setChar(--store, ' ');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block49;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 42: {
                                if (decimalInserted) {
                                    if (left_digits <= 0) {
                                        while (store > 0) {
                                            if (store == 1 && this.picForNumberArray[0] == '$') {
                                                this.setChar(--store, this.getCurrency());
                                                continue;
                                            }
                                            if (this.picForNumberArray[store - 1] == 'B') {
                                                this.setChar(--store, ' ');
                                                continue;
                                            }
                                            this.setChar(--store, '*');
                                        }
                                        i = -1;
                                        if (this.picArray[0] == '-') {
                                            this.setChar(0, negative ? (char)'-' : ' ');
                                            break;
                                        }
                                        if (this.getPic(0) != '+') continue block49;
                                        this.setChar(0, negative ? (char)'-' : '+');
                                        break;
                                    }
                                    picturec = 57;
                                    break;
                                }
                                if (zero) {
                                    this.setChar(--store, '*');
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 43: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '+') {
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block49;
                                    this.setChar(--store, negative ? (char)'-' : '+');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 45: {
                                if (store == 1 || store == this.length() && i > 0 && this.picArray[i - 1] != '-') {
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    if (left_digits > 0) continue block49;
                                    this.setChar(--store, negative ? (char)'-' : ' ');
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 36: {
                                if (store == 1) {
                                    this.setChar(--store, this.getCurrency());
                                    break;
                                }
                                if (decimalInserted) {
                                    if (left_digits > 0) {
                                        picturec = 57;
                                        break;
                                    }
                                    this.setChar(--store, this.getCurrency());
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    if (this.picArray[0] == '-') {
                                        this.setChar(0, negative ? (char)'-' : ' ');
                                        break;
                                    }
                                    if (this.picArray[0] != '+') continue block49;
                                    this.setChar(0, negative ? (char)'-' : '+');
                                    break;
                                }
                                if (zero) {
                                    while (store > 0) {
                                        this.setChar(--store, ' ');
                                    }
                                    i = -1;
                                    break;
                                }
                                picturec = 57;
                                break;
                            }
                            case 57: {
                                if (decimalInserted) {
                                    if (--left_digits >= 0) {
                                        this.setChar(--store, this.left_array[left_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                } else if (virtualPlace > right_digits) {
                                    this.setChar(--store, '0');
                                    --virtualPlace;
                                } else {
                                    if (right_digits > this.place) {
                                        right_digits = this.place;
                                    }
                                    --virtualPlace;
                                    if (--right_digits >= 0) {
                                        this.setChar(--store, this.right_array[right_digits]);
                                    } else {
                                        this.setChar(--store, '0');
                                    }
                                }
                                picturec = 64;
                                break;
                            }
                            case 86: {
                                decimalInserted = true;
                                break;
                            }
                            case 67: 
                            case 99: {
                                if (negative && store < this.picLength) {
                                    this.setChar(store, 'R');
                                    this.setChar(--store, 'C');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            case 68: 
                            case 100: {
                                if (negative && i < this.picLength) {
                                    this.setChar(store, 'B');
                                    this.setChar(--store, 'D');
                                    break;
                                }
                                this.setChar(store, ' ');
                                this.setChar(--store, ' ');
                                break;
                            }
                            default: {
                                if (LogSetup.IS_LOGGING_INFO) {
                                    LogSetup.LOGGER.info(" 8 switch() default case hit because picturec=" + (char)picturec + " is unaccounted for. Picture=" + String.copyValueOf(this.getPictureArray()) + ". ");
                                }
                                this.setChar(--store, ' ');
                            }
                        }
                    } while (picturec == 57);
                }
            }
            return this;
        }
        int address = this.pointerAddress;
        if ((this.flagBits & 0x1C000000) == 0x8000000) {
            int i;
            int load = 0;
            int len = this.length();
            if (this.isJustRight()) {
                int insertable = 0;
                for (i = 0; i < len; ++i) {
                    switch (this.picArray[i]) {
                        case '9': 
                        case 'A': 
                        case 'X': {
                            ++insertable;
                        }
                    }
                }
                load = paramLength - insertable;
            }
            block61: for (i = 0; i < len; ++i) {
                switch (this.picArray[i]) {
                    case '9': 
                    case 'A': 
                    case 'X': {
                        this.pointerMemory.setByte(address++, load >= 0 && load < paramLength ? (byte)param : SPACE_BYTE);
                        ++load;
                        continue block61;
                    }
                    case 'B': {
                        this.pointerMemory.setByte(address++, SPACE_BYTE);
                        continue block61;
                    }
                    case '0': {
                        this.pointerMemory.setChar(address++, '0');
                        continue block61;
                    }
                    case '/': {
                        this.pointerMemory.setChar(address++, '/');
                        continue block61;
                    }
                    case ':': {
                        this.pointerMemory.setChar(address++, ':');
                        continue block61;
                    }
                    case '@': {
                        this.pointerMemory.setChar(address++, '\u0000');
                    }
                }
            }
            return this;
        }
        if (byteEncoding == null) {
            paramByte = (byte)param;
        } else {
            String s = DEFAULT_NAME + param;
            try {
                paramByte = s.getBytes(byteEncoding)[0];
            }
            catch (UnsupportedEncodingException e) {
                paramByte = (byte)param;
            }
        }
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.pointerMemory.setByte(address++, paramByte);
        }
        return this;
    }

    public final boolean string(Variable sendString, String delimiter, Numeric pointer) {
        return this.string(sendString.toString(), delimiter, pointer);
    }

    public final boolean string(Variable sendString, byte[] delimiter_byte, Numeric pointer) {
        String delimiter = new String(delimiter_byte, StandardCharsets.UTF_8);
        return this.string(sendString.toString(), delimiter, pointer);
    }

    public final boolean string(String sendString, Numeric pointer) {
        return this.string(sendString, null, pointer);
    }

    public final boolean string(byte[] sendString, Numeric pointer) {
        return this.string(new String(sendString), null, pointer);
    }

    public final boolean string(byte[] sendString, String delimiter, Numeric pointer) {
        return this.string(new String(sendString), delimiter, pointer);
    }

    public final boolean string(String sendString, String delimiter, Numeric pointer) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        this.setDirty();
        int address = this.pointerAddress;
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.setChar(pointerValue++, sendString.charAt(i));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.setChar(pointerValue++, sendString.charAt(i));
        }
        pointer.move(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, Numeric pointer) {
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        this.setDirty();
        int address = this.pointerAddress;
        sendString.flushToMemory();
        int delimiterValue = sendString.length();
        int sendStringOffset = sendString.pointerAddress;
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
        }
        pointer.move(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, byte[] delimiter_byte, Index pointer) {
        String delimiter = new String(delimiter_byte, StandardCharsets.UTF_8);
        return this.string(sendString.toString(), delimiter, pointer);
    }

    public final boolean string(Variable sendString, String delimiter, Index pointer) {
        return this.string(sendString.toString(), delimiter, pointer);
    }

    public final boolean string(String sendString, Index pointer) {
        return this.string(sendString, null, pointer);
    }

    public final boolean string(byte[] sendString, Index pointer) {
        return this.string(new String(sendString), null, pointer);
    }

    public final boolean string(byte[] sendString, String delimiter, Index pointer) {
        return this.string(new String(sendString), delimiter, pointer);
    }

    public final boolean string(String sendString, String delimiter, Index pointer) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        this.setDirty();
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.setChar(pointerValue++, sendString.charAt(i));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.setChar(pointerValue++, sendString.charAt(i));
        }
        pointer.setToValue(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, Index pointer) {
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        this.setDirty();
        int address = this.pointerAddress;
        sendString.flushToMemory();
        int delimiterValue = sendString.length();
        int sendStringOffset = sendString.pointerAddress;
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
            }
            pointer.setToValue(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
        }
        pointer.setToValue(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, String delimiter, Numeric pointer, boolean international) {
        return this.string(sendString.toString(), delimiter, pointer, international);
    }

    public final boolean string(String sendString, Numeric pointer, boolean international) {
        return this.string(sendString, null, pointer, international);
    }

    public final boolean string(byte[] sendString, Numeric pointer, boolean international) {
        return this.string(new String(sendString), null, pointer, international);
    }

    public final boolean string(byte[] sendString, String delimiter, Numeric pointer, boolean international) {
        return this.string(new String(sendString), delimiter, pointer, international);
    }

    public final boolean string(String sendString, String delimiter, Numeric pointer, boolean international) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        this.setDirty();
        if (international) {
            pointerValue *= 2;
        }
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.setChar(pointerValue++, sendString.charAt(i));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.setChar(pointerValue++, sendString.charAt(i));
        }
        if (international) {
            pointerValue /= 2;
        }
        pointer.move(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, Numeric pointer, boolean international) {
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        this.setDirty();
        int address = this.pointerAddress;
        if (international) {
            pointerValue *= 2;
        }
        sendString.flushToMemory();
        int delimiterValue = sendString.length();
        int sendStringOffset = sendString.pointerAddress;
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
        }
        if (international) {
            pointerValue /= 2;
        }
        pointer.move(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, String delimiter, Index pointer, boolean international) {
        return this.string(sendString.toString(), delimiter, pointer, international);
    }

    public final boolean string(String sendString, Index pointer, boolean international) {
        return this.string(sendString, null, pointer, international);
    }

    public final boolean string(byte[] sendString, Index pointer, boolean international) {
        return this.string(new String(sendString), null, pointer, international);
    }

    public final boolean string(byte[] sendString, String delimiter, Index pointer, boolean international) {
        return this.string(new String(sendString), delimiter, pointer, international);
    }

    public final boolean string(String sendString, String delimiter, Index pointer, boolean international) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (international) {
            pointerValue *= 2;
        }
        this.setDirty();
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.setChar(pointerValue++, sendString.charAt(i));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.setChar(pointerValue++, sendString.charAt(i));
        }
        if (international) {
            pointerValue /= 2;
        }
        pointer.setToValue(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public final boolean string(Variable sendString, Index pointer, boolean international) {
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (international) {
            pointerValue *= 2;
        }
        this.setDirty();
        int address = this.pointerAddress;
        sendString.flushToMemory();
        int delimiterValue = sendString.length();
        int sendStringOffset = sendString.pointerAddress;
        if (pointerValue + delimiterValue > this.length()) {
            int loopMax = this.length() - pointerValue;
            for (int i = 0; i < loopMax; ++i) {
                this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
            }
            pointer.move(pointerValue + 1);
            this.fillFromMemory();
            return true;
        }
        for (int i = 0; i < delimiterValue; ++i) {
            this.pointerMemory.setByte(address + pointerValue++, sendString.getMemory().getByte(sendStringOffset++));
        }
        if (international) {
            pointerValue /= 2;
        }
        pointer.setToValue(++pointerValue);
        this.fillFromMemory();
        return false;
    }

    public static final boolean string(byte[] sendString, String delimiter, Numeric pointer, StringBuffer intoString) {
        return Variable.string(new String(sendString), delimiter, pointer, intoString);
    }

    public static final boolean string(String sendString, String delimiter, Numeric pointer, StringBuffer intoString) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        int intoStringLength = intoString.capacity();
        for (int i = 0; i < delimiterValue; ++i) {
            if (pointerValue >= intoStringLength) {
                pointer.move(pointerValue + 1);
                return true;
            }
            char c = sendString.charAt(i);
            try {
                intoString.setCharAt(pointerValue, c);
            }
            catch (StringIndexOutOfBoundsException e) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch (StringIndexOutOfBoundsException e)");
                    e.printStackTrace();
                }
                intoString.append(c);
            }
            ++pointerValue;
        }
        pointer.move(++pointerValue);
        return false;
    }

    public static final boolean string(byte[] sendString, String delimiter, Numeric pointer, char[] intoString) {
        return Variable.string(new String(sendString), delimiter, pointer, intoString);
    }

    public static final boolean string(String sendString, String delimiter, Numeric pointer, char[] intoString) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        int intoStringLength = intoString.length;
        for (int i = 0; i < delimiterValue; ++i) {
            if (pointerValue >= intoStringLength) {
                pointer.move(pointerValue + 1);
                return true;
            }
            intoString[pointerValue] = sendString.charAt(i);
            ++pointerValue;
        }
        pointer.move(++pointerValue);
        return false;
    }

    public static final boolean string(byte[] sendString, String delimiter, Index pointer, char[] intoString) {
        return Variable.string(new String(sendString), delimiter, pointer, intoString);
    }

    public static final boolean string(String sendString, String delimiter, Index pointer, char[] intoString) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        int intoStringLength = intoString.length;
        for (int i = 0; i < delimiterValue; ++i) {
            if (pointerValue >= intoStringLength) {
                pointer.setToValue(pointerValue + 1);
                return true;
            }
            intoString[pointerValue++] = sendString.charAt(i);
        }
        pointer.setToValue(++pointerValue);
        return false;
    }

    public static final boolean string(byte[] sendString, String delimiter, Numeric pointer, char[] intoString, boolean international) {
        return Variable.string(new String(sendString), delimiter, pointer, intoString, international);
    }

    public static final boolean string(String sendString, String delimiter, Numeric pointer, char[] intoString, boolean international) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (international) {
            pointerValue *= 2;
        }
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        int intoStringLength = intoString.length;
        for (int i = 0; i < delimiterValue; ++i) {
            if (pointerValue >= intoStringLength) {
                pointer.move(pointerValue + 1);
                return true;
            }
            intoString[pointerValue] = sendString.charAt(i);
            ++pointerValue;
        }
        if (international) {
            pointerValue /= 2;
        }
        pointer.move(++pointerValue);
        return false;
    }

    public static final boolean string(byte[] sendString, String delimiter, Index pointer, char[] intoString, boolean international) {
        return Variable.string(new String(sendString), delimiter, pointer, intoString, international);
    }

    public static final boolean string(String sendString, String delimiter, Index pointer, char[] intoString, boolean international) {
        int delimiterValue;
        int pointerValue = pointer.toInt();
        if (pointerValue < 1) {
            return true;
        }
        --pointerValue;
        if (international) {
            pointerValue *= 2;
        }
        if (delimiter == null || delimiter.length() == 0 || (delimiterValue = sendString.indexOf(delimiter)) == -1) {
            delimiterValue = sendString.length();
        }
        int intoStringLength = intoString.length;
        for (int i = 0; i < delimiterValue; ++i) {
            if (pointerValue >= intoStringLength) {
                pointer.setToValue(pointerValue + 1);
                return true;
            }
            intoString[pointerValue++] = sendString.charAt(i);
        }
        if (international) {
            pointerValue /= 2;
        }
        pointer.setToValue(++pointerValue);
        return false;
    }

    public final boolean isSizeError() {
        if (this.sizeErrorCondition) {
            this.sizeErrorCondition = false;
            return true;
        }
        return false;
    }

    public final boolean isCheckSizeError() {
        return this.sizeErrorCondition;
    }

    public final Variable setSizeError() {
        this.sizeErrorCondition = true;
        return this;
    }

    public final Numeric setNumericSizeError() {
        this.sizeErrorCondition = true;
        return (Numeric)this;
    }

    public final Variable setSizeError(boolean state) {
        this.sizeErrorCondition = state;
        return this;
    }

    public final Variable clearSizeError() {
        this.sizeErrorCondition = false;
        return this;
    }

    @Override
    public char toChar() {
        this.flushToMemory();
        return this.getChar(0);
    }

    @Override
    public byte toByte() {
        return (byte)this.toInt();
    }

    public boolean isUsagePointer() {
        return this instanceof DataPointer;
    }

    @Override
    public short toShort() {
        return (short)this.toInt();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int toInt() {
        int n;
        this.flushToMemory();
        int length = this.length();
        char CURRENT_DECIMAL = this.getDecimal();
        int value = 0;
        boolean negative = false;
        char c = '\u0000';
        block15: for (int load = 0; load < length; ++load) {
            c = this.getChar(load);
            switch (c) {
                case '0': {
                    value *= 10;
                    break;
                }
                case '1': {
                    value *= 10;
                    --value;
                    break;
                }
                case '2': {
                    value *= 10;
                    value -= 2;
                    break;
                }
                case '3': {
                    value *= 10;
                    value -= 3;
                    break;
                }
                case '4': {
                    value *= 10;
                    value -= 4;
                    break;
                }
                case '5': {
                    value *= 10;
                    value -= 5;
                    break;
                }
                case '6': {
                    value *= 10;
                    value -= 6;
                    break;
                }
                case '7': {
                    value *= 10;
                    value -= 7;
                    break;
                }
                case '8': {
                    value *= 10;
                    value -= 8;
                    break;
                }
                case '9': {
                    value *= 10;
                    value -= 9;
                    break;
                }
                case '-': {
                    if (negative) break;
                    negative = true;
                    break;
                }
                case '.': {
                    if (CURRENT_DECIMAL == '.') break block15;
                }
                case ',': {
                    if (CURRENT_DECIMAL == ',') break block15;
                }
            }
        }
        if (negative) {
            n = value;
            return n;
        }
        n = -value;
        return n;
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.toInt());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long toLong() {
        long l;
        this.flushToMemory();
        int length = this.length();
        char CURRENT_DECIMAL = this.getDecimal();
        long value = 0L;
        boolean negative = false;
        char c = '\u0000';
        block16: for (int load = 0; load < length; ++load) {
            c = this.getChar(load);
            switch (c) {
                case ' ': {
                    break;
                }
                case '0': {
                    value *= 10L;
                    break;
                }
                case '1': {
                    value *= 10L;
                    --value;
                    break;
                }
                case '2': {
                    value *= 10L;
                    value -= 2L;
                    break;
                }
                case '3': {
                    value *= 10L;
                    value -= 3L;
                    break;
                }
                case '4': {
                    value *= 10L;
                    value -= 4L;
                    break;
                }
                case '5': {
                    value *= 10L;
                    value -= 5L;
                    break;
                }
                case '6': {
                    value *= 10L;
                    value -= 6L;
                    break;
                }
                case '7': {
                    value *= 10L;
                    value -= 7L;
                    break;
                }
                case '8': {
                    value *= 10L;
                    value -= 8L;
                    break;
                }
                case '9': {
                    value *= 10L;
                    value -= 9L;
                    break;
                }
                case '-': {
                    if (negative) break;
                    negative = true;
                    break;
                }
                case '.': {
                    if (CURRENT_DECIMAL == '.') break block16;
                }
                case ',': {
                    if (CURRENT_DECIMAL == ',') break block16;
                }
            }
        }
        if (negative) {
            l = value;
            return l;
        }
        l = -value;
        return l;
    }

    @Override
    public float toFloat() {
        float result;
        try {
            result = Float.valueOf(this.toNumericString()).floatValue();
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return 0.0f;
        }
        return result;
    }

    @Override
    public double toDouble() {
        double result;
        try {
            result = Double.valueOf(this.toNumericString());
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return 0.0;
        }
        return result;
    }

    public Bignum toBignum() {
        return new Bignum(this.toNumericString());
    }

    public Bignum toModifyBignum() {
        return new Bignum(this.toNumericString());
    }

    @Override
    public boolean toBoolean() {
        switch (this.toChar()) {
            case '1': 
            case 'T': 
            case 'X': 
            case 'Y': 
            case 't': 
            case 'x': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public String toNumericString() {
        int i;
        if (this.pointerMemory == null) {
            return ZEROES_STRING;
        }
        boolean scaleFound = false;
        this.flushToMemory();
        int length = this.length();
        int loadc = 48;
        char[] result = new char[length + this.scale];
        int counter = 0;
        boolean digitFound = false;
        boolean decimalFound = false;
        boolean negativeFound = false;
        boolean exponentFound = false;
        char CURRENT_DECIMAL = this.getDecimal();
        block7: for (int load = 0; load < length; ++load) {
            loadc = this.getChar(load);
            switch (loadc) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (this.place > 0 && this.scale > 0 && !decimalFound && !scaleFound) {
                        scaleFound = true;
                        decimalFound = true;
                        result[counter++] = CURRENT_DECIMAL;
                        for (i = 0; i < this.scale; ++i) {
                            result[counter++] = 48;
                        }
                    }
                    digitFound = true;
                    result[counter++] = loadc;
                    continue block7;
                }
                case 69: {
                    exponentFound = true;
                    result[counter++] = loadc;
                    continue block7;
                }
                case 46: {
                    if (CURRENT_DECIMAL != '.' || decimalFound) continue block7;
                    if (!scaleFound && this.place == 0 && this.scale > 0) {
                        for (i = 0; i < this.scale; ++i) {
                            result[counter++] = 48;
                        }
                        scaleFound = true;
                    }
                    decimalFound = true;
                    result[counter++] = loadc;
                    if (scaleFound || this.place <= 0 || this.scale <= 0) continue block7;
                    for (i = 0; i < this.scale; ++i) {
                        result[counter++] = 48;
                    }
                    scaleFound = true;
                    continue block7;
                }
                case 44: {
                    if (CURRENT_DECIMAL != ',' || decimalFound) continue block7;
                    if (!scaleFound && this.place == 0 && this.scale > 0) {
                        for (i = 0; i < this.scale; ++i) {
                            result[counter++] = 48;
                        }
                        scaleFound = true;
                    }
                    decimalFound = true;
                    result[counter++] = loadc;
                    if (scaleFound || this.place <= 0 || this.scale <= 0) continue block7;
                    for (i = 0; i < this.scale; ++i) {
                        result[counter++] = 48;
                    }
                    scaleFound = true;
                    continue block7;
                }
                case 45: 
                case 67: 
                case 68: {
                    if (exponentFound) {
                        result[counter++] = loadc;
                        continue block7;
                    }
                    if (negativeFound) continue block7;
                    negativeFound = true;
                    result[counter++] = 45;
                }
            }
        }
        if (this.place == 0 && this.scale > 0 && !scaleFound) {
            for (i = 0; i < this.scale; ++i) {
                result[counter++] = 48;
            }
        }
        if (!digitFound) {
            return ZEROES_STRING;
        }
        return new String(result, 0, counter);
    }

    public String toNumericValueString() {
        int i;
        if (this.pointerMemory == null || this.picForNumberArray == null) {
            return this.toNumericString();
        }
        boolean scaleFound = false;
        this.flushToMemory();
        int length = this.length();
        int loadc = 48;
        char[] result = new char[length + this.scale + 1];
        int counter = 0;
        boolean digitFound = false;
        boolean decimalFound = false;
        boolean negativeFound = false;
        boolean exponentFound = false;
        char CURRENT_DECIMAL = this.getDecimal();
        block7: for (int load = 0; load < length; ++load) {
            loadc = this.getChar(load);
            switch (loadc) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (this.place > 0 && this.scale > 0 && !decimalFound && !scaleFound) {
                        scaleFound = true;
                        decimalFound = true;
                        result[counter++] = CURRENT_DECIMAL;
                        for (i = 0; i < this.scale; ++i) {
                            result[counter++] = 48;
                        }
                    }
                    digitFound = true;
                    result[counter++] = loadc;
                    continue block7;
                }
                case 69: {
                    exponentFound = true;
                    result[counter++] = loadc;
                    continue block7;
                }
                case 46: {
                    if (CURRENT_DECIMAL != '.' || decimalFound) continue block7;
                    if (!scaleFound && this.place == 0 && this.scale > 0) {
                        for (i = 0; i < this.scale; ++i) {
                            result[counter++] = 48;
                        }
                        scaleFound = true;
                    }
                    decimalFound = true;
                    result[counter++] = loadc;
                    if (scaleFound || this.place <= 0 || this.scale <= 0) continue block7;
                    for (i = 0; i < this.scale; ++i) {
                        result[counter++] = 48;
                    }
                    scaleFound = true;
                    continue block7;
                }
                case 44: {
                    if (CURRENT_DECIMAL != ',' || decimalFound) continue block7;
                    if (!scaleFound && this.place == 0 && this.scale > 0) {
                        for (i = 0; i < this.scale; ++i) {
                            result[counter++] = 48;
                        }
                        scaleFound = true;
                    }
                    decimalFound = true;
                    result[counter++] = loadc;
                    if (scaleFound || this.place <= 0 || this.scale <= 0) continue block7;
                    for (i = 0; i < this.scale; ++i) {
                        result[counter++] = 48;
                    }
                    scaleFound = true;
                    continue block7;
                }
                case 45: {
                    if (exponentFound) {
                        result[counter++] = loadc;
                        continue block7;
                    }
                    if (negativeFound) continue block7;
                    negativeFound = true;
                    result[counter++] = loadc;
                }
            }
        }
        if (this.place == 0 && this.scale > 0 && !scaleFound) {
            for (i = 0; i < this.scale; ++i) {
                result[counter++] = 48;
            }
        }
        boolean VFoundInPic = false;
        if (this.place > 0) {
            for (char c2 : this.picForNumberArray) {
                if (c2 != 'v' && c2 != 'V') continue;
                VFoundInPic = true;
                break;
            }
        }
        if (VFoundInPic && this.place > 0) {
            for (int i2 = 0; i2 < this.place; ++i2) {
                result[counter - i2] = result[counter - i2 - 1];
            }
            result[counter - this.place] = 46;
            ++counter;
        }
        if (!digitFound) {
            return ZEROES_STRING;
        }
        return new String(result, 0, counter);
    }

    public String toValueString() {
        String result = (this.flagBits & 0x3C000000) == 0x4000000 || (this.flagBits & 0x3C000000) == 0xC000000 ? this.toNumericString() : this.toDisplayString();
        return result;
    }

    public String toScalelessString() {
        this.flushToMemory();
        int length = this.length();
        char loadc = '0';
        char[] result = new char[length + this.scale];
        int counter = 0;
        boolean digitFound = false;
        boolean decimalFound = false;
        boolean negativeFound = false;
        boolean exponentFound = false;
        char CURRENT_DECIMAL = this.getDecimal();
        block5: for (int load = 0; load < length; ++load) {
            loadc = this.getChar(load);
            switch (loadc) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    digitFound = true;
                    result[counter++] = loadc;
                    continue block5;
                }
                case 'E': {
                    exponentFound = true;
                    result[counter++] = loadc;
                    continue block5;
                }
                case '-': {
                    if (exponentFound) {
                        result[counter++] = loadc;
                        continue block5;
                    }
                    if (negativeFound) continue block5;
                    negativeFound = true;
                    result[counter++] = loadc;
                    continue block5;
                }
                default: {
                    if (loadc != CURRENT_DECIMAL || decimalFound) continue block5;
                    decimalFound = true;
                    result[counter++] = loadc;
                }
            }
        }
        if (!digitFound) {
            return ZEROES_STRING;
        }
        return new String(result, 0, counter);
    }

    public Variable move(char param) {
        return this.move(String.valueOf(param));
    }

    public Variable move(byte param) {
        return this.move(String.valueOf(param));
    }

    public Variable move(short param) {
        return this.move(String.valueOf(param));
    }

    public Variable move(int param) {
        return this.move(String.valueOf(param));
    }

    public Variable move(Index param) {
        return this.move(param.toString());
    }

    public Variable move(long param) {
        return this.move(String.valueOf(param));
    }

    public Variable move(float param) {
        return this.move(new Numeric(param));
    }

    public Variable move(double param) {
        return this.move(new Numeric(param));
    }

    public Variable move(Bignum param) {
        return this.move(param.toString());
    }

    public Variable move(BigDecimal param) {
        return this.move(param.toString());
    }

    public Variable move(boolean param) {
        if ((this.flagBits & 0x3C000000) == 0x20000000) {
            return this.move(param ? "Y" : "N");
        }
        return this.move(param ? 1 : 0);
    }

    public void setSymbolicOn(String text) {
        this.flushToMemory();
        char ch = (char)(this.getChar(0) | text.charAt(0));
        this.pointerMemory.setChar(this.pointerAddress, ch);
    }

    public void setSymbolicOff(String text) {
        this.flushToMemory();
        char ch = (char)(this.getChar(0) & ~text.charAt(0));
        this.pointerMemory.setChar(this.pointerAddress, ch);
    }

    public boolean isSymbolicOn(String text) {
        this.flushToMemory();
        char ch = this.getChar(0);
        char oc = text.charAt(0);
        return (ch & oc) != 0;
    }

    public boolean isSymbolicOff(String text) {
        this.flushToMemory();
        char ch = this.getChar(0);
        char oc = text.charAt(0);
        return (ch & oc) == 0;
    }

    public final String getString() {
        int length = this.length();
        try {
            char[] dest;
            block7: {
                ++ModifyOnce;
                this.flushToMemory();
                if (this.pointerMemory == null) {
                    return DEFAULT_NAME;
                }
                dest = new char[length];
                try {
                    for (int i = 0; i < length; ++i) {
                        dest[i] = this.getChar(i);
                    }
                }
                catch (Exception bufferOverrunException) {
                    if (!LogSetup.IS_LOGGING_INFO) break block7;
                    LogSetup.LOGGER.info("catch (Exception bufferOverrunException)");
                    bufferOverrunException.printStackTrace();
                }
            }
            return new String(dest);
        }
        catch (Exception veryOddException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.config("getString(): Exception veryOddException occurred.");
            }
            return DEFAULT_NAME;
        }
    }

    public int getOdoBytes(byte[] dataByteArray, int offset) {
        if (this.odoNoSlide && this.isGroup() && this.itemSize < this.maxItemSize) {
            Variable sibling = this.firstChild;
            while (offset < dataByteArray.length && sibling != null) {
                if ((sibling.flagBits & 0x100000) != 0x100000) {
                    offset = sibling.getOdoBytes(dataByteArray, offset);
                }
                sibling = sibling.nextSibling;
            }
            return offset;
        }
        if (this.dependingOnVariable != null) {
            int readLen = this.dependingOnVariable.toInt() * this.itemSize;
            if (offset + readLen > dataByteArray.length) {
                readLen = dataByteArray.length - offset;
            }
            this.pointerMemory.copy(this.pointerAddress, dataByteArray, offset, readLen);
            offset += readLen;
        } else {
            int readLen = this.itemSize * Math.max(Math.min(this.occurs(), this.maxIndex), this.minIndex);
            if (offset + readLen > dataByteArray.length) {
                readLen = dataByteArray.length - offset;
            }
            this.pointerMemory.copy(this.pointerAddress, dataByteArray, offset, readLen);
            offset += readLen;
        }
        return offset;
    }

    public String toString() {
        int length = this.lengthBO();
        try {
            char[] dest;
            block13: {
                this.flushToMemory();
                dest = new char[length];
                try {
                    if (this.odoNoSlide && this.firstChild != null && this.itemSize < this.maxItemSize) {
                        StringBuffer sb = new StringBuffer(length);
                        Variable sibling = this.firstChild;
                        while (sibling != null) {
                            if ((sibling.flagBits & 0x100000) != 0x100000) {
                                sb.append(sibling.toString());
                            }
                            sibling = sibling.nextSibling;
                        }
                        return sb.toString();
                    }
                    if (this.dependingOnVariable != null) {
                        int odoLen = this.dependingOnVariable.toInt();
                        dest = new char[odoLen];
                        for (int i = 0; i < odoLen; ++i) {
                            dest[i] = this.getChar(i);
                        }
                    } else {
                        if (this.isHighValues()) {
                            return this.pointerMemory.toString(this.pointerAddress, length, defaultCharset);
                        }
                        length = this.itemSize * Math.max(Math.min(this.occurs(), this.maxIndex), this.minIndex);
                        dest = new char[length];
                        for (int i = 0; i < length; ++i) {
                            dest[i] = this.getChar(i);
                        }
                    }
                }
                catch (Exception bufferOverrunException) {
                    if (!LogSetup.IS_LOGGING_INFO) break block13;
                    LogSetup.LOGGER.info("catch (Exception bufferOverrunException)");
                    bufferOverrunException.printStackTrace();
                }
            }
            return new String(dest);
        }
        catch (Exception veryOddException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("toString(): Exception veryOddException occurred.");
                veryOddException.printStackTrace();
            }
            return DEFAULT_NAME;
        }
    }

    public String toString(String encoding) {
        try {
            this.flushToMemory();
            try {
                return this.pointerMemory.toString(this.pointerAddress, this.length(), encoding);
            }
            catch (Exception bufferOverrunException) {
                int maxVisibleSize;
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch (Exception bufferOverrunException)");
                }
                int length = this.length();
                int maxRemainingLength = this.pointerMemory.getTopOfMemory() - this.pointerAddress;
                int n = maxVisibleSize = maxRemainingLength > 0 ? maxRemainingLength : 0;
                if (length > maxVisibleSize) {
                    length = maxVisibleSize;
                }
                return this.pointerMemory.toString(this.pointerAddress, length, encoding);
            }
        }
        catch (UnsupportedEncodingException veryOddException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.config("toString(): Exception UnsupportedEncodingException occurred.");
            }
            return DEFAULT_NAME;
        }
    }

    public String toDescribedString() {
        return this.toDescribedString(0);
    }

    public String toDescribedString(int indent) {
        Variable child = this.firstChild;
        String s = null;
        s = child == null ? Variable.all(' ', indent) + this.getName() + ": '" + this.toDisplayString() + AQUOTES_STRING + System.getProperty("line.separator") : Variable.all(' ', indent) + this.getName() + ":" + System.getProperty("line.separator");
        while (child != null) {
            s = s + child.toDescribedString(indent + 1);
            child = child.nextSibling;
        }
        return s;
    }

    public final void setString(byte[] param) {
        this.setDirty();
        int paramLength = param.length;
        if (paramLength > this.length()) {
            paramLength = this.length();
        }
        this.pointerMemory.copy(param, 0, this.pointerAddress, paramLength);
        this.fillFromMemory();
    }

    public final void setString(byte[] param, int paramLength) {
        this.setDirty();
        if (paramLength > param.length) {
            paramLength = param.length;
        }
        if (paramLength > this.length()) {
            paramLength = this.length();
        }
        this.pointerMemory.copy(param, 0, this.pointerAddress, paramLength);
        this.fillFromMemory();
    }

    public final void setString(byte[] param, int offset, int end) {
        block5: {
            try {
                int paramLength;
                this.setDirty();
                if (offset < 0) {
                    offset = 0;
                }
                if ((paramLength = end - offset) + offset > param.length) {
                    paramLength = param.length;
                }
                if (paramLength > this.length()) {
                    paramLength = this.length();
                }
                this.pointerMemory.copy(param, offset, this.pointerAddress + offset, paramLength);
                this.fillFromMemory();
            }
            catch (Exception offsetExceptionIsFine) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.config("toString(): Exception offsetExceptionIsFine occurred.");
            }
        }
    }

    public final void setString(String param) {
        int itemLength;
        int paramLength;
        if (this.pointerMemory == null) {
            return;
        }
        this.setDirty();
        byte[] paramBytes = param.getBytes(defaultCharset);
        if (memoryCharset != null) {
            byte[] ebcdicBytes = param.getBytes(memoryCharset);
            for (int j = 0; j < paramBytes.length; ++j) {
                if (paramBytes[j] == -1) continue;
                paramBytes[j] = ebcdicBytes[j];
            }
        }
        if ((paramLength = param.length()) > (itemLength = this.length())) {
            paramLength = itemLength;
        } else if (paramLength < itemLength) {
            this.pointerMemory.pad(this.pointerAddress + paramLength, itemLength - paramLength);
        }
        this.pointerMemory.copy(paramBytes, 0, this.pointerAddress, paramLength);
    }

    public final void setString(char[] param) {
        this.setString(new String(param));
        this.fillFromMemory();
    }

    public final void setString(char[] param, int paramLength) {
        if (param.length > paramLength) {
            this.setString(new String(param, 0, paramLength));
        } else {
            this.setString(new String(param));
        }
        this.fillFromMemory();
    }

    public final void setString(char[] param, int offset, int end) {
        if (offset <= end && offset < param.length && end <= param.length) {
            this.setString(new String(param, offset, end));
        } else if (LogSetup.IS_LOGGING_INFO) {
            LogSetup.LOGGER.config("toString(): Exception offsetExceptionIsFine occurred.");
        }
        this.fillFromMemory();
    }

    public final void setString(Memory paramMemory, int paramAddress) {
        this.setDirty();
        this.pointerMemory.copy(paramMemory, paramAddress, this.pointerAddress, this.length());
        this.fillFromMemory();
    }

    final char getChar(int index) {
        if (memoryCharset != null) {
            byte[] ba = new byte[]{this.pointerMemory.getByte(this.pointerAddress + index)};
            return new String(ba, memoryCharset).charAt(0);
        }
        return this.pointerMemory.getChar(this.pointerAddress + index);
    }

    final void setChar(int index, char param) {
        if (memoryCharset != null) {
            char[] ca = new char[]{param};
            this.pointerMemory.setByte(this.pointerAddress + index, new String(ca).getBytes(memoryCharset)[0]);
        } else {
            this.pointerMemory.setChar(this.pointerAddress + index, param);
        }
    }

    public void toUpperCase(int length) {
        this.flushToMemory();
        if (memoryCharset != null) {
            for (int index = 0; index < length; ++index) {
                this.setChar(this.pointerAddress + index, Character.toUpperCase(this.getChar(this.pointerAddress + index)));
            }
        } else {
            for (int index = 0; index < length; ++index) {
                this.pointerMemory.setChar(this.pointerAddress + index, Character.toUpperCase(this.pointerMemory.getChar(this.pointerAddress + index)));
            }
        }
    }

    public void toLowerCase(int length) {
        this.flushToMemory();
        if (memoryCharset != null) {
            for (int index = 0; index < length; ++index) {
                this.setChar(this.pointerAddress + index, Character.toLowerCase(this.getChar(this.pointerAddress + index)));
            }
        } else {
            for (int index = 0; index < length; ++index) {
                this.pointerMemory.setChar(this.pointerAddress + index, Character.toLowerCase(this.pointerMemory.getChar(this.pointerAddress + index)));
            }
        }
    }

    public void maskAnd(Variable source, int length) {
        this.flushToMemory();
        source.flushToMemory();
        Memory sourceMem = source.pointerMemory;
        int sourceAddress = source.pointerAddress;
        Memory targetMem = this.pointerMemory;
        int targetAddress = this.pointerAddress;
        for (int i = 0; i < length; ++i) {
            this.pointerMemory.setByte(this.pointerAddress + i, Bitmask.andByte(sourceMem.getByte(sourceAddress + i), targetMem.getByte(targetAddress + i)));
        }
    }

    public void maskEq(Variable source, int length) {
        this.flushToMemory();
        source.flushToMemory();
        Memory sourceMem = source.pointerMemory;
        int sourceAddress = source.pointerAddress;
        Memory targetMem = this.pointerMemory;
        int targetAddress = this.pointerAddress;
        for (int i = 0; i < length; ++i) {
            this.pointerMemory.setByte(this.pointerAddress + i, Bitmask.eqByte(sourceMem.getByte(sourceAddress + i), targetMem.getByte(targetAddress + i)));
        }
    }

    public void maskImp(Variable source, int length) {
        this.flushToMemory();
        source.flushToMemory();
        Memory sourceMem = source.pointerMemory;
        int sourceAddress = source.pointerAddress;
        Memory targetMem = this.pointerMemory;
        int targetAddress = this.pointerAddress;
        for (int i = 0; i < length; ++i) {
            this.pointerMemory.setByte(this.pointerAddress + i, Bitmask.impByte(sourceMem.getByte(sourceAddress + i), targetMem.getByte(targetAddress + i)));
        }
    }

    public void maskOr(Variable source, int length) {
        this.flushToMemory();
        source.flushToMemory();
        Memory sourceMem = source.pointerMemory;
        int sourceAddress = source.pointerAddress;
        Memory targetMem = this.pointerMemory;
        int targetAddress = this.pointerAddress;
        for (int i = 0; i < length; ++i) {
            this.pointerMemory.setByte(this.pointerAddress + i, Bitmask.orByte(sourceMem.getByte(sourceAddress + i), targetMem.getByte(targetAddress + i)));
        }
    }

    public void maskXor(Variable source, int length) {
        this.flushToMemory();
        source.flushToMemory();
        Memory sourceMem = source.pointerMemory;
        int sourceAddress = source.pointerAddress;
        Memory targetMem = this.pointerMemory;
        int targetAddress = this.pointerAddress;
        for (int i = 0; i < length; ++i) {
            this.pointerMemory.setByte(this.pointerAddress + i, Bitmask.xorByte(sourceMem.getByte(sourceAddress + i), targetMem.getByte(targetAddress + i)));
        }
    }

    public void maskNot(int length) {
        this.flushToMemory();
        for (int i = 0; i < length; ++i) {
            this.pointerMemory.setByte(this.pointerAddress + i, Bitmask.notByte(this.pointerMemory.getByte(this.pointerAddress + i)));
        }
    }

    int generateReturnCode() {
        int len = this.length();
        if (len <= 4) {
            int returnCode = 0;
            this.flushToMemory();
            for (int i = 0; i < len; ++i) {
                returnCode <<= 8;
                returnCode |= this.pointerMemory.getByte(this.pointerAddress + i) & 0xFF;
            }
            return returnCode;
        }
        return this.toInt();
    }

    public int getAddress() {
        return this.pointerAddress;
    }

    public int getMaxAddress() {
        return this.pointerAddress + this.itemSize - 1;
    }

    public final void setAddress(int setLocation) {
        if (setLocation < 0) {
            throw new RuntimeException("pointerAddress is invalid: " + setLocation + SPACES_STRING + this);
        }
        this.pointerAddress = setLocation;
    }

    public final void setAddress(double setLocation) {
        this.setAddress((int)setLocation);
    }

    public final void setAddress(String setLocation) {
        this.setAddress(ConvertData.parseInt(setLocation));
    }

    public final Memory getMemory() {
        return this.pointerMemory;
    }

    public final void setMemory(Memory memoryObject) {
        this.flushToMemory();
        if (memoryObject != null) {
            this.alwaysFlush = memoryObject.alwaysFlush;
        }
        this.pointerMemory = memoryObject;
    }

    public final void setMemoryOld(Memory memoryObject) {
        if (memoryObject != null) {
            this.alwaysFlush = memoryObject.alwaysFlush;
        }
        this.pointerMemory = memoryObject;
    }

    public final char getCurrency() {
        return Memory.getGlobalCurrency();
    }

    public final void setCurrency(char currencySymbol) {
        this.pointerMemory.setCurrency(currencySymbol);
    }

    public final char getComma() {
        return Memory.getGlobalComma();
    }

    public final void setComma(char commaSymbol) {
        this.pointerMemory.setComma(commaSymbol);
    }

    public final char getDecimal() {
        return Memory.getGlobalDecimal();
    }

    public final void setDecimal(char decimalSymbol) {
        this.pointerMemory.setDecimal(decimalSymbol);
    }

    public static void setShift(char out, char in) {
        useShiftInOut = true;
        shiftOut = out;
        shiftIn = in;
    }

    public static void setShiftVS() {
        Variable.setShift('\u000e', '\u000f');
    }

    public static void setShiftMF() {
        Variable.setShift('A', 'Z');
    }

    public static void setShiftIn(char c) {
        useShiftInOut = true;
        shiftIn = c;
    }

    public static void setShiftOut(char c) {
        useShiftInOut = true;
        shiftOut = c;
    }

    public static char getShiftIn() {
        return shiftIn;
    }

    public static char getShiftOut() {
        return shiftOut;
    }

    public static void setInternationalEncoding(String value) {
        internationalEncoding = value;
    }

    public static String getInternationalEncoding() {
        return internationalEncoding;
    }

    public static void setPackedSignEncoding(String value) {
        packedSignEncoding = "NOPFD".equalsIgnoreCase(value) ? PackedSignEncoding.NOPFD : ("PFD".equalsIgnoreCase(value) ? PackedSignEncoding.PFD : ("MIG".equalsIgnoreCase(value) ? PackedSignEncoding.MIG : ("BULL".equalsIgnoreCase(value) ? PackedSignEncoding.BULL : ("NCR".equalsIgnoreCase(value) ? PackedSignEncoding.NCR : PackedSignEncoding.NOPFD))));
        if (packedSignEncoding == PackedSignEncoding.BULL || packedSignEncoding == PackedSignEncoding.NCR) {
            PD_NUMPROCB1 = (char)48;
            PD_NUMPROCB2 = (char)32;
        } else {
            PD_NUMPROCB1 = (char)45;
            PD_NUMPROCB2 = (char)45;
        }
    }

    public static PackedSignEncoding getPackedSignEncoding() {
        return packedSignEncoding;
    }

    public static void setByteEncoding(String value) {
        byteEncoding = value;
    }

    public static String getByteEncoding() {
        return byteEncoding;
    }

    public static String toDisplayString(String s) {
        byte[] result;
        if (s == null) {
            return "null";
        }
        if (internationalEncoding == null) {
            return s;
        }
        int length = s.length();
        char schar = '\u0000';
        if (internationalEncodingUseHigh) {
            result = new byte[length * 2];
            int cursor = 0;
            for (int i = 0; i < length; ++i) {
                schar = s.charAt(i);
                result[cursor++] = (byte)(schar >> 8 & 0xFF);
                result[cursor++] = (byte)(schar & 0xFF);
            }
        } else {
            result = new byte[length];
            for (int i = 0; i < length; ++i) {
                schar = s.charAt(i);
                result[i] = (byte)(schar & 0xFF);
            }
        }
        try {
            return new String(result, internationalEncoding);
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e) because of unsupported encoding; don't try it again");
                e.printStackTrace();
            }
            internationalEncoding = null;
            return s;
        }
    }

    public static String toText(String s) {
        return Variable.toText(s);
    }

    public static String codePageToString(String s) {
        if (s == null) {
            return "null";
        }
        if (byteEncoding == null) {
            return s;
        }
        int l = s.length();
        byte[] b = new byte[l];
        for (int i = 0; i < l; ++i) {
            b[i] = (byte)(s.charAt(i) & 0xFF);
        }
        try {
            return new String(b, byteEncoding);
        }
        catch (UnsupportedEncodingException e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (UnsupportedEncodingException e) because of unsupported encoding; don't try it again");
                e.printStackTrace();
            }
            byteEncoding = null;
            return s;
        }
    }

    public static String codePageToString(byte[] b) {
        if (b == null) {
            return "null";
        }
        try {
            if (byteEncoding == null) {
                return new String(b, "iso-8859-1");
            }
            return new String(b, byteEncoding);
        }
        catch (UnsupportedEncodingException e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (UnsupportedEncodingException e) because of unsupported encoding '" + byteEncoding + AQUOTES_STRING);
                e.printStackTrace();
            }
            byteEncoding = null;
            return new String(b);
        }
    }

    public String toDisplayString() {
        try {
            if (this.isContainingInternational()) {
                int maxVisibleSize;
                this.flushToMemory();
                if (internationalEncoding != null) {
                    try {
                        int maxVisibleSize2;
                        int length = this.length();
                        int maxVisibleLength = this.pointerMemory.getTopOfMemory() - this.pointerAddress;
                        int n = maxVisibleSize2 = maxVisibleLength > 0 ? maxVisibleLength : 0;
                        if (length > maxVisibleSize2) {
                            length = maxVisibleSize2;
                        }
                        if (internationalEncodingUseHigh) {
                            return this.pointerMemory.toString(this.pointerAddress, length, internationalEncoding);
                        }
                        byte[] result = new byte[length / 2];
                        int cursor = 0;
                        for (int i = 1; i < length; i += 2) {
                            result[cursor++] = this.pointerMemory.getByte(this.pointerAddress + i);
                        }
                        return new String(result, 0, cursor);
                    }
                    catch (UnsupportedEncodingException encodingException) {
                        if (LogSetup.IS_LOGGING_INFO) {
                            LogSetup.LOGGER.info("catch (Exception encodingException)");
                            encodingException.printStackTrace();
                        }
                        return DEFAULT_NAME;
                    }
                }
                if (!useShiftInOut) {
                    int maxVisibleSize3;
                    int length = this.length();
                    int maxVisibleLength = this.pointerMemory.getTopOfMemory();
                    int n = maxVisibleSize3 = maxVisibleLength > 0 ? maxVisibleLength : 0;
                    if (length > maxVisibleSize3) {
                        length = maxVisibleSize3;
                    }
                    int half = length / 2;
                    char[] result = new char[half];
                    int cursor = 0;
                    for (int i = 0; i < half; ++i) {
                        char c;
                        result[i] = (c = (char)((this.getChar(cursor++) << 8 | this.getChar(cursor++)) & 0xFFFF)) == '\u2020' ? 32 : (c == '\uf8f8' ? 8224 : c);
                    }
                    return new String(result);
                }
                StringBuffer result = new StringBuffer();
                int cursor = 0;
                boolean shifted = false;
                int length = this.length();
                int maxVisibleLength = this.pointerMemory.getTopOfMemory();
                int n = maxVisibleSize = maxVisibleLength > 0 ? maxVisibleLength : 0;
                if (length > maxVisibleSize) {
                    length = maxVisibleSize;
                }
                while (cursor < length) {
                    char c = this.getChar(cursor);
                    if (c == shiftOut && !shifted) {
                        shifted = true;
                    } else if (c == shiftIn && shifted) {
                        shifted = false;
                    } else if (shifted) {
                        char c2 = this.getChar(++cursor);
                        c = (char)((c & 0xFF) << 8 | c2 & 0xFF);
                        result.append(c);
                    } else {
                        result.append(c);
                    }
                    ++cursor;
                }
                return result.toString();
            }
            if (byteEncoding != null) {
                this.flushToMemory();
                int length = this.length();
                int maxVisibleLength = this.pointerMemory.getTopOfMemory();
                int maxVisibleSize = maxVisibleLength > 0 ? maxVisibleLength : 0;
                char CURRENT_DECIMAL = this.getDecimal();
                char CURRENT_COMMA = this.getComma();
                if (length > maxVisibleSize) {
                    length = maxVisibleSize;
                }
                String displayable = null;
                displayable = this.isHighValues() ? this.pointerMemory.toString(this.pointerAddress, length, defaultCharset) : this.pointerMemory.toString(this.pointerAddress, length, memoryCharset);
                if (this.isTypeNumericEdited() && CURRENT_DECIMAL != '.') {
                    displayable = displayable.replace('.', '^');
                    displayable = displayable.replace(',', CURRENT_COMMA);
                    displayable = displayable.replace('^', CURRENT_DECIMAL);
                }
                return displayable;
            }
            return this.toString();
        }
        catch (Exception veryOddException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception veryOddException)");
                veryOddException.printStackTrace();
            }
            return DEFAULT_NAME;
        }
    }

    public String toNationalString() {
        return this.toDisplayString();
    }

    public String toNationalString(int fieldSize) {
        String result = this.toNationalString();
        if (result == null) {
            return result;
        }
        if (fieldSize <= 0 || fieldSize > 159) {
            return result;
        }
        int resultLength = result.length();
        if (fieldSize < resultLength) {
            return result.substring(0, fieldSize);
        }
        if (fieldSize == resultLength) {
            return result;
        }
        return result + Variable.all(' ', fieldSize - resultLength);
    }

    public String toHexString() {
        this.flushToMemory();
        StringBuffer buffer = new StringBuffer(this.length() * 2 + 3);
        if (this.isInternational()) {
            buffer.append("I[");
        } else {
            buffer.append("X[");
        }
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            char c = this.getChar(i);
            int h = c >> 4 & 0xF;
            int l = c & 0xF;
            char H = h >= 0 && h <= 9 ? (char)(48 + h) : (char)(97 + h - 10);
            char L = l >= 0 && l <= 9 ? (char)(48 + l) : (char)(97 + l - 10);
            buffer.append(H).append(L);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String getCompactPicture() {
        byte scale = this.scale;
        int place = this.place;
        String scaleString = DEFAULT_NAME;
        if (scale > 0) {
            if (place > 0) {
                place -= scale;
            }
            if (scale == 1) {
                scaleString = "P";
            } else if (scale == 2) {
                scaleString = "PP";
            } else if (scale > 2) {
                scaleString = "P(" + scale + ")";
            }
        }
        if (this.picArray != null && this.picArray.length > 0) {
            int length = this.picLength;
            if (length == 0) {
                length = this.picArray.length;
            }
            int insertion_v = -2;
            if (place > 0) {
                insertion_v = length - place - 1;
            }
            StringBuffer result = new StringBuffer();
            if (insertion_v == -1) {
                result.append('V');
                result.append(scaleString);
                scaleString = DEFAULT_NAME;
                insertion_v = -3;
            }
            int i = 0;
            int count = 0;
            char oldc = this.getPic(0);
            if (insertion_v >= 0) {
                ++length;
            }
            int endPoint = length - 1;
            while (i < length) {
                char c;
                if (insertion_v == -2 || insertion_v == -3) {
                    c = this.getPic(i);
                } else if (i < insertion_v) {
                    c = this.getPic(i);
                } else if (i == insertion_v) {
                    c = 'V';
                    ++endPoint;
                } else {
                    c = this.getPic(i - 1);
                }
                if (c == '_') {
                    if (oldc == 'C') {
                        c = 'R';
                    }
                    if (oldc == 'D') {
                        c = 'B';
                    }
                }
                ++count;
                if (c != oldc || i == endPoint) {
                    if (i == endPoint) {
                        c = oldc;
                    }
                    if (count == 1) {
                        result.append(oldc);
                    } else if (count == 2) {
                        result.append(oldc);
                        result.append(oldc);
                    } else if (count == 3) {
                        result.append(oldc);
                        result.append(oldc);
                        result.append(oldc);
                    } else if (count > 3) {
                        result.append(oldc);
                        result.append("(" + count + ")");
                    }
                    count = 0;
                }
                if (i == insertion_v) {
                    result.append(scaleString);
                    scaleString = DEFAULT_NAME;
                }
                oldc = c;
                ++i;
            }
            if (insertion_v == -2) {
                result.append(scaleString);
            }
            String resultString = result.toString();
            if (this.signPosition != 0 && (this.flagBits & 0x3C000000) == 0x4000000) {
                resultString = "S" + resultString;
            }
            return resultString;
        }
        int temp_picLength = this.picLength;
        if (temp_picLength == 0) {
            temp_picLength = this.length();
        }
        if ((this.flagBits & 0x3C000000) == 0x20000000) {
            switch (temp_picLength) {
                case 1: {
                    return "A";
                }
                case 2: {
                    return "AA";
                }
                case 3: {
                    return "AAA";
                }
            }
            return "A(" + temp_picLength + ")";
        }
        if ((this.flagBits & 0x3C000000) == 0x4000000) {
            if (place > 0) {
                int before = temp_picLength - place;
                int after = temp_picLength - before;
                String beforeString = DEFAULT_NAME;
                String afterString = DEFAULT_NAME;
                if (before == 1) {
                    beforeString = "9";
                } else if (before == 2) {
                    beforeString = "99";
                } else if (before > 2) {
                    beforeString = "9(" + before + ")";
                }
                if (after == 1) {
                    afterString = "9";
                } else if (after == 2) {
                    afterString = "99";
                } else if (after > 2) {
                    afterString = "9(" + after + ")";
                }
                if (before == 0) {
                    return "V" + scaleString + afterString;
                }
                if (after == 0) {
                    return beforeString + scaleString;
                }
                return beforeString + "V" + afterString;
            }
            if (temp_picLength == 1) {
                return "9";
            }
            if (temp_picLength == 2) {
                return "99";
            }
            return "9(" + temp_picLength + ")" + scaleString;
        }
        switch (temp_picLength) {
            case 1: {
                return "X";
            }
            case 2: {
                return "XX";
            }
            case 3: {
                return "XXX";
            }
        }
        return "X(" + temp_picLength + ")";
    }

    protected void calcPadding() {
    }

    public int getUsageNumber() {
        if (this.isUsageMisc()) {
            return 5;
        }
        if (this.isUsageExternalForm()) {
            return 36;
        }
        return 0;
    }

    public final boolean isTypeNumericEdited() {
        return (this.flagBits & 0x3C000000) == 0xC000000;
    }

    public final boolean isTypePointer() {
        return this instanceof DataPointer;
    }

    public final boolean isTypeNumeric() {
        return (this.flagBits & 0x3C000000) == 0x4000000;
    }

    public void setTypeNumber(byte type) {
        this.flagBits &= 0xC3FFFFFF;
        switch (type) {
            case 0: {
                this.flagBits |= 0x4000000;
                break;
            }
            case 1: {
                this.flagBits |= 0xC000000;
                break;
            }
            case 2: {
                this.flagBits |= 0;
                break;
            }
            case 3: {
                this.flagBits |= 0x8000000;
                break;
            }
            case 4: {
                this.flagBits |= 0x20000000;
                break;
            }
            case 31: {
                this.flagBits |= 0x10000000;
                break;
            }
            case 32: {
                this.flagBits |= 0x18000000;
            }
        }
    }

    public String getTypeName() {
        boolean alphabetic;
        boolean numeric = (this.flagBits & 0x4000000) != 0;
        boolean edited = (this.flagBits & 0x8000000) != 0;
        boolean national = (this.flagBits & 0x10000000) != 0;
        boolean bl = alphabetic = (this.flagBits & 0x20000000) != 0;
        if (alphabetic) {
            return "ALPHABETIC";
        }
        if (numeric) {
            return edited ? "NUMERIC_EDITED" : "NUMERIC";
        }
        if (national) {
            return edited ? "NATIONAL_EDITED" : "NATIONAL";
        }
        return edited ? "ALPHANUMERIC_EDITED" : "ALPHANUMERIC";
    }

    public int getTypeNumber() {
        boolean alphabetic;
        boolean numeric = (this.flagBits & 0x4000000) != 0;
        boolean edited = (this.flagBits & 0x8000000) != 0;
        boolean national = (this.flagBits & 0x10000000) != 0;
        boolean bl = alphabetic = (this.flagBits & 0x20000000) != 0;
        if (alphabetic) {
            return 4;
        }
        if (numeric) {
            return edited ? 1 : 0;
        }
        if (national) {
            return edited ? 32 : 31;
        }
        return edited ? 3 : 2;
    }

    public final void setDataPointer(Object value) {
        if (value instanceof Number) {
            this.pointerAddress = ((Number)value).intValue();
        } else if (value instanceof byte[]) {
            this.setPointerToBytes((byte[])value);
        } else {
            this.pointerAddress = ConvertData.parseInt(String.valueOf(value));
        }
    }

    public final void setAddressToPointer(DataPointer v) {
        Variable tmp = new Variable();
        tmp.setMemory(this.pointerMemory);
        tmp.setAddress(this.pointerAddress);
        tmp.itemSize = this.itemSize;
        if (this.pointerMemory != null) {
            this.pointerMemory.flushToMemory(tmp, false);
        }
        this.setAddressFromMemoryAndAddress(v.getPointerMemory(), v.getPointerAddress());
    }

    public final void setAddressToAddress(Variable v) {
        Variable tmp = new Variable();
        tmp.setMemory(this.pointerMemory);
        tmp.setAddress(this.pointerAddress);
        tmp.itemSize = this.itemSize;
        if (this.pointerMemory != null) {
            this.pointerMemory.flushToMemory(tmp, false);
        }
        this.setAddressFromMemoryAndAddress(v.getMemory(), v.getAddress());
    }

    private void setAddressFromMemoryAndAddress(Memory m, int a) {
        int priorAddress = this.getAddress();
        this.setMemoryOld(m);
        this.setAddress(a);
        this.setAddressChanged = true;
        int offset = a - priorAddress;
        ++ModifyOnce;
        if (this.firstChild != null) {
            this.modifyOnce = ModifyOnce;
            this.firstChild.setGroupPointer(m, offset, true);
        }
        if (this.arrayChild != null) {
            this.setArrayMemoryPointer(this.arrayChild, m, offset);
        }
        if (this.redefinedFrom != null) {
            this.redefinedFrom.setAddressFromMemoryAndAddress(m, a);
        }
        if (this.redefinedTo != null) {
            for (Variable e : this.redefinedTo) {
                this.modifyOnce = ++ModifyOnce;
                e.setGroupPointer(m, offset, true);
            }
        }
    }

    public final void setAddressNull() {
        ++ModifyOnce;
        this.pointerMemory = null;
    }

    public int setPointerToBytes(byte[] memorySpace) {
        int redefineAddressAdjustment;
        int memoryLeft;
        if (this instanceof DataPointer && this.length() == DataPointer.SIZE_POINTER) {
            return ((DataPointer)this).setPointerToBytes(memorySpace);
        }
        if (memorySpace == null) {
            this.pointerMemory = null;
            this.pointerAddress = 0;
            return 0;
        }
        this.modifyOnce = ++ModifyOnce;
        Memory dynamicMemory = Cache.disabled ? new UnbufferedMemory(memorySpace) : new Memory(memorySpace);
        int dynamicAddress = 0;
        int offset = -this.pointerAddress;
        this.alwaysFlush = true;
        this.setAddressChanged = true;
        if (memorySpace.length < this.itemSize) {
            if (this.resetItemSize == -1000) {
                this.resetItemSize = this.itemSize;
            }
            memoryLeft = this.itemSize = memorySpace.length;
        } else {
            memoryLeft = this.itemSize;
        }
        this.pointerMemory = dynamicMemory;
        this.pointerAddress = dynamicAddress;
        Variable currentChild = this.firstChild;
        Variable child = null;
        if (this.arrayChild != null) {
            this.setArrayMemoryPointer(this.arrayChild, dynamicMemory, offset);
        }
        int n = redefineAddressAdjustment = currentChild == null ? 0 : currentChild.pointerAddress;
        while (currentChild != null) {
            currentChild.modifyOnce = ModifyOnce;
            if ((memoryLeft += redefineAddressAdjustment - currentChild.pointerAddress) > 0) {
                if (memoryLeft > currentChild.length()) {
                    memoryLeft -= currentChild.itemSize;
                } else {
                    if (currentChild.resetItemSize == -1000) {
                        currentChild.resetItemSize = currentChild.itemSize;
                    }
                    currentChild.itemSize = memoryLeft;
                    memoryLeft = 0;
                }
                currentChild.alwaysFlush = true;
                currentChild.pointerMemory = dynamicMemory;
                currentChild.pointerAddress += offset;
                if (currentChild.arrayChild != null) {
                    this.setArrayMemoryPointer(currentChild.arrayChild, dynamicMemory, offset);
                }
                if ((child = currentChild.firstChild) != null) {
                    child.setGroupMemoryPointer(dynamicMemory, offset);
                }
            }
            redefineAddressAdjustment = currentChild.pointerAddress + currentChild.itemSize;
            currentChild = currentChild.nextSibling;
        }
        return -offset;
    }

    public int rebasePointerToBytes(byte[] memorySpace) {
        Memory dynamicMemory = Cache.disabled ? new UnbufferedMemory(memorySpace) : new Memory(memorySpace);
        this.pointerMemory = dynamicMemory;
        int offset = -this.pointerAddress;
        this.pointerAddress = 0;
        if (this.firstChild != null) {
            return this.firstChild.setGroupMemoryPointer(dynamicMemory, offset);
        }
        return 0;
    }

    public int rebasePointerToSharedBytes(byte[] memorySpace) {
        Memory dynamicMemory = Cache.disabled ? new UnbufferedMemory(memorySpace) : new Memory(memorySpace);
        dynamicMemory.setDynamic();
        dynamicMemory.setShared();
        int index = SharedMemory.getInstance().makeSharedMemory(dynamicMemory);
        int addr = index | 0x40000000;
        this.pointerMemory = dynamicMemory;
        int offset = -this.pointerAddress;
        this.pointerAddress = 0;
        if (this.firstChild != null) {
            return this.firstChild.setGroupMemoryPointer(dynamicMemory, offset);
        }
        return 0;
    }

    private final int setGroupMemoryPointer(Memory d_memory, int offset) {
        Variable currentChild = this;
        do {
            Variable child;
            if (currentChild.modifyOnce != ModifyOnce) {
                currentChild.modifyOnce = ModifyOnce;
                currentChild.alwaysFlush = true;
                currentChild.pointerMemory = d_memory;
                currentChild.pointerAddress += offset;
            }
            if ((child = currentChild.firstChild) == null) continue;
            child.setGroupMemoryPointer(d_memory, offset);
        } while ((currentChild = currentChild.nextSibling) != null);
        return -offset;
    }

    private final int setArrayGroupMemoryPointer(Memory d_memory, int offset) {
        Variable currentChild = this;
        if (currentChild.modifyOnce != ModifyOnce) {
            currentChild.modifyOnce = ModifyOnce;
            if (d_memory != null && !d_memory.alwaysFlush && currentChild.notify == null) {
                currentChild.pointerMemory.removeNotify(currentChild);
            }
            currentChild.alwaysFlush = true;
            currentChild.pointerMemory = d_memory;
            currentChild.setAddress(this.getAddress() + offset);
            if (d_memory != null && !d_memory.alwaysFlush && currentChild.notify == null) {
                currentChild.pointerMemory.addNotify(currentChild);
            }
        }
        if (currentChild.arrayChild != null) {
            this.setArrayMemoryPointer(currentChild.arrayChild, d_memory, offset);
        }
        return -offset;
    }

    private final int setArrayMemoryPointer(Object[] array, Memory d_memory, int offset) {
        if (array == null) {
            return -offset;
        }
        if (array.length == 2 && array[1] instanceof VariableSubscript) {
            VariableSubscript vs = (VariableSubscript)array[1];
            vs.finished();
        } else {
            for (int i = 1; i < array.length; ++i) {
                Object element = array[i];
                if (element == null) continue;
                if (element instanceof Object[]) {
                    this.setArrayMemoryPointer((Object[])element, d_memory, offset);
                    continue;
                }
                ((Variable)element).setArrayGroupMemoryPointer(d_memory, offset);
            }
        }
        return -offset;
    }

    private final int setGroupPointer(Memory d_memory, int offset, boolean explicit) {
        Variable currentChild = this;
        do {
            Variable child;
            if (currentChild.modifyOnce != ModifyOnce) {
                currentChild.modifyOnce = ModifyOnce;
                if (d_memory != null && !d_memory.alwaysFlush && currentChild.notify == null) {
                    currentChild.pointerMemory.removeNotify(currentChild);
                }
                currentChild.setAddressChanged = explicit && (offset != 0 || currentChild.pointerMemory != d_memory);
                currentChild.pointerMemory = d_memory;
                currentChild.pointerAddress += offset;
                if (d_memory != null && !d_memory.alwaysFlush && currentChild.notify == null) {
                    currentChild.pointerMemory.addNotify(currentChild);
                }
            }
            if (currentChild.arrayChild != null && this.setAddressChanged) {
                this.setArrayMemoryPointer(currentChild.arrayChild, d_memory, offset);
            }
            if ((child = currentChild.firstChild) == null) continue;
            child.setGroupPointer(d_memory, offset, explicit);
        } while ((currentChild = currentChild.nextSibling) != null);
        return -offset;
    }

    private final int setBigGroupPointer(Memory d_memory, int d_address, int d_size) {
        int redefineAddressAdjustment;
        if (d_memory == null) {
            return 0;
        }
        this.modifyOnce = ++ModifyOnce;
        int offset = d_address - this.pointerAddress;
        this.pointerMemory.removeNotify(this);
        this.pointerMemory = d_memory;
        this.pointerAddress = d_address;
        this.pointerMemory.addNotify(this);
        if (this.maxItemSize != d_size) {
            this.resetItemSize = this.maxItemSize;
            this.maxItemSize = d_size;
        }
        Variable currentChild = this.firstChild;
        Variable priorChild = null;
        Variable grandChild = null;
        int n = redefineAddressAdjustment = currentChild == null ? 0 : currentChild.pointerAddress + offset;
        if (currentChild != null && currentChild.pointerAddress != d_address) {
            d_size -= currentChild.pointerAddress + offset - d_address;
        }
        while (currentChild != null) {
            currentChild.modifyOnce = ModifyOnce;
            currentChild.pointerMemory.removeNotify(this);
            currentChild.pointerMemory = d_memory;
            currentChild.pointerAddress += offset;
            currentChild.pointerMemory.addNotify(this);
            currentChild.setGroupSize(d_size += redefineAddressAdjustment - currentChild.pointerAddress);
            if (priorChild != null) {
                priorChild.resetGroupSize();
            }
            d_size -= currentChild.itemSize;
            redefineAddressAdjustment = currentChild.pointerAddress + currentChild.itemSize;
            if (currentChild.arrayChild != null && this.setAddressChanged) {
                this.setArrayMemoryPointer(currentChild.arrayChild, d_memory, offset);
            }
            if ((grandChild = currentChild.firstChild) != null) {
                grandChild.setGroupPointer(d_memory, offset, false);
            }
            priorChild = currentChild;
            currentChild = currentChild.nextSibling;
        }
        return -offset;
    }

    private static final boolean copyChangedAddresses(Variable toRecord, Variable fromRecord) {
        boolean rc = false;
        if (fromRecord.setAddressChanged && fromRecord.itemSize == toRecord.itemSize) {
            toRecord.pointerMemory = fromRecord.pointerMemory;
            toRecord.pointerAddress = fromRecord.pointerAddress;
            toRecord.setAddressChanged = fromRecord.setAddressChanged;
            rc = true;
        }
        Variable toChildElement = toRecord.firstChild;
        Variable fromChildElement = fromRecord.firstChild;
        while (toChildElement != null && fromChildElement != null) {
            rc |= Variable.copyChangedAddresses(toChildElement, fromChildElement);
            toChildElement = toChildElement.nextSibling;
            fromChildElement = fromChildElement.nextSibling;
        }
        return rc;
    }

    public final int setGroupPointer(Variable v) {
        this.setAddressChanged = true;
        int rc = this.setBigGroupPointer(v.pointerMemory, v.pointerAddress, this.maxItemSize);
        return rc;
    }

    private final int setGroupPointer(Memory d_memory, int offset) {
        if (this.modifyOnce != ModifyOnce) {
            this.modifyOnce = ModifyOnce;
            this.pointerMemory = d_memory;
            this.setAddress(this.getAddress() + offset);
        }
        Variable currentChild = this.firstChild;
        while (currentChild != null) {
            currentChild.setGroupPointer(d_memory, offset);
            currentChild = currentChild.nextSibling;
        }
        return offset;
    }

    public final void setGroupSize(int totalSize) {
        Variable currentChild;
        int redefineAddressAdjustment;
        if (this.maxItemSize != totalSize) {
            this.resetItemSize = this.maxItemSize;
            this.maxItemSize = totalSize;
        }
        int n = redefineAddressAdjustment = (currentChild = this.firstChild) == null ? 0 : currentChild.pointerAddress;
        while (currentChild != null) {
            currentChild.setGroupSize(totalSize - (currentChild.pointerAddress - redefineAddressAdjustment));
            currentChild = currentChild.nextSibling;
        }
    }

    public final void resetGroupSize() {
        if (this.maxItemSize == -1000) {
            return;
        }
        this.maxItemSize = this.resetItemSize != -1000 ? this.resetItemSize : -1000;
        Variable currentChild = this.firstChild;
        while (currentChild != null) {
            currentChild.resetGroupSize();
            currentChild = currentChild.nextSibling;
        }
    }

    public final int redefines(Variable master) {
        this.modifyOnce = ++ModifyOnce;
        Memory masterMemory = master.pointerMemory;
        int masterAddress = master.pointerAddress;
        int offset = masterAddress - this.pointerAddress;
        this.pointerMemory = masterMemory;
        this.pointerAddress = masterAddress;
        Variable child = this.firstChild;
        Variable itsChild = null;
        while (child != null) {
            child.modifyOnce = ModifyOnce;
            child.pointerMemory = masterMemory;
            child.pointerAddress += offset;
            itsChild = child.firstChild;
            if (itsChild != null) {
                itsChild.setGroupPointer(masterMemory, offset, false);
            }
            child = child.nextSibling;
        }
        this.invalidateCache();
        if (Cache.standard) {
            this.removeNotify();
            this.addNotifyChildren();
        }
        return -offset;
    }

    public final int redefinesFinalize(Variable master) {
        this.modifyOnce = ++ModifyOnce;
        Memory masterMemory = master.pointerMemory;
        int masterAddress = master.pointerAddress;
        int offset = masterAddress - this.pointerAddress;
        this.pointerMemory = masterMemory;
        this.pointerAddress = masterAddress;
        Variable child = this.firstChild;
        Variable itsChild = null;
        while (child != null) {
            child.modifyOnce = ModifyOnce;
            child.pointerMemory = masterMemory;
            child.pointerAddress += offset;
            itsChild = child.firstChild;
            if (itsChild != null) {
                itsChild.setGroupPointer(masterMemory, offset, false);
            }
            child = child.nextSibling;
        }
        this.invalidateCache();
        if (Cache.standard) {
            this.removeNotify();
        }
        return -offset;
    }

    public final Variable setTo(int x) {
        return this.move(x);
    }

    public final void setToValue(int x) {
        this.move(x);
    }

    public final Variable setUp(int x) {
        return this.setTo(this.toInt() + x);
    }

    public final boolean setUpCheck(int x) {
        this.setToValue(this.toInt() + x);
        return true;
    }

    public final Variable setDown(int x) {
        return this.setTo(this.toInt() - x);
    }

    public final boolean setDownCheck(int x) {
        this.setToValue(this.toInt() - x);
        return true;
    }

    public final boolean check() {
        return true;
    }

    public String getUsage() {
        return "Display";
    }

    private static final char hexChar(int value) {
        switch (value) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return Memory.getGlobalDecimal();
    }

    public final String toDebugString() {
        try {
            String usage;
            String result;
            String name;
            block36: {
                String pictureString;
                String elementString;
                String depthString;
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                int depth = -1;
                                Variable thevar = this;
                                depthString = "?";
                                try {
                                    while (thevar != null) {
                                        thevar = thevar.parent;
                                        ++depth;
                                    }
                                    depthString = DEFAULT_NAME + depth;
                                }
                                catch (Exception e) {
                                    if (!LogSetup.IS_LOGGING_INFO) break block32;
                                    LogSetup.LOGGER.info("catch (Exception e)");
                                    e.printStackTrace();
                                }
                            }
                            name = "?";
                            try {
                                name = this.getName();
                            }
                            catch (Exception e) {
                                if (!LogSetup.IS_LOGGING_INFO) break block33;
                                LogSetup.LOGGER.info("catch (Exception e)");
                                e.printStackTrace();
                            }
                        }
                        elementString = DEFAULT_NAME;
                        try {
                            boolean element;
                            boolean bl = element = this.firstChild == null;
                            if (element) {
                                if (this.dimensions() > 0) {
                                    if (name.indexOf(40) < 0) {
                                        element = false;
                                    } else {
                                        elementString = "*";
                                    }
                                } else {
                                    elementString = "*";
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!LogSetup.IS_LOGGING_INFO) break block34;
                            LogSetup.LOGGER.info("catch (Exception e)");
                            e.printStackTrace();
                        }
                    }
                    pictureString = DEFAULT_NAME;
                    try {
                        pictureString = this.getCompactPicture();
                    }
                    catch (Exception e) {
                        if (!LogSetup.IS_LOGGING_INFO) break block35;
                        LogSetup.LOGGER.info("catch (Exception e)");
                        e.printStackTrace();
                    }
                }
                result = DEFAULT_NAME + elementString + depthString + SPACES_STRING + pictureString;
                usage = "Display";
                try {
                    usage = this.getUsage();
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block36;
                    LogSetup.LOGGER.info("catch (Exception e)");
                    e.printStackTrace();
                }
            }
            if (!usage.equals("Display")) {
                result = result + SPACES_STRING + usage + SPACES_STRING;
            }
            result = result + " '" + name + AQUOTES_STRING;
            try {
                boolean dots = false;
                String displayString = this.toText();
                if (displayString == null) {
                    displayString = DEFAULT_NAME;
                }
                if (displayString.length() > 128) {
                    displayString = displayString.substring(0, 128);
                    dots = true;
                }
                int length = displayString.length();
                StringBuffer visible = new StringBuffer(length);
                boolean hexmode = false;
                char c = '\u0000';
                for (int i = 0; i < length; ++i) {
                    c = displayString.charAt(i);
                    if (c >= ' ') {
                        if (hexmode) {
                            visible.append('}');
                            hexmode = false;
                        }
                        visible.append(c);
                    } else {
                        if (!hexmode) {
                            hexmode = true;
                            visible.append("%{");
                        }
                        visible.append(Variable.hexChar(c >> 4));
                        visible.append(Variable.hexChar(c & 0xF));
                    }
                    if (visible.length() <= 128) continue;
                    dots = true;
                    break;
                }
                if (hexmode) {
                    visible.append('}');
                }
                if (dots) {
                    visible.append(" ...");
                }
                result = result + "=" + visible.toString();
            }
            catch (Exception e) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch (Exception e)");
                    e.printStackTrace();
                }
                result = result + "= unknown-data address=" + this.pointerAddress + " size=" + this.itemSize;
            }
            return result;
        }
        catch (Exception outerException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception outerException)");
                outerException.printStackTrace();
            }
            return "(unknown debug string)";
        }
    }

    public final String toDebugString2() {
        char CURRENT_DECIMAL = this.getDecimal();
        String str = "<Name=" + this.getName() + ". toString=" + this.toString() + ". toDisplayString=" + this.toDisplayString() + ". toText=" + this.toText() + ". toValueString=" + this.toValueString() + ". toNumericString=" + this.toNumericString() + ". toNumericValueString=" + this.toNumericValueString() + ". toInspectString=" + this.toInspectString() + ". getString()=" + this.getString() + ". itemSize aka length=" + this.getLength() + ". picLength=" + this.getPicLength() + ". PicArray=" + (this.getPictureArray() == null ? "NULL" : String.copyValueOf(this.getPictureArray())) + ". picForNumberLength=" + this.picForNumberLength + ". PicArray=" + (this.picForNumberArray == null ? "NULL" : String.copyValueOf(this.picForNumberArray)) + ". place=" + this.place + ". CompactPicture=" + this.getCompactPicture() + ". isJustRight()=" + this.isJustRight() + ". hasScreenProperty=" + this.hasScreenProperty() + ". isNum=" + this.isTypeNumeric() + ". isNumEdited=" + this.isTypeNumericEdited() + ". decimal=" + CURRENT_DECIMAL + ". typeName=" + this.getTypeName() + ". typeNumber=" + this.getTypeNumber() + ". type=" + this.getType() + ". className=" + this.getClassName() + ". dirty=" + this.dirty + ". alwaysFlush=" + this.alwaysFlush + ". handle=" + this.handle + ". notify=" + (this.notify == null ? "NULL" : this.notify.toDescription()) + ". getIdentifier()=" + this.getIdentifier() + ">";
        String displayableString = String2.makeDisplayable(str);
        return displayableString;
    }

    public int getAcceptSize() {
        return this.isInternational() ? this.length() / 2 : this.length();
    }

    protected final int[] createArrayDim(int requestDim) {
        Variable current = this;
        int dims = 0;
        int[] dim = new int[requestDim];
        while (current != null) {
            if (current.isArray()) {
                dim[dims] = current.maxIndex + 1;
                if (++dims >= requestDim) break;
            }
            current = current.parent;
        }
        if (dims < requestDim) {
            return null;
        }
        return dim;
    }

    protected final int[] createArraySiz(int requestDim) {
        Variable current = this;
        int dims = 0;
        int[] dimsiz = new int[requestDim];
        while (current != null) {
            if (current.isArray()) {
                dimsiz[dims] = current.length();
                if (++dims >= requestDim) break;
            }
            current = current.parent;
        }
        if (dims < requestDim) {
            return null;
        }
        return dimsiz;
    }

    public VariableSubscript createVariableArray(int dimensions) {
        int[] siz = this.createArraySiz(dimensions);
        int[] dim = this.createArrayDim(dimensions);
        if (siz == null) {
            return null;
        }
        VariableSubscript vs = new VariableSubscript(this, dim, siz);
        this.setSubscriptChild(vs);
        return vs;
    }

    public Variable[] createArray1() {
        int[] dim = this.createArrayDim(1);
        if (dim == null) {
            return null;
        }
        Variable[] result = new Variable[dim[0]];
        result[0] = ArrayIndexOutOfBoundsVariable.garbage;
        for (int i0 = 1; i0 < dim[0]; ++i0) {
            result[i0] = this.subscript(i0);
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][] createArray2() {
        int[] dim = this.createArrayDim(2);
        if (dim == null) {
            return null;
        }
        Variable[][] result = new Variable[dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[1]; ++i0) {
            for (int i1 = 0; i1 < dim[0]; ++i1) {
                result[i0][i1] = i0 == 0 || i1 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1);
            }
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][][] createArray3() {
        int[] dim = this.createArrayDim(3);
        if (dim == null) {
            return null;
        }
        Variable[][][] result = new Variable[dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[2]; ++i0) {
            for (int i1 = 0; i1 < dim[1]; ++i1) {
                for (int i2 = 0; i2 < dim[0]; ++i2) {
                    result[i0][i1][i2] = i0 == 0 || i1 == 0 || i2 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1, i2);
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][][][] createArray4() {
        int[] dim = this.createArrayDim(4);
        if (dim == null) {
            return null;
        }
        Variable[][][][] result = new Variable[dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[3]; ++i0) {
            for (int i1 = 0; i1 < dim[2]; ++i1) {
                for (int i2 = 0; i2 < dim[1]; ++i2) {
                    for (int i3 = 0; i3 < dim[0]; ++i3) {
                        result[i0][i1][i2][i3] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1, i2, i3);
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][][][][] createArray5() {
        int[] dim = this.createArrayDim(5);
        if (dim == null) {
            return null;
        }
        Variable[][][][][] result = new Variable[dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[4]; ++i0) {
            for (int i1 = 0; i1 < dim[3]; ++i1) {
                for (int i2 = 0; i2 < dim[2]; ++i2) {
                    for (int i3 = 0; i3 < dim[1]; ++i3) {
                        for (int i4 = 0; i4 < dim[0]; ++i4) {
                            result[i0][i1][i2][i3][i4] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][][][][][] createArray6() {
        int[] dim = this.createArrayDim(6);
        if (dim == null) {
            return null;
        }
        Variable[][][][][][] result = new Variable[dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[5]; ++i0) {
            for (int i1 = 0; i1 < dim[4]; ++i1) {
                for (int i2 = 0; i2 < dim[3]; ++i2) {
                    for (int i3 = 0; i3 < dim[2]; ++i3) {
                        for (int i4 = 0; i4 < dim[1]; ++i4) {
                            for (int i5 = 0; i5 < dim[0]; ++i5) {
                                result[i0][i1][i2][i3][i4][i5] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1, i2, i3, i4, i5);
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][][][][][][] createArray7() {
        int[] dim = this.createArrayDim(7);
        if (dim == null) {
            return null;
        }
        Variable[][][][][][][] result = new Variable[dim[6]][dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[6]; ++i0) {
            for (int i1 = 0; i1 < dim[5]; ++i1) {
                for (int i2 = 0; i2 < dim[4]; ++i2) {
                    for (int i3 = 0; i3 < dim[3]; ++i3) {
                        for (int i4 = 0; i4 < dim[2]; ++i4) {
                            for (int i5 = 0; i5 < dim[1]; ++i5) {
                                for (int i6 = 0; i6 < dim[0]; ++i6) {
                                    result[i0][i1][i2][i3][i4][i5][i6] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1, i2, i3, i4, i5, i6);
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public Variable[][][][][][][][] createArray8() {
        int[] dim = this.createArrayDim(8);
        if (dim == null) {
            return null;
        }
        Variable[][][][][][][][] result = new Variable[dim[7]][dim[6]][dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[7]; ++i0) {
            for (int i1 = 0; i1 < dim[6]; ++i1) {
                for (int i2 = 0; i2 < dim[5]; ++i2) {
                    for (int i3 = 0; i3 < dim[4]; ++i3) {
                        for (int i4 = 0; i4 < dim[3]; ++i4) {
                            for (int i5 = 0; i5 < dim[2]; ++i5) {
                                for (int i6 = 0; i6 < dim[1]; ++i6) {
                                    for (int i7 = 0; i7 < dim[0]; ++i7) {
                                        result[i0][i1][i2][i3][i4][i5][i6][i7] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.subscript(i0, i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[] createArray1(Variable[] result) {
        int[] dim = this.createArrayDim(1);
        if (dim == null) {
            return null;
        }
        result[0] = ArrayIndexOutOfBoundsVariable.garbage;
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        int dim0 = dim[0];
        for (int i0 = 1; i0 < dim0; ++i0) {
            result[i0].updateSubscript(i0, memory, offset);
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][] createArray2(Variable[][] result) {
        int[] dim = this.createArrayDim(2);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[1]; ++i0) {
            for (int i1 = 0; i1 < dim[0]; ++i1) {
                if (i0 == 0 || i1 == 0) {
                    result[i0][i1] = ArrayIndexOutOfBoundsVariable.garbage;
                    continue;
                }
                result[i0][i1].updateSubscript(i0, i1, memory, offset);
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][][] createArray3(Variable[][][] result) {
        int[] dim = this.createArrayDim(3);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[2]; ++i0) {
            for (int i1 = 0; i1 < dim[1]; ++i1) {
                for (int i2 = 0; i2 < dim[0]; ++i2) {
                    if (i0 == 0 || i1 == 0 || i2 == 0) {
                        result[i0][i1][i2] = ArrayIndexOutOfBoundsVariable.garbage;
                        continue;
                    }
                    result[i0][i1][i2].updateSubscript(i0, i1, i2, memory, offset);
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][][][] createArray4(Variable[][][][] result) {
        int[] dim = this.createArrayDim(4);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[3]; ++i0) {
            for (int i1 = 0; i1 < dim[2]; ++i1) {
                for (int i2 = 0; i2 < dim[1]; ++i2) {
                    for (int i3 = 0; i3 < dim[0]; ++i3) {
                        if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0) {
                            result[i0][i1][i2][i3] = ArrayIndexOutOfBoundsVariable.garbage;
                            continue;
                        }
                        result[i0][i1][i2][i3].updateSubscript(i0, i1, i2, i3, memory, offset);
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][][][][] createArray5(Variable[][][][][] result) {
        int[] dim = this.createArrayDim(5);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[4]; ++i0) {
            for (int i1 = 0; i1 < dim[3]; ++i1) {
                for (int i2 = 0; i2 < dim[2]; ++i2) {
                    for (int i3 = 0; i3 < dim[1]; ++i3) {
                        for (int i4 = 0; i4 < dim[0]; ++i4) {
                            if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) {
                                result[i0][i1][i2][i3][i4] = ArrayIndexOutOfBoundsVariable.garbage;
                                continue;
                            }
                            result[i0][i1][i2][i3][i4].updateSubscript(i0, i1, i2, i3, i4, memory, offset);
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][][][][][] createArray6(Variable[][][][][][] result) {
        int[] dim = this.createArrayDim(6);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[5]; ++i0) {
            for (int i1 = 0; i1 < dim[4]; ++i1) {
                for (int i2 = 0; i2 < dim[3]; ++i2) {
                    for (int i3 = 0; i3 < dim[2]; ++i3) {
                        for (int i4 = 0; i4 < dim[1]; ++i4) {
                            for (int i5 = 0; i5 < dim[0]; ++i5) {
                                if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0) {
                                    result[i0][i1][i2][i3][i4][i5] = ArrayIndexOutOfBoundsVariable.garbage;
                                    continue;
                                }
                                result[i0][i1][i2][i3][i4][i5].updateSubscript(i0, i1, i2, i3, i4, i5, memory, offset);
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][][][][][][] createArray7(Variable[][][][][][][] result) {
        int[] dim = this.createArrayDim(7);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[6]; ++i0) {
            for (int i1 = 0; i1 < dim[5]; ++i1) {
                for (int i2 = 0; i2 < dim[4]; ++i2) {
                    for (int i3 = 0; i3 < dim[3]; ++i3) {
                        for (int i4 = 0; i4 < dim[2]; ++i4) {
                            for (int i5 = 0; i5 < dim[1]; ++i5) {
                                for (int i6 = 0; i6 < dim[0]; ++i6) {
                                    if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0) {
                                        result[i0][i1][i2][i3][i4][i5][i6] = ArrayIndexOutOfBoundsVariable.garbage;
                                        continue;
                                    }
                                    result[i0][i1][i2][i3][i4][i5][i6].updateSubscript(i0, i1, i2, i3, i4, i5, i6, memory, offset);
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Variable[][][][][][][][] createArray8(Variable[][][][][][][][] result) {
        int[] dim = this.createArrayDim(8);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[7]; ++i0) {
            for (int i1 = 0; i1 < dim[6]; ++i1) {
                for (int i2 = 0; i2 < dim[5]; ++i2) {
                    for (int i3 = 0; i3 < dim[4]; ++i3) {
                        for (int i4 = 0; i4 < dim[3]; ++i4) {
                            for (int i5 = 0; i5 < dim[2]; ++i5) {
                                for (int i6 = 0; i6 < dim[1]; ++i6) {
                                    for (int i7 = 0; i7 < dim[0]; ++i7) {
                                        if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0) {
                                            result[i0][i1][i2][i3][i4][i5][i6][i7] = ArrayIndexOutOfBoundsVariable.garbage;
                                            continue;
                                        }
                                        result[i0][i1][i2][i3][i4][i5][i6][i7].updateSubscript(i0, i1, i2, i3, i4, i5, i6, i7, memory, offset);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final void releaseSubscript() {
        this.flushToMemory();
        if (Cache.standard) {
            this.removeNotify();
        }
    }

    private final void removeNotify() {
        if (this.alwaysFlush) {
            return;
        }
        if (this.pointerMemory != null) {
            this.pointerMemory.removeNotify(this);
        }
    }

    private final void addNotifyChildren() {
        if (this.alwaysFlush) {
            return;
        }
        if (this.pointerMemory != null) {
            this.pointerMemory.addNotifyChildren(this);
            this.notifyDelayed = false;
        }
    }

    public static void finalizeArray(VariableSubscript result) {
        result.finished();
    }

    public static void finalizeArray(NumericSubscript result) {
        result.finished();
    }

    public static void finalizeArray(DataPointerSubscript result) {
        result.finished();
    }

    public static void finalizeArray1(Variable[] result) {
        int resultLength = result.length;
        for (int i0 = 1; i0 < resultLength; ++i0) {
            result[i0].removeNotify();
        }
    }

    public static void finalizeArray2(Variable[][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                result[i0][i1].removeNotify();
            }
        }
    }

    public static void finalizeArray3(Variable[][][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                for (int i2 = 1; i2 < result[i0][i1].length; ++i2) {
                    result[i0][i1][i2].removeNotify();
                }
            }
        }
    }

    public static void finalizeArray4(Variable[][][][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                for (int i2 = 1; i2 < result[i0][i1].length; ++i2) {
                    for (int i3 = 1; i3 < result[i0][i1][i2].length; ++i3) {
                        result[i0][i1][i2][i3].removeNotify();
                    }
                }
            }
        }
    }

    public static void finalizeArray5(Variable[][][][][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                for (int i2 = 1; i2 < result[i0][i1].length; ++i2) {
                    for (int i3 = 1; i3 < result[i0][i1][i2].length; ++i3) {
                        for (int i4 = 1; i4 < result[i0][i1][i2][i3].length; ++i4) {
                            result[i0][i1][i2][i3][i4].removeNotify();
                        }
                    }
                }
            }
        }
    }

    public static void finalizeArray6(Variable[][][][][][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                for (int i2 = 1; i2 < result[i0][i1].length; ++i2) {
                    for (int i3 = 1; i3 < result[i0][i1][i2].length; ++i3) {
                        for (int i4 = 1; i4 < result[i0][i1][i2][i3].length; ++i4) {
                            for (int i5 = 1; i5 < result[i0][i1][i2][i3][i4].length; ++i5) {
                                result[i0][i1][i2][i3][i4][i5].removeNotify();
                            }
                        }
                    }
                }
            }
        }
    }

    public static void finalizeArray7(Variable[][][][][][][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                for (int i2 = 1; i2 < result[i0][i1].length; ++i2) {
                    for (int i3 = 1; i3 < result[i0][i1][i2].length; ++i3) {
                        for (int i4 = 1; i4 < result[i0][i1][i2][i3].length; ++i4) {
                            for (int i5 = 1; i5 < result[i0][i1][i2][i3][i4].length; ++i5) {
                                for (int i6 = 1; i6 < result[i0][i1][i2][i3][i4][i5].length; ++i6) {
                                    result[i0][i1][i2][i3][i4][i5][i6].removeNotify();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static void finalizeArray8(Variable[][][][][][][][] result) {
        for (int i0 = 1; i0 < result.length; ++i0) {
            for (int i1 = 1; i1 < result[i0].length; ++i1) {
                for (int i2 = 1; i2 < result[i0][i1].length; ++i2) {
                    for (int i3 = 1; i3 < result[i0][i1][i2].length; ++i3) {
                        for (int i4 = 1; i4 < result[i0][i1][i2][i3].length; ++i4) {
                            for (int i5 = 1; i5 < result[i0][i1][i2][i3][i4].length; ++i5) {
                                for (int i6 = 1; i6 < result[i0][i1][i2][i3][i4][i5].length; ++i6) {
                                    for (int i7 = 1; i7 < result[i0][i1][i2][i3][i4][i5][i6].length; ++i7) {
                                        result[i0][i1][i2][i3][i4][i5][i6][i7].removeNotify();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public final Numeric[] createNumericArray1() {
        int[] dim = this.createArrayDim(1);
        if (dim == null) {
            return null;
        }
        Numeric[] result = new Numeric[dim[0]];
        result[0] = ArrayIndexOutOfBoundsVariable.garbage;
        int dim0 = dim[0];
        for (int i0 = 1; i0 < dim0; ++i0) {
            result[i0] = this.numericSubscript(i0);
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][] createNumericArray2() {
        int[] dim = this.createArrayDim(2);
        if (dim == null) {
            return null;
        }
        Numeric[][] result = new Numeric[dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[1]; ++i0) {
            for (int i1 = 0; i1 < dim[0]; ++i1) {
                result[i0][i1] = i0 == 0 || i1 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1);
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][] createNumericArray3() {
        int[] dim = this.createArrayDim(3);
        if (dim == null) {
            return null;
        }
        Numeric[][][] result = new Numeric[dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[2]; ++i0) {
            for (int i1 = 0; i1 < dim[1]; ++i1) {
                for (int i2 = 0; i2 < dim[0]; ++i2) {
                    result[i0][i1][i2] = i0 == 0 || i1 == 0 || i2 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1, i2);
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][] createNumericArray4() {
        int[] dim = this.createArrayDim(4);
        if (dim == null) {
            return null;
        }
        Numeric[][][][] result = new Numeric[dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[3]; ++i0) {
            for (int i1 = 0; i1 < dim[2]; ++i1) {
                for (int i2 = 0; i2 < dim[1]; ++i2) {
                    for (int i3 = 0; i3 < dim[0]; ++i3) {
                        result[i0][i1][i2][i3] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1, i2, i3);
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][] createNumericArray5() {
        int[] dim = this.createArrayDim(5);
        if (dim == null) {
            return null;
        }
        Numeric[][][][][] result = new Numeric[dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[4]; ++i0) {
            for (int i1 = 0; i1 < dim[3]; ++i1) {
                for (int i2 = 0; i2 < dim[2]; ++i2) {
                    for (int i3 = 0; i3 < dim[1]; ++i3) {
                        for (int i4 = 0; i4 < dim[0]; ++i4) {
                            result[i0][i1][i2][i3][i4] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1, i2, i3, i4);
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][][] createNumericArray6() {
        int[] dim = this.createArrayDim(6);
        if (dim == null) {
            return null;
        }
        Numeric[][][][][][] result = new Numeric[dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[5]; ++i0) {
            for (int i1 = 0; i1 < dim[4]; ++i1) {
                for (int i2 = 0; i2 < dim[3]; ++i2) {
                    for (int i3 = 0; i3 < dim[2]; ++i3) {
                        for (int i4 = 0; i4 < dim[1]; ++i4) {
                            for (int i5 = 0; i5 < dim[0]; ++i5) {
                                result[i0][i1][i2][i3][i4][i5] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1, i2, i3, i4, i5);
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][][][] createNumericArray7() {
        int[] dim = this.createArrayDim(7);
        if (dim == null) {
            return null;
        }
        Numeric[][][][][][][] result = new Numeric[dim[6]][dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[6]; ++i0) {
            for (int i1 = 0; i1 < dim[5]; ++i1) {
                for (int i2 = 0; i2 < dim[4]; ++i2) {
                    for (int i3 = 0; i3 < dim[3]; ++i3) {
                        for (int i4 = 0; i4 < dim[2]; ++i4) {
                            for (int i5 = 0; i5 < dim[1]; ++i5) {
                                for (int i6 = 0; i6 < dim[0]; ++i6) {
                                    result[i0][i1][i2][i3][i4][i5][i6] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1, i2, i3, i4, i5, i6);
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][][][][] createNumericArray8() {
        int[] dim = this.createArrayDim(8);
        if (dim == null) {
            return null;
        }
        Numeric[][][][][][][][] result = new Numeric[dim[7]][dim[6]][dim[5]][dim[4]][dim[3]][dim[2]][dim[1]][dim[0]];
        for (int i0 = 0; i0 < dim[7]; ++i0) {
            for (int i1 = 0; i1 < dim[6]; ++i1) {
                for (int i2 = 0; i2 < dim[5]; ++i2) {
                    for (int i3 = 0; i3 < dim[4]; ++i3) {
                        for (int i4 = 0; i4 < dim[3]; ++i4) {
                            for (int i5 = 0; i5 < dim[2]; ++i5) {
                                for (int i6 = 0; i6 < dim[1]; ++i6) {
                                    for (int i7 = 0; i7 < dim[0]; ++i7) {
                                        result[i0][i1][i2][i3][i4][i5][i6][i7] = i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0 ? ArrayIndexOutOfBoundsVariable.garbage : this.numericSubscript(i0, i1, i2, i3, i4, i5, i6, i7);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[] createNumericArray1(Numeric[] result) {
        int[] dim = this.createArrayDim(1);
        if (dim == null) {
            return null;
        }
        result[0] = ArrayIndexOutOfBoundsVariable.garbage;
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 1; i0 < dim[0]; ++i0) {
            result[i0].updateNumericSubscript(i0, memory, offset);
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][] createNumericArray2(Numeric[][] result) {
        int[] dim = this.createArrayDim(2);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[1]; ++i0) {
            for (int i1 = 0; i1 < dim[0]; ++i1) {
                if (i0 == 0 || i1 == 0) {
                    result[i0][i1] = ArrayIndexOutOfBoundsVariable.garbage;
                    continue;
                }
                result[i0][i1].updateNumericSubscript(i0, i1, memory, offset);
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][] createNumericArray3(Numeric[][][] result) {
        int[] dim = this.createArrayDim(3);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[2]; ++i0) {
            for (int i1 = 0; i1 < dim[1]; ++i1) {
                for (int i2 = 0; i2 < dim[0]; ++i2) {
                    if (i0 == 0 || i1 == 0 || i2 == 0) {
                        result[i0][i1][i2] = ArrayIndexOutOfBoundsVariable.garbage;
                        continue;
                    }
                    result[i0][i1][i2].updateNumericSubscript(i0, i1, i2, memory, offset);
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][] createNumericArray4(Numeric[][][][] result) {
        int[] dim = this.createArrayDim(4);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[3]; ++i0) {
            for (int i1 = 0; i1 < dim[2]; ++i1) {
                for (int i2 = 0; i2 < dim[1]; ++i2) {
                    for (int i3 = 0; i3 < dim[0]; ++i3) {
                        if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0) {
                            result[i0][i1][i2][i3] = ArrayIndexOutOfBoundsVariable.garbage;
                            continue;
                        }
                        result[i0][i1][i2][i3].updateNumericSubscript(i0, i1, i2, i3, memory, offset);
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][] createNumericArray5(Numeric[][][][][] result) {
        int[] dim = this.createArrayDim(5);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[4]; ++i0) {
            for (int i1 = 0; i1 < dim[3]; ++i1) {
                for (int i2 = 0; i2 < dim[2]; ++i2) {
                    for (int i3 = 0; i3 < dim[1]; ++i3) {
                        for (int i4 = 0; i4 < dim[0]; ++i4) {
                            if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0) {
                                result[i0][i1][i2][i3][i4] = ArrayIndexOutOfBoundsVariable.garbage;
                                continue;
                            }
                            result[i0][i1][i2][i3][i4].updateNumericSubscript(i0, i1, i2, i3, i4, memory, offset);
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][][] createNumericArray6(Numeric[][][][][][] result) {
        int[] dim = this.createArrayDim(6);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[5]; ++i0) {
            for (int i1 = 0; i1 < dim[4]; ++i1) {
                for (int i2 = 0; i2 < dim[3]; ++i2) {
                    for (int i3 = 0; i3 < dim[2]; ++i3) {
                        for (int i4 = 0; i4 < dim[1]; ++i4) {
                            for (int i5 = 0; i5 < dim[0]; ++i5) {
                                if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0) {
                                    result[i0][i1][i2][i3][i4][i5] = ArrayIndexOutOfBoundsVariable.garbage;
                                    continue;
                                }
                                result[i0][i1][i2][i3][i4][i5].updateNumericSubscript(i0, i1, i2, i3, i4, i5, memory, offset);
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][][][] createNumericArray7(Numeric[][][][][][][] result) {
        int[] dim = this.createArrayDim(7);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[6]; ++i0) {
            for (int i1 = 0; i1 < dim[5]; ++i1) {
                for (int i2 = 0; i2 < dim[4]; ++i2) {
                    for (int i3 = 0; i3 < dim[3]; ++i3) {
                        for (int i4 = 0; i4 < dim[2]; ++i4) {
                            for (int i5 = 0; i5 < dim[1]; ++i5) {
                                for (int i6 = 0; i6 < dim[0]; ++i6) {
                                    if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0) {
                                        result[i0][i1][i2][i3][i4][i5][i6] = ArrayIndexOutOfBoundsVariable.garbage;
                                        continue;
                                    }
                                    result[i0][i1][i2][i3][i4][i5][i6].updateNumericSubscript(i0, i1, i2, i3, i4, i5, i6, memory, offset);
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public final Numeric[][][][][][][][] createNumericArray8(Numeric[][][][][][][][] result) {
        int[] dim = this.createArrayDim(8);
        if (dim == null) {
            return null;
        }
        Memory memory = this.pointerMemory;
        int offset = this.pointerAddress;
        for (int i0 = 0; i0 < dim[7]; ++i0) {
            for (int i1 = 0; i1 < dim[6]; ++i1) {
                for (int i2 = 0; i2 < dim[5]; ++i2) {
                    for (int i3 = 0; i3 < dim[4]; ++i3) {
                        for (int i4 = 0; i4 < dim[3]; ++i4) {
                            for (int i5 = 0; i5 < dim[2]; ++i5) {
                                for (int i6 = 0; i6 < dim[1]; ++i6) {
                                    for (int i7 = 0; i7 < dim[0]; ++i7) {
                                        if (i0 == 0 || i1 == 0 || i2 == 0 || i3 == 0 || i4 == 0 || i5 == 0 || i6 == 0 || i7 == 0) {
                                            result[i0][i1][i2][i3][i4][i5][i6][i7] = ArrayIndexOutOfBoundsVariable.garbage;
                                            continue;
                                        }
                                        result[i0][i1][i2][i3][i4][i5][i6][i7].updateNumericSubscript(i0, i1, i2, i3, i4, i5, i6, i7, memory, offset);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.arrayChild = result;
        return result;
    }

    public static void cleanArray(Object[] array, boolean alsoFlush) {
        for (int i = 1; i < array.length; ++i) {
            Object arrOrElem = array[i];
            if (arrOrElem instanceof Object[]) {
                Variable.cleanArray((Object[])arrOrElem, alsoFlush);
                continue;
            }
            if (arrOrElem instanceof VariableSubscript) {
                ((VariableSubscript)arrOrElem).flushAllContinue();
                continue;
            }
            Variable element = (Variable)arrOrElem;
            if (element.modifyOnce == ModifyOnce) {
                return;
            }
            if (alsoFlush && element.dirty && element.valid) {
                element.flushToMemory();
            }
            element.valid = false;
            element.dirty = false;
            element.cleanChildren(alsoFlush);
        }
    }

    public void cleanAssociates(boolean alsoFlush) {
        if (this.redefinedFrom != null && this.redefinedFrom.modifyOnce != ModifyOnce) {
            if (this.redefinedFrom.dirty && alsoFlush && this.redefinedFrom.firstChild == null) {
                this.redefinedFrom.flushDirtyToMemory();
            } else {
                this.redefinedFrom.valid = false;
            }
            this.redefinedFrom.cleanChildren(alsoFlush);
            this.redefinedFrom.cleanAncestors();
        }
        if (this.redefinedTo != null) {
            for (Variable tmp2 : this.redefinedTo) {
                if (tmp2.modifyOnce == ModifyOnce) continue;
                if (tmp2.dirty && alsoFlush && tmp2.firstChild == null) {
                    tmp2.flushDirtyToMemory();
                }
                tmp2.cleanChildren(alsoFlush);
                tmp2.cleanAncestors();
            }
        }
    }

    public void cleanChildren(boolean alsoFlush) {
        if (this.modifyOnce == ModifyOnce) {
            return;
        }
        this.modifyOnce = ModifyOnce;
        Variable tmp = this.firstChild;
        while (tmp != null) {
            tmp.valid = false;
            if (tmp.dirty && alsoFlush && tmp.firstChild == null) {
                if (!(tmp instanceof Numeric)) {
                    --ModifyOnce;
                }
                tmp.flushToMemory();
            }
            tmp.dirty = false;
            tmp.cleanAssociates(alsoFlush);
            tmp.cleanChildren(alsoFlush);
            if (tmp.arrayChild != null) {
                Variable.cleanArray(tmp.arrayChild, alsoFlush);
            }
            tmp = tmp.nextSibling;
        }
    }

    public void cleanAncestors() {
        Variable tmp = this.parent;
        while (tmp != null) {
            if (tmp.modifyOnce != ModifyOnce) {
                tmp.cleanAncestorsContinue();
                tmp.cleanAssociates(true);
                if (tmp.arrayChild != null) {
                    Variable.cleanArray(tmp.arrayChild, true);
                }
                this.modifyOnce = ModifyOnce;
                tmp.valid = false;
                tmp.dirty = false;
            }
            tmp = tmp.parent;
        }
    }

    public void cleanAncestorsContinue() {
    }

    public void flushDirtyToMemory() {
        this.numericString = null;
        if (Cache.standard) {
            this.dirty = false;
        } else if (Cache.forbid) {
            if (!this.valid) {
                ++ModifyOnce;
                this.cleanAssociates(false);
                this.cleanChildren(false);
                this.cleanAncestors();
            }
            this.valid = true;
            this.dirty = false;
        }
    }

    public void flushToMemory() {
        this.numericString = null;
        if (Cache.standard) {
            if (this.notifyDelayed) {
                if (this.pointerMemory != null) {
                    this.pointerMemory.addNotify(this);
                }
                this.notifyDelayed = false;
            }
            if (this.dirty) {
                this.dirty = false;
            } else if (this.notify != null) {
                this.notify.flushToMemory();
            } else if (this.pointerMemory != null) {
                this.pointerMemory.flushToMemory(this, false);
            }
        } else if (Cache.forbid) {
            if (!this.valid) {
                ++ModifyOnce;
                this.cleanAssociates(true);
                this.cleanChildren(true);
                this.cleanAncestors();
                this.valid = true;
            }
            this.dirty = false;
        }
    }

    public void fillFromMemory() {
        if (Cache.forbid) {
            if (!this.valid) {
                ++ModifyOnce;
                this.cleanAssociates(true);
                this.cleanChildren(true);
                this.cleanAncestors();
            }
            this.valid = true;
            this.dirty = false;
        }
    }

    private final void fillFromMemoryAll() {
        if (Cache.standard) {
            if (this.alwaysFlush) {
                return;
            }
            this.dirty = false;
            this.valid = true;
            this.fillFromMemory();
            Variable v = this.firstChild;
            while (v != null) {
                v.fillFromMemoryAll();
                v = v.nextSibling;
            }
        } else {
            this.fillFromMemory();
        }
    }

    public void updateFromMemory(boolean andMarkDirty) {
    }

    public final void setDirty() {
        this.numericString = null;
        if (Cache.standard) {
            if (this.dirty) {
                return;
            }
            if (this.alwaysFlush) {
                return;
            }
            if (this.notifyDelayed) {
                if (this.pointerMemory != null) {
                    this.pointerMemory.addNotify(this);
                }
                this.notifyDelayed = false;
            }
            if (this.notify != null && !this.isNumericInstance()) {
                this.notify.flushToMemory();
            }
            this.valid = true;
            this.dirty = true;
            this.fillFromMemory();
        } else if (Cache.forbid) {
            if (!this.valid && !this.dirty) {
                this.fillFromMemory();
            }
            this.valid = true;
            this.dirty = true;
        }
    }

    public final void setValid() {
        this.numericString = null;
        if (Cache.standard) {
            if (this.valid) {
                return;
            }
            if (this.alwaysFlush) {
                return;
            }
            if (this.notifyDelayed) {
                if (this.pointerMemory != null) {
                    this.pointerMemory.addNotify(this);
                }
                this.notifyDelayed = false;
            }
            if (this.notify != null && !this.isNumericInstance()) {
                this.notify.flushToMemory();
            }
            this.valid = true;
            this.dirty = true;
            this.fillFromMemory();
            this.dirty = false;
        } else if (Cache.forbid && !this.valid && !this.dirty) {
            this.fillFromMemory();
        }
    }

    public final void setDirtyNoFill() {
        this.numericString = null;
        if (Cache.standard) {
            if (this.dirty) {
                return;
            }
            if (this.alwaysFlush) {
                return;
            }
            if (this.notifyDelayed) {
                if (this.pointerMemory != null) {
                    this.pointerMemory.addNotify(this);
                }
                this.notifyDelayed = false;
            }
            if (this.notify != null) {
                this.notify.flushToMemory();
            } else if (this.pointerMemory != null) {
                this.pointerMemory.flushToMemory(this, true);
            }
            this.valid = true;
            this.dirty = true;
        } else {
            if (!this.dirty) {
                ++ModifyOnce;
                this.cleanAssociates(false);
                this.cleanChildren(false);
                this.cleanAncestors();
            }
            this.valid = true;
            this.dirty = true;
        }
    }

    public final void prepareMemoryForWrite() {
        this.numericString = null;
        if (Cache.standard) {
            if (this.dirty) {
                this.valid = false;
                this.dirty = false;
                return;
            }
            if (this.alwaysFlush) {
                return;
            }
            if (this.notifyDelayed) {
                if (this.pointerMemory != null) {
                    this.pointerMemory.addNotify(this);
                }
                this.notifyDelayed = false;
            }
            if (this.notify != null) {
                int notifySize = this.notify.size();
                Variable[] elementData = this.notify.elementData;
                for (int i = 0; i < notifySize; ++i) {
                    elementData[i].invalidateCache();
                }
            } else if (this.pointerMemory != null) {
                this.pointerMemory.invalidateCache(this);
            }
        } else {
            if (!this.valid) {
                ++ModifyOnce;
                this.cleanAssociates(false);
                this.cleanChildren(false);
                this.cleanAncestors();
            }
            this.valid = false;
            this.dirty = false;
        }
    }

    public final void prepareRecordToRead() {
        this.prepareMemoryForWrite();
    }

    public final void prepareRecordToWrite() {
        this.flushToMemory();
    }

    public final void invalidateCache() {
        this.numericString = null;
        this.valid = false;
        this.dirty = false;
    }

    public final String getNotify() {
        if (Cache.standard) {
            int i;
            if (this.notifyDelayed) {
                if (this.pointerMemory != null) {
                    this.pointerMemory.addNotify(this);
                }
                this.notifyDelayed = false;
            }
            if (this.notify == null) {
                return "[no notify]";
            }
            int notifySize = this.notify.size();
            StringBuffer result = new StringBuffer("[");
            int duplicates = 0;
            for (i = 0; i < notifySize; ++i) {
                for (int j = i + 1; j < notifySize; ++j) {
                    if (this.notify.elementAt(i) != this.notify.elementAt(j)) continue;
                    ++duplicates;
                }
            }
            result.append("dups(").append(duplicates).append("):");
            for (i = 0; i < notifySize; ++i) {
                Variable v = this.notify.elementAt(i);
                if (i != 0) {
                    result.append(",");
                }
                result.append(v.getName() + " @ " + DataPointer.getPointerString(v));
            }
            result.append(']');
            return result.toString();
        }
        return null;
    }

    public static int getNarg() {
        return narg;
    }

    public static Context setCurrContext(Context context) {
        Context _oldContext = _currContext;
        _currContext = context;
        return _oldContext;
    }

    public static void setNarg(parameterList param) {
        if (param != null) {
            param.setBufferNarg(narg);
            narg = param.size();
            if (_currContext != null) {
                String linkMemDesc = DEFAULT_NAME;
                for (int i = 0; i < narg; ++i) {
                    if (param.getVariable((int)i).pointerMemory == null || linkMemDesc.indexOf(param.getVariable((int)i).pointerMemory.toString()) != -1) continue;
                    linkMemDesc = linkMemDesc + ":" + param.getVariable((int)i).pointerMemory.toString();
                }
                _currContext.setlnkPointerMemory(linkMemDesc);
            }
        } else {
            narg = 0;
        }
    }

    public static void setNarg(int value) {
        narg = value;
    }

    public final Variable ipc_init(parameterList param, int index) {
        if (param == null || index < 0 || index > param.getLength() + param.numberMissing()) {
            return null;
        }
        if (index >= param.getLength()) {
            param.addMissing(index, this.pointerMemory);
            this.pointerMemory = null;
            return this;
        }
        Memory memory = this.pointerMemory;
        if (param.isOmitted(index)) {
            this.setNative(false);
            param.setOrigMemory(index, this.pointerMemory);
            this.pointerMemory = null;
            return this;
        }
        if (param.isByteArray(index)) {
            this.setArgument(param.getByteArray(index));
            param.setVariable(index, this);
        }
        this.setNative(false);
        param.setOrigMemory(index, this.pointerMemory);
        param.setOrigAddress(index, this.pointerAddress);
        param.setOrigSize(index, this.itemSize);
        if (param.byReference(index)) {
            this.setBigGroupPointer(param.getPointerMemory(index), param.getPointerAddress(index), param.getMaxSize(index));
            this.fillFromMemoryAll();
        } else {
            param.getPointerAddress(index);
            if (param.getSize(index) == 0) {
                this.move(param.getString(index));
            } else if (memory != null) {
                int copyLen;
                Memory formalMemory = this.pointerMemory;
                int formalParamLen = this.length();
                int formalParamAddr = this.pointerAddress;
                Memory actualMemory = param.getMemory(index);
                int actualParamLen = param.getSize(index);
                int actualParamAddr = param.getAddress(index);
                if (actualParamLen < formalParamLen) {
                    int padLen = formalParamLen - actualParamLen;
                    this.pointerMemory.pad(formalParamAddr + actualParamLen, padLen);
                    copyLen = actualParamLen;
                } else {
                    copyLen = formalParamLen;
                }
                formalMemory.copy(actualMemory, actualParamAddr, formalParamAddr, copyLen);
            }
        }
        this.setHandle(param.getVariable(index).getHandle());
        return this;
    }

    public static void ipc_ready(Variable[] linkageVars) {
        Variable v;
        int i;
        if (linkageVars == null) {
            return;
        }
        int vars_length = linkageVars.length;
        for (i = 0; i < vars_length; ++i) {
            v = linkageVars[i];
            if (v == null) continue;
            if (v.isNative()) {
                v = null;
                continue;
            }
            v.flushToMemory();
        }
        if (Cache.standard) {
            Memory m;
            for (i = 0; i < vars_length; ++i) {
                v = linkageVars[i];
                if (v == null || (m = v.pointerMemory) == null) continue;
                m.removeNotify(v);
            }
            for (i = 0; i < vars_length; ++i) {
                v = linkageVars[i];
                if (v == null || (m = v.pointerMemory) == null) continue;
                m.delayNotifyChildren(v);
            }
        }
        for (i = 0; i < vars_length; ++i) {
            v = linkageVars[i];
            if (v == null || v.pointerMemory == null) continue;
            v.fillFromMemoryAll();
        }
    }

    public static void ipc_finish(Variable[] toProgramParams, parameterList fromProgramParams) {
        Variable.ipc_finish(toProgramParams, fromProgramParams, "program");
    }

    public static void ipc_finish(Variable[] linkageVars, parameterList fromProgramParams, String programName) {
        Variable v;
        int i;
        if (fromProgramParams != null) {
            narg = fromProgramParams.getBufferNarg();
        }
        if (linkageVars == null) {
            return;
        }
        if (fromProgramParams.isCallFromJava()) {
            fromProgramParams.completeJavaCall(linkageVars);
        }
        for (i = linkageVars.length - 1; i >= 0; --i) {
            v = linkageVars[i];
            if (v == null) continue;
            v.flushToMemory();
            if (!Cache.forbid) continue;
            ++ModifyOnce;
            v.cleanAssociates(true);
            v.cleanChildren(true);
        }
        if (Cache.standard) {
            for (i = 0; i < linkageVars.length; ++i) {
                v = linkageVars[i];
                if (v == null) continue;
                v.removeNotify();
            }
        }
        for (i = linkageVars.length - 1; i >= 0; --i) {
            v = linkageVars[i];
            if (fromProgramParams.isMissing(i)) {
                v.pointerMemory = (Memory)fromProgramParams.getMissing(i);
                continue;
            }
            if (fromProgramParams.isOmitted(i)) {
                v.pointerMemory = fromProgramParams.getOrigMemory(i);
                continue;
            }
            if (v == null) continue;
            int offset = fromProgramParams.getOrigAddress(i);
            Memory memory = fromProgramParams.getOrigMemory(i);
            v.itemSize = fromProgramParams.getOrigSize(i);
            ++ModifyOnce;
            v.setGroupPointer(memory, offset - v.getAddress());
            v.resetGroupSize();
        }
    }

    public static void ipc_final(Variable[] linkageVars, parameterList fromProgramParams) {
        Variable.ipc_final(linkageVars);
    }

    public static void ipc_final(Variable[] linkageVars) {
        if (linkageVars == null) {
            return;
        }
        if (Cache.standard) {
            for (int i = 0; i < linkageVars.length; ++i) {
                Variable v = linkageVars[i];
                if (v == null || v.pointerMemory == null) continue;
                v.pointerMemory.addNotify(v);
                v.notifyDelayed = false;
            }
        }
    }

    public Variable setIdentifiedBy(String name) {
        this.flagBits |= 0x40000000;
        this.name = name;
        return this;
    }

    public boolean isIdentified() {
        return (this.flagBits & 0x40000000) == 0x40000000;
    }

    public String getIdentifier() {
        return this.name;
    }

    public boolean isExternalForm() {
        return this.isUsageExternalForm();
    }

    public Handle getHandle() {
        return this.handle;
    }

    public boolean isHandle() {
        return this.handle != null;
    }

    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    public Variable settingHandle(Handle handle) {
        this.handle = handle;
        return this;
    }

    public String getValueOfHandle() {
        return this.handle != null ? this.handle.getValue() : SPACES_STRING;
    }

    public Variable(Handle handle) {
        this.handle = handle;
        this.move(handle.getHandleNumber());
    }

    public Variable updateHandle() {
        if (this.handle != null) {
            return this.move(this.handle.getHandleNumber());
        }
        return this;
    }

    public Variable move(Handle copy) {
        if (this.handle != null) {
            this.handle.set(copy);
        } else {
            this.handle = copy;
        }
        return this.move(copy.getHandleNumber());
    }

    public Variable move(ThreadQueue threadQueue) {
        this.handle = new Handle(threadQueue);
        return this;
    }

    public byte[] getArgument() {
        try {
            if (this.length() == 0) {
                if (this.handle != null) {
                    return ConvertData.nativeIntToBytes(this.handle.getHandleNumber());
                }
                return ConvertData.nativeIntToBytes(this.pointerAddress);
            }
            this.flushToMemory();
            byte[] result = new byte[this.length()];
            this.pointerMemory.copy(this.pointerAddress, result, 0, this.length());
            return result;
        }
        catch (Exception neverThrowException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception neverThrowException)");
                neverThrowException.printStackTrace();
            }
            return null;
        }
    }

    public byte[] getBytes() {
        try {
            return this.toByteArray();
        }
        catch (Exception neverThrowException) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception neverThrowException)");
                neverThrowException.printStackTrace();
            }
            return null;
        }
    }

    public void setArgument(byte[] data) {
        block5: {
            try {
                if (this.length() == 0) {
                    if (this.getHandle() == null) {
                        this.pointerAddress = ConvertData.nativeBytesToInt(data);
                    }
                } else {
                    this.setString(data);
                }
            }
            catch (Exception neverThrowException) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.info("catch (Exception neverThrowException)");
                neverThrowException.printStackTrace();
            }
        }
    }

    public int getArgumentType() {
        if (this.firstChild != null) {
            return 22;
        }
        boolean numeric = (this.flagBits & 0x4000000) != 0;
        boolean edited = (this.flagBits & 0x8000000) != 0;
        boolean national = (this.flagBits & 0x10000000) != 0;
        boolean alphabetic = (this.flagBits & 0x20000000) != 0;
        boolean just = this.isJustRight();
        if (alphabetic) {
            return just ? 19 : 18;
        }
        if (numeric) {
            return edited ? 0 : 97;
        }
        if (national) {
            return edited ? 26 : (just ? 25 : 24);
        }
        return edited ? 20 : (just ? 17 : 16);
    }

    protected int getBasicType(int preferredType) {
        int value = 0;
        switch (this.signPosition) {
            case 0: {
                value |= 0;
                break;
            }
            case 2: {
                value |= 1;
                break;
            }
            case 3: {
                value |= 2;
                break;
            }
            case 4: {
                value |= 3;
                break;
            }
            case 5: {
                value |= 4;
            }
        }
        value = this.isJustRight() ? (value |= 8) : (value |= 0);
        if (!this.isTableElement()) {
            boolean array = false;
            Variable check = this;
            while (check != null) {
                if (check.isArray()) {
                    array = true;
                    break;
                }
                check = check.parent;
            }
            value = array ? (value |= 0x40) : (value |= preferredType);
        } else {
            value |= preferredType;
        }
        if (this.isFlagRedefines()) {
            value |= 0x1000;
        }
        return value;
    }

    protected int getBasicType() {
        return this.getBasicType(0);
    }

    @Override
    public int getType() {
        int basicType = this.getBasicType();
        if (this.firstChild != null && (basicType & 0x40) == 0) {
            return basicType | 0x20;
        }
        return basicType | 0;
    }

    public int getNumericInfo() {
        return (this.flagBits & 0x3C000000) == 0x4000000 ? this.place : (byte)0;
    }

    public Variable setIndicator(int value) {
        this.indicator = value;
        return this;
    }

    public int getIndicator() {
        return this.indicator;
    }

    public Date getDate() {
        try {
            if (this.format != null) {
                return FormatDateTime.format(this.format, this.toString());
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
            Date dateStr = formatter.parse(this.toString());
            return dateStr;
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch (Exception e)");
                e.printStackTrace();
            }
            return null;
        }
    }

    public Object getObjectParameter() {
        if (this.length() == 1) {
            return new Character(this.toChar());
        }
        return this.toString();
    }

    public Object getSqlObject(int sqlType) {
        return this.getSqlObject(sqlType, null, null);
    }

    public Object getSqlObject(int sqlType, String dateFormat) {
        return this.getSqlObject(sqlType, null, dateFormat);
    }

    public Object getSqlObject(int sqlType, IDatatype indicator) {
        return this.getSqlObject(sqlType, indicator, null);
    }

    public Object getSqlObject(int sqlType, IDatatype indicator, String dateFormat) {
        int indicatorValue;
        if (indicator != null && (indicatorValue = indicator.toInt()) < 0) {
            return null;
        }
        if (sqlInferDateTime == null) {
            sqlInferDateTime = "true".equalsIgnoreCase(RuntimeEnvironment.getGlobalParameter("sql.infer.datetime")) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (sqlLowValueIsSpace == null) {
            sqlLowValueIsSpace = "true".equalsIgnoreCase(RuntimeEnvironment.getGlobalParameter("sql.translate.lowvalues")) ? Boolean.TRUE : Boolean.FALSE;
        }
        switch (sqlType) {
            case 0: {
                return this.getSqlObject();
            }
            case 8: 
            case 96: 
            case 97: {
                if (sqlInferDateTime.booleanValue()) {
                    switch (this.itemSize) {
                        case 8: {
                            if (!TIME_PATTERN.matcher(this.toText()).matches()) break;
                            return Time.valueOf(this.toText());
                        }
                        case 10: {
                            if (DATE_PATTERN_ISO.matcher(this.toText()).matches()) {
                                return java.sql.Date.valueOf(LocalDate.parse(this.toString(), DateTimeFormatter.ISO_DATE));
                            }
                            if (!DATE_PATTERN_USA.matcher(this.toText()).matches()) break;
                            return java.sql.Date.valueOf(LocalDate.parse(this.toString(), DateTimeFormatter.ofPattern("MM/dd/yyyy")));
                        }
                        case 26: {
                            if (!TIMESTAMP_PATTERN.matcher(this.toText()).matches()) break;
                            return Timestamp.valueOf(this.toText());
                        }
                    }
                }
                if (this.isContainingInternational()) {
                    if (sqlLowValueIsSpace.booleanValue()) {
                        return this.toText().replaceAll("\\x00", SPACES_STRING);
                    }
                    return this.toText();
                }
                if (sqlLowValueIsSpace.booleanValue()) {
                    return this.toDatabase(this.toText().replaceAll("\\x00", SPACES_STRING));
                }
                return this.toDatabase(this.toText());
            }
            case 256: 
            case 258: {
                return this.toText();
            }
            case 12: {
                if (this.format != null) {
                    return java.sql.Date.valueOf(FormatDateTime.format(this.format, this.toString()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                }
                if (dateFormat != null) {
                    if ("yyyy-mm-dd".equals(dateFormat)) {
                        return java.sql.Date.valueOf(LocalDate.parse(this.toString(), DateTimeFormatter.ISO_DATE));
                    }
                    if ("mm/dd/yyyy".equals(dateFormat)) {
                        return java.sql.Date.valueOf(LocalDate.parse(this.toString(), DateTimeFormatter.ofPattern("MM/dd/yyyy")));
                    }
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
                    return java.sql.Date.valueOf(LocalDate.parse(this.toString(), formatter));
                }
                return java.sql.Date.valueOf(this.toString());
            }
            case 92: {
                return Time.valueOf(this.toText());
            }
            case 93: {
                return Timestamp.valueOf(this.toText());
            }
            case 3: {
                return Integer.valueOf(this.toNumericString());
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 68: 
            case 91: 
            case 152: 
            case 153: 
            case 154: 
            case 172: {
                return new BigDecimal(this.toNumericString());
            }
            case 23: 
            case 24: {
                return this.toByteArray();
            }
            case 262: {
                Variable child = this.firstChild;
                if (child != null) {
                    int length = child.toInt();
                    Variable data = child.nextSibling;
                    if (length <= 0) {
                        return DEFAULT_NAME;
                    }
                    if (length > data.maxItemSize) {
                        return this.toDatabase(data.toString().substring(0, data.maxItemSize));
                    }
                    if (this.isContainingInternational()) {
                        return data.toText().substring(0, length);
                    }
                    return this.toDatabase(data.toString().substring(0, length));
                }
                if (this.isContainingInternational()) {
                    return Variable.rightTrim(this.toText());
                }
                return this.toDatabase(Variable.rightTrim(this.toString()));
            }
            case 9: 
            case 11: 
            case 94: {
                Variable child = this.firstChild;
                if (child != null) {
                    int length = child.toInt();
                    Variable data = child.nextSibling;
                    if (length <= 0) {
                        return DEFAULT_NAME;
                    }
                    if (length > data.maxItemSize) {
                        return this.toDatabase(Variable.rightTrim(data.toString()));
                    }
                    if (this.isContainingInternational()) {
                        return Variable.rightTrim(data.toText().substring(0, length));
                    }
                    return this.toDatabase(Variable.rightTrim(data.toString().substring(0, length)));
                }
                if (this.isContainingInternational()) {
                    return Variable.rightTrim(this.toText());
                }
                return this.toDatabase(Variable.rightTrim(this.toString()));
            }
            case 1: 
            case 257: 
            case 259: {
                return Variable.rightTrim(this.toText());
            }
            case 5: {
                if (this.isContainingInternational()) {
                    return Variable.rightTrim(this.toText());
                }
                return this.toDatabase(Variable.rightTrim(this.toString()));
            }
            case 263: {
                Variable data;
                int length;
                if (this.firstChild != null && this.firstChild.nextSibling != null && this.firstChild.nextSibling.nextSibling == null) {
                    length = this.firstChild.toInt();
                    if (length > (data = this.firstChild.nextSibling).length()) {
                        length = data.length();
                    } else if (length < 0) {
                        length = 0;
                    }
                } else if (this.firstChild != null && this.firstChild.nextSibling != null && this.firstChild.nextSibling.nextSibling != null && this.firstChild.nextSibling.nextSibling.nextSibling == null) {
                    length = this.firstChild.nextSibling.toInt();
                    if (length > (data = this.firstChild.nextSibling.nextSibling).length()) {
                        length = data.length();
                    } else if (length < 0) {
                        length = 0;
                    }
                } else if (this.firstChild != null) {
                    length = this.length();
                    data = this;
                } else {
                    length = this.length();
                    data = this;
                }
                byte[] tmp = new byte[length];
                data.getMemory().copy(data.pointerAddress, tmp, 0, length);
                return tmp;
            }
            case 15: 
            case 95: 
            case 260: 
            case 261: {
                Variable child = this.firstChild;
                if (child != null) {
                    int length = child.toInt();
                    Variable data = child.nextSibling;
                    byte[] result = data.toByteArray();
                    if (length < 0) {
                        length = 0;
                    }
                    if (length < result.length) {
                        byte[] modified = new byte[length];
                        System.arraycopy(result, 0, modified, 0, length);
                        return modified;
                    }
                    if (length > result.length) {
                        byte[] modified = new byte[length];
                        System.arraycopy(result, 0, modified, 0, result.length);
                        return modified;
                    }
                    return result;
                }
                return this.toByteArray();
            }
            case 384: {
                return String.format("0000-00-00 %02d:%02d:%02d", this.firstChild.toInt(), this.firstChild.nextSibling.toInt(), this.firstChild.nextSibling.nextSibling.toInt());
            }
            case 385: {
                return String.format("%04d-%02d-%02d 00:00:00", this.firstChild.toInt(), this.firstChild.nextSibling.toInt(), this.firstChild.nextSibling.nextSibling.toInt());
            }
            case 386: {
                Variable yr = this.firstChild;
                Variable mo = yr.nextSibling;
                Variable da = mo.nextSibling;
                Variable hr = da.nextSibling;
                Variable mn = hr.nextSibling;
                Variable sc = mn.nextSibling;
                Variable fr = sc.nextSibling;
                return String.format("%04d-%02d-%02d %02d:%02d:%02d.%d", yr.toInt(), mo.toInt(), da.toInt(), hr.toInt(), mn.toInt(), sc.toInt(), fr.toInt());
            }
            case 387: {
                Variable yr = this.firstChild;
                Variable mo = yr.nextSibling;
                Variable da = mo.nextSibling;
                Variable hr = da.nextSibling;
                Variable mn = hr.nextSibling;
                Variable sc = mn.nextSibling;
                Variable fr = sc.nextSibling;
                Variable zh = fr.nextSibling;
                Variable zm = zh.nextSibling;
                return String.format("%04d-%02d-%02d %02d:%02d:%02d.%d+%d:%02d", yr.toInt(), mo.toInt(), da.toInt(), hr.toInt(), mn.toInt(), sc.toInt(), fr.toInt(), zh.toInt(), zm.toInt());
            }
            case 388: {
                return this.firstChild.nextSibling.nextSibling.nextSibling.toString();
            }
        }
        return this.toString();
    }

    public Object getSqlObject(Variable indicator) {
        if (indicator != null && indicator.compare(Numeric.ZERO) < 0) {
            return null;
        }
        return this.getSqlObject();
    }

    public Object getSqlObject(Variable indicator, boolean trim) {
        if (indicator != null && indicator.compare(Numeric.ZERO) < 0) {
            return null;
        }
        return this.getSqlObject(trim);
    }

    private String fromDatabase(String old) {
        if (!checkedSqlEncoding) {
            try {
                sqlEncoding = RuntimeEnvironment.getGlobalParameter("sql.encoding");
                if ("UTF-8".equalsIgnoreCase(sqlEncoding)) {
                    sqlEncoding = null;
                }
                if (sqlEncoding != null) {
                    sqlCharset = Charset.forName(sqlEncoding);
                }
            }
            catch (Exception couldNotCheckSqlEncodingParam) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch (Exception couldNotCheckSqlEncodingParam)");
                    couldNotCheckSqlEncodingParam.printStackTrace();
                }
                sqlEncoding = null;
                sqlCharset = null;
            }
            checkedSqlEncoding = true;
        }
        if (sqlCharset == null) {
            return old;
        }
        byte[] data = old.getBytes(defaultCharset);
        return new String(data, sqlCharset);
    }

    private Object toDatabase(String old) {
        if (!checkedSqlEncoding) {
            try {
                sqlEncoding = RuntimeEnvironment.getGlobalParameter("sql.encoding");
                if ("UTF-8".equalsIgnoreCase(sqlEncoding)) {
                    sqlEncoding = null;
                }
                if (sqlEncoding != null) {
                    sqlCharset = Charset.forName(sqlEncoding);
                }
            }
            catch (Exception couldNotCheckSqlEncodingParam) {
                if (LogSetup.IS_LOGGING_INFO) {
                    LogSetup.LOGGER.info("catch (Exception couldNotCheckSqlEncodingParam)");
                    couldNotCheckSqlEncodingParam.printStackTrace();
                }
                sqlEncoding = null;
                sqlCharset = null;
            }
            checkedSqlEncoding = true;
        }
        if (sqlCharset == null) {
            return old;
        }
        return old.getBytes(sqlCharset);
    }

    public Object getSqlObject() {
        return this.getSqlObject(trimGetSqlObject);
    }

    public Object getSqlObject(boolean trim) {
        if (this.format != null) {
            return FormatDateTime.format(this.format, this.toString());
        }
        if (this.isAnyVarChar()) {
            if (this.isVarChar()) {
                Variable child = this.firstChild;
                if (child != null) {
                    int length = child.toInt();
                    Variable data = child.nextSibling;
                    if (trim) {
                        if (this.isContainingInternational()) {
                            return Variable.rightTrim(data.toText().substring(0, length));
                        }
                        return this.toDatabase(Variable.rightTrim(data.toString().substring(0, length)));
                    }
                    if (this.isContainingInternational()) {
                        return data.toText().substring(0, length);
                    }
                    return this.toDatabase(data.toString().substring(0, length));
                }
            } else {
                Variable child = this.firstChild;
                if (child != null && (child = child.nextSibling) != null) {
                    int length = child.toInt();
                    Variable data = child.nextSibling;
                    if (trim) {
                        if (this.isContainingInternational()) {
                            return Variable.rightTrim(data.toText().substring(0, length));
                        }
                        return this.toDatabase(Variable.rightTrim(data.toString().substring(0, length)));
                    }
                    if (this.isContainingInternational()) {
                        return data.toText().substring(0, length);
                    }
                    return this.toDatabase(data.toString().substring(0, length));
                }
            }
        } else {
            if (trim) {
                if (this.isContainingInternational()) {
                    return Variable.rightTrim(this.toText());
                }
                return this.toDatabase(Variable.rightTrim(this.toString()));
            }
            if (this.isContainingInternational()) {
                return this.toText();
            }
            return this.toDatabase(this.toString());
        }
        return null;
    }

    public static final String rightTrim(String value) {
        int length;
        if (value == null) {
            return null;
        }
        for (length = value.length(); length > 0 && value.charAt(length - 1) == ' '; --length) {
        }
        return value.substring(0, length);
    }

    public static final String rightTrim1(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        if (length == 1) {
            return value;
        }
        while (length > 1 && value.charAt(length - 1) == ' ') {
            --length;
        }
        return value.substring(0, length);
    }

    protected int canStore(String stringValue) {
        int length;
        if (stringValue.length() < this.length()) {
            return 0;
        }
        for (length = stringValue.length() - 1; length >= 0 && stringValue.charAt(length) == ' '; --length) {
        }
        return ++length <= this.length() ? 1 : 2;
    }

    public boolean isNullIndicator() {
        return this.compare(Numeric.ZERO) < 0;
    }

    public int setSqlTrimObject(Object value) throws SQLException {
        return this.setSqlTrimObject(0, value, null, false, false);
    }

    public int setSqlTrimObject(Object value, Variable indicator) throws SQLException {
        return this.setSqlTrimObject(0, value, indicator, false, false);
    }

    public int setSqlTrimObject(Object value, Variable indicator, boolean discoverRightTruncation) throws SQLException {
        return this.setSqlTrimObject(0, value, indicator, discoverRightTruncation, false);
    }

    public int setSqlTrimObject(Object value, Variable indicator, boolean discoverRightTruncation, boolean oracle) throws SQLException {
        return this.setSqlTrimObject(0, value, indicator, discoverRightTruncation, false);
    }

    public int setSqlTrimObject(int sqltype, Object value, Variable indicator, boolean discoverRightTruncation, boolean oracle) throws SQLException {
        return this.setSqlTrimObject(sqltype, value, indicator, discoverRightTruncation, oracle, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setSqlTrimObject(int sqltype, Object value, Variable indicator, boolean discoverRightTruncation, boolean oracle, String dateFormat) throws SQLException {
        if (value == null) {
            if (indicator != null) {
                indicator.move(-1);
                return 0;
            } else {
                if (!oracle) throw new SQLException("Elastic COBOL SQL: 22002.R11: Null value, no indicator", "22002");
                this.moveLowValues();
            }
            return 0;
        }
        if (value instanceof Date) {
            if (indicator != null) {
                indicator.move(0);
            }
            if (this.firstChild == null) {
                if (sqltype == 12 && dateFormat != null) {
                    if ("yyyy-mm-dd".equals(dateFormat)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        this.move(sdf.format((Date)value));
                        return 0;
                    } else if ("mm/dd/yyyy".equals(dateFormat)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                        this.move(sdf.format((Date)value));
                        return 0;
                    } else {
                        this.move((Date)value);
                    }
                    return 0;
                } else {
                    this.move((Date)value);
                }
                return 0;
            } else {
                int count = 0;
                Variable subelement = this.firstChild;
                boolean isGood = true;
                while (subelement != null) {
                    isGood = isGood && subelement.isNumericDisplay();
                    ++count;
                    subelement = subelement.nextSibling;
                }
                if (!isGood) return 16;
                Calendar valuedt = GregorianCalendar.getInstance();
                valuedt.setTime((Date)value);
                subelement = this.firstChild;
                if (count == 3) {
                    if (this.firstChild.signPosition != 0) {
                        subelement.move(valuedt.get(1));
                        subelement = subelement.nextSibling;
                        subelement.move(valuedt.get(2) + 1);
                        subelement = subelement.nextSibling;
                        subelement.move(valuedt.get(5));
                        return 0;
                    } else {
                        subelement.move(valuedt.get(11));
                        subelement = subelement.nextSibling;
                        subelement.move(valuedt.get(12));
                        subelement = subelement.nextSibling;
                        subelement.move(valuedt.get(13));
                    }
                    return 0;
                } else if (count == 7) {
                    subelement.move(valuedt.get(1));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(2) + 1);
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(5));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(11));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(12));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(13));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(14));
                    return 0;
                } else {
                    if (count != 9) return 16;
                    subelement.move(valuedt.get(1));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(2) + 1);
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(5));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(11));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(12));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(13));
                    subelement = subelement.nextSibling;
                    subelement.move(valuedt.get(14));
                    subelement = subelement.nextSibling;
                    TimeZone tz = valuedt.getTimeZone();
                    subelement.move(tz.getOffset(valuedt.getTimeInMillis()) / 60);
                    subelement = subelement.nextSibling;
                    subelement.move(tz.getOffset(valuedt.getTimeInMillis()) % 60);
                }
            }
            return 0;
        }
        if (value instanceof GregorianCalendar) {
            if (indicator != null) {
                indicator.move(0);
            }
            this.move((GregorianCalendar)value);
            return 0;
        }
        if (oracle && value instanceof ROWID) {
            if (indicator != null) {
                indicator.move(0);
            }
            this.move(((ROWID)value).stringValue());
            return 0;
        }
        if (value instanceof byte[]) {
            Variable length;
            byte[] byteValue = (byte[])value;
            if (sqltype != 263 && memoryCharset != null) {
                String tmp = sqlCharset != null ? new String(byteValue, sqlCharset) : new String(byteValue, defaultCharset);
                byteValue = tmp.getBytes(memoryCharset);
            }
            if (indicator != null) {
                indicator.move(byteValue.length);
            }
            if (this.firstChild != null && this.firstChild.nextSibling != null && this.firstChild.nextSibling.nextSibling == null) {
                length = this.firstChild;
                Variable data = this.firstChild.nextSibling;
                length.move(byteValue.length);
                data.move(byteValue);
                return 0;
            } else if (this.firstChild != null && this.firstChild.nextSibling != null && this.firstChild.nextSibling.nextSibling != null && this.firstChild.nextSibling.nextSibling.nextSibling == null) {
                length = this.firstChild.nextSibling;
                Variable data = this.firstChild.nextSibling.nextSibling;
                length.move(byteValue.length);
                data.move(byteValue);
                return 0;
            } else if (this.firstChild != null) {
                this.move(byteValue);
                return 0;
            } else {
                this.move(byteValue);
            }
            return 0;
        } else {
            String stringValue = BigDecimal.class.isInstance(value) ? ((BigDecimal)value).toPlainString() : value.toString();
            if (stringValue == null) {
                if (indicator != null) {
                    indicator.move(0);
                }
                this.initData();
                return 0;
            }
            if (indicator != null) {
                indicator.move(stringValue.length());
            }
            if (this.isAnyVarChar()) {
                if (this.isVarChar()) {
                    int length = stringValue.length();
                    Variable child = this.firstChild;
                    if (child != null) {
                        child.move(length);
                        Variable data = child.nextSibling;
                        if (data != null) {
                            data.move(stringValue);
                            return 0;
                        }
                    }
                } else {
                    int length = stringValue.length();
                    Variable child = this.firstChild;
                    if (child != null && (child = child.nextSibling) != null) {
                        child.move(length);
                        Variable data = child.nextSibling;
                        if (data != null) {
                            data.move(stringValue);
                            return 0;
                        }
                    }
                }
            }
            if (this.isContainingInternational()) {
                this.moveNational(stringValue);
            } else {
                this.move(this.fromDatabase(stringValue));
            }
            if (!discoverRightTruncation) return 0;
            return this.canStore(stringValue);
        }
    }

    public Variable setLocale(String locale) {
        return this;
    }

    public String getLocale() {
        return null;
    }

    public Variable setFormat(String format) {
        this.format = format;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public Variable move(Date date) {
        return this.move(this.format(date));
    }

    public Variable move(GregorianCalendar greg, int nanos) {
        return this.move(FormatDateTime.format(this.format, greg, nanos));
    }

    public Variable move(GregorianCalendar greg) {
        return this.move(FormatDateTime.format(this.format, greg));
    }

    public String format(Date date) {
        return FormatDateTime.format(this.format, date);
    }

    public void setXmlOff() {
        this.xmlBits = 0;
    }

    public void setXmlContent() {
        this.xmlBits |= 1;
    }

    public void setXmlContentOffset() {
        this.xmlBits |= 2;
    }

    public void setXmlContentLength() {
        this.xmlBits |= 4;
    }

    public void setXmlContentData() {
        this.xmlBits |= 8;
    }

    public void setXmlContentName() {
        this.xmlBits |= 0x10000;
    }

    public void setXmlAttribute() {
        this.xmlBits |= 0x10;
    }

    public void setXmlAttributeUri() {
        this.xmlBits |= 0x20;
    }

    public void setXmlAttributeLocal() {
        this.xmlBits |= 0x40;
    }

    public void setXmlAttributeQname() {
        this.xmlBits |= 0x80;
    }

    public void setXmlAttributeType() {
        this.xmlBits |= 0x100;
    }

    public void setXmlAttributeData() {
        this.xmlBits |= 0x200;
    }

    public void setXmlAttributeLength() {
        this.xmlBits |= 0x400;
    }

    public void setXmlAttributeName() {
        this.xmlBits |= 0x20000;
    }

    public void setXmlLocator() {
        this.xmlBits |= 0x800;
    }

    public void setXmlLocatorPublic() {
        this.xmlBits |= 0x1000;
    }

    public void setXmlLocatorSystem() {
        this.xmlBits |= 0x2000;
    }

    public void setXmlLocatorLine() {
        this.xmlBits |= 0x4000;
    }

    public void setXmlLocatorColumn() {
        this.xmlBits |= 0x8000;
    }

    public boolean isXmlTag() {
        return this.xmlBits == 0;
    }

    public boolean isXmlOff() {
        return this.xmlBits == 0;
    }

    public boolean isXml() {
        return this.xmlBits != 0;
    }

    public boolean isXmlAnyContent() {
        return (this.xmlBits & 0x1000E) != 0;
    }

    public boolean isXmlContent() {
        return (this.xmlBits & 1) == 1;
    }

    public boolean isXmlContentOffset() {
        return (this.xmlBits & 2) == 2;
    }

    public boolean isXmlContentLength() {
        return (this.xmlBits & 4) == 4;
    }

    public boolean isXmlContentData() {
        return (this.xmlBits & 8) == 8;
    }

    public boolean isXmlContentName() {
        return (this.xmlBits & 0x10000) == 65536;
    }

    public boolean isXmlAnyAttribute() {
        return (this.xmlBits & 0x207E0) != 0;
    }

    public boolean isXmlAttribute() {
        return (this.xmlBits & 0x10) == 16;
    }

    public boolean isXmlAttributeUri() {
        return (this.xmlBits & 0x20) == 32;
    }

    public boolean isXmlAttributeLocal() {
        return (this.xmlBits & 0x40) == 64;
    }

    public boolean isXmlAttributeQname() {
        return (this.xmlBits & 0x80) == 128;
    }

    public boolean isXmlAttributeType() {
        return (this.xmlBits & 0x100) == 256;
    }

    public boolean isXmlAttributeData() {
        return (this.xmlBits & 0x200) == 512;
    }

    public boolean isXmlAttributeLength() {
        return (this.xmlBits & 0x400) == 1024;
    }

    public boolean isXmlAttributeName() {
        return (this.xmlBits & 0x20000) == 131072;
    }

    public boolean isXmlAnyLocator() {
        return (this.xmlBits & 0xF000) != 0;
    }

    public boolean isXmlLocator() {
        return (this.xmlBits & 0x800) == 2048;
    }

    public boolean isXmlLocatorPublic() {
        return (this.xmlBits & 0x1000) == 4096;
    }

    public boolean isXmlLocatorSystem() {
        return (this.xmlBits & 0x2000) == 8192;
    }

    public boolean isXmlLocatorLine() {
        return (this.xmlBits & 0x4000) == 16384;
    }

    public boolean isXmlLocatorColumn() {
        return (this.xmlBits & 0x8000) == 32768;
    }

    public void setXml(int value) {
        this.xmlBits = value;
    }

    public int getXml() {
        return this.xmlBits;
    }

    public boolean isVariableList() {
        return false;
    }

    public boolean isNumericDisplay() {
        return (this.flagBits & 0x4000000) == 0x4000000;
    }

    public boolean isDefinedNumeric() {
        return this.isTypeNumeric();
    }

    public static void reconfig() {
        block28: {
            block27: {
                String caching = RuntimeEnvironment.getGlobalParameter("CACHE");
                if ("ENABLED".equalsIgnoreCase(caching)) {
                    Cache.enableCaching();
                } else if ("DISABLED".equalsIgnoreCase(caching)) {
                    Cache.disableCaching();
                } else if ("FORBID".equalsIgnoreCase(caching)) {
                    Cache.forbidCaching();
                }
                try {
                    block26: {
                        internationalEncoding = RuntimeEnvironment.getGlobalParameter("ie");
                        if (internationalEncoding == null) {
                            internationalEncoding = RuntimeEnvironment.getGlobalParameter("encodenational");
                        }
                        if (internationalEncoding != null && internationalEncoding.length() > 0 && internationalEncoding.charAt(0) == '!') {
                            internationalEncodingUseHigh = true;
                            try {
                                internationalEncoding = internationalEncoding.substring(1);
                            }
                            catch (Exception substringException) {
                                if (!LogSetup.IS_LOGGING_INFO) break block26;
                                LogSetup.LOGGER.config("toString(): Exception substringException occurred.");
                                substringException.printStackTrace();
                            }
                        }
                    }
                    if (packedSignEncoding == null) {
                        Variable.setPackedSignEncoding(RuntimeEnvironment.getGlobalParameter("NUMPROC"));
                    }
                }
                catch (Exception determineEncoding) {
                    if (!LogSetup.IS_LOGGING_INFO) break block27;
                    LogSetup.LOGGER.info("catch (Exception determineEncoding)");
                    determineEncoding.printStackTrace();
                }
            }
            try {
                String encoding = RuntimeEnvironment.getGlobalParameter("be");
                byteEncoding = encoding != null ? encoding : null;
            }
            catch (Exception determineEncoding) {
                if (!LogSetup.IS_LOGGING_INFO) break block28;
                LogSetup.LOGGER.info("catch (Exception determineEncoding)");
                determineEncoding.printStackTrace();
            }
        }
        String numberToAlphanumericMove = RuntimeEnvironment.getGlobalParameter("numtoan");
        if (numberToAlphanumericMove != null && numberToAlphanumericMove.length() >= 2) {
            numToAlphaIsZeroFilledRightJustified = "zr".equalsIgnoreCase(numberToAlphanumericMove);
        }
        if (DataType == null) {
            DataType = RuntimeEnvironment.getGlobalParameter("DT");
        }
        if ("3".equals(DataType)) {
            String IBMEncoding = RuntimeEnvironment.getGlobalParameter("ibm.encoding");
            if (IBMEncoding == null) {
                byteEncoding = "Cp1047";
            } else if (byteEncoding == null) {
                byteEncoding = IBMEncoding;
            }
            SPACE_BYTE = (byte)64;
            SPACE_INT = 64;
            SPACE_CHAR = (char)SPACE_BYTE;
            ZERO_CHAR = (char)240;
        }
        if (byteEncoding != null) {
            try {
                memoryCharset = Charset.forName(byteEncoding);
            }
            catch (IllegalCharsetNameException e) {
                byteEncoding = null;
                memoryCharset = null;
            }
        }
        String Trunc = RuntimeEnvironment.getGlobalParameter("TRUNC");
        if ("5".equals(DataType) || "BINARY".equalsIgnoreCase(Trunc) || "BIN".equalsIgnoreCase(Trunc)) {
            Variable.setRoundOverflow();
        } else if ("1".equals(DataType) || "3".equals(DataType) || "STD".equalsIgnoreCase(Trunc)) {
            Variable.setTruncateStandard();
        }
        ODOMoveLenCheck = !"5".equals(DataType) && !"1".equals(DataType) && !"3".equals(DataType);
        String bufferOverrun = RuntimeEnvironment.getGlobalParameter("BUFFER-OVERRUN");
        BufferOverrunCheck = ZEROES_STRING.equals(bufferOverrun) || "strict".equalsIgnoreCase(bufferOverrun) || "n".equalsIgnoreCase(bufferOverrun) || "no".equalsIgnoreCase(bufferOverrun) || "false".equalsIgnoreCase(bufferOverrun) || "off".equalsIgnoreCase(bufferOverrun) ? BufferOverrunSettings.STRICT : (bufferOverrun == null || "relax".equalsIgnoreCase(bufferOverrun) || "relaxed".equalsIgnoreCase(bufferOverrun) || "1".equals(bufferOverrun) || "y".equalsIgnoreCase(bufferOverrun) || "yes".equalsIgnoreCase(bufferOverrun) || "true".equalsIgnoreCase(bufferOverrun) || "on".equalsIgnoreCase(bufferOverrun) ? BufferOverrunSettings.RELAXED : ("extreme".equalsIgnoreCase(bufferOverrun) ? BufferOverrunSettings.EXTREME : BufferOverrunSettings.STRICT));
        numericValdityChecking = RuntimeEnvironment.isGlobalParameter("CHECKNUM");
        SPECIAL_CHAR_HIGH_LOW_VALUES = RuntimeEnvironment.isGlobalParameter("CHARHIGHLOW", true);
        DataPointer.SIZE_POINTER = RuntimeEnvironment.getArchitecture() == 32 ? 4 : 8;
        String NULL_POINTER_DEREFERENCE_STRING = RuntimeEnvironment.getGlobalParameter("NULL-POINTER-DEREFERENCE");
        DataPointer.NULL_POINTER_DEREFERENCE = NULL_POINTER_DEREFERENCE_STRING != null && ("yes".equalsIgnoreCase(NULL_POINTER_DEREFERENCE_STRING) || "true".equalsIgnoreCase(NULL_POINTER_DEREFERENCE_STRING) || "1".equals(NULL_POINTER_DEREFERENCE_STRING));
        ConvertNumericsToInt = RuntimeEnvironment.isGlobalParameter("CONVERT-NUMERIC", true);
    }

    public static void setRoundOverflow() {
        RoundOverflow = true;
        TruncateDecimal = false;
    }

    public static void setTruncateStandard() {
        RoundOverflow = false;
        TruncateDecimal = true;
    }

    public static void setTruncateOpt() {
        RoundOverflow = false;
        TruncateDecimal = false;
    }

    public static void completeSPInitialization() {
        initSPComplete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeInitialization() {
        if (initializationComplete) {
            return;
        }
        Class<Variable> clazz = Variable.class;
        synchronized (Variable.class) {
            String licenseCheckResult;
            if (initializationComplete) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (!initSPComplete && (licenseCheckResult = HCILicensing.LicenseCheck("hpaas-cbl-rts", 1, false)).compareTo(DEFAULT_NAME) != 0) {
                throw new RuntimeException(licenseCheckResult);
            }
            ZEROES.move(ZEROES_STRING);
            SPACES.move(SPACES_STRING);
            HIGH_VALUES.move("9");
            LOW_VALUES.move("-9");
            QUOTES.move(QUOTES_STRING);
            AQUOTES.move(AQUOTES_STRING);
            ZEROES.zeroes();
            SPACES.spaces();
            HIGH_VALUES.high_values();
            LOW_VALUES.low_values();
            QUOTES.quotes();
            AQUOTES.aquotes();
            Variable.reconfig();
            initializationComplete = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void redoInitialization() {
        initializationComplete = false;
        SPACE_BYTE = (byte)32;
        SPACE_INT = 32;
        SPACE_CHAR = (char)SPACE_BYTE;
        ZERO_CHAR = (char)48;
        memoryCharset = null;
        byteEncoding = null;
        Variable.completeInitialization();
    }

    @Override
    public int getLength() {
        return this.length();
    }

    @Override
    public int getSize() {
        return this.lengthMX();
    }

    public int getMinimumSize() {
        if (this.maxItemSize > 0) {
            if (this.itemSize < this.maxItemSize) {
                return this.itemSize;
            }
            return this.maxItemSize;
        }
        return this.length();
    }

    @Override
    public int getDecimalPositions() {
        return this.place;
    }

    @Override
    public void toByteArray(byte[] param, int offset, int length) {
        this.flushToMemory();
        if (length > this.length()) {
            length = this.length();
        }
        this.pointerMemory.copy(this.pointerAddress, param, offset, length);
    }

    @Override
    public void fromByteArray(byte[] param, int offset, int length) {
        this.prepareMemoryForWrite();
        this.pointerMemory.copy(param, offset, this.pointerAddress, length);
    }

    public void moveIndexedValue(String dim, String val) {
        String[] index = dim.split(",");
        int[] idx = new int[index.length];
        Object[] objArray = this.createArray();
        for (int i = 0; i < index.length; ++i) {
            idx[i] = Integer.parseInt(index[i]);
        }
        switch (index.length) {
            case 1: {
                if (this.isNumericInstance()) {
                    Numeric[] arr = (Numeric[])objArray;
                    arr[idx[0]].move(val);
                    break;
                }
                Variable[] arr = (Variable[])objArray;
                arr[idx[0]].move(val);
                break;
            }
            case 2: {
                if (this.isNumericInstance()) {
                    Numeric[][] arr = (Numeric[][])objArray;
                    arr[idx[0]][idx[1]].move(val);
                    break;
                }
                Variable[][] arr = (Variable[][])objArray;
                arr[idx[0]][idx[1]].move(val);
                break;
            }
            case 3: {
                if (this.isNumericInstance()) {
                    Numeric[][][] arr = (Numeric[][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]].move(val);
                    break;
                }
                Variable[][][] arr = (Variable[][][])objArray;
                arr[idx[0]][idx[1]][idx[2]].move(val);
                break;
            }
            case 4: {
                if (this.isNumericInstance()) {
                    Numeric[][][][] arr = (Numeric[][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]].move(val);
                    break;
                }
                Variable[][][][] arr = (Variable[][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]].move(val);
                break;
            }
            case 5: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][] arr = (Numeric[][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]].move(val);
                    break;
                }
                Variable[][][][][] arr = (Variable[][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]].move(val);
                break;
            }
            case 6: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][][] arr = (Numeric[][][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]].move(val);
                    break;
                }
                Variable[][][][][][] arr = (Variable[][][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]].move(val);
                break;
            }
            case 7: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][][][] arr = (Numeric[][][][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]].move(val);
                    break;
                }
                Variable[][][][][][][] arr = (Variable[][][][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]].move(val);
                break;
            }
            case 8: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][][][][] arr = (Numeric[][][][][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]][idx[7]].move(val);
                    break;
                }
                Variable[][][][][][][][] arr = (Variable[][][][][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]][idx[7]].move(val);
                break;
            }
        }
    }

    public Variable idx(int idx1) {
        return this.idx(String.valueOf(idx1));
    }

    public Variable idx(int idx1, int idx2) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2));
    }

    public Variable idx(int idx1, int idx2, int idx3) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2) + "," + String.valueOf(idx3));
    }

    public Variable idx(int idx1, int idx2, int idx3, int idx4) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2) + "," + String.valueOf(idx3) + "," + String.valueOf(idx4));
    }

    public Variable idx(int idx1, int idx2, int idx3, int idx4, int idx5) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2) + "," + String.valueOf(idx3) + "," + String.valueOf(idx4) + "," + String.valueOf(idx5));
    }

    public Variable idx(int idx1, int idx2, int idx3, int idx4, int idx5, int idx6) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2) + "," + String.valueOf(idx3) + "," + String.valueOf(idx4) + "," + String.valueOf(idx5) + "," + String.valueOf(idx6));
    }

    public Variable idx(int idx1, int idx2, int idx3, int idx4, int idx5, int idx6, int idx7) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2) + "," + String.valueOf(idx3) + "," + String.valueOf(idx4) + String.valueOf(idx5) + "," + String.valueOf(idx6) + "," + String.valueOf(idx7));
    }

    public Variable idx(int idx1, int idx2, int idx3, int idx4, int idx5, int idx6, int idx7, int idx8) {
        return this.idx(String.valueOf(idx1) + "," + String.valueOf(idx2) + "," + String.valueOf(idx3) + "," + String.valueOf(idx4) + String.valueOf(idx5) + "," + String.valueOf(idx6) + "," + String.valueOf(idx7) + "," + String.valueOf(idx8));
    }

    public Variable idx(String dim) {
        String[] index = dim.split(",");
        int[] idx = new int[index.length];
        Object[] objArray = this.createArray();
        for (int i = 0; i < index.length; ++i) {
            idx[i] = Integer.parseInt(index[i]);
        }
        if (objArray.length == 2 && objArray[1] instanceof VariableSubscript) {
            Variable v = ((VariableSubscript)objArray[1]).get(idx);
            v.idxString = idx;
            return v;
        }
        switch (index.length) {
            case 1: {
                if (this.isNumericInstance()) {
                    Numeric[] arr = (Numeric[])objArray;
                    arr[idx[0]].idxString = idx;
                    return arr[idx[0]];
                }
                Variable[] arr = (Variable[])objArray;
                arr[idx[0]].idxString = idx;
                return arr[idx[0]];
            }
            case 2: {
                if (this.isNumericInstance()) {
                    Numeric[][] arr = (Numeric[][])objArray;
                    arr[idx[0]][idx[1]].idxString = idx;
                    return arr[idx[0]][idx[1]];
                }
                Variable[][] arr = (Variable[][])objArray;
                arr[idx[0]][idx[1]].idxString = idx;
                return arr[idx[0]][idx[1]];
            }
            case 3: {
                if (this.isNumericInstance()) {
                    Numeric[][][] arr = (Numeric[][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]].idxString = idx;
                    return arr[idx[0]][idx[1]][idx[2]];
                }
                Variable[][][] arr = (Variable[][][])objArray;
                arr[idx[0]][idx[1]][idx[2]].idxString = idx;
                return arr[idx[0]][idx[1]][idx[2]];
            }
            case 4: {
                if (this.isNumericInstance()) {
                    Numeric[][][][] arr = (Numeric[][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]].idxString = idx;
                    return arr[idx[0]][idx[1]][idx[2]][idx[3]];
                }
                Variable[][][][] arr = (Variable[][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]].idxString = idx;
                return arr[idx[0]][idx[1]][idx[2]][idx[3]];
            }
            case 5: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][] arr = (Numeric[][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]].idxString = idx;
                    return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]];
                }
                Variable[][][][][] arr = (Variable[][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]].idxString = idx;
                return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]];
            }
            case 6: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][][] arr = (Numeric[][][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]].idxString = idx;
                    return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]];
                }
                Variable[][][][][][] arr = (Variable[][][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]].idxString = idx;
                return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]];
            }
            case 7: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][][][] arr = (Numeric[][][][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]].idxString = idx;
                    return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]];
                }
                Variable[][][][][][][] arr = (Variable[][][][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]].idxString = idx;
                return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]];
            }
            case 8: {
                if (this.isNumericInstance()) {
                    Numeric[][][][][][][][] arr = (Numeric[][][][][][][][])objArray;
                    arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]][idx[7]].idxString = idx;
                    return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]][idx[7]];
                }
                Variable[][][][][][][][] arr = (Variable[][][][][][][][])objArray;
                arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]][idx[7]].idxString = idx;
                return arr[idx[0]][idx[1]][idx[2]][idx[3]][idx[4]][idx[5]][idx[6]][idx[7]];
            }
        }
        return null;
    }

    public String getIndexedValue(String dim) {
        return this.idx(dim).toText();
    }

    public String toXml() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(this);
        return this.generateXml(l);
    }

    private String generateXml(List<Variable> fromIdentifier) {
        StringBuffer sb = new StringBuffer();
        Iterator<Variable> iterator = fromIdentifier.iterator();
        while (iterator.hasNext()) {
            Variable o1;
            Variable v1 = o1 = iterator.next();
            Variable dv = v1.dependingOnVariable;
            if (dv != null && v1.subscript > dv.toInt()) continue;
            String tag = v1.getName();
            sb.append("<" + tag + ">");
            if (v1.isElementary()) {
                if (v1 instanceof Numeric) {
                    sb.append(v1.toNumericValueString().replaceFirst("(?<=\\D*)0+(?=\\d+)", DEFAULT_NAME));
                } else {
                    String val = v1.toValueString().trim();
                    sb.append(val.isEmpty() ? SPACES_STRING : val);
                }
            } else {
                sb.append(this.generateXml(v1.getChildrenWithArrayElementsAsItems()));
            }
            sb.append("</" + tag + ">");
        }
        return sb.toString();
    }

    @Override
    public String toText() {
        return this.toDisplayString();
    }

    @Override
    public void fromText(String text) {
        this.moveNational(text);
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toNumericString());
    }

    @Override
    public IDatatype toDatatype() {
        return this;
    }

    @Override
    public void fromBoolean(boolean param) {
        this.move(param);
    }

    @Override
    public void fromByte(byte param) {
        this.move(param);
    }

    @Override
    public void fromChar(char param) {
        this.move(param);
    }

    @Override
    public void fromShort(short param) {
        this.move(param);
    }

    @Override
    public void fromInt(int param) {
        this.move(param);
    }

    @Override
    public void fromLong(long param) {
        this.move(param);
    }

    @Override
    public void fromFloat(float param) {
        this.move(param);
    }

    @Override
    public void fromDouble(double param) {
        this.move(param);
    }

    @Override
    public void fromBigDecimal(BigDecimal param) {
        this.move(param.toString());
    }

    @Override
    public void fromDatatype(IDatatype param) {
        if (param == null) {
            this.init();
        } else if (param instanceof Variable) {
            if (param instanceof Numeric) {
                this.move((Numeric)param);
            } else {
                this.move((Variable)param);
            }
        } else {
            this.move(param.toString());
        }
    }

    @Override
    public void fromDataPointer(byte[] param) {
        this.pointerMemory = new UnbufferedMemory(param);
        this.pointerAddress = 0;
        this.itemSize = param.length;
    }

    private Object[] checkArray() {
        Variable check = this;
        while (check != null) {
            if (check.isArray()) {
                return check.createArray();
            }
            check = check.parent;
        }
        return null;
    }

    @Override
    public Object[] getElements() {
        if (this.arrayChild != null) {
            return this.arrayChild;
        }
        Object[] check = this.checkArray();
        if (check != null) {
            return check;
        }
        if (this.firstChild == null) {
            return null;
        }
        int counter = this.getChildrenCount();
        Object[] result = new IDatatype[counter];
        Variable child = this.firstChild;
        counter = 0;
        while (child != null) {
            result[counter] = child;
            ++counter;
            child = child.nextSibling;
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.flushToMemory();
        out.writeInt(this.itemSize);
        out.writeByte(this.signPosition);
        out.writeByte(this.place);
        out.writeByte(this.scale);
        out.writeInt(this.minIndex);
        out.writeInt(this.maxIndex);
        out.writeObject(this.name);
        out.writeInt(this.indicator);
        out.writeByte(this.specialType);
        out.writeObject(this.picArray);
        out.writeInt(this.eventHandler);
        out.writeBoolean(this.sizeErrorCondition);
        out.writeInt(this.flagBits);
        out.writeInt(this.xmlBits);
        out.writeObject(this.initValue);
        out.writeObject(this.format);
        byte[] data = this.toByteArray();
        out.writeObject(data);
        Variable writeChildren = this.firstChild;
        while (writeChildren != null) {
            out.writeObject(writeChildren);
            out.writeInt(writeChildren.pointerAddress - this.pointerAddress);
            writeChildren = writeChildren.nextSibling;
        }
        out.writeObject(null);
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.firstIntervalPage = null;
        this.notify = null;
        this.notifyDelayed = false;
        this.arrayChild = null;
        this.handle = null;
        this.guiObject = null;
        this.fromVariable = null;
        this.toVariable = null;
        this.screenProperty = null;
        this.parent = null;
        this.dependingOnVariable = null;
        this.redefinedFrom = null;
        this.redefinedTo = null;
        this.alwaysFlush = true;
        this.numericString = null;
        this.valid = false;
        this.dirty = false;
        this.right_array = null;
        this.left_array = null;
        this.nextSibling = null;
        this.firstChild = null;
        this.surrogate = null;
        this.itemSize = in.readInt();
        this.pointerMemory = new Memory(this.itemSize, new String[0]);
        this.pointerAddress = 0;
        this.signPosition = in.readByte();
        this.place = in.readByte();
        this.scale = in.readByte();
        this.minIndex = in.readInt();
        this.maxIndex = in.readInt();
        this.name = (String)in.readObject();
        this.indicator = in.readInt();
        this.specialType = in.readByte();
        this.picArray = (char[])in.readObject();
        this.eventHandler = in.readInt();
        this.sizeErrorCondition = in.readBoolean();
        this.flagBits = in.readInt();
        this.xmlBits = in.readInt();
        this.initValue = (String)in.readObject();
        this.format = (String)in.readObject();
        byte[] dataArray = (byte[])in.readObject();
        if (dataArray != null) {
            this.fromByteArray(dataArray);
        }
        Variable readChildren = (Variable)in.readObject();
        int offsetFromMyAddress = in.readInt();
        if (readChildren != null) {
            readChildren.pointerMemory = this.pointerMemory;
            readChildren.pointerAddress = this.pointerAddress + offsetFromMyAddress;
        }
        this.firstChild = readChildren;
        while (readChildren != null) {
            readChildren = readChildren.nextSibling = (Variable)in.readObject();
            offsetFromMyAddress = in.readInt();
            if (readChildren == null) continue;
            readChildren.pointerMemory = this.pointerMemory;
            readChildren.pointerAddress = this.pointerAddress + offsetFromMyAddress;
        }
    }

    public boolean toBoolean(int offset) {
        return false;
    }

    public boolean toBoolean(int offset, int length) {
        return false;
    }

    public void setAlwaysFlush(boolean alwaysFlush) {
        this.alwaysFlush = alwaysFlush;
    }

    public void addConditionals(Level88 lvl) {
        if (this.level88s == null) {
            this.level88s = new ArrayList();
        }
        this.level88s.add(lvl);
    }

    public boolean isConditional() {
        return this.level88s != null;
    }

    public Object[] getConditionals() {
        return this.level88s.toArray();
    }

    public void setConditionalStatusByName(String name, boolean status) {
        if (this.isConditional()) {
            for (Level88 level88 : this.level88s) {
                if (!level88.getName().equalsIgnoreCase(name)) continue;
                level88.setStatus(status);
            }
        }
    }

    public static void setBoundsCheck(boolean mode) {
        boundsCheck = mode;
    }

    public static void setBufferOverrun(String value) {
        if ("extreme".equalsIgnoreCase(value)) {
            BufferOverrunCheck = BufferOverrunSettings.EXTREME;
        } else if ("strict".equalsIgnoreCase(value)) {
            BufferOverrunCheck = BufferOverrunSettings.STRICT;
        } else if ("relaxed".equalsIgnoreCase(value)) {
            BufferOverrunCheck = BufferOverrunSettings.RELAXED;
        }
    }

    public Variable get(Variable[] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0];
    }

    public Variable get(Variable[][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0];
    }

    public Variable get(Variable[][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0];
    }

    public Variable get(Variable[][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0];
    }

    public Variable get(Variable[][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0];
    }

    public Variable get(Variable[][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0];
    }

    public Variable get(Variable[][][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]][idxArray[6]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0][0];
    }

    public Variable get(Variable[][][][][][][][] array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array[idxArray[0]][idxArray[1]][idxArray[2]][idxArray[3]][idxArray[4]][idxArray[5]][idxArray[6]][idxArray[7]];
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return array[0][0][0][0][0][0][0][0];
    }

    public Variable get(VariableSubscript array, int[] idxArray) {
        if (this.checkBounds(idxArray)) {
            return array.get(idxArray);
        }
        this.handleBoundsError(Arrays.toString(idxArray));
        return ArrayIndexOutOfBoundsVariable.garbage;
    }

    public void handleBoundsError(String idxArray) {
        StackTraceElement stack = new Throwable().getStackTrace()[2];
        String errmsg = "Index out of bounds, lower bounds = " + this.lowerBounds + ", upper bounds = " + this.upperBounds + ", index = " + idxArray + "\n";
        errmsg = errmsg + "COBOL error at line " + stack.getLineNumber() + " in method " + stack.getMethodName() + " of source: " + stack.getFileName() + "\n\n";
        if (boundsCheck) {
            CobolException.runtimeError(errmsg);
            throw new StopRun("Index Out of Bounds");
        }
        if (ArrayIndexOutOfBoundsVariable.mode == 1 && LogSetup.IS_LOGGING_INFO) {
            LogSetup.LOGGER.info(errmsg);
        }
    }

    public boolean checkBounds(int[] idxArray) {
        boolean result = true;
        this.upperBounds = DEFAULT_NAME;
        this.lowerBounds = DEFAULT_NAME;
        if (this.maxDim == null) {
            int dim = this.dimensions();
            this.maxDim = new int[dim];
            this.minDim = new int[dim];
            this.dependsVars = new Variable[dim];
            for (int i = 0; i < dim; ++i) {
                this.upperBound(i, dim - i);
                this.minDim[i] = this.lowerBound(dim - i);
            }
        }
        for (int i = 0; i < idxArray.length; ++i) {
            if (idxArray[i] >= this.minDim[i] && idxArray[i] <= (this.dependsVars[i] != null ? this.dependsVars[i].toInt() : this.maxDim[i])) continue;
            for (int j = 0; j <= i; ++j) {
                int imax = this.dependsVars[i] != null ? this.dependsVars[i].toInt() : this.maxDim[i];
                this.upperBounds = this.upperBounds + "[" + String.valueOf(imax) + "]";
                this.lowerBounds = this.lowerBounds + "[" + String.valueOf(this.minDim[i]) + "]";
            }
            result = false;
        }
        return result;
    }

    public static void finalizeInternalArray() {
        if (_currContext == null) {
            return;
        }
        if (Cache.forbid) {
            return;
        }
        Map<Object, Object> intArrTbl = _currContext.getlnkArrayTable();
        for (Map.Entry<Object, Object> entry : intArrTbl.entrySet()) {
            Object arr = entry.getKey();
            if (arr instanceof Variable[][][][][][][][]) {
                Variable.finalizeArray8((Variable[][][][][][][][])arr);
                continue;
            }
            if (arr instanceof Variable[][][][][][][]) {
                Variable.finalizeArray7((Variable[][][][][][][])arr);
                continue;
            }
            if (arr instanceof Variable[][][][][][]) {
                Variable.finalizeArray6((Variable[][][][][][])arr);
                continue;
            }
            if (arr instanceof Variable[][][][][]) {
                Variable.finalizeArray5((Variable[][][][][])arr);
                continue;
            }
            if (arr instanceof Variable[][][][]) {
                Variable.finalizeArray4((Variable[][][][])arr);
                continue;
            }
            if (arr instanceof Variable[][][]) {
                Variable.finalizeArray3((Variable[][][])arr);
                continue;
            }
            if (arr instanceof Variable[][]) {
                Variable.finalizeArray2((Variable[][])arr);
                continue;
            }
            if (!(arr instanceof Variable[])) continue;
            Variable.finalizeArray1((Variable[])arr);
        }
    }

    public static void initializeInternalArray() {
        if (_currContext == null) {
            return;
        }
        if (Cache.forbid) {
            return;
        }
        Map<Object, Object> intArrTbl = _currContext.getlnkArrayTable();
        for (Map.Entry<Object, Object> entry : intArrTbl.entrySet()) {
            Object child = entry.getKey();
            Object parent = entry.getValue();
            if (parent instanceof DataPointer) {
                if (child instanceof DataPointer[][][][][][][][]) {
                    child = ((DataPointer)parent).createArray8((DataPointer[][][][][][][][])child);
                    continue;
                }
                if (child instanceof DataPointer[][][][][][][]) {
                    child = ((DataPointer)parent).createArray7((DataPointer[][][][][][][])child);
                    continue;
                }
                if (child instanceof DataPointer[][][][][][]) {
                    child = ((DataPointer)parent).createArray6((DataPointer[][][][][][])child);
                    continue;
                }
                if (child instanceof DataPointer[][][][][]) {
                    child = ((DataPointer)parent).createArray5((DataPointer[][][][][])child);
                    continue;
                }
                if (child instanceof DataPointer[][][][]) {
                    child = ((DataPointer)parent).createArray4((DataPointer[][][][])child);
                    continue;
                }
                if (child instanceof DataPointer[][][]) {
                    child = ((DataPointer)parent).createArray3((DataPointer[][][])child);
                    continue;
                }
                if (child instanceof DataPointer[][]) {
                    child = ((DataPointer)parent).createArray2((DataPointer[][])child);
                    continue;
                }
                if (!(child instanceof DataPointer[])) continue;
                child = ((DataPointer)parent).createArray1((DataPointer[])child);
                continue;
            }
            if (parent instanceof Numeric) {
                if (child instanceof Numeric[][][][][][][][]) {
                    child = ((Numeric)parent).createArray8((Numeric[][][][][][][][])child);
                    continue;
                }
                if (child instanceof Numeric[][][][][][][]) {
                    child = ((Numeric)parent).createArray7((Numeric[][][][][][][])child);
                    continue;
                }
                if (child instanceof Numeric[][][][][][]) {
                    child = ((Numeric)parent).createArray6((Numeric[][][][][][])child);
                    continue;
                }
                if (child instanceof Numeric[][][][][]) {
                    child = ((Numeric)parent).createArray5((Numeric[][][][][])child);
                    continue;
                }
                if (child instanceof Numeric[][][][]) {
                    child = ((Numeric)parent).createArray4((Numeric[][][][])child);
                    continue;
                }
                if (child instanceof Numeric[][][]) {
                    child = ((Numeric)parent).createArray3((Numeric[][][])child);
                    continue;
                }
                if (child instanceof Numeric[][]) {
                    child = ((Numeric)parent).createArray2((Numeric[][])child);
                    continue;
                }
                if (!(child instanceof Numeric[])) continue;
                child = ((Numeric)parent).createArray1((Numeric[])child);
                continue;
            }
            if (child instanceof Variable[][][][][][][][]) {
                child = ((Variable)parent).createArray8((Variable[][][][][][][][])child);
                continue;
            }
            if (child instanceof Variable[][][][][][][]) {
                child = ((Variable)parent).createArray7((Variable[][][][][][][])child);
                continue;
            }
            if (child instanceof Variable[][][][][][]) {
                child = ((Variable)parent).createArray6((Variable[][][][][][])child);
                continue;
            }
            if (child instanceof Variable[][][][][]) {
                child = ((Variable)parent).createArray5((Variable[][][][][])child);
                continue;
            }
            if (child instanceof Variable[][][][]) {
                child = ((Variable)parent).createArray4((Variable[][][][])child);
                continue;
            }
            if (child instanceof Variable[][][]) {
                child = ((Variable)parent).createArray3((Variable[][][])child);
                continue;
            }
            if (child instanceof Variable[][]) {
                child = ((Variable)parent).createArray2((Variable[][])child);
                continue;
            }
            if (!(child instanceof Variable[])) continue;
            Variable[] variableArray = ((Variable)parent).createArray1((Variable[])child);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public final void setDirtyFlag(boolean val) {
        this.dirty = val;
    }

    public final void setValid(boolean val) {
        this.valid = val;
    }

    public long getModifyOnce() {
        return this.modifyOnce;
    }

    public void setModifyOnce(long modifyOnce) {
        this.modifyOnce = modifyOnce;
    }

    public void setSubscriptChild(VariableSubscript subscriptChild) {
        this.arrayChild = new VariableSubscript[]{null, subscriptChild};
    }

    public static boolean isDataTypeMF() {
        return DataType.equals("5");
    }

    public boolean isNotRefmodVar() {
        return !this.isrefmod;
    }

    static {
        defaultCharset = Charset.forName("iso-8859-1");
        memoryCharset = null;
        sqlCharset = null;
        numToAlphaIsZeroFilledRightJustified = false;
        boundsCheck = false;
        BufferOverrunCheck = BufferOverrunSettings.STRICT;
        ODOMoveLenCheck = true;
        DataType = null;
        RoundOverflow = false;
        TruncateDecimal = false;
        ConvertNumericsToInt = true;
        ModifyOnce = 1000000L;
        Variable.checkTrimGetSqlObject();
        ZERO = ZEROES = Display.createZeroDisplay();
        ZEROS = ZEROES;
        SPACE = SPACES = new Variable("SPACES", "X", "%");
        HIGH_VALUE = HIGH_VALUES = new Variable("HIGH-VALUES", "9", "3");
        LOW_VALUE = LOW_VALUES = new Variable("LOW-VALUES", "S9", "-7");
        QUOTE = QUOTES = new Variable("QUOTES", "X", "i");
        AQUOTE = AQUOTES = new Variable("QUOTES", "X", "j");
        HIGH_VALUES_STRING = new String(new char[]{Memory.HIGH});
        LOW_VALUES_STRING = new String(new char[]{'\u0000'});
        initAlphanumeric = null;
        initAlphabetic = null;
        initNumeric = null;
        initAlphanumericEdited = null;
        initNumericEdited = null;
        initNational = null;
        initNationalEdited = null;
        sub = false;
        String encoding = RuntimeEnvironment.getGlobalParameter("be");
        if (encoding != null) {
            byteEncoding = encoding;
        }
        initSPComplete = false;
    }

    private static enum BufferOverrunSettings {
        STRICT,
        RELAXED,
        EXTREME;

    }

    public static enum PackedSignEncoding {
        NOPFD,
        PFD,
        MIG,
        NCR,
        BULL;

    }
}

