/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.Configuration;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.ResourceLoader;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class XAEnvironment {
    private static Context ctx;
    private static ResourceLoader rloader;
    private static BitronixTransactionManager btm;

    public static void init() {
    }

    public static Context initExternal(String configFileName, String serverName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "bitronix.tm.jndi.BitronixInitialContextFactory");
        Configuration conf = TransactionManagerServices.getConfiguration();
        conf.setServerId(serverName != null ? serverName : "XAServer" + LocalTime.now());
        conf.setDisableJmx(true);
        conf.setResourceConfigurationFilename(configFileName);
        rloader = TransactionManagerServices.getResourceLoader();
        int failedToLoadCnt = rloader.init();
        if (failedToLoadCnt > 0) {
            System.err.println("failed to load " + failedToLoadCnt + " resources");
        }
        ctx = new InitialContext(env);
        btm = TransactionManagerServices.getTransactionManager();
        return ctx;
    }

    public static void closeXADataSources() {
        Map rmap = rloader.getResources();
        for (Object obj : rmap.values()) {
            if (!(obj instanceof PoolingDataSource)) continue;
            ((PoolingDataSource)obj).close();
        }
    }

    public static Map<String, Object> getConnections() throws SQLException {
        HashMap<String, Object> connectionMap = new HashMap<String, Object>();
        Map rmap = rloader.getResources();
        for (Map.Entry entry : rmap.entrySet()) {
            Object objVal = entry.getValue();
            Object objKey = entry.getKey();
            if (!(objVal instanceof PoolingDataSource) || !(objKey instanceof String)) continue;
            Connection conn = ((PoolingDataSource)objVal).getConnection();
            connectionMap.put((String)objKey, conn);
        }
        return connectionMap;
    }

    public static Connection getConnection(String name) throws SQLException {
        Object obj = null;
        try {
            obj = ctx.lookup(name);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        if (obj instanceof PoolingDataSource) {
            return ((PoolingDataSource)obj).getConnection();
        }
        return null;
    }

    public static void begin() throws NotSupportedException, SystemException {
        btm.begin();
    }

    public static void commit() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, NotSupportedException {
        btm.commit();
        btm.begin();
    }

    public static void rollback() throws IllegalStateException, SecurityException, SystemException, NotSupportedException {
        btm.rollback();
        btm.begin();
    }

    public static void shutdown() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (btm.getCurrentTransaction() != null) {
            btm.commit();
        }
        btm.shutdown();
    }

    public static boolean isTransactionManaged() {
        return btm != null;
    }
}

