/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.KeyStroke;
import com.heirloomcomputing.ecs.exec.KeyStrokeAction;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ScreenProperty;
import com.heirloomcomputing.ecs.exec.TermComponent;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.smartFile;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XOpenScreen
extends IO
implements ActionListener {
    public static final boolean debugMode = false;
    private int defaultFG = 2;
    private int defaultBG = 0;
    private boolean hasGUI = true;
    private String title = null;
    private boolean gosyserr = false;
    private boolean gosysout = false;
    private long timeout = -1L;
    private static final float EPSILON = 0.01f;
    private final Object defaultTreeLockObject = new Object();
    private float cury = 0.0f;
    private float curx = 0.0f;
    private Variable variableToDisplay = null;
    private Vector<inputField> inputFields = null;
    private boolean foundField = false;
    private boolean terminatorPressed = false;
    private static final boolean debug_accept = false;
    private boolean mouseClickTimeout = false;
    private int curActiveIndex = -1;
    private Vector<Variable> acceptSubscripts = null;
    private static boolean htmlTemplatePrefixInit = false;
    private static Vector<String> htmlTemplatePrefix = new Vector();

    public static void debug(String text) {
        System.out.println("XOpenScreen: " + text);
    }

    public static void output(String text) {
        System.out.println(text);
    }

    public XOpenScreen() {
        this(true, false, false, null);
    }

    public XOpenScreen(boolean hasGUI) {
        this(hasGUI, false, false, null);
    }

    public XOpenScreen(boolean hasGUI, boolean gosyserr) {
        this(hasGUI, gosyserr, false, null);
    }

    public XOpenScreen(boolean hasGUI, String title) {
        this(hasGUI, false, false, title);
    }

    public XOpenScreen(boolean hasGUI, boolean gosyserr, boolean gosysout) {
        this(hasGUI, gosyserr, gosysout, null);
    }

    public XOpenScreen(boolean hasGUI, boolean gosyserr, String title) {
        this(hasGUI, gosyserr, false, null);
    }

    public XOpenScreen(boolean hasGUI, boolean gosyserr, boolean gosysout, String title) {
        this.hasGUI = hasGUI;
        this.gosyserr = gosyserr;
        this.gosysout = gosysout;
        this.title = title;
    }

    private final boolean isZero(float value) {
        return value > -0.01f && value < 0.01f;
    }

    private final Object getTreeLockObjectForTerm(ScreenHandler term) {
        Container c;
        if (term != null && (c = term.getPanelForWindow()) != null) {
            return ((Component)c).getTreeLock();
        }
        return this.defaultTreeLockObject;
    }

    private boolean updateTermForDisplay(float line, float column, ScreenProperty p) {
        if (line > 0.0f && column < 0.0f) {
            column = 1.0f;
        }
        ScreenHandler Term = this.getScreenHandler();
        if (this.isZero(column)) {
            column = Term.getCursorX() + 1;
        }
        if (this.isZero(line)) {
            line = Term.getCursorY() + 1;
        }
        line = line <= 0.0f ? -1.0f : (line -= 1.0f);
        column = column <= 0.0f ? -1.0f : (column -= 1.0f);
        int fg = -1;
        int bg = -1;
        if (p != null) {
            if (line < 0.0f) {
                line = 0.0f;
            }
            if (column < 0.0f) {
                column = 0.0f;
            }
            Term.setScrollable(false);
            Term.clearAttributes();
            fg = p.getForegroundColor();
            bg = p.getBackgroundColor();
            if ((fg < 0 || fg >= 16) && (fg = Term.getDefaultFG()) < 0) {
                fg = this.defaultFG;
            }
            if ((bg < 0 || bg >= 16) && (bg = Term.getDefaultBG()) < 0) {
                bg = this.defaultBG;
            }
            Term.setAttributes(p.getProperties(), fg, bg);
            if (p.isBlankScreen()) {
                boolean changed = false;
                this.defaultFG = -1;
                this.defaultBG = -1;
                if (fg >= 0 && fg < 16) {
                    this.defaultFG = fg;
                    changed = true;
                }
                if (bg >= 0 && bg < 16) {
                    this.defaultBG = bg;
                    changed = true;
                }
                if (changed) {
                    Term.setDefaultColors(this.defaultFG, this.defaultBG);
                }
                Term.clearScreen();
            }
            float cy = line;
            float cx = column;
            float tx = p.getColumn();
            try {
                if (p.isColumnInPixels()) {
                    tx /= (float)Term.getCellWidth();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            float ty = p.getLine();
            try {
                if (p.isLineInPixels()) {
                    ty /= (float)Term.getCellHeight();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tx >= 0.0f && p.isColumnRelative()) {
                if (p.isColumnRelativeMinus()) {
                    if (tx <= -1.0f) {
                        tx += 1.0f;
                    }
                    cx -= tx;
                } else {
                    if (tx >= 1.0f) {
                        tx -= 1.0f;
                    }
                    cx += tx;
                }
            } else {
                if (ty >= 0.0f && tx < 0.0f) {
                    tx = 1.0f;
                }
                if (tx >= 1.0f) {
                    tx -= 1.0f;
                }
                if (tx >= 0.0f) {
                    cx = column + tx;
                }
            }
            if (ty >= 0.0f && p.isLineRelative()) {
                cy = p.isLineRelativeMinus() ? (cy -= ty) : (cy += ty);
            } else {
                if (ty >= 1.0f) {
                    ty -= 1.0f;
                }
                if (ty >= 0.0f) {
                    cy = line + ty;
                }
            }
            Term.move((int)cy, (int)cx);
            if (p.isBell()) {
                Term.beep();
            }
            if (p.isBlankLine()) {
                Term.move((int)cy, 0);
                Term.clrtoeol();
                Term.move((int)cy, (int)cx);
            }
            if (p.isEraseEOL()) {
                Term.clrtoeol();
            }
            if (p.isEraseEOS()) {
                Term.clrtobot();
            }
            this.cury = cy;
            this.curx = cx;
        } else {
            Term.setScrollable(true);
            if (column >= 0.0f && line >= 0.0f && !Term.move((int)line, (int)column)) {
                return false;
            }
            this.cury = line;
            this.curx = column;
        }
        return true;
    }

    public char getSecureChar() {
        String temp = RuntimeEnvironment.getGlobalParameter("SECURE-CHAR");
        if (temp == null || temp.length() != 1) {
            return '*';
        }
        return temp.charAt(0);
    }

    @Override
    public synchronized boolean display(String text, float line, float column, boolean advance, ScreenProperty p) {
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return false;
        }
        text = this.filter(text);
        if (p != null) {
            if (!this.isZero(line) || column >= 0.0f) {
                advance = false;
            } else {
                column = 0.0f;
            }
            if (!this.updateTermForDisplay(line, column, p)) {
                return false;
            }
            if (p.isSize()) {
                int size = p.getSize();
                if (size > 0 && size < text.length()) {
                    text = text.substring(0, size);
                } else if (size > 0 && size < 256) {
                    while (text.length() < size) {
                        text = text + "                                        ";
                    }
                    if (text.length() > size) {
                        text = text.substring(0, size);
                    }
                }
            }
            if (p.isSecure()) {
                int endx;
                for (endx = text.length() - 1; endx >= 0 && text.charAt(endx) == ' '; --endx) {
                }
                StringBuffer myText = new StringBuffer(text);
                char secureChar = this.getSecureChar();
                for (int i = 0; i <= endx; ++i) {
                    myText.setCharAt(i, secureChar);
                }
                text = myText.toString();
            }
        } else if (!this.updateTermForDisplay(line, column, p)) {
            return false;
        }
        if (advance ? !Term.println(text) : !Term.print(text)) {
            return false;
        }
        Term.refresh();
        return true;
    }

    @Override
    public synchronized boolean display(Variable v, float line, float column, boolean advance) {
        return this.display(v, line, column, advance, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean display(Variable v, float line, float column, boolean advance, int occursIndex1, int occursIndex2) {
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return false;
        }
        if (v.isExternalForm() && v.isIdentified()) {
            return this.displayExternalForm(v, line, column, advance);
        }
        ScreenProperty p = XOpenScreen.getProperty(v);
        int arrayLength = v.occurs();
        if (arrayLength > 1) {
            if (occursIndex1 <= 1 || occursIndex2 > 1) {
                occursIndex1 = occursIndex2;
            }
            for (int i = 1; i <= arrayLength; ++i) {
                Variable curV = v.subscript(i);
                if (curV == null) {
                    return false;
                }
                curV.setScreenProperty(p);
                curV.setScreen(v.isScreen());
                if (!this.display(curV, line, column, advance, occursIndex1, i)) {
                    curV.releaseSubscript();
                    return false;
                }
                curV.releaseSubscript();
            }
            return true;
        }
        if (line > 0.0f && column < 0.0f) {
            column = 1.0f;
        }
        if (this.isZero(column)) {
            column = Term.getCursorX() + 1;
        }
        if (this.isZero(line)) {
            line = Term.getCursorY() + 1;
        }
        line = line <= 0.0f ? -1.0f : (line -= 1.0f);
        column = column <= 0.0f ? -1.0f : (column -= 1.0f);
        if (XOpenScreen.isScreen(v)) {
            if (this.isGraphical() ? v.isPruneToCharacter() : v.isPruneToGraphics()) {
                return true;
            }
            boolean found = false;
            this.variableToDisplay = v;
            for (Variable parent = v.getParent(); parent != null; parent = parent.getParent()) {
                v = parent;
            }
            if (v == this.variableToDisplay) {
                found = true;
            } else if (!XOpenScreen.isScreen(v)) {
                found = true;
                v = this.variableToDisplay;
            }
            if (line < 0.0f) {
                line = 0.0f;
            }
            if (column < 0.0f) {
                column = 0.0f;
            }
            Object treeLockObject = this.getTreeLockObjectForTerm(Term);
            boolean returnCode = false;
            Object object = treeLockObject;
            synchronized (object) {
                Term.setScrollable(false);
                Term.clearAttributes();
                int fg = -1;
                int bg = -1;
                if (p != null) {
                    fg = p.getForegroundColor();
                    bg = p.getBackgroundColor();
                    if ((fg < 0 || fg >= 16) && (fg = Term.getDefaultFG()) < 0) {
                        fg = this.defaultFG;
                    }
                    if ((bg < 0 || bg >= 16) && (bg = Term.getDefaultBG()) < 0) {
                        bg = this.defaultBG;
                    }
                    Term.setAttributes(p.getProperties(), fg, bg);
                    this.searchForBlankScreen(v, fg, bg, 0, found);
                }
                returnCode = this.display(v, line, column, advance, new fvalue(line), new fvalue(column), false, 0, fg, bg, null, found, occursIndex1, occursIndex2);
            }
            this.variableToDisplay = null;
            if (returnCode) {
                Term.refresh();
                try {
                    Handle h = this.getIOHandle();
                    if (h != null) {
                        h.getComponent().repaint();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
        Handle h = v.getHandle();
        if (h != null) {
            return this.display(h, line, column, advance, null);
        }
        return this.display(v.toNationalString(), line, column, advance);
    }

    private boolean searchForBlankScreen(Variable v, int Fore, int Back, int attr, boolean found) {
        Variable child;
        if (v == null) {
            return false;
        }
        ScreenHandler Term = this.getScreenHandler();
        ScreenProperty p = XOpenScreen.getProperty(v);
        if (p != null) {
            int fg = p.getForegroundColor();
            int bg = p.getBackgroundColor();
            if (fg >= 0 && fg < 16) {
                Fore = fg;
            }
            if (bg >= 0 && bg < 16) {
                Back = bg;
            }
            if (found && p.isBlankScreen()) {
                attr = attr & 0x51003C80 | p.getProperties();
                Term.setAttributes(attr, Fore, Back);
                boolean changed = false;
                this.defaultFG = -1;
                this.defaultBG = -1;
                if (Fore >= 0 && Fore < 16) {
                    this.defaultFG = Fore;
                    changed = true;
                }
                if (Back >= 0 && Back < 16) {
                    this.defaultBG = Back;
                    changed = true;
                }
                if (changed) {
                    Term.setDefaultColors(this.defaultFG, this.defaultBG);
                }
                Term.clearScreen();
                return true;
            }
        }
        if ((child = v.getChild()) != null) {
            while (child != null) {
                boolean isFound = found;
                if (!isFound && child == this.variableToDisplay) {
                    isFound = true;
                }
                if (this.searchForBlankScreen(child, Fore, Back, attr, isFound)) {
                    return true;
                }
                child = child.getSibling();
            }
        }
        return false;
    }

    private boolean display(Variable v, float line, float column, boolean advance, fvalue cy, fvalue cx, boolean secure, int attr, int fg2, int bg2, ScreenProperty parentProperty, boolean found) {
        return this.display(v, line, column, advance, cy, cx, secure, attr, fg2, bg2, parentProperty, found, 0, 0);
    }

    private boolean display(Variable v, float line, float column, boolean advance, fvalue cy, fvalue cx, boolean secure, int attr, int fg2, int bg2, ScreenProperty parentProperty, boolean found, int occursIndex1, int occursIndex2) {
        Variable child;
        ScreenHandler Term = this.getScreenHandler();
        if (v == null) {
            return false;
        }
        if (this.isGraphical() ? v.isPruneToCharacter() : v.isPruneToGraphics()) {
            return true;
        }
        ScreenProperty p = XOpenScreen.getProperty(v);
        int arrayLength = v.occurs();
        if (arrayLength > 1) {
            if (occursIndex1 <= 1 || occursIndex2 > 1) {
                occursIndex1 = occursIndex2;
            }
            for (int i = 1; i <= arrayLength; ++i) {
                Variable curV = v.subscript(i);
                if (curV == null) {
                    return false;
                }
                if (line < 1.0f) {
                    cy.value += 1.0f;
                }
                curV.setScreenProperty(p);
                if (!this.display(curV, line, column, advance, cy, cx, secure, attr, fg2, bg2, parentProperty, found, occursIndex1, i)) {
                    curV.releaseSubscript();
                    return false;
                }
                curV.releaseSubscript();
            }
            return true;
        }
        if (p != null) {
            if (p.isSecure()) {
                secure = true;
            }
            int fg = p.getForegroundColor();
            int bg = p.getBackgroundColor();
            if (fg >= 0 && fg <= 15) {
                fg2 = fg;
            }
            if (bg >= 0 && bg <= 15) {
                bg2 = bg;
            }
            attr = attr & 0x51003C80 | p.getProperties();
            Term.setAttributes(attr, fg2, bg2);
            float tx = p.getColumn();
            try {
                if (p.isColumnInPixels()) {
                    tx /= (float)Term.getCellWidth();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            float ty = p.getLine();
            try {
                if (p.isLineInPixels()) {
                    ty /= (float)Term.getCellHeight();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tx >= 0.0f && p.isColumnRelative()) {
                if (p.isColumnRelativeMinus()) {
                    if (tx <= -1.0f) {
                        tx += 1.0f;
                    }
                    cx.value -= tx;
                } else {
                    if (tx >= 1.0f) {
                        tx -= 1.0f;
                    }
                    cx.value += tx;
                }
            } else {
                if (ty >= 0.0f && tx < 0.0f) {
                    tx = 1.0f;
                }
                if (tx >= 1.0f) {
                    tx -= 1.0f;
                }
                if (tx >= 0.0f) {
                    cx.value = column + tx;
                }
            }
            if (ty >= 0.0f && p.isLineRelative()) {
                cy.value = p.isLineRelativeMinus() ? (cy.value -= ty) : (cy.value += ty);
            } else {
                if (ty >= 1.0f) {
                    ty -= 1.0f;
                }
                if (ty >= 0.0f) {
                    cy.value = line + ty;
                }
            }
            Term.move((int)cy.value, (int)cx.value);
            if (p.isBell()) {
                Term.beep();
            }
            if (p.isBlankLine()) {
                Term.move((int)cy.value, 0);
                Term.clrtoeol();
                Term.move((int)cy.value, (int)cx.value);
            }
            if (p.isEraseEOL()) {
                Term.clrtoeol();
            }
            if (p.isEraseEOS()) {
                Term.clrtobot();
            }
        }
        if ((child = v.getChild()) != null && p != null) {
            while (child != null) {
                boolean isFound = found;
                if (!isFound && child == this.variableToDisplay) {
                    isFound = true;
                }
                this.display(child, line, column, false, cy, cx, secure, attr, fg2, bg2, p, isFound, occursIndex1, occursIndex2);
                child = child.getSibling();
            }
        } else {
            Variable from;
            if (found && (from = this.getFromVariable(v)) != null) {
                if (occursIndex2 > 0) {
                    from = occursIndex1 > 0 ? from.subscript(occursIndex1, occursIndex2) : from.subscript(occursIndex2);
                }
                if (from.isNumericInstance()) {
                    v.move((Numeric)from);
                } else {
                    v.move(from);
                }
                if (occursIndex2 > 0) {
                    from.releaseSubscript();
                }
            }
            boolean returnCode = false;
            Handle h = v.getHandle();
            if (h != null) {
                TermComponent t;
                returnCode = found ? this.display(h, cy.value, cx.value, false, p) : true;
                if (!h.isSpecialDisplay() && (t = h.getTermComponent()) != null) {
                    double columnsOccupied = t.getColumnsCells();
                    if (columnsOccupied <= 0.0) {
                        columnsOccupied = 1.0;
                    }
                    cx.value = (float)((double)cx.value + columnsOccupied);
                }
            } else {
                int len = v.lengthNational();
                String text = null;
                if (p != null) {
                    if (p.isSize()) {
                        len = p.getSize();
                        text = v.toNationalString(len);
                    }
                } else if (parentProperty != null && parentProperty.isSize()) {
                    len = parentProperty.getSize();
                    text = v.toNationalString(len);
                }
                if (text == null) {
                    text = v.toNationalString();
                }
                if (secure) {
                    int endx;
                    for (endx = text.length() - 1; endx >= 0 && text.charAt(endx) == ' '; --endx) {
                    }
                    StringBuffer myText = new StringBuffer(text);
                    char secureChar = this.getSecureChar();
                    for (int i = 0; i <= endx; ++i) {
                        myText.setCharAt(i, secureChar);
                    }
                    text = myText.toString();
                }
                if (found) {
                    if (this.getToVariable(v) != null) {
                        Term.setAttributes(attr | 0x20000000, -1, -1);
                    }
                    returnCode = Term.print(text);
                } else {
                    returnCode = true;
                }
                cx.value += (float)len;
            }
            return returnCode;
        }
        return true;
    }

    @Override
    public synchronized boolean acceptOmitted(long timeout) {
        Handle myHandle;
        this.timeout = timeout;
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return false;
        }
        Term.setScrollable(false);
        XOpenScreen.setCRTStatusKey(0, 48, 0);
        if (this.isGraphical() && (myHandle = this.getIOHandle()) != null) {
            KeyEvent evt;
            AcceptEvent acceptEvent;
            while ((acceptEvent = myHandle.accept(timeout)) == null || (!acceptEvent.isEvent() || acceptEvent.getValue() != 3) && (!acceptEvent.isTerminating() || acceptEvent.isKey() && !XOpenScreen.isKeyTerminatesAccept(evt = (KeyEvent)acceptEvent.getEventObject()))) {
            }
            if (acceptEvent == null) {
                return XOpenScreen.updateStatus(new AcceptEvent(null, 3));
            }
            return XOpenScreen.updateStatus(acceptEvent);
        }
        KeyValue[] terminators = XOpenScreen.getTerminators();
        Term.waitForTerminatorKey(terminators);
        KeyValue myTerminator = Term.getTerminator();
        return XOpenScreen.updateStatus(myTerminator);
    }

    @Override
    public synchronized boolean accept(Variable v, float line, float column, long timeout) {
        ScreenHandler Term;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable=" + v.toDebugString() + ".");
        }
        if ((Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout)) == null) {
            return false;
        }
        this.timeout = timeout;
        if (line > 0.0f && column <= 0.0f) {
            column = 1.0f;
        }
        line = line <= 0.0f ? -1.0f : (line -= 1.0f);
        column = column <= 0.0f ? -1.0f : (column -= 1.0f);
        if (v != null && v.isExternalForm()) {
            return this.acceptExternalForm(v, line, column);
        }
        boolean isScreen = XOpenScreen.isScreen(v);
        Handle h = v.getHandle();
        boolean handleWithNoScreenSection = false;
        if (!isScreen && h != null) {
            IO.setProperty(v, new ScreenProperty());
            handleWithNoScreenSection = true;
            isScreen = true;
        }
        if (isScreen) {
            Variable child;
            if (this.isGraphical()) {
                if (v.isPruneToCharacter()) {
                    if (handleWithNoScreenSection) {
                        IO.removeScreen(v);
                    }
                    return true;
                }
            } else if (v.isPruneToGraphics()) {
                if (handleWithNoScreenSection) {
                    IO.removeScreen(v);
                }
                return true;
            }
            boolean update = true;
            ScreenProperty p = XOpenScreen.getProperty(v);
            if (p != null && p.isNoUpdate()) {
                update = false;
            }
            if (v.getHandle() == null && this.getToVariable(v) == null && (child = v.getChild()) != null && v.getSibling() == null && v.getParent() == null && !XOpenScreen.isScreen(child)) {
                if (line < 0.0f) {
                    line = Term.getCursorY();
                }
                if (column < 0.0f) {
                    column = Term.getCursorX();
                }
                if (this.getToVariable(child) == null && this.getFromVariable(child) == null) {
                    IO.using(child, child, child);
                }
            }
            if (line < 0.0f) {
                line = 0.0f;
            }
            if (column < 0.0f) {
                column = 0.0f;
            }
            int cx = Term.getCursorX();
            int cy = Term.getCursorY();
            Term.clearAttributes();
            Term.setScrollable(false);
            this.inputFields = new Vector();
            this.foundField = false;
            this.terminatorPressed = false;
            char pchar = ' ';
            if (update) {
                pchar = '_';
            }
            String defaultString = null;
            boolean found = false;
            this.variableToDisplay = v;
            for (Variable parent = v.getParent(); parent != null; parent = parent.getParent()) {
                v = parent;
            }
            if (v == this.variableToDisplay) {
                found = true;
            } else if (!XOpenScreen.isScreen(v)) {
                found = true;
                v = this.variableToDisplay;
            }
            this.setupAccept(v, line, column, new fvalue(line), new fvalue(column), false, false, false, false, 0, -1, -1, pchar, defaultString, null, found);
            this.variableToDisplay = null;
            Term.clearAttributes();
            XOpenScreen.setCRTStatusKey(0, 48, 0);
            this.addMouseListenerToTermPanel();
            boolean result = false;
            try {
                result = this.accept(update);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.releaseSubscripts();
            this.removeMouseListenerFromTermPanel();
            this.removeHandleListeners();
            this.inputFields.removeAllElements();
            this.inputFields = null;
            Term.move(cy, cx);
            if (!result) {
                if (!this.foundField) {
                    if (IO.getWaitForTerminatorKey()) {
                        KeyValue[] terminators = XOpenScreen.getTerminators();
                        Term.waitForTerminatorKey(terminators);
                        KeyValue myTerminator = Term.getTerminator();
                        result = XOpenScreen.updateStatus(myTerminator);
                    }
                    XOpenScreen.setCRTStatusKey(9, 0, 0);
                    if (handleWithNoScreenSection) {
                        IO.removeScreen(v);
                    }
                    return false;
                }
            } else if (!this.terminatorPressed) {
                XOpenScreen.setCRTStatusKey(0, 49, 9);
                if (handleWithNoScreenSection) {
                    IO.removeScreen(v);
                }
                return true;
            }
            if (handleWithNoScreenSection) {
                IO.removeScreen(v);
            }
            return result;
        }
        String TOString = null;
        try {
            TOString = Term.getString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (TOString != null) {
            if (TOString.length() > v.itemSize) {
                v.moveNational(TOString.substring(0, v.itemSize));
            } else {
                v.moveNational(TOString);
            }
        }
        return true;
    }

    private void removeHandleListeners() {
        if (this.inputFields == null) {
            return;
        }
        for (int i = 0; i < this.inputFields.size(); ++i) {
            inputField f = this.inputFields.elementAt(i);
            Handle h = f.getHandle();
            if (h == null || !h.isAcceptable()) continue;
            h.removeListeners();
        }
    }

    private boolean isMouseClickCausedTimeout() {
        return this.mouseClickTimeout;
    }

    private void setMouseClickCausedTimeout(boolean flag) {
        this.mouseClickTimeout = false;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int mouseClickY;
        int mouseClickX;
        if (evt == null) {
            return;
        }
        ScreenHandler Term = this.getScreenHandlerIfPresent();
        if (Term == null) {
            return;
        }
        if (this.curActiveIndex < 0) {
            return;
        }
        int cellWidth = Term.getCellWidth();
        if (cellWidth <= 0) {
            return;
        }
        int cellHeight = Term.getCellHeight();
        if (cellHeight <= 0) {
            return;
        }
        String text = evt.getActionCommand();
        if (text == null || !text.startsWith("MOUSE_RELEASED")) {
            return;
        }
        if (text.length() <= 15) {
            return;
        }
        int index = (text = text.substring(15)).indexOf(44);
        if (index < 0) {
            return;
        }
        if (index + 1 >= text.length()) {
            return;
        }
        String xText = text.substring(0, index).trim();
        String yText = text.substring(index + 1).trim();
        try {
            mouseClickX = Integer.valueOf(xText);
        }
        catch (Exception e) {
            return;
        }
        try {
            mouseClickY = Integer.valueOf(yText);
        }
        catch (Exception e) {
            return;
        }
        this.mouseClickTimeout = false;
        for (int i = 0; i < this.inputFields.size(); ++i) {
            inputField f = this.inputFields.elementAt(i);
            f.setActiveField(false);
            if (this.mouseClickTimeout || i == this.curActiveIndex || f.getHandle() != null || !f.contains(mouseClickX, mouseClickY)) continue;
            Handle h = null;
            if (this.curActiveIndex >= 0) {
                inputField activeField = this.inputFields.elementAt(this.curActiveIndex);
                h = activeField.getHandle();
            }
            this.curActiveIndex = -1;
            f.setActiveField(true);
            this.mouseClickTimeout = true;
            if (h != null) {
                Handle.signalAccept();
                continue;
            }
            Term.forceGetStringTimeout();
        }
    }

    private void addMouseListenerToTermPanel() {
        this.mouseClickTimeout = false;
        ScreenHandler Term = this.getScreenHandler();
        if (Term != null) {
            Term.addActionListener(this);
        }
    }

    private void removeMouseListenerFromTermPanel() {
        this.mouseClickTimeout = false;
        ScreenHandler Term = this.getScreenHandlerIfPresent();
        if (Term != null) {
            Term.removeActionListener(this);
        }
    }

    @Override
    public synchronized String accept(int length, long timeout) {
        this.timeout = timeout;
        ScreenHandler Term = this.getScreenHandler();
        String rs = null;
        try {
            rs = Term.getString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rs != null && rs.length() > length) {
            return rs.substring(0, length);
        }
        return rs;
    }

    private void releaseSubscripts() {
        if (this.acceptSubscripts == null) {
            return;
        }
        int size = this.acceptSubscripts.size();
        for (int i = 0; i < size; ++i) {
            Variable v = this.acceptSubscripts.elementAt(i);
            if (v == null) continue;
            v.releaseSubscript();
        }
        this.acceptSubscripts.removeAllElements();
    }

    private boolean setupAccept(Variable v, float line, float column, fvalue cy, fvalue cx, boolean secure, boolean auto, boolean full, boolean req, int attr, int fg2, int bg2, char promptChar, String defaultString, ScreenProperty parentProperty, boolean found) {
        return this.setupAccept(v, line, column, cy, cx, secure, auto, full, req, attr, fg2, bg2, promptChar, defaultString, parentProperty, found, 0, 0);
    }

    private boolean setupAccept(Variable v, float line, float column, fvalue cy, fvalue cx, boolean secure, boolean auto, boolean full, boolean req, int attr, int fg2, int bg2, char promptChar, String defaultString, ScreenProperty parentProperty, boolean found, int occursIndex1, int occursIndex2) {
        Variable child;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("Variable v.toDebugString2()=" + v.toDebugString2() + ".");
        }
        if (v == null) {
            return false;
        }
        ScreenHandler Term = this.getScreenHandler();
        if (this.isGraphical() ? v.isPruneToCharacter() : v.isPruneToGraphics()) {
            return true;
        }
        ScreenProperty p = XOpenScreen.getProperty(v);
        int arrayLength = v.occurs();
        if (arrayLength > 1) {
            if (occursIndex1 <= 1 || occursIndex2 > 1) {
                occursIndex1 = occursIndex2;
            }
            for (int i = 1; i <= arrayLength; ++i) {
                Variable curV = v.subscript(i);
                if (curV == null) {
                    return false;
                }
                if (line < 1.0f) {
                    cy.value += 1.0f;
                }
                curV.setScreenProperty(p);
                if (this.acceptSubscripts == null) {
                    this.acceptSubscripts = new Vector();
                }
                this.acceptSubscripts.addElement(curV);
                if (this.setupAccept(curV, line, column, cy, cx, secure, auto, full, req, attr, fg2, bg2, promptChar, defaultString, parentProperty, found, occursIndex1, i)) continue;
                return false;
            }
            return true;
        }
        if (p != null) {
            int bg;
            int fg;
            String ds;
            char prompt;
            if (p.isSecure()) {
                secure = true;
            }
            if (p.isAuto()) {
                auto = true;
            }
            if (p.isFull()) {
                full = true;
            }
            if (p.isRequired()) {
                req = true;
            }
            if ((prompt = p.getPrompt()) != promptChar && prompt != '\u0000') {
                promptChar = prompt;
            }
            if ((ds = p.getDefaultValue()) != null) {
                defaultString = ds;
            }
            if ((fg = p.getForegroundColor()) >= 0 && fg <= 15) {
                fg2 = fg;
            }
            if ((bg = p.getBackgroundColor()) >= 0 && bg <= 15) {
                bg2 = bg;
            }
            attr = attr & 0x51003C80 | p.getProperties();
            Term.setAttributes(attr, fg2, bg2);
            float tx = p.getColumn();
            try {
                if (p.isColumnInPixels()) {
                    tx /= (float)Term.getCellWidth();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            float ty = p.getLine();
            try {
                if (p.isLineInPixels()) {
                    ty /= (float)Term.getCellHeight();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tx >= 0.0f && p.isColumnRelative()) {
                if (p.isColumnRelativeMinus()) {
                    if (tx <= -1.0f) {
                        tx += 1.0f;
                    }
                    cx.value -= tx;
                } else {
                    if (tx >= 1.0f) {
                        tx -= 1.0f;
                    }
                    cx.value += tx;
                }
            } else {
                if (ty >= 0.0f && tx < 0.0f) {
                    tx = 1.0f;
                }
                if (tx >= 1.0f) {
                    tx -= 1.0f;
                }
                if (tx >= 0.0f) {
                    cx.value = column + tx;
                }
            }
            if (ty >= 0.0f && p.isLineRelative()) {
                cy.value = p.isLineRelativeMinus() ? (cy.value -= ty) : (cy.value += ty);
            } else {
                if (ty >= 1.0f) {
                    ty -= 1.0f;
                }
                if (ty >= 0.0f) {
                    cy.value = line + ty;
                }
            }
        }
        if ((child = v.getChild()) != null && p != null) {
            while (child != null) {
                boolean isFound = found;
                if (!isFound && child == this.variableToDisplay) {
                    isFound = true;
                }
                this.setupAccept(child, line, column, cy, cx, secure, auto, full, req, attr, fg2, bg2, promptChar, defaultString, p, isFound, occursIndex1, occursIndex2);
                child = child.getSibling();
            }
        } else {
            Handle h = v.getHandle();
            if (h == null) {
                Variable to = this.getToVariable(v);
                if (to != null) {
                    int myAttr = Term.getAttributes();
                    int myFG = Term.getFG();
                    int myBG = Term.getBG();
                    inputField field = new inputField(v, (int)cx.value, (int)cy.value, myAttr, myFG, myBG, secure, auto, full, req, promptChar, defaultString, occursIndex1, occursIndex2);
                    if (p != null) {
                        if (p.isSize()) {
                            field.setSize(p.getSize());
                        }
                    } else if (parentProperty != null && parentProperty.isSize()) {
                        field.setSize(parentProperty.getSize());
                    }
                    if (found) {
                        this.inputFields.addElement(field);
                    }
                    cx.value += (float)field.getSize();
                } else {
                    cx.value += (float)v.lengthNational();
                }
            } else {
                TermComponent t;
                if (found && h.isAcceptable()) {
                    int myAttr = Term.getAttributes();
                    int myFG = Term.getFG();
                    int myBG = Term.getBG();
                    h.addListeners();
                    inputField field = new inputField(v, (int)cx.value, (int)cy.value, myAttr, myFG, myBG, secure, auto, full, req, promptChar, defaultString, occursIndex1, occursIndex2);
                    this.inputFields.addElement(field);
                }
                if (!h.isSpecialDisplay() && (t = h.getTermComponent()) != null) {
                    double columnsOccupied = t.getColumnsCells();
                    if (columnsOccupied <= 0.0) {
                        columnsOccupied = 1.0;
                    }
                    cx.value = (float)((double)cx.value + columnsOccupied);
                }
            }
            float termColumns = Term.getColumns();
            if (cx.value >= termColumns) {
                cx.value = termColumns - 1.0f;
            }
            return true;
        }
        return true;
    }

    private boolean accept(boolean update) {
        int val;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finest("accept(boolean update): Hello");
        }
        if (this.inputFields.size() == 0) {
            this.foundField = false;
            return false;
        }
        ScreenHandler Term = this.getScreenHandler();
        int index = -1;
        if (controlValue != null && (val = controlValue.toInt() - 1) >= 0 && val < this.inputFields.size()) {
            index = val;
            this.foundField = true;
        }
        int sx = XOpenScreen.getCursorColumn();
        int sy = XOpenScreen.getCursorLine();
        if (sx < 0 && sy < 0) {
            sx = 0;
            sy = 0;
            index = 0;
        }
        if (sx < 0) {
            sx = 0;
        } else if (sx > 0) {
            --sx;
        }
        if (sy < 0) {
            sy = 0;
        } else if (sy > 0) {
            --sy;
        }
        inputField f = null;
        if (index < 0) {
            int closest = -1;
            int closest_i = -1;
            boolean greater = true;
            for (int i = 0; i < this.inputFields.size(); ++i) {
                f = this.inputFields.elementAt(i);
                if (f.contains(sx, sy)) {
                    this.foundField = true;
                    index = i;
                    break;
                }
                int beginx = f.cx;
                int endx = beginx + (f.getSize() - 1);
                int disty = f.cy - sy;
                int distx = endx - sx;
                if (disty >= 0) {
                    greater = false;
                }
                int dist = distx * distx + disty * disty * 512;
                if (closest < 0) {
                    closest = dist;
                    closest_i = i;
                    continue;
                }
                if (dist >= closest) continue;
                closest = dist;
                closest_i = i;
            }
            if (index < 0) {
                index = closest_i >= 0 && !greater ? closest_i : 0;
            }
        }
        int endx = 0;
        int cx = 0;
        int cy = 0;
        boolean result = false;
        Variable to = null;
        Variable from = null;
        String curString = null;
        String TOString = null;
        KeyValue[] terminators = XOpenScreen.getTerminators();
        KeyValue myTerminator = null;
        KeyValue exitKey = null;
        KeyStrokeAction action = null;
        boolean lastWasExitKeyDown = false;
        boolean lastWasATab = true;
        boolean lastWasAShiftTab = false;
        AcceptEvent acceptEvent = null;
        block26: while (true) {
            Handle h;
            block147: {
                result = false;
                if (index >= this.inputFields.size()) {
                    if (lastWasExitKeyDown) {
                        lastWasExitKeyDown = false;
                        index = 0;
                    } else {
                        int tcy = cy;
                        int tcx = Term.getCursorX();
                        if (tcy >= 0) {
                            ++tcy;
                        }
                        if (tcx >= 0) {
                            ++tcx;
                        }
                        XOpenScreen.setCursorColumn(tcx);
                        XOpenScreen.setCursorLine(tcy);
                        Term.move(cy, endx + 1);
                        result = true;
                        break;
                    }
                }
                if (index < 0) {
                    index = 0;
                }
                h = null;
                while (true) {
                    f = this.inputFields.elementAt(index);
                    h = f.getHandle();
                    if (!lastWasAShiftTab && !lastWasATab || h == null || !h.isHandleNoTab()) break block147;
                    int size = this.inputFields.size();
                    if (size <= 1) break;
                    if (lastWasATab) {
                        if (++index < size) continue;
                        index = 0;
                        continue;
                    }
                    if (--index >= 0) continue;
                    index = size - 1;
                }
                int tcy = cy;
                int tcx = Term.getCursorX();
                if (tcy >= 0) {
                    ++tcy;
                }
                if (tcx >= 0) {
                    ++tcx;
                }
                XOpenScreen.setCursorColumn(tcx);
                XOpenScreen.setCursorLine(tcy);
                Term.move(cy, endx + 1);
                result = true;
                this.foundField = true;
                return result;
            }
            lastWasATab = false;
            lastWasAShiftTab = false;
            if (h == null) {
                from = f.getFromVariable();
            }
            Term.clearAttributes();
            Term.setAttributes(f.attr, f.fg, f.bg);
            cx = f.cx;
            cy = f.cy;
            int beginx = cx;
            endx = beginx + (f.getSize() - 1);
            if (this.foundField) {
                cx = sx;
                this.foundField = false;
            }
            Term.move(cy, cx);
            boolean err = true;
            boolean lastWasHandleAccept = false;
            while (err) {
                err = false;
                while (true) {
                    int clen;
                    this.setMouseClickCausedTimeout(false);
                    if (h != null) {
                        acceptEvent = null;
                        if (h.hasBeforeProcedure()) {
                            h.beforeProcedure();
                            if (acceptControl != null) {
                                int value = acceptControl.toInt();
                                block5 : switch (value) {
                                    default: {
                                        break;
                                    }
                                    case 1: {
                                        int val2;
                                        if (controlValue == null || (val2 = controlValue.toInt() - 1) < 0 || val2 >= this.inputFields.size()) break;
                                        f = this.inputFields.elementAt(val2);
                                        index = val2;
                                        h = f.getHandle();
                                        if (h == null) {
                                            from = f.getFromVariable();
                                        }
                                        Term.clearAttributes();
                                        Term.setAttributes(f.attr, f.fg, f.bg);
                                        cx = f.cx;
                                        cy = f.cy;
                                        beginx = cx;
                                        endx = beginx + (f.getSize() - 1);
                                        Term.move(cy, cx);
                                        break;
                                    }
                                    case 4: {
                                        if (controlId == null) break;
                                        int val2 = controlId.toInt();
                                        for (int i = 0; i < this.inputFields.size(); ++i) {
                                            f = this.inputFields.elementAt(i);
                                            Handle myHandle = f.getHandle();
                                            if (myHandle == null || myHandle.getId() != val2) continue;
                                            index = i;
                                            h = myHandle;
                                            Term.clearAttributes();
                                            Term.setAttributes(f.attr, f.fg, f.bg);
                                            cx = f.cx;
                                            cy = f.cy;
                                            beginx = cx;
                                            endx = beginx + (f.getSize() - 1);
                                            Term.move(cy, cx);
                                            break block5;
                                        }
                                        break;
                                    }
                                    case 2: {
                                        acceptEvent = new AcceptEvent(h, 1, controlValue != null ? controlValue.toInt() : 13);
                                        break;
                                    }
                                    case 3: {
                                        acceptEvent = new AcceptEvent(h, 2, controlValue != null ? controlValue.toInt() : 27);
                                    }
                                }
                            }
                        }
                    }
                    if (h != null) {
                        lastWasHandleAccept = true;
                        this.curActiveIndex = index;
                        f.setActiveField(false);
                        if (controlValue != null) {
                            controlValue.move(this.curActiveIndex + 1);
                        }
                        if (acceptEvent == null) {
                            lastWasATab = false;
                            lastWasAShiftTab = false;
                            acceptEvent = h.accept(this.timeout);
                        }
                        this.curActiveIndex = -1;
                        break;
                    }
                    lastWasATab = false;
                    lastWasAShiftTab = false;
                    lastWasHandleAccept = false;
                    curString = f.getString();
                    if (curString != null && (clen = curString.length()) > 0) {
                        if (from == null) {
                            StringBuffer a = new StringBuffer();
                            a.setLength(clen);
                            curString = a.toString();
                        }
                        String tempString = curString = curString.replace('\u0000', ' ');
                        Variable myV = from;
                        if (from == null) {
                            myV = f.v;
                        }
                        if (myV.isNumericDisplay()) {
                            int i;
                            for (i = 0; i < clen && tempString.charAt(i) == '0'; ++i) {
                            }
                            if (i > 0) {
                                tempString = i < clen ? tempString.substring(i) + tempString.substring(0, i).replace('0', ' ') : tempString.replace('0', ' ');
                            }
                        }
                        curString = tempString;
                        char promptChar = f.promptChar();
                        try {
                            cx = beginx;
                            Term.move(cy, cx);
                            if (update) {
                                if (f.isSecure()) {
                                    int tempEndx;
                                    for (tempEndx = tempString.length() - 1; tempEndx >= 0 && tempString.charAt(tempEndx) == ' '; --tempEndx) {
                                    }
                                    StringBuffer myText = new StringBuffer(tempString);
                                    char secureChar = this.getSecureChar();
                                    for (int i = 0; i <= tempEndx; ++i) {
                                        myText.setCharAt(i, secureChar);
                                    }
                                    tempString = myText.toString();
                                } else {
                                    tempString = tempString.replace(' ', promptChar);
                                    String defString = f.defaultString();
                                    if (defString != null) {
                                        defString = defString.trim();
                                        tempString = (defString + tempString).substring(0, tempString.length());
                                        curString = (defString + curString).substring(0, curString.length());
                                        if ((cx += defString.length()) > endx) {
                                            cx = beginx;
                                        }
                                    }
                                }
                                Term.print(tempString);
                                Term.refresh();
                                Term.move(cy, cx);
                            }
                            this.curActiveIndex = index;
                            f.setActiveField(false);
                            if (this.isGraphical()) {
                                Handle.setAcceptObject(null);
                            }
                            if (this.timeout > 0L) {
                                Term.setGetStringTimeout(this.timeout * 10L);
                            }
                            try {
                                TOString = Term.getString(curString, f.auto, f.secure, terminators, cx - beginx, false, promptChar, null, false, null);
                            }
                            catch (Throwable defString) {
                                // empty catch block
                            }
                            this.curActiveIndex = -1;
                        }
                        catch (Exception ex) {
                            TOString = null;
                        }
                    }
                    if (TOString == null) break;
                    f.v.moveNational(TOString);
                    f.refresh();
                    if (f.full && !this.meetsFULLClause(f)) {
                        cx = endx;
                        Term.move(cy, cx);
                        Term.beep();
                        continue;
                    }
                    if (!f.req || this.meetsREQUIREDClause(f.v)) break;
                    cx = beginx;
                    Term.move(cy, cx);
                    Term.beep();
                }
                if (lastWasHandleAccept || TOString == null) continue;
                to = f.getToVariable();
                if (to != null) {
                    if (to.isInternational()) {
                        to.moveNational(TOString);
                    } else {
                        int typeNumber = to.getTypeNumber();
                        switch (typeNumber) {
                            case 0: 
                            case 1: {
                                if (!to.moveSE(TOString).isSizeError()) break;
                                Term.beep();
                                err = true;
                                break;
                            }
                            default: {
                                to.moveNational(TOString);
                            }
                        }
                    }
                    f.refresh();
                }
                int savex = Term.getCursorX();
                if (update) {
                    if (from != null && from == to) {
                        f.v.move(from);
                        f.refresh();
                        if (LogSetup.IS_LOGGING) {
                            LogSetup.LOGGER.finer("accept(boolean update): if (update): toVar=" + to.toDebugString2() + ". fromVar=" + from.toDebugString2() + ". After move to f.v, f.v=" + f.v.toDebugString2());
                        }
                    }
                    try {
                        cx = beginx;
                        Term.move(cy, cx);
                        String myString = f.getString();
                        if (f.isSecure()) {
                            int tempEndx;
                            for (tempEndx = myString.length() - 1; tempEndx >= 0 && myString.charAt(tempEndx) == ' '; --tempEndx) {
                            }
                            StringBuffer myText = new StringBuffer(myString);
                            char secureChar = this.getSecureChar();
                            for (int i = 0; i <= tempEndx; ++i) {
                                myText.setCharAt(i, secureChar);
                            }
                            myString = myText.toString();
                        }
                        Term.print(myString);
                        Term.refresh();
                    }
                    catch (Exception myString) {
                        // empty catch block
                    }
                }
                if (err) {
                    cx = beginx;
                    Term.move(cy, cx);
                    continue;
                }
                cx = savex;
                Term.move(cy, cx);
            }
            boolean timeoutHappened = false;
            try {
                if (lastWasHandleAccept && (acceptEvent == null || acceptEvent.isTimeout()) || !lastWasHandleAccept && Term.isGetStringTimeout()) {
                    if (this.isMouseClickCausedTimeout()) {
                        this.setMouseClickCausedTimeout(false);
                        int i = 0;
                        while (true) {
                            if (i >= this.inputFields.size()) continue block26;
                            f = this.inputFields.elementAt(i);
                            if (f.isActiveField()) {
                                f.setActiveField(false);
                                index = i;
                                h = f.getHandle();
                                if (h == null) {
                                    from = f.getFromVariable();
                                }
                                Term.clearAttributes();
                                Term.setAttributes(f.attr, f.fg, f.bg);
                                cx = f.cx;
                                cy = f.cy;
                                beginx = cx;
                                endx = beginx + (f.getSize() - 1);
                                Term.move(cy, cx);
                                continue block26;
                            }
                            ++i;
                        }
                    }
                    timeoutHappened = true;
                    if (!lastWasHandleAccept) {
                        Handle myHandle;
                        for (int i = 0; i < this.inputFields.size(); ++i) {
                            TermComponent t;
                            f = this.inputFields.elementAt(i);
                            Handle myHandle2 = f.getHandle();
                            if (myHandle2 == null || (t = myHandle2.getTermComponent()) == null || !t.hasFocusChild()) continue;
                            index = i;
                            h = myHandle2;
                            Term.clearAttributes();
                            Term.setAttributes(f.attr, f.fg, f.bg);
                            cx = f.cx;
                            cy = f.cy;
                            beginx = cx;
                            endx = beginx + (f.getSize() - 1);
                            Term.move(cy, cx);
                            timeoutHappened = false;
                            break;
                        }
                        if (!timeoutHappened) continue;
                        if (this.isGraphical() && (myHandle = this.getIOHandle()) != null) {
                            while ((acceptEvent = myHandle.acceptWithoutRequestingFocus(50L)) == null || acceptEvent.isEvent() && acceptEvent.getValue() == 3) {
                            }
                            lastWasHandleAccept = true;
                            timeoutHappened = false;
                        }
                    }
                }
                lastWasExitKeyDown = false;
                if (lastWasHandleAccept) {
                    Handle sourceH;
                    boolean isCommandGoto;
                    if (acceptEvent == null || !acceptEvent.isTerminating()) continue;
                    int tcy = cy;
                    int tcx = Term.getCursorX();
                    if (tcy >= 0) {
                        ++tcy;
                    }
                    if (tcx >= 0) {
                        ++tcx;
                    }
                    XOpenScreen.setCursorColumn(tcx);
                    XOpenScreen.setCursorLine(tcy);
                    Term.move(cy, endx + 1);
                    boolean moveKey = false;
                    if (acceptEvent.isKey()) {
                        try {
                            KeyEvent evt = (KeyEvent)acceptEvent.getEventObject();
                            action = KeyStroke.getKeyStrokeAction(evt);
                            if (XOpenScreen.isEditMoveToNextField(action, evt)) {
                                lastWasATab = true;
                                moveKey = true;
                                ++index;
                            } else if (XOpenScreen.isEditDown(action, evt) || XOpenScreen.isEditRight(action, evt)) {
                                moveKey = true;
                                ++index;
                                lastWasExitKeyDown = true;
                            } else {
                                lastWasAShiftTab = XOpenScreen.isEditMoveToPreviousField(action, evt);
                                if (lastWasAShiftTab || XOpenScreen.isEditUp(action, evt) || XOpenScreen.isEditLeft(action, evt)) {
                                    moveKey = true;
                                    if (--index < 0) {
                                        index = this.inputFields.size() - 1;
                                    }
                                } else if (XOpenScreen.isEditMoveToFirstField(action, evt)) {
                                    moveKey = true;
                                    index = 0;
                                } else if (XOpenScreen.isEditMoveToLastField(action, evt)) {
                                    moveKey = true;
                                    index = this.inputFields.size() - 1;
                                } else {
                                    ++index;
                                }
                            }
                            if (moveKey) {
                                exitKey = new KeyValue(evt);
                            }
                        }
                        catch (Throwable evt) {
                            // empty catch block
                        }
                    }
                    if (moveKey) {
                        XOpenScreen.setCRTStatusKey(0, 48, 0);
                        result = true;
                    } else {
                        result = XOpenScreen.updateStatus(acceptEvent);
                    }
                    int reasonForEntry = 0;
                    boolean performedProcedure = false;
                    boolean bl = isCommandGoto = acceptEvent != null && acceptEvent.isEvent() && acceptEvent.getValue() == 3;
                    if (h != null) {
                        if (isCommandGoto || !acceptEvent.isExceptionCondition() || moveKey) {
                            performedProcedure = h.hasAfterProcedure();
                            if (performedProcedure) {
                                reasonForEntry = acceptEvent.getReasonForEntry();
                                if (acceptControl != null) {
                                    acceptControl.move(reasonForEntry);
                                }
                                if (controlValue != null) {
                                    controlValue.move(index + 1);
                                }
                                if (controlHandle != null) {
                                    controlHandle.move(acceptEvent.getControlHandle());
                                }
                                if (controlId != null) {
                                    controlId.move(acceptEvent.getControlId());
                                }
                                h.afterProcedure();
                            }
                        } else {
                            performedProcedure = h.hasExceptionProcedure();
                            if (performedProcedure) {
                                reasonForEntry = acceptEvent.getReasonForEntry();
                                if (acceptControl != null) {
                                    acceptControl.move(reasonForEntry);
                                }
                                if (controlValue != null) {
                                    controlValue.move(index + 1);
                                }
                                if (controlHandle != null) {
                                    controlHandle.move(acceptEvent.getControlHandle());
                                }
                                if (controlId != null) {
                                    controlId.move(acceptEvent.getControlId());
                                }
                                h.exceptionProcedure();
                            }
                        }
                    }
                    if (isCommandGoto && (sourceH = (Handle)acceptEvent.getSource()) != null && sourceH != h) {
                        for (int i = 0; i < this.inputFields.size(); ++i) {
                            f = this.inputFields.elementAt(i);
                            Handle myHandle = f.getHandle();
                            if (myHandle != sourceH) continue;
                            index = i;
                            h = myHandle;
                            if (h == null) {
                                from = f.getFromVariable();
                            }
                            Term.clearAttributes();
                            Term.setAttributes(f.attr, f.fg, f.bg);
                            cx = f.cx;
                            cy = f.cy;
                            beginx = cx;
                            endx = beginx + (f.getSize() - 1);
                            Term.move(cy, cx);
                        }
                    }
                    if (performedProcedure) {
                        if (acceptControl != null) {
                            reasonForEntry = acceptControl.toInt();
                        }
                        switch (reasonForEntry) {
                            default: {
                                break;
                            }
                            case 1: {
                                if (controlValue == null) break;
                                int val3 = controlValue.toInt() - 1;
                                if (val3 >= 0 && val3 < this.inputFields.size()) {
                                    f = this.inputFields.elementAt(val3);
                                    index = val3;
                                    h = f.getHandle();
                                    if (h == null) {
                                        from = f.getFromVariable();
                                    }
                                    Term.clearAttributes();
                                    Term.setAttributes(f.attr, f.fg, f.bg);
                                    cx = f.cx;
                                    cy = f.cy;
                                    beginx = cx;
                                    endx = beginx + (f.getSize() - 1);
                                    Term.move(cy, cx);
                                    continue block26;
                                }
                                controlValue.move(0);
                                break;
                            }
                            case 4: {
                                if (controlId == null) break;
                                int val4 = controlId.toInt();
                                boolean found = false;
                                for (int i = 0; i < this.inputFields.size(); ++i) {
                                    f = this.inputFields.elementAt(i);
                                    Handle myHandle = f.getHandle();
                                    if (myHandle == null || myHandle.getId() != val4) continue;
                                    index = i;
                                    h = myHandle;
                                    Term.clearAttributes();
                                    Term.setAttributes(f.attr, f.fg, f.bg);
                                    cx = f.cx;
                                    cy = f.cy;
                                    beginx = cx;
                                    endx = beginx + (f.getSize() - 1);
                                    Term.move(cy, cx);
                                    break;
                                }
                                if (found) continue block26;
                                controlValue.move(0);
                                break;
                            }
                            case 2: {
                                acceptEvent = new AcceptEvent(h, 1, controlValue != null ? controlValue.toInt() : 13);
                                result = XOpenScreen.updateStatus(acceptEvent);
                                break;
                            }
                            case 3: {
                                acceptEvent = new AcceptEvent(h, 2, controlValue != null ? controlValue.toInt() : 27);
                                result = XOpenScreen.updateStatus(acceptEvent);
                            }
                        }
                    }
                    if (isCommandGoto || reasonForEntry == 1 || moveKey) continue;
                    this.terminatorPressed = true;
                    break;
                }
                myTerminator = Term.getTerminator();
                if (myTerminator != null) {
                    this.terminatorPressed = true;
                    result = XOpenScreen.updateStatus(myTerminator);
                    int tcy = cy;
                    int tcx = Term.getCursorX();
                    if (tcy >= 0) {
                        ++tcy;
                    }
                    if (tcx >= 0) {
                        ++tcx;
                    }
                    XOpenScreen.setCursorColumn(tcx);
                    XOpenScreen.setCursorLine(tcy);
                    Term.move(cy, endx + 1);
                    break;
                }
                exitKey = Term.getExitKey();
                if (exitKey == null) {
                    ++index;
                    continue;
                }
                action = KeyStroke.getKeyStrokeAction(exitKey);
                if (XOpenScreen.isEditMoveToNextField(action, exitKey)) {
                    lastWasATab = true;
                    ++index;
                    continue;
                }
                if (XOpenScreen.isEditDown(action, exitKey) || XOpenScreen.isEditRight(action, exitKey)) {
                    ++index;
                    lastWasExitKeyDown = true;
                    continue;
                }
                lastWasAShiftTab = XOpenScreen.isEditMoveToPreviousField(action, exitKey);
                if (lastWasAShiftTab || XOpenScreen.isEditUp(action, exitKey) || XOpenScreen.isEditLeft(action, exitKey)) {
                    if (--index >= 0) continue;
                    index = this.inputFields.size() - 1;
                    continue;
                }
                if (XOpenScreen.isEditMoveToFirstField(action, exitKey)) {
                    index = 0;
                    continue;
                }
                if (XOpenScreen.isEditMoveToLastField(action, exitKey)) {
                    index = this.inputFields.size() - 1;
                    continue;
                }
                ++index;
            }
            catch (Throwable t1) {
                return result;
            }
        }
        this.foundField = true;
        return result;
    }

    private boolean meetsFULLClause(inputField f) {
        Variable v = f.v;
        int t = v.getTypeNumber();
        if (t == 0 || t == 1) {
            if (v.compare(Variable.ZEROES) == 0) {
                return true;
            }
            char c1 = v.getPic(0);
            char c2 = v.toChar();
            return (c1 != '*' || c2 != '*') && (c1 != 'Z' && c1 != 'z' || c2 != ' ');
        }
        if (v.compare(Variable.SPACES) == 0) {
            return true;
        }
        String s = f.getString();
        int len = s.length();
        if (len < 1) {
            return true;
        }
        if (len == 1) {
            return s.charAt(0) != ' ';
        }
        return s.charAt(0) != ' ' && s.charAt(len - 1) != ' ';
    }

    private boolean meetsREQUIREDClause(Variable v) {
        int t = v.getTypeNumber();
        if (t == 0 || t == 1) {
            return v.compare(Variable.ZEROES) != 0;
        }
        return v.compare(Variable.SPACES) != 0;
    }

    @Override
    public IO newInstance(String title) {
        return this.newInstance(this.hasGUI, this.gosyserr, this.gosysout, title);
    }

    private IO newInstance(boolean hasGUI, boolean gosyserr, String title) {
        return new XOpenScreen(hasGUI, gosyserr, title);
    }

    private IO newInstance(boolean hasGUI, boolean gosyserr, boolean gosysout, String title) {
        return new XOpenScreen(hasGUI, gosyserr, gosysout, title);
    }

    @Override
    protected synchronized KeyValue getChar() {
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return null;
        }
        return Term.getChar();
    }

    protected synchronized boolean displayExternalForm(Variable v, float line, float column, boolean advance) {
        String filename = v.getIdentifier();
        if (filename != null) {
            try {
                filename = smartFile.convertFilename(filename);
                Hashtable<String, Variable> identifiers = new Hashtable<String, Variable>();
                boolean foundIdentifiers = false;
                FileInputStream f = null;
                if (!htmlTemplatePrefixInit) {
                    htmlTemplatePrefixInit = true;
                    String parse = RuntimeEnvironment.getGlobalParameter("HTML-TEMPLATE-PREFIX");
                    if (parse != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(parse);
                        while (stringTokenizer.hasMoreTokens()) {
                            htmlTemplatePrefix.addElement(stringTokenizer.nextToken());
                        }
                    }
                }
                int attempts = htmlTemplatePrefix.size();
                String basename = filename;
                if (filename.indexOf("://") >= 0) {
                    this.display("<html>", line, column, advance);
                    this.display("<head>", line, column, advance);
                    this.display("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">", line, column, advance);
                    this.display("<meta HTTP-EQUIV=\"refresh\" CONTENT=\"0; URL=" + filename + "\">", line, column, advance);
                    this.display("<title>" + filename + "...</title>", line, column, advance);
                    this.display("<a href=\"" + filename + "\" target=\"_top\">Click here if redirect does not occur.</a>", line, column, advance);
                    this.display("</head>", line, column, advance);
                    this.display("</body>", line, column, advance);
                    this.display("</html>", line, column, advance);
                    return false;
                }
                for (int attempt = -1; attempt < attempts && f == null; ++attempt) {
                    if (attempt >= 0) {
                        filename = htmlTemplatePrefix.elementAt(attempt);
                        filename = filename + basename;
                    }
                    try {
                        f = new FileInputStream(filename);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (f != null && !filename.endsWith(".htm") && filename.endsWith(".html")) continue;
                }
                if (f == null) {
                    this.display("<HTML><HEAD>HTML Template Not Available</HEAD><BODY><H1>HTML Template Not Available</H1><p>The file '" + basename + "' is not available for HTML output.<p></BODY></HTML>", line, column, advance);
                    return false;
                }
                BufferedReader d = new BufferedReader(new InputStreamReader(f));
                String text = null;
                int index1 = 0;
                int index2 = 0;
                do {
                    index1 = -1;
                    text = d.readLine();
                    do {
                        Variable found;
                        if ((index1 = text.indexOf("%%", index1 + 1)) < 0) continue;
                        index2 = text.indexOf("%%", index1 + 1);
                        if (index2 < 0) {
                            index1 = -1;
                        }
                        if (index2 < 0) continue;
                        String subst = text.substring(index1 + 2, index2);
                        int style = 0;
                        if (subst.startsWith("!s ") || subst.startsWith("!S ")) {
                            style = 1;
                            subst = subst.substring(3);
                        } else if (subst.startsWith("!t ") || subst.startsWith("!T ")) {
                            style = 2;
                            subst = subst.substring(3);
                        }
                        String left = "";
                        String right = "";
                        try {
                            left = text.substring(0, index1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            right = text.substring(index2 + 2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!foundIdentifiers) {
                            foundIdentifiers = true;
                            this.fillInIdentifiers(v, identifiers);
                        }
                        if ((found = (Variable)identifiers.get(subst)) != null) {
                            subst = found.toDisplayString();
                            if (style == 1) {
                                int i;
                                int len = subst.length();
                                for (i = len - 1; i >= 0 && subst.charAt(i) == ' '; --i) {
                                }
                                if (i < 0) {
                                    subst = "";
                                } else if (i < len - 1) {
                                    subst = subst.substring(0, i + 1);
                                }
                            } else if (style == 2) {
                                subst = subst.trim();
                            }
                            text = left + subst + right;
                            continue;
                        }
                        index1 += 2;
                    } while (index1 >= 0);
                    if (text == null) continue;
                    this.display(text, line, column, advance);
                } while (text != null);
                d.close();
                f.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void fillInIdentifiers(Variable v, Hashtable<String, Variable> identifiers) {
        Variable child = null;
        while (v != null) {
            if (v.isIdentified()) {
                identifiers.put(v.getIdentifier(), v);
            }
            if ((child = v.getChild()) != null) {
                this.fillInIdentifiers(child, identifiers);
            }
            v = v.getSibling();
        }
    }

    private char hex(byte[] s, int offset) {
        byte d1 = s[++offset];
        byte d2 = s[offset + 1];
        int value = 0;
        if (d1 >= 48 && d1 <= 57) {
            value = d1 - 48;
        } else if (d1 >= 97 && d1 <= 102) {
            value = d1 - 97 + 10;
        } else if (d1 >= 65 && d1 <= 70) {
            value = d1 - 65 + 10;
        }
        value *= 16;
        if (d2 >= 48 && d2 <= 57) {
            value |= d2 - 48;
        } else if (d2 >= 97 && d2 <= 102) {
            value |= d2 - 97 + 10;
        } else if (d2 >= 65 && d2 <= 70) {
            value |= d2 - 65 + 10;
        }
        return (char)value;
    }

    private void parseCGI(String s, Hashtable<String, Variable> identifiers) {
        int length = s.length();
        byte[] content = new byte[length];
        for (int i = 0; i < length; ++i) {
            content[i] = (byte)(s.charAt(i) & 0xFF);
        }
        this.parseCGI(content, identifiers);
    }

    private void parseCGI(byte[] s, Hashtable<String, Variable> identifiers) {
        int length = s.length;
        for (int i = 0; i < length; ++i) {
            if (s[i] != 43) continue;
            s[i] = 32;
        }
        int lastPosition = 0;
        int firstEquals = -1;
        for (int i = 0; i < length; ++i) {
            if (firstEquals < 0 && s[i] == 61) {
                firstEquals = i;
            }
            boolean split = false;
            if (s[i] == 38) {
                split = true;
            } else if (i == length - 1) {
                split = true;
                ++i;
            }
            if (!split) continue;
            if (firstEquals >= 0) {
                int j;
                StringBuffer parameter = new StringBuffer();
                StringBuffer value = new StringBuffer();
                for (j = lastPosition; j < firstEquals; ++j) {
                    if (s[j] != 37) {
                        parameter.append((char)(s[j] & 0xFF));
                        continue;
                    }
                    parameter.append(this.hex(s, j));
                    j += 2;
                }
                for (j = firstEquals + 1; j < i; ++j) {
                    if (s[j] != 37) {
                        value.append((char)(s[j] & 0xFF));
                        continue;
                    }
                    value.append(this.hex(s, j));
                    j += 2;
                }
                String parameterString = parameter.toString();
                String valueString = value.toString();
                Variable modify = identifiers.get(parameterString);
                if (modify != null) {
                    modify.move(valueString);
                }
            }
            lastPosition = i + 1;
            firstEquals = -1;
        }
    }

    protected boolean acceptExternalForm(Variable v, float line, float column) {
        block12: {
            ScreenHandler Term = this.getScreenHandler();
            try {
                String REQUEST_METHOD = RuntimeEnvironment.getGlobalParameter("REQUEST_METHOD");
                if ("GET".equalsIgnoreCase(REQUEST_METHOD)) {
                    String QUERY_STRING = RuntimeEnvironment.getGlobalParameter("QUERY_STRING");
                    if (QUERY_STRING != null) {
                        Hashtable<String, Variable> identifiers = new Hashtable<String, Variable>();
                        this.fillInIdentifiers(v, identifiers);
                        this.parseCGI(QUERY_STRING, identifiers);
                    }
                    break block12;
                }
                if ("POST".equalsIgnoreCase(REQUEST_METHOD)) {
                    int content_length;
                    String CONTENT_LENGTH;
                    byte[] content = null;
                    Hashtable<String, Variable> identifiers = new Hashtable<String, Variable>();
                    this.fillInIdentifiers(v, identifiers);
                    String QUERY_STRING = RuntimeEnvironment.getGlobalParameter("QUERY_STRING");
                    if (QUERY_STRING != null) {
                        this.parseCGI(QUERY_STRING, identifiers);
                    }
                    if ((CONTENT_LENGTH = RuntimeEnvironment.getGlobalParameter("CONTENT_LENGTH")) == null || (content_length = Integer.parseInt(CONTENT_LENGTH.trim())) <= 0) break block12;
                    content = new byte[content_length];
                    try {
                        int content_read = System.in.read(content, 0, content_length);
                        if (content_read == content_length) {
                            this.parseCGI(content, identifiers);
                        }
                        break block12;
                    }
                    catch (Exception exception) {}
                    break block12;
                }
                String TOString = null;
                try {
                    TOString = Term.getString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (TOString != null) {
                    v.moveNational(TOString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private synchronized boolean display(Handle h, float line, float column, boolean advance, ScreenProperty p) {
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return false;
        }
        Handle windowHandle = this.getIOHandle();
        if (windowHandle != h) {
            h.setWindow(windowHandle);
            h.show();
        }
        if (p != null) {
            p.setProperties(Term.getAttributes());
            p.applyHandleProperties();
        }
        return this.display(h, line + 1.0f, column + 1.0f, false, false, advance);
    }

    @Override
    public synchronized boolean display(Handle h) {
        return this.display(h, -1.0f, -1.0f, false, false, true);
    }

    @Override
    public synchronized boolean display(Handle h, float line, float column) {
        return this.display(h, line, column, false, false, true);
    }

    private synchronized boolean display(Handle h, float line, float column, boolean columnIsPixels, boolean lineIsPixels) {
        return this.display(h, line, column, columnIsPixels, lineIsPixels, true);
    }

    private synchronized boolean display(Handle h, float line, float column, boolean columnIsPixels, boolean lineIsPixels, boolean advance) {
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return false;
        }
        try {
            Handle windowHandle = this.getIOHandle();
            if (windowHandle != h) {
                double provisionalTermColumn;
                double columnsOccupied;
                double termColumn;
                TermComponent t = h.getTermComponent();
                if (t == null) {
                    windowHandle.add(h, column, line, columnIsPixels, lineIsPixels);
                    return true;
                }
                double termLine = (double)line >= 0.0 ? (double)line - 1.0 : (double)line;
                double d = termColumn = (double)column >= 0.0 ? (double)column - 1.0 : (double)column;
                if (termLine < 0.0 || lineIsPixels) {
                    termLine = t.getLine();
                    double d2 = termLine = termLine >= 0.0 ? termLine - 1.0 : termLine;
                }
                if (termColumn < 0.0 || columnIsPixels) {
                    termColumn = t.getColumn();
                    double d3 = termColumn = termColumn >= 0.0 ? termColumn - 1.0 : termColumn;
                }
                if (termColumn < 0.0) {
                    termColumn = Term.getCursorX();
                }
                if (termLine < 0.0) {
                    termLine = Term.getCursorY();
                }
                if ((double)column < 0.0 && !columnIsPixels) {
                    column = (float)(termColumn + 1.0);
                }
                if ((double)line < 0.0 && !lineIsPixels) {
                    line = (float)(termLine + 1.0);
                }
                if ((columnsOccupied = t.getColumnsCells()) <= 0.0) {
                    columnsOccupied = 1.0;
                }
                if ((provisionalTermColumn = termColumn + columnsOccupied) <= (double)Term.getColumns()) {
                    termColumn = provisionalTermColumn;
                }
                windowHandle.add(h, column, line, columnIsPixels, lineIsPixels);
                if (!h.isSpecialDisplay()) {
                    Term.move((int)termLine, (int)termColumn);
                }
            } else {
                windowHandle.display();
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public synchronized boolean display(Handle h, float line, float column, ScreenProperty p) {
        if (h == null) {
            return false;
        }
        ScreenHandler Term = this.getScreenHandler(this.hasGUI, this.title, this.gosyserr, this.gosysout);
        if (Term == null) {
            return false;
        }
        if (!this.updateTermForDisplay(line, column, p)) {
            return false;
        }
        if (this.display(h, this.cury, this.curx, false, p)) {
            Term.refresh();
            return true;
        }
        return false;
    }

    class inputField {
        public Variable v;
        public int cx;
        public int cy;
        public int attr;
        public int fg;
        public int bg;
        public boolean secure;
        public boolean auto;
        public boolean full;
        public boolean req;
        public char promptChar;
        public String defaultString;
        public int size = 0;
        public String textString = "";
        public boolean activeField = false;
        public Variable from = null;
        public Variable to = null;

        public inputField(Variable v, int cx, int cy, int attr, int fg, int bg, boolean secure, boolean auto, boolean full, boolean req, char promptChar, String defaultString, int occursIndex1, int occursIndex2) {
            this.v = v;
            this.cx = cx;
            this.cy = cy;
            this.attr = attr;
            this.fg = fg;
            this.bg = bg;
            this.secure = secure;
            this.auto = auto;
            this.full = full;
            this.req = req;
            this.promptChar = promptChar;
            this.defaultString = defaultString;
            if (v != null) {
                this.textString = v.toNationalString();
                this.size = v.lengthNational();
            }
            this.from = XOpenScreen.this.getFromVariable(v);
            this.to = XOpenScreen.this.getToVariable(v);
            if (this.from != null && occursIndex2 > 0) {
                this.from = occursIndex1 > 0 ? this.from.subscript(occursIndex1, occursIndex2) : this.from.subscript(occursIndex2);
                if (XOpenScreen.this.acceptSubscripts == null) {
                    XOpenScreen.this.acceptSubscripts = new Vector();
                }
                XOpenScreen.this.acceptSubscripts.addElement(this.from);
            }
            if (this.to != null && occursIndex2 > 0) {
                this.to = occursIndex1 > 0 ? this.to.subscript(occursIndex1, occursIndex2) : this.to.subscript(occursIndex2);
                if (XOpenScreen.this.acceptSubscripts == null) {
                    XOpenScreen.this.acceptSubscripts = new Vector();
                }
                XOpenScreen.this.acceptSubscripts.addElement(this.to);
            }
        }

        public Variable getFromVariable() {
            return this.from;
        }

        public Variable getToVariable() {
            return this.to;
        }

        public Handle getHandle() {
            if (this.v != null) {
                return this.v.getHandle();
            }
            return null;
        }

        public boolean isActiveField() {
            return this.activeField;
        }

        public void setActiveField(boolean flag) {
            this.activeField = flag;
        }

        public void refresh() {
            if (this.v != null) {
                int s = this.v.lengthNational();
                this.textString = s == this.size ? this.v.toNationalString() : this.v.toNationalString(this.size);
            }
        }

        public void setSize(int s) {
            if (s != this.size) {
                if (this.size > 0 && this.v != null) {
                    this.textString = this.v.toNationalString(s);
                }
                this.size = s;
            }
        }

        public int getSize() {
            Handle h = this.getHandle();
            if (h != null) {
                TermComponent t = h.getTermComponent();
                if (t != null) {
                    double columnsOccupied = t.getColumnsCells();
                    if (columnsOccupied <= 0.0) {
                        columnsOccupied = 1.0;
                    }
                    return (int)columnsOccupied;
                }
                return 0;
            }
            return this.size;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public char promptChar() {
            return this.promptChar;
        }

        public String defaultString() {
            return this.defaultString;
        }

        public String getString() {
            return this.textString;
        }

        public boolean contains(int sx, int sy) {
            if (this.cy != sy) {
                return false;
            }
            return sx >= this.cx && sx <= this.cx + (this.getSize() - 1);
        }
    }

    class fvalue {
        public float value;

        public fvalue(float value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

