/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.IO;

public class console
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean open;
    private boolean alreadyOpen = true;
    private IO consolehandle;

    public static final String getProtocol() {
        return "console";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        String myfile = "CONSOLE";
        if (filename != null && !filename.trim().equals("")) {
            myfile = myfile + ":" + filename;
        } else {
            filename = "";
        }
        this.filename = filename;
        if (IO.isOpen(myfile)) {
            this.open = true;
            this.consolehandle = IO.allocateIO(myfile);
        }
        return true;
    }

    @Override
    public void setLineSequential(boolean state) {
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        this.consolehandle.write(data, offset, length);
        return 0;
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        if (this.consolehandle != null) {
            int i;
            String result = this.consolehandle.accept(length);
            for (i = 0; i < result.length(); ++i) {
                data[offset + i] = (byte)result.charAt(i);
            }
            for (i = result.length(); i < length; ++i) {
                data[offset + i] = 32;
            }
            return result.length();
        }
        return -30;
    }

    @Override
    public final int close(int mode) {
        if (!this.alreadyOpen) {
            IO.deallocateIO("CONSOLE:" + this.filename);
            this.consolehandle = null;
            this.open = false;
        }
        return 0;
    }

    @Override
    public final int open(int mode) {
        String myfile = "CONSOLE";
        if (this.filename != null && !this.filename.trim().equals("")) {
            myfile = myfile + ":" + this.filename;
        }
        if (IO.isOpen(myfile)) {
            this.consolehandle = IO.allocateIO(myfile);
            this.alreadyOpen = true;
            this.open = true;
        }
        if (this.open) {
            return -41;
        }
        try {
            this.consolehandle = IO.allocateIO(myfile);
            this.alreadyOpen = false;
            this.open = true;
        }
        catch (Exception e) {
            return -30;
        }
        return 0;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.consolehandle;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
    }
}

