/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class ims
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean open;
    private Socket ims;
    private int port = 9999;
    private DataInputStream is;
    private DataOutputStream os;

    public static final String getProtocol() {
        return "ims";
    }

    private final String parseFilename(String filename) {
        int colon;
        if (filename == null) {
            filename = "";
        }
        if ((filename = filename.trim()).startsWith("//")) {
            filename = filename.substring(2);
        }
        if (filename.toUpperCase().startsWith("ims:")) {
            filename = filename.substring(4);
        }
        if ((colon = filename.indexOf(58)) >= 0) {
            try {
                this.port = ConvertData.parseInt(filename.substring(colon + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            filename = filename.substring(0, colon);
        }
        return filename;
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        this.readable = true;
        this.writable = true;
        this.filename = this.parseFilename(filename);
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        try {
            this.os.write(data, offset, length);
            return 0;
        }
        catch (IOException e) {
            return -30;
        }
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        int bytesRead = 0;
        try {
            int byte_zero = this.is.readByte() & 0xFF;
            int byte_one = this.is.readByte() & 0xFF;
            int seg_lth = byte_zero * 256 + byte_one;
            byte[] seg_data = new byte[seg_lth - 2];
            bytesRead = this.is.read(seg_data, 0, seg_lth - 2);
            if (bytesRead <= 0) {
                return -10;
            }
            data[offset + 0] = (byte)byte_zero;
            data[offset + 1] = (byte)byte_one;
            System.arraycopy(seg_data, 0, data, offset + 2, Math.min(seg_data.length, data.length));
            for (int zc = seg_lth; zc < length; ++zc) {
                data[zc] = Variable.SPACE_BYTE;
            }
            return bytesRead + 2;
        }
        catch (Exception e) {
            return -10;
        }
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        if (this.ims != null) {
            try {
                this.ims.close();
                this.ims = null;
            }
            catch (Exception e) {
                this.ims = null;
                return -30;
            }
        }
        this.is = null;
        this.os = null;
        return 0;
    }

    @Override
    public final int open(int mode) {
        this.filename = this.parseFilename(this.filename);
        try {
            this.ims = new Socket(this.filename, this.port);
            this.is = new DataInputStream(this.ims.getInputStream());
            this.os = new DataOutputStream(this.ims.getOutputStream());
            this.open = true;
            return 0;
        }
        catch (IOException e) {
            return -30;
        }
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.ims;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

