/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.api.IGenericPrinter;
import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.print.PrinterControl;

public class printer
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean open;
    private IGenericPrinter cobolPrinter;

    public static final String getProtocol() {
        return "printer";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        this.filename = filename;
        this.readable = false;
        this.writable = true;
        lineSequential = true;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        this.cobolPrinter.write(new String(data, offset, length));
        return 0;
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        return -30;
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        PrinterControl.closePrinter(this.cobolPrinter);
        return 0;
    }

    @Override
    public final int open(int mode) {
        if (this.open) {
            return -41;
        }
        if (this.filename == null) {
            this.filename = "";
        }
        String driverName = this.filename;
        String driverNameUpperCase = (driverName = driverName.trim()).toUpperCase();
        int index = driverNameUpperCase.indexOf("DRIVER=");
        if (index < 0) {
            index = driverNameUpperCase.indexOf("DEVICE=");
        }
        if (index >= 0) {
            this.filename = index > 0 ? driverName.substring(0, index) : "";
            if ((index = (driverName = driverName.substring(index + 7)).indexOf(47)) >= 0) {
                try {
                    this.filename = this.filename + driverName.substring(index + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                driverName = driverName.substring(0, index);
            } else {
                index = driverName.indexOf(58);
                if (index >= 0) {
                    try {
                        this.filename = this.filename + driverName.substring(index + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    driverName = driverName.substring(0, index);
                } else {
                    index = driverName.indexOf(59);
                    if (index >= 0) {
                        try {
                            this.filename = this.filename + driverName.substring(index + 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        driverName = driverName.substring(0, index);
                    }
                }
            }
        } else {
            driverName = null;
        }
        this.cobolPrinter = PrinterControl.getPrinter(driverName);
        if (this.cobolPrinter != null && this.cobolPrinter.open(PrinterControl.isPrinterDialogEnabled(), PrinterControl.isPrinterOpenRawMode(), this.filename)) {
            this.open = true;
            return 0;
        }
        return -35;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final boolean isStream() {
        return false;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.cobolPrinter;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
    }
}

